// services/network/public/mojom/service_worker_router_info.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/network/public/mojom/service_worker_router_info.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/service_worker_router_info.mojom-params-data.h"
namespace network {
namespace mojom {

NOINLINE static const char* ServiceWorkerRouterSourceTypeToStringHelper(ServiceWorkerRouterSourceType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ServiceWorkerRouterSourceType::kNetwork:
      return "kNetwork";
    case ServiceWorkerRouterSourceType::kRace:
      return "kRace";
    case ServiceWorkerRouterSourceType::kFetchEvent:
      return "kFetchEvent";
    case ServiceWorkerRouterSourceType::kCache:
      return "kCache";
    default:
      return nullptr;
  }
}

std::string ServiceWorkerRouterSourceTypeToString(ServiceWorkerRouterSourceType value) {
  const char *str = ServiceWorkerRouterSourceTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ServiceWorkerRouterSourceType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ServiceWorkerRouterSourceType value) {
  return os << ServiceWorkerRouterSourceTypeToString(value);
}

NOINLINE static const char* ServiceWorkerStatusToStringHelper(ServiceWorkerStatus value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ServiceWorkerStatus::kRunning:
      return "kRunning";
    case ServiceWorkerStatus::kStarting:
      return "kStarting";
    case ServiceWorkerStatus::kStopping:
      return "kStopping";
    case ServiceWorkerStatus::kStopped:
      return "kStopped";
    case ServiceWorkerStatus::kWarmingUp:
      return "kWarmingUp";
    case ServiceWorkerStatus::kWarmedUp:
      return "kWarmedUp";
    default:
      return nullptr;
  }
}

std::string ServiceWorkerStatusToString(ServiceWorkerStatus value) {
  const char *str = ServiceWorkerStatusToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ServiceWorkerStatus value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ServiceWorkerStatus value) {
  return os << ServiceWorkerStatusToString(value);
}

namespace internal {


// static
bool ServiceWorkerRouterInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ServiceWorkerRouterInfo_Data* object =
      static_cast<const ServiceWorkerRouterInfo_Data*>(data);


  if (!::network::mojom::internal::ServiceWorkerRouterSourceType_Data
        ::Validate(object->matched_source_type_$value, validation_context))
    return false;


  if (!::network::mojom::internal::ServiceWorkerRouterSourceType_Data
        ::Validate(object->actual_source_type_$value, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->router_evaluation_time, 8, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->router_evaluation_time, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cache_lookup_time, 9, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->cache_lookup_time, validation_context))
    return false;


  if (!::network::mojom::internal::ServiceWorkerStatus_Data
        ::Validate(object->evaluation_worker_status_$value, validation_context))
    return false;

  return true;
}

ServiceWorkerRouterInfo_Data::ServiceWorkerRouterInfo_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace network

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::ServiceWorkerRouterSourceType>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::ServiceWorkerRouterSourceType value) {
  return std::move(context).WriteString(::network::mojom::ServiceWorkerRouterSourceTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::ServiceWorkerStatus>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::ServiceWorkerStatus value) {
  return std::move(context).WriteString(::network::mojom::ServiceWorkerStatusToString(value));
}

} // namespace perfetto