// services/network/public/mojom/key_pinning.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_KEY_PINNING_MOJOM_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_KEY_PINNING_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/key_pinning.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/key_pinning.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/key_pinning.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>








namespace network::mojom {






class  PinSetInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PinSetInfo, T>::value>;
  using DataView = PinSetInfoDataView;
  using Data_ = internal::PinSetInfo_Data;

  template <typename... Args>
  static PinSetInfoPtr New(Args&&... args) {
    return PinSetInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PinSetInfoPtr From(const U& u) {
    return mojo::TypeConverter<PinSetInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PinSetInfo>::Convert(*this);
  }


  PinSetInfo();

  PinSetInfo(
      const std::string& hostname,
      const std::string& pinset_name,
      bool include_subdomains);


  ~PinSetInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PinSetInfoPtr>
  PinSetInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PinSetInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PinSetInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PinSetInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PinSetInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PinSetInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PinSetInfo_UnserializedMessageContext<
            UserType, PinSetInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PinSetInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PinSetInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PinSetInfo_UnserializedMessageContext<
            UserType, PinSetInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PinSetInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string hostname;
  
  std::string pinset_name;
  
  bool include_subdomains;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PinSetInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PinSetInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PinSetInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PinSetInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}








class  PinSet {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PinSet, T>::value>;
  using DataView = PinSetDataView;
  using Data_ = internal::PinSet_Data;

  template <typename... Args>
  static PinSetPtr New(Args&&... args) {
    return PinSetPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PinSetPtr From(const U& u) {
    return mojo::TypeConverter<PinSetPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PinSet>::Convert(*this);
  }


  PinSet();

  PinSet(
      const std::string& name,
      std::vector<std::vector<uint8_t>> static_spki_hashes,
      std::vector<std::vector<uint8_t>> bad_static_spki_hashes,
      const std::string& report_uri);


  ~PinSet();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PinSetPtr>
  PinSetPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PinSet::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PinSet::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PinSet::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PinSet::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PinSet::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PinSet_UnserializedMessageContext<
            UserType, PinSet::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PinSet::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PinSet::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PinSet_UnserializedMessageContext<
            UserType, PinSet::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PinSet::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string name;
  
  std::vector<std::vector<uint8_t>> static_spki_hashes;
  
  std::vector<std::vector<uint8_t>> bad_static_spki_hashes;
  
  std::string report_uri;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PinSet::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PinSet::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PinSet::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PinSet::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  PinList {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PinList, T>::value>;
  using DataView = PinListDataView;
  using Data_ = internal::PinList_Data;

  template <typename... Args>
  static PinListPtr New(Args&&... args) {
    return PinListPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PinListPtr From(const U& u) {
    return mojo::TypeConverter<PinListPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PinList>::Convert(*this);
  }


  PinList();

  PinList(
      std::vector<PinSetPtr> pinsets,
      std::vector<PinSetInfoPtr> host_pins);

PinList(const PinList&) = delete;
PinList& operator=(const PinList&) = delete;

  ~PinList();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PinListPtr>
  PinListPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PinList::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PinList::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PinList::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PinList::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PinList::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PinList_UnserializedMessageContext<
            UserType, PinList::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PinList::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PinList::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PinList_UnserializedMessageContext<
            UserType, PinList::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PinList::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<PinSetPtr> pinsets;
  
  std::vector<PinSetInfoPtr> host_pins;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PinList::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PinList::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PinList::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PinList::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
PinSetPtr PinSet::Clone() const {
  return New(
      mojo::Clone(name),
      mojo::Clone(static_spki_hashes),
      mojo::Clone(bad_static_spki_hashes),
      mojo::Clone(report_uri)
  );
}

template <typename T, PinSet::EnableIfSame<T>*>
bool PinSet::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->static_spki_hashes, other_struct.static_spki_hashes))
    return false;
  if (!mojo::Equals(this->bad_static_spki_hashes, other_struct.bad_static_spki_hashes))
    return false;
  if (!mojo::Equals(this->report_uri, other_struct.report_uri))
    return false;
  return true;
}

template <typename T, PinSet::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.static_spki_hashes < rhs.static_spki_hashes)
    return true;
  if (rhs.static_spki_hashes < lhs.static_spki_hashes)
    return false;
  if (lhs.bad_static_spki_hashes < rhs.bad_static_spki_hashes)
    return true;
  if (rhs.bad_static_spki_hashes < lhs.bad_static_spki_hashes)
    return false;
  if (lhs.report_uri < rhs.report_uri)
    return true;
  if (rhs.report_uri < lhs.report_uri)
    return false;
  return false;
}
template <typename StructPtrType>
PinSetInfoPtr PinSetInfo::Clone() const {
  return New(
      mojo::Clone(hostname),
      mojo::Clone(pinset_name),
      mojo::Clone(include_subdomains)
  );
}

template <typename T, PinSetInfo::EnableIfSame<T>*>
bool PinSetInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->hostname, other_struct.hostname))
    return false;
  if (!mojo::Equals(this->pinset_name, other_struct.pinset_name))
    return false;
  if (!mojo::Equals(this->include_subdomains, other_struct.include_subdomains))
    return false;
  return true;
}

template <typename T, PinSetInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.hostname < rhs.hostname)
    return true;
  if (rhs.hostname < lhs.hostname)
    return false;
  if (lhs.pinset_name < rhs.pinset_name)
    return true;
  if (rhs.pinset_name < lhs.pinset_name)
    return false;
  if (lhs.include_subdomains < rhs.include_subdomains)
    return true;
  if (rhs.include_subdomains < lhs.include_subdomains)
    return false;
  return false;
}
template <typename StructPtrType>
PinListPtr PinList::Clone() const {
  return New(
      mojo::Clone(pinsets),
      mojo::Clone(host_pins)
  );
}

template <typename T, PinList::EnableIfSame<T>*>
bool PinList::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->pinsets, other_struct.pinsets))
    return false;
  if (!mojo::Equals(this->host_pins, other_struct.host_pins))
    return false;
  return true;
}

template <typename T, PinList::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.pinsets < rhs.pinsets)
    return true;
  if (rhs.pinsets < lhs.pinsets)
    return false;
  if (lhs.host_pins < rhs.host_pins)
    return true;
  if (rhs.host_pins < lhs.host_pins)
    return false;
  return false;
}


}  // network::mojom

namespace mojo {


template <>
struct  StructTraits<::network::mojom::PinSet::DataView,
                                         ::network::mojom::PinSetPtr> {
  static bool IsNull(const ::network::mojom::PinSetPtr& input) { return !input; }
  static void SetToNull(::network::mojom::PinSetPtr* output) { output->reset(); }

  static const decltype(::network::mojom::PinSet::name)& name(
      const ::network::mojom::PinSetPtr& input) {
    return input->name;
  }

  static const decltype(::network::mojom::PinSet::static_spki_hashes)& static_spki_hashes(
      const ::network::mojom::PinSetPtr& input) {
    return input->static_spki_hashes;
  }

  static const decltype(::network::mojom::PinSet::bad_static_spki_hashes)& bad_static_spki_hashes(
      const ::network::mojom::PinSetPtr& input) {
    return input->bad_static_spki_hashes;
  }

  static const decltype(::network::mojom::PinSet::report_uri)& report_uri(
      const ::network::mojom::PinSetPtr& input) {
    return input->report_uri;
  }

  static bool Read(::network::mojom::PinSet::DataView input, ::network::mojom::PinSetPtr* output);
};


template <>
struct  StructTraits<::network::mojom::PinSetInfo::DataView,
                                         ::network::mojom::PinSetInfoPtr> {
  static bool IsNull(const ::network::mojom::PinSetInfoPtr& input) { return !input; }
  static void SetToNull(::network::mojom::PinSetInfoPtr* output) { output->reset(); }

  static const decltype(::network::mojom::PinSetInfo::hostname)& hostname(
      const ::network::mojom::PinSetInfoPtr& input) {
    return input->hostname;
  }

  static const decltype(::network::mojom::PinSetInfo::pinset_name)& pinset_name(
      const ::network::mojom::PinSetInfoPtr& input) {
    return input->pinset_name;
  }

  static decltype(::network::mojom::PinSetInfo::include_subdomains) include_subdomains(
      const ::network::mojom::PinSetInfoPtr& input) {
    return input->include_subdomains;
  }

  static bool Read(::network::mojom::PinSetInfo::DataView input, ::network::mojom::PinSetInfoPtr* output);
};


template <>
struct  StructTraits<::network::mojom::PinList::DataView,
                                         ::network::mojom::PinListPtr> {
  static bool IsNull(const ::network::mojom::PinListPtr& input) { return !input; }
  static void SetToNull(::network::mojom::PinListPtr* output) { output->reset(); }

  static const decltype(::network::mojom::PinList::pinsets)& pinsets(
      const ::network::mojom::PinListPtr& input) {
    return input->pinsets;
  }

  static const decltype(::network::mojom::PinList::host_pins)& host_pins(
      const ::network::mojom::PinListPtr& input) {
    return input->host_pins;
  }

  static bool Read(::network::mojom::PinList::DataView input, ::network::mojom::PinListPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_KEY_PINNING_MOJOM_H_