// services/network/public/mojom/cookie_setting_overrides.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_COOKIE_SETTING_OVERRIDES_MOJOM_BLINK_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_COOKIE_SETTING_OVERRIDES_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/cookie_setting_overrides.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/cookie_setting_overrides.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/cookie_setting_overrides.mojom-blink-forward.h"  // IWYU pragma: export

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace network::mojom::blink {





class BLINK_PLATFORM_EXPORT CookieSettingOverrides {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CookieSettingOverrides, T>::value>;
  using DataView = CookieSettingOverridesDataView;
  using Data_ = internal::CookieSettingOverrides_Data;

  template <typename... Args>
  static CookieSettingOverridesPtr New(Args&&... args) {
    return CookieSettingOverridesPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CookieSettingOverridesPtr From(const U& u) {
    return mojo::TypeConverter<CookieSettingOverridesPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CookieSettingOverrides>::Convert(*this);
  }


  CookieSettingOverrides();

  explicit CookieSettingOverrides(
      uint64_t overrides_bitmask);


  ~CookieSettingOverrides();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CookieSettingOverridesPtr>
  CookieSettingOverridesPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CookieSettingOverrides::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CookieSettingOverrides::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CookieSettingOverrides::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CookieSettingOverrides::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CookieSettingOverrides::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CookieSettingOverrides_UnserializedMessageContext<
            UserType, CookieSettingOverrides::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CookieSettingOverrides::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CookieSettingOverrides::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CookieSettingOverrides_UnserializedMessageContext<
            UserType, CookieSettingOverrides::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CookieSettingOverrides::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint64_t overrides_bitmask;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CookieSettingOverrides::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CookieSettingOverrides::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CookieSettingOverrides::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CookieSettingOverrides::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}




template <typename StructPtrType>
CookieSettingOverridesPtr CookieSettingOverrides::Clone() const {
  return New(
      mojo::Clone(overrides_bitmask)
  );
}

template <typename T, CookieSettingOverrides::EnableIfSame<T>*>
bool CookieSettingOverrides::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->overrides_bitmask, other_struct.overrides_bitmask))
    return false;
  return true;
}

template <typename T, CookieSettingOverrides::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.overrides_bitmask < rhs.overrides_bitmask)
    return true;
  if (rhs.overrides_bitmask < lhs.overrides_bitmask)
    return false;
  return false;
}


}  // network::mojom::blink

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::CookieSettingOverrides::DataView,
                                         ::network::mojom::blink::CookieSettingOverridesPtr> {
  static bool IsNull(const ::network::mojom::blink::CookieSettingOverridesPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::CookieSettingOverridesPtr* output) { output->reset(); }

  static decltype(::network::mojom::blink::CookieSettingOverrides::overrides_bitmask) overrides_bitmask(
      const ::network::mojom::blink::CookieSettingOverridesPtr& input) {
    return input->overrides_bitmask;
  }

  static bool Read(::network::mojom::blink::CookieSettingOverrides::DataView input, ::network::mojom::blink::CookieSettingOverridesPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_COOKIE_SETTING_OVERRIDES_MOJOM_BLINK_H_