// services/network/public/mojom/clear_data_filter.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/network/public/mojom/clear_data_filter.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/clear_data_filter.mojom-params-data.h"
namespace network {
namespace mojom {

NOINLINE static const char* ClearDataFilter_TypeToStringHelper(ClearDataFilter_Type value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ClearDataFilter_Type::DELETE_MATCHES:
      return "DELETE_MATCHES";
    case ClearDataFilter_Type::KEEP_MATCHES:
      return "KEEP_MATCHES";
    default:
      return nullptr;
  }
}

std::string ClearDataFilter_TypeToString(ClearDataFilter_Type value) {
  const char *str = ClearDataFilter_TypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ClearDataFilter_Type value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ClearDataFilter_Type value) {
  return os << ClearDataFilter_TypeToString(value);
}

namespace internal {


// static
bool ClearDataFilter_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ClearDataFilter_Data* object =
      static_cast<const ClearDataFilter_Data*>(data);


  if (!::network::mojom::internal::ClearDataFilter_Type_Data
        ::Validate(object->type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->domains, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& domains_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->domains, validation_context,
                                         &domains_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->origins, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& origins_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->origins, validation_context,
                                         &origins_validate_params)) {
    return false;
  }

  return true;
}

ClearDataFilter_Data::ClearDataFilter_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace network

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::ClearDataFilter_Type>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::ClearDataFilter_Type value) {
  return std::move(context).WriteString(::network::mojom::ClearDataFilter_TypeToString(value));
}

} // namespace perfetto