// services/network/public/mojom/accept_ch_frame_observer.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_ACCEPT_CH_FRAME_OBSERVER_MOJOM_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_ACCEPT_CH_FRAME_OBSERVER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/accept_ch_frame_observer.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/accept_ch_frame_observer.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/accept_ch_frame_observer.mojom-forward.h"  // IWYU pragma: export
#include "services/network/public/mojom/http_request_headers.mojom-forward.h"
#include "services/network/public/mojom/web_client_hints_types.mojom-forward.h"
#include "url/mojom/origin.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace network::mojom {

class AcceptCHFrameObserverProxy;

template <typename ImplRefTraits>
class AcceptCHFrameObserverStub;

class AcceptCHFrameObserverRequestValidator;
class AcceptCHFrameObserverResponseValidator;


class AcceptCHFrameObserver
    : public AcceptCHFrameObserverInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = AcceptCHFrameObserverInterfaceBase;
  using Proxy_ = AcceptCHFrameObserverProxy;

  template <typename ImplRefTraits>
  using Stub_ = AcceptCHFrameObserverStub<ImplRefTraits>;

  using RequestValidator_ = AcceptCHFrameObserverRequestValidator;
  using ResponseValidator_ = AcceptCHFrameObserverResponseValidator;
  enum MethodMinVersions : uint32_t {
    kOnAcceptCHFrameReceivedMinVersion = 0,
    kCloneMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnAcceptCHFrameReceived_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Clone_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~AcceptCHFrameObserver() = default;


  using OnAcceptCHFrameReceivedCallback = base::OnceCallback<void(int32_t)>;
  
  virtual void OnAcceptCHFrameReceived(const ::url::Origin& origin, const std::vector<::network::mojom::WebClientHintsType>& accept_ch_frame, OnAcceptCHFrameReceivedCallback callback) = 0;

  
  virtual void Clone(::mojo::PendingReceiver<AcceptCHFrameObserver> listener) = 0;
};



class  AcceptCHFrameObserverProxy
    : public AcceptCHFrameObserver {
 public:
  using InterfaceType = AcceptCHFrameObserver;

  explicit AcceptCHFrameObserverProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnAcceptCHFrameReceived(const ::url::Origin& origin, const std::vector<::network::mojom::WebClientHintsType>& accept_ch_frame, OnAcceptCHFrameReceivedCallback callback) final;
  
  void Clone(::mojo::PendingReceiver<AcceptCHFrameObserver> listener) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  AcceptCHFrameObserverStubDispatch {
 public:
  static bool Accept(AcceptCHFrameObserver* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      AcceptCHFrameObserver* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<AcceptCHFrameObserver>>
class AcceptCHFrameObserverStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  AcceptCHFrameObserverStub() = default;
  ~AcceptCHFrameObserverStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AcceptCHFrameObserverStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AcceptCHFrameObserverStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  AcceptCHFrameObserverRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  AcceptCHFrameObserverResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // network::mojom

namespace mojo {

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_ACCEPT_CH_FRAME_OBSERVER_MOJOM_H_