// services/device/public/mojom/wake_lock_provider.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_DEVICE_PUBLIC_MOJOM_WAKE_LOCK_PROVIDER_MOJOM_H_
#define SERVICES_DEVICE_PUBLIC_MOJOM_WAKE_LOCK_PROVIDER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/device/public/mojom/wake_lock_provider.mojom-features.h"  // IWYU pragma: export
#include "services/device/public/mojom/wake_lock_provider.mojom-shared.h"  // IWYU pragma: export
#include "services/device/public/mojom/wake_lock_provider.mojom-forward.h"  // IWYU pragma: export
#include "services/device/public/mojom/wake_lock_context.mojom-forward.h"
#include "services/device/public/mojom/wake_lock.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace device::mojom {

class WakeLockProviderProxy;

template <typename ImplRefTraits>
class WakeLockProviderStub;

class WakeLockProviderRequestValidator;
class WakeLockProviderResponseValidator;


class WakeLockProvider
    : public WakeLockProviderInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = WakeLockProviderInterfaceBase;
  using Proxy_ = WakeLockProviderProxy;

  template <typename ImplRefTraits>
  using Stub_ = WakeLockProviderStub<ImplRefTraits>;

  using RequestValidator_ = WakeLockProviderRequestValidator;
  using ResponseValidator_ = WakeLockProviderResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetWakeLockContextForIDMinVersion = 0,
    kGetWakeLockWithoutContextMinVersion = 0,
    kNotifyOnWakeLockDeactivationMinVersion = 0,
    kGetActiveWakeLocksForTestsMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetWakeLockContextForID_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetWakeLockWithoutContext_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct NotifyOnWakeLockDeactivation_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetActiveWakeLocksForTests_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~WakeLockProvider() = default;

  
  virtual void GetWakeLockContextForID(int32_t context_id, ::mojo::PendingReceiver<::device::mojom::WakeLockContext> context) = 0;

  
  virtual void GetWakeLockWithoutContext(::device::mojom::WakeLockType type, ::device::mojom::WakeLockReason reason, const std::string& description, ::mojo::PendingReceiver<::device::mojom::WakeLock> wake_lock) = 0;

  
  virtual void NotifyOnWakeLockDeactivation(::device::mojom::WakeLockType type, ::mojo::PendingRemote<WakeLockObserver> observer) = 0;


  using GetActiveWakeLocksForTestsCallback = base::OnceCallback<void(int32_t)>;
  
  virtual void GetActiveWakeLocksForTests(::device::mojom::WakeLockType type, GetActiveWakeLocksForTestsCallback callback) = 0;
};

class WakeLockObserverProxy;

template <typename ImplRefTraits>
class WakeLockObserverStub;

class WakeLockObserverRequestValidator;


class WakeLockObserver
    : public WakeLockObserverInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = WakeLockObserverInterfaceBase;
  using Proxy_ = WakeLockObserverProxy;

  template <typename ImplRefTraits>
  using Stub_ = WakeLockObserverStub<ImplRefTraits>;

  using RequestValidator_ = WakeLockObserverRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnWakeLockDeactivatedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnWakeLockDeactivated_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~WakeLockObserver() = default;

  
  virtual void OnWakeLockDeactivated(::device::mojom::WakeLockType type) = 0;
};



class  WakeLockProviderProxy
    : public WakeLockProvider {
 public:
  using InterfaceType = WakeLockProvider;

  explicit WakeLockProviderProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetWakeLockContextForID(int32_t context_id, ::mojo::PendingReceiver<::device::mojom::WakeLockContext> context) final;
  
  void GetWakeLockWithoutContext(::device::mojom::WakeLockType type, ::device::mojom::WakeLockReason reason, const std::string& description, ::mojo::PendingReceiver<::device::mojom::WakeLock> wake_lock) final;
  
  void NotifyOnWakeLockDeactivation(::device::mojom::WakeLockType type, ::mojo::PendingRemote<WakeLockObserver> observer) final;
  
  void GetActiveWakeLocksForTests(::device::mojom::WakeLockType type, GetActiveWakeLocksForTestsCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  WakeLockObserverProxy
    : public WakeLockObserver {
 public:
  using InterfaceType = WakeLockObserver;

  explicit WakeLockObserverProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnWakeLockDeactivated(::device::mojom::WakeLockType type) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  WakeLockProviderStubDispatch {
 public:
  static bool Accept(WakeLockProvider* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      WakeLockProvider* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<WakeLockProvider>>
class WakeLockProviderStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  WakeLockProviderStub() = default;
  ~WakeLockProviderStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WakeLockProviderStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WakeLockProviderStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  WakeLockObserverStubDispatch {
 public:
  static bool Accept(WakeLockObserver* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      WakeLockObserver* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<WakeLockObserver>>
class WakeLockObserverStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  WakeLockObserverStub() = default;
  ~WakeLockObserverStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WakeLockObserverStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WakeLockObserverStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  WakeLockProviderRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  WakeLockObserverRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  WakeLockProviderResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // device::mojom

namespace mojo {

}  // namespace mojo

#endif  // SERVICES_DEVICE_PUBLIC_MOJOM_WAKE_LOCK_PROVIDER_MOJOM_H_