// mojo/public/mojom/base/generic_pending_receiver.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MOJO_PUBLIC_MOJOM_BASE_GENERIC_PENDING_RECEIVER_MOJOM_SHARED_H_
#define MOJO_PUBLIC_MOJOM_BASE_GENERIC_PENDING_RECEIVER_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "mojo/public/mojom/base/generic_pending_receiver.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"


#include "base/component_export.h"




namespace mojo_base::mojom {
class GenericPendingReceiverDataView;



}  // mojo_base::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::mojo_base::mojom::GenericPendingReceiverDataView> {
  using Data = ::mojo_base::mojom::internal::GenericPendingReceiver_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace mojo_base::mojom {


class GenericPendingReceiverDataView {
 public:
  GenericPendingReceiverDataView() = default;

  GenericPendingReceiverDataView(
      internal::GenericPendingReceiver_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInterfaceNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInterfaceName(UserType* output) {
    
    auto* pointer = data_->interface_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  mojo::ScopedMessagePipeHandle TakeReceivingPipe() {
    mojo::ScopedMessagePipeHandle result;
    bool ret =
        mojo::internal::Deserialize<mojo::ScopedMessagePipeHandle>(
            &data_->receiving_pipe, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::GenericPendingReceiver_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // mojo_base::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::mojo_base::mojom::GenericPendingReceiverDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::mojo_base::mojom::GenericPendingReceiverDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::mojo_base::mojom::internal::GenericPendingReceiver_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::interface_name(input)) in_interface_name = Traits::interface_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->interface_name)::BaseType> interface_name_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_interface_name, interface_name_fragment);
    fragment->interface_name.Set(
        interface_name_fragment.is_null() ? nullptr : interface_name_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->interface_name.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null interface_name in GenericPendingReceiver struct");
    decltype(Traits::receiving_pipe(input)) in_receiving_pipe = Traits::receiving_pipe(input);
    mojo::internal::Serialize<mojo::ScopedMessagePipeHandle>(
        in_receiving_pipe, &fragment->receiving_pipe, &fragment.message());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid(fragment->receiving_pipe),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid receiving_pipe in GenericPendingReceiver struct");
  }

  static bool Deserialize(::mojo_base::mojom::internal::GenericPendingReceiver_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::mojo_base::mojom::GenericPendingReceiverDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace mojo_base::mojom {

inline void GenericPendingReceiverDataView::GetInterfaceNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->interface_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}



}  // mojo_base::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // MOJO_PUBLIC_MOJOM_BASE_GENERIC_PENDING_RECEIVER_MOJOM_SHARED_H_