// mojo/public/interfaces/bindings/pipe_control_messages.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MOJO_PUBLIC_INTERFACES_BINDINGS_PIPE_CONTROL_MESSAGES_MOJOM_SHARED_H_
#define MOJO_PUBLIC_INTERFACES_BINDINGS_PIPE_CONTROL_MESSAGES_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "mojo/public/interfaces/bindings/pipe_control_messages.mojom-shared-internal.h"



#include "base/component_export.h"




namespace mojo::pipe_control {
class RunOrClosePipeMessageParamsDataView;

class DisconnectReasonDataView;

class PeerAssociatedEndpointClosedEventDataView;

class PauseUntilFlushCompletesDataView;

class FlushAsyncDataView;

class RunOrClosePipeInputDataView;


}  // mojo::pipe_control

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::mojo::pipe_control::RunOrClosePipeMessageParamsDataView> {
  using Data = ::mojo::pipe_control::internal::RunOrClosePipeMessageParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::mojo::pipe_control::DisconnectReasonDataView> {
  using Data = ::mojo::pipe_control::internal::DisconnectReason_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::mojo::pipe_control::PeerAssociatedEndpointClosedEventDataView> {
  using Data = ::mojo::pipe_control::internal::PeerAssociatedEndpointClosedEvent_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::mojo::pipe_control::PauseUntilFlushCompletesDataView> {
  using Data = ::mojo::pipe_control::internal::PauseUntilFlushCompletes_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::mojo::pipe_control::FlushAsyncDataView> {
  using Data = ::mojo::pipe_control::internal::FlushAsync_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::mojo::pipe_control::RunOrClosePipeInputDataView> {
  using Data = ::mojo::pipe_control::internal::RunOrClosePipeInput_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace mojo::pipe_control {


class RunOrClosePipeMessageParamsDataView {
 public:
  RunOrClosePipeMessageParamsDataView() = default;

  RunOrClosePipeMessageParamsDataView(
      internal::RunOrClosePipeMessageParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInputDataView(
      RunOrClosePipeInputDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInput(UserType* output) {
    
    auto* pointer = !data_->input.is_null() ? &data_->input : nullptr;
    return mojo::internal::Deserialize<::mojo::pipe_control::RunOrClosePipeInputDataView>(
        pointer, output, message_);
  }
 private:
  internal::RunOrClosePipeMessageParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DisconnectReasonDataView {
 public:
  DisconnectReasonDataView() = default;

  DisconnectReasonDataView(
      internal::DisconnectReason_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint32_t custom_reason() const {
    return data_->custom_reason;
  }
  inline void GetDescriptionDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDescription(UserType* output) {
    
    auto* pointer = data_->description.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::DisconnectReason_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PeerAssociatedEndpointClosedEventDataView {
 public:
  PeerAssociatedEndpointClosedEventDataView() = default;

  PeerAssociatedEndpointClosedEventDataView(
      internal::PeerAssociatedEndpointClosedEvent_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint32_t id() const {
    return data_->id;
  }
  inline void GetDisconnectReasonDataView(
      DisconnectReasonDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDisconnectReason(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo::pipe_control::DisconnectReasonDataView, UserType>(),
    "Attempting to read the optional `disconnect_reason` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDisconnectReason` instead "
    "of `ReadDisconnectReason if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->disconnect_reason.Get();
    return mojo::internal::Deserialize<::mojo::pipe_control::DisconnectReasonDataView>(
        pointer, output, message_);
  }
 private:
  internal::PeerAssociatedEndpointClosedEvent_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PauseUntilFlushCompletesDataView {
 public:
  PauseUntilFlushCompletesDataView() = default;

  PauseUntilFlushCompletesDataView(
      internal::PauseUntilFlushCompletes_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  mojo::ScopedMessagePipeHandle TakeFlushPipe() {
    mojo::ScopedMessagePipeHandle result;
    bool ret =
        mojo::internal::Deserialize<mojo::ScopedMessagePipeHandle>(
            &data_->flush_pipe, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::PauseUntilFlushCompletes_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FlushAsyncDataView {
 public:
  FlushAsyncDataView() = default;

  FlushAsyncDataView(
      internal::FlushAsync_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  mojo::ScopedMessagePipeHandle TakeFlusherPipe() {
    mojo::ScopedMessagePipeHandle result;
    bool ret =
        mojo::internal::Deserialize<mojo::ScopedMessagePipeHandle>(
            &data_->flusher_pipe, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::FlushAsync_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class RunOrClosePipeInputDataView {
 public:
  using Tag = internal::RunOrClosePipeInput_Data::RunOrClosePipeInput_Tag;

  RunOrClosePipeInputDataView() = default;

  RunOrClosePipeInputDataView(
      internal::RunOrClosePipeInput_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_peer_associated_endpoint_closed_event() const { return data_->tag == Tag::kPeerAssociatedEndpointClosedEvent; }
  inline void GetPeerAssociatedEndpointClosedEventDataView(
      PeerAssociatedEndpointClosedEventDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadPeerAssociatedEndpointClosedEvent(UserType* output) const {
    
    CHECK(is_peer_associated_endpoint_closed_event());
    return mojo::internal::Deserialize<::mojo::pipe_control::PeerAssociatedEndpointClosedEventDataView>(
        data_->data.f_peer_associated_endpoint_closed_event.Get(), output, message_);
  }
  bool is_pause_until_flush_completes() const { return data_->tag == Tag::kPauseUntilFlushCompletes; }
  inline void GetPauseUntilFlushCompletesDataView(
      PauseUntilFlushCompletesDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadPauseUntilFlushCompletes(UserType* output) const {
    
    CHECK(is_pause_until_flush_completes());
    return mojo::internal::Deserialize<::mojo::pipe_control::PauseUntilFlushCompletesDataView>(
        data_->data.f_pause_until_flush_completes.Get(), output, message_);
  }
  bool is_flush_async() const { return data_->tag == Tag::kFlushAsync; }
  inline void GetFlushAsyncDataView(
      FlushAsyncDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadFlushAsync(UserType* output) const {
    
    CHECK(is_flush_async());
    return mojo::internal::Deserialize<::mojo::pipe_control::FlushAsyncDataView>(
        data_->data.f_flush_async.Get(), output, message_);
  }

 private:
  internal::RunOrClosePipeInput_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // mojo::pipe_control

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::mojo::pipe_control::RunOrClosePipeMessageParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::mojo::pipe_control::RunOrClosePipeMessageParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::mojo::pipe_control::internal::RunOrClosePipeMessageParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::input(input)) in_input = Traits::input(input);
    mojo::internal::MessageFragment<decltype(fragment->input)>
        input_fragment(fragment.message());
    input_fragment.Claim(&fragment->input);
    mojo::internal::Serialize<::mojo::pipe_control::RunOrClosePipeInputDataView>(
        in_input, input_fragment, true);
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->input.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null input in RunOrClosePipeMessageParams struct");
  }

  static bool Deserialize(::mojo::pipe_control::internal::RunOrClosePipeMessageParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::mojo::pipe_control::RunOrClosePipeMessageParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::mojo::pipe_control::DisconnectReasonDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::mojo::pipe_control::DisconnectReasonDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::mojo::pipe_control::internal::DisconnectReason_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->custom_reason = Traits::custom_reason(input);
    decltype(Traits::description(input)) in_description = Traits::description(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->description)::BaseType> description_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_description, description_fragment);
    fragment->description.Set(
        description_fragment.is_null() ? nullptr : description_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->description.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null description in DisconnectReason struct");
  }

  static bool Deserialize(::mojo::pipe_control::internal::DisconnectReason_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::mojo::pipe_control::DisconnectReasonDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::mojo::pipe_control::PeerAssociatedEndpointClosedEventDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::mojo::pipe_control::PeerAssociatedEndpointClosedEventDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::mojo::pipe_control::internal::PeerAssociatedEndpointClosedEvent_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->id = Traits::id(input);
    decltype(Traits::disconnect_reason(input)) in_disconnect_reason = Traits::disconnect_reason(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->disconnect_reason)::BaseType> disconnect_reason_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo::pipe_control::DisconnectReasonDataView>(
        in_disconnect_reason, disconnect_reason_fragment);
    fragment->disconnect_reason.Set(
        disconnect_reason_fragment.is_null() ? nullptr : disconnect_reason_fragment.data());
  }

  static bool Deserialize(::mojo::pipe_control::internal::PeerAssociatedEndpointClosedEvent_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::mojo::pipe_control::PeerAssociatedEndpointClosedEventDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::mojo::pipe_control::PauseUntilFlushCompletesDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::mojo::pipe_control::PauseUntilFlushCompletesDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::mojo::pipe_control::internal::PauseUntilFlushCompletes_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::flush_pipe(input)) in_flush_pipe = Traits::flush_pipe(input);
    mojo::internal::Serialize<mojo::ScopedMessagePipeHandle>(
        in_flush_pipe, &fragment->flush_pipe, &fragment.message());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid(fragment->flush_pipe),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid flush_pipe in PauseUntilFlushCompletes struct");
  }

  static bool Deserialize(::mojo::pipe_control::internal::PauseUntilFlushCompletes_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::mojo::pipe_control::PauseUntilFlushCompletesDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::mojo::pipe_control::FlushAsyncDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::mojo::pipe_control::FlushAsyncDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::mojo::pipe_control::internal::FlushAsync_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::flusher_pipe(input)) in_flusher_pipe = Traits::flusher_pipe(input);
    mojo::internal::Serialize<mojo::ScopedMessagePipeHandle>(
        in_flusher_pipe, &fragment->flusher_pipe, &fragment.message());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid(fragment->flusher_pipe),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid flusher_pipe in FlushAsync struct");
  }

  static bool Deserialize(::mojo::pipe_control::internal::FlushAsync_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::mojo::pipe_control::FlushAsyncDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::mojo::pipe_control::RunOrClosePipeInputDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::mojo::pipe_control::RunOrClosePipeInputDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::mojo::pipe_control::internal::RunOrClosePipeInput_Data>& fragment,
                        bool inlined) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

    if (!inlined)
      fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    fragment->size = kUnionDataSize;
    fragment->tag = Traits::GetTag(input);
    switch (fragment->tag) {
      case ::mojo::pipe_control::RunOrClosePipeInputDataView::Tag::kPeerAssociatedEndpointClosedEvent: {
        decltype(Traits::peer_associated_endpoint_closed_event(input))
            in_peer_associated_endpoint_closed_event = Traits::peer_associated_endpoint_closed_event(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_peer_associated_endpoint_closed_event)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::mojo::pipe_control::PeerAssociatedEndpointClosedEventDataView>(
            in_peer_associated_endpoint_closed_event, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null peer_associated_endpoint_closed_event in RunOrClosePipeInput union");
        fragment->data.f_peer_associated_endpoint_closed_event.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
      case ::mojo::pipe_control::RunOrClosePipeInputDataView::Tag::kPauseUntilFlushCompletes: {
        decltype(Traits::pause_until_flush_completes(input))
            in_pause_until_flush_completes = Traits::pause_until_flush_completes(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_pause_until_flush_completes)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::mojo::pipe_control::PauseUntilFlushCompletesDataView>(
            in_pause_until_flush_completes, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null pause_until_flush_completes in RunOrClosePipeInput union");
        fragment->data.f_pause_until_flush_completes.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
      case ::mojo::pipe_control::RunOrClosePipeInputDataView::Tag::kFlushAsync: {
        decltype(Traits::flush_async(input))
            in_flush_async = Traits::flush_async(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_flush_async)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::mojo::pipe_control::FlushAsyncDataView>(
            in_flush_async, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null flush_async in RunOrClosePipeInput union");
        fragment->data.f_flush_async.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
    }
  }

  static bool Deserialize(::mojo::pipe_control::internal::RunOrClosePipeInput_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::mojo::pipe_control::RunOrClosePipeInputDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace mojo::pipe_control {

inline void RunOrClosePipeMessageParamsDataView::GetInputDataView(
    RunOrClosePipeInputDataView* output) {
  auto pointer = &data_->input;
  *output = RunOrClosePipeInputDataView(pointer, message_);
}


inline void DisconnectReasonDataView::GetDescriptionDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->description.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void PeerAssociatedEndpointClosedEventDataView::GetDisconnectReasonDataView(
    DisconnectReasonDataView* output) {
  auto pointer = data_->disconnect_reason.Get();
  *output = DisconnectReasonDataView(pointer, message_);
}






inline void RunOrClosePipeInputDataView::GetPeerAssociatedEndpointClosedEventDataView(
    PeerAssociatedEndpointClosedEventDataView* output) const {
  CHECK(is_peer_associated_endpoint_closed_event());
  *output = PeerAssociatedEndpointClosedEventDataView(data_->data.f_peer_associated_endpoint_closed_event.Get(), message_);
}
inline void RunOrClosePipeInputDataView::GetPauseUntilFlushCompletesDataView(
    PauseUntilFlushCompletesDataView* output) const {
  CHECK(is_pause_until_flush_completes());
  *output = PauseUntilFlushCompletesDataView(data_->data.f_pause_until_flush_completes.Get(), message_);
}
inline void RunOrClosePipeInputDataView::GetFlushAsyncDataView(
    FlushAsyncDataView* output) const {
  CHECK(is_flush_async());
  *output = FlushAsyncDataView(data_->data.f_flush_async.Get(), message_);
}


}  // mojo::pipe_control

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // MOJO_PUBLIC_INTERFACES_BINDINGS_PIPE_CONTROL_MESSAGES_MOJOM_SHARED_H_