// media/mojo/mojom/video_decoder.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_VIDEO_DECODER_MOJOM_PARAMS_DATA_H_
#define MEDIA_MOJO_MOJOM_VIDEO_DECODER_MOJOM_PARAMS_DATA_H_

#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace media::mojom {
namespace internal {
class  VideoFrameHandleReleaser_ReleaseVideoFrame_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::UnguessableToken_Data> release_token;
  mojo::internal::Pointer<::gpu::mojom::internal::SyncToken_Data> release_sync_token;

 private:
  friend class mojo::internal::MessageFragment<VideoFrameHandleReleaser_ReleaseVideoFrame_Params_Data>;

  VideoFrameHandleReleaser_ReleaseVideoFrame_Params_Data();
  ~VideoFrameHandleReleaser_ReleaseVideoFrame_Params_Data() = delete;
};
static_assert(sizeof(VideoFrameHandleReleaser_ReleaseVideoFrame_Params_Data) == 24,
              "Bad sizeof(VideoFrameHandleReleaser_ReleaseVideoFrame_Params_Data)");
class  VideoDecoder_GetSupportedConfigs_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<VideoDecoder_GetSupportedConfigs_Params_Data>;

  VideoDecoder_GetSupportedConfigs_Params_Data();
  ~VideoDecoder_GetSupportedConfigs_Params_Data() = delete;
};
static_assert(sizeof(VideoDecoder_GetSupportedConfigs_Params_Data) == 8,
              "Bad sizeof(VideoDecoder_GetSupportedConfigs_Params_Data)");
class  VideoDecoder_GetSupportedConfigs_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::SupportedVideoDecoderConfig_Data>>> supported_configs;
  int32_t decoder_type;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<VideoDecoder_GetSupportedConfigs_ResponseParams_Data>;

  VideoDecoder_GetSupportedConfigs_ResponseParams_Data();
  ~VideoDecoder_GetSupportedConfigs_ResponseParams_Data() = delete;
};
static_assert(sizeof(VideoDecoder_GetSupportedConfigs_ResponseParams_Data) == 24,
              "Bad sizeof(VideoDecoder_GetSupportedConfigs_ResponseParams_Data)");
class  VideoDecoder_Construct_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::AssociatedInterface_Data client;
  mojo::internal::Interface_Data media_log;
  mojo::internal::Handle_Data video_frame_handle_releaser;
  mojo::internal::Handle_Data decoder_buffer_pipe;
  mojo::internal::Pointer<internal::CommandBufferId_Data> command_buffer_id;
  mojo::internal::Pointer<::gfx::mojom::internal::ColorSpace_Data> target_color_space;

 private:
  friend class mojo::internal::MessageFragment<VideoDecoder_Construct_Params_Data>;

  VideoDecoder_Construct_Params_Data();
  ~VideoDecoder_Construct_Params_Data() = delete;
};
static_assert(sizeof(VideoDecoder_Construct_Params_Data) == 48,
              "Bad sizeof(VideoDecoder_Construct_Params_Data)");
class  VideoDecoder_Initialize_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::media::mojom::internal::VideoDecoderConfig_Data> config;
  uint8_t low_delay : 1;
  uint8_t pad1_[7];
  mojo::internal::Pointer<::mojo_base::mojom::internal::UnguessableToken_Data> cdm_id;

 private:
  friend class mojo::internal::MessageFragment<VideoDecoder_Initialize_Params_Data>;

  VideoDecoder_Initialize_Params_Data();
  ~VideoDecoder_Initialize_Params_Data() = delete;
};
static_assert(sizeof(VideoDecoder_Initialize_Params_Data) == 32,
              "Bad sizeof(VideoDecoder_Initialize_Params_Data)");
class  VideoDecoder_Initialize_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::media::mojom::internal::DecoderStatus_Data> status;
  uint8_t needs_bitstream_conversion : 1;
  uint8_t pad1_[3];
  int32_t max_decode_requests;
  int32_t decoder_type;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<VideoDecoder_Initialize_ResponseParams_Data>;

  VideoDecoder_Initialize_ResponseParams_Data();
  ~VideoDecoder_Initialize_ResponseParams_Data() = delete;
};
static_assert(sizeof(VideoDecoder_Initialize_ResponseParams_Data) == 32,
              "Bad sizeof(VideoDecoder_Initialize_ResponseParams_Data)");
class  VideoDecoder_Decode_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  ::media::mojom::internal::DecoderBuffer_Data buffer;

 private:
  friend class mojo::internal::MessageFragment<VideoDecoder_Decode_Params_Data>;

  VideoDecoder_Decode_Params_Data();
  ~VideoDecoder_Decode_Params_Data() = delete;
};
static_assert(sizeof(VideoDecoder_Decode_Params_Data) == 24,
              "Bad sizeof(VideoDecoder_Decode_Params_Data)");
class  VideoDecoder_Decode_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::media::mojom::internal::DecoderStatus_Data> status;

 private:
  friend class mojo::internal::MessageFragment<VideoDecoder_Decode_ResponseParams_Data>;

  VideoDecoder_Decode_ResponseParams_Data();
  ~VideoDecoder_Decode_ResponseParams_Data() = delete;
};
static_assert(sizeof(VideoDecoder_Decode_ResponseParams_Data) == 16,
              "Bad sizeof(VideoDecoder_Decode_ResponseParams_Data)");
class  VideoDecoder_Reset_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<VideoDecoder_Reset_Params_Data>;

  VideoDecoder_Reset_Params_Data();
  ~VideoDecoder_Reset_Params_Data() = delete;
};
static_assert(sizeof(VideoDecoder_Reset_Params_Data) == 8,
              "Bad sizeof(VideoDecoder_Reset_Params_Data)");
class  VideoDecoder_Reset_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<VideoDecoder_Reset_ResponseParams_Data>;

  VideoDecoder_Reset_ResponseParams_Data();
  ~VideoDecoder_Reset_ResponseParams_Data() = delete;
};
static_assert(sizeof(VideoDecoder_Reset_ResponseParams_Data) == 8,
              "Bad sizeof(VideoDecoder_Reset_ResponseParams_Data)");
class  VideoDecoder_OnOverlayInfoChanged_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::OverlayInfo_Data> overlay_info;

 private:
  friend class mojo::internal::MessageFragment<VideoDecoder_OnOverlayInfoChanged_Params_Data>;

  VideoDecoder_OnOverlayInfoChanged_Params_Data();
  ~VideoDecoder_OnOverlayInfoChanged_Params_Data() = delete;
};
static_assert(sizeof(VideoDecoder_OnOverlayInfoChanged_Params_Data) == 16,
              "Bad sizeof(VideoDecoder_OnOverlayInfoChanged_Params_Data)");
class  VideoDecoderClient_OnVideoFrameDecoded_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::media::mojom::internal::VideoFrame_Data> frame;
  uint8_t can_read_without_stalling : 1;
  uint8_t pad1_[7];
  mojo::internal::Pointer<::mojo_base::mojom::internal::UnguessableToken_Data> release_token;

 private:
  friend class mojo::internal::MessageFragment<VideoDecoderClient_OnVideoFrameDecoded_Params_Data>;

  VideoDecoderClient_OnVideoFrameDecoded_Params_Data();
  ~VideoDecoderClient_OnVideoFrameDecoded_Params_Data() = delete;
};
static_assert(sizeof(VideoDecoderClient_OnVideoFrameDecoded_Params_Data) == 32,
              "Bad sizeof(VideoDecoderClient_OnVideoFrameDecoded_Params_Data)");
class  VideoDecoderClient_OnWaiting_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t reason;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<VideoDecoderClient_OnWaiting_Params_Data>;

  VideoDecoderClient_OnWaiting_Params_Data();
  ~VideoDecoderClient_OnWaiting_Params_Data() = delete;
};
static_assert(sizeof(VideoDecoderClient_OnWaiting_Params_Data) == 16,
              "Bad sizeof(VideoDecoderClient_OnWaiting_Params_Data)");
class  VideoDecoderClient_RequestOverlayInfo_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t restart_for_transitions : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<VideoDecoderClient_RequestOverlayInfo_Params_Data>;

  VideoDecoderClient_RequestOverlayInfo_Params_Data();
  ~VideoDecoderClient_RequestOverlayInfo_Params_Data() = delete;
};
static_assert(sizeof(VideoDecoderClient_RequestOverlayInfo_Params_Data) == 16,
              "Bad sizeof(VideoDecoderClient_RequestOverlayInfo_Params_Data)");

}  // namespace internal


class VideoFrameHandleReleaser_ReleaseVideoFrame_ParamsDataView {
 public:
  VideoFrameHandleReleaser_ReleaseVideoFrame_ParamsDataView() = default;

  VideoFrameHandleReleaser_ReleaseVideoFrame_ParamsDataView(
      internal::VideoFrameHandleReleaser_ReleaseVideoFrame_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetReleaseTokenDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReleaseToken(UserType* output) {
    
    auto* pointer = data_->release_token.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  inline void GetReleaseSyncTokenDataView(
      ::gpu::mojom::SyncTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReleaseSyncToken(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gpu::mojom::SyncTokenDataView, UserType>(),
    "Attempting to read the optional `release_sync_token` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadReleaseSyncToken` instead "
    "of `ReadReleaseSyncToken if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->release_sync_token.Get();
    return mojo::internal::Deserialize<::gpu::mojom::SyncTokenDataView>(
        pointer, output, message_);
  }
 private:
  internal::VideoFrameHandleReleaser_ReleaseVideoFrame_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class VideoDecoder_GetSupportedConfigs_ParamsDataView {
 public:
  VideoDecoder_GetSupportedConfigs_ParamsDataView() = default;

  VideoDecoder_GetSupportedConfigs_ParamsDataView(
      internal::VideoDecoder_GetSupportedConfigs_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::VideoDecoder_GetSupportedConfigs_Params_Data* data_ = nullptr;
};


class VideoDecoder_GetSupportedConfigs_ResponseParamsDataView {
 public:
  VideoDecoder_GetSupportedConfigs_ResponseParamsDataView() = default;

  VideoDecoder_GetSupportedConfigs_ResponseParamsDataView(
      internal::VideoDecoder_GetSupportedConfigs_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSupportedConfigsDataView(
      mojo::ArrayDataView<SupportedVideoDecoderConfigDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSupportedConfigs(UserType* output) {
    
    auto* pointer = data_->supported_configs.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::media::mojom::SupportedVideoDecoderConfigDataView>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadDecoderType(UserType* output) const {
    auto data_value = data_->decoder_type;
    return mojo::internal::Deserialize<::media::mojom::VideoDecoderType>(
        data_value, output);
  }
  ::media::mojom::VideoDecoderType decoder_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::VideoDecoderType>(data_->decoder_type));
  }
 private:
  internal::VideoDecoder_GetSupportedConfigs_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class VideoDecoder_Construct_ParamsDataView {
 public:
  VideoDecoder_Construct_ParamsDataView() = default;

  VideoDecoder_Construct_ParamsDataView(
      internal::VideoDecoder_Construct_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeClient() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::media::mojom::VideoDecoderClientAssociatedPtrInfoDataView>(
            &data_->client, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeMediaLog() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::media::mojom::MediaLogInterfaceBase>>(
            &data_->media_log, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeVideoFrameHandleReleaser() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::media::mojom::VideoFrameHandleReleaserInterfaceBase>>(
            &data_->video_frame_handle_releaser, &result, message_);
    DCHECK(ret);
    return result;
  }
  mojo::ScopedDataPipeConsumerHandle TakeDecoderBufferPipe() {
    mojo::ScopedDataPipeConsumerHandle result;
    bool ret =
        mojo::internal::Deserialize<mojo::ScopedDataPipeConsumerHandle>(
            &data_->decoder_buffer_pipe, &result, message_);
    DCHECK(ret);
    return result;
  }
  inline void GetCommandBufferIdDataView(
      CommandBufferIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCommandBufferId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::media::mojom::CommandBufferIdDataView, UserType>(),
    "Attempting to read the optional `command_buffer_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCommandBufferId` instead "
    "of `ReadCommandBufferId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->command_buffer_id.Get();
    return mojo::internal::Deserialize<::media::mojom::CommandBufferIdDataView>(
        pointer, output, message_);
  }
  inline void GetTargetColorSpaceDataView(
      ::gfx::mojom::ColorSpaceDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTargetColorSpace(UserType* output) {
    
    auto* pointer = data_->target_color_space.Get();
    return mojo::internal::Deserialize<::gfx::mojom::ColorSpaceDataView>(
        pointer, output, message_);
  }
 private:
  internal::VideoDecoder_Construct_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class VideoDecoder_Initialize_ParamsDataView {
 public:
  VideoDecoder_Initialize_ParamsDataView() = default;

  VideoDecoder_Initialize_ParamsDataView(
      internal::VideoDecoder_Initialize_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetConfigDataView(
      ::media::mojom::VideoDecoderConfigDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadConfig(UserType* output) {
    
    auto* pointer = data_->config.Get();
    return mojo::internal::Deserialize<::media::mojom::VideoDecoderConfigDataView>(
        pointer, output, message_);
  }
  bool low_delay() const {
    return data_->low_delay;
  }
  inline void GetCdmIdDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCdmId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::UnguessableTokenDataView, UserType>(),
    "Attempting to read the optional `cdm_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCdmId` instead "
    "of `ReadCdmId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->cdm_id.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
 private:
  internal::VideoDecoder_Initialize_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class VideoDecoder_Initialize_ResponseParamsDataView {
 public:
  VideoDecoder_Initialize_ResponseParamsDataView() = default;

  VideoDecoder_Initialize_ResponseParamsDataView(
      internal::VideoDecoder_Initialize_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetStatusDataView(
      ::media::mojom::DecoderStatusDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStatus(UserType* output) {
    
    auto* pointer = data_->status.Get();
    return mojo::internal::Deserialize<::media::mojom::DecoderStatusDataView>(
        pointer, output, message_);
  }
  bool needs_bitstream_conversion() const {
    return data_->needs_bitstream_conversion;
  }
  int32_t max_decode_requests() const {
    return data_->max_decode_requests;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadDecoderType(UserType* output) const {
    auto data_value = data_->decoder_type;
    return mojo::internal::Deserialize<::media::mojom::VideoDecoderType>(
        data_value, output);
  }
  ::media::mojom::VideoDecoderType decoder_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::VideoDecoderType>(data_->decoder_type));
  }
 private:
  internal::VideoDecoder_Initialize_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class VideoDecoder_Decode_ParamsDataView {
 public:
  VideoDecoder_Decode_ParamsDataView() = default;

  VideoDecoder_Decode_ParamsDataView(
      internal::VideoDecoder_Decode_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetBufferDataView(
      ::media::mojom::DecoderBufferDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBuffer(UserType* output) {
    
    auto* pointer = !data_->buffer.is_null() ? &data_->buffer : nullptr;
    return mojo::internal::Deserialize<::media::mojom::DecoderBufferDataView>(
        pointer, output, message_);
  }
 private:
  internal::VideoDecoder_Decode_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class VideoDecoder_Decode_ResponseParamsDataView {
 public:
  VideoDecoder_Decode_ResponseParamsDataView() = default;

  VideoDecoder_Decode_ResponseParamsDataView(
      internal::VideoDecoder_Decode_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetStatusDataView(
      ::media::mojom::DecoderStatusDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStatus(UserType* output) {
    
    auto* pointer = data_->status.Get();
    return mojo::internal::Deserialize<::media::mojom::DecoderStatusDataView>(
        pointer, output, message_);
  }
 private:
  internal::VideoDecoder_Decode_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class VideoDecoder_Reset_ParamsDataView {
 public:
  VideoDecoder_Reset_ParamsDataView() = default;

  VideoDecoder_Reset_ParamsDataView(
      internal::VideoDecoder_Reset_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::VideoDecoder_Reset_Params_Data* data_ = nullptr;
};


class VideoDecoder_Reset_ResponseParamsDataView {
 public:
  VideoDecoder_Reset_ResponseParamsDataView() = default;

  VideoDecoder_Reset_ResponseParamsDataView(
      internal::VideoDecoder_Reset_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::VideoDecoder_Reset_ResponseParams_Data* data_ = nullptr;
};


class VideoDecoder_OnOverlayInfoChanged_ParamsDataView {
 public:
  VideoDecoder_OnOverlayInfoChanged_ParamsDataView() = default;

  VideoDecoder_OnOverlayInfoChanged_ParamsDataView(
      internal::VideoDecoder_OnOverlayInfoChanged_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetOverlayInfoDataView(
      OverlayInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOverlayInfo(UserType* output) {
    
    auto* pointer = data_->overlay_info.Get();
    return mojo::internal::Deserialize<::media::mojom::OverlayInfoDataView>(
        pointer, output, message_);
  }
 private:
  internal::VideoDecoder_OnOverlayInfoChanged_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class VideoDecoderClient_OnVideoFrameDecoded_ParamsDataView {
 public:
  VideoDecoderClient_OnVideoFrameDecoded_ParamsDataView() = default;

  VideoDecoderClient_OnVideoFrameDecoded_ParamsDataView(
      internal::VideoDecoderClient_OnVideoFrameDecoded_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFrameDataView(
      ::media::mojom::VideoFrameDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFrame(UserType* output) {
    
    auto* pointer = data_->frame.Get();
    return mojo::internal::Deserialize<::media::mojom::VideoFrameDataView>(
        pointer, output, message_);
  }
  bool can_read_without_stalling() const {
    return data_->can_read_without_stalling;
  }
  inline void GetReleaseTokenDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReleaseToken(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::UnguessableTokenDataView, UserType>(),
    "Attempting to read the optional `release_token` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadReleaseToken` instead "
    "of `ReadReleaseToken if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->release_token.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
 private:
  internal::VideoDecoderClient_OnVideoFrameDecoded_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class VideoDecoderClient_OnWaiting_ParamsDataView {
 public:
  VideoDecoderClient_OnWaiting_ParamsDataView() = default;

  VideoDecoderClient_OnWaiting_ParamsDataView(
      internal::VideoDecoderClient_OnWaiting_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadReason(UserType* output) const {
    auto data_value = data_->reason;
    return mojo::internal::Deserialize<::media::mojom::WaitingReason>(
        data_value, output);
  }
  ::media::mojom::WaitingReason reason() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::WaitingReason>(data_->reason));
  }
 private:
  internal::VideoDecoderClient_OnWaiting_Params_Data* data_ = nullptr;
};


class VideoDecoderClient_RequestOverlayInfo_ParamsDataView {
 public:
  VideoDecoderClient_RequestOverlayInfo_ParamsDataView() = default;

  VideoDecoderClient_RequestOverlayInfo_ParamsDataView(
      internal::VideoDecoderClient_RequestOverlayInfo_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool restart_for_transitions() const {
    return data_->restart_for_transitions;
  }
 private:
  internal::VideoDecoderClient_RequestOverlayInfo_Params_Data* data_ = nullptr;
};

inline void VideoFrameHandleReleaser_ReleaseVideoFrame_ParamsDataView::GetReleaseTokenDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->release_token.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}
inline void VideoFrameHandleReleaser_ReleaseVideoFrame_ParamsDataView::GetReleaseSyncTokenDataView(
    ::gpu::mojom::SyncTokenDataView* output) {
  auto pointer = data_->release_sync_token.Get();
  *output = ::gpu::mojom::SyncTokenDataView(pointer, message_);
}




inline void VideoDecoder_GetSupportedConfigs_ResponseParamsDataView::GetSupportedConfigsDataView(
    mojo::ArrayDataView<SupportedVideoDecoderConfigDataView>* output) {
  auto pointer = data_->supported_configs.Get();
  *output = mojo::ArrayDataView<SupportedVideoDecoderConfigDataView>(pointer, message_);
}


inline void VideoDecoder_Construct_ParamsDataView::GetCommandBufferIdDataView(
    CommandBufferIdDataView* output) {
  auto pointer = data_->command_buffer_id.Get();
  *output = CommandBufferIdDataView(pointer, message_);
}
inline void VideoDecoder_Construct_ParamsDataView::GetTargetColorSpaceDataView(
    ::gfx::mojom::ColorSpaceDataView* output) {
  auto pointer = data_->target_color_space.Get();
  *output = ::gfx::mojom::ColorSpaceDataView(pointer, message_);
}


inline void VideoDecoder_Initialize_ParamsDataView::GetConfigDataView(
    ::media::mojom::VideoDecoderConfigDataView* output) {
  auto pointer = data_->config.Get();
  *output = ::media::mojom::VideoDecoderConfigDataView(pointer, message_);
}
inline void VideoDecoder_Initialize_ParamsDataView::GetCdmIdDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->cdm_id.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}


inline void VideoDecoder_Initialize_ResponseParamsDataView::GetStatusDataView(
    ::media::mojom::DecoderStatusDataView* output) {
  auto pointer = data_->status.Get();
  *output = ::media::mojom::DecoderStatusDataView(pointer, message_);
}


inline void VideoDecoder_Decode_ParamsDataView::GetBufferDataView(
    ::media::mojom::DecoderBufferDataView* output) {
  auto pointer = &data_->buffer;
  *output = ::media::mojom::DecoderBufferDataView(pointer, message_);
}


inline void VideoDecoder_Decode_ResponseParamsDataView::GetStatusDataView(
    ::media::mojom::DecoderStatusDataView* output) {
  auto pointer = data_->status.Get();
  *output = ::media::mojom::DecoderStatusDataView(pointer, message_);
}






inline void VideoDecoder_OnOverlayInfoChanged_ParamsDataView::GetOverlayInfoDataView(
    OverlayInfoDataView* output) {
  auto pointer = data_->overlay_info.Get();
  *output = OverlayInfoDataView(pointer, message_);
}


inline void VideoDecoderClient_OnVideoFrameDecoded_ParamsDataView::GetFrameDataView(
    ::media::mojom::VideoFrameDataView* output) {
  auto pointer = data_->frame.Get();
  *output = ::media::mojom::VideoFrameDataView(pointer, message_);
}
inline void VideoDecoderClient_OnVideoFrameDecoded_ParamsDataView::GetReleaseTokenDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->release_token.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}







}  // media::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // MEDIA_MOJO_MOJOM_VIDEO_DECODER_MOJOM_PARAMS_DATA_H_