// media/mojo/mojom/stable/stable_video_decoder.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "media/mojo/mojom/stable/stable_video_decoder.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/mojo/mojom/stable/stable_video_decoder.mojom-params-data.h"
#include "media/mojo/mojom/stable/stable_video_decoder.mojom-shared-message-ids.h"

#include "media/mojo/mojom/stable/stable_video_decoder.mojom-import-headers.h"
#include "media/mojo/mojom/stable/stable_video_decoder.mojom-test-utils.h"


namespace media::stable::mojom {
const char MediaLog::Name_[] = "media.stable.mojom.MediaLog";
constexpr base::Token MediaLog::Uuid_;

MediaLog::IPCStableHashFunction MediaLog::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::MediaLog>(message.name())) {
    case messages::MediaLog::kAddLogRecord: {
      return &MediaLog::AddLogRecord_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* MediaLog::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::MediaLog>(message.name())) {
      case messages::MediaLog::kAddLogRecord:
            return "Receive media::stable::mojom::MediaLog::AddLogRecord";
    }
  } else {
    switch (static_cast<messages::MediaLog>(message.name())) {
      case messages::MediaLog::kAddLogRecord:
            return "Receive reply media::stable::mojom::MediaLog::AddLogRecord";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t MediaLog::AddLogRecord_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)media::stable::mojom::MediaLog::AddLogRecord");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

MediaLogProxy::MediaLogProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void MediaLogProxy::AddLogRecord(
    const ::media::MediaLogRecord& in_event) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::stable::mojom::MediaLog::AddLogRecord", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event"), in_event,
                        "<value of type const ::media::MediaLogRecord&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaLog::kAddLogRecord), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::stable::mojom::internal::MediaLog_AddLogRecord_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->event)::BaseType> event_fragment(
          params.message());
  mojo::internal::Serialize<::media::stable::mojom::MediaLogRecordDataView>(
      in_event, event_fragment);
  params->event.Set(
      event_fragment.is_null() ? nullptr : event_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->event.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null event in MediaLog.AddLogRecord request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaLog::Name_);
  message.set_method_name("AddLogRecord");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool MediaLogStubDispatch::Accept(
    MediaLog* impl,
    mojo::Message* message) {
  switch (static_cast<messages::MediaLog>(message->header()->name)) {
    case messages::MediaLog::kAddLogRecord: {
      DCHECK(message->is_serialized());
      internal::MediaLog_AddLogRecord_Params_Data* params =
          reinterpret_cast<internal::MediaLog_AddLogRecord_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for MediaLog.0
      bool success = true;
      ::media::MediaLogRecord p_event{};
      MediaLog_AddLogRecord_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadEvent(&p_event))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaLog::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddLogRecord(        
        std::move(p_event));
      return true;
    }
  }
  return false;
}

// static
bool MediaLogStubDispatch::AcceptWithResponder(
    MediaLog* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::MediaLog>(message->header()->name)) {
    case messages::MediaLog::kAddLogRecord: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kMediaLogValidationInfo[] = {
    { &internal::MediaLog_AddLogRecord_Params_Data::Validate,
     nullptr /* no response */},
};

bool MediaLogRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::stable::mojom::MediaLog::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kMediaLogValidationInfo);
}

const char VideoFrameHandleReleaser::Name_[] = "media.stable.mojom.VideoFrameHandleReleaser";
constexpr base::Token VideoFrameHandleReleaser::Uuid_;

VideoFrameHandleReleaser::IPCStableHashFunction VideoFrameHandleReleaser::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::VideoFrameHandleReleaser>(message.name())) {
    case messages::VideoFrameHandleReleaser::kReleaseVideoFrame: {
      return &VideoFrameHandleReleaser::ReleaseVideoFrame_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* VideoFrameHandleReleaser::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::VideoFrameHandleReleaser>(message.name())) {
      case messages::VideoFrameHandleReleaser::kReleaseVideoFrame:
            return "Receive media::stable::mojom::VideoFrameHandleReleaser::ReleaseVideoFrame";
    }
  } else {
    switch (static_cast<messages::VideoFrameHandleReleaser>(message.name())) {
      case messages::VideoFrameHandleReleaser::kReleaseVideoFrame:
            return "Receive reply media::stable::mojom::VideoFrameHandleReleaser::ReleaseVideoFrame";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t VideoFrameHandleReleaser::ReleaseVideoFrame_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)media::stable::mojom::VideoFrameHandleReleaser::ReleaseVideoFrame");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

VideoFrameHandleReleaserProxy::VideoFrameHandleReleaserProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void VideoFrameHandleReleaserProxy::ReleaseVideoFrame(
    const ::base::UnguessableToken& in_release_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::stable::mojom::VideoFrameHandleReleaser::ReleaseVideoFrame", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("release_token"), in_release_token,
                        "<value of type const ::base::UnguessableToken&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoFrameHandleReleaser::kReleaseVideoFrame), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::stable::mojom::internal::VideoFrameHandleReleaser_ReleaseVideoFrame_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->release_token)::BaseType> release_token_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_release_token, release_token_fragment);
  params->release_token.Set(
      release_token_fragment.is_null() ? nullptr : release_token_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->release_token.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null release_token in VideoFrameHandleReleaser.ReleaseVideoFrame request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoFrameHandleReleaser::Name_);
  message.set_method_name("ReleaseVideoFrame");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool VideoFrameHandleReleaserStubDispatch::Accept(
    VideoFrameHandleReleaser* impl,
    mojo::Message* message) {
  switch (static_cast<messages::VideoFrameHandleReleaser>(message->header()->name)) {
    case messages::VideoFrameHandleReleaser::kReleaseVideoFrame: {
      DCHECK(message->is_serialized());
      internal::VideoFrameHandleReleaser_ReleaseVideoFrame_Params_Data* params =
          reinterpret_cast<internal::VideoFrameHandleReleaser_ReleaseVideoFrame_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for VideoFrameHandleReleaser.0
      bool success = true;
      ::base::UnguessableToken p_release_token{};
      VideoFrameHandleReleaser_ReleaseVideoFrame_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadReleaseToken(&p_release_token))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoFrameHandleReleaser::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReleaseVideoFrame(        
        std::move(p_release_token));
      return true;
    }
  }
  return false;
}

// static
bool VideoFrameHandleReleaserStubDispatch::AcceptWithResponder(
    VideoFrameHandleReleaser* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::VideoFrameHandleReleaser>(message->header()->name)) {
    case messages::VideoFrameHandleReleaser::kReleaseVideoFrame: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kVideoFrameHandleReleaserValidationInfo[] = {
    { &internal::VideoFrameHandleReleaser_ReleaseVideoFrame_Params_Data::Validate,
     nullptr /* no response */},
};

bool VideoFrameHandleReleaserRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::stable::mojom::VideoFrameHandleReleaser::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kVideoFrameHandleReleaserValidationInfo);
}

const char VideoDecoderClient::Name_[] = "media.stable.mojom.VideoDecoderClient";
constexpr base::Token VideoDecoderClient::Uuid_;

VideoDecoderClient::IPCStableHashFunction VideoDecoderClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::VideoDecoderClient>(message.name())) {
    case messages::VideoDecoderClient::kOnVideoFrameDecoded: {
      return &VideoDecoderClient::OnVideoFrameDecoded_Sym::IPCStableHash;
    }
    case messages::VideoDecoderClient::kOnWaiting: {
      return &VideoDecoderClient::OnWaiting_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* VideoDecoderClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::VideoDecoderClient>(message.name())) {
      case messages::VideoDecoderClient::kOnVideoFrameDecoded:
            return "Receive media::stable::mojom::VideoDecoderClient::OnVideoFrameDecoded";
      case messages::VideoDecoderClient::kOnWaiting:
            return "Receive media::stable::mojom::VideoDecoderClient::OnWaiting";
    }
  } else {
    switch (static_cast<messages::VideoDecoderClient>(message.name())) {
      case messages::VideoDecoderClient::kOnVideoFrameDecoded:
            return "Receive reply media::stable::mojom::VideoDecoderClient::OnVideoFrameDecoded";
      case messages::VideoDecoderClient::kOnWaiting:
            return "Receive reply media::stable::mojom::VideoDecoderClient::OnWaiting";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t VideoDecoderClient::OnVideoFrameDecoded_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)media::stable::mojom::VideoDecoderClient::OnVideoFrameDecoded");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t VideoDecoderClient::OnWaiting_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)media::stable::mojom::VideoDecoderClient::OnWaiting");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

VideoDecoderClientProxy::VideoDecoderClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void VideoDecoderClientProxy::OnVideoFrameDecoded(
    ::media::stable::mojom::VideoFramePtr in_frame, bool in_can_read_without_stalling, const ::base::UnguessableToken& in_release_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::stable::mojom::VideoDecoderClient::OnVideoFrameDecoded", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame"), in_frame,
                        "<value of type ::media::stable::mojom::VideoFramePtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("can_read_without_stalling"), in_can_read_without_stalling,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("release_token"), in_release_token,
                        "<value of type const ::base::UnguessableToken&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoDecoderClient::kOnVideoFrameDecoded), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::stable::mojom::internal::VideoDecoderClient_OnVideoFrameDecoded_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->frame)::BaseType> frame_fragment(
          params.message());
  mojo::internal::Serialize<::media::stable::mojom::VideoFrameDataView>(
      in_frame, frame_fragment);
  params->frame.Set(
      frame_fragment.is_null() ? nullptr : frame_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->frame.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null frame in VideoDecoderClient.OnVideoFrameDecoded request");
  params->can_read_without_stalling = in_can_read_without_stalling;
  mojo::internal::MessageFragment<
      typename decltype(params->release_token)::BaseType> release_token_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_release_token, release_token_fragment);
  params->release_token.Set(
      release_token_fragment.is_null() ? nullptr : release_token_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->release_token.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null release_token in VideoDecoderClient.OnVideoFrameDecoded request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoDecoderClient::Name_);
  message.set_method_name("OnVideoFrameDecoded");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void VideoDecoderClientProxy::OnWaiting(
    ::media::WaitingReason in_reason) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::stable::mojom::VideoDecoderClient::OnWaiting", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reason"), in_reason,
                        "<value of type ::media::WaitingReason>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoDecoderClient::kOnWaiting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::stable::mojom::internal::VideoDecoderClient_OnWaiting_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::media::stable::mojom::WaitingReason>(
      in_reason, &params->reason);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoDecoderClient::Name_);
  message.set_method_name("OnWaiting");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool VideoDecoderClientStubDispatch::Accept(
    VideoDecoderClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::VideoDecoderClient>(message->header()->name)) {
    case messages::VideoDecoderClient::kOnVideoFrameDecoded: {
      DCHECK(message->is_serialized());
      internal::VideoDecoderClient_OnVideoFrameDecoded_Params_Data* params =
          reinterpret_cast<internal::VideoDecoderClient_OnVideoFrameDecoded_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for VideoDecoderClient.0
      bool success = true;
      ::media::stable::mojom::VideoFramePtr p_frame{};
      bool p_can_read_without_stalling{};
      ::base::UnguessableToken p_release_token{};
      VideoDecoderClient_OnVideoFrameDecoded_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFrame(&p_frame))
        success = false;
      if (success)
        p_can_read_without_stalling = input_data_view.can_read_without_stalling();
      if (success && !input_data_view.ReadReleaseToken(&p_release_token))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoDecoderClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnVideoFrameDecoded(        
        std::move(p_frame), 
        std::move(p_can_read_without_stalling), 
        std::move(p_release_token));
      return true;
    }
    case messages::VideoDecoderClient::kOnWaiting: {
      DCHECK(message->is_serialized());
      internal::VideoDecoderClient_OnWaiting_Params_Data* params =
          reinterpret_cast<internal::VideoDecoderClient_OnWaiting_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for VideoDecoderClient.1
      bool success = true;
      ::media::WaitingReason p_reason{};
      VideoDecoderClient_OnWaiting_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadReason(&p_reason))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoDecoderClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnWaiting(        
        std::move(p_reason));
      return true;
    }
  }
  return false;
}

// static
bool VideoDecoderClientStubDispatch::AcceptWithResponder(
    VideoDecoderClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::VideoDecoderClient>(message->header()->name)) {
    case messages::VideoDecoderClient::kOnVideoFrameDecoded: {
      break;
    }
    case messages::VideoDecoderClient::kOnWaiting: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kVideoDecoderClientValidationInfo[] = {
    { &internal::VideoDecoderClient_OnVideoFrameDecoded_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::VideoDecoderClient_OnWaiting_Params_Data::Validate,
     nullptr /* no response */},
};

bool VideoDecoderClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::stable::mojom::VideoDecoderClient::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kVideoDecoderClientValidationInfo);
}

const char CdmContextEventCallback::Name_[] = "media.stable.mojom.CdmContextEventCallback";
constexpr base::Token CdmContextEventCallback::Uuid_;

CdmContextEventCallback::IPCStableHashFunction CdmContextEventCallback::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::CdmContextEventCallback>(message.name())) {
    case messages::CdmContextEventCallback::kEventCallback: {
      return &CdmContextEventCallback::EventCallback_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* CdmContextEventCallback::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::CdmContextEventCallback>(message.name())) {
      case messages::CdmContextEventCallback::kEventCallback:
            return "Receive media::stable::mojom::CdmContextEventCallback::EventCallback";
    }
  } else {
    switch (static_cast<messages::CdmContextEventCallback>(message.name())) {
      case messages::CdmContextEventCallback::kEventCallback:
            return "Receive reply media::stable::mojom::CdmContextEventCallback::EventCallback";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t CdmContextEventCallback::EventCallback_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)media::stable::mojom::CdmContextEventCallback::EventCallback");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

CdmContextEventCallbackProxy::CdmContextEventCallbackProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CdmContextEventCallbackProxy::EventCallback(
    ::media::CdmContext::Event in_event) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::stable::mojom::CdmContextEventCallback::EventCallback", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event"), in_event,
                        "<value of type ::media::CdmContext::Event>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CdmContextEventCallback::kEventCallback), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::stable::mojom::internal::CdmContextEventCallback_EventCallback_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::media::stable::mojom::CdmContextEvent>(
      in_event, &params->event);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CdmContextEventCallback::Name_);
  message.set_method_name("EventCallback");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool CdmContextEventCallbackStubDispatch::Accept(
    CdmContextEventCallback* impl,
    mojo::Message* message) {
  switch (static_cast<messages::CdmContextEventCallback>(message->header()->name)) {
    case messages::CdmContextEventCallback::kEventCallback: {
      DCHECK(message->is_serialized());
      internal::CdmContextEventCallback_EventCallback_Params_Data* params =
          reinterpret_cast<internal::CdmContextEventCallback_EventCallback_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for CdmContextEventCallback.0
      bool success = true;
      ::media::CdmContext::Event p_event{};
      CdmContextEventCallback_EventCallback_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadEvent(&p_event))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CdmContextEventCallback::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EventCallback(        
        std::move(p_event));
      return true;
    }
  }
  return false;
}

// static
bool CdmContextEventCallbackStubDispatch::AcceptWithResponder(
    CdmContextEventCallback* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::CdmContextEventCallback>(message->header()->name)) {
    case messages::CdmContextEventCallback::kEventCallback: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kCdmContextEventCallbackValidationInfo[] = {
    { &internal::CdmContextEventCallback_EventCallback_Params_Data::Validate,
     nullptr /* no response */},
};

bool CdmContextEventCallbackRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::stable::mojom::CdmContextEventCallback::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kCdmContextEventCallbackValidationInfo);
}

const char StableCdmContext::Name_[] = "media.stable.mojom.StableCdmContext";
constexpr base::Token StableCdmContext::Uuid_;

StableCdmContext::IPCStableHashFunction StableCdmContext::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::StableCdmContext>(message.name())) {
    case messages::StableCdmContext::kGetHwKeyData: {
      return &StableCdmContext::GetHwKeyData_Sym::IPCStableHash;
    }
    case messages::StableCdmContext::kRegisterEventCallback: {
      return &StableCdmContext::RegisterEventCallback_Sym::IPCStableHash;
    }
    case messages::StableCdmContext::kGetHwConfigData: {
      return &StableCdmContext::GetHwConfigData_Sym::IPCStableHash;
    }
    case messages::StableCdmContext::kGetScreenResolutions: {
      return &StableCdmContext::GetScreenResolutions_Sym::IPCStableHash;
    }
    case messages::StableCdmContext::kAllocateSecureBuffer: {
      return &StableCdmContext::AllocateSecureBuffer_Sym::IPCStableHash;
    }
    case messages::StableCdmContext::kParseEncryptedSliceHeader: {
      return &StableCdmContext::ParseEncryptedSliceHeader_Sym::IPCStableHash;
    }
    case messages::StableCdmContext::kDecryptVideoBuffer: {
      return &StableCdmContext::DecryptVideoBuffer_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* StableCdmContext::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::StableCdmContext>(message.name())) {
      case messages::StableCdmContext::kGetHwKeyData:
            return "Receive media::stable::mojom::StableCdmContext::GetHwKeyData";
      case messages::StableCdmContext::kRegisterEventCallback:
            return "Receive media::stable::mojom::StableCdmContext::RegisterEventCallback";
      case messages::StableCdmContext::kGetHwConfigData:
            return "Receive media::stable::mojom::StableCdmContext::GetHwConfigData";
      case messages::StableCdmContext::kGetScreenResolutions:
            return "Receive media::stable::mojom::StableCdmContext::GetScreenResolutions";
      case messages::StableCdmContext::kAllocateSecureBuffer:
            return "Receive media::stable::mojom::StableCdmContext::AllocateSecureBuffer";
      case messages::StableCdmContext::kParseEncryptedSliceHeader:
            return "Receive media::stable::mojom::StableCdmContext::ParseEncryptedSliceHeader";
      case messages::StableCdmContext::kDecryptVideoBuffer:
            return "Receive media::stable::mojom::StableCdmContext::DecryptVideoBuffer";
    }
  } else {
    switch (static_cast<messages::StableCdmContext>(message.name())) {
      case messages::StableCdmContext::kGetHwKeyData:
            return "Receive reply media::stable::mojom::StableCdmContext::GetHwKeyData";
      case messages::StableCdmContext::kRegisterEventCallback:
            return "Receive reply media::stable::mojom::StableCdmContext::RegisterEventCallback";
      case messages::StableCdmContext::kGetHwConfigData:
            return "Receive reply media::stable::mojom::StableCdmContext::GetHwConfigData";
      case messages::StableCdmContext::kGetScreenResolutions:
            return "Receive reply media::stable::mojom::StableCdmContext::GetScreenResolutions";
      case messages::StableCdmContext::kAllocateSecureBuffer:
            return "Receive reply media::stable::mojom::StableCdmContext::AllocateSecureBuffer";
      case messages::StableCdmContext::kParseEncryptedSliceHeader:
            return "Receive reply media::stable::mojom::StableCdmContext::ParseEncryptedSliceHeader";
      case messages::StableCdmContext::kDecryptVideoBuffer:
            return "Receive reply media::stable::mojom::StableCdmContext::DecryptVideoBuffer";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t StableCdmContext::GetHwKeyData_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)media::stable::mojom::StableCdmContext::GetHwKeyData");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t StableCdmContext::RegisterEventCallback_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)media::stable::mojom::StableCdmContext::RegisterEventCallback");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t StableCdmContext::GetHwConfigData_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)media::stable::mojom::StableCdmContext::GetHwConfigData");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t StableCdmContext::GetScreenResolutions_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)media::stable::mojom::StableCdmContext::GetScreenResolutions");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t StableCdmContext::AllocateSecureBuffer_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)media::stable::mojom::StableCdmContext::AllocateSecureBuffer");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t StableCdmContext::ParseEncryptedSliceHeader_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)media::stable::mojom::StableCdmContext::ParseEncryptedSliceHeader");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t StableCdmContext::DecryptVideoBuffer_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)media::stable::mojom::StableCdmContext::DecryptVideoBuffer");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class StableCdmContext_GetHwKeyData_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  StableCdmContext_GetHwKeyData_ForwardToCallback(
      StableCdmContext::GetHwKeyDataCallback callback
      ) : callback_(std::move(callback)) {
  }

  StableCdmContext_GetHwKeyData_ForwardToCallback(const StableCdmContext_GetHwKeyData_ForwardToCallback&) = delete;
  StableCdmContext_GetHwKeyData_ForwardToCallback& operator=(const StableCdmContext_GetHwKeyData_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  StableCdmContext::GetHwKeyDataCallback callback_;
};

class StableCdmContext_GetHwConfigData_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  StableCdmContext_GetHwConfigData_ForwardToCallback(
      StableCdmContext::GetHwConfigDataCallback callback
      ) : callback_(std::move(callback)) {
  }

  StableCdmContext_GetHwConfigData_ForwardToCallback(const StableCdmContext_GetHwConfigData_ForwardToCallback&) = delete;
  StableCdmContext_GetHwConfigData_ForwardToCallback& operator=(const StableCdmContext_GetHwConfigData_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  StableCdmContext::GetHwConfigDataCallback callback_;
};

class StableCdmContext_GetScreenResolutions_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  StableCdmContext_GetScreenResolutions_ForwardToCallback(
      StableCdmContext::GetScreenResolutionsCallback callback
      ) : callback_(std::move(callback)) {
  }

  StableCdmContext_GetScreenResolutions_ForwardToCallback(const StableCdmContext_GetScreenResolutions_ForwardToCallback&) = delete;
  StableCdmContext_GetScreenResolutions_ForwardToCallback& operator=(const StableCdmContext_GetScreenResolutions_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  StableCdmContext::GetScreenResolutionsCallback callback_;
};

class StableCdmContext_AllocateSecureBuffer_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  StableCdmContext_AllocateSecureBuffer_ForwardToCallback(
      StableCdmContext::AllocateSecureBufferCallback callback
      ) : callback_(std::move(callback)) {
  }

  StableCdmContext_AllocateSecureBuffer_ForwardToCallback(const StableCdmContext_AllocateSecureBuffer_ForwardToCallback&) = delete;
  StableCdmContext_AllocateSecureBuffer_ForwardToCallback& operator=(const StableCdmContext_AllocateSecureBuffer_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  StableCdmContext::AllocateSecureBufferCallback callback_;
};

class StableCdmContext_ParseEncryptedSliceHeader_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  StableCdmContext_ParseEncryptedSliceHeader_ForwardToCallback(
      StableCdmContext::ParseEncryptedSliceHeaderCallback callback
      ) : callback_(std::move(callback)) {
  }

  StableCdmContext_ParseEncryptedSliceHeader_ForwardToCallback(const StableCdmContext_ParseEncryptedSliceHeader_ForwardToCallback&) = delete;
  StableCdmContext_ParseEncryptedSliceHeader_ForwardToCallback& operator=(const StableCdmContext_ParseEncryptedSliceHeader_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  StableCdmContext::ParseEncryptedSliceHeaderCallback callback_;
};

class StableCdmContext_DecryptVideoBuffer_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  StableCdmContext_DecryptVideoBuffer_ForwardToCallback(
      StableCdmContext::DecryptVideoBufferCallback callback
      ) : callback_(std::move(callback)) {
  }

  StableCdmContext_DecryptVideoBuffer_ForwardToCallback(const StableCdmContext_DecryptVideoBuffer_ForwardToCallback&) = delete;
  StableCdmContext_DecryptVideoBuffer_ForwardToCallback& operator=(const StableCdmContext_DecryptVideoBuffer_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  StableCdmContext::DecryptVideoBufferCallback callback_;
};

StableCdmContextProxy::StableCdmContextProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void StableCdmContextProxy::GetHwKeyData(
    ::std::unique_ptr<::media::DecryptConfig> in_decrypt_config, const std::vector<uint8_t>& in_hw_identifier, GetHwKeyDataCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::stable::mojom::StableCdmContext::GetHwKeyData", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("decrypt_config"), in_decrypt_config,
                        "<value of type ::std::unique_ptr<::media::DecryptConfig>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("hw_identifier"), in_hw_identifier,
                        "<value of type const std::vector<uint8_t>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::StableCdmContext::kGetHwKeyData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::stable::mojom::internal::StableCdmContext_GetHwKeyData_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->decrypt_config)::BaseType> decrypt_config_fragment(
          params.message());
  mojo::internal::Serialize<::media::stable::mojom::DecryptConfigDataView>(
      in_decrypt_config, decrypt_config_fragment);
  params->decrypt_config.Set(
      decrypt_config_fragment.is_null() ? nullptr : decrypt_config_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->decrypt_config.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null decrypt_config in StableCdmContext.GetHwKeyData request");
  mojo::internal::MessageFragment<
      typename decltype(params->hw_identifier)::BaseType>
      hw_identifier_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& hw_identifier_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_hw_identifier, hw_identifier_fragment, &hw_identifier_validate_params);
  params->hw_identifier.Set(
      hw_identifier_fragment.is_null() ? nullptr : hw_identifier_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->hw_identifier.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null hw_identifier in StableCdmContext.GetHwKeyData request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StableCdmContext::Name_);
  message.set_method_name("GetHwKeyData");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new StableCdmContext_GetHwKeyData_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void StableCdmContextProxy::RegisterEventCallback(
    ::mojo::PendingRemote<CdmContextEventCallback> in_callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::stable::mojom::StableCdmContext::RegisterEventCallback", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("callback"), in_callback,
                        "<value of type ::mojo::PendingRemote<CdmContextEventCallback>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::StableCdmContext::kRegisterEventCallback), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::stable::mojom::internal::StableCdmContext_RegisterEventCallback_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::media::stable::mojom::CdmContextEventCallbackInterfaceBase>>(
      in_callback, &params->callback, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->callback),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid callback in StableCdmContext.RegisterEventCallback request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StableCdmContext::Name_);
  message.set_method_name("RegisterEventCallback");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void StableCdmContextProxy::GetHwConfigData(
    GetHwConfigDataCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media::stable::mojom::StableCdmContext::GetHwConfigData");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::StableCdmContext::kGetHwConfigData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::stable::mojom::internal::StableCdmContext_GetHwConfigData_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StableCdmContext::Name_);
  message.set_method_name("GetHwConfigData");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new StableCdmContext_GetHwConfigData_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void StableCdmContextProxy::GetScreenResolutions(
    GetScreenResolutionsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media::stable::mojom::StableCdmContext::GetScreenResolutions");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::StableCdmContext::kGetScreenResolutions), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::stable::mojom::internal::StableCdmContext_GetScreenResolutions_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StableCdmContext::Name_);
  message.set_method_name("GetScreenResolutions");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new StableCdmContext_GetScreenResolutions_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void StableCdmContextProxy::AllocateSecureBuffer(
    uint32_t in_size, AllocateSecureBufferCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::stable::mojom::StableCdmContext::AllocateSecureBuffer", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("size"), in_size,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::StableCdmContext::kAllocateSecureBuffer), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::stable::mojom::internal::StableCdmContext_AllocateSecureBuffer_Params_Data> params(
          message);
  params.Allocate();
  params->size = in_size;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StableCdmContext::Name_);
  message.set_method_name("AllocateSecureBuffer");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new StableCdmContext_AllocateSecureBuffer_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void StableCdmContextProxy::ParseEncryptedSliceHeader(
    uint64_t in_secure_handle, uint32_t in_offset, const std::vector<uint8_t>& in_stream_data, ParseEncryptedSliceHeaderCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::stable::mojom::StableCdmContext::ParseEncryptedSliceHeader", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("secure_handle"), in_secure_handle,
                        "<value of type uint64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("offset"), in_offset,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("stream_data"), in_stream_data,
                        "<value of type const std::vector<uint8_t>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::StableCdmContext::kParseEncryptedSliceHeader), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::stable::mojom::internal::StableCdmContext_ParseEncryptedSliceHeader_Params_Data> params(
          message);
  params.Allocate();
  params->secure_handle = in_secure_handle;
  params->offset = in_offset;
  mojo::internal::MessageFragment<
      typename decltype(params->stream_data)::BaseType>
      stream_data_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& stream_data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_stream_data, stream_data_fragment, &stream_data_validate_params);
  params->stream_data.Set(
      stream_data_fragment.is_null() ? nullptr : stream_data_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->stream_data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null stream_data in StableCdmContext.ParseEncryptedSliceHeader request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StableCdmContext::Name_);
  message.set_method_name("ParseEncryptedSliceHeader");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new StableCdmContext_ParseEncryptedSliceHeader_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void StableCdmContextProxy::DecryptVideoBuffer(
    const ::scoped_refptr<::media::DecoderBuffer>& in_buffer, const std::vector<uint8_t>& in_bytes, DecryptVideoBufferCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::stable::mojom::StableCdmContext::DecryptVideoBuffer", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer"), in_buffer,
                        "<value of type const ::scoped_refptr<::media::DecoderBuffer>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bytes"), in_bytes,
                        "<value of type const std::vector<uint8_t>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::StableCdmContext::kDecryptVideoBuffer), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::stable::mojom::internal::StableCdmContext_DecryptVideoBuffer_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->buffer)::BaseType> buffer_fragment(
          params.message());
  mojo::internal::Serialize<::media::stable::mojom::DecoderBufferDataView>(
      in_buffer, buffer_fragment);
  params->buffer.Set(
      buffer_fragment.is_null() ? nullptr : buffer_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->buffer.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null buffer in StableCdmContext.DecryptVideoBuffer request");
  mojo::internal::MessageFragment<
      typename decltype(params->bytes)::BaseType>
      bytes_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& bytes_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_bytes, bytes_fragment, &bytes_validate_params);
  params->bytes.Set(
      bytes_fragment.is_null() ? nullptr : bytes_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->bytes.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null bytes in StableCdmContext.DecryptVideoBuffer request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StableCdmContext::Name_);
  message.set_method_name("DecryptVideoBuffer");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new StableCdmContext_DecryptVideoBuffer_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class StableCdmContext_GetHwKeyData_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static StableCdmContext::GetHwKeyDataCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<StableCdmContext_GetHwKeyData_ProxyToResponder> proxy(
        new StableCdmContext_GetHwKeyData_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&StableCdmContext_GetHwKeyData_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~StableCdmContext_GetHwKeyData_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  StableCdmContext_GetHwKeyData_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "StableCdmContext::GetHwKeyDataCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::media::Decryptor::Status in_status, const std::vector<uint8_t>& in_key_data);
};

bool StableCdmContext_GetHwKeyData_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::StableCdmContext_GetHwKeyData_ResponseParams_Data* params =
      reinterpret_cast<
          internal::StableCdmContext_GetHwKeyData_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for StableCdmContext.0
  bool success = true;
  ::media::Decryptor::Status p_status{};
  std::vector<uint8_t> p_key_data{};
  StableCdmContext_GetHwKeyData_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success && !input_data_view.ReadKeyData(&p_key_data))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        StableCdmContext::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_key_data));
  return true;
}

void StableCdmContext_GetHwKeyData_ProxyToResponder::Run(
    ::media::Decryptor::Status in_status, const std::vector<uint8_t>& in_key_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media::stable::mojom::StableCdmContext::GetHwKeyData", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::media::Decryptor::Status>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("key_data"), in_key_data,
                        "<value of type const std::vector<uint8_t>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::StableCdmContext::kGetHwKeyData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::stable::mojom::internal::StableCdmContext_GetHwKeyData_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::media::stable::mojom::DecryptStatus>(
      in_status, &params->status);
  mojo::internal::MessageFragment<
      typename decltype(params->key_data)::BaseType>
      key_data_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& key_data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_key_data, key_data_fragment, &key_data_validate_params);
  params->key_data.Set(
      key_data_fragment.is_null() ? nullptr : key_data_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->key_data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null key_data in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StableCdmContext::Name_);
  message.set_method_name("GetHwKeyData");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class StableCdmContext_GetHwConfigData_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static StableCdmContext::GetHwConfigDataCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<StableCdmContext_GetHwConfigData_ProxyToResponder> proxy(
        new StableCdmContext_GetHwConfigData_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&StableCdmContext_GetHwConfigData_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~StableCdmContext_GetHwConfigData_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  StableCdmContext_GetHwConfigData_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "StableCdmContext::GetHwConfigDataCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success, const std::vector<uint8_t>& in_config_data);
};

bool StableCdmContext_GetHwConfigData_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::StableCdmContext_GetHwConfigData_ResponseParams_Data* params =
      reinterpret_cast<
          internal::StableCdmContext_GetHwConfigData_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for StableCdmContext.2
  bool success = true;
  bool p_success{};
  std::vector<uint8_t> p_config_data{};
  StableCdmContext_GetHwConfigData_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (success && !input_data_view.ReadConfigData(&p_config_data))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        StableCdmContext::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success), 
std::move(p_config_data));
  return true;
}

void StableCdmContext_GetHwConfigData_ProxyToResponder::Run(
    bool in_success, const std::vector<uint8_t>& in_config_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media::stable::mojom::StableCdmContext::GetHwConfigData", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("config_data"), in_config_data,
                        "<value of type const std::vector<uint8_t>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::StableCdmContext::kGetHwConfigData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::stable::mojom::internal::StableCdmContext_GetHwConfigData_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->success = in_success;
  mojo::internal::MessageFragment<
      typename decltype(params->config_data)::BaseType>
      config_data_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& config_data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_config_data, config_data_fragment, &config_data_validate_params);
  params->config_data.Set(
      config_data_fragment.is_null() ? nullptr : config_data_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->config_data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null config_data in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StableCdmContext::Name_);
  message.set_method_name("GetHwConfigData");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class StableCdmContext_GetScreenResolutions_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static StableCdmContext::GetScreenResolutionsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<StableCdmContext_GetScreenResolutions_ProxyToResponder> proxy(
        new StableCdmContext_GetScreenResolutions_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&StableCdmContext_GetScreenResolutions_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~StableCdmContext_GetScreenResolutions_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  StableCdmContext_GetScreenResolutions_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "StableCdmContext::GetScreenResolutionsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::vector<::gfx::Size>& in_resolutions);
};

bool StableCdmContext_GetScreenResolutions_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::StableCdmContext_GetScreenResolutions_ResponseParams_Data* params =
      reinterpret_cast<
          internal::StableCdmContext_GetScreenResolutions_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for StableCdmContext.3
  bool success = true;
  std::vector<::gfx::Size> p_resolutions{};
  StableCdmContext_GetScreenResolutions_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResolutions(&p_resolutions))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        StableCdmContext::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_resolutions));
  return true;
}

void StableCdmContext_GetScreenResolutions_ProxyToResponder::Run(
    const std::vector<::gfx::Size>& in_resolutions) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media::stable::mojom::StableCdmContext::GetScreenResolutions", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("resolutions"), in_resolutions,
                        "<value of type const std::vector<::gfx::Size>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::StableCdmContext::kGetScreenResolutions), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::stable::mojom::internal::StableCdmContext_GetScreenResolutions_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->resolutions)::BaseType>
      resolutions_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& resolutions_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  mojo::internal::Serialize<mojo::ArrayDataView<::gfx::mojom::SizeDataView>>(
      in_resolutions, resolutions_fragment, &resolutions_validate_params);
  params->resolutions.Set(
      resolutions_fragment.is_null() ? nullptr : resolutions_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->resolutions.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null resolutions in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StableCdmContext::Name_);
  message.set_method_name("GetScreenResolutions");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class StableCdmContext_AllocateSecureBuffer_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static StableCdmContext::AllocateSecureBufferCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<StableCdmContext_AllocateSecureBuffer_ProxyToResponder> proxy(
        new StableCdmContext_AllocateSecureBuffer_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&StableCdmContext_AllocateSecureBuffer_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~StableCdmContext_AllocateSecureBuffer_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  StableCdmContext_AllocateSecureBuffer_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "StableCdmContext::AllocateSecureBufferCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::mojo::PlatformHandle in_secure_buffer);
};

bool StableCdmContext_AllocateSecureBuffer_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::StableCdmContext_AllocateSecureBuffer_ResponseParams_Data* params =
      reinterpret_cast<
          internal::StableCdmContext_AllocateSecureBuffer_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for StableCdmContext.4
  bool success = true;
  ::mojo::PlatformHandle p_secure_buffer{};
  StableCdmContext_AllocateSecureBuffer_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_secure_buffer = input_data_view.TakeSecureBuffer();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        StableCdmContext::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_secure_buffer));
  return true;
}

void StableCdmContext_AllocateSecureBuffer_ProxyToResponder::Run(
    ::mojo::PlatformHandle in_secure_buffer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media::stable::mojom::StableCdmContext::AllocateSecureBuffer", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("secure_buffer"), in_secure_buffer,
                        "<value of type ::mojo::PlatformHandle>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::StableCdmContext::kAllocateSecureBuffer), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::stable::mojom::internal::StableCdmContext_AllocateSecureBuffer_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::PlatformHandle>(
      in_secure_buffer, &params->secure_buffer, &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StableCdmContext::Name_);
  message.set_method_name("AllocateSecureBuffer");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class StableCdmContext_ParseEncryptedSliceHeader_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static StableCdmContext::ParseEncryptedSliceHeaderCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<StableCdmContext_ParseEncryptedSliceHeader_ProxyToResponder> proxy(
        new StableCdmContext_ParseEncryptedSliceHeader_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&StableCdmContext_ParseEncryptedSliceHeader_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~StableCdmContext_ParseEncryptedSliceHeader_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  StableCdmContext_ParseEncryptedSliceHeader_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "StableCdmContext::ParseEncryptedSliceHeaderCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success, const std::vector<uint8_t>& in_slice_header);
};

bool StableCdmContext_ParseEncryptedSliceHeader_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::StableCdmContext_ParseEncryptedSliceHeader_ResponseParams_Data* params =
      reinterpret_cast<
          internal::StableCdmContext_ParseEncryptedSliceHeader_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for StableCdmContext.5
  bool success = true;
  bool p_success{};
  std::vector<uint8_t> p_slice_header{};
  StableCdmContext_ParseEncryptedSliceHeader_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (success && !input_data_view.ReadSliceHeader(&p_slice_header))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        StableCdmContext::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success), 
std::move(p_slice_header));
  return true;
}

void StableCdmContext_ParseEncryptedSliceHeader_ProxyToResponder::Run(
    bool in_success, const std::vector<uint8_t>& in_slice_header) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media::stable::mojom::StableCdmContext::ParseEncryptedSliceHeader", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("slice_header"), in_slice_header,
                        "<value of type const std::vector<uint8_t>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::StableCdmContext::kParseEncryptedSliceHeader), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::stable::mojom::internal::StableCdmContext_ParseEncryptedSliceHeader_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->success = in_success;
  mojo::internal::MessageFragment<
      typename decltype(params->slice_header)::BaseType>
      slice_header_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& slice_header_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_slice_header, slice_header_fragment, &slice_header_validate_params);
  params->slice_header.Set(
      slice_header_fragment.is_null() ? nullptr : slice_header_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->slice_header.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null slice_header in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StableCdmContext::Name_);
  message.set_method_name("ParseEncryptedSliceHeader");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class StableCdmContext_DecryptVideoBuffer_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static StableCdmContext::DecryptVideoBufferCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<StableCdmContext_DecryptVideoBuffer_ProxyToResponder> proxy(
        new StableCdmContext_DecryptVideoBuffer_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&StableCdmContext_DecryptVideoBuffer_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~StableCdmContext_DecryptVideoBuffer_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  StableCdmContext_DecryptVideoBuffer_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "StableCdmContext::DecryptVideoBufferCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::media::Decryptor::Status in_status, const ::scoped_refptr<::media::DecoderBuffer>& in_decoder_buffer, const std::vector<uint8_t>& in_bytes);
};

bool StableCdmContext_DecryptVideoBuffer_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::StableCdmContext_DecryptVideoBuffer_ResponseParams_Data* params =
      reinterpret_cast<
          internal::StableCdmContext_DecryptVideoBuffer_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for StableCdmContext.6
  bool success = true;
  ::media::Decryptor::Status p_status{};
  ::scoped_refptr<::media::DecoderBuffer> p_decoder_buffer{};
  std::vector<uint8_t> p_bytes{};
  StableCdmContext_DecryptVideoBuffer_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success && !input_data_view.ReadDecoderBuffer(&p_decoder_buffer))
    success = false;
  if (success && !input_data_view.ReadBytes(&p_bytes))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        StableCdmContext::Name_, 6, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_decoder_buffer), 
std::move(p_bytes));
  return true;
}

void StableCdmContext_DecryptVideoBuffer_ProxyToResponder::Run(
    ::media::Decryptor::Status in_status, const ::scoped_refptr<::media::DecoderBuffer>& in_decoder_buffer, const std::vector<uint8_t>& in_bytes) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media::stable::mojom::StableCdmContext::DecryptVideoBuffer", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::media::Decryptor::Status>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("decoder_buffer"), in_decoder_buffer,
                        "<value of type const ::scoped_refptr<::media::DecoderBuffer>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bytes"), in_bytes,
                        "<value of type const std::vector<uint8_t>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::StableCdmContext::kDecryptVideoBuffer), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::stable::mojom::internal::StableCdmContext_DecryptVideoBuffer_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::media::stable::mojom::DecryptStatus>(
      in_status, &params->status);
  mojo::internal::MessageFragment<
      typename decltype(params->decoder_buffer)::BaseType> decoder_buffer_fragment(
          params.message());
  mojo::internal::Serialize<::media::stable::mojom::DecoderBufferDataView>(
      in_decoder_buffer, decoder_buffer_fragment);
  params->decoder_buffer.Set(
      decoder_buffer_fragment.is_null() ? nullptr : decoder_buffer_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->bytes)::BaseType>
      bytes_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& bytes_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_bytes, bytes_fragment, &bytes_validate_params);
  params->bytes.Set(
      bytes_fragment.is_null() ? nullptr : bytes_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->bytes.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null bytes in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StableCdmContext::Name_);
  message.set_method_name("DecryptVideoBuffer");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool StableCdmContextStubDispatch::Accept(
    StableCdmContext* impl,
    mojo::Message* message) {
  switch (static_cast<messages::StableCdmContext>(message->header()->name)) {
    case messages::StableCdmContext::kGetHwKeyData: {
      break;
    }
    case messages::StableCdmContext::kRegisterEventCallback: {
      DCHECK(message->is_serialized());
      internal::StableCdmContext_RegisterEventCallback_Params_Data* params =
          reinterpret_cast<internal::StableCdmContext_RegisterEventCallback_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for StableCdmContext.1
      bool success = true;
      ::mojo::PendingRemote<CdmContextEventCallback> p_callback{};
      StableCdmContext_RegisterEventCallback_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_callback =
            input_data_view.TakeCallback<decltype(p_callback)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            StableCdmContext::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RegisterEventCallback(        
        std::move(p_callback));
      return true;
    }
    case messages::StableCdmContext::kGetHwConfigData: {
      break;
    }
    case messages::StableCdmContext::kGetScreenResolutions: {
      break;
    }
    case messages::StableCdmContext::kAllocateSecureBuffer: {
      break;
    }
    case messages::StableCdmContext::kParseEncryptedSliceHeader: {
      break;
    }
    case messages::StableCdmContext::kDecryptVideoBuffer: {
      break;
    }
  }
  return false;
}

// static
bool StableCdmContextStubDispatch::AcceptWithResponder(
    StableCdmContext* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::StableCdmContext>(message->header()->name)) {
    case messages::StableCdmContext::kGetHwKeyData: {
      internal::StableCdmContext_GetHwKeyData_Params_Data* params =
          reinterpret_cast<
              internal::StableCdmContext_GetHwKeyData_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for StableCdmContext.0
      bool success = true;
      ::std::unique_ptr<::media::DecryptConfig> p_decrypt_config{};
      std::vector<uint8_t> p_hw_identifier{};
      StableCdmContext_GetHwKeyData_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDecryptConfig(&p_decrypt_config))
        success = false;
      if (success && !input_data_view.ReadHwIdentifier(&p_hw_identifier))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            StableCdmContext::Name_, 0, false);
        return false;
      }
      StableCdmContext::GetHwKeyDataCallback callback =
          StableCdmContext_GetHwKeyData_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetHwKeyData(        
        std::move(p_decrypt_config), 
        std::move(p_hw_identifier), std::move(callback));
      return true;
    }
    case messages::StableCdmContext::kRegisterEventCallback: {
      break;
    }
    case messages::StableCdmContext::kGetHwConfigData: {
      internal::StableCdmContext_GetHwConfigData_Params_Data* params =
          reinterpret_cast<
              internal::StableCdmContext_GetHwConfigData_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for StableCdmContext.2
      bool success = true;
      StableCdmContext_GetHwConfigData_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            StableCdmContext::Name_, 2, false);
        return false;
      }
      StableCdmContext::GetHwConfigDataCallback callback =
          StableCdmContext_GetHwConfigData_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetHwConfigData(std::move(callback));
      return true;
    }
    case messages::StableCdmContext::kGetScreenResolutions: {
      internal::StableCdmContext_GetScreenResolutions_Params_Data* params =
          reinterpret_cast<
              internal::StableCdmContext_GetScreenResolutions_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for StableCdmContext.3
      bool success = true;
      StableCdmContext_GetScreenResolutions_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            StableCdmContext::Name_, 3, false);
        return false;
      }
      StableCdmContext::GetScreenResolutionsCallback callback =
          StableCdmContext_GetScreenResolutions_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetScreenResolutions(std::move(callback));
      return true;
    }
    case messages::StableCdmContext::kAllocateSecureBuffer: {
      internal::StableCdmContext_AllocateSecureBuffer_Params_Data* params =
          reinterpret_cast<
              internal::StableCdmContext_AllocateSecureBuffer_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for StableCdmContext.4
      bool success = true;
      uint32_t p_size{};
      StableCdmContext_AllocateSecureBuffer_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_size = input_data_view.size();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            StableCdmContext::Name_, 4, false);
        return false;
      }
      StableCdmContext::AllocateSecureBufferCallback callback =
          StableCdmContext_AllocateSecureBuffer_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AllocateSecureBuffer(        
        std::move(p_size), std::move(callback));
      return true;
    }
    case messages::StableCdmContext::kParseEncryptedSliceHeader: {
      internal::StableCdmContext_ParseEncryptedSliceHeader_Params_Data* params =
          reinterpret_cast<
              internal::StableCdmContext_ParseEncryptedSliceHeader_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for StableCdmContext.5
      bool success = true;
      uint64_t p_secure_handle{};
      uint32_t p_offset{};
      std::vector<uint8_t> p_stream_data{};
      StableCdmContext_ParseEncryptedSliceHeader_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_secure_handle = input_data_view.secure_handle();
      if (success)
        p_offset = input_data_view.offset();
      if (success && !input_data_view.ReadStreamData(&p_stream_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            StableCdmContext::Name_, 5, false);
        return false;
      }
      StableCdmContext::ParseEncryptedSliceHeaderCallback callback =
          StableCdmContext_ParseEncryptedSliceHeader_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ParseEncryptedSliceHeader(        
        std::move(p_secure_handle), 
        std::move(p_offset), 
        std::move(p_stream_data), std::move(callback));
      return true;
    }
    case messages::StableCdmContext::kDecryptVideoBuffer: {
      internal::StableCdmContext_DecryptVideoBuffer_Params_Data* params =
          reinterpret_cast<
              internal::StableCdmContext_DecryptVideoBuffer_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for StableCdmContext.6
      bool success = true;
      ::scoped_refptr<::media::DecoderBuffer> p_buffer{};
      std::vector<uint8_t> p_bytes{};
      StableCdmContext_DecryptVideoBuffer_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBuffer(&p_buffer))
        success = false;
      if (success && !input_data_view.ReadBytes(&p_bytes))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            StableCdmContext::Name_, 6, false);
        return false;
      }
      StableCdmContext::DecryptVideoBufferCallback callback =
          StableCdmContext_DecryptVideoBuffer_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DecryptVideoBuffer(        
        std::move(p_buffer), 
        std::move(p_bytes), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kStableCdmContextValidationInfo[] = {
    { &internal::StableCdmContext_GetHwKeyData_Params_Data::Validate,
     &internal::StableCdmContext_GetHwKeyData_ResponseParams_Data::Validate},
    { &internal::StableCdmContext_RegisterEventCallback_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::StableCdmContext_GetHwConfigData_Params_Data::Validate,
     &internal::StableCdmContext_GetHwConfigData_ResponseParams_Data::Validate},
    { &internal::StableCdmContext_GetScreenResolutions_Params_Data::Validate,
     &internal::StableCdmContext_GetScreenResolutions_ResponseParams_Data::Validate},
    { &internal::StableCdmContext_AllocateSecureBuffer_Params_Data::Validate,
     &internal::StableCdmContext_AllocateSecureBuffer_ResponseParams_Data::Validate},
    { &internal::StableCdmContext_ParseEncryptedSliceHeader_Params_Data::Validate,
     &internal::StableCdmContext_ParseEncryptedSliceHeader_ResponseParams_Data::Validate},
    { &internal::StableCdmContext_DecryptVideoBuffer_Params_Data::Validate,
     &internal::StableCdmContext_DecryptVideoBuffer_ResponseParams_Data::Validate},
};

bool StableCdmContextRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::stable::mojom::StableCdmContext::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kStableCdmContextValidationInfo);
}

bool StableCdmContextResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::media::stable::mojom::StableCdmContext::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kStableCdmContextValidationInfo);
}
const char StableVideoDecoder::Name_[] = "media.stable.mojom.StableVideoDecoder";
constexpr base::Token StableVideoDecoder::Uuid_;

StableVideoDecoder::IPCStableHashFunction StableVideoDecoder::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::StableVideoDecoder>(message.name())) {
    case messages::StableVideoDecoder::kGetSupportedConfigs: {
      return &StableVideoDecoder::GetSupportedConfigs_Sym::IPCStableHash;
    }
    case messages::StableVideoDecoder::kConstruct: {
      return &StableVideoDecoder::Construct_Sym::IPCStableHash;
    }
    case messages::StableVideoDecoder::kInitialize: {
      return &StableVideoDecoder::Initialize_Sym::IPCStableHash;
    }
    case messages::StableVideoDecoder::kDecode: {
      return &StableVideoDecoder::Decode_Sym::IPCStableHash;
    }
    case messages::StableVideoDecoder::kReset: {
      return &StableVideoDecoder::Reset_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* StableVideoDecoder::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::StableVideoDecoder>(message.name())) {
      case messages::StableVideoDecoder::kGetSupportedConfigs:
            return "Receive media::stable::mojom::StableVideoDecoder::GetSupportedConfigs";
      case messages::StableVideoDecoder::kConstruct:
            return "Receive media::stable::mojom::StableVideoDecoder::Construct";
      case messages::StableVideoDecoder::kInitialize:
            return "Receive media::stable::mojom::StableVideoDecoder::Initialize";
      case messages::StableVideoDecoder::kDecode:
            return "Receive media::stable::mojom::StableVideoDecoder::Decode";
      case messages::StableVideoDecoder::kReset:
            return "Receive media::stable::mojom::StableVideoDecoder::Reset";
    }
  } else {
    switch (static_cast<messages::StableVideoDecoder>(message.name())) {
      case messages::StableVideoDecoder::kGetSupportedConfigs:
            return "Receive reply media::stable::mojom::StableVideoDecoder::GetSupportedConfigs";
      case messages::StableVideoDecoder::kConstruct:
            return "Receive reply media::stable::mojom::StableVideoDecoder::Construct";
      case messages::StableVideoDecoder::kInitialize:
            return "Receive reply media::stable::mojom::StableVideoDecoder::Initialize";
      case messages::StableVideoDecoder::kDecode:
            return "Receive reply media::stable::mojom::StableVideoDecoder::Decode";
      case messages::StableVideoDecoder::kReset:
            return "Receive reply media::stable::mojom::StableVideoDecoder::Reset";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t StableVideoDecoder::GetSupportedConfigs_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)media::stable::mojom::StableVideoDecoder::GetSupportedConfigs");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t StableVideoDecoder::Construct_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)media::stable::mojom::StableVideoDecoder::Construct");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t StableVideoDecoder::Initialize_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)media::stable::mojom::StableVideoDecoder::Initialize");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t StableVideoDecoder::Decode_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)media::stable::mojom::StableVideoDecoder::Decode");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t StableVideoDecoder::Reset_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)media::stable::mojom::StableVideoDecoder::Reset");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)
bool StableVideoDecoder::GetSupportedConfigs(std::vector<::media::SupportedVideoDecoderConfig>* out_supported_configs, ::media::VideoDecoderType* out_decoder_type) {
  NOTREACHED();
}
class StableVideoDecoder_GetSupportedConfigs_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  StableVideoDecoder_GetSupportedConfigs_HandleSyncResponse(
      bool* result, std::vector<::media::SupportedVideoDecoderConfig>* out_supported_configs, ::media::VideoDecoderType* out_decoder_type)
      : result_(result), out_supported_configs_(out_supported_configs), out_decoder_type_(out_decoder_type) {
    DCHECK(!*result_);
  }

  StableVideoDecoder_GetSupportedConfigs_HandleSyncResponse(const StableVideoDecoder_GetSupportedConfigs_HandleSyncResponse&) = delete;
  StableVideoDecoder_GetSupportedConfigs_HandleSyncResponse& operator=(const StableVideoDecoder_GetSupportedConfigs_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  std::vector<::media::SupportedVideoDecoderConfig>* out_supported_configs_;
  ::media::VideoDecoderType* out_decoder_type_;};

class StableVideoDecoder_GetSupportedConfigs_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  StableVideoDecoder_GetSupportedConfigs_ForwardToCallback(
      StableVideoDecoder::GetSupportedConfigsCallback callback
      ) : callback_(std::move(callback)) {
  }

  StableVideoDecoder_GetSupportedConfigs_ForwardToCallback(const StableVideoDecoder_GetSupportedConfigs_ForwardToCallback&) = delete;
  StableVideoDecoder_GetSupportedConfigs_ForwardToCallback& operator=(const StableVideoDecoder_GetSupportedConfigs_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  StableVideoDecoder::GetSupportedConfigsCallback callback_;
};

class StableVideoDecoder_Initialize_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  StableVideoDecoder_Initialize_ForwardToCallback(
      StableVideoDecoder::InitializeCallback callback
      ) : callback_(std::move(callback)) {
  }

  StableVideoDecoder_Initialize_ForwardToCallback(const StableVideoDecoder_Initialize_ForwardToCallback&) = delete;
  StableVideoDecoder_Initialize_ForwardToCallback& operator=(const StableVideoDecoder_Initialize_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  StableVideoDecoder::InitializeCallback callback_;
};

class StableVideoDecoder_Decode_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  StableVideoDecoder_Decode_ForwardToCallback(
      StableVideoDecoder::DecodeCallback callback
      ) : callback_(std::move(callback)) {
  }

  StableVideoDecoder_Decode_ForwardToCallback(const StableVideoDecoder_Decode_ForwardToCallback&) = delete;
  StableVideoDecoder_Decode_ForwardToCallback& operator=(const StableVideoDecoder_Decode_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  StableVideoDecoder::DecodeCallback callback_;
};

class StableVideoDecoder_Reset_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  StableVideoDecoder_Reset_ForwardToCallback(
      StableVideoDecoder::ResetCallback callback
      ) : callback_(std::move(callback)) {
  }

  StableVideoDecoder_Reset_ForwardToCallback(const StableVideoDecoder_Reset_ForwardToCallback&) = delete;
  StableVideoDecoder_Reset_ForwardToCallback& operator=(const StableVideoDecoder_Reset_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  StableVideoDecoder::ResetCallback callback_;
};

StableVideoDecoderProxy::StableVideoDecoderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}
bool StableVideoDecoderProxy::GetSupportedConfigs(
    std::vector<::media::SupportedVideoDecoderConfig>* out_param_supported_configs, ::media::VideoDecoderType* out_param_decoder_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "Call media::stable::mojom::StableVideoDecoder::GetSupportedConfigs (sync)");
#else
  TRACE_EVENT0("mojom", "StableVideoDecoder::GetSupportedConfigs");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::StableVideoDecoder::kGetSupportedConfigs), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::stable::mojom::internal::StableVideoDecoder_GetSupportedConfigs_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StableVideoDecoder::Name_);
  message.set_method_name("GetSupportedConfigs");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new StableVideoDecoder_GetSupportedConfigs_HandleSyncResponse(
          &result, out_param_supported_configs, out_param_decoder_type));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "StableVideoDecoder::GetSupportedConfigs", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("supported_configs"), out_param_supported_configs,
                        "<value of type const std::vector<::media::SupportedVideoDecoderConfig>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("decoder_type"), out_param_decoder_type,
                        "<value of type ::media::VideoDecoderType>");
   });
#endif
  return result;
}

void StableVideoDecoderProxy::GetSupportedConfigs(
    GetSupportedConfigsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media::stable::mojom::StableVideoDecoder::GetSupportedConfigs");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::StableVideoDecoder::kGetSupportedConfigs), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::stable::mojom::internal::StableVideoDecoder_GetSupportedConfigs_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StableVideoDecoder::Name_);
  message.set_method_name("GetSupportedConfigs");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new StableVideoDecoder_GetSupportedConfigs_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void StableVideoDecoderProxy::Construct(
    ::mojo::PendingAssociatedRemote<VideoDecoderClient> in_client, ::mojo::PendingRemote<MediaLog> in_media_log, ::mojo::PendingReceiver<VideoFrameHandleReleaser> in_video_frame_handle_releaser, ::mojo::ScopedDataPipeConsumerHandle in_decoder_buffer_pipe, const ::gfx::ColorSpace& in_target_color_space) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::stable::mojom::StableVideoDecoder::Construct", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingAssociatedRemote<VideoDecoderClient>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("media_log"), in_media_log,
                        "<value of type ::mojo::PendingRemote<MediaLog>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("video_frame_handle_releaser"), in_video_frame_handle_releaser,
                        "<value of type ::mojo::PendingReceiver<VideoFrameHandleReleaser>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("decoder_buffer_pipe"), in_decoder_buffer_pipe,
                        "<value of type ::mojo::ScopedDataPipeConsumerHandle>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("target_color_space"), in_target_color_space,
                        "<value of type const ::gfx::ColorSpace&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::StableVideoDecoder::kConstruct), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::stable::mojom::internal::StableVideoDecoder_Construct_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::media::stable::mojom::VideoDecoderClientAssociatedPtrInfoDataView>(
      in_client, &params->client, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid client in StableVideoDecoder.Construct request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::media::stable::mojom::MediaLogInterfaceBase>>(
      in_media_log, &params->media_log, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->media_log),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid media_log in StableVideoDecoder.Construct request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media::stable::mojom::VideoFrameHandleReleaserInterfaceBase>>(
      in_video_frame_handle_releaser, &params->video_frame_handle_releaser, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->video_frame_handle_releaser),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid video_frame_handle_releaser in StableVideoDecoder.Construct request");
  mojo::internal::Serialize<mojo::ScopedDataPipeConsumerHandle>(
      in_decoder_buffer_pipe, &params->decoder_buffer_pipe, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->decoder_buffer_pipe),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid decoder_buffer_pipe in StableVideoDecoder.Construct request");
  mojo::internal::MessageFragment<
      typename decltype(params->target_color_space)::BaseType> target_color_space_fragment(
          params.message());
  mojo::internal::Serialize<::media::stable::mojom::ColorSpaceDataView>(
      in_target_color_space, target_color_space_fragment);
  params->target_color_space.Set(
      target_color_space_fragment.is_null() ? nullptr : target_color_space_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->target_color_space.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null target_color_space in StableVideoDecoder.Construct request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StableVideoDecoder::Name_);
  message.set_method_name("Construct");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void StableVideoDecoderProxy::Initialize(
    const ::media::VideoDecoderConfig& in_config, bool in_low_delay, ::mojo::PendingRemote<StableCdmContext> in_cdm_context, InitializeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::stable::mojom::StableVideoDecoder::Initialize", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("config"), in_config,
                        "<value of type const ::media::VideoDecoderConfig&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("low_delay"), in_low_delay,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cdm_context"), in_cdm_context,
                        "<value of type ::mojo::PendingRemote<StableCdmContext>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::StableVideoDecoder::kInitialize), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::stable::mojom::internal::StableVideoDecoder_Initialize_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->config)::BaseType> config_fragment(
          params.message());
  mojo::internal::Serialize<::media::stable::mojom::VideoDecoderConfigDataView>(
      in_config, config_fragment);
  params->config.Set(
      config_fragment.is_null() ? nullptr : config_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->config.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null config in StableVideoDecoder.Initialize request");
  params->low_delay = in_low_delay;
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::media::stable::mojom::StableCdmContextInterfaceBase>>(
      in_cdm_context, &params->cdm_context, &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StableVideoDecoder::Name_);
  message.set_method_name("Initialize");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new StableVideoDecoder_Initialize_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void StableVideoDecoderProxy::Decode(
    const ::scoped_refptr<::media::DecoderBuffer>& in_buffer, DecodeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::stable::mojom::StableVideoDecoder::Decode", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer"), in_buffer,
                        "<value of type const ::scoped_refptr<::media::DecoderBuffer>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::StableVideoDecoder::kDecode), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::stable::mojom::internal::StableVideoDecoder_Decode_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->buffer)::BaseType> buffer_fragment(
          params.message());
  mojo::internal::Serialize<::media::stable::mojom::DecoderBufferDataView>(
      in_buffer, buffer_fragment);
  params->buffer.Set(
      buffer_fragment.is_null() ? nullptr : buffer_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->buffer.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null buffer in StableVideoDecoder.Decode request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StableVideoDecoder::Name_);
  message.set_method_name("Decode");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new StableVideoDecoder_Decode_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void StableVideoDecoderProxy::Reset(
    ResetCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media::stable::mojom::StableVideoDecoder::Reset");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::StableVideoDecoder::kReset), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::stable::mojom::internal::StableVideoDecoder_Reset_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StableVideoDecoder::Name_);
  message.set_method_name("Reset");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new StableVideoDecoder_Reset_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class StableVideoDecoder_GetSupportedConfigs_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static StableVideoDecoder::GetSupportedConfigsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<StableVideoDecoder_GetSupportedConfigs_ProxyToResponder> proxy(
        new StableVideoDecoder_GetSupportedConfigs_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&StableVideoDecoder_GetSupportedConfigs_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~StableVideoDecoder_GetSupportedConfigs_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  StableVideoDecoder_GetSupportedConfigs_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "StableVideoDecoder::GetSupportedConfigsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::vector<::media::SupportedVideoDecoderConfig>& in_supported_configs, ::media::VideoDecoderType in_decoder_type);
};

bool StableVideoDecoder_GetSupportedConfigs_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::StableVideoDecoder_GetSupportedConfigs_ResponseParams_Data* params =
      reinterpret_cast<
          internal::StableVideoDecoder_GetSupportedConfigs_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for StableVideoDecoder.0
  bool success = true;
  std::vector<::media::SupportedVideoDecoderConfig> p_supported_configs{};
  ::media::VideoDecoderType p_decoder_type{};
  StableVideoDecoder_GetSupportedConfigs_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadSupportedConfigs(&p_supported_configs))
    success = false;
  if (success && !input_data_view.ReadDecoderType(&p_decoder_type))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        StableVideoDecoder::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_supported_configs), 
std::move(p_decoder_type));
  return true;
}

void StableVideoDecoder_GetSupportedConfigs_ProxyToResponder::Run(
    const std::vector<::media::SupportedVideoDecoderConfig>& in_supported_configs, ::media::VideoDecoderType in_decoder_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media::stable::mojom::StableVideoDecoder::GetSupportedConfigs", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("supported_configs"), in_supported_configs,
                        "<value of type const std::vector<::media::SupportedVideoDecoderConfig>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("decoder_type"), in_decoder_type,
                        "<value of type ::media::VideoDecoderType>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::StableVideoDecoder::kGetSupportedConfigs), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::stable::mojom::internal::StableVideoDecoder_GetSupportedConfigs_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->supported_configs)::BaseType>
      supported_configs_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& supported_configs_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  mojo::internal::Serialize<mojo::ArrayDataView<::media::stable::mojom::SupportedVideoDecoderConfigDataView>>(
      in_supported_configs, supported_configs_fragment, &supported_configs_validate_params);
  params->supported_configs.Set(
      supported_configs_fragment.is_null() ? nullptr : supported_configs_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->supported_configs.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null supported_configs in ");
  mojo::internal::Serialize<::media::stable::mojom::VideoDecoderType>(
      in_decoder_type, &params->decoder_type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StableVideoDecoder::Name_);
  message.set_method_name("GetSupportedConfigs");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool StableVideoDecoder_GetSupportedConfigs_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::StableVideoDecoder_GetSupportedConfigs_ResponseParams_Data* params =
      reinterpret_cast<internal::StableVideoDecoder_GetSupportedConfigs_ResponseParams_Data*>(
          message->mutable_payload());
  
  
  // Validation for StableVideoDecoder.0
  bool success = true;
  std::vector<::media::SupportedVideoDecoderConfig> p_supported_configs{};
  ::media::VideoDecoderType p_decoder_type{};
  StableVideoDecoder_GetSupportedConfigs_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadSupportedConfigs(&p_supported_configs))
    success = false;
  if (success && !input_data_view.ReadDecoderType(&p_decoder_type))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        StableVideoDecoder::Name_, 0, true);
    return false;
  }
  *out_supported_configs_ = std::move(p_supported_configs);
  *out_decoder_type_ = std::move(p_decoder_type);
  *result_ = true;
  return true;
}
class StableVideoDecoder_Initialize_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static StableVideoDecoder::InitializeCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<StableVideoDecoder_Initialize_ProxyToResponder> proxy(
        new StableVideoDecoder_Initialize_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&StableVideoDecoder_Initialize_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~StableVideoDecoder_Initialize_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  StableVideoDecoder_Initialize_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "StableVideoDecoder::InitializeCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::media::DecoderStatus& in_status, bool in_needs_bitstream_conversion, int32_t in_max_decode_requests, ::media::VideoDecoderType in_decoder_type, bool in_needs_transcryption);
};

bool StableVideoDecoder_Initialize_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::StableVideoDecoder_Initialize_ResponseParams_Data* params =
      reinterpret_cast<
          internal::StableVideoDecoder_Initialize_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for StableVideoDecoder.2
  bool success = true;
  ::media::DecoderStatus p_status{};
  bool p_needs_bitstream_conversion{};
  int32_t p_max_decode_requests{};
  ::media::VideoDecoderType p_decoder_type{};
  bool p_needs_transcryption{};
  StableVideoDecoder_Initialize_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success)
    p_needs_bitstream_conversion = input_data_view.needs_bitstream_conversion();
  if (success)
    p_max_decode_requests = input_data_view.max_decode_requests();
  if (success && !input_data_view.ReadDecoderType(&p_decoder_type))
    success = false;
  if (success)
    p_needs_transcryption = input_data_view.needs_transcryption();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        StableVideoDecoder::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_needs_bitstream_conversion), 
std::move(p_max_decode_requests), 
std::move(p_decoder_type), 
std::move(p_needs_transcryption));
  return true;
}

void StableVideoDecoder_Initialize_ProxyToResponder::Run(
    const ::media::DecoderStatus& in_status, bool in_needs_bitstream_conversion, int32_t in_max_decode_requests, ::media::VideoDecoderType in_decoder_type, bool in_needs_transcryption) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media::stable::mojom::StableVideoDecoder::Initialize", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type const ::media::DecoderStatus&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("needs_bitstream_conversion"), in_needs_bitstream_conversion,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("max_decode_requests"), in_max_decode_requests,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("decoder_type"), in_decoder_type,
                        "<value of type ::media::VideoDecoderType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("needs_transcryption"), in_needs_transcryption,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::StableVideoDecoder::kInitialize), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::stable::mojom::internal::StableVideoDecoder_Initialize_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->status)::BaseType> status_fragment(
          params.message());
  mojo::internal::Serialize<::media::stable::mojom::StatusDataView>(
      in_status, status_fragment);
  params->status.Set(
      status_fragment.is_null() ? nullptr : status_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->status.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null status in ");
  params->needs_bitstream_conversion = in_needs_bitstream_conversion;
  params->max_decode_requests = in_max_decode_requests;
  mojo::internal::Serialize<::media::stable::mojom::VideoDecoderType>(
      in_decoder_type, &params->decoder_type);
  params->needs_transcryption = in_needs_transcryption;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StableVideoDecoder::Name_);
  message.set_method_name("Initialize");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class StableVideoDecoder_Decode_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static StableVideoDecoder::DecodeCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<StableVideoDecoder_Decode_ProxyToResponder> proxy(
        new StableVideoDecoder_Decode_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&StableVideoDecoder_Decode_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~StableVideoDecoder_Decode_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  StableVideoDecoder_Decode_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "StableVideoDecoder::DecodeCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::media::DecoderStatus& in_status);
};

bool StableVideoDecoder_Decode_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::StableVideoDecoder_Decode_ResponseParams_Data* params =
      reinterpret_cast<
          internal::StableVideoDecoder_Decode_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for StableVideoDecoder.3
  bool success = true;
  ::media::DecoderStatus p_status{};
  StableVideoDecoder_Decode_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        StableVideoDecoder::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status));
  return true;
}

void StableVideoDecoder_Decode_ProxyToResponder::Run(
    const ::media::DecoderStatus& in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media::stable::mojom::StableVideoDecoder::Decode", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type const ::media::DecoderStatus&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::StableVideoDecoder::kDecode), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::stable::mojom::internal::StableVideoDecoder_Decode_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->status)::BaseType> status_fragment(
          params.message());
  mojo::internal::Serialize<::media::stable::mojom::StatusDataView>(
      in_status, status_fragment);
  params->status.Set(
      status_fragment.is_null() ? nullptr : status_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->status.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null status in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StableVideoDecoder::Name_);
  message.set_method_name("Decode");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class StableVideoDecoder_Reset_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static StableVideoDecoder::ResetCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<StableVideoDecoder_Reset_ProxyToResponder> proxy(
        new StableVideoDecoder_Reset_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&StableVideoDecoder_Reset_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~StableVideoDecoder_Reset_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  StableVideoDecoder_Reset_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "StableVideoDecoder::ResetCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool StableVideoDecoder_Reset_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::StableVideoDecoder_Reset_ResponseParams_Data* params =
      reinterpret_cast<
          internal::StableVideoDecoder_Reset_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for StableVideoDecoder.4
  bool success = true;
  StableVideoDecoder_Reset_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        StableVideoDecoder::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void StableVideoDecoder_Reset_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply media::stable::mojom::StableVideoDecoder::Reset");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::StableVideoDecoder::kReset), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::stable::mojom::internal::StableVideoDecoder_Reset_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StableVideoDecoder::Name_);
  message.set_method_name("Reset");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool StableVideoDecoderStubDispatch::Accept(
    StableVideoDecoder* impl,
    mojo::Message* message) {
  switch (static_cast<messages::StableVideoDecoder>(message->header()->name)) {
    case messages::StableVideoDecoder::kGetSupportedConfigs: {
      break;
    }
    case messages::StableVideoDecoder::kConstruct: {
      DCHECK(message->is_serialized());
      internal::StableVideoDecoder_Construct_Params_Data* params =
          reinterpret_cast<internal::StableVideoDecoder_Construct_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for StableVideoDecoder.1
      bool success = true;
      ::mojo::PendingAssociatedRemote<VideoDecoderClient> p_client{};
      ::mojo::PendingRemote<MediaLog> p_media_log{};
      ::mojo::PendingReceiver<VideoFrameHandleReleaser> p_video_frame_handle_releaser{};
      ::mojo::ScopedDataPipeConsumerHandle p_decoder_buffer_pipe{};
      ::gfx::ColorSpace p_target_color_space{};
      StableVideoDecoder_Construct_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (success) {
        p_media_log =
            input_data_view.TakeMediaLog<decltype(p_media_log)>();
      }
      if (success) {
        p_video_frame_handle_releaser =
            input_data_view.TakeVideoFrameHandleReleaser<decltype(p_video_frame_handle_releaser)>();
      }
      if (success)
        p_decoder_buffer_pipe = input_data_view.TakeDecoderBufferPipe();
      if (success && !input_data_view.ReadTargetColorSpace(&p_target_color_space))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            StableVideoDecoder::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Construct(        
        std::move(p_client), 
        std::move(p_media_log), 
        std::move(p_video_frame_handle_releaser), 
        std::move(p_decoder_buffer_pipe), 
        std::move(p_target_color_space));
      return true;
    }
    case messages::StableVideoDecoder::kInitialize: {
      break;
    }
    case messages::StableVideoDecoder::kDecode: {
      break;
    }
    case messages::StableVideoDecoder::kReset: {
      break;
    }
  }
  return false;
}

// static
bool StableVideoDecoderStubDispatch::AcceptWithResponder(
    StableVideoDecoder* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::StableVideoDecoder>(message->header()->name)) {
    case messages::StableVideoDecoder::kGetSupportedConfigs: {
      internal::StableVideoDecoder_GetSupportedConfigs_Params_Data* params =
          reinterpret_cast<
              internal::StableVideoDecoder_GetSupportedConfigs_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for StableVideoDecoder.0
      bool success = true;
      StableVideoDecoder_GetSupportedConfigs_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            StableVideoDecoder::Name_, 0, false);
        return false;
      }
      StableVideoDecoder::GetSupportedConfigsCallback callback =
          StableVideoDecoder_GetSupportedConfigs_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetSupportedConfigs(std::move(callback));
      return true;
    }
    case messages::StableVideoDecoder::kConstruct: {
      break;
    }
    case messages::StableVideoDecoder::kInitialize: {
      internal::StableVideoDecoder_Initialize_Params_Data* params =
          reinterpret_cast<
              internal::StableVideoDecoder_Initialize_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for StableVideoDecoder.2
      bool success = true;
      ::media::VideoDecoderConfig p_config{};
      bool p_low_delay{};
      ::mojo::PendingRemote<StableCdmContext> p_cdm_context{};
      StableVideoDecoder_Initialize_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadConfig(&p_config))
        success = false;
      if (success)
        p_low_delay = input_data_view.low_delay();
      if (success) {
        p_cdm_context =
            input_data_view.TakeCdmContext<decltype(p_cdm_context)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            StableVideoDecoder::Name_, 2, false);
        return false;
      }
      StableVideoDecoder::InitializeCallback callback =
          StableVideoDecoder_Initialize_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Initialize(        
        std::move(p_config), 
        std::move(p_low_delay), 
        std::move(p_cdm_context), std::move(callback));
      return true;
    }
    case messages::StableVideoDecoder::kDecode: {
      internal::StableVideoDecoder_Decode_Params_Data* params =
          reinterpret_cast<
              internal::StableVideoDecoder_Decode_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for StableVideoDecoder.3
      bool success = true;
      ::scoped_refptr<::media::DecoderBuffer> p_buffer{};
      StableVideoDecoder_Decode_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBuffer(&p_buffer))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            StableVideoDecoder::Name_, 3, false);
        return false;
      }
      StableVideoDecoder::DecodeCallback callback =
          StableVideoDecoder_Decode_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Decode(        
        std::move(p_buffer), std::move(callback));
      return true;
    }
    case messages::StableVideoDecoder::kReset: {
      internal::StableVideoDecoder_Reset_Params_Data* params =
          reinterpret_cast<
              internal::StableVideoDecoder_Reset_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for StableVideoDecoder.4
      bool success = true;
      StableVideoDecoder_Reset_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            StableVideoDecoder::Name_, 4, false);
        return false;
      }
      StableVideoDecoder::ResetCallback callback =
          StableVideoDecoder_Reset_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Reset(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kStableVideoDecoderValidationInfo[] = {
    { &internal::StableVideoDecoder_GetSupportedConfigs_Params_Data::Validate,
     &internal::StableVideoDecoder_GetSupportedConfigs_ResponseParams_Data::Validate},
    { &internal::StableVideoDecoder_Construct_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::StableVideoDecoder_Initialize_Params_Data::Validate,
     &internal::StableVideoDecoder_Initialize_ResponseParams_Data::Validate},
    { &internal::StableVideoDecoder_Decode_Params_Data::Validate,
     &internal::StableVideoDecoder_Decode_ResponseParams_Data::Validate},
    { &internal::StableVideoDecoder_Reset_Params_Data::Validate,
     &internal::StableVideoDecoder_Reset_ResponseParams_Data::Validate},
};

bool StableVideoDecoderRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::stable::mojom::StableVideoDecoder::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kStableVideoDecoderValidationInfo);
}

bool StableVideoDecoderResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::media::stable::mojom::StableVideoDecoder::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kStableVideoDecoderValidationInfo);
}
const char StableVideoDecoderTracker::Name_[] = "media.stable.mojom.StableVideoDecoderTracker";
constexpr base::Token StableVideoDecoderTracker::Uuid_;

StableVideoDecoderTracker::IPCStableHashFunction StableVideoDecoderTracker::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* StableVideoDecoderTracker::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
# endif // !BUILDFLAG(IS_FUCHSIA)

StableVideoDecoderTrackerProxy::StableVideoDecoderTrackerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

// static
bool StableVideoDecoderTrackerStubDispatch::Accept(
    StableVideoDecoderTracker* impl,
    mojo::Message* message) {
  return false;
}

// static
bool StableVideoDecoderTrackerStubDispatch::AcceptWithResponder(
    StableVideoDecoderTracker* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  return false;
}
namespace {
}  // namespace

bool StableVideoDecoderTrackerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::stable::mojom::StableVideoDecoderTracker::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, {});
}

const char StableVideoDecoderFactory::Name_[] = "media.stable.mojom.StableVideoDecoderFactory";
constexpr base::Token StableVideoDecoderFactory::Uuid_;

StableVideoDecoderFactory::IPCStableHashFunction StableVideoDecoderFactory::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::StableVideoDecoderFactory>(message.name())) {
    case messages::StableVideoDecoderFactory::kCreateStableVideoDecoder: {
      return &StableVideoDecoderFactory::CreateStableVideoDecoder_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* StableVideoDecoderFactory::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::StableVideoDecoderFactory>(message.name())) {
      case messages::StableVideoDecoderFactory::kCreateStableVideoDecoder:
            return "Receive media::stable::mojom::StableVideoDecoderFactory::CreateStableVideoDecoder";
    }
  } else {
    switch (static_cast<messages::StableVideoDecoderFactory>(message.name())) {
      case messages::StableVideoDecoderFactory::kCreateStableVideoDecoder:
            return "Receive reply media::stable::mojom::StableVideoDecoderFactory::CreateStableVideoDecoder";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t StableVideoDecoderFactory::CreateStableVideoDecoder_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)media::stable::mojom::StableVideoDecoderFactory::CreateStableVideoDecoder");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

StableVideoDecoderFactoryProxy::StableVideoDecoderFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void StableVideoDecoderFactoryProxy::CreateStableVideoDecoder(
    ::mojo::PendingReceiver<StableVideoDecoder> in_receiver, ::mojo::PendingRemote<StableVideoDecoderTracker> in_tracker) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::stable::mojom::StableVideoDecoderFactory::CreateStableVideoDecoder", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<StableVideoDecoder>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tracker"), in_tracker,
                        "<value of type ::mojo::PendingRemote<StableVideoDecoderTracker>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::StableVideoDecoderFactory::kCreateStableVideoDecoder), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::stable::mojom::internal::StableVideoDecoderFactory_CreateStableVideoDecoder_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media::stable::mojom::StableVideoDecoderInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in StableVideoDecoderFactory.CreateStableVideoDecoder request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::media::stable::mojom::StableVideoDecoderTrackerInterfaceBase>>(
      in_tracker, &params->tracker, &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StableVideoDecoderFactory::Name_);
  message.set_method_name("CreateStableVideoDecoder");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool StableVideoDecoderFactoryStubDispatch::Accept(
    StableVideoDecoderFactory* impl,
    mojo::Message* message) {
  switch (static_cast<messages::StableVideoDecoderFactory>(message->header()->name)) {
    case messages::StableVideoDecoderFactory::kCreateStableVideoDecoder: {
      DCHECK(message->is_serialized());
      internal::StableVideoDecoderFactory_CreateStableVideoDecoder_Params_Data* params =
          reinterpret_cast<internal::StableVideoDecoderFactory_CreateStableVideoDecoder_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for StableVideoDecoderFactory.0
      bool success = true;
      ::mojo::PendingReceiver<StableVideoDecoder> p_receiver{};
      ::mojo::PendingRemote<StableVideoDecoderTracker> p_tracker{};
      StableVideoDecoderFactory_CreateStableVideoDecoder_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (success) {
        p_tracker =
            input_data_view.TakeTracker<decltype(p_tracker)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            StableVideoDecoderFactory::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateStableVideoDecoder(        
        std::move(p_receiver), 
        std::move(p_tracker));
      return true;
    }
  }
  return false;
}

// static
bool StableVideoDecoderFactoryStubDispatch::AcceptWithResponder(
    StableVideoDecoderFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::StableVideoDecoderFactory>(message->header()->name)) {
    case messages::StableVideoDecoderFactory::kCreateStableVideoDecoder: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kStableVideoDecoderFactoryValidationInfo[] = {
    { &internal::StableVideoDecoderFactory_CreateStableVideoDecoder_Params_Data::Validate,
     nullptr /* no response */},
};

bool StableVideoDecoderFactoryRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::stable::mojom::StableVideoDecoderFactory::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kStableVideoDecoderFactoryValidationInfo);
}

const char StableVideoDecoderFactoryProcess::Name_[] = "media.stable.mojom.StableVideoDecoderFactoryProcess";

StableVideoDecoderFactoryProcess::IPCStableHashFunction StableVideoDecoderFactoryProcess::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::StableVideoDecoderFactoryProcess>(message.name())) {
    case messages::StableVideoDecoderFactoryProcess::kInitializeStableVideoDecoderFactory: {
      return &StableVideoDecoderFactoryProcess::InitializeStableVideoDecoderFactory_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* StableVideoDecoderFactoryProcess::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::StableVideoDecoderFactoryProcess>(message.name())) {
      case messages::StableVideoDecoderFactoryProcess::kInitializeStableVideoDecoderFactory:
            return "Receive media::stable::mojom::StableVideoDecoderFactoryProcess::InitializeStableVideoDecoderFactory";
    }
  } else {
    switch (static_cast<messages::StableVideoDecoderFactoryProcess>(message.name())) {
      case messages::StableVideoDecoderFactoryProcess::kInitializeStableVideoDecoderFactory:
            return "Receive reply media::stable::mojom::StableVideoDecoderFactoryProcess::InitializeStableVideoDecoderFactory";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t StableVideoDecoderFactoryProcess::InitializeStableVideoDecoderFactory_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)media::stable::mojom::StableVideoDecoderFactoryProcess::InitializeStableVideoDecoderFactory");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

StableVideoDecoderFactoryProcessProxy::StableVideoDecoderFactoryProcessProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void StableVideoDecoderFactoryProcessProxy::InitializeStableVideoDecoderFactory(
    const ::gpu::GpuFeatureInfo& in_gpu_feature_info, ::mojo::PendingReceiver<StableVideoDecoderFactory> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::stable::mojom::StableVideoDecoderFactoryProcess::InitializeStableVideoDecoderFactory", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("gpu_feature_info"), in_gpu_feature_info,
                        "<value of type const ::gpu::GpuFeatureInfo&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<StableVideoDecoderFactory>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::StableVideoDecoderFactoryProcess::kInitializeStableVideoDecoderFactory), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::stable::mojom::internal::StableVideoDecoderFactoryProcess_InitializeStableVideoDecoderFactory_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->gpu_feature_info)::BaseType> gpu_feature_info_fragment(
          params.message());
  mojo::internal::Serialize<::gpu::mojom::GpuFeatureInfoDataView>(
      in_gpu_feature_info, gpu_feature_info_fragment);
  params->gpu_feature_info.Set(
      gpu_feature_info_fragment.is_null() ? nullptr : gpu_feature_info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->gpu_feature_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null gpu_feature_info in StableVideoDecoderFactoryProcess.InitializeStableVideoDecoderFactory request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media::stable::mojom::StableVideoDecoderFactoryInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in StableVideoDecoderFactoryProcess.InitializeStableVideoDecoderFactory request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StableVideoDecoderFactoryProcess::Name_);
  message.set_method_name("InitializeStableVideoDecoderFactory");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool StableVideoDecoderFactoryProcessStubDispatch::Accept(
    StableVideoDecoderFactoryProcess* impl,
    mojo::Message* message) {
  switch (static_cast<messages::StableVideoDecoderFactoryProcess>(message->header()->name)) {
    case messages::StableVideoDecoderFactoryProcess::kInitializeStableVideoDecoderFactory: {
      DCHECK(message->is_serialized());
      internal::StableVideoDecoderFactoryProcess_InitializeStableVideoDecoderFactory_Params_Data* params =
          reinterpret_cast<internal::StableVideoDecoderFactoryProcess_InitializeStableVideoDecoderFactory_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for StableVideoDecoderFactoryProcess.0
      bool success = true;
      ::gpu::GpuFeatureInfo p_gpu_feature_info{};
      ::mojo::PendingReceiver<StableVideoDecoderFactory> p_receiver{};
      StableVideoDecoderFactoryProcess_InitializeStableVideoDecoderFactory_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadGpuFeatureInfo(&p_gpu_feature_info))
        success = false;
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            StableVideoDecoderFactoryProcess::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->InitializeStableVideoDecoderFactory(        
        std::move(p_gpu_feature_info), 
        std::move(p_receiver));
      return true;
    }
  }
  return false;
}

// static
bool StableVideoDecoderFactoryProcessStubDispatch::AcceptWithResponder(
    StableVideoDecoderFactoryProcess* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::StableVideoDecoderFactoryProcess>(message->header()->name)) {
    case messages::StableVideoDecoderFactoryProcess::kInitializeStableVideoDecoderFactory: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kStableVideoDecoderFactoryProcessValidationInfo[] = {
    {base::to_underlying(messages::StableVideoDecoderFactoryProcess::kInitializeStableVideoDecoderFactory),
     { &internal::StableVideoDecoderFactoryProcess_InitializeStableVideoDecoderFactory_Params_Data::Validate,
      nullptr /* no response */}},
};

bool StableVideoDecoderFactoryProcessRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::stable::mojom::StableVideoDecoderFactoryProcess::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kStableVideoDecoderFactoryProcessValidationInfo);
}



}  // media::stable::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace media::stable::mojom {


void MediaLogInterceptorForTesting::AddLogRecord(const ::media::MediaLogRecord& event) {
  GetForwardingInterface()->AddLogRecord(
    std::move(event)
    );
}
MediaLogAsyncWaiter::MediaLogAsyncWaiter(
    MediaLog* proxy) : proxy_(proxy) {}

MediaLogAsyncWaiter::~MediaLogAsyncWaiter() = default;




void VideoFrameHandleReleaserInterceptorForTesting::ReleaseVideoFrame(const ::base::UnguessableToken& release_token) {
  GetForwardingInterface()->ReleaseVideoFrame(
    std::move(release_token)
    );
}
VideoFrameHandleReleaserAsyncWaiter::VideoFrameHandleReleaserAsyncWaiter(
    VideoFrameHandleReleaser* proxy) : proxy_(proxy) {}

VideoFrameHandleReleaserAsyncWaiter::~VideoFrameHandleReleaserAsyncWaiter() = default;




void VideoDecoderClientInterceptorForTesting::OnVideoFrameDecoded(::media::stable::mojom::VideoFramePtr frame, bool can_read_without_stalling, const ::base::UnguessableToken& release_token) {
  GetForwardingInterface()->OnVideoFrameDecoded(
    std::move(frame)
    , 
    std::move(can_read_without_stalling)
    , 
    std::move(release_token)
    );
}
void VideoDecoderClientInterceptorForTesting::OnWaiting(::media::WaitingReason reason) {
  GetForwardingInterface()->OnWaiting(
    std::move(reason)
    );
}
VideoDecoderClientAsyncWaiter::VideoDecoderClientAsyncWaiter(
    VideoDecoderClient* proxy) : proxy_(proxy) {}

VideoDecoderClientAsyncWaiter::~VideoDecoderClientAsyncWaiter() = default;




void CdmContextEventCallbackInterceptorForTesting::EventCallback(::media::CdmContext::Event event) {
  GetForwardingInterface()->EventCallback(
    std::move(event)
    );
}
CdmContextEventCallbackAsyncWaiter::CdmContextEventCallbackAsyncWaiter(
    CdmContextEventCallback* proxy) : proxy_(proxy) {}

CdmContextEventCallbackAsyncWaiter::~CdmContextEventCallbackAsyncWaiter() = default;




void StableCdmContextInterceptorForTesting::GetHwKeyData(::std::unique_ptr<::media::DecryptConfig> decrypt_config, const std::vector<uint8_t>& hw_identifier, GetHwKeyDataCallback callback) {
  GetForwardingInterface()->GetHwKeyData(
    std::move(decrypt_config)
    , 
    std::move(hw_identifier)
    , std::move(callback));
}
void StableCdmContextInterceptorForTesting::RegisterEventCallback(::mojo::PendingRemote<CdmContextEventCallback> callback) {
  GetForwardingInterface()->RegisterEventCallback(
    std::move(callback)
    );
}
void StableCdmContextInterceptorForTesting::GetHwConfigData(GetHwConfigDataCallback callback) {
  GetForwardingInterface()->GetHwConfigData(std::move(callback));
}
void StableCdmContextInterceptorForTesting::GetScreenResolutions(GetScreenResolutionsCallback callback) {
  GetForwardingInterface()->GetScreenResolutions(std::move(callback));
}
void StableCdmContextInterceptorForTesting::AllocateSecureBuffer(uint32_t size, AllocateSecureBufferCallback callback) {
  GetForwardingInterface()->AllocateSecureBuffer(
    std::move(size)
    , std::move(callback));
}
void StableCdmContextInterceptorForTesting::ParseEncryptedSliceHeader(uint64_t secure_handle, uint32_t offset, const std::vector<uint8_t>& stream_data, ParseEncryptedSliceHeaderCallback callback) {
  GetForwardingInterface()->ParseEncryptedSliceHeader(
    std::move(secure_handle)
    , 
    std::move(offset)
    , 
    std::move(stream_data)
    , std::move(callback));
}
void StableCdmContextInterceptorForTesting::DecryptVideoBuffer(const ::scoped_refptr<::media::DecoderBuffer>& buffer, const std::vector<uint8_t>& bytes, DecryptVideoBufferCallback callback) {
  GetForwardingInterface()->DecryptVideoBuffer(
    std::move(buffer)
    , 
    std::move(bytes)
    , std::move(callback));
}
StableCdmContextAsyncWaiter::StableCdmContextAsyncWaiter(
    StableCdmContext* proxy) : proxy_(proxy) {}

StableCdmContextAsyncWaiter::~StableCdmContextAsyncWaiter() = default;

void StableCdmContextAsyncWaiter::GetHwKeyData(
    ::std::unique_ptr<::media::DecryptConfig> decrypt_config, const std::vector<uint8_t>& hw_identifier, ::media::Decryptor::Status* out_status, std::vector<uint8_t>* out_key_data) {
  base::RunLoop loop;
  proxy_->GetHwKeyData(
      std::move(decrypt_config),
      std::move(hw_identifier),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::media::Decryptor::Status* out_status
,
             std::vector<uint8_t>* out_key_data
,
             ::media::Decryptor::Status status,
             const std::vector<uint8_t>& key_data) {*out_status = std::move(status);*out_key_data = std::move(key_data);
            loop->Quit();
          },
          &loop,
          out_status,
          out_key_data));
  loop.Run();
}



void StableCdmContextAsyncWaiter::GetHwConfigData(
    bool* out_success, std::vector<uint8_t>* out_config_data) {
  base::RunLoop loop;
  proxy_->GetHwConfigData(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             std::vector<uint8_t>* out_config_data
,
             bool success,
             const std::vector<uint8_t>& config_data) {*out_success = std::move(success);*out_config_data = std::move(config_data);
            loop->Quit();
          },
          &loop,
          out_success,
          out_config_data));
  loop.Run();
}



void StableCdmContextAsyncWaiter::GetScreenResolutions(
    std::vector<::gfx::Size>* out_resolutions) {
  base::RunLoop loop;
  proxy_->GetScreenResolutions(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<::gfx::Size>* out_resolutions
,
             const std::vector<::gfx::Size>& resolutions) {*out_resolutions = std::move(resolutions);
            loop->Quit();
          },
          &loop,
          out_resolutions));
  loop.Run();
}

std::vector<::gfx::Size> StableCdmContextAsyncWaiter::GetScreenResolutions(
    ) {
  std::vector<::gfx::Size> async_wait_result;
  GetScreenResolutions(&async_wait_result);
  return async_wait_result;
}

void StableCdmContextAsyncWaiter::AllocateSecureBuffer(
    uint32_t size, ::mojo::PlatformHandle* out_secure_buffer) {
  base::RunLoop loop;
  proxy_->AllocateSecureBuffer(
      std::move(size),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::mojo::PlatformHandle* out_secure_buffer
,
             ::mojo::PlatformHandle secure_buffer) {*out_secure_buffer = std::move(secure_buffer);
            loop->Quit();
          },
          &loop,
          out_secure_buffer));
  loop.Run();
}

::mojo::PlatformHandle StableCdmContextAsyncWaiter::AllocateSecureBuffer(
    uint32_t size) {
  ::mojo::PlatformHandle async_wait_result;
  AllocateSecureBuffer(std::move(size),&async_wait_result);
  return async_wait_result;
}

void StableCdmContextAsyncWaiter::ParseEncryptedSliceHeader(
    uint64_t secure_handle, uint32_t offset, const std::vector<uint8_t>& stream_data, bool* out_success, std::vector<uint8_t>* out_slice_header) {
  base::RunLoop loop;
  proxy_->ParseEncryptedSliceHeader(
      std::move(secure_handle),
      std::move(offset),
      std::move(stream_data),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             std::vector<uint8_t>* out_slice_header
,
             bool success,
             const std::vector<uint8_t>& slice_header) {*out_success = std::move(success);*out_slice_header = std::move(slice_header);
            loop->Quit();
          },
          &loop,
          out_success,
          out_slice_header));
  loop.Run();
}



void StableCdmContextAsyncWaiter::DecryptVideoBuffer(
    const ::scoped_refptr<::media::DecoderBuffer>& buffer, const std::vector<uint8_t>& bytes, ::media::Decryptor::Status* out_status, ::scoped_refptr<::media::DecoderBuffer>* out_decoder_buffer, std::vector<uint8_t>* out_bytes) {
  base::RunLoop loop;
  proxy_->DecryptVideoBuffer(
      std::move(buffer),
      std::move(bytes),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::media::Decryptor::Status* out_status
,
             ::scoped_refptr<::media::DecoderBuffer>* out_decoder_buffer
,
             std::vector<uint8_t>* out_bytes
,
             ::media::Decryptor::Status status,
             const ::scoped_refptr<::media::DecoderBuffer>& decoder_buffer,
             const std::vector<uint8_t>& bytes) {*out_status = std::move(status);*out_decoder_buffer = std::move(decoder_buffer);*out_bytes = std::move(bytes);
            loop->Quit();
          },
          &loop,
          out_status,
          out_decoder_buffer,
          out_bytes));
  loop.Run();
}






void StableVideoDecoderInterceptorForTesting::GetSupportedConfigs(GetSupportedConfigsCallback callback) {
  GetForwardingInterface()->GetSupportedConfigs(std::move(callback));
}
void StableVideoDecoderInterceptorForTesting::Construct(::mojo::PendingAssociatedRemote<VideoDecoderClient> client, ::mojo::PendingRemote<MediaLog> media_log, ::mojo::PendingReceiver<VideoFrameHandleReleaser> video_frame_handle_releaser, ::mojo::ScopedDataPipeConsumerHandle decoder_buffer_pipe, const ::gfx::ColorSpace& target_color_space) {
  GetForwardingInterface()->Construct(
    std::move(client)
    , 
    std::move(media_log)
    , 
    std::move(video_frame_handle_releaser)
    , 
    std::move(decoder_buffer_pipe)
    , 
    std::move(target_color_space)
    );
}
void StableVideoDecoderInterceptorForTesting::Initialize(const ::media::VideoDecoderConfig& config, bool low_delay, ::mojo::PendingRemote<StableCdmContext> cdm_context, InitializeCallback callback) {
  GetForwardingInterface()->Initialize(
    std::move(config)
    , 
    std::move(low_delay)
    , 
    std::move(cdm_context)
    , std::move(callback));
}
void StableVideoDecoderInterceptorForTesting::Decode(const ::scoped_refptr<::media::DecoderBuffer>& buffer, DecodeCallback callback) {
  GetForwardingInterface()->Decode(
    std::move(buffer)
    , std::move(callback));
}
void StableVideoDecoderInterceptorForTesting::Reset(ResetCallback callback) {
  GetForwardingInterface()->Reset(std::move(callback));
}
StableVideoDecoderAsyncWaiter::StableVideoDecoderAsyncWaiter(
    StableVideoDecoder* proxy) : proxy_(proxy) {}

StableVideoDecoderAsyncWaiter::~StableVideoDecoderAsyncWaiter() = default;

void StableVideoDecoderAsyncWaiter::GetSupportedConfigs(
    std::vector<::media::SupportedVideoDecoderConfig>* out_supported_configs, ::media::VideoDecoderType* out_decoder_type) {
  base::RunLoop loop;
  proxy_->GetSupportedConfigs(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<::media::SupportedVideoDecoderConfig>* out_supported_configs
,
             ::media::VideoDecoderType* out_decoder_type
,
             const std::vector<::media::SupportedVideoDecoderConfig>& supported_configs,
             ::media::VideoDecoderType decoder_type) {*out_supported_configs = std::move(supported_configs);*out_decoder_type = std::move(decoder_type);
            loop->Quit();
          },
          &loop,
          out_supported_configs,
          out_decoder_type));
  loop.Run();
}



void StableVideoDecoderAsyncWaiter::Initialize(
    const ::media::VideoDecoderConfig& config, bool low_delay, ::mojo::PendingRemote<StableCdmContext> cdm_context, ::media::DecoderStatus* out_status, bool* out_needs_bitstream_conversion, int32_t* out_max_decode_requests, ::media::VideoDecoderType* out_decoder_type, bool* out_needs_transcryption) {
  base::RunLoop loop;
  proxy_->Initialize(
      std::move(config),
      std::move(low_delay),
      std::move(cdm_context),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::media::DecoderStatus* out_status
,
             bool* out_needs_bitstream_conversion
,
             int32_t* out_max_decode_requests
,
             ::media::VideoDecoderType* out_decoder_type
,
             bool* out_needs_transcryption
,
             const ::media::DecoderStatus& status,
             bool needs_bitstream_conversion,
             int32_t max_decode_requests,
             ::media::VideoDecoderType decoder_type,
             bool needs_transcryption) {*out_status = std::move(status);*out_needs_bitstream_conversion = std::move(needs_bitstream_conversion);*out_max_decode_requests = std::move(max_decode_requests);*out_decoder_type = std::move(decoder_type);*out_needs_transcryption = std::move(needs_transcryption);
            loop->Quit();
          },
          &loop,
          out_status,
          out_needs_bitstream_conversion,
          out_max_decode_requests,
          out_decoder_type,
          out_needs_transcryption));
  loop.Run();
}



void StableVideoDecoderAsyncWaiter::Decode(
    const ::scoped_refptr<::media::DecoderBuffer>& buffer, ::media::DecoderStatus* out_status) {
  base::RunLoop loop;
  proxy_->Decode(
      std::move(buffer),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::media::DecoderStatus* out_status
,
             const ::media::DecoderStatus& status) {*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_status));
  loop.Run();
}

::media::DecoderStatus StableVideoDecoderAsyncWaiter::Decode(
    const ::scoped_refptr<::media::DecoderBuffer>& buffer) {
  ::media::DecoderStatus async_wait_result;
  Decode(std::move(buffer),&async_wait_result);
  return async_wait_result;
}

void StableVideoDecoderAsyncWaiter::Reset(
    ) {
  base::RunLoop loop;
  proxy_->Reset(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}






StableVideoDecoderTrackerAsyncWaiter::StableVideoDecoderTrackerAsyncWaiter(
    StableVideoDecoderTracker* proxy) : proxy_(proxy) {}

StableVideoDecoderTrackerAsyncWaiter::~StableVideoDecoderTrackerAsyncWaiter() = default;




void StableVideoDecoderFactoryInterceptorForTesting::CreateStableVideoDecoder(::mojo::PendingReceiver<StableVideoDecoder> receiver, ::mojo::PendingRemote<StableVideoDecoderTracker> tracker) {
  GetForwardingInterface()->CreateStableVideoDecoder(
    std::move(receiver)
    , 
    std::move(tracker)
    );
}
StableVideoDecoderFactoryAsyncWaiter::StableVideoDecoderFactoryAsyncWaiter(
    StableVideoDecoderFactory* proxy) : proxy_(proxy) {}

StableVideoDecoderFactoryAsyncWaiter::~StableVideoDecoderFactoryAsyncWaiter() = default;




void StableVideoDecoderFactoryProcessInterceptorForTesting::InitializeStableVideoDecoderFactory(const ::gpu::GpuFeatureInfo& gpu_feature_info, ::mojo::PendingReceiver<StableVideoDecoderFactory> receiver) {
  GetForwardingInterface()->InitializeStableVideoDecoderFactory(
    std::move(gpu_feature_info)
    , 
    std::move(receiver)
    );
}
StableVideoDecoderFactoryProcessAsyncWaiter::StableVideoDecoderFactoryProcessAsyncWaiter(
    StableVideoDecoderFactoryProcess* proxy) : proxy_(proxy) {}

StableVideoDecoderFactoryProcessAsyncWaiter::~StableVideoDecoderFactoryProcessAsyncWaiter() = default;






}  // media::stable::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif