// media/mojo/mojom/audio_input_stream.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "media/mojo/mojom/audio_input_stream.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/mojo/mojom/audio_input_stream.mojom-params-data.h"
namespace media {
namespace mojom {

NOINLINE static const char* AudioInputStreamObserver_DisconnectReasonToStringHelper(AudioInputStreamObserver_DisconnectReason value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case AudioInputStreamObserver_DisconnectReason::kDefault:
      return "kDefault";
    case AudioInputStreamObserver_DisconnectReason::kPlatformError:
      return "kPlatformError";
    case AudioInputStreamObserver_DisconnectReason::kTerminatedByClient:
      return "kTerminatedByClient";
    case AudioInputStreamObserver_DisconnectReason::kStreamCreationFailed:
      return "kStreamCreationFailed";
    case AudioInputStreamObserver_DisconnectReason::kDocumentDestroyed:
      return "kDocumentDestroyed";
    case AudioInputStreamObserver_DisconnectReason::kSystemPermissions:
      return "kSystemPermissions";
    case AudioInputStreamObserver_DisconnectReason::kDeviceInUse:
      return "kDeviceInUse";
    default:
      return nullptr;
  }
}

std::string AudioInputStreamObserver_DisconnectReasonToString(AudioInputStreamObserver_DisconnectReason value) {
  const char *str = AudioInputStreamObserver_DisconnectReasonToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown AudioInputStreamObserver_DisconnectReason value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, AudioInputStreamObserver_DisconnectReason value) {
  return os << AudioInputStreamObserver_DisconnectReasonToString(value);
}

namespace internal {


// static
bool AudioInputStream_Record_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AudioInputStream_Record_Params_Data* object =
      static_cast<const AudioInputStream_Record_Params_Data*>(data);

  return true;
}

AudioInputStream_Record_Params_Data::AudioInputStream_Record_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AudioInputStream_SetVolume_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AudioInputStream_SetVolume_Params_Data* object =
      static_cast<const AudioInputStream_SetVolume_Params_Data*>(data);

  return true;
}

AudioInputStream_SetVolume_Params_Data::AudioInputStream_SetVolume_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AudioInputStreamClient_OnError_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AudioInputStreamClient_OnError_Params_Data* object =
      static_cast<const AudioInputStreamClient_OnError_Params_Data*>(data);


  if (!::media::mojom::internal::InputStreamErrorCode_Data
        ::Validate(object->code, validation_context))
    return false;

  return true;
}

AudioInputStreamClient_OnError_Params_Data::AudioInputStreamClient_OnError_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AudioInputStreamClient_OnMutedStateChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AudioInputStreamClient_OnMutedStateChanged_Params_Data* object =
      static_cast<const AudioInputStreamClient_OnMutedStateChanged_Params_Data*>(data);

  return true;
}

AudioInputStreamClient_OnMutedStateChanged_Params_Data::AudioInputStreamClient_OnMutedStateChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AudioInputStreamObserver_DidStartRecording_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AudioInputStreamObserver_DidStartRecording_Params_Data* object =
      static_cast<const AudioInputStreamObserver_DidStartRecording_Params_Data*>(data);

  return true;
}

AudioInputStreamObserver_DidStartRecording_Params_Data::AudioInputStreamObserver_DidStartRecording_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace media

namespace perfetto {

// static
void TraceFormatTraits<::media::mojom::AudioInputStreamObserver_DisconnectReason>::WriteIntoTrace(
   perfetto::TracedValue context, ::media::mojom::AudioInputStreamObserver_DisconnectReason value) {
  return std::move(context).WriteString(::media::mojom::AudioInputStreamObserver_DisconnectReasonToString(value));
}

} // namespace perfetto