// gpu/ipc/common/gpu_preferences.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "gpu/ipc/common/gpu_preferences.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "gpu/ipc/common/gpu_preferences.mojom-params-data.h"
namespace gpu {
namespace mojom {

NOINLINE static const char* VulkanImplementationNameToStringHelper(VulkanImplementationName value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case VulkanImplementationName::kNone:
      return "kNone";
    case VulkanImplementationName::kNative:
      return "kNative";
    case VulkanImplementationName::kForcedNative:
      return "kForcedNative";
    case VulkanImplementationName::kSwiftshader:
      return "{kSwiftshader, kLast}";
    default:
      return nullptr;
  }
}

std::string VulkanImplementationNameToString(VulkanImplementationName value) {
  const char *str = VulkanImplementationNameToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown VulkanImplementationName value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, VulkanImplementationName value) {
  return os << VulkanImplementationNameToString(value);
}

NOINLINE static const char* WebGPUAdapterNameToStringHelper(WebGPUAdapterName value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case WebGPUAdapterName::kDefault:
      return "kDefault";
    case WebGPUAdapterName::kD3D11:
      return "kD3D11";
    case WebGPUAdapterName::kOpenGLES:
      return "kOpenGLES";
    case WebGPUAdapterName::kSwiftShader:
      return "kSwiftShader";
    default:
      return nullptr;
  }
}

std::string WebGPUAdapterNameToString(WebGPUAdapterName value) {
  const char *str = WebGPUAdapterNameToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown WebGPUAdapterName value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, WebGPUAdapterName value) {
  return os << WebGPUAdapterNameToString(value);
}

NOINLINE static const char* WebGPUPowerPreferenceToStringHelper(WebGPUPowerPreference value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case WebGPUPowerPreference::kNone:
      return "kNone";
    case WebGPUPowerPreference::kDefaultLowPower:
      return "kDefaultLowPower";
    case WebGPUPowerPreference::kDefaultHighPerformance:
      return "kDefaultHighPerformance";
    case WebGPUPowerPreference::kForceLowPower:
      return "kForceLowPower";
    case WebGPUPowerPreference::kForceHighPerformance:
      return "kForceHighPerformance";
    default:
      return nullptr;
  }
}

std::string WebGPUPowerPreferenceToString(WebGPUPowerPreference value) {
  const char *str = WebGPUPowerPreferenceToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown WebGPUPowerPreference value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, WebGPUPowerPreference value) {
  return os << WebGPUPowerPreferenceToString(value);
}

NOINLINE static const char* GrContextTypeToStringHelper(GrContextType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case GrContextType::kNone:
      return "kNone";
    case GrContextType::kGL:
      return "kGL";
    case GrContextType::kVulkan:
      return "kVulkan";
    case GrContextType::kGraphiteDawn:
      return "kGraphiteDawn";
    case GrContextType::kGraphiteMetal:
      return "kGraphiteMetal";
    default:
      return nullptr;
  }
}

std::string GrContextTypeToString(GrContextType value) {
  const char *str = GrContextTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown GrContextType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, GrContextType value) {
  return os << GrContextTypeToString(value);
}

NOINLINE static const char* DawnBackendValidationLevelToStringHelper(DawnBackendValidationLevel value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case DawnBackendValidationLevel::kDisabled:
      return "kDisabled";
    case DawnBackendValidationLevel::kPartial:
      return "kPartial";
    case DawnBackendValidationLevel::kFull:
      return "kFull";
    default:
      return nullptr;
  }
}

std::string DawnBackendValidationLevelToString(DawnBackendValidationLevel value) {
  const char *str = DawnBackendValidationLevelToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown DawnBackendValidationLevel value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, DawnBackendValidationLevel value) {
  return os << DawnBackendValidationLevelToString(value);
}

namespace internal {


// static
bool GpuPreferences_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 80, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GpuPreferences_Data* object =
      static_cast<const GpuPreferences_Data*>(data);


  if (!::gpu::mojom::internal::GrContextType_Data
        ::Validate(object->gr_context_type, validation_context))
    return false;


  if (!::gpu::mojom::internal::VulkanImplementationName_Data
        ::Validate(object->use_vulkan, validation_context))
    return false;


  if (!::gpu::mojom::internal::WebGPUAdapterName_Data
        ::Validate(object->use_webgpu_adapter, validation_context))
    return false;


  if (!::gpu::mojom::internal::WebGPUPowerPreference_Data
        ::Validate(object->use_webgpu_power_preference, validation_context))
    return false;


  if (!::gpu::mojom::internal::DawnBackendValidationLevel_Data
        ::Validate(object->enable_dawn_backend_validation, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->enabled_dawn_features_list, 50, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& enabled_dawn_features_list_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->enabled_dawn_features_list, validation_context,
                                         &enabled_dawn_features_list_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->disabled_dawn_features_list, 51, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& disabled_dawn_features_list_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->disabled_dawn_features_list, validation_context,
                                         &disabled_dawn_features_list_validate_params)) {
    return false;
  }


  if (!::mojo_base::mojom::internal::MessagePumpType_Data
        ::Validate(object->message_pump_type, validation_context))
    return false;

  return true;
}

GpuPreferences_Data::GpuPreferences_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace gpu

namespace perfetto {

// static
void TraceFormatTraits<::gpu::mojom::VulkanImplementationName>::WriteIntoTrace(
   perfetto::TracedValue context, ::gpu::mojom::VulkanImplementationName value) {
  return std::move(context).WriteString(::gpu::mojom::VulkanImplementationNameToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::gpu::mojom::WebGPUAdapterName>::WriteIntoTrace(
   perfetto::TracedValue context, ::gpu::mojom::WebGPUAdapterName value) {
  return std::move(context).WriteString(::gpu::mojom::WebGPUAdapterNameToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::gpu::mojom::WebGPUPowerPreference>::WriteIntoTrace(
   perfetto::TracedValue context, ::gpu::mojom::WebGPUPowerPreference value) {
  return std::move(context).WriteString(::gpu::mojom::WebGPUPowerPreferenceToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::gpu::mojom::GrContextType>::WriteIntoTrace(
   perfetto::TracedValue context, ::gpu::mojom::GrContextType value) {
  return std::move(context).WriteString(::gpu::mojom::GrContextTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::gpu::mojom::DawnBackendValidationLevel>::WriteIntoTrace(
   perfetto::TracedValue context, ::gpu::mojom::DawnBackendValidationLevel value) {
  return std::move(context).WriteString(::gpu::mojom::DawnBackendValidationLevelToString(value));
}

} // namespace perfetto