// gpu/ipc/common/gpu_disk_cache_type.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "gpu/ipc/common/gpu_disk_cache_type.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "gpu/ipc/common/gpu_disk_cache_type.mojom-params-data.h"
namespace gpu {
namespace mojom {

NOINLINE static const char* GpuDiskCacheTypeToStringHelper(GpuDiskCacheType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case GpuDiskCacheType::kGlShaders:
      return "kGlShaders";
    case GpuDiskCacheType::kDawnWebGPU:
      return "kDawnWebGPU";
    case GpuDiskCacheType::kDawnGraphite:
      return "kDawnGraphite";
    default:
      return nullptr;
  }
}

std::string GpuDiskCacheTypeToString(GpuDiskCacheType value) {
  const char *str = GpuDiskCacheTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown GpuDiskCacheType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, GpuDiskCacheType value) {
  return os << GpuDiskCacheTypeToString(value);
}

namespace internal {
// static
bool GpuDiskCacheHandle_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const GpuDiskCacheHandle_Data* object = static_cast<const GpuDiskCacheHandle_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case GpuDiskCacheHandle_Tag::kGlShaderHandle: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_gl_shader_handle, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_gl_shader_handle, validation_context))
        return false;
      return true;
    }
    case GpuDiskCacheHandle_Tag::kDawnWebgpuHandle: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_dawn_webgpu_handle, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_dawn_webgpu_handle, validation_context))
        return false;
      return true;
    }
    case GpuDiskCacheHandle_Tag::kDawnGraphiteHandle: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_dawn_graphite_handle, 3, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_dawn_graphite_handle, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in GpuDiskCacheHandle");
      return false;
    }
  }
}


// static
bool GpuDiskCacheGlShaderHandle_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GpuDiskCacheGlShaderHandle_Data* object =
      static_cast<const GpuDiskCacheGlShaderHandle_Data*>(data);

  return true;
}

GpuDiskCacheGlShaderHandle_Data::GpuDiskCacheGlShaderHandle_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GpuDiskCacheDawnWebGPUHandle_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GpuDiskCacheDawnWebGPUHandle_Data* object =
      static_cast<const GpuDiskCacheDawnWebGPUHandle_Data*>(data);

  return true;
}

GpuDiskCacheDawnWebGPUHandle_Data::GpuDiskCacheDawnWebGPUHandle_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GpuDiskCacheDawnGraphiteHandle_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GpuDiskCacheDawnGraphiteHandle_Data* object =
      static_cast<const GpuDiskCacheDawnGraphiteHandle_Data*>(data);

  return true;
}

GpuDiskCacheDawnGraphiteHandle_Data::GpuDiskCacheDawnGraphiteHandle_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace gpu

namespace perfetto {

// static
void TraceFormatTraits<::gpu::mojom::GpuDiskCacheType>::WriteIntoTrace(
   perfetto::TracedValue context, ::gpu::mojom::GpuDiskCacheType value) {
  return std::move(context).WriteString(::gpu::mojom::GpuDiskCacheTypeToString(value));
}

} // namespace perfetto