// extensions/common/mojom/code_injection.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef EXTENSIONS_COMMON_MOJOM_CODE_INJECTION_MOJOM_H_
#define EXTENSIONS_COMMON_MOJOM_CODE_INJECTION_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "extensions/common/mojom/code_injection.mojom-features.h"  // IWYU pragma: export
#include "extensions/common/mojom/code_injection.mojom-shared.h"  // IWYU pragma: export
#include "extensions/common/mojom/code_injection.mojom-forward.h"  // IWYU pragma: export
#include "extensions/common/mojom/css_origin.mojom-forward.h"
#include "extensions/common/mojom/execution_world.mojom-forward.h"
#include "third_party/blink/public/mojom/script/script_evaluation_params.mojom-forward.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>








namespace extensions::mojom {






class  CSSSource {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CSSSource, T>::value>;
  using DataView = CSSSourceDataView;
  using Data_ = internal::CSSSource_Data;

  template <typename... Args>
  static CSSSourcePtr New(Args&&... args) {
    return CSSSourcePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CSSSourcePtr From(const U& u) {
    return mojo::TypeConverter<CSSSourcePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CSSSource>::Convert(*this);
  }


  CSSSource();

  CSSSource(
      const std::string& code,
      const std::optional<std::string>& key);


  ~CSSSource();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CSSSourcePtr>
  CSSSourcePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CSSSource::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CSSSource::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CSSSource::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CSSSource::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CSSSource::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CSSSource_UnserializedMessageContext<
            UserType, CSSSource::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CSSSource::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CSSSource::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CSSSource_UnserializedMessageContext<
            UserType, CSSSource::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CSSSource::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string code;
  
  std::optional<std::string> key;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CSSSource::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CSSSource::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CSSSource::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CSSSource::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class  CodeInjection {
 public:
  using DataView = CodeInjectionDataView;
  using Data_ = internal::CodeInjection_Data;
  using Tag = Data_::CodeInjection_Tag;

  template <typename... Args>
  static CodeInjectionPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }
  // Construct an instance holding |css|.
  static CodeInjectionPtr
  NewCss(
      CSSInjectionPtr value) {
    auto result = CodeInjectionPtr(std::in_place);
    result->set_css(std::move(value));
    return result;
  }
  // Construct an instance holding |js|.
  static CodeInjectionPtr
  NewJs(
      JSInjectionPtr value) {
    auto result = CodeInjectionPtr(std::in_place);
    result->set_js(std::move(value));
    return result;
  }

  template <typename U>
  static CodeInjectionPtr From(const U& u) {
    return mojo::TypeConverter<CodeInjectionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CodeInjection>::Convert(*this);
  }

  CodeInjection();
  ~CodeInjection();
  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  CodeInjection(const CodeInjection& other) = delete;
  CodeInjection& operator=(const CodeInjection& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = CodeInjectionPtr>
  CodeInjectionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, CodeInjection>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, CodeInjection>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }


  
  bool is_css() const { return tag_ == Tag::kCss; }

  
  CSSInjectionPtr& get_css() const {
    CHECK(tag_ == Tag::kCss);
    return *(data_.css);
  }

  
  void set_css(
      CSSInjectionPtr css);
  
  bool is_js() const { return tag_ == Tag::kJs; }

  
  JSInjectionPtr& get_js() const {
    CHECK(tag_ == Tag::kJs);
    return *(data_.js);
  }

  
  void set_js(
      JSInjectionPtr js);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CodeInjection::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<CodeInjection::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  union Union_ {
    Union_() = default;
    ~Union_() = default;
    CSSInjectionPtr* css;
    JSInjectionPtr* js;
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class  JSSource {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<JSSource, T>::value>;
  using DataView = JSSourceDataView;
  using Data_ = internal::JSSource_Data;

  template <typename... Args>
  static JSSourcePtr New(Args&&... args) {
    return JSSourcePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static JSSourcePtr From(const U& u) {
    return mojo::TypeConverter<JSSourcePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, JSSource>::Convert(*this);
  }


  JSSource();

  JSSource(
      const std::string& code,
      const ::GURL& script_url);


  ~JSSource();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = JSSourcePtr>
  JSSourcePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, JSSource::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, JSSource::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, JSSource::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        JSSource::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        JSSource::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::JSSource_UnserializedMessageContext<
            UserType, JSSource::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<JSSource::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return JSSource::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::JSSource_UnserializedMessageContext<
            UserType, JSSource::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<JSSource::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string code;
  
  ::GURL script_url;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, JSSource::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, JSSource::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, JSSource::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, JSSource::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  JSInjection {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<JSInjection, T>::value>;
  using DataView = JSInjectionDataView;
  using Data_ = internal::JSInjection_Data;

  template <typename... Args>
  static JSInjectionPtr New(Args&&... args) {
    return JSInjectionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static JSInjectionPtr From(const U& u) {
    return mojo::TypeConverter<JSInjectionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, JSInjection>::Convert(*this);
  }


  JSInjection();

  JSInjection(
      std::vector<JSSourcePtr> sources,
      ::extensions::mojom::ExecutionWorld world,
      const std::optional<std::string>& world_id,
      ::blink::mojom::WantResultOption wants_result,
      ::blink::mojom::UserActivationOption user_gesture,
      ::blink::mojom::PromiseResultOption wait_for_promise);

JSInjection(const JSInjection&) = delete;
JSInjection& operator=(const JSInjection&) = delete;

  ~JSInjection();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = JSInjectionPtr>
  JSInjectionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, JSInjection::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, JSInjection::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, JSInjection::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        JSInjection::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        JSInjection::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::JSInjection_UnserializedMessageContext<
            UserType, JSInjection::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<JSInjection::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return JSInjection::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::JSInjection_UnserializedMessageContext<
            UserType, JSInjection::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<JSInjection::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<JSSourcePtr> sources;
  
  ::extensions::mojom::ExecutionWorld world;
  
  std::optional<std::string> world_id;
  
  ::blink::mojom::WantResultOption wants_result;
  
  ::blink::mojom::UserActivationOption user_gesture;
  
  ::blink::mojom::PromiseResultOption wait_for_promise;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, JSInjection::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, JSInjection::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, JSInjection::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, JSInjection::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  CSSInjection {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CSSInjection, T>::value>;
  using DataView = CSSInjectionDataView;
  using Data_ = internal::CSSInjection_Data;
  using Operation = CSSInjection_Operation;

  template <typename... Args>
  static CSSInjectionPtr New(Args&&... args) {
    return CSSInjectionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CSSInjectionPtr From(const U& u) {
    return mojo::TypeConverter<CSSInjectionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CSSInjection>::Convert(*this);
  }


  CSSInjection();

  CSSInjection(
      std::vector<CSSSourcePtr> sources,
      ::extensions::mojom::CSSOrigin css_origin,
      CSSInjection::Operation operation);

CSSInjection(const CSSInjection&) = delete;
CSSInjection& operator=(const CSSInjection&) = delete;

  ~CSSInjection();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CSSInjectionPtr>
  CSSInjectionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CSSInjection::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CSSInjection::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CSSInjection::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CSSInjection::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CSSInjection::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CSSInjection_UnserializedMessageContext<
            UserType, CSSInjection::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CSSInjection::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CSSInjection::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CSSInjection_UnserializedMessageContext<
            UserType, CSSInjection::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CSSInjection::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<CSSSourcePtr> sources;
  
  ::extensions::mojom::CSSOrigin css_origin;
  
  CSSInjection::Operation operation;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CSSInjection::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CSSInjection::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CSSInjection::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CSSInjection::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
CodeInjectionPtr CodeInjection::Clone() const {
  switch (tag_) {
    case Tag::kCss:
      return NewCss(
          mojo::Clone(*data_.css));
    case Tag::kJs:
      return NewJs(
          mojo::Clone(*data_.js));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, CodeInjection>::value>::type*>
bool CodeInjection::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kCss:
      return mojo::Equals(*(data_.css), *(other.data_.css));
    case Tag::kJs:
      return mojo::Equals(*(data_.js), *(other.data_.js));
  }

  return false;
}
template <typename StructPtrType>
JSSourcePtr JSSource::Clone() const {
  return New(
      mojo::Clone(code),
      mojo::Clone(script_url)
  );
}

template <typename T, JSSource::EnableIfSame<T>*>
bool JSSource::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->code, other_struct.code))
    return false;
  if (!mojo::Equals(this->script_url, other_struct.script_url))
    return false;
  return true;
}

template <typename T, JSSource::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.code < rhs.code)
    return true;
  if (rhs.code < lhs.code)
    return false;
  if (lhs.script_url < rhs.script_url)
    return true;
  if (rhs.script_url < lhs.script_url)
    return false;
  return false;
}
template <typename StructPtrType>
CSSSourcePtr CSSSource::Clone() const {
  return New(
      mojo::Clone(code),
      mojo::Clone(key)
  );
}

template <typename T, CSSSource::EnableIfSame<T>*>
bool CSSSource::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->code, other_struct.code))
    return false;
  if (!mojo::Equals(this->key, other_struct.key))
    return false;
  return true;
}

template <typename T, CSSSource::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.code < rhs.code)
    return true;
  if (rhs.code < lhs.code)
    return false;
  if (lhs.key < rhs.key)
    return true;
  if (rhs.key < lhs.key)
    return false;
  return false;
}
template <typename StructPtrType>
JSInjectionPtr JSInjection::Clone() const {
  return New(
      mojo::Clone(sources),
      mojo::Clone(world),
      mojo::Clone(world_id),
      mojo::Clone(wants_result),
      mojo::Clone(user_gesture),
      mojo::Clone(wait_for_promise)
  );
}

template <typename T, JSInjection::EnableIfSame<T>*>
bool JSInjection::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->sources, other_struct.sources))
    return false;
  if (!mojo::Equals(this->world, other_struct.world))
    return false;
  if (!mojo::Equals(this->world_id, other_struct.world_id))
    return false;
  if (!mojo::Equals(this->wants_result, other_struct.wants_result))
    return false;
  if (!mojo::Equals(this->user_gesture, other_struct.user_gesture))
    return false;
  if (!mojo::Equals(this->wait_for_promise, other_struct.wait_for_promise))
    return false;
  return true;
}

template <typename T, JSInjection::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.sources < rhs.sources)
    return true;
  if (rhs.sources < lhs.sources)
    return false;
  if (lhs.world < rhs.world)
    return true;
  if (rhs.world < lhs.world)
    return false;
  if (lhs.world_id < rhs.world_id)
    return true;
  if (rhs.world_id < lhs.world_id)
    return false;
  if (lhs.wants_result < rhs.wants_result)
    return true;
  if (rhs.wants_result < lhs.wants_result)
    return false;
  if (lhs.user_gesture < rhs.user_gesture)
    return true;
  if (rhs.user_gesture < lhs.user_gesture)
    return false;
  if (lhs.wait_for_promise < rhs.wait_for_promise)
    return true;
  if (rhs.wait_for_promise < lhs.wait_for_promise)
    return false;
  return false;
}
template <typename StructPtrType>
CSSInjectionPtr CSSInjection::Clone() const {
  return New(
      mojo::Clone(sources),
      mojo::Clone(css_origin),
      mojo::Clone(operation)
  );
}

template <typename T, CSSInjection::EnableIfSame<T>*>
bool CSSInjection::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->sources, other_struct.sources))
    return false;
  if (!mojo::Equals(this->css_origin, other_struct.css_origin))
    return false;
  if (!mojo::Equals(this->operation, other_struct.operation))
    return false;
  return true;
}

template <typename T, CSSInjection::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.sources < rhs.sources)
    return true;
  if (rhs.sources < lhs.sources)
    return false;
  if (lhs.css_origin < rhs.css_origin)
    return true;
  if (rhs.css_origin < lhs.css_origin)
    return false;
  if (lhs.operation < rhs.operation)
    return true;
  if (rhs.operation < lhs.operation)
    return false;
  return false;
}


}  // extensions::mojom

namespace mojo {


template <>
struct  StructTraits<::extensions::mojom::JSSource::DataView,
                                         ::extensions::mojom::JSSourcePtr> {
  static bool IsNull(const ::extensions::mojom::JSSourcePtr& input) { return !input; }
  static void SetToNull(::extensions::mojom::JSSourcePtr* output) { output->reset(); }

  static const decltype(::extensions::mojom::JSSource::code)& code(
      const ::extensions::mojom::JSSourcePtr& input) {
    return input->code;
  }

  static const decltype(::extensions::mojom::JSSource::script_url)& script_url(
      const ::extensions::mojom::JSSourcePtr& input) {
    return input->script_url;
  }

  static bool Read(::extensions::mojom::JSSource::DataView input, ::extensions::mojom::JSSourcePtr* output);
};


template <>
struct  StructTraits<::extensions::mojom::CSSSource::DataView,
                                         ::extensions::mojom::CSSSourcePtr> {
  static bool IsNull(const ::extensions::mojom::CSSSourcePtr& input) { return !input; }
  static void SetToNull(::extensions::mojom::CSSSourcePtr* output) { output->reset(); }

  static const decltype(::extensions::mojom::CSSSource::code)& code(
      const ::extensions::mojom::CSSSourcePtr& input) {
    return input->code;
  }

  static const decltype(::extensions::mojom::CSSSource::key)& key(
      const ::extensions::mojom::CSSSourcePtr& input) {
    return input->key;
  }

  static bool Read(::extensions::mojom::CSSSource::DataView input, ::extensions::mojom::CSSSourcePtr* output);
};


template <>
struct  StructTraits<::extensions::mojom::JSInjection::DataView,
                                         ::extensions::mojom::JSInjectionPtr> {
  static bool IsNull(const ::extensions::mojom::JSInjectionPtr& input) { return !input; }
  static void SetToNull(::extensions::mojom::JSInjectionPtr* output) { output->reset(); }

  static const decltype(::extensions::mojom::JSInjection::sources)& sources(
      const ::extensions::mojom::JSInjectionPtr& input) {
    return input->sources;
  }

  static decltype(::extensions::mojom::JSInjection::world) world(
      const ::extensions::mojom::JSInjectionPtr& input) {
    return input->world;
  }

  static const decltype(::extensions::mojom::JSInjection::world_id)& world_id(
      const ::extensions::mojom::JSInjectionPtr& input) {
    return input->world_id;
  }

  static decltype(::extensions::mojom::JSInjection::wants_result) wants_result(
      const ::extensions::mojom::JSInjectionPtr& input) {
    return input->wants_result;
  }

  static decltype(::extensions::mojom::JSInjection::user_gesture) user_gesture(
      const ::extensions::mojom::JSInjectionPtr& input) {
    return input->user_gesture;
  }

  static decltype(::extensions::mojom::JSInjection::wait_for_promise) wait_for_promise(
      const ::extensions::mojom::JSInjectionPtr& input) {
    return input->wait_for_promise;
  }

  static bool Read(::extensions::mojom::JSInjection::DataView input, ::extensions::mojom::JSInjectionPtr* output);
};


template <>
struct  StructTraits<::extensions::mojom::CSSInjection::DataView,
                                         ::extensions::mojom::CSSInjectionPtr> {
  static bool IsNull(const ::extensions::mojom::CSSInjectionPtr& input) { return !input; }
  static void SetToNull(::extensions::mojom::CSSInjectionPtr* output) { output->reset(); }

  static const decltype(::extensions::mojom::CSSInjection::sources)& sources(
      const ::extensions::mojom::CSSInjectionPtr& input) {
    return input->sources;
  }

  static decltype(::extensions::mojom::CSSInjection::css_origin) css_origin(
      const ::extensions::mojom::CSSInjectionPtr& input) {
    return input->css_origin;
  }

  static decltype(::extensions::mojom::CSSInjection::operation) operation(
      const ::extensions::mojom::CSSInjectionPtr& input) {
    return input->operation;
  }

  static bool Read(::extensions::mojom::CSSInjection::DataView input, ::extensions::mojom::CSSInjectionPtr* output);
};


template <>
struct  UnionTraits<::extensions::mojom::CodeInjection::DataView,
                                        ::extensions::mojom::CodeInjectionPtr> {
  static bool IsNull(const ::extensions::mojom::CodeInjectionPtr& input) { return !input; }
  static void SetToNull(::extensions::mojom::CodeInjectionPtr* output) { output->reset(); }

  static ::extensions::mojom::CodeInjection::Tag GetTag(const ::extensions::mojom::CodeInjectionPtr& input) {
    return input->which();
  }

  static const ::extensions::mojom::CSSInjectionPtr& css(const ::extensions::mojom::CodeInjectionPtr& input) {
    return input->get_css();
  }

  static const ::extensions::mojom::JSInjectionPtr& js(const ::extensions::mojom::CodeInjectionPtr& input) {
    return input->get_js();
  }

  static bool Read(::extensions::mojom::CodeInjection::DataView input, ::extensions::mojom::CodeInjectionPtr* output);
};

}  // namespace mojo

#endif  // EXTENSIONS_COMMON_MOJOM_CODE_INJECTION_MOJOM_H_