// device/vr/public/mojom/vr_service.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "device/vr/public/mojom/vr_service.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "device/vr/public/mojom/vr_service.mojom-params-data.h"
#include "device/vr/public/mojom/vr_service.mojom-shared-message-ids.h"

#include "device/vr/public/mojom/vr_service.mojom-blink-import-headers.h"
#include "device/vr/public/mojom/vr_service.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace device::mojom::blink {
constexpr uint64_t XRCubeMap::kNumComponentsPerPixel;
XRDepthConfig::XRDepthConfig()
    : depth_usage(),
      depth_data_format() {}

XRDepthConfig::XRDepthConfig(
    ::device::mojom::blink::XRDepthUsage depth_usage_in,
    ::device::mojom::blink::XRDepthDataFormat depth_data_format_in)
    : depth_usage(std::move(depth_usage_in)),
      depth_data_format(std::move(depth_data_format_in)) {}

XRDepthConfig::~XRDepthConfig() = default;
size_t XRDepthConfig::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->depth_usage);
  seed = mojo::internal::WTFHash(seed, this->depth_data_format);
  return seed;
}

void XRDepthConfig::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "depth_usage"), this->depth_usage,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::device::mojom::blink::XRDepthUsage>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "depth_data_format"), this->depth_data_format,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::device::mojom::blink::XRDepthDataFormat>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool XRDepthConfig::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRSessionDeviceConfig::XRSessionDeviceConfig()
    : default_framebuffer_scale(1.0f),
      views(),
      supports_viewport_scaling(),
      enable_anti_aliasing(true),
      depth_configuration() {}

XRSessionDeviceConfig::XRSessionDeviceConfig(
    float default_framebuffer_scale_in,
    WTF::Vector<XRViewPtr> views_in,
    bool supports_viewport_scaling_in,
    bool enable_anti_aliasing_in,
    XRDepthConfigPtr depth_configuration_in)
    : default_framebuffer_scale(std::move(default_framebuffer_scale_in)),
      views(std::move(views_in)),
      supports_viewport_scaling(std::move(supports_viewport_scaling_in)),
      enable_anti_aliasing(std::move(enable_anti_aliasing_in)),
      depth_configuration(std::move(depth_configuration_in)) {}

XRSessionDeviceConfig::~XRSessionDeviceConfig() = default;

void XRSessionDeviceConfig::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "default_framebuffer_scale"), this->default_framebuffer_scale,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "views"), this->views,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type WTF::Vector<XRViewPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "supports_viewport_scaling"), this->supports_viewport_scaling,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_anti_aliasing"), this->enable_anti_aliasing,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "depth_configuration"), this->depth_configuration,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type XRDepthConfigPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool XRSessionDeviceConfig::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRSession::XRSession()
    : data_provider(),
      client_receiver(),
      submit_frame_sink(),
      enabled_features(),
      device_config(),
      enviroment_blend_mode(),
      interaction_mode() {}

XRSession::XRSession(
    ::mojo::PendingRemote<XRFrameDataProvider> data_provider_in,
    ::mojo::PendingReceiver<XRSessionClient> client_receiver_in,
    XRPresentationConnectionPtr submit_frame_sink_in,
    WTF::Vector<::device::mojom::blink::XRSessionFeature> enabled_features_in,
    XRSessionDeviceConfigPtr device_config_in,
    XREnvironmentBlendMode enviroment_blend_mode_in,
    XRInteractionMode interaction_mode_in)
    : data_provider(std::move(data_provider_in)),
      client_receiver(std::move(client_receiver_in)),
      submit_frame_sink(std::move(submit_frame_sink_in)),
      enabled_features(std::move(enabled_features_in)),
      device_config(std::move(device_config_in)),
      enviroment_blend_mode(std::move(enviroment_blend_mode_in)),
      interaction_mode(std::move(interaction_mode_in)) {}

XRSession::~XRSession() = default;

void XRSession::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "data_provider"), this->data_provider,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<XRFrameDataProvider>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "client_receiver"), this->client_receiver,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingReceiver<XRSessionClient>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "submit_frame_sink"), this->submit_frame_sink,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type XRPresentationConnectionPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enabled_features"), this->enabled_features,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::Vector<::device::mojom::blink::XRSessionFeature>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "device_config"), this->device_config,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type XRSessionDeviceConfigPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enviroment_blend_mode"), this->enviroment_blend_mode,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type XREnvironmentBlendMode>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "interaction_mode"), this->interaction_mode,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type XRInteractionMode>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool XRSession::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRPresentationConnection::XRPresentationConnection()
    : provider(),
      client_receiver(),
      transport_options() {}

XRPresentationConnection::XRPresentationConnection(
    ::mojo::PendingRemote<XRPresentationProvider> provider_in,
    ::mojo::PendingReceiver<XRPresentationClient> client_receiver_in,
    XRPresentationTransportOptionsPtr transport_options_in)
    : provider(std::move(provider_in)),
      client_receiver(std::move(client_receiver_in)),
      transport_options(std::move(transport_options_in)) {}

XRPresentationConnection::~XRPresentationConnection() = default;

void XRPresentationConnection::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "provider"), this->provider,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<XRPresentationProvider>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "client_receiver"), this->client_receiver,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingReceiver<XRPresentationClient>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "transport_options"), this->transport_options,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type XRPresentationTransportOptionsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool XRPresentationConnection::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRInputSourceDescription::XRInputSourceDescription()
    : target_ray_mode(),
      handedness(),
      input_from_pointer(),
      profiles() {}

XRInputSourceDescription::XRInputSourceDescription(
    XRTargetRayMode target_ray_mode_in,
    XRHandedness handedness_in,
    const std::optional<::gfx::Transform>& input_from_pointer_in,
    WTF::Vector<WTF::String> profiles_in)
    : target_ray_mode(std::move(target_ray_mode_in)),
      handedness(std::move(handedness_in)),
      input_from_pointer(std::move(input_from_pointer_in)),
      profiles(std::move(profiles_in)) {}

XRInputSourceDescription::~XRInputSourceDescription() = default;

void XRInputSourceDescription::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "target_ray_mode"), this->target_ray_mode,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type XRTargetRayMode>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "handedness"), this->handedness,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type XRHandedness>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input_from_pointer"), this->input_from_pointer,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::gfx::Transform>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "profiles"), this->profiles,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::Vector<WTF::String>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool XRInputSourceDescription::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRInputSourceState::XRInputSourceState()
    : source_id(),
      description(),
      mojo_from_input(),
      emulated_position(),
      is_auxiliary(),
      primary_input_pressed(),
      primary_input_clicked(),
      primary_squeeze_pressed(),
      primary_squeeze_clicked(),
      gamepad(),
      overlay_pointer_position(),
      hand_tracking_data() {}

XRInputSourceState::XRInputSourceState(
    uint32_t source_id_in,
    XRInputSourceDescriptionPtr description_in,
    const std::optional<::gfx::Transform>& mojo_from_input_in,
    bool emulated_position_in,
    bool is_auxiliary_in,
    bool primary_input_pressed_in,
    bool primary_input_clicked_in,
    bool primary_squeeze_pressed_in,
    bool primary_squeeze_clicked_in,
    const std::optional<::device::Gamepad>& gamepad_in,
    const std::optional<::gfx::PointF>& overlay_pointer_position_in,
    ::device::mojom::blink::XRHandTrackingDataPtr hand_tracking_data_in)
    : source_id(std::move(source_id_in)),
      description(std::move(description_in)),
      mojo_from_input(std::move(mojo_from_input_in)),
      emulated_position(std::move(emulated_position_in)),
      is_auxiliary(std::move(is_auxiliary_in)),
      primary_input_pressed(std::move(primary_input_pressed_in)),
      primary_input_clicked(std::move(primary_input_clicked_in)),
      primary_squeeze_pressed(std::move(primary_squeeze_pressed_in)),
      primary_squeeze_clicked(std::move(primary_squeeze_clicked_in)),
      gamepad(std::move(gamepad_in)),
      overlay_pointer_position(std::move(overlay_pointer_position_in)),
      hand_tracking_data(std::move(hand_tracking_data_in)) {}

XRInputSourceState::~XRInputSourceState() = default;

void XRInputSourceState::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "source_id"), this->source_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "description"), this->description,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type XRInputSourceDescriptionPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mojo_from_input"), this->mojo_from_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::gfx::Transform>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "emulated_position"), this->emulated_position,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_auxiliary"), this->is_auxiliary,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "primary_input_pressed"), this->primary_input_pressed,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "primary_input_clicked"), this->primary_input_clicked,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "primary_squeeze_pressed"), this->primary_squeeze_pressed,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "primary_squeeze_clicked"), this->primary_squeeze_clicked,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "gamepad"), this->gamepad,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::device::Gamepad>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "overlay_pointer_position"), this->overlay_pointer_position,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::gfx::PointF>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hand_tracking_data"), this->hand_tracking_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::device::mojom::blink::XRHandTrackingDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool XRInputSourceState::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
VRFieldOfView::VRFieldOfView()
    : up_degrees(),
      down_degrees(),
      left_degrees(),
      right_degrees() {}

VRFieldOfView::VRFieldOfView(
    float up_degrees_in,
    float down_degrees_in,
    float left_degrees_in,
    float right_degrees_in)
    : up_degrees(std::move(up_degrees_in)),
      down_degrees(std::move(down_degrees_in)),
      left_degrees(std::move(left_degrees_in)),
      right_degrees(std::move(right_degrees_in)) {}

VRFieldOfView::~VRFieldOfView() = default;
size_t VRFieldOfView::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->up_degrees);
  seed = mojo::internal::WTFHash(seed, this->down_degrees);
  seed = mojo::internal::WTFHash(seed, this->left_degrees);
  seed = mojo::internal::WTFHash(seed, this->right_degrees);
  return seed;
}

void VRFieldOfView::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "up_degrees"), this->up_degrees,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "down_degrees"), this->down_degrees,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "left_degrees"), this->left_degrees,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "right_degrees"), this->right_degrees,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool VRFieldOfView::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
VRPose::VRPose()
    : orientation(),
      position(),
      emulated_position() {}

VRPose::VRPose(
    const std::optional<::gfx::Quaternion>& orientation_in,
    const std::optional<::gfx::Point3F>& position_in,
    bool emulated_position_in)
    : orientation(std::move(orientation_in)),
      position(std::move(position_in)),
      emulated_position(std::move(emulated_position_in)) {}

VRPose::~VRPose() = default;

void VRPose::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "orientation"), this->orientation,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::gfx::Quaternion>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "position"), this->position,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::gfx::Point3F>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "emulated_position"), this->emulated_position,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool VRPose::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Pose::Pose()
    : orientation(),
      position() {}

Pose::Pose(
    const ::gfx::Quaternion& orientation_in,
    const ::gfx::Point3F& position_in)
    : orientation(std::move(orientation_in)),
      position(std::move(position_in)) {}

Pose::~Pose() = default;

void Pose::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "orientation"), this->orientation,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Quaternion&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "position"), this->position,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Point3F&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Pose::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRRay::XRRay()
    : origin(),
      direction() {}

XRRay::XRRay(
    const ::gfx::Point3F& origin_in,
    const ::gfx::Vector3dF& direction_in)
    : origin(std::move(origin_in)),
      direction(std::move(direction_in)) {}

XRRay::~XRRay() = default;

void XRRay::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "origin"), this->origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Point3F&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "direction"), this->direction,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Vector3dF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool XRRay::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRHitResult::XRHitResult()
    : mojo_from_result(),
      plane_id() {}

XRHitResult::XRHitResult(
    const ::device::Pose& mojo_from_result_in,
    uint64_t plane_id_in)
    : mojo_from_result(std::move(mojo_from_result_in)),
      plane_id(std::move(plane_id_in)) {}

XRHitResult::~XRHitResult() = default;

void XRHitResult::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mojo_from_result"), this->mojo_from_result,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::device::Pose&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "plane_id"), this->plane_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool XRHitResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRView::XRView()
    : eye(),
      field_of_view(),
      mojo_from_view(),
      viewport(),
      depth_data(),
      is_first_person_observer(false) {}

XRView::XRView(
    XREye eye_in,
    VRFieldOfViewPtr field_of_view_in,
    const ::gfx::Transform& mojo_from_view_in,
    const ::gfx::Rect& viewport_in,
    XRDepthDataPtr depth_data_in,
    bool is_first_person_observer_in)
    : eye(std::move(eye_in)),
      field_of_view(std::move(field_of_view_in)),
      mojo_from_view(std::move(mojo_from_view_in)),
      viewport(std::move(viewport_in)),
      depth_data(std::move(depth_data_in)),
      is_first_person_observer(std::move(is_first_person_observer_in)) {}

XRView::~XRView() = default;

void XRView::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "eye"), this->eye,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type XREye>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "field_of_view"), this->field_of_view,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type VRFieldOfViewPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mojo_from_view"), this->mojo_from_view,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Transform&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "viewport"), this->viewport,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Rect&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "depth_data"), this->depth_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type XRDepthDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_first_person_observer"), this->is_first_person_observer,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool XRView::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
VRStageParameters::VRStageParameters()
    : mojo_from_stage(),
      bounds() {}

VRStageParameters::VRStageParameters(
    const ::gfx::Transform& mojo_from_stage_in,
    std::optional<WTF::Vector<::gfx::Point3F>> bounds_in)
    : mojo_from_stage(std::move(mojo_from_stage_in)),
      bounds(std::move(bounds_in)) {}

VRStageParameters::~VRStageParameters() = default;

void VRStageParameters::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mojo_from_stage"), this->mojo_from_stage,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Transform&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bounds"), this->bounds,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<WTF::Vector<::gfx::Point3F>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool VRStageParameters::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRPresentationTransportOptions::XRPresentationTransportOptions()
    : transport_method(),
      wait_for_transfer_notification(),
      wait_for_render_notification(),
      wait_for_gpu_fence() {}

XRPresentationTransportOptions::XRPresentationTransportOptions(
    XRPresentationTransportMethod transport_method_in,
    bool wait_for_transfer_notification_in,
    bool wait_for_render_notification_in,
    bool wait_for_gpu_fence_in)
    : transport_method(std::move(transport_method_in)),
      wait_for_transfer_notification(std::move(wait_for_transfer_notification_in)),
      wait_for_render_notification(std::move(wait_for_render_notification_in)),
      wait_for_gpu_fence(std::move(wait_for_gpu_fence_in)) {}

XRPresentationTransportOptions::~XRPresentationTransportOptions() = default;
size_t XRPresentationTransportOptions::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->transport_method);
  seed = mojo::internal::WTFHash(seed, this->wait_for_transfer_notification);
  seed = mojo::internal::WTFHash(seed, this->wait_for_render_notification);
  seed = mojo::internal::WTFHash(seed, this->wait_for_gpu_fence);
  return seed;
}

void XRPresentationTransportOptions::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "transport_method"), this->transport_method,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type XRPresentationTransportMethod>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "wait_for_transfer_notification"), this->wait_for_transfer_notification,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "wait_for_render_notification"), this->wait_for_render_notification,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "wait_for_gpu_fence"), this->wait_for_gpu_fence,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool XRPresentationTransportOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRInputSourceSpaceInfo::XRInputSourceSpaceInfo()
    : input_source_id(),
      input_source_space_type() {}

XRInputSourceSpaceInfo::XRInputSourceSpaceInfo(
    uint32_t input_source_id_in,
    XRInputSourceSpaceType input_source_space_type_in)
    : input_source_id(std::move(input_source_id_in)),
      input_source_space_type(std::move(input_source_space_type_in)) {}

XRInputSourceSpaceInfo::~XRInputSourceSpaceInfo() = default;
size_t XRInputSourceSpaceInfo::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->input_source_id);
  seed = mojo::internal::WTFHash(seed, this->input_source_space_type);
  return seed;
}

void XRInputSourceSpaceInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input_source_id"), this->input_source_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input_source_space_type"), this->input_source_space_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type XRInputSourceSpaceType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool XRInputSourceSpaceInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRHandJointSpaceInfo::XRHandJointSpaceInfo()
    : handedness(),
      joint() {}

XRHandJointSpaceInfo::XRHandJointSpaceInfo(
    XRHandedness handedness_in,
    ::device::mojom::blink::XRHandJoint joint_in)
    : handedness(std::move(handedness_in)),
      joint(std::move(joint_in)) {}

XRHandJointSpaceInfo::~XRHandJointSpaceInfo() = default;
size_t XRHandJointSpaceInfo::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->handedness);
  seed = mojo::internal::WTFHash(seed, this->joint);
  return seed;
}

void XRHandJointSpaceInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "handedness"), this->handedness,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type XRHandedness>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "joint"), this->joint,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::device::mojom::blink::XRHandJoint>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool XRHandJointSpaceInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRPlanePointData::XRPlanePointData()
    : x(),
      z() {}

XRPlanePointData::XRPlanePointData(
    float x_in,
    float z_in)
    : x(std::move(x_in)),
      z(std::move(z_in)) {}

XRPlanePointData::~XRPlanePointData() = default;
size_t XRPlanePointData::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->x);
  seed = mojo::internal::WTFHash(seed, this->z);
  return seed;
}

void XRPlanePointData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "x"), this->x,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "z"), this->z,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool XRPlanePointData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRPlaneData::XRPlaneData()
    : id(),
      orientation(),
      mojo_from_plane(),
      polygon() {}

XRPlaneData::XRPlaneData(
    uint64_t id_in,
    XRPlaneOrientation orientation_in,
    const std::optional<::device::Pose>& mojo_from_plane_in,
    WTF::Vector<XRPlanePointDataPtr> polygon_in)
    : id(std::move(id_in)),
      orientation(std::move(orientation_in)),
      mojo_from_plane(std::move(mojo_from_plane_in)),
      polygon(std::move(polygon_in)) {}

XRPlaneData::~XRPlaneData() = default;

void XRPlaneData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "orientation"), this->orientation,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type XRPlaneOrientation>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mojo_from_plane"), this->mojo_from_plane,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::device::Pose>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "polygon"), this->polygon,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type WTF::Vector<XRPlanePointDataPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool XRPlaneData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRPlaneDetectionData::XRPlaneDetectionData()
    : all_planes_ids(),
      updated_planes_data() {}

XRPlaneDetectionData::XRPlaneDetectionData(
    WTF::Vector<uint64_t> all_planes_ids_in,
    WTF::Vector<XRPlaneDataPtr> updated_planes_data_in)
    : all_planes_ids(std::move(all_planes_ids_in)),
      updated_planes_data(std::move(updated_planes_data_in)) {}

XRPlaneDetectionData::~XRPlaneDetectionData() = default;

void XRPlaneDetectionData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "all_planes_ids"), this->all_planes_ids,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::Vector<uint64_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "updated_planes_data"), this->updated_planes_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type WTF::Vector<XRPlaneDataPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool XRPlaneDetectionData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRAnchorData::XRAnchorData()
    : id(),
      mojo_from_anchor() {}

XRAnchorData::XRAnchorData(
    uint64_t id_in,
    const std::optional<::device::Pose>& mojo_from_anchor_in)
    : id(std::move(id_in)),
      mojo_from_anchor(std::move(mojo_from_anchor_in)) {}

XRAnchorData::~XRAnchorData() = default;

void XRAnchorData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mojo_from_anchor"), this->mojo_from_anchor,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::device::Pose>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool XRAnchorData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRAnchorsData::XRAnchorsData()
    : all_anchors_ids(),
      updated_anchors_data() {}

XRAnchorsData::XRAnchorsData(
    WTF::Vector<uint64_t> all_anchors_ids_in,
    WTF::Vector<XRAnchorDataPtr> updated_anchors_data_in)
    : all_anchors_ids(std::move(all_anchors_ids_in)),
      updated_anchors_data(std::move(updated_anchors_data_in)) {}

XRAnchorsData::~XRAnchorsData() = default;

void XRAnchorsData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "all_anchors_ids"), this->all_anchors_ids,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::Vector<uint64_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "updated_anchors_data"), this->updated_anchors_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type WTF::Vector<XRAnchorDataPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool XRAnchorsData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRHitTestSubscriptionResultData::XRHitTestSubscriptionResultData()
    : subscription_id(),
      hit_test_results() {}

XRHitTestSubscriptionResultData::XRHitTestSubscriptionResultData(
    uint64_t subscription_id_in,
    WTF::Vector<XRHitResultPtr> hit_test_results_in)
    : subscription_id(std::move(subscription_id_in)),
      hit_test_results(std::move(hit_test_results_in)) {}

XRHitTestSubscriptionResultData::~XRHitTestSubscriptionResultData() = default;

void XRHitTestSubscriptionResultData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "subscription_id"), this->subscription_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hit_test_results"), this->hit_test_results,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type WTF::Vector<XRHitResultPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool XRHitTestSubscriptionResultData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRHitTestTransientInputSubscriptionResultData::XRHitTestTransientInputSubscriptionResultData()
    : subscription_id(),
      input_source_id_to_hit_test_results() {}

XRHitTestTransientInputSubscriptionResultData::XRHitTestTransientInputSubscriptionResultData(
    uint64_t subscription_id_in,
    WTF::HashMap<uint32_t, WTF::Vector<XRHitResultPtr>> input_source_id_to_hit_test_results_in)
    : subscription_id(std::move(subscription_id_in)),
      input_source_id_to_hit_test_results(std::move(input_source_id_to_hit_test_results_in)) {}

XRHitTestTransientInputSubscriptionResultData::~XRHitTestTransientInputSubscriptionResultData() = default;

void XRHitTestTransientInputSubscriptionResultData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "subscription_id"), this->subscription_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input_source_id_to_hit_test_results"), this->input_source_id_to_hit_test_results,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type WTF::HashMap<uint32_t, WTF::Vector<XRHitResultPtr>>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool XRHitTestTransientInputSubscriptionResultData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRHitTestSubscriptionResultsData::XRHitTestSubscriptionResultsData()
    : results(),
      transient_input_results() {}

XRHitTestSubscriptionResultsData::XRHitTestSubscriptionResultsData(
    WTF::Vector<XRHitTestSubscriptionResultDataPtr> results_in,
    WTF::Vector<XRHitTestTransientInputSubscriptionResultDataPtr> transient_input_results_in)
    : results(std::move(results_in)),
      transient_input_results(std::move(transient_input_results_in)) {}

XRHitTestSubscriptionResultsData::~XRHitTestSubscriptionResultsData() = default;

void XRHitTestSubscriptionResultsData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "results"), this->results,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type WTF::Vector<XRHitTestSubscriptionResultDataPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "transient_input_results"), this->transient_input_results,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type WTF::Vector<XRHitTestTransientInputSubscriptionResultDataPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool XRHitTestSubscriptionResultsData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
RgbTupleF32::RgbTupleF32()
    : red(),
      green(),
      blue() {}

RgbTupleF32::RgbTupleF32(
    float red_in,
    float green_in,
    float blue_in)
    : red(std::move(red_in)),
      green(std::move(green_in)),
      blue(std::move(blue_in)) {}

RgbTupleF32::~RgbTupleF32() = default;

void RgbTupleF32::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "red"), this->red,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "green"), this->green,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "blue"), this->blue,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool RgbTupleF32::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRSphericalHarmonics::XRSphericalHarmonics()
    : coefficients() {}

XRSphericalHarmonics::XRSphericalHarmonics(
    WTF::Vector<::device::RgbTupleF32> coefficients_in)
    : coefficients(std::move(coefficients_in)) {}

XRSphericalHarmonics::~XRSphericalHarmonics() = default;

void XRSphericalHarmonics::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "coefficients"), this->coefficients,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::Vector<::device::RgbTupleF32>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool XRSphericalHarmonics::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
RgbaTupleF16::RgbaTupleF16()
    : red(),
      green(),
      blue(),
      alpha() {}

RgbaTupleF16::RgbaTupleF16(
    uint16_t red_in,
    uint16_t green_in,
    uint16_t blue_in,
    uint16_t alpha_in)
    : red(std::move(red_in)),
      green(std::move(green_in)),
      blue(std::move(blue_in)),
      alpha(std::move(alpha_in)) {}

RgbaTupleF16::~RgbaTupleF16() = default;

void RgbaTupleF16::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "red"), this->red,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint16_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "green"), this->green,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint16_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "blue"), this->blue,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint16_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "alpha"), this->alpha,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint16_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool RgbaTupleF16::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRCubeMap::XRCubeMap()
    : width_and_height(),
      positive_x(),
      negative_x(),
      positive_y(),
      negative_y(),
      positive_z(),
      negative_z() {}

XRCubeMap::XRCubeMap(
    uint32_t width_and_height_in,
    WTF::Vector<::device::RgbaTupleF16> positive_x_in,
    WTF::Vector<::device::RgbaTupleF16> negative_x_in,
    WTF::Vector<::device::RgbaTupleF16> positive_y_in,
    WTF::Vector<::device::RgbaTupleF16> negative_y_in,
    WTF::Vector<::device::RgbaTupleF16> positive_z_in,
    WTF::Vector<::device::RgbaTupleF16> negative_z_in)
    : width_and_height(std::move(width_and_height_in)),
      positive_x(std::move(positive_x_in)),
      negative_x(std::move(negative_x_in)),
      positive_y(std::move(positive_y_in)),
      negative_y(std::move(negative_y_in)),
      positive_z(std::move(positive_z_in)),
      negative_z(std::move(negative_z_in)) {}

XRCubeMap::~XRCubeMap() = default;

void XRCubeMap::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "width_and_height"), this->width_and_height,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "positive_x"), this->positive_x,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::Vector<::device::RgbaTupleF16>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "negative_x"), this->negative_x,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::Vector<::device::RgbaTupleF16>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "positive_y"), this->positive_y,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::Vector<::device::RgbaTupleF16>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "negative_y"), this->negative_y,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::Vector<::device::RgbaTupleF16>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "positive_z"), this->positive_z,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::Vector<::device::RgbaTupleF16>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "negative_z"), this->negative_z,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::Vector<::device::RgbaTupleF16>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool XRCubeMap::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRLightProbe::XRLightProbe()
    : spherical_harmonics(),
      main_light_direction(),
      main_light_intensity() {}

XRLightProbe::XRLightProbe(
    XRSphericalHarmonicsPtr spherical_harmonics_in,
    const ::gfx::Vector3dF& main_light_direction_in,
    const ::device::RgbTupleF32& main_light_intensity_in)
    : spherical_harmonics(std::move(spherical_harmonics_in)),
      main_light_direction(std::move(main_light_direction_in)),
      main_light_intensity(std::move(main_light_intensity_in)) {}

XRLightProbe::~XRLightProbe() = default;

void XRLightProbe::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "spherical_harmonics"), this->spherical_harmonics,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type XRSphericalHarmonicsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "main_light_direction"), this->main_light_direction,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Vector3dF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "main_light_intensity"), this->main_light_intensity,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::device::RgbTupleF32&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool XRLightProbe::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRReflectionProbe::XRReflectionProbe()
    : cube_map() {}

XRReflectionProbe::XRReflectionProbe(
    XRCubeMapPtr cube_map_in)
    : cube_map(std::move(cube_map_in)) {}

XRReflectionProbe::~XRReflectionProbe() = default;

void XRReflectionProbe::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cube_map"), this->cube_map,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type XRCubeMapPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool XRReflectionProbe::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRLightEstimationData::XRLightEstimationData()
    : light_probe(),
      reflection_probe() {}

XRLightEstimationData::XRLightEstimationData(
    XRLightProbePtr light_probe_in,
    XRReflectionProbePtr reflection_probe_in)
    : light_probe(std::move(light_probe_in)),
      reflection_probe(std::move(reflection_probe_in)) {}

XRLightEstimationData::~XRLightEstimationData() = default;

void XRLightEstimationData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "light_probe"), this->light_probe,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type XRLightProbePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "reflection_probe"), this->reflection_probe,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type XRReflectionProbePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool XRLightEstimationData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRDepthDataStillValid::XRDepthDataStillValid() {}

XRDepthDataStillValid::~XRDepthDataStillValid() = default;
size_t XRDepthDataStillValid::Hash(size_t seed) const {
  return seed;
}

void XRDepthDataStillValid::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
}

bool XRDepthDataStillValid::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRDepthDataUpdated::XRDepthDataUpdated()
    : pixel_data(),
      norm_texture_from_norm_view(),
      size(),
      raw_value_to_meters() {}

XRDepthDataUpdated::XRDepthDataUpdated(
    ::mojo_base::BigBuffer pixel_data_in,
    const ::gfx::Transform& norm_texture_from_norm_view_in,
    const ::gfx::Size& size_in,
    float raw_value_to_meters_in)
    : pixel_data(std::move(pixel_data_in)),
      norm_texture_from_norm_view(std::move(norm_texture_from_norm_view_in)),
      size(std::move(size_in)),
      raw_value_to_meters(std::move(raw_value_to_meters_in)) {}

XRDepthDataUpdated::~XRDepthDataUpdated() = default;

void XRDepthDataUpdated::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pixel_data"), this->pixel_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo_base::BigBuffer>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "norm_texture_from_norm_view"), this->norm_texture_from_norm_view,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Transform&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "size"), this->size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "raw_value_to_meters"), this->raw_value_to_meters,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool XRDepthDataUpdated::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRTrackedImageData::XRTrackedImageData()
    : index(),
      mojo_from_image(),
      actively_tracked(),
      width_in_meters() {}

XRTrackedImageData::XRTrackedImageData(
    uint32_t index_in,
    const ::device::Pose& mojo_from_image_in,
    bool actively_tracked_in,
    float width_in_meters_in)
    : index(std::move(index_in)),
      mojo_from_image(std::move(mojo_from_image_in)),
      actively_tracked(std::move(actively_tracked_in)),
      width_in_meters(std::move(width_in_meters_in)) {}

XRTrackedImageData::~XRTrackedImageData() = default;

void XRTrackedImageData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "index"), this->index,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mojo_from_image"), this->mojo_from_image,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::device::Pose&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "actively_tracked"), this->actively_tracked,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "width_in_meters"), this->width_in_meters,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool XRTrackedImageData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRTrackedImagesData::XRTrackedImagesData()
    : images_data(),
      image_trackable_scores() {}

XRTrackedImagesData::XRTrackedImagesData(
    WTF::Vector<XRTrackedImageDataPtr> images_data_in,
    std::optional<WTF::Vector<bool>> image_trackable_scores_in)
    : images_data(std::move(images_data_in)),
      image_trackable_scores(std::move(image_trackable_scores_in)) {}

XRTrackedImagesData::~XRTrackedImagesData() = default;

void XRTrackedImagesData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "images_data"), this->images_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type WTF::Vector<XRTrackedImageDataPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "image_trackable_scores"), this->image_trackable_scores,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<WTF::Vector<bool>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool XRTrackedImagesData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRFrameData::XRFrameData()
    : mojo_from_viewer(),
      time_delta(),
      buffer_shared_image(),
      buffer_sync_token(),
      camera_image_buffer_shared_image(),
      camera_image_buffer_sync_token(),
      camera_image_size(),
      mojo_space_reset(),
      mojo_from_floor(),
      frame_id(),
      views(),
      input_state(),
      stage_parameters_id(),
      stage_parameters(),
      detected_planes_data(),
      anchors_data(),
      light_estimation_data(),
      hit_test_subscription_results(),
      rendering_time_ratio(),
      tracked_images() {}

XRFrameData::XRFrameData(
    VRPosePtr mojo_from_viewer_in,
    ::base::TimeDelta time_delta_in,
    const std::optional<::gpu::ExportedSharedImage>& buffer_shared_image_in,
    const std::optional<::gpu::SyncToken>& buffer_sync_token_in,
    const std::optional<::gpu::ExportedSharedImage>& camera_image_buffer_shared_image_in,
    const std::optional<::gpu::SyncToken>& camera_image_buffer_sync_token_in,
    const std::optional<::gfx::Size>& camera_image_size_in,
    bool mojo_space_reset_in,
    const std::optional<::gfx::Transform>& mojo_from_floor_in,
    int16_t frame_id_in,
    WTF::Vector<XRViewPtr> views_in,
    std::optional<WTF::Vector<XRInputSourceStatePtr>> input_state_in,
    uint32_t stage_parameters_id_in,
    VRStageParametersPtr stage_parameters_in,
    XRPlaneDetectionDataPtr detected_planes_data_in,
    XRAnchorsDataPtr anchors_data_in,
    XRLightEstimationDataPtr light_estimation_data_in,
    XRHitTestSubscriptionResultsDataPtr hit_test_subscription_results_in,
    float rendering_time_ratio_in,
    XRTrackedImagesDataPtr tracked_images_in)
    : mojo_from_viewer(std::move(mojo_from_viewer_in)),
      time_delta(std::move(time_delta_in)),
      buffer_shared_image(std::move(buffer_shared_image_in)),
      buffer_sync_token(std::move(buffer_sync_token_in)),
      camera_image_buffer_shared_image(std::move(camera_image_buffer_shared_image_in)),
      camera_image_buffer_sync_token(std::move(camera_image_buffer_sync_token_in)),
      camera_image_size(std::move(camera_image_size_in)),
      mojo_space_reset(std::move(mojo_space_reset_in)),
      mojo_from_floor(std::move(mojo_from_floor_in)),
      frame_id(std::move(frame_id_in)),
      views(std::move(views_in)),
      input_state(std::move(input_state_in)),
      stage_parameters_id(std::move(stage_parameters_id_in)),
      stage_parameters(std::move(stage_parameters_in)),
      detected_planes_data(std::move(detected_planes_data_in)),
      anchors_data(std::move(anchors_data_in)),
      light_estimation_data(std::move(light_estimation_data_in)),
      hit_test_subscription_results(std::move(hit_test_subscription_results_in)),
      rendering_time_ratio(std::move(rendering_time_ratio_in)),
      tracked_images(std::move(tracked_images_in)) {}

XRFrameData::~XRFrameData() = default;

void XRFrameData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mojo_from_viewer"), this->mojo_from_viewer,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type VRPosePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "time_delta"), this->time_delta,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "buffer_shared_image"), this->buffer_shared_image,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::gpu::ExportedSharedImage>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "buffer_sync_token"), this->buffer_sync_token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::gpu::SyncToken>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "camera_image_buffer_shared_image"), this->camera_image_buffer_shared_image,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::gpu::ExportedSharedImage>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "camera_image_buffer_sync_token"), this->camera_image_buffer_sync_token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::gpu::SyncToken>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "camera_image_size"), this->camera_image_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::gfx::Size>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mojo_space_reset"), this->mojo_space_reset,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mojo_from_floor"), this->mojo_from_floor,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::gfx::Transform>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame_id"), this->frame_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int16_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "views"), this->views,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type WTF::Vector<XRViewPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input_state"), this->input_state,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<WTF::Vector<XRInputSourceStatePtr>>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "stage_parameters_id"), this->stage_parameters_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "stage_parameters"), this->stage_parameters,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type VRStageParametersPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "detected_planes_data"), this->detected_planes_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type XRPlaneDetectionDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "anchors_data"), this->anchors_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type XRAnchorsDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "light_estimation_data"), this->light_estimation_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type XRLightEstimationDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hit_test_subscription_results"), this->hit_test_subscription_results,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type XRHitTestSubscriptionResultsDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "rendering_time_ratio"), this->rendering_time_ratio,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tracked_images"), this->tracked_images,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type XRTrackedImagesDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool XRFrameData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
RequestSessionSuccess::RequestSessionSuccess()
    : session(),
      trace_id(),
      metrics_recorder(),
      xr_internals_listener() {}

RequestSessionSuccess::RequestSessionSuccess(
    XRSessionPtr session_in,
    uint64_t trace_id_in,
    ::mojo::PendingRemote<XRSessionMetricsRecorder> metrics_recorder_in,
    ::mojo::PendingRemote<WebXrInternalsRendererListener> xr_internals_listener_in)
    : session(std::move(session_in)),
      trace_id(std::move(trace_id_in)),
      metrics_recorder(std::move(metrics_recorder_in)),
      xr_internals_listener(std::move(xr_internals_listener_in)) {}

RequestSessionSuccess::~RequestSessionSuccess() = default;

void RequestSessionSuccess::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "session"), this->session,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type XRSessionPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "trace_id"), this->trace_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "metrics_recorder"), this->metrics_recorder,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<XRSessionMetricsRecorder>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "xr_internals_listener"), this->xr_internals_listener,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<WebXrInternalsRendererListener>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool RequestSessionSuccess::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRFrameDataRequestOptions::XRFrameDataRequestOptions()
    : include_lighting_estimation_data(),
      stage_parameters_id() {}

XRFrameDataRequestOptions::XRFrameDataRequestOptions(
    bool include_lighting_estimation_data_in,
    uint32_t stage_parameters_id_in)
    : include_lighting_estimation_data(std::move(include_lighting_estimation_data_in)),
      stage_parameters_id(std::move(stage_parameters_id_in)) {}

XRFrameDataRequestOptions::~XRFrameDataRequestOptions() = default;
size_t XRFrameDataRequestOptions::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->include_lighting_estimation_data);
  seed = mojo::internal::WTFHash(seed, this->stage_parameters_id);
  return seed;
}

void XRFrameDataRequestOptions::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "include_lighting_estimation_data"), this->include_lighting_estimation_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "stage_parameters_id"), this->stage_parameters_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool XRFrameDataRequestOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRNativeOriginInformation::XRNativeOriginInformation() : tag_(Tag::kInputSourceSpaceInfo) {
  data_.input_source_space_info = new XRInputSourceSpaceInfoPtr;
}

XRNativeOriginInformation::~XRNativeOriginInformation() {
  DestroyActive();
}


void XRNativeOriginInformation::set_input_source_space_info(
    XRInputSourceSpaceInfoPtr input_source_space_info) {
  if (tag_ == Tag::kInputSourceSpaceInfo) {
    *(data_.input_source_space_info) = std::move(input_source_space_info);
  } else {
    DestroyActive();
    tag_ = Tag::kInputSourceSpaceInfo;
    data_.input_source_space_info = new XRInputSourceSpaceInfoPtr(
        std::move(input_source_space_info));
  }
}
void XRNativeOriginInformation::set_plane_id(
    uint64_t plane_id) {
  if (tag_ != Tag::kPlaneId) {
    DestroyActive();
    tag_ = Tag::kPlaneId;
  }
  data_.plane_id = plane_id;
}
void XRNativeOriginInformation::set_anchor_id(
    uint64_t anchor_id) {
  if (tag_ != Tag::kAnchorId) {
    DestroyActive();
    tag_ = Tag::kAnchorId;
  }
  data_.anchor_id = anchor_id;
}
void XRNativeOriginInformation::set_reference_space_type(
    XRReferenceSpaceType reference_space_type) {
  if (tag_ != Tag::kReferenceSpaceType) {
    DestroyActive();
    tag_ = Tag::kReferenceSpaceType;
  }
  data_.reference_space_type = reference_space_type;
}
void XRNativeOriginInformation::set_hand_joint_space_info(
    XRHandJointSpaceInfoPtr hand_joint_space_info) {
  if (tag_ == Tag::kHandJointSpaceInfo) {
    *(data_.hand_joint_space_info) = std::move(hand_joint_space_info);
  } else {
    DestroyActive();
    tag_ = Tag::kHandJointSpaceInfo;
    data_.hand_joint_space_info = new XRHandJointSpaceInfoPtr(
        std::move(hand_joint_space_info));
  }
}
void XRNativeOriginInformation::set_image_index(
    uint32_t image_index) {
  if (tag_ != Tag::kImageIndex) {
    DestroyActive();
    tag_ = Tag::kImageIndex;
  }
  data_.image_index = image_index;
}

void XRNativeOriginInformation::DestroyActive() {
  switch (tag_) {

    case Tag::kInputSourceSpaceInfo:

      delete data_.input_source_space_info;
      break;
    case Tag::kPlaneId:

      break;
    case Tag::kAnchorId:

      break;
    case Tag::kReferenceSpaceType:

      break;
    case Tag::kHandJointSpaceInfo:

      delete data_.hand_joint_space_info;
      break;
    case Tag::kImageIndex:

      break;
  }
}
size_t XRNativeOriginInformation::Hash(size_t seed) const {
  seed = mojo::internal::HashCombine(seed, static_cast<uint32_t>(tag_));
  switch (tag_) {

    case Tag::kInputSourceSpaceInfo:
      return mojo::internal::WTFHash(seed, *data_.input_source_space_info);
    case Tag::kPlaneId:
      return mojo::internal::WTFHash(seed, data_.plane_id);
    case Tag::kAnchorId:
      return mojo::internal::WTFHash(seed, data_.anchor_id);
    case Tag::kReferenceSpaceType:
      return mojo::internal::WTFHash(seed, data_.reference_space_type);
    case Tag::kHandJointSpaceInfo:
      return mojo::internal::WTFHash(seed, *data_.hand_joint_space_info);
    case Tag::kImageIndex:
      return mojo::internal::WTFHash(seed, data_.image_index);
    default:
      NOTREACHED();
  }
}

bool XRNativeOriginInformation::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
XRDepthData::XRDepthData() : tag_(Tag::kDataStillValid) {
  data_.data_still_valid = new XRDepthDataStillValidPtr;
}

XRDepthData::~XRDepthData() {
  DestroyActive();
}


void XRDepthData::set_data_still_valid(
    XRDepthDataStillValidPtr data_still_valid) {
  if (tag_ == Tag::kDataStillValid) {
    *(data_.data_still_valid) = std::move(data_still_valid);
  } else {
    DestroyActive();
    tag_ = Tag::kDataStillValid;
    data_.data_still_valid = new XRDepthDataStillValidPtr(
        std::move(data_still_valid));
  }
}
void XRDepthData::set_updated_depth_data(
    XRDepthDataUpdatedPtr updated_depth_data) {
  if (tag_ == Tag::kUpdatedDepthData) {
    *(data_.updated_depth_data) = std::move(updated_depth_data);
  } else {
    DestroyActive();
    tag_ = Tag::kUpdatedDepthData;
    data_.updated_depth_data = new XRDepthDataUpdatedPtr(
        std::move(updated_depth_data));
  }
}

void XRDepthData::DestroyActive() {
  switch (tag_) {

    case Tag::kDataStillValid:

      delete data_.data_still_valid;
      break;
    case Tag::kUpdatedDepthData:

      delete data_.updated_depth_data;
      break;
  }
}

bool XRDepthData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
RequestSessionResult::RequestSessionResult() : tag_(Tag::kSuccess) {
  data_.success = new RequestSessionSuccessPtr;
}

RequestSessionResult::~RequestSessionResult() {
  DestroyActive();
}


void RequestSessionResult::set_success(
    RequestSessionSuccessPtr success) {
  if (tag_ == Tag::kSuccess) {
    *(data_.success) = std::move(success);
  } else {
    DestroyActive();
    tag_ = Tag::kSuccess;
    data_.success = new RequestSessionSuccessPtr(
        std::move(success));
  }
}
void RequestSessionResult::set_failure_reason(
    ::device::mojom::blink::RequestSessionError failure_reason) {
  if (tag_ != Tag::kFailureReason) {
    DestroyActive();
    tag_ = Tag::kFailureReason;
  }
  data_.failure_reason = failure_reason;
}

void RequestSessionResult::DestroyActive() {
  switch (tag_) {

    case Tag::kSuccess:

      delete data_.success;
      break;
    case Tag::kFailureReason:

      break;
  }
}

bool RequestSessionResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
const char VRService::Name_[] = "device.mojom.VRService";

VRService::IPCStableHashFunction VRService::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::VRService>(message.name())) {
    case messages::VRService::kSetClient: {
      return &VRService::SetClient_Sym::IPCStableHash;
    }
    case messages::VRService::kRequestSession: {
      return &VRService::RequestSession_Sym::IPCStableHash;
    }
    case messages::VRService::kSupportsSession: {
      return &VRService::SupportsSession_Sym::IPCStableHash;
    }
    case messages::VRService::kExitPresent: {
      return &VRService::ExitPresent_Sym::IPCStableHash;
    }
    case messages::VRService::kSetFramesThrottled: {
      return &VRService::SetFramesThrottled_Sym::IPCStableHash;
    }
    case messages::VRService::kMakeXrCompatible: {
      return &VRService::MakeXrCompatible_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* VRService::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::VRService>(message.name())) {
      case messages::VRService::kSetClient:
            return "Receive device::mojom::VRService::SetClient";
      case messages::VRService::kRequestSession:
            return "Receive device::mojom::VRService::RequestSession";
      case messages::VRService::kSupportsSession:
            return "Receive device::mojom::VRService::SupportsSession";
      case messages::VRService::kExitPresent:
            return "Receive device::mojom::VRService::ExitPresent";
      case messages::VRService::kSetFramesThrottled:
            return "Receive device::mojom::VRService::SetFramesThrottled";
      case messages::VRService::kMakeXrCompatible:
            return "Receive device::mojom::VRService::MakeXrCompatible";
    }
  } else {
    switch (static_cast<messages::VRService>(message.name())) {
      case messages::VRService::kSetClient:
            return "Receive reply device::mojom::VRService::SetClient";
      case messages::VRService::kRequestSession:
            return "Receive reply device::mojom::VRService::RequestSession";
      case messages::VRService::kSupportsSession:
            return "Receive reply device::mojom::VRService::SupportsSession";
      case messages::VRService::kExitPresent:
            return "Receive reply device::mojom::VRService::ExitPresent";
      case messages::VRService::kSetFramesThrottled:
            return "Receive reply device::mojom::VRService::SetFramesThrottled";
      case messages::VRService::kMakeXrCompatible:
            return "Receive reply device::mojom::VRService::MakeXrCompatible";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t VRService::SetClient_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)device::mojom::VRService::SetClient");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t VRService::RequestSession_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)device::mojom::VRService::RequestSession");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t VRService::SupportsSession_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)device::mojom::VRService::SupportsSession");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t VRService::ExitPresent_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)device::mojom::VRService::ExitPresent");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t VRService::SetFramesThrottled_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)device::mojom::VRService::SetFramesThrottled");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t VRService::MakeXrCompatible_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)device::mojom::VRService::MakeXrCompatible");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)
bool VRService::MakeXrCompatible(XrCompatibleResult* out_xr_compatible_result) {
  NOTREACHED();
}

class VRService_RequestSession_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  VRService_RequestSession_ForwardToCallback(
      VRService::RequestSessionCallback callback
      ) : callback_(std::move(callback)) {
  }

  VRService_RequestSession_ForwardToCallback(const VRService_RequestSession_ForwardToCallback&) = delete;
  VRService_RequestSession_ForwardToCallback& operator=(const VRService_RequestSession_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  VRService::RequestSessionCallback callback_;
};

class VRService_SupportsSession_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  VRService_SupportsSession_ForwardToCallback(
      VRService::SupportsSessionCallback callback
      ) : callback_(std::move(callback)) {
  }

  VRService_SupportsSession_ForwardToCallback(const VRService_SupportsSession_ForwardToCallback&) = delete;
  VRService_SupportsSession_ForwardToCallback& operator=(const VRService_SupportsSession_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  VRService::SupportsSessionCallback callback_;
};

class VRService_ExitPresent_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  VRService_ExitPresent_ForwardToCallback(
      VRService::ExitPresentCallback callback
      ) : callback_(std::move(callback)) {
  }

  VRService_ExitPresent_ForwardToCallback(const VRService_ExitPresent_ForwardToCallback&) = delete;
  VRService_ExitPresent_ForwardToCallback& operator=(const VRService_ExitPresent_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  VRService::ExitPresentCallback callback_;
};
class VRService_MakeXrCompatible_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  VRService_MakeXrCompatible_HandleSyncResponse(
      bool* result, XrCompatibleResult* out_xr_compatible_result)
      : result_(result), out_xr_compatible_result_(out_xr_compatible_result) {
    DCHECK(!*result_);
  }

  VRService_MakeXrCompatible_HandleSyncResponse(const VRService_MakeXrCompatible_HandleSyncResponse&) = delete;
  VRService_MakeXrCompatible_HandleSyncResponse& operator=(const VRService_MakeXrCompatible_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  XrCompatibleResult* out_xr_compatible_result_;};

class VRService_MakeXrCompatible_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  VRService_MakeXrCompatible_ForwardToCallback(
      VRService::MakeXrCompatibleCallback callback
      ) : callback_(std::move(callback)) {
  }

  VRService_MakeXrCompatible_ForwardToCallback(const VRService_MakeXrCompatible_ForwardToCallback&) = delete;
  VRService_MakeXrCompatible_ForwardToCallback& operator=(const VRService_MakeXrCompatible_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  VRService::MakeXrCompatibleCallback callback_;
};

VRServiceProxy::VRServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void VRServiceProxy::SetClient(
    ::mojo::PendingRemote<VRServiceClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::VRService::SetClient", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<VRServiceClient>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VRService::kSetClient), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::VRService_SetClient_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::device::mojom::VRServiceClientInterfaceBase>>(
      in_client, &params->client, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid client in VRService.SetClient request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VRService::Name_);
  message.set_method_name("SetClient");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void VRServiceProxy::RequestSession(
    ::device::mojom::blink::XRSessionOptionsPtr in_options, RequestSessionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::VRService::RequestSession", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options,
                        "<value of type ::device::mojom::blink::XRSessionOptionsPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VRService::kRequestSession), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::VRService_RequestSession_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  mojo::internal::Serialize<::device::mojom::XRSessionOptionsDataView>(
      in_options, options_fragment);
  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->options.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null options in VRService.RequestSession request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VRService::Name_);
  message.set_method_name("RequestSession");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new VRService_RequestSession_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void VRServiceProxy::SupportsSession(
    ::device::mojom::blink::XRSessionOptionsPtr in_options, SupportsSessionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::VRService::SupportsSession", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options,
                        "<value of type ::device::mojom::blink::XRSessionOptionsPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VRService::kSupportsSession), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::VRService_SupportsSession_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  mojo::internal::Serialize<::device::mojom::XRSessionOptionsDataView>(
      in_options, options_fragment);
  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->options.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null options in VRService.SupportsSession request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VRService::Name_);
  message.set_method_name("SupportsSession");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new VRService_SupportsSession_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void VRServiceProxy::ExitPresent(
    ExitPresentCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send device::mojom::VRService::ExitPresent");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VRService::kExitPresent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::VRService_ExitPresent_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VRService::Name_);
  message.set_method_name("ExitPresent");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new VRService_ExitPresent_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void VRServiceProxy::SetFramesThrottled(
    bool in_throttled) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::VRService::SetFramesThrottled", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("throttled"), in_throttled,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VRService::kSetFramesThrottled), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::VRService_SetFramesThrottled_Params_Data> params(
          message);
  params.Allocate();
  params->throttled = in_throttled;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VRService::Name_);
  message.set_method_name("SetFramesThrottled");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
bool VRServiceProxy::MakeXrCompatible(
    XrCompatibleResult* out_param_xr_compatible_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "Call device::mojom::VRService::MakeXrCompatible (sync)");
#else
  TRACE_EVENT0("mojom", "VRService::MakeXrCompatible");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VRService::kMakeXrCompatible), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::VRService_MakeXrCompatible_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VRService::Name_);
  message.set_method_name("MakeXrCompatible");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new VRService_MakeXrCompatible_HandleSyncResponse(
          &result, out_param_xr_compatible_result));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "VRService::MakeXrCompatible", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("xr_compatible_result"), out_param_xr_compatible_result,
                        "<value of type XrCompatibleResult>");
   });
#endif
  return result;
}

void VRServiceProxy::MakeXrCompatible(
    MakeXrCompatibleCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send device::mojom::VRService::MakeXrCompatible");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VRService::kMakeXrCompatible), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::VRService_MakeXrCompatible_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VRService::Name_);
  message.set_method_name("MakeXrCompatible");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new VRService_MakeXrCompatible_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class VRService_RequestSession_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static VRService::RequestSessionCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<VRService_RequestSession_ProxyToResponder> proxy(
        new VRService_RequestSession_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&VRService_RequestSession_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~VRService_RequestSession_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  VRService_RequestSession_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "VRService::RequestSessionCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      RequestSessionResultPtr in_result);
};

bool VRService_RequestSession_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::VRService_RequestSession_ResponseParams_Data* params =
      reinterpret_cast<
          internal::VRService_RequestSession_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for VRService.1
  bool success = true;
  RequestSessionResultPtr p_result{};
  VRService_RequestSession_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        VRService::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void VRService_RequestSession_ProxyToResponder::Run(
    RequestSessionResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply device::mojom::VRService::RequestSession", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type RequestSessionResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VRService::kRequestSession), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::VRService_RequestSession_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  mojo::internal::Serialize<::device::mojom::RequestSessionResultDataView>(
      in_result, result_fragment, true);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VRService::Name_);
  message.set_method_name("RequestSession");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class VRService_SupportsSession_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static VRService::SupportsSessionCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<VRService_SupportsSession_ProxyToResponder> proxy(
        new VRService_SupportsSession_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&VRService_SupportsSession_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~VRService_SupportsSession_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  VRService_SupportsSession_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "VRService::SupportsSessionCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_supports_session);
};

bool VRService_SupportsSession_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::VRService_SupportsSession_ResponseParams_Data* params =
      reinterpret_cast<
          internal::VRService_SupportsSession_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for VRService.2
  bool success = true;
  bool p_supports_session{};
  VRService_SupportsSession_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_supports_session = input_data_view.supports_session();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        VRService::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_supports_session));
  return true;
}

void VRService_SupportsSession_ProxyToResponder::Run(
    bool in_supports_session) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply device::mojom::VRService::SupportsSession", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("supports_session"), in_supports_session,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VRService::kSupportsSession), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::VRService_SupportsSession_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->supports_session = in_supports_session;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VRService::Name_);
  message.set_method_name("SupportsSession");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class VRService_ExitPresent_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static VRService::ExitPresentCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<VRService_ExitPresent_ProxyToResponder> proxy(
        new VRService_ExitPresent_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&VRService_ExitPresent_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~VRService_ExitPresent_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  VRService_ExitPresent_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "VRService::ExitPresentCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool VRService_ExitPresent_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::VRService_ExitPresent_ResponseParams_Data* params =
      reinterpret_cast<
          internal::VRService_ExitPresent_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for VRService.3
  bool success = true;
  VRService_ExitPresent_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        VRService::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void VRService_ExitPresent_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply device::mojom::VRService::ExitPresent");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VRService::kExitPresent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::VRService_ExitPresent_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VRService::Name_);
  message.set_method_name("ExitPresent");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class VRService_MakeXrCompatible_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static VRService::MakeXrCompatibleCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<VRService_MakeXrCompatible_ProxyToResponder> proxy(
        new VRService_MakeXrCompatible_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&VRService_MakeXrCompatible_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~VRService_MakeXrCompatible_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  VRService_MakeXrCompatible_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "VRService::MakeXrCompatibleCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      XrCompatibleResult in_xr_compatible_result);
};

bool VRService_MakeXrCompatible_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::VRService_MakeXrCompatible_ResponseParams_Data* params =
      reinterpret_cast<
          internal::VRService_MakeXrCompatible_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for VRService.5
  bool success = true;
  XrCompatibleResult p_xr_compatible_result{};
  VRService_MakeXrCompatible_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadXrCompatibleResult(&p_xr_compatible_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        VRService::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_xr_compatible_result));
  return true;
}

void VRService_MakeXrCompatible_ProxyToResponder::Run(
    XrCompatibleResult in_xr_compatible_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply device::mojom::VRService::MakeXrCompatible", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("xr_compatible_result"), in_xr_compatible_result,
                        "<value of type XrCompatibleResult>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VRService::kMakeXrCompatible), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::VRService_MakeXrCompatible_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::device::mojom::XrCompatibleResult>(
      in_xr_compatible_result, &params->xr_compatible_result);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VRService::Name_);
  message.set_method_name("MakeXrCompatible");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool VRService_MakeXrCompatible_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::VRService_MakeXrCompatible_ResponseParams_Data* params =
      reinterpret_cast<internal::VRService_MakeXrCompatible_ResponseParams_Data*>(
          message->mutable_payload());
  
  
  // Validation for VRService.5
  bool success = true;
  XrCompatibleResult p_xr_compatible_result{};
  VRService_MakeXrCompatible_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadXrCompatibleResult(&p_xr_compatible_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        VRService::Name_, 5, true);
    return false;
  }
  *out_xr_compatible_result_ = std::move(p_xr_compatible_result);
  *result_ = true;
  return true;
}

// static
bool VRServiceStubDispatch::Accept(
    VRService* impl,
    mojo::Message* message) {
  switch (static_cast<messages::VRService>(message->header()->name)) {
    case messages::VRService::kSetClient: {
      DCHECK(message->is_serialized());
      internal::VRService_SetClient_Params_Data* params =
          reinterpret_cast<internal::VRService_SetClient_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for VRService.0
      bool success = true;
      ::mojo::PendingRemote<VRServiceClient> p_client{};
      VRService_SetClient_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VRService::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetClient(        
        std::move(p_client));
      return true;
    }
    case messages::VRService::kRequestSession: {
      break;
    }
    case messages::VRService::kSupportsSession: {
      break;
    }
    case messages::VRService::kExitPresent: {
      break;
    }
    case messages::VRService::kSetFramesThrottled: {
      DCHECK(message->is_serialized());
      internal::VRService_SetFramesThrottled_Params_Data* params =
          reinterpret_cast<internal::VRService_SetFramesThrottled_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for VRService.4
      bool success = true;
      bool p_throttled{};
      VRService_SetFramesThrottled_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_throttled = input_data_view.throttled();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VRService::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetFramesThrottled(        
        std::move(p_throttled));
      return true;
    }
    case messages::VRService::kMakeXrCompatible: {
      break;
    }
  }
  return false;
}

// static
bool VRServiceStubDispatch::AcceptWithResponder(
    VRService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::VRService>(message->header()->name)) {
    case messages::VRService::kSetClient: {
      break;
    }
    case messages::VRService::kRequestSession: {
      internal::VRService_RequestSession_Params_Data* params =
          reinterpret_cast<
              internal::VRService_RequestSession_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for VRService.1
      bool success = true;
      ::device::mojom::blink::XRSessionOptionsPtr p_options{};
      VRService_RequestSession_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VRService::Name_, 1, false);
        return false;
      }
      VRService::RequestSessionCallback callback =
          VRService_RequestSession_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestSession(        
        std::move(p_options), std::move(callback));
      return true;
    }
    case messages::VRService::kSupportsSession: {
      internal::VRService_SupportsSession_Params_Data* params =
          reinterpret_cast<
              internal::VRService_SupportsSession_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for VRService.2
      bool success = true;
      ::device::mojom::blink::XRSessionOptionsPtr p_options{};
      VRService_SupportsSession_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VRService::Name_, 2, false);
        return false;
      }
      VRService::SupportsSessionCallback callback =
          VRService_SupportsSession_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SupportsSession(        
        std::move(p_options), std::move(callback));
      return true;
    }
    case messages::VRService::kExitPresent: {
      internal::VRService_ExitPresent_Params_Data* params =
          reinterpret_cast<
              internal::VRService_ExitPresent_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for VRService.3
      bool success = true;
      VRService_ExitPresent_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VRService::Name_, 3, false);
        return false;
      }
      VRService::ExitPresentCallback callback =
          VRService_ExitPresent_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ExitPresent(std::move(callback));
      return true;
    }
    case messages::VRService::kSetFramesThrottled: {
      break;
    }
    case messages::VRService::kMakeXrCompatible: {
      internal::VRService_MakeXrCompatible_Params_Data* params =
          reinterpret_cast<
              internal::VRService_MakeXrCompatible_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for VRService.5
      bool success = true;
      VRService_MakeXrCompatible_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VRService::Name_, 5, false);
        return false;
      }
      VRService::MakeXrCompatibleCallback callback =
          VRService_MakeXrCompatible_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MakeXrCompatible(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kVRServiceValidationInfo[] = {
    {base::to_underlying(messages::VRService::kSetClient),
     { &internal::VRService_SetClient_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::VRService::kRequestSession),
     { &internal::VRService_RequestSession_Params_Data::Validate,
      &internal::VRService_RequestSession_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::VRService::kSupportsSession),
     { &internal::VRService_SupportsSession_Params_Data::Validate,
      &internal::VRService_SupportsSession_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::VRService::kExitPresent),
     { &internal::VRService_ExitPresent_Params_Data::Validate,
      &internal::VRService_ExitPresent_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::VRService::kSetFramesThrottled),
     { &internal::VRService_SetFramesThrottled_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::VRService::kMakeXrCompatible),
     { &internal::VRService_MakeXrCompatible_Params_Data::Validate,
      &internal::VRService_MakeXrCompatible_ResponseParams_Data::Validate}},
};

bool VRServiceRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::blink::VRService::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kVRServiceValidationInfo);
}

bool VRServiceResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::blink::VRService::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kVRServiceValidationInfo);

}
const char XRSessionMetricsRecorder::Name_[] = "device.mojom.XRSessionMetricsRecorder";

XRSessionMetricsRecorder::IPCStableHashFunction XRSessionMetricsRecorder::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::XRSessionMetricsRecorder>(message.name())) {
    case messages::XRSessionMetricsRecorder::kReportFeatureUsed: {
      return &XRSessionMetricsRecorder::ReportFeatureUsed_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* XRSessionMetricsRecorder::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::XRSessionMetricsRecorder>(message.name())) {
      case messages::XRSessionMetricsRecorder::kReportFeatureUsed:
            return "Receive device::mojom::XRSessionMetricsRecorder::ReportFeatureUsed";
    }
  } else {
    switch (static_cast<messages::XRSessionMetricsRecorder>(message.name())) {
      case messages::XRSessionMetricsRecorder::kReportFeatureUsed:
            return "Receive reply device::mojom::XRSessionMetricsRecorder::ReportFeatureUsed";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t XRSessionMetricsRecorder::ReportFeatureUsed_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)device::mojom::XRSessionMetricsRecorder::ReportFeatureUsed");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

XRSessionMetricsRecorderProxy::XRSessionMetricsRecorderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void XRSessionMetricsRecorderProxy::ReportFeatureUsed(
    ::device::mojom::blink::XRSessionFeature in_feature) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::XRSessionMetricsRecorder::ReportFeatureUsed", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("feature"), in_feature,
                        "<value of type ::device::mojom::blink::XRSessionFeature>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XRSessionMetricsRecorder::kReportFeatureUsed), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::XRSessionMetricsRecorder_ReportFeatureUsed_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::device::mojom::XRSessionFeature>(
      in_feature, &params->feature);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRSessionMetricsRecorder::Name_);
  message.set_method_name("ReportFeatureUsed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool XRSessionMetricsRecorderStubDispatch::Accept(
    XRSessionMetricsRecorder* impl,
    mojo::Message* message) {
  switch (static_cast<messages::XRSessionMetricsRecorder>(message->header()->name)) {
    case messages::XRSessionMetricsRecorder::kReportFeatureUsed: {
      DCHECK(message->is_serialized());
      internal::XRSessionMetricsRecorder_ReportFeatureUsed_Params_Data* params =
          reinterpret_cast<internal::XRSessionMetricsRecorder_ReportFeatureUsed_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for XRSessionMetricsRecorder.0
      bool success = true;
      ::device::mojom::blink::XRSessionFeature p_feature{};
      XRSessionMetricsRecorder_ReportFeatureUsed_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFeature(&p_feature))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XRSessionMetricsRecorder::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReportFeatureUsed(        
        std::move(p_feature));
      return true;
    }
  }
  return false;
}

// static
bool XRSessionMetricsRecorderStubDispatch::AcceptWithResponder(
    XRSessionMetricsRecorder* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::XRSessionMetricsRecorder>(message->header()->name)) {
    case messages::XRSessionMetricsRecorder::kReportFeatureUsed: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kXRSessionMetricsRecorderValidationInfo[] = {
    {base::to_underlying(messages::XRSessionMetricsRecorder::kReportFeatureUsed),
     { &internal::XRSessionMetricsRecorder_ReportFeatureUsed_Params_Data::Validate,
      nullptr /* no response */}},
};

bool XRSessionMetricsRecorderRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::blink::XRSessionMetricsRecorder::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kXRSessionMetricsRecorderValidationInfo);
}

const char VRServiceClient::Name_[] = "device.mojom.VRServiceClient";

VRServiceClient::IPCStableHashFunction VRServiceClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::VRServiceClient>(message.name())) {
    case messages::VRServiceClient::kOnDeviceChanged: {
      return &VRServiceClient::OnDeviceChanged_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* VRServiceClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::VRServiceClient>(message.name())) {
      case messages::VRServiceClient::kOnDeviceChanged:
            return "Receive device::mojom::VRServiceClient::OnDeviceChanged";
    }
  } else {
    switch (static_cast<messages::VRServiceClient>(message.name())) {
      case messages::VRServiceClient::kOnDeviceChanged:
            return "Receive reply device::mojom::VRServiceClient::OnDeviceChanged";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t VRServiceClient::OnDeviceChanged_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)device::mojom::VRServiceClient::OnDeviceChanged");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

VRServiceClientProxy::VRServiceClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void VRServiceClientProxy::OnDeviceChanged(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send device::mojom::VRServiceClient::OnDeviceChanged");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VRServiceClient::kOnDeviceChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::VRServiceClient_OnDeviceChanged_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VRServiceClient::Name_);
  message.set_method_name("OnDeviceChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool VRServiceClientStubDispatch::Accept(
    VRServiceClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::VRServiceClient>(message->header()->name)) {
    case messages::VRServiceClient::kOnDeviceChanged: {
      DCHECK(message->is_serialized());
      internal::VRServiceClient_OnDeviceChanged_Params_Data* params =
          reinterpret_cast<internal::VRServiceClient_OnDeviceChanged_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for VRServiceClient.0
      bool success = true;
      VRServiceClient_OnDeviceChanged_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VRServiceClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnDeviceChanged(        );
      return true;
    }
  }
  return false;
}

// static
bool VRServiceClientStubDispatch::AcceptWithResponder(
    VRServiceClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::VRServiceClient>(message->header()->name)) {
    case messages::VRServiceClient::kOnDeviceChanged: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kVRServiceClientValidationInfo[] = {
    {base::to_underlying(messages::VRServiceClient::kOnDeviceChanged),
     { &internal::VRServiceClient_OnDeviceChanged_Params_Data::Validate,
      nullptr /* no response */}},
};

bool VRServiceClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::blink::VRServiceClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kVRServiceClientValidationInfo);
}

const char XREnvironmentIntegrationProvider::Name_[] = "device.mojom.XREnvironmentIntegrationProvider";

XREnvironmentIntegrationProvider::IPCStableHashFunction XREnvironmentIntegrationProvider::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::XREnvironmentIntegrationProvider>(message.name())) {
    case messages::XREnvironmentIntegrationProvider::kSubscribeToHitTest: {
      return &XREnvironmentIntegrationProvider::SubscribeToHitTest_Sym::IPCStableHash;
    }
    case messages::XREnvironmentIntegrationProvider::kSubscribeToHitTestForTransientInput: {
      return &XREnvironmentIntegrationProvider::SubscribeToHitTestForTransientInput_Sym::IPCStableHash;
    }
    case messages::XREnvironmentIntegrationProvider::kUnsubscribeFromHitTest: {
      return &XREnvironmentIntegrationProvider::UnsubscribeFromHitTest_Sym::IPCStableHash;
    }
    case messages::XREnvironmentIntegrationProvider::kCreateAnchor: {
      return &XREnvironmentIntegrationProvider::CreateAnchor_Sym::IPCStableHash;
    }
    case messages::XREnvironmentIntegrationProvider::kCreatePlaneAnchor: {
      return &XREnvironmentIntegrationProvider::CreatePlaneAnchor_Sym::IPCStableHash;
    }
    case messages::XREnvironmentIntegrationProvider::kDetachAnchor: {
      return &XREnvironmentIntegrationProvider::DetachAnchor_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* XREnvironmentIntegrationProvider::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::XREnvironmentIntegrationProvider>(message.name())) {
      case messages::XREnvironmentIntegrationProvider::kSubscribeToHitTest:
            return "Receive device::mojom::XREnvironmentIntegrationProvider::SubscribeToHitTest";
      case messages::XREnvironmentIntegrationProvider::kSubscribeToHitTestForTransientInput:
            return "Receive device::mojom::XREnvironmentIntegrationProvider::SubscribeToHitTestForTransientInput";
      case messages::XREnvironmentIntegrationProvider::kUnsubscribeFromHitTest:
            return "Receive device::mojom::XREnvironmentIntegrationProvider::UnsubscribeFromHitTest";
      case messages::XREnvironmentIntegrationProvider::kCreateAnchor:
            return "Receive device::mojom::XREnvironmentIntegrationProvider::CreateAnchor";
      case messages::XREnvironmentIntegrationProvider::kCreatePlaneAnchor:
            return "Receive device::mojom::XREnvironmentIntegrationProvider::CreatePlaneAnchor";
      case messages::XREnvironmentIntegrationProvider::kDetachAnchor:
            return "Receive device::mojom::XREnvironmentIntegrationProvider::DetachAnchor";
    }
  } else {
    switch (static_cast<messages::XREnvironmentIntegrationProvider>(message.name())) {
      case messages::XREnvironmentIntegrationProvider::kSubscribeToHitTest:
            return "Receive reply device::mojom::XREnvironmentIntegrationProvider::SubscribeToHitTest";
      case messages::XREnvironmentIntegrationProvider::kSubscribeToHitTestForTransientInput:
            return "Receive reply device::mojom::XREnvironmentIntegrationProvider::SubscribeToHitTestForTransientInput";
      case messages::XREnvironmentIntegrationProvider::kUnsubscribeFromHitTest:
            return "Receive reply device::mojom::XREnvironmentIntegrationProvider::UnsubscribeFromHitTest";
      case messages::XREnvironmentIntegrationProvider::kCreateAnchor:
            return "Receive reply device::mojom::XREnvironmentIntegrationProvider::CreateAnchor";
      case messages::XREnvironmentIntegrationProvider::kCreatePlaneAnchor:
            return "Receive reply device::mojom::XREnvironmentIntegrationProvider::CreatePlaneAnchor";
      case messages::XREnvironmentIntegrationProvider::kDetachAnchor:
            return "Receive reply device::mojom::XREnvironmentIntegrationProvider::DetachAnchor";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t XREnvironmentIntegrationProvider::SubscribeToHitTest_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)device::mojom::XREnvironmentIntegrationProvider::SubscribeToHitTest");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t XREnvironmentIntegrationProvider::SubscribeToHitTestForTransientInput_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)device::mojom::XREnvironmentIntegrationProvider::SubscribeToHitTestForTransientInput");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t XREnvironmentIntegrationProvider::UnsubscribeFromHitTest_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)device::mojom::XREnvironmentIntegrationProvider::UnsubscribeFromHitTest");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t XREnvironmentIntegrationProvider::CreateAnchor_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)device::mojom::XREnvironmentIntegrationProvider::CreateAnchor");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t XREnvironmentIntegrationProvider::CreatePlaneAnchor_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)device::mojom::XREnvironmentIntegrationProvider::CreatePlaneAnchor");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t XREnvironmentIntegrationProvider::DetachAnchor_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)device::mojom::XREnvironmentIntegrationProvider::DetachAnchor");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class XREnvironmentIntegrationProvider_SubscribeToHitTest_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  XREnvironmentIntegrationProvider_SubscribeToHitTest_ForwardToCallback(
      XREnvironmentIntegrationProvider::SubscribeToHitTestCallback callback
      ) : callback_(std::move(callback)) {
  }

  XREnvironmentIntegrationProvider_SubscribeToHitTest_ForwardToCallback(const XREnvironmentIntegrationProvider_SubscribeToHitTest_ForwardToCallback&) = delete;
  XREnvironmentIntegrationProvider_SubscribeToHitTest_ForwardToCallback& operator=(const XREnvironmentIntegrationProvider_SubscribeToHitTest_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  XREnvironmentIntegrationProvider::SubscribeToHitTestCallback callback_;
};

class XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ForwardToCallback(
      XREnvironmentIntegrationProvider::SubscribeToHitTestForTransientInputCallback callback
      ) : callback_(std::move(callback)) {
  }

  XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ForwardToCallback(const XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ForwardToCallback&) = delete;
  XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ForwardToCallback& operator=(const XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  XREnvironmentIntegrationProvider::SubscribeToHitTestForTransientInputCallback callback_;
};

class XREnvironmentIntegrationProvider_CreateAnchor_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  XREnvironmentIntegrationProvider_CreateAnchor_ForwardToCallback(
      XREnvironmentIntegrationProvider::CreateAnchorCallback callback
      ) : callback_(std::move(callback)) {
  }

  XREnvironmentIntegrationProvider_CreateAnchor_ForwardToCallback(const XREnvironmentIntegrationProvider_CreateAnchor_ForwardToCallback&) = delete;
  XREnvironmentIntegrationProvider_CreateAnchor_ForwardToCallback& operator=(const XREnvironmentIntegrationProvider_CreateAnchor_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  XREnvironmentIntegrationProvider::CreateAnchorCallback callback_;
};

class XREnvironmentIntegrationProvider_CreatePlaneAnchor_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  XREnvironmentIntegrationProvider_CreatePlaneAnchor_ForwardToCallback(
      XREnvironmentIntegrationProvider::CreatePlaneAnchorCallback callback
      ) : callback_(std::move(callback)) {
  }

  XREnvironmentIntegrationProvider_CreatePlaneAnchor_ForwardToCallback(const XREnvironmentIntegrationProvider_CreatePlaneAnchor_ForwardToCallback&) = delete;
  XREnvironmentIntegrationProvider_CreatePlaneAnchor_ForwardToCallback& operator=(const XREnvironmentIntegrationProvider_CreatePlaneAnchor_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  XREnvironmentIntegrationProvider::CreatePlaneAnchorCallback callback_;
};

XREnvironmentIntegrationProviderProxy::XREnvironmentIntegrationProviderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void XREnvironmentIntegrationProviderProxy::SubscribeToHitTest(
    XRNativeOriginInformationPtr in_native_origin_information, const WTF::Vector<EntityTypeForHitTest>& in_entity_types, XRRayPtr in_ray, SubscribeToHitTestCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::XREnvironmentIntegrationProvider::SubscribeToHitTest", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("native_origin_information"), in_native_origin_information,
                        "<value of type XRNativeOriginInformationPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("entity_types"), in_entity_types,
                        "<value of type const WTF::Vector<EntityTypeForHitTest>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("ray"), in_ray,
                        "<value of type XRRayPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XREnvironmentIntegrationProvider::kSubscribeToHitTest), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::XREnvironmentIntegrationProvider_SubscribeToHitTest_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->native_origin_information)>
      native_origin_information_fragment(params.message());
  native_origin_information_fragment.Claim(&params->native_origin_information);
  mojo::internal::Serialize<::device::mojom::XRNativeOriginInformationDataView>(
      in_native_origin_information, native_origin_information_fragment, true);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->native_origin_information.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null native_origin_information in XREnvironmentIntegrationProvider.SubscribeToHitTest request");
  mojo::internal::MessageFragment<
      typename decltype(params->entity_types)::BaseType>
      entity_types_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& entity_types_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::device::mojom::internal::EntityTypeForHitTest_Data::Validate>();
  mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::EntityTypeForHitTest>>(
      in_entity_types, entity_types_fragment, &entity_types_validate_params);
  params->entity_types.Set(
      entity_types_fragment.is_null() ? nullptr : entity_types_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->entity_types.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null entity_types in XREnvironmentIntegrationProvider.SubscribeToHitTest request");
  mojo::internal::MessageFragment<
      typename decltype(params->ray)::BaseType> ray_fragment(
          params.message());
  mojo::internal::Serialize<::device::mojom::XRRayDataView>(
      in_ray, ray_fragment);
  params->ray.Set(
      ray_fragment.is_null() ? nullptr : ray_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->ray.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null ray in XREnvironmentIntegrationProvider.SubscribeToHitTest request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XREnvironmentIntegrationProvider::Name_);
  message.set_method_name("SubscribeToHitTest");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new XREnvironmentIntegrationProvider_SubscribeToHitTest_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void XREnvironmentIntegrationProviderProxy::SubscribeToHitTestForTransientInput(
    const WTF::String& in_profile_name, const WTF::Vector<EntityTypeForHitTest>& in_entity_types, XRRayPtr in_ray, SubscribeToHitTestForTransientInputCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::XREnvironmentIntegrationProvider::SubscribeToHitTestForTransientInput", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("profile_name"), in_profile_name,
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("entity_types"), in_entity_types,
                        "<value of type const WTF::Vector<EntityTypeForHitTest>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("ray"), in_ray,
                        "<value of type XRRayPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XREnvironmentIntegrationProvider::kSubscribeToHitTestForTransientInput), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->profile_name)::BaseType> profile_name_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_profile_name, profile_name_fragment);
  params->profile_name.Set(
      profile_name_fragment.is_null() ? nullptr : profile_name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->profile_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null profile_name in XREnvironmentIntegrationProvider.SubscribeToHitTestForTransientInput request");
  mojo::internal::MessageFragment<
      typename decltype(params->entity_types)::BaseType>
      entity_types_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& entity_types_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::device::mojom::internal::EntityTypeForHitTest_Data::Validate>();
  mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::EntityTypeForHitTest>>(
      in_entity_types, entity_types_fragment, &entity_types_validate_params);
  params->entity_types.Set(
      entity_types_fragment.is_null() ? nullptr : entity_types_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->entity_types.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null entity_types in XREnvironmentIntegrationProvider.SubscribeToHitTestForTransientInput request");
  mojo::internal::MessageFragment<
      typename decltype(params->ray)::BaseType> ray_fragment(
          params.message());
  mojo::internal::Serialize<::device::mojom::XRRayDataView>(
      in_ray, ray_fragment);
  params->ray.Set(
      ray_fragment.is_null() ? nullptr : ray_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->ray.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null ray in XREnvironmentIntegrationProvider.SubscribeToHitTestForTransientInput request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XREnvironmentIntegrationProvider::Name_);
  message.set_method_name("SubscribeToHitTestForTransientInput");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void XREnvironmentIntegrationProviderProxy::UnsubscribeFromHitTest(
    uint64_t in_subscription_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::XREnvironmentIntegrationProvider::UnsubscribeFromHitTest", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("subscription_id"), in_subscription_id,
                        "<value of type uint64_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XREnvironmentIntegrationProvider::kUnsubscribeFromHitTest), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::XREnvironmentIntegrationProvider_UnsubscribeFromHitTest_Params_Data> params(
          message);
  params.Allocate();
  params->subscription_id = in_subscription_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XREnvironmentIntegrationProvider::Name_);
  message.set_method_name("UnsubscribeFromHitTest");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void XREnvironmentIntegrationProviderProxy::CreateAnchor(
    XRNativeOriginInformationPtr in_native_origin_information, const ::device::Pose& in_native_origin_from_anchor, CreateAnchorCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::XREnvironmentIntegrationProvider::CreateAnchor", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("native_origin_information"), in_native_origin_information,
                        "<value of type XRNativeOriginInformationPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("native_origin_from_anchor"), in_native_origin_from_anchor,
                        "<value of type const ::device::Pose&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XREnvironmentIntegrationProvider::kCreateAnchor), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::XREnvironmentIntegrationProvider_CreateAnchor_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->native_origin_information)>
      native_origin_information_fragment(params.message());
  native_origin_information_fragment.Claim(&params->native_origin_information);
  mojo::internal::Serialize<::device::mojom::XRNativeOriginInformationDataView>(
      in_native_origin_information, native_origin_information_fragment, true);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->native_origin_information.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null native_origin_information in XREnvironmentIntegrationProvider.CreateAnchor request");
  mojo::internal::MessageFragment<
      typename decltype(params->native_origin_from_anchor)::BaseType> native_origin_from_anchor_fragment(
          params.message());
  mojo::internal::Serialize<::device::mojom::PoseDataView>(
      in_native_origin_from_anchor, native_origin_from_anchor_fragment);
  params->native_origin_from_anchor.Set(
      native_origin_from_anchor_fragment.is_null() ? nullptr : native_origin_from_anchor_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->native_origin_from_anchor.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null native_origin_from_anchor in XREnvironmentIntegrationProvider.CreateAnchor request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XREnvironmentIntegrationProvider::Name_);
  message.set_method_name("CreateAnchor");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new XREnvironmentIntegrationProvider_CreateAnchor_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void XREnvironmentIntegrationProviderProxy::CreatePlaneAnchor(
    XRNativeOriginInformationPtr in_native_origin_information, const ::device::Pose& in_native_origin_from_anchor, uint64_t in_plane_id, CreatePlaneAnchorCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::XREnvironmentIntegrationProvider::CreatePlaneAnchor", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("native_origin_information"), in_native_origin_information,
                        "<value of type XRNativeOriginInformationPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("native_origin_from_anchor"), in_native_origin_from_anchor,
                        "<value of type const ::device::Pose&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("plane_id"), in_plane_id,
                        "<value of type uint64_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XREnvironmentIntegrationProvider::kCreatePlaneAnchor), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::XREnvironmentIntegrationProvider_CreatePlaneAnchor_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->native_origin_information)>
      native_origin_information_fragment(params.message());
  native_origin_information_fragment.Claim(&params->native_origin_information);
  mojo::internal::Serialize<::device::mojom::XRNativeOriginInformationDataView>(
      in_native_origin_information, native_origin_information_fragment, true);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->native_origin_information.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null native_origin_information in XREnvironmentIntegrationProvider.CreatePlaneAnchor request");
  mojo::internal::MessageFragment<
      typename decltype(params->native_origin_from_anchor)::BaseType> native_origin_from_anchor_fragment(
          params.message());
  mojo::internal::Serialize<::device::mojom::PoseDataView>(
      in_native_origin_from_anchor, native_origin_from_anchor_fragment);
  params->native_origin_from_anchor.Set(
      native_origin_from_anchor_fragment.is_null() ? nullptr : native_origin_from_anchor_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->native_origin_from_anchor.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null native_origin_from_anchor in XREnvironmentIntegrationProvider.CreatePlaneAnchor request");
  params->plane_id = in_plane_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XREnvironmentIntegrationProvider::Name_);
  message.set_method_name("CreatePlaneAnchor");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new XREnvironmentIntegrationProvider_CreatePlaneAnchor_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void XREnvironmentIntegrationProviderProxy::DetachAnchor(
    uint64_t in_anchor_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::XREnvironmentIntegrationProvider::DetachAnchor", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("anchor_id"), in_anchor_id,
                        "<value of type uint64_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XREnvironmentIntegrationProvider::kDetachAnchor), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::XREnvironmentIntegrationProvider_DetachAnchor_Params_Data> params(
          message);
  params.Allocate();
  params->anchor_id = in_anchor_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XREnvironmentIntegrationProvider::Name_);
  message.set_method_name("DetachAnchor");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class XREnvironmentIntegrationProvider_SubscribeToHitTest_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static XREnvironmentIntegrationProvider::SubscribeToHitTestCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<XREnvironmentIntegrationProvider_SubscribeToHitTest_ProxyToResponder> proxy(
        new XREnvironmentIntegrationProvider_SubscribeToHitTest_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&XREnvironmentIntegrationProvider_SubscribeToHitTest_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~XREnvironmentIntegrationProvider_SubscribeToHitTest_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  XREnvironmentIntegrationProvider_SubscribeToHitTest_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "XREnvironmentIntegrationProvider::SubscribeToHitTestCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      SubscribeToHitTestResult in_result, uint64_t in_subscription_id);
};

bool XREnvironmentIntegrationProvider_SubscribeToHitTest_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::XREnvironmentIntegrationProvider_SubscribeToHitTest_ResponseParams_Data* params =
      reinterpret_cast<
          internal::XREnvironmentIntegrationProvider_SubscribeToHitTest_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for XREnvironmentIntegrationProvider.0
  bool success = true;
  SubscribeToHitTestResult p_result{};
  uint64_t p_subscription_id{};
  XREnvironmentIntegrationProvider_SubscribeToHitTest_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success)
    p_subscription_id = input_data_view.subscription_id();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        XREnvironmentIntegrationProvider::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_subscription_id));
  return true;
}

void XREnvironmentIntegrationProvider_SubscribeToHitTest_ProxyToResponder::Run(
    SubscribeToHitTestResult in_result, uint64_t in_subscription_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply device::mojom::XREnvironmentIntegrationProvider::SubscribeToHitTest", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type SubscribeToHitTestResult>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("subscription_id"), in_subscription_id,
                        "<value of type uint64_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XREnvironmentIntegrationProvider::kSubscribeToHitTest), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::XREnvironmentIntegrationProvider_SubscribeToHitTest_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::device::mojom::SubscribeToHitTestResult>(
      in_result, &params->result);
  params->subscription_id = in_subscription_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XREnvironmentIntegrationProvider::Name_);
  message.set_method_name("SubscribeToHitTest");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static XREnvironmentIntegrationProvider::SubscribeToHitTestForTransientInputCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ProxyToResponder> proxy(
        new XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "XREnvironmentIntegrationProvider::SubscribeToHitTestForTransientInputCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      SubscribeToHitTestResult in_result, uint64_t in_subscription_id);
};

bool XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ResponseParams_Data* params =
      reinterpret_cast<
          internal::XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for XREnvironmentIntegrationProvider.1
  bool success = true;
  SubscribeToHitTestResult p_result{};
  uint64_t p_subscription_id{};
  XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success)
    p_subscription_id = input_data_view.subscription_id();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        XREnvironmentIntegrationProvider::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_subscription_id));
  return true;
}

void XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ProxyToResponder::Run(
    SubscribeToHitTestResult in_result, uint64_t in_subscription_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply device::mojom::XREnvironmentIntegrationProvider::SubscribeToHitTestForTransientInput", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type SubscribeToHitTestResult>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("subscription_id"), in_subscription_id,
                        "<value of type uint64_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XREnvironmentIntegrationProvider::kSubscribeToHitTestForTransientInput), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::device::mojom::SubscribeToHitTestResult>(
      in_result, &params->result);
  params->subscription_id = in_subscription_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XREnvironmentIntegrationProvider::Name_);
  message.set_method_name("SubscribeToHitTestForTransientInput");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class XREnvironmentIntegrationProvider_CreateAnchor_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static XREnvironmentIntegrationProvider::CreateAnchorCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<XREnvironmentIntegrationProvider_CreateAnchor_ProxyToResponder> proxy(
        new XREnvironmentIntegrationProvider_CreateAnchor_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&XREnvironmentIntegrationProvider_CreateAnchor_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~XREnvironmentIntegrationProvider_CreateAnchor_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  XREnvironmentIntegrationProvider_CreateAnchor_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "XREnvironmentIntegrationProvider::CreateAnchorCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      CreateAnchorResult in_result, uint64_t in_anchor_id);
};

bool XREnvironmentIntegrationProvider_CreateAnchor_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::XREnvironmentIntegrationProvider_CreateAnchor_ResponseParams_Data* params =
      reinterpret_cast<
          internal::XREnvironmentIntegrationProvider_CreateAnchor_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for XREnvironmentIntegrationProvider.3
  bool success = true;
  CreateAnchorResult p_result{};
  uint64_t p_anchor_id{};
  XREnvironmentIntegrationProvider_CreateAnchor_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success)
    p_anchor_id = input_data_view.anchor_id();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        XREnvironmentIntegrationProvider::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_anchor_id));
  return true;
}

void XREnvironmentIntegrationProvider_CreateAnchor_ProxyToResponder::Run(
    CreateAnchorResult in_result, uint64_t in_anchor_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply device::mojom::XREnvironmentIntegrationProvider::CreateAnchor", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type CreateAnchorResult>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("anchor_id"), in_anchor_id,
                        "<value of type uint64_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XREnvironmentIntegrationProvider::kCreateAnchor), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::XREnvironmentIntegrationProvider_CreateAnchor_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::device::mojom::CreateAnchorResult>(
      in_result, &params->result);
  params->anchor_id = in_anchor_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XREnvironmentIntegrationProvider::Name_);
  message.set_method_name("CreateAnchor");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class XREnvironmentIntegrationProvider_CreatePlaneAnchor_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static XREnvironmentIntegrationProvider::CreatePlaneAnchorCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<XREnvironmentIntegrationProvider_CreatePlaneAnchor_ProxyToResponder> proxy(
        new XREnvironmentIntegrationProvider_CreatePlaneAnchor_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&XREnvironmentIntegrationProvider_CreatePlaneAnchor_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~XREnvironmentIntegrationProvider_CreatePlaneAnchor_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  XREnvironmentIntegrationProvider_CreatePlaneAnchor_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "XREnvironmentIntegrationProvider::CreatePlaneAnchorCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      CreateAnchorResult in_result, uint64_t in_anchor_id);
};

bool XREnvironmentIntegrationProvider_CreatePlaneAnchor_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::XREnvironmentIntegrationProvider_CreatePlaneAnchor_ResponseParams_Data* params =
      reinterpret_cast<
          internal::XREnvironmentIntegrationProvider_CreatePlaneAnchor_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for XREnvironmentIntegrationProvider.4
  bool success = true;
  CreateAnchorResult p_result{};
  uint64_t p_anchor_id{};
  XREnvironmentIntegrationProvider_CreatePlaneAnchor_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success)
    p_anchor_id = input_data_view.anchor_id();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        XREnvironmentIntegrationProvider::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_anchor_id));
  return true;
}

void XREnvironmentIntegrationProvider_CreatePlaneAnchor_ProxyToResponder::Run(
    CreateAnchorResult in_result, uint64_t in_anchor_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply device::mojom::XREnvironmentIntegrationProvider::CreatePlaneAnchor", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type CreateAnchorResult>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("anchor_id"), in_anchor_id,
                        "<value of type uint64_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XREnvironmentIntegrationProvider::kCreatePlaneAnchor), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::XREnvironmentIntegrationProvider_CreatePlaneAnchor_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::device::mojom::CreateAnchorResult>(
      in_result, &params->result);
  params->anchor_id = in_anchor_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XREnvironmentIntegrationProvider::Name_);
  message.set_method_name("CreatePlaneAnchor");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool XREnvironmentIntegrationProviderStubDispatch::Accept(
    XREnvironmentIntegrationProvider* impl,
    mojo::Message* message) {
  switch (static_cast<messages::XREnvironmentIntegrationProvider>(message->header()->name)) {
    case messages::XREnvironmentIntegrationProvider::kSubscribeToHitTest: {
      break;
    }
    case messages::XREnvironmentIntegrationProvider::kSubscribeToHitTestForTransientInput: {
      break;
    }
    case messages::XREnvironmentIntegrationProvider::kUnsubscribeFromHitTest: {
      DCHECK(message->is_serialized());
      internal::XREnvironmentIntegrationProvider_UnsubscribeFromHitTest_Params_Data* params =
          reinterpret_cast<internal::XREnvironmentIntegrationProvider_UnsubscribeFromHitTest_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for XREnvironmentIntegrationProvider.2
      bool success = true;
      uint64_t p_subscription_id{};
      XREnvironmentIntegrationProvider_UnsubscribeFromHitTest_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_subscription_id = input_data_view.subscription_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XREnvironmentIntegrationProvider::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UnsubscribeFromHitTest(        
        std::move(p_subscription_id));
      return true;
    }
    case messages::XREnvironmentIntegrationProvider::kCreateAnchor: {
      break;
    }
    case messages::XREnvironmentIntegrationProvider::kCreatePlaneAnchor: {
      break;
    }
    case messages::XREnvironmentIntegrationProvider::kDetachAnchor: {
      DCHECK(message->is_serialized());
      internal::XREnvironmentIntegrationProvider_DetachAnchor_Params_Data* params =
          reinterpret_cast<internal::XREnvironmentIntegrationProvider_DetachAnchor_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for XREnvironmentIntegrationProvider.5
      bool success = true;
      uint64_t p_anchor_id{};
      XREnvironmentIntegrationProvider_DetachAnchor_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_anchor_id = input_data_view.anchor_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XREnvironmentIntegrationProvider::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DetachAnchor(        
        std::move(p_anchor_id));
      return true;
    }
  }
  return false;
}

// static
bool XREnvironmentIntegrationProviderStubDispatch::AcceptWithResponder(
    XREnvironmentIntegrationProvider* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::XREnvironmentIntegrationProvider>(message->header()->name)) {
    case messages::XREnvironmentIntegrationProvider::kSubscribeToHitTest: {
      internal::XREnvironmentIntegrationProvider_SubscribeToHitTest_Params_Data* params =
          reinterpret_cast<
              internal::XREnvironmentIntegrationProvider_SubscribeToHitTest_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for XREnvironmentIntegrationProvider.0
      bool success = true;
      XRNativeOriginInformationPtr p_native_origin_information{};
      WTF::Vector<EntityTypeForHitTest> p_entity_types{};
      XRRayPtr p_ray{};
      XREnvironmentIntegrationProvider_SubscribeToHitTest_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadNativeOriginInformation(&p_native_origin_information))
        success = false;
      if (success && !input_data_view.ReadEntityTypes(&p_entity_types))
        success = false;
      if (success && !input_data_view.ReadRay(&p_ray))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XREnvironmentIntegrationProvider::Name_, 0, false);
        return false;
      }
      XREnvironmentIntegrationProvider::SubscribeToHitTestCallback callback =
          XREnvironmentIntegrationProvider_SubscribeToHitTest_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SubscribeToHitTest(        
        std::move(p_native_origin_information), 
        std::move(p_entity_types), 
        std::move(p_ray), std::move(callback));
      return true;
    }
    case messages::XREnvironmentIntegrationProvider::kSubscribeToHitTestForTransientInput: {
      internal::XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_Params_Data* params =
          reinterpret_cast<
              internal::XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for XREnvironmentIntegrationProvider.1
      bool success = true;
      WTF::String p_profile_name{};
      WTF::Vector<EntityTypeForHitTest> p_entity_types{};
      XRRayPtr p_ray{};
      XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadProfileName(&p_profile_name))
        success = false;
      if (success && !input_data_view.ReadEntityTypes(&p_entity_types))
        success = false;
      if (success && !input_data_view.ReadRay(&p_ray))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XREnvironmentIntegrationProvider::Name_, 1, false);
        return false;
      }
      XREnvironmentIntegrationProvider::SubscribeToHitTestForTransientInputCallback callback =
          XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SubscribeToHitTestForTransientInput(        
        std::move(p_profile_name), 
        std::move(p_entity_types), 
        std::move(p_ray), std::move(callback));
      return true;
    }
    case messages::XREnvironmentIntegrationProvider::kUnsubscribeFromHitTest: {
      break;
    }
    case messages::XREnvironmentIntegrationProvider::kCreateAnchor: {
      internal::XREnvironmentIntegrationProvider_CreateAnchor_Params_Data* params =
          reinterpret_cast<
              internal::XREnvironmentIntegrationProvider_CreateAnchor_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for XREnvironmentIntegrationProvider.3
      bool success = true;
      XRNativeOriginInformationPtr p_native_origin_information{};
      ::device::Pose p_native_origin_from_anchor{};
      XREnvironmentIntegrationProvider_CreateAnchor_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadNativeOriginInformation(&p_native_origin_information))
        success = false;
      if (success && !input_data_view.ReadNativeOriginFromAnchor(&p_native_origin_from_anchor))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XREnvironmentIntegrationProvider::Name_, 3, false);
        return false;
      }
      XREnvironmentIntegrationProvider::CreateAnchorCallback callback =
          XREnvironmentIntegrationProvider_CreateAnchor_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateAnchor(        
        std::move(p_native_origin_information), 
        std::move(p_native_origin_from_anchor), std::move(callback));
      return true;
    }
    case messages::XREnvironmentIntegrationProvider::kCreatePlaneAnchor: {
      internal::XREnvironmentIntegrationProvider_CreatePlaneAnchor_Params_Data* params =
          reinterpret_cast<
              internal::XREnvironmentIntegrationProvider_CreatePlaneAnchor_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for XREnvironmentIntegrationProvider.4
      bool success = true;
      XRNativeOriginInformationPtr p_native_origin_information{};
      ::device::Pose p_native_origin_from_anchor{};
      uint64_t p_plane_id{};
      XREnvironmentIntegrationProvider_CreatePlaneAnchor_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadNativeOriginInformation(&p_native_origin_information))
        success = false;
      if (success && !input_data_view.ReadNativeOriginFromAnchor(&p_native_origin_from_anchor))
        success = false;
      if (success)
        p_plane_id = input_data_view.plane_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XREnvironmentIntegrationProvider::Name_, 4, false);
        return false;
      }
      XREnvironmentIntegrationProvider::CreatePlaneAnchorCallback callback =
          XREnvironmentIntegrationProvider_CreatePlaneAnchor_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreatePlaneAnchor(        
        std::move(p_native_origin_information), 
        std::move(p_native_origin_from_anchor), 
        std::move(p_plane_id), std::move(callback));
      return true;
    }
    case messages::XREnvironmentIntegrationProvider::kDetachAnchor: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kXREnvironmentIntegrationProviderValidationInfo[] = {
    {base::to_underlying(messages::XREnvironmentIntegrationProvider::kSubscribeToHitTest),
     { &internal::XREnvironmentIntegrationProvider_SubscribeToHitTest_Params_Data::Validate,
      &internal::XREnvironmentIntegrationProvider_SubscribeToHitTest_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::XREnvironmentIntegrationProvider::kSubscribeToHitTestForTransientInput),
     { &internal::XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_Params_Data::Validate,
      &internal::XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::XREnvironmentIntegrationProvider::kUnsubscribeFromHitTest),
     { &internal::XREnvironmentIntegrationProvider_UnsubscribeFromHitTest_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::XREnvironmentIntegrationProvider::kCreateAnchor),
     { &internal::XREnvironmentIntegrationProvider_CreateAnchor_Params_Data::Validate,
      &internal::XREnvironmentIntegrationProvider_CreateAnchor_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::XREnvironmentIntegrationProvider::kCreatePlaneAnchor),
     { &internal::XREnvironmentIntegrationProvider_CreatePlaneAnchor_Params_Data::Validate,
      &internal::XREnvironmentIntegrationProvider_CreatePlaneAnchor_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::XREnvironmentIntegrationProvider::kDetachAnchor),
     { &internal::XREnvironmentIntegrationProvider_DetachAnchor_Params_Data::Validate,
      nullptr /* no response */}},
};

bool XREnvironmentIntegrationProviderRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::blink::XREnvironmentIntegrationProvider::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kXREnvironmentIntegrationProviderValidationInfo);
}

bool XREnvironmentIntegrationProviderResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::blink::XREnvironmentIntegrationProvider::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kXREnvironmentIntegrationProviderValidationInfo);

}
const char XRFrameDataProvider::Name_[] = "device.mojom.XRFrameDataProvider";

XRFrameDataProvider::IPCStableHashFunction XRFrameDataProvider::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::XRFrameDataProvider>(message.name())) {
    case messages::XRFrameDataProvider::kGetFrameData: {
      return &XRFrameDataProvider::GetFrameData_Sym::IPCStableHash;
    }
    case messages::XRFrameDataProvider::kGetEnvironmentIntegrationProvider: {
      return &XRFrameDataProvider::GetEnvironmentIntegrationProvider_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* XRFrameDataProvider::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::XRFrameDataProvider>(message.name())) {
      case messages::XRFrameDataProvider::kGetFrameData:
            return "Receive device::mojom::XRFrameDataProvider::GetFrameData";
      case messages::XRFrameDataProvider::kGetEnvironmentIntegrationProvider:
            return "Receive device::mojom::XRFrameDataProvider::GetEnvironmentIntegrationProvider";
    }
  } else {
    switch (static_cast<messages::XRFrameDataProvider>(message.name())) {
      case messages::XRFrameDataProvider::kGetFrameData:
            return "Receive reply device::mojom::XRFrameDataProvider::GetFrameData";
      case messages::XRFrameDataProvider::kGetEnvironmentIntegrationProvider:
            return "Receive reply device::mojom::XRFrameDataProvider::GetEnvironmentIntegrationProvider";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t XRFrameDataProvider::GetFrameData_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)device::mojom::XRFrameDataProvider::GetFrameData");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t XRFrameDataProvider::GetEnvironmentIntegrationProvider_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)device::mojom::XRFrameDataProvider::GetEnvironmentIntegrationProvider");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class XRFrameDataProvider_GetFrameData_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  XRFrameDataProvider_GetFrameData_ForwardToCallback(
      XRFrameDataProvider::GetFrameDataCallback callback
      ) : callback_(std::move(callback)) {
  }

  XRFrameDataProvider_GetFrameData_ForwardToCallback(const XRFrameDataProvider_GetFrameData_ForwardToCallback&) = delete;
  XRFrameDataProvider_GetFrameData_ForwardToCallback& operator=(const XRFrameDataProvider_GetFrameData_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  XRFrameDataProvider::GetFrameDataCallback callback_;
};

XRFrameDataProviderProxy::XRFrameDataProviderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void XRFrameDataProviderProxy::GetFrameData(
    XRFrameDataRequestOptionsPtr in_options, GetFrameDataCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::XRFrameDataProvider::GetFrameData", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options,
                        "<value of type XRFrameDataRequestOptionsPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XRFrameDataProvider::kGetFrameData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::XRFrameDataProvider_GetFrameData_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  mojo::internal::Serialize<::device::mojom::XRFrameDataRequestOptionsDataView>(
      in_options, options_fragment);
  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRFrameDataProvider::Name_);
  message.set_method_name("GetFrameData");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new XRFrameDataProvider_GetFrameData_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void XRFrameDataProviderProxy::GetEnvironmentIntegrationProvider(
    ::mojo::PendingAssociatedReceiver<XREnvironmentIntegrationProvider> in_environment_provider) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::XRFrameDataProvider::GetEnvironmentIntegrationProvider", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("environment_provider"), in_environment_provider,
                        "<value of type ::mojo::PendingAssociatedReceiver<XREnvironmentIntegrationProvider>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XRFrameDataProvider::kGetEnvironmentIntegrationProvider), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::XRFrameDataProvider_GetEnvironmentIntegrationProvider_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::device::mojom::XREnvironmentIntegrationProviderAssociatedRequestDataView>(
      in_environment_provider, &params->environment_provider, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->environment_provider),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid environment_provider in XRFrameDataProvider.GetEnvironmentIntegrationProvider request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRFrameDataProvider::Name_);
  message.set_method_name("GetEnvironmentIntegrationProvider");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class XRFrameDataProvider_GetFrameData_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static XRFrameDataProvider::GetFrameDataCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<XRFrameDataProvider_GetFrameData_ProxyToResponder> proxy(
        new XRFrameDataProvider_GetFrameData_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&XRFrameDataProvider_GetFrameData_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~XRFrameDataProvider_GetFrameData_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  XRFrameDataProvider_GetFrameData_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "XRFrameDataProvider::GetFrameDataCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      XRFrameDataPtr in_frame_data);
};

bool XRFrameDataProvider_GetFrameData_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::XRFrameDataProvider_GetFrameData_ResponseParams_Data* params =
      reinterpret_cast<
          internal::XRFrameDataProvider_GetFrameData_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for XRFrameDataProvider.0
  bool success = true;
  XRFrameDataPtr p_frame_data{};
  XRFrameDataProvider_GetFrameData_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadFrameData(&p_frame_data))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        XRFrameDataProvider::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_frame_data));
  return true;
}

void XRFrameDataProvider_GetFrameData_ProxyToResponder::Run(
    XRFrameDataPtr in_frame_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply device::mojom::XRFrameDataProvider::GetFrameData", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_data"), in_frame_data,
                        "<value of type XRFrameDataPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XRFrameDataProvider::kGetFrameData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::XRFrameDataProvider_GetFrameData_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->frame_data)::BaseType> frame_data_fragment(
          params.message());
  mojo::internal::Serialize<::device::mojom::XRFrameDataDataView>(
      in_frame_data, frame_data_fragment);
  params->frame_data.Set(
      frame_data_fragment.is_null() ? nullptr : frame_data_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRFrameDataProvider::Name_);
  message.set_method_name("GetFrameData");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool XRFrameDataProviderStubDispatch::Accept(
    XRFrameDataProvider* impl,
    mojo::Message* message) {
  switch (static_cast<messages::XRFrameDataProvider>(message->header()->name)) {
    case messages::XRFrameDataProvider::kGetFrameData: {
      break;
    }
    case messages::XRFrameDataProvider::kGetEnvironmentIntegrationProvider: {
      DCHECK(message->is_serialized());
      internal::XRFrameDataProvider_GetEnvironmentIntegrationProvider_Params_Data* params =
          reinterpret_cast<internal::XRFrameDataProvider_GetEnvironmentIntegrationProvider_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for XRFrameDataProvider.1
      bool success = true;
      ::mojo::PendingAssociatedReceiver<XREnvironmentIntegrationProvider> p_environment_provider{};
      XRFrameDataProvider_GetEnvironmentIntegrationProvider_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_environment_provider =
            input_data_view.TakeEnvironmentProvider<decltype(p_environment_provider)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XRFrameDataProvider::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetEnvironmentIntegrationProvider(        
        std::move(p_environment_provider));
      return true;
    }
  }
  return false;
}

// static
bool XRFrameDataProviderStubDispatch::AcceptWithResponder(
    XRFrameDataProvider* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::XRFrameDataProvider>(message->header()->name)) {
    case messages::XRFrameDataProvider::kGetFrameData: {
      internal::XRFrameDataProvider_GetFrameData_Params_Data* params =
          reinterpret_cast<
              internal::XRFrameDataProvider_GetFrameData_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for XRFrameDataProvider.0
      bool success = true;
      XRFrameDataRequestOptionsPtr p_options{};
      XRFrameDataProvider_GetFrameData_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XRFrameDataProvider::Name_, 0, false);
        return false;
      }
      XRFrameDataProvider::GetFrameDataCallback callback =
          XRFrameDataProvider_GetFrameData_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetFrameData(        
        std::move(p_options), std::move(callback));
      return true;
    }
    case messages::XRFrameDataProvider::kGetEnvironmentIntegrationProvider: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kXRFrameDataProviderValidationInfo[] = {
    {base::to_underlying(messages::XRFrameDataProvider::kGetFrameData),
     { &internal::XRFrameDataProvider_GetFrameData_Params_Data::Validate,
      &internal::XRFrameDataProvider_GetFrameData_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::XRFrameDataProvider::kGetEnvironmentIntegrationProvider),
     { &internal::XRFrameDataProvider_GetEnvironmentIntegrationProvider_Params_Data::Validate,
      nullptr /* no response */}},
};

bool XRFrameDataProviderRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::blink::XRFrameDataProvider::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kXRFrameDataProviderValidationInfo);
}

bool XRFrameDataProviderResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::blink::XRFrameDataProvider::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kXRFrameDataProviderValidationInfo);

}
const char XRPresentationProvider::Name_[] = "device.mojom.XRPresentationProvider";

XRPresentationProvider::IPCStableHashFunction XRPresentationProvider::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::XRPresentationProvider>(message.name())) {
    case messages::XRPresentationProvider::kUpdateLayerBounds: {
      return &XRPresentationProvider::UpdateLayerBounds_Sym::IPCStableHash;
    }
    case messages::XRPresentationProvider::kSubmitFrameMissing: {
      return &XRPresentationProvider::SubmitFrameMissing_Sym::IPCStableHash;
    }
    case messages::XRPresentationProvider::kSubmitFrame: {
      return &XRPresentationProvider::SubmitFrame_Sym::IPCStableHash;
    }
    case messages::XRPresentationProvider::kSubmitFrameDrawnIntoTexture: {
      return &XRPresentationProvider::SubmitFrameDrawnIntoTexture_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* XRPresentationProvider::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::XRPresentationProvider>(message.name())) {
      case messages::XRPresentationProvider::kUpdateLayerBounds:
            return "Receive device::mojom::XRPresentationProvider::UpdateLayerBounds";
      case messages::XRPresentationProvider::kSubmitFrameMissing:
            return "Receive device::mojom::XRPresentationProvider::SubmitFrameMissing";
      case messages::XRPresentationProvider::kSubmitFrame:
            return "Receive device::mojom::XRPresentationProvider::SubmitFrame";
      case messages::XRPresentationProvider::kSubmitFrameDrawnIntoTexture:
            return "Receive device::mojom::XRPresentationProvider::SubmitFrameDrawnIntoTexture";
    }
  } else {
    switch (static_cast<messages::XRPresentationProvider>(message.name())) {
      case messages::XRPresentationProvider::kUpdateLayerBounds:
            return "Receive reply device::mojom::XRPresentationProvider::UpdateLayerBounds";
      case messages::XRPresentationProvider::kSubmitFrameMissing:
            return "Receive reply device::mojom::XRPresentationProvider::SubmitFrameMissing";
      case messages::XRPresentationProvider::kSubmitFrame:
            return "Receive reply device::mojom::XRPresentationProvider::SubmitFrame";
      case messages::XRPresentationProvider::kSubmitFrameDrawnIntoTexture:
            return "Receive reply device::mojom::XRPresentationProvider::SubmitFrameDrawnIntoTexture";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t XRPresentationProvider::UpdateLayerBounds_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)device::mojom::XRPresentationProvider::UpdateLayerBounds");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t XRPresentationProvider::SubmitFrameMissing_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)device::mojom::XRPresentationProvider::SubmitFrameMissing");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t XRPresentationProvider::SubmitFrame_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)device::mojom::XRPresentationProvider::SubmitFrame");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t XRPresentationProvider::SubmitFrameDrawnIntoTexture_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)device::mojom::XRPresentationProvider::SubmitFrameDrawnIntoTexture");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

XRPresentationProviderProxy::XRPresentationProviderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void XRPresentationProviderProxy::UpdateLayerBounds(
    int16_t in_frame_id, const ::gfx::RectF& in_left_bounds, const ::gfx::RectF& in_right_bounds, const ::gfx::Size& in_source_size) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::XRPresentationProvider::UpdateLayerBounds", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_id"), in_frame_id,
                        "<value of type int16_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("left_bounds"), in_left_bounds,
                        "<value of type const ::gfx::RectF&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("right_bounds"), in_right_bounds,
                        "<value of type const ::gfx::RectF&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source_size"), in_source_size,
                        "<value of type const ::gfx::Size&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XRPresentationProvider::kUpdateLayerBounds), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::XRPresentationProvider_UpdateLayerBounds_Params_Data> params(
          message);
  params.Allocate();
  params->frame_id = in_frame_id;
  mojo::internal::MessageFragment<
      typename decltype(params->left_bounds)::BaseType> left_bounds_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::RectFDataView>(
      in_left_bounds, left_bounds_fragment);
  params->left_bounds.Set(
      left_bounds_fragment.is_null() ? nullptr : left_bounds_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->left_bounds.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null left_bounds in XRPresentationProvider.UpdateLayerBounds request");
  mojo::internal::MessageFragment<
      typename decltype(params->right_bounds)::BaseType> right_bounds_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::RectFDataView>(
      in_right_bounds, right_bounds_fragment);
  params->right_bounds.Set(
      right_bounds_fragment.is_null() ? nullptr : right_bounds_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->right_bounds.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null right_bounds in XRPresentationProvider.UpdateLayerBounds request");
  mojo::internal::MessageFragment<
      typename decltype(params->source_size)::BaseType> source_size_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
      in_source_size, source_size_fragment);
  params->source_size.Set(
      source_size_fragment.is_null() ? nullptr : source_size_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->source_size.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null source_size in XRPresentationProvider.UpdateLayerBounds request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRPresentationProvider::Name_);
  message.set_method_name("UpdateLayerBounds");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void XRPresentationProviderProxy::SubmitFrameMissing(
    int16_t in_frame_id, const ::gpu::SyncToken& in_sync_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::XRPresentationProvider::SubmitFrameMissing", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_id"), in_frame_id,
                        "<value of type int16_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("sync_token"), in_sync_token,
                        "<value of type const ::gpu::SyncToken&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XRPresentationProvider::kSubmitFrameMissing), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::XRPresentationProvider_SubmitFrameMissing_Params_Data> params(
          message);
  params.Allocate();
  params->frame_id = in_frame_id;
  mojo::internal::MessageFragment<
      typename decltype(params->sync_token)::BaseType> sync_token_fragment(
          params.message());
  mojo::internal::Serialize<::gpu::mojom::SyncTokenDataView>(
      in_sync_token, sync_token_fragment);
  params->sync_token.Set(
      sync_token_fragment.is_null() ? nullptr : sync_token_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->sync_token.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null sync_token in XRPresentationProvider.SubmitFrameMissing request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRPresentationProvider::Name_);
  message.set_method_name("SubmitFrameMissing");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void XRPresentationProviderProxy::SubmitFrame(
    int16_t in_frame_id, const ::gpu::MailboxHolder& in_mailbox_holder, ::base::TimeDelta in_time_waited) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::XRPresentationProvider::SubmitFrame", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_id"), in_frame_id,
                        "<value of type int16_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("mailbox_holder"), in_mailbox_holder,
                        "<value of type const ::gpu::MailboxHolder&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("time_waited"), in_time_waited,
                        "<value of type ::base::TimeDelta>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XRPresentationProvider::kSubmitFrame), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::XRPresentationProvider_SubmitFrame_Params_Data> params(
          message);
  params.Allocate();
  params->frame_id = in_frame_id;
  mojo::internal::MessageFragment<
      typename decltype(params->mailbox_holder)::BaseType> mailbox_holder_fragment(
          params.message());
  mojo::internal::Serialize<::gpu::mojom::MailboxHolderDataView>(
      in_mailbox_holder, mailbox_holder_fragment);
  params->mailbox_holder.Set(
      mailbox_holder_fragment.is_null() ? nullptr : mailbox_holder_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->mailbox_holder.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null mailbox_holder in XRPresentationProvider.SubmitFrame request");
  mojo::internal::MessageFragment<
      typename decltype(params->time_waited)::BaseType> time_waited_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_time_waited, time_waited_fragment);
  params->time_waited.Set(
      time_waited_fragment.is_null() ? nullptr : time_waited_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->time_waited.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null time_waited in XRPresentationProvider.SubmitFrame request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRPresentationProvider::Name_);
  message.set_method_name("SubmitFrame");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void XRPresentationProviderProxy::SubmitFrameDrawnIntoTexture(
    int16_t in_frameId, const ::gpu::SyncToken& in_sync_token, ::base::TimeDelta in_time_waited) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::XRPresentationProvider::SubmitFrameDrawnIntoTexture", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frameId"), in_frameId,
                        "<value of type int16_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("sync_token"), in_sync_token,
                        "<value of type const ::gpu::SyncToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("time_waited"), in_time_waited,
                        "<value of type ::base::TimeDelta>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XRPresentationProvider::kSubmitFrameDrawnIntoTexture), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::XRPresentationProvider_SubmitFrameDrawnIntoTexture_Params_Data> params(
          message);
  params.Allocate();
  params->frameId = in_frameId;
  mojo::internal::MessageFragment<
      typename decltype(params->sync_token)::BaseType> sync_token_fragment(
          params.message());
  mojo::internal::Serialize<::gpu::mojom::SyncTokenDataView>(
      in_sync_token, sync_token_fragment);
  params->sync_token.Set(
      sync_token_fragment.is_null() ? nullptr : sync_token_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->sync_token.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null sync_token in XRPresentationProvider.SubmitFrameDrawnIntoTexture request");
  mojo::internal::MessageFragment<
      typename decltype(params->time_waited)::BaseType> time_waited_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_time_waited, time_waited_fragment);
  params->time_waited.Set(
      time_waited_fragment.is_null() ? nullptr : time_waited_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->time_waited.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null time_waited in XRPresentationProvider.SubmitFrameDrawnIntoTexture request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRPresentationProvider::Name_);
  message.set_method_name("SubmitFrameDrawnIntoTexture");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool XRPresentationProviderStubDispatch::Accept(
    XRPresentationProvider* impl,
    mojo::Message* message) {
  switch (static_cast<messages::XRPresentationProvider>(message->header()->name)) {
    case messages::XRPresentationProvider::kUpdateLayerBounds: {
      DCHECK(message->is_serialized());
      internal::XRPresentationProvider_UpdateLayerBounds_Params_Data* params =
          reinterpret_cast<internal::XRPresentationProvider_UpdateLayerBounds_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for XRPresentationProvider.0
      bool success = true;
      int16_t p_frame_id{};
      ::gfx::RectF p_left_bounds{};
      ::gfx::RectF p_right_bounds{};
      ::gfx::Size p_source_size{};
      XRPresentationProvider_UpdateLayerBounds_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_frame_id = input_data_view.frame_id();
      if (success && !input_data_view.ReadLeftBounds(&p_left_bounds))
        success = false;
      if (success && !input_data_view.ReadRightBounds(&p_right_bounds))
        success = false;
      if (success && !input_data_view.ReadSourceSize(&p_source_size))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XRPresentationProvider::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateLayerBounds(        
        std::move(p_frame_id), 
        std::move(p_left_bounds), 
        std::move(p_right_bounds), 
        std::move(p_source_size));
      return true;
    }
    case messages::XRPresentationProvider::kSubmitFrameMissing: {
      DCHECK(message->is_serialized());
      internal::XRPresentationProvider_SubmitFrameMissing_Params_Data* params =
          reinterpret_cast<internal::XRPresentationProvider_SubmitFrameMissing_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for XRPresentationProvider.1
      bool success = true;
      int16_t p_frame_id{};
      ::gpu::SyncToken p_sync_token{};
      XRPresentationProvider_SubmitFrameMissing_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_frame_id = input_data_view.frame_id();
      if (success && !input_data_view.ReadSyncToken(&p_sync_token))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XRPresentationProvider::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SubmitFrameMissing(        
        std::move(p_frame_id), 
        std::move(p_sync_token));
      return true;
    }
    case messages::XRPresentationProvider::kSubmitFrame: {
      DCHECK(message->is_serialized());
      internal::XRPresentationProvider_SubmitFrame_Params_Data* params =
          reinterpret_cast<internal::XRPresentationProvider_SubmitFrame_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for XRPresentationProvider.2
      bool success = true;
      int16_t p_frame_id{};
      ::gpu::MailboxHolder p_mailbox_holder{};
      ::base::TimeDelta p_time_waited{};
      XRPresentationProvider_SubmitFrame_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_frame_id = input_data_view.frame_id();
      if (success && !input_data_view.ReadMailboxHolder(&p_mailbox_holder))
        success = false;
      if (success && !input_data_view.ReadTimeWaited(&p_time_waited))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XRPresentationProvider::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SubmitFrame(        
        std::move(p_frame_id), 
        std::move(p_mailbox_holder), 
        std::move(p_time_waited));
      return true;
    }
    case messages::XRPresentationProvider::kSubmitFrameDrawnIntoTexture: {
      DCHECK(message->is_serialized());
      internal::XRPresentationProvider_SubmitFrameDrawnIntoTexture_Params_Data* params =
          reinterpret_cast<internal::XRPresentationProvider_SubmitFrameDrawnIntoTexture_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for XRPresentationProvider.3
      bool success = true;
      int16_t p_frameId{};
      ::gpu::SyncToken p_sync_token{};
      ::base::TimeDelta p_time_waited{};
      XRPresentationProvider_SubmitFrameDrawnIntoTexture_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_frameId = input_data_view.frameId();
      if (success && !input_data_view.ReadSyncToken(&p_sync_token))
        success = false;
      if (success && !input_data_view.ReadTimeWaited(&p_time_waited))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XRPresentationProvider::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SubmitFrameDrawnIntoTexture(        
        std::move(p_frameId), 
        std::move(p_sync_token), 
        std::move(p_time_waited));
      return true;
    }
  }
  return false;
}

// static
bool XRPresentationProviderStubDispatch::AcceptWithResponder(
    XRPresentationProvider* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::XRPresentationProvider>(message->header()->name)) {
    case messages::XRPresentationProvider::kUpdateLayerBounds: {
      break;
    }
    case messages::XRPresentationProvider::kSubmitFrameMissing: {
      break;
    }
    case messages::XRPresentationProvider::kSubmitFrame: {
      break;
    }
    case messages::XRPresentationProvider::kSubmitFrameDrawnIntoTexture: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kXRPresentationProviderValidationInfo[] = {
    {base::to_underlying(messages::XRPresentationProvider::kUpdateLayerBounds),
     { &internal::XRPresentationProvider_UpdateLayerBounds_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::XRPresentationProvider::kSubmitFrameMissing),
     { &internal::XRPresentationProvider_SubmitFrameMissing_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::XRPresentationProvider::kSubmitFrame),
     { &internal::XRPresentationProvider_SubmitFrame_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::XRPresentationProvider::kSubmitFrameDrawnIntoTexture),
     { &internal::XRPresentationProvider_SubmitFrameDrawnIntoTexture_Params_Data::Validate,
      nullptr /* no response */}},
};

bool XRPresentationProviderRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::blink::XRPresentationProvider::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kXRPresentationProviderValidationInfo);
}

const char XRPresentationClient::Name_[] = "device.mojom.XRPresentationClient";

XRPresentationClient::IPCStableHashFunction XRPresentationClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::XRPresentationClient>(message.name())) {
    case messages::XRPresentationClient::kOnSubmitFrameTransferred: {
      return &XRPresentationClient::OnSubmitFrameTransferred_Sym::IPCStableHash;
    }
    case messages::XRPresentationClient::kOnSubmitFrameRendered: {
      return &XRPresentationClient::OnSubmitFrameRendered_Sym::IPCStableHash;
    }
    case messages::XRPresentationClient::kOnSubmitFrameGpuFence: {
      return &XRPresentationClient::OnSubmitFrameGpuFence_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* XRPresentationClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::XRPresentationClient>(message.name())) {
      case messages::XRPresentationClient::kOnSubmitFrameTransferred:
            return "Receive device::mojom::XRPresentationClient::OnSubmitFrameTransferred";
      case messages::XRPresentationClient::kOnSubmitFrameRendered:
            return "Receive device::mojom::XRPresentationClient::OnSubmitFrameRendered";
      case messages::XRPresentationClient::kOnSubmitFrameGpuFence:
            return "Receive device::mojom::XRPresentationClient::OnSubmitFrameGpuFence";
    }
  } else {
    switch (static_cast<messages::XRPresentationClient>(message.name())) {
      case messages::XRPresentationClient::kOnSubmitFrameTransferred:
            return "Receive reply device::mojom::XRPresentationClient::OnSubmitFrameTransferred";
      case messages::XRPresentationClient::kOnSubmitFrameRendered:
            return "Receive reply device::mojom::XRPresentationClient::OnSubmitFrameRendered";
      case messages::XRPresentationClient::kOnSubmitFrameGpuFence:
            return "Receive reply device::mojom::XRPresentationClient::OnSubmitFrameGpuFence";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t XRPresentationClient::OnSubmitFrameTransferred_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)device::mojom::XRPresentationClient::OnSubmitFrameTransferred");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t XRPresentationClient::OnSubmitFrameRendered_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)device::mojom::XRPresentationClient::OnSubmitFrameRendered");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t XRPresentationClient::OnSubmitFrameGpuFence_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)device::mojom::XRPresentationClient::OnSubmitFrameGpuFence");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

XRPresentationClientProxy::XRPresentationClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void XRPresentationClientProxy::OnSubmitFrameTransferred(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::XRPresentationClient::OnSubmitFrameTransferred", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XRPresentationClient::kOnSubmitFrameTransferred), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::XRPresentationClient_OnSubmitFrameTransferred_Params_Data> params(
          message);
  params.Allocate();
  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRPresentationClient::Name_);
  message.set_method_name("OnSubmitFrameTransferred");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void XRPresentationClientProxy::OnSubmitFrameRendered(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send device::mojom::XRPresentationClient::OnSubmitFrameRendered");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XRPresentationClient::kOnSubmitFrameRendered), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::XRPresentationClient_OnSubmitFrameRendered_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRPresentationClient::Name_);
  message.set_method_name("OnSubmitFrameRendered");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void XRPresentationClientProxy::OnSubmitFrameGpuFence(
    ::gfx::GpuFenceHandle in_gpu_fence_handle) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::XRPresentationClient::OnSubmitFrameGpuFence", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("gpu_fence_handle"), in_gpu_fence_handle,
                        "<value of type ::gfx::GpuFenceHandle>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XRPresentationClient::kOnSubmitFrameGpuFence), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::XRPresentationClient_OnSubmitFrameGpuFence_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->gpu_fence_handle)::BaseType> gpu_fence_handle_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::GpuFenceHandleDataView>(
      in_gpu_fence_handle, gpu_fence_handle_fragment);
  params->gpu_fence_handle.Set(
      gpu_fence_handle_fragment.is_null() ? nullptr : gpu_fence_handle_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->gpu_fence_handle.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null gpu_fence_handle in XRPresentationClient.OnSubmitFrameGpuFence request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRPresentationClient::Name_);
  message.set_method_name("OnSubmitFrameGpuFence");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool XRPresentationClientStubDispatch::Accept(
    XRPresentationClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::XRPresentationClient>(message->header()->name)) {
    case messages::XRPresentationClient::kOnSubmitFrameTransferred: {
      DCHECK(message->is_serialized());
      internal::XRPresentationClient_OnSubmitFrameTransferred_Params_Data* params =
          reinterpret_cast<internal::XRPresentationClient_OnSubmitFrameTransferred_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for XRPresentationClient.0
      bool success = true;
      bool p_success{};
      XRPresentationClient_OnSubmitFrameTransferred_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_success = input_data_view.success();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XRPresentationClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnSubmitFrameTransferred(        
        std::move(p_success));
      return true;
    }
    case messages::XRPresentationClient::kOnSubmitFrameRendered: {
      DCHECK(message->is_serialized());
      internal::XRPresentationClient_OnSubmitFrameRendered_Params_Data* params =
          reinterpret_cast<internal::XRPresentationClient_OnSubmitFrameRendered_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for XRPresentationClient.1
      bool success = true;
      XRPresentationClient_OnSubmitFrameRendered_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XRPresentationClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnSubmitFrameRendered(        );
      return true;
    }
    case messages::XRPresentationClient::kOnSubmitFrameGpuFence: {
      DCHECK(message->is_serialized());
      internal::XRPresentationClient_OnSubmitFrameGpuFence_Params_Data* params =
          reinterpret_cast<internal::XRPresentationClient_OnSubmitFrameGpuFence_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for XRPresentationClient.2
      bool success = true;
      ::gfx::GpuFenceHandle p_gpu_fence_handle{};
      XRPresentationClient_OnSubmitFrameGpuFence_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadGpuFenceHandle(&p_gpu_fence_handle))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XRPresentationClient::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnSubmitFrameGpuFence(        
        std::move(p_gpu_fence_handle));
      return true;
    }
  }
  return false;
}

// static
bool XRPresentationClientStubDispatch::AcceptWithResponder(
    XRPresentationClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::XRPresentationClient>(message->header()->name)) {
    case messages::XRPresentationClient::kOnSubmitFrameTransferred: {
      break;
    }
    case messages::XRPresentationClient::kOnSubmitFrameRendered: {
      break;
    }
    case messages::XRPresentationClient::kOnSubmitFrameGpuFence: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kXRPresentationClientValidationInfo[] = {
    {base::to_underlying(messages::XRPresentationClient::kOnSubmitFrameTransferred),
     { &internal::XRPresentationClient_OnSubmitFrameTransferred_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::XRPresentationClient::kOnSubmitFrameRendered),
     { &internal::XRPresentationClient_OnSubmitFrameRendered_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::XRPresentationClient::kOnSubmitFrameGpuFence),
     { &internal::XRPresentationClient_OnSubmitFrameGpuFence_Params_Data::Validate,
      nullptr /* no response */}},
};

bool XRPresentationClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::blink::XRPresentationClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kXRPresentationClientValidationInfo);
}

const char XRSessionClient::Name_[] = "device.mojom.XRSessionClient";

XRSessionClient::IPCStableHashFunction XRSessionClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::XRSessionClient>(message.name())) {
    case messages::XRSessionClient::kOnExitPresent: {
      return &XRSessionClient::OnExitPresent_Sym::IPCStableHash;
    }
    case messages::XRSessionClient::kOnVisibilityStateChanged: {
      return &XRSessionClient::OnVisibilityStateChanged_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* XRSessionClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::XRSessionClient>(message.name())) {
      case messages::XRSessionClient::kOnExitPresent:
            return "Receive device::mojom::XRSessionClient::OnExitPresent";
      case messages::XRSessionClient::kOnVisibilityStateChanged:
            return "Receive device::mojom::XRSessionClient::OnVisibilityStateChanged";
    }
  } else {
    switch (static_cast<messages::XRSessionClient>(message.name())) {
      case messages::XRSessionClient::kOnExitPresent:
            return "Receive reply device::mojom::XRSessionClient::OnExitPresent";
      case messages::XRSessionClient::kOnVisibilityStateChanged:
            return "Receive reply device::mojom::XRSessionClient::OnVisibilityStateChanged";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t XRSessionClient::OnExitPresent_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)device::mojom::XRSessionClient::OnExitPresent");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t XRSessionClient::OnVisibilityStateChanged_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)device::mojom::XRSessionClient::OnVisibilityStateChanged");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

XRSessionClientProxy::XRSessionClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void XRSessionClientProxy::OnExitPresent(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send device::mojom::XRSessionClient::OnExitPresent");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XRSessionClient::kOnExitPresent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::XRSessionClient_OnExitPresent_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRSessionClient::Name_);
  message.set_method_name("OnExitPresent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void XRSessionClientProxy::OnVisibilityStateChanged(
    XRVisibilityState in_visibility_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::XRSessionClient::OnVisibilityStateChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("visibility_state"), in_visibility_state,
                        "<value of type XRVisibilityState>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XRSessionClient::kOnVisibilityStateChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::XRSessionClient_OnVisibilityStateChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::device::mojom::XRVisibilityState>(
      in_visibility_state, &params->visibility_state);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRSessionClient::Name_);
  message.set_method_name("OnVisibilityStateChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool XRSessionClientStubDispatch::Accept(
    XRSessionClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::XRSessionClient>(message->header()->name)) {
    case messages::XRSessionClient::kOnExitPresent: {
      DCHECK(message->is_serialized());
      internal::XRSessionClient_OnExitPresent_Params_Data* params =
          reinterpret_cast<internal::XRSessionClient_OnExitPresent_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for XRSessionClient.0
      bool success = true;
      XRSessionClient_OnExitPresent_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XRSessionClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnExitPresent(        );
      return true;
    }
    case messages::XRSessionClient::kOnVisibilityStateChanged: {
      DCHECK(message->is_serialized());
      internal::XRSessionClient_OnVisibilityStateChanged_Params_Data* params =
          reinterpret_cast<internal::XRSessionClient_OnVisibilityStateChanged_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for XRSessionClient.1
      bool success = true;
      XRVisibilityState p_visibility_state{};
      XRSessionClient_OnVisibilityStateChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadVisibilityState(&p_visibility_state))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XRSessionClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnVisibilityStateChanged(        
        std::move(p_visibility_state));
      return true;
    }
  }
  return false;
}

// static
bool XRSessionClientStubDispatch::AcceptWithResponder(
    XRSessionClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::XRSessionClient>(message->header()->name)) {
    case messages::XRSessionClient::kOnExitPresent: {
      break;
    }
    case messages::XRSessionClient::kOnVisibilityStateChanged: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kXRSessionClientValidationInfo[] = {
    {base::to_underlying(messages::XRSessionClient::kOnExitPresent),
     { &internal::XRSessionClient_OnExitPresent_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::XRSessionClient::kOnVisibilityStateChanged),
     { &internal::XRSessionClient_OnVisibilityStateChanged_Params_Data::Validate,
      nullptr /* no response */}},
};

bool XRSessionClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::blink::XRSessionClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kXRSessionClientValidationInfo);
}

const char WebXrInternalsRendererListener::Name_[] = "device.mojom.WebXrInternalsRendererListener";

WebXrInternalsRendererListener::IPCStableHashFunction WebXrInternalsRendererListener::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::WebXrInternalsRendererListener>(message.name())) {
    case messages::WebXrInternalsRendererListener::kOnFrameData: {
      return &WebXrInternalsRendererListener::OnFrameData_Sym::IPCStableHash;
    }
    case messages::WebXrInternalsRendererListener::kOnConsoleLog: {
      return &WebXrInternalsRendererListener::OnConsoleLog_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* WebXrInternalsRendererListener::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::WebXrInternalsRendererListener>(message.name())) {
      case messages::WebXrInternalsRendererListener::kOnFrameData:
            return "Receive device::mojom::WebXrInternalsRendererListener::OnFrameData";
      case messages::WebXrInternalsRendererListener::kOnConsoleLog:
            return "Receive device::mojom::WebXrInternalsRendererListener::OnConsoleLog";
    }
  } else {
    switch (static_cast<messages::WebXrInternalsRendererListener>(message.name())) {
      case messages::WebXrInternalsRendererListener::kOnFrameData:
            return "Receive reply device::mojom::WebXrInternalsRendererListener::OnFrameData";
      case messages::WebXrInternalsRendererListener::kOnConsoleLog:
            return "Receive reply device::mojom::WebXrInternalsRendererListener::OnConsoleLog";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t WebXrInternalsRendererListener::OnFrameData_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)device::mojom::WebXrInternalsRendererListener::OnFrameData");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebXrInternalsRendererListener::OnConsoleLog_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)device::mojom::WebXrInternalsRendererListener::OnConsoleLog");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

WebXrInternalsRendererListenerProxy::WebXrInternalsRendererListenerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WebXrInternalsRendererListenerProxy::OnFrameData(
    ::device::mojom::blink::XrFrameStatisticsPtr in_xrframe_statistics) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::WebXrInternalsRendererListener::OnFrameData", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("xrframe_statistics"), in_xrframe_statistics,
                        "<value of type ::device::mojom::blink::XrFrameStatisticsPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebXrInternalsRendererListener::kOnFrameData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::WebXrInternalsRendererListener_OnFrameData_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->xrframe_statistics)::BaseType> xrframe_statistics_fragment(
          params.message());
  mojo::internal::Serialize<::device::mojom::XrFrameStatisticsDataView>(
      in_xrframe_statistics, xrframe_statistics_fragment);
  params->xrframe_statistics.Set(
      xrframe_statistics_fragment.is_null() ? nullptr : xrframe_statistics_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->xrframe_statistics.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null xrframe_statistics in WebXrInternalsRendererListener.OnFrameData request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebXrInternalsRendererListener::Name_);
  message.set_method_name("OnFrameData");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebXrInternalsRendererListenerProxy::OnConsoleLog(
    ::device::mojom::blink::XrLogMessagePtr in_xrlogging_statistics) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::WebXrInternalsRendererListener::OnConsoleLog", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("xrlogging_statistics"), in_xrlogging_statistics,
                        "<value of type ::device::mojom::blink::XrLogMessagePtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebXrInternalsRendererListener::kOnConsoleLog), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::WebXrInternalsRendererListener_OnConsoleLog_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->xrlogging_statistics)::BaseType> xrlogging_statistics_fragment(
          params.message());
  mojo::internal::Serialize<::device::mojom::XrLogMessageDataView>(
      in_xrlogging_statistics, xrlogging_statistics_fragment);
  params->xrlogging_statistics.Set(
      xrlogging_statistics_fragment.is_null() ? nullptr : xrlogging_statistics_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->xrlogging_statistics.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null xrlogging_statistics in WebXrInternalsRendererListener.OnConsoleLog request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebXrInternalsRendererListener::Name_);
  message.set_method_name("OnConsoleLog");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool WebXrInternalsRendererListenerStubDispatch::Accept(
    WebXrInternalsRendererListener* impl,
    mojo::Message* message) {
  switch (static_cast<messages::WebXrInternalsRendererListener>(message->header()->name)) {
    case messages::WebXrInternalsRendererListener::kOnFrameData: {
      DCHECK(message->is_serialized());
      internal::WebXrInternalsRendererListener_OnFrameData_Params_Data* params =
          reinterpret_cast<internal::WebXrInternalsRendererListener_OnFrameData_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for WebXrInternalsRendererListener.0
      bool success = true;
      ::device::mojom::blink::XrFrameStatisticsPtr p_xrframe_statistics{};
      WebXrInternalsRendererListener_OnFrameData_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadXrframeStatistics(&p_xrframe_statistics))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebXrInternalsRendererListener::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnFrameData(        
        std::move(p_xrframe_statistics));
      return true;
    }
    case messages::WebXrInternalsRendererListener::kOnConsoleLog: {
      DCHECK(message->is_serialized());
      internal::WebXrInternalsRendererListener_OnConsoleLog_Params_Data* params =
          reinterpret_cast<internal::WebXrInternalsRendererListener_OnConsoleLog_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for WebXrInternalsRendererListener.1
      bool success = true;
      ::device::mojom::blink::XrLogMessagePtr p_xrlogging_statistics{};
      WebXrInternalsRendererListener_OnConsoleLog_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadXrloggingStatistics(&p_xrlogging_statistics))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebXrInternalsRendererListener::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnConsoleLog(        
        std::move(p_xrlogging_statistics));
      return true;
    }
  }
  return false;
}

// static
bool WebXrInternalsRendererListenerStubDispatch::AcceptWithResponder(
    WebXrInternalsRendererListener* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::WebXrInternalsRendererListener>(message->header()->name)) {
    case messages::WebXrInternalsRendererListener::kOnFrameData: {
      break;
    }
    case messages::WebXrInternalsRendererListener::kOnConsoleLog: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kWebXrInternalsRendererListenerValidationInfo[] = {
    {base::to_underlying(messages::WebXrInternalsRendererListener::kOnFrameData),
     { &internal::WebXrInternalsRendererListener_OnFrameData_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::WebXrInternalsRendererListener::kOnConsoleLog),
     { &internal::WebXrInternalsRendererListener_OnConsoleLog_Params_Data::Validate,
      nullptr /* no response */}},
};

bool WebXrInternalsRendererListenerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::blink::WebXrInternalsRendererListener::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kWebXrInternalsRendererListenerValidationInfo);
}



}  // device::mojom::blink


namespace mojo {


// static
bool StructTraits<::device::mojom::blink::XRDepthConfig::DataView, ::device::mojom::blink::XRDepthConfigPtr>::Read(
    ::device::mojom::blink::XRDepthConfig::DataView input,
    ::device::mojom::blink::XRDepthConfigPtr* output) {
  bool success = true;
  ::device::mojom::blink::XRDepthConfigPtr result(::device::mojom::blink::XRDepthConfig::New());
  
      if (success && !input.ReadDepthUsage(&result->depth_usage))
        success = false;
      if (success && !input.ReadDepthDataFormat(&result->depth_data_format))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::XRSessionDeviceConfig::DataView, ::device::mojom::blink::XRSessionDeviceConfigPtr>::Read(
    ::device::mojom::blink::XRSessionDeviceConfig::DataView input,
    ::device::mojom::blink::XRSessionDeviceConfigPtr* output) {
  bool success = true;
  ::device::mojom::blink::XRSessionDeviceConfigPtr result(::device::mojom::blink::XRSessionDeviceConfig::New());
  
      if (success)
        result->default_framebuffer_scale = input.default_framebuffer_scale();
      if (success && !input.ReadViews(&result->views))
        success = false;
      if (success)
        result->supports_viewport_scaling = input.supports_viewport_scaling();
      if (success)
        result->enable_anti_aliasing = input.enable_anti_aliasing();
      if (success && !input.ReadDepthConfiguration(&result->depth_configuration))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::XRSession::DataView, ::device::mojom::blink::XRSessionPtr>::Read(
    ::device::mojom::blink::XRSession::DataView input,
    ::device::mojom::blink::XRSessionPtr* output) {
  bool success = true;
  ::device::mojom::blink::XRSessionPtr result(::device::mojom::blink::XRSession::New());
  
      if (success) {
        result->data_provider =
            input.TakeDataProvider<decltype(result->data_provider)>();
      }
      if (success) {
        result->client_receiver =
            input.TakeClientReceiver<decltype(result->client_receiver)>();
      }
      if (success && !input.ReadSubmitFrameSink(&result->submit_frame_sink))
        success = false;
      if (success && !input.ReadEnabledFeatures(&result->enabled_features))
        success = false;
      if (success && !input.ReadDeviceConfig(&result->device_config))
        success = false;
      if (success && !input.ReadEnviromentBlendMode(&result->enviroment_blend_mode))
        success = false;
      if (success && !input.ReadInteractionMode(&result->interaction_mode))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::XRPresentationConnection::DataView, ::device::mojom::blink::XRPresentationConnectionPtr>::Read(
    ::device::mojom::blink::XRPresentationConnection::DataView input,
    ::device::mojom::blink::XRPresentationConnectionPtr* output) {
  bool success = true;
  ::device::mojom::blink::XRPresentationConnectionPtr result(::device::mojom::blink::XRPresentationConnection::New());
  
      if (success) {
        result->provider =
            input.TakeProvider<decltype(result->provider)>();
      }
      if (success) {
        result->client_receiver =
            input.TakeClientReceiver<decltype(result->client_receiver)>();
      }
      if (success && !input.ReadTransportOptions(&result->transport_options))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::XRInputSourceDescription::DataView, ::device::mojom::blink::XRInputSourceDescriptionPtr>::Read(
    ::device::mojom::blink::XRInputSourceDescription::DataView input,
    ::device::mojom::blink::XRInputSourceDescriptionPtr* output) {
  bool success = true;
  ::device::mojom::blink::XRInputSourceDescriptionPtr result(::device::mojom::blink::XRInputSourceDescription::New());
  
      if (success && !input.ReadTargetRayMode(&result->target_ray_mode))
        success = false;
      if (success && !input.ReadHandedness(&result->handedness))
        success = false;
      if (success && !input.ReadInputFromPointer(&result->input_from_pointer))
        success = false;
      if (success && !input.ReadProfiles(&result->profiles))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::XRInputSourceState::DataView, ::device::mojom::blink::XRInputSourceStatePtr>::Read(
    ::device::mojom::blink::XRInputSourceState::DataView input,
    ::device::mojom::blink::XRInputSourceStatePtr* output) {
  bool success = true;
  ::device::mojom::blink::XRInputSourceStatePtr result(::device::mojom::blink::XRInputSourceState::New());
  
      if (success)
        result->source_id = input.source_id();
      if (success && !input.ReadDescription(&result->description))
        success = false;
      if (success && !input.ReadMojoFromInput(&result->mojo_from_input))
        success = false;
      if (success)
        result->emulated_position = input.emulated_position();
      if (success)
        result->is_auxiliary = input.is_auxiliary();
      if (success)
        result->primary_input_pressed = input.primary_input_pressed();
      if (success)
        result->primary_input_clicked = input.primary_input_clicked();
      if (success)
        result->primary_squeeze_pressed = input.primary_squeeze_pressed();
      if (success)
        result->primary_squeeze_clicked = input.primary_squeeze_clicked();
      if (success && !input.ReadGamepad(&result->gamepad))
        success = false;
      if (success && !input.ReadOverlayPointerPosition(&result->overlay_pointer_position))
        success = false;
      if (success && !input.ReadHandTrackingData(&result->hand_tracking_data))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::VRFieldOfView::DataView, ::device::mojom::blink::VRFieldOfViewPtr>::Read(
    ::device::mojom::blink::VRFieldOfView::DataView input,
    ::device::mojom::blink::VRFieldOfViewPtr* output) {
  bool success = true;
  ::device::mojom::blink::VRFieldOfViewPtr result(::device::mojom::blink::VRFieldOfView::New());
  
      if (success)
        result->up_degrees = input.up_degrees();
      if (success)
        result->down_degrees = input.down_degrees();
      if (success)
        result->left_degrees = input.left_degrees();
      if (success)
        result->right_degrees = input.right_degrees();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::VRPose::DataView, ::device::mojom::blink::VRPosePtr>::Read(
    ::device::mojom::blink::VRPose::DataView input,
    ::device::mojom::blink::VRPosePtr* output) {
  bool success = true;
  ::device::mojom::blink::VRPosePtr result(::device::mojom::blink::VRPose::New());
  
      if (success && !input.ReadOrientation(&result->orientation))
        success = false;
      if (success && !input.ReadPosition(&result->position))
        success = false;
      if (success)
        result->emulated_position = input.emulated_position();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::Pose::DataView, ::device::mojom::blink::PosePtr>::Read(
    ::device::mojom::blink::Pose::DataView input,
    ::device::mojom::blink::PosePtr* output) {
  bool success = true;
  ::device::mojom::blink::PosePtr result(::device::mojom::blink::Pose::New());
  
      if (success && !input.ReadOrientation(&result->orientation))
        success = false;
      if (success && !input.ReadPosition(&result->position))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::XRRay::DataView, ::device::mojom::blink::XRRayPtr>::Read(
    ::device::mojom::blink::XRRay::DataView input,
    ::device::mojom::blink::XRRayPtr* output) {
  bool success = true;
  ::device::mojom::blink::XRRayPtr result(::device::mojom::blink::XRRay::New());
  
      if (success && !input.ReadOrigin(&result->origin))
        success = false;
      if (success && !input.ReadDirection(&result->direction))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::XRHitResult::DataView, ::device::mojom::blink::XRHitResultPtr>::Read(
    ::device::mojom::blink::XRHitResult::DataView input,
    ::device::mojom::blink::XRHitResultPtr* output) {
  bool success = true;
  ::device::mojom::blink::XRHitResultPtr result(::device::mojom::blink::XRHitResult::New());
  
      if (success && !input.ReadMojoFromResult(&result->mojo_from_result))
        success = false;
      if (success)
        result->plane_id = input.plane_id();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::XRView::DataView, ::device::mojom::blink::XRViewPtr>::Read(
    ::device::mojom::blink::XRView::DataView input,
    ::device::mojom::blink::XRViewPtr* output) {
  bool success = true;
  ::device::mojom::blink::XRViewPtr result(::device::mojom::blink::XRView::New());
  
      if (success && !input.ReadEye(&result->eye))
        success = false;
      if (success && !input.ReadFieldOfView(&result->field_of_view))
        success = false;
      if (success && !input.ReadMojoFromView(&result->mojo_from_view))
        success = false;
      if (success && !input.ReadViewport(&result->viewport))
        success = false;
      if (success && !input.ReadDepthData(&result->depth_data))
        success = false;
      if (success)
        result->is_first_person_observer = input.is_first_person_observer();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::VRStageParameters::DataView, ::device::mojom::blink::VRStageParametersPtr>::Read(
    ::device::mojom::blink::VRStageParameters::DataView input,
    ::device::mojom::blink::VRStageParametersPtr* output) {
  bool success = true;
  ::device::mojom::blink::VRStageParametersPtr result(::device::mojom::blink::VRStageParameters::New());
  
      if (success && !input.ReadMojoFromStage(&result->mojo_from_stage))
        success = false;
      if (success && !input.ReadBounds(&result->bounds))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::XRPresentationTransportOptions::DataView, ::device::mojom::blink::XRPresentationTransportOptionsPtr>::Read(
    ::device::mojom::blink::XRPresentationTransportOptions::DataView input,
    ::device::mojom::blink::XRPresentationTransportOptionsPtr* output) {
  bool success = true;
  ::device::mojom::blink::XRPresentationTransportOptionsPtr result(::device::mojom::blink::XRPresentationTransportOptions::New());
  
      if (success && !input.ReadTransportMethod(&result->transport_method))
        success = false;
      if (success)
        result->wait_for_transfer_notification = input.wait_for_transfer_notification();
      if (success)
        result->wait_for_render_notification = input.wait_for_render_notification();
      if (success)
        result->wait_for_gpu_fence = input.wait_for_gpu_fence();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::XRInputSourceSpaceInfo::DataView, ::device::mojom::blink::XRInputSourceSpaceInfoPtr>::Read(
    ::device::mojom::blink::XRInputSourceSpaceInfo::DataView input,
    ::device::mojom::blink::XRInputSourceSpaceInfoPtr* output) {
  bool success = true;
  ::device::mojom::blink::XRInputSourceSpaceInfoPtr result(::device::mojom::blink::XRInputSourceSpaceInfo::New());
  
      if (success)
        result->input_source_id = input.input_source_id();
      if (success && !input.ReadInputSourceSpaceType(&result->input_source_space_type))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::XRHandJointSpaceInfo::DataView, ::device::mojom::blink::XRHandJointSpaceInfoPtr>::Read(
    ::device::mojom::blink::XRHandJointSpaceInfo::DataView input,
    ::device::mojom::blink::XRHandJointSpaceInfoPtr* output) {
  bool success = true;
  ::device::mojom::blink::XRHandJointSpaceInfoPtr result(::device::mojom::blink::XRHandJointSpaceInfo::New());
  
      if (success && !input.ReadHandedness(&result->handedness))
        success = false;
      if (success && !input.ReadJoint(&result->joint))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::XRPlanePointData::DataView, ::device::mojom::blink::XRPlanePointDataPtr>::Read(
    ::device::mojom::blink::XRPlanePointData::DataView input,
    ::device::mojom::blink::XRPlanePointDataPtr* output) {
  bool success = true;
  ::device::mojom::blink::XRPlanePointDataPtr result(::device::mojom::blink::XRPlanePointData::New());
  
      if (success)
        result->x = input.x();
      if (success)
        result->z = input.z();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::XRPlaneData::DataView, ::device::mojom::blink::XRPlaneDataPtr>::Read(
    ::device::mojom::blink::XRPlaneData::DataView input,
    ::device::mojom::blink::XRPlaneDataPtr* output) {
  bool success = true;
  ::device::mojom::blink::XRPlaneDataPtr result(::device::mojom::blink::XRPlaneData::New());
  
      if (success)
        result->id = input.id();
      if (success && !input.ReadOrientation(&result->orientation))
        success = false;
      if (success && !input.ReadMojoFromPlane(&result->mojo_from_plane))
        success = false;
      if (success && !input.ReadPolygon(&result->polygon))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::XRPlaneDetectionData::DataView, ::device::mojom::blink::XRPlaneDetectionDataPtr>::Read(
    ::device::mojom::blink::XRPlaneDetectionData::DataView input,
    ::device::mojom::blink::XRPlaneDetectionDataPtr* output) {
  bool success = true;
  ::device::mojom::blink::XRPlaneDetectionDataPtr result(::device::mojom::blink::XRPlaneDetectionData::New());
  
      if (success && !input.ReadAllPlanesIds(&result->all_planes_ids))
        success = false;
      if (success && !input.ReadUpdatedPlanesData(&result->updated_planes_data))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::XRAnchorData::DataView, ::device::mojom::blink::XRAnchorDataPtr>::Read(
    ::device::mojom::blink::XRAnchorData::DataView input,
    ::device::mojom::blink::XRAnchorDataPtr* output) {
  bool success = true;
  ::device::mojom::blink::XRAnchorDataPtr result(::device::mojom::blink::XRAnchorData::New());
  
      if (success)
        result->id = input.id();
      if (success && !input.ReadMojoFromAnchor(&result->mojo_from_anchor))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::XRAnchorsData::DataView, ::device::mojom::blink::XRAnchorsDataPtr>::Read(
    ::device::mojom::blink::XRAnchorsData::DataView input,
    ::device::mojom::blink::XRAnchorsDataPtr* output) {
  bool success = true;
  ::device::mojom::blink::XRAnchorsDataPtr result(::device::mojom::blink::XRAnchorsData::New());
  
      if (success && !input.ReadAllAnchorsIds(&result->all_anchors_ids))
        success = false;
      if (success && !input.ReadUpdatedAnchorsData(&result->updated_anchors_data))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::XRHitTestSubscriptionResultData::DataView, ::device::mojom::blink::XRHitTestSubscriptionResultDataPtr>::Read(
    ::device::mojom::blink::XRHitTestSubscriptionResultData::DataView input,
    ::device::mojom::blink::XRHitTestSubscriptionResultDataPtr* output) {
  bool success = true;
  ::device::mojom::blink::XRHitTestSubscriptionResultDataPtr result(::device::mojom::blink::XRHitTestSubscriptionResultData::New());
  
      if (success)
        result->subscription_id = input.subscription_id();
      if (success && !input.ReadHitTestResults(&result->hit_test_results))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::XRHitTestTransientInputSubscriptionResultData::DataView, ::device::mojom::blink::XRHitTestTransientInputSubscriptionResultDataPtr>::Read(
    ::device::mojom::blink::XRHitTestTransientInputSubscriptionResultData::DataView input,
    ::device::mojom::blink::XRHitTestTransientInputSubscriptionResultDataPtr* output) {
  bool success = true;
  ::device::mojom::blink::XRHitTestTransientInputSubscriptionResultDataPtr result(::device::mojom::blink::XRHitTestTransientInputSubscriptionResultData::New());
  
      if (success)
        result->subscription_id = input.subscription_id();
      if (success && !input.ReadInputSourceIdToHitTestResults(&result->input_source_id_to_hit_test_results))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::XRHitTestSubscriptionResultsData::DataView, ::device::mojom::blink::XRHitTestSubscriptionResultsDataPtr>::Read(
    ::device::mojom::blink::XRHitTestSubscriptionResultsData::DataView input,
    ::device::mojom::blink::XRHitTestSubscriptionResultsDataPtr* output) {
  bool success = true;
  ::device::mojom::blink::XRHitTestSubscriptionResultsDataPtr result(::device::mojom::blink::XRHitTestSubscriptionResultsData::New());
  
      if (success && !input.ReadResults(&result->results))
        success = false;
      if (success && !input.ReadTransientInputResults(&result->transient_input_results))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::RgbTupleF32::DataView, ::device::mojom::blink::RgbTupleF32Ptr>::Read(
    ::device::mojom::blink::RgbTupleF32::DataView input,
    ::device::mojom::blink::RgbTupleF32Ptr* output) {
  bool success = true;
  ::device::mojom::blink::RgbTupleF32Ptr result(::device::mojom::blink::RgbTupleF32::New());
  
      if (success)
        result->red = input.red();
      if (success)
        result->green = input.green();
      if (success)
        result->blue = input.blue();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::XRSphericalHarmonics::DataView, ::device::mojom::blink::XRSphericalHarmonicsPtr>::Read(
    ::device::mojom::blink::XRSphericalHarmonics::DataView input,
    ::device::mojom::blink::XRSphericalHarmonicsPtr* output) {
  bool success = true;
  ::device::mojom::blink::XRSphericalHarmonicsPtr result(::device::mojom::blink::XRSphericalHarmonics::New());
  
      if (success && !input.ReadCoefficients(&result->coefficients))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::RgbaTupleF16::DataView, ::device::mojom::blink::RgbaTupleF16Ptr>::Read(
    ::device::mojom::blink::RgbaTupleF16::DataView input,
    ::device::mojom::blink::RgbaTupleF16Ptr* output) {
  bool success = true;
  ::device::mojom::blink::RgbaTupleF16Ptr result(::device::mojom::blink::RgbaTupleF16::New());
  
      if (success)
        result->red = input.red();
      if (success)
        result->green = input.green();
      if (success)
        result->blue = input.blue();
      if (success)
        result->alpha = input.alpha();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::XRCubeMap::DataView, ::device::mojom::blink::XRCubeMapPtr>::Read(
    ::device::mojom::blink::XRCubeMap::DataView input,
    ::device::mojom::blink::XRCubeMapPtr* output) {
  bool success = true;
  ::device::mojom::blink::XRCubeMapPtr result(::device::mojom::blink::XRCubeMap::New());
  
      if (success)
        result->width_and_height = input.width_and_height();
      if (success && !input.ReadPositiveX(&result->positive_x))
        success = false;
      if (success && !input.ReadNegativeX(&result->negative_x))
        success = false;
      if (success && !input.ReadPositiveY(&result->positive_y))
        success = false;
      if (success && !input.ReadNegativeY(&result->negative_y))
        success = false;
      if (success && !input.ReadPositiveZ(&result->positive_z))
        success = false;
      if (success && !input.ReadNegativeZ(&result->negative_z))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::XRLightProbe::DataView, ::device::mojom::blink::XRLightProbePtr>::Read(
    ::device::mojom::blink::XRLightProbe::DataView input,
    ::device::mojom::blink::XRLightProbePtr* output) {
  bool success = true;
  ::device::mojom::blink::XRLightProbePtr result(::device::mojom::blink::XRLightProbe::New());
  
      if (success && !input.ReadSphericalHarmonics(&result->spherical_harmonics))
        success = false;
      if (success && !input.ReadMainLightDirection(&result->main_light_direction))
        success = false;
      if (success && !input.ReadMainLightIntensity(&result->main_light_intensity))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::XRReflectionProbe::DataView, ::device::mojom::blink::XRReflectionProbePtr>::Read(
    ::device::mojom::blink::XRReflectionProbe::DataView input,
    ::device::mojom::blink::XRReflectionProbePtr* output) {
  bool success = true;
  ::device::mojom::blink::XRReflectionProbePtr result(::device::mojom::blink::XRReflectionProbe::New());
  
      if (success && !input.ReadCubeMap(&result->cube_map))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::XRLightEstimationData::DataView, ::device::mojom::blink::XRLightEstimationDataPtr>::Read(
    ::device::mojom::blink::XRLightEstimationData::DataView input,
    ::device::mojom::blink::XRLightEstimationDataPtr* output) {
  bool success = true;
  ::device::mojom::blink::XRLightEstimationDataPtr result(::device::mojom::blink::XRLightEstimationData::New());
  
      if (success && !input.ReadLightProbe(&result->light_probe))
        success = false;
      if (success && !input.ReadReflectionProbe(&result->reflection_probe))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::XRDepthDataStillValid::DataView, ::device::mojom::blink::XRDepthDataStillValidPtr>::Read(
    ::device::mojom::blink::XRDepthDataStillValid::DataView input,
    ::device::mojom::blink::XRDepthDataStillValidPtr* output) {
  bool success = true;
  ::device::mojom::blink::XRDepthDataStillValidPtr result(::device::mojom::blink::XRDepthDataStillValid::New());
  
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::XRDepthDataUpdated::DataView, ::device::mojom::blink::XRDepthDataUpdatedPtr>::Read(
    ::device::mojom::blink::XRDepthDataUpdated::DataView input,
    ::device::mojom::blink::XRDepthDataUpdatedPtr* output) {
  bool success = true;
  ::device::mojom::blink::XRDepthDataUpdatedPtr result(::device::mojom::blink::XRDepthDataUpdated::New());
  
      if (success && !input.ReadPixelData(&result->pixel_data))
        success = false;
      if (success && !input.ReadNormTextureFromNormView(&result->norm_texture_from_norm_view))
        success = false;
      if (success && !input.ReadSize(&result->size))
        success = false;
      if (success)
        result->raw_value_to_meters = input.raw_value_to_meters();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::XRTrackedImageData::DataView, ::device::mojom::blink::XRTrackedImageDataPtr>::Read(
    ::device::mojom::blink::XRTrackedImageData::DataView input,
    ::device::mojom::blink::XRTrackedImageDataPtr* output) {
  bool success = true;
  ::device::mojom::blink::XRTrackedImageDataPtr result(::device::mojom::blink::XRTrackedImageData::New());
  
      if (success)
        result->index = input.index();
      if (success && !input.ReadMojoFromImage(&result->mojo_from_image))
        success = false;
      if (success)
        result->actively_tracked = input.actively_tracked();
      if (success)
        result->width_in_meters = input.width_in_meters();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::XRTrackedImagesData::DataView, ::device::mojom::blink::XRTrackedImagesDataPtr>::Read(
    ::device::mojom::blink::XRTrackedImagesData::DataView input,
    ::device::mojom::blink::XRTrackedImagesDataPtr* output) {
  bool success = true;
  ::device::mojom::blink::XRTrackedImagesDataPtr result(::device::mojom::blink::XRTrackedImagesData::New());
  
      if (success && !input.ReadImagesData(&result->images_data))
        success = false;
      if (success && !input.ReadImageTrackableScores(&result->image_trackable_scores))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::XRFrameData::DataView, ::device::mojom::blink::XRFrameDataPtr>::Read(
    ::device::mojom::blink::XRFrameData::DataView input,
    ::device::mojom::blink::XRFrameDataPtr* output) {
  bool success = true;
  ::device::mojom::blink::XRFrameDataPtr result(::device::mojom::blink::XRFrameData::New());
  
      if (success && !input.ReadMojoFromViewer(&result->mojo_from_viewer))
        success = false;
      if (success && !input.ReadTimeDelta(&result->time_delta))
        success = false;
      if (success && !input.ReadBufferSharedImage(&result->buffer_shared_image))
        success = false;
      if (success && !input.ReadBufferSyncToken(&result->buffer_sync_token))
        success = false;
      if (success && !input.ReadCameraImageBufferSharedImage(&result->camera_image_buffer_shared_image))
        success = false;
      if (success && !input.ReadCameraImageBufferSyncToken(&result->camera_image_buffer_sync_token))
        success = false;
      if (success && !input.ReadCameraImageSize(&result->camera_image_size))
        success = false;
      if (success)
        result->mojo_space_reset = input.mojo_space_reset();
      if (success && !input.ReadMojoFromFloor(&result->mojo_from_floor))
        success = false;
      if (success)
        result->frame_id = input.frame_id();
      if (success && !input.ReadViews(&result->views))
        success = false;
      if (success && !input.ReadInputState(&result->input_state))
        success = false;
      if (success)
        result->stage_parameters_id = input.stage_parameters_id();
      if (success && !input.ReadStageParameters(&result->stage_parameters))
        success = false;
      if (success && !input.ReadDetectedPlanesData(&result->detected_planes_data))
        success = false;
      if (success && !input.ReadAnchorsData(&result->anchors_data))
        success = false;
      if (success && !input.ReadLightEstimationData(&result->light_estimation_data))
        success = false;
      if (success && !input.ReadHitTestSubscriptionResults(&result->hit_test_subscription_results))
        success = false;
      if (success)
        result->rendering_time_ratio = input.rendering_time_ratio();
      if (success && !input.ReadTrackedImages(&result->tracked_images))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::RequestSessionSuccess::DataView, ::device::mojom::blink::RequestSessionSuccessPtr>::Read(
    ::device::mojom::blink::RequestSessionSuccess::DataView input,
    ::device::mojom::blink::RequestSessionSuccessPtr* output) {
  bool success = true;
  ::device::mojom::blink::RequestSessionSuccessPtr result(::device::mojom::blink::RequestSessionSuccess::New());
  
      if (success && !input.ReadSession(&result->session))
        success = false;
      if (success)
        result->trace_id = input.trace_id();
      if (success) {
        result->metrics_recorder =
            input.TakeMetricsRecorder<decltype(result->metrics_recorder)>();
      }
      if (success) {
        result->xr_internals_listener =
            input.TakeXrInternalsListener<decltype(result->xr_internals_listener)>();
      }
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::XRFrameDataRequestOptions::DataView, ::device::mojom::blink::XRFrameDataRequestOptionsPtr>::Read(
    ::device::mojom::blink::XRFrameDataRequestOptions::DataView input,
    ::device::mojom::blink::XRFrameDataRequestOptionsPtr* output) {
  bool success = true;
  ::device::mojom::blink::XRFrameDataRequestOptionsPtr result(::device::mojom::blink::XRFrameDataRequestOptions::New());
  
      if (success)
        result->include_lighting_estimation_data = input.include_lighting_estimation_data();
      if (success)
        result->stage_parameters_id = input.stage_parameters_id();
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::device::mojom::blink::XRNativeOriginInformation::DataView, ::device::mojom::blink::XRNativeOriginInformationPtr>::Read(
    ::device::mojom::blink::XRNativeOriginInformation::DataView input,
    ::device::mojom::blink::XRNativeOriginInformationPtr* output) {
  using UnionType = ::device::mojom::blink::XRNativeOriginInformation;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kInputSourceSpaceInfo: {
      ::device::mojom::blink::XRInputSourceSpaceInfoPtr result_input_source_space_info;
      if (!input.ReadInputSourceSpaceInfo(&result_input_source_space_info))
        return false;

      *output = UnionType::NewInputSourceSpaceInfo(
          std::move(result_input_source_space_info));
      break;
    }
    case Tag::kPlaneId: {
      *output = UnionType::NewPlaneId(input.plane_id());
      break;
    }
    case Tag::kAnchorId: {
      *output = UnionType::NewAnchorId(input.anchor_id());
      break;
    }
    case Tag::kReferenceSpaceType: {
      ::device::mojom::blink::XRReferenceSpaceType result_reference_space_type;
      if (!input.ReadReferenceSpaceType(&result_reference_space_type))
        return false;

      *output = UnionType::NewReferenceSpaceType(result_reference_space_type);
      break;
    }
    case Tag::kHandJointSpaceInfo: {
      ::device::mojom::blink::XRHandJointSpaceInfoPtr result_hand_joint_space_info;
      if (!input.ReadHandJointSpaceInfo(&result_hand_joint_space_info))
        return false;

      *output = UnionType::NewHandJointSpaceInfo(
          std::move(result_hand_joint_space_info));
      break;
    }
    case Tag::kImageIndex: {
      *output = UnionType::NewImageIndex(input.image_index());
      break;
    }
    default:

      return false;
  }
  return true;
}

// static
bool UnionTraits<::device::mojom::blink::XRDepthData::DataView, ::device::mojom::blink::XRDepthDataPtr>::Read(
    ::device::mojom::blink::XRDepthData::DataView input,
    ::device::mojom::blink::XRDepthDataPtr* output) {
  using UnionType = ::device::mojom::blink::XRDepthData;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kDataStillValid: {
      ::device::mojom::blink::XRDepthDataStillValidPtr result_data_still_valid;
      if (!input.ReadDataStillValid(&result_data_still_valid))
        return false;

      *output = UnionType::NewDataStillValid(
          std::move(result_data_still_valid));
      break;
    }
    case Tag::kUpdatedDepthData: {
      ::device::mojom::blink::XRDepthDataUpdatedPtr result_updated_depth_data;
      if (!input.ReadUpdatedDepthData(&result_updated_depth_data))
        return false;

      *output = UnionType::NewUpdatedDepthData(
          std::move(result_updated_depth_data));
      break;
    }
    default:

      return false;
  }
  return true;
}

// static
bool UnionTraits<::device::mojom::blink::RequestSessionResult::DataView, ::device::mojom::blink::RequestSessionResultPtr>::Read(
    ::device::mojom::blink::RequestSessionResult::DataView input,
    ::device::mojom::blink::RequestSessionResultPtr* output) {
  using UnionType = ::device::mojom::blink::RequestSessionResult;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kSuccess: {
      ::device::mojom::blink::RequestSessionSuccessPtr result_success;
      if (!input.ReadSuccess(&result_success))
        return false;

      *output = UnionType::NewSuccess(
          std::move(result_success));
      break;
    }
    case Tag::kFailureReason: {
      ::device::mojom::blink::RequestSessionError result_failure_reason;
      if (!input.ReadFailureReason(&result_failure_reason))
        return false;

      *output = UnionType::NewFailureReason(result_failure_reason);
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace device::mojom::blink {


void VRServiceInterceptorForTesting::SetClient(::mojo::PendingRemote<VRServiceClient> client) {
  GetForwardingInterface()->SetClient(
    std::move(client)
    );
}
void VRServiceInterceptorForTesting::RequestSession(::device::mojom::blink::XRSessionOptionsPtr options, RequestSessionCallback callback) {
  GetForwardingInterface()->RequestSession(
    std::move(options)
    , std::move(callback));
}
void VRServiceInterceptorForTesting::SupportsSession(::device::mojom::blink::XRSessionOptionsPtr options, SupportsSessionCallback callback) {
  GetForwardingInterface()->SupportsSession(
    std::move(options)
    , std::move(callback));
}
void VRServiceInterceptorForTesting::ExitPresent(ExitPresentCallback callback) {
  GetForwardingInterface()->ExitPresent(std::move(callback));
}
void VRServiceInterceptorForTesting::SetFramesThrottled(bool throttled) {
  GetForwardingInterface()->SetFramesThrottled(
    std::move(throttled)
    );
}
void VRServiceInterceptorForTesting::MakeXrCompatible(MakeXrCompatibleCallback callback) {
  GetForwardingInterface()->MakeXrCompatible(std::move(callback));
}
VRServiceAsyncWaiter::VRServiceAsyncWaiter(
    VRService* proxy) : proxy_(proxy) {}

VRServiceAsyncWaiter::~VRServiceAsyncWaiter() = default;

void VRServiceAsyncWaiter::RequestSession(
    ::device::mojom::blink::XRSessionOptionsPtr options, RequestSessionResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->RequestSession(
      std::move(options),
      base::BindOnce(
          [](base::RunLoop* loop,
             RequestSessionResultPtr* out_result
,
             RequestSessionResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

RequestSessionResultPtr VRServiceAsyncWaiter::RequestSession(
    ::device::mojom::blink::XRSessionOptionsPtr options) {
  RequestSessionResultPtr async_wait_result;
  RequestSession(std::move(options),&async_wait_result);
  return async_wait_result;
}

void VRServiceAsyncWaiter::SupportsSession(
    ::device::mojom::blink::XRSessionOptionsPtr options, bool* out_supports_session) {
  base::RunLoop loop;
  proxy_->SupportsSession(
      std::move(options),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_supports_session
,
             bool supports_session) {*out_supports_session = std::move(supports_session);
            loop->Quit();
          },
          &loop,
          out_supports_session));
  loop.Run();
}

bool VRServiceAsyncWaiter::SupportsSession(
    ::device::mojom::blink::XRSessionOptionsPtr options) {
  bool async_wait_result;
  SupportsSession(std::move(options),&async_wait_result);
  return async_wait_result;
}

void VRServiceAsyncWaiter::ExitPresent(
    ) {
  base::RunLoop loop;
  proxy_->ExitPresent(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void VRServiceAsyncWaiter::MakeXrCompatible(
    XrCompatibleResult* out_xr_compatible_result) {
  base::RunLoop loop;
  proxy_->MakeXrCompatible(
      base::BindOnce(
          [](base::RunLoop* loop,
             XrCompatibleResult* out_xr_compatible_result
,
             XrCompatibleResult xr_compatible_result) {*out_xr_compatible_result = std::move(xr_compatible_result);
            loop->Quit();
          },
          &loop,
          out_xr_compatible_result));
  loop.Run();
}

XrCompatibleResult VRServiceAsyncWaiter::MakeXrCompatible(
    ) {
  XrCompatibleResult async_wait_result;
  MakeXrCompatible(&async_wait_result);
  return async_wait_result;
}




void XRSessionMetricsRecorderInterceptorForTesting::ReportFeatureUsed(::device::mojom::blink::XRSessionFeature feature) {
  GetForwardingInterface()->ReportFeatureUsed(
    std::move(feature)
    );
}
XRSessionMetricsRecorderAsyncWaiter::XRSessionMetricsRecorderAsyncWaiter(
    XRSessionMetricsRecorder* proxy) : proxy_(proxy) {}

XRSessionMetricsRecorderAsyncWaiter::~XRSessionMetricsRecorderAsyncWaiter() = default;




void VRServiceClientInterceptorForTesting::OnDeviceChanged() {
  GetForwardingInterface()->OnDeviceChanged();
}
VRServiceClientAsyncWaiter::VRServiceClientAsyncWaiter(
    VRServiceClient* proxy) : proxy_(proxy) {}

VRServiceClientAsyncWaiter::~VRServiceClientAsyncWaiter() = default;




void XREnvironmentIntegrationProviderInterceptorForTesting::SubscribeToHitTest(XRNativeOriginInformationPtr native_origin_information, const WTF::Vector<EntityTypeForHitTest>& entity_types, XRRayPtr ray, SubscribeToHitTestCallback callback) {
  GetForwardingInterface()->SubscribeToHitTest(
    std::move(native_origin_information)
    , 
    std::move(entity_types)
    , 
    std::move(ray)
    , std::move(callback));
}
void XREnvironmentIntegrationProviderInterceptorForTesting::SubscribeToHitTestForTransientInput(const WTF::String& profile_name, const WTF::Vector<EntityTypeForHitTest>& entity_types, XRRayPtr ray, SubscribeToHitTestForTransientInputCallback callback) {
  GetForwardingInterface()->SubscribeToHitTestForTransientInput(
    std::move(profile_name)
    , 
    std::move(entity_types)
    , 
    std::move(ray)
    , std::move(callback));
}
void XREnvironmentIntegrationProviderInterceptorForTesting::UnsubscribeFromHitTest(uint64_t subscription_id) {
  GetForwardingInterface()->UnsubscribeFromHitTest(
    std::move(subscription_id)
    );
}
void XREnvironmentIntegrationProviderInterceptorForTesting::CreateAnchor(XRNativeOriginInformationPtr native_origin_information, const ::device::Pose& native_origin_from_anchor, CreateAnchorCallback callback) {
  GetForwardingInterface()->CreateAnchor(
    std::move(native_origin_information)
    , 
    std::move(native_origin_from_anchor)
    , std::move(callback));
}
void XREnvironmentIntegrationProviderInterceptorForTesting::CreatePlaneAnchor(XRNativeOriginInformationPtr native_origin_information, const ::device::Pose& native_origin_from_anchor, uint64_t plane_id, CreatePlaneAnchorCallback callback) {
  GetForwardingInterface()->CreatePlaneAnchor(
    std::move(native_origin_information)
    , 
    std::move(native_origin_from_anchor)
    , 
    std::move(plane_id)
    , std::move(callback));
}
void XREnvironmentIntegrationProviderInterceptorForTesting::DetachAnchor(uint64_t anchor_id) {
  GetForwardingInterface()->DetachAnchor(
    std::move(anchor_id)
    );
}
XREnvironmentIntegrationProviderAsyncWaiter::XREnvironmentIntegrationProviderAsyncWaiter(
    XREnvironmentIntegrationProvider* proxy) : proxy_(proxy) {}

XREnvironmentIntegrationProviderAsyncWaiter::~XREnvironmentIntegrationProviderAsyncWaiter() = default;

void XREnvironmentIntegrationProviderAsyncWaiter::SubscribeToHitTest(
    XRNativeOriginInformationPtr native_origin_information, const WTF::Vector<EntityTypeForHitTest>& entity_types, XRRayPtr ray, SubscribeToHitTestResult* out_result, uint64_t* out_subscription_id) {
  base::RunLoop loop;
  proxy_->SubscribeToHitTest(
      std::move(native_origin_information),
      std::move(entity_types),
      std::move(ray),
      base::BindOnce(
          [](base::RunLoop* loop,
             SubscribeToHitTestResult* out_result
,
             uint64_t* out_subscription_id
,
             SubscribeToHitTestResult result,
             uint64_t subscription_id) {*out_result = std::move(result);*out_subscription_id = std::move(subscription_id);
            loop->Quit();
          },
          &loop,
          out_result,
          out_subscription_id));
  loop.Run();
}



void XREnvironmentIntegrationProviderAsyncWaiter::SubscribeToHitTestForTransientInput(
    const WTF::String& profile_name, const WTF::Vector<EntityTypeForHitTest>& entity_types, XRRayPtr ray, SubscribeToHitTestResult* out_result, uint64_t* out_subscription_id) {
  base::RunLoop loop;
  proxy_->SubscribeToHitTestForTransientInput(
      std::move(profile_name),
      std::move(entity_types),
      std::move(ray),
      base::BindOnce(
          [](base::RunLoop* loop,
             SubscribeToHitTestResult* out_result
,
             uint64_t* out_subscription_id
,
             SubscribeToHitTestResult result,
             uint64_t subscription_id) {*out_result = std::move(result);*out_subscription_id = std::move(subscription_id);
            loop->Quit();
          },
          &loop,
          out_result,
          out_subscription_id));
  loop.Run();
}



void XREnvironmentIntegrationProviderAsyncWaiter::CreateAnchor(
    XRNativeOriginInformationPtr native_origin_information, const ::device::Pose& native_origin_from_anchor, CreateAnchorResult* out_result, uint64_t* out_anchor_id) {
  base::RunLoop loop;
  proxy_->CreateAnchor(
      std::move(native_origin_information),
      std::move(native_origin_from_anchor),
      base::BindOnce(
          [](base::RunLoop* loop,
             CreateAnchorResult* out_result
,
             uint64_t* out_anchor_id
,
             CreateAnchorResult result,
             uint64_t anchor_id) {*out_result = std::move(result);*out_anchor_id = std::move(anchor_id);
            loop->Quit();
          },
          &loop,
          out_result,
          out_anchor_id));
  loop.Run();
}



void XREnvironmentIntegrationProviderAsyncWaiter::CreatePlaneAnchor(
    XRNativeOriginInformationPtr native_origin_information, const ::device::Pose& native_origin_from_anchor, uint64_t plane_id, CreateAnchorResult* out_result, uint64_t* out_anchor_id) {
  base::RunLoop loop;
  proxy_->CreatePlaneAnchor(
      std::move(native_origin_information),
      std::move(native_origin_from_anchor),
      std::move(plane_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             CreateAnchorResult* out_result
,
             uint64_t* out_anchor_id
,
             CreateAnchorResult result,
             uint64_t anchor_id) {*out_result = std::move(result);*out_anchor_id = std::move(anchor_id);
            loop->Quit();
          },
          &loop,
          out_result,
          out_anchor_id));
  loop.Run();
}






void XRFrameDataProviderInterceptorForTesting::GetFrameData(XRFrameDataRequestOptionsPtr options, GetFrameDataCallback callback) {
  GetForwardingInterface()->GetFrameData(
    std::move(options)
    , std::move(callback));
}
void XRFrameDataProviderInterceptorForTesting::GetEnvironmentIntegrationProvider(::mojo::PendingAssociatedReceiver<XREnvironmentIntegrationProvider> environment_provider) {
  GetForwardingInterface()->GetEnvironmentIntegrationProvider(
    std::move(environment_provider)
    );
}
XRFrameDataProviderAsyncWaiter::XRFrameDataProviderAsyncWaiter(
    XRFrameDataProvider* proxy) : proxy_(proxy) {}

XRFrameDataProviderAsyncWaiter::~XRFrameDataProviderAsyncWaiter() = default;

void XRFrameDataProviderAsyncWaiter::GetFrameData(
    XRFrameDataRequestOptionsPtr options, XRFrameDataPtr* out_frame_data) {
  base::RunLoop loop;
  proxy_->GetFrameData(
      std::move(options),
      base::BindOnce(
          [](base::RunLoop* loop,
             XRFrameDataPtr* out_frame_data
,
             XRFrameDataPtr frame_data) {*out_frame_data = std::move(frame_data);
            loop->Quit();
          },
          &loop,
          out_frame_data));
  loop.Run();
}

XRFrameDataPtr XRFrameDataProviderAsyncWaiter::GetFrameData(
    XRFrameDataRequestOptionsPtr options) {
  XRFrameDataPtr async_wait_result;
  GetFrameData(std::move(options),&async_wait_result);
  return async_wait_result;
}




void XRPresentationProviderInterceptorForTesting::UpdateLayerBounds(int16_t frame_id, const ::gfx::RectF& left_bounds, const ::gfx::RectF& right_bounds, const ::gfx::Size& source_size) {
  GetForwardingInterface()->UpdateLayerBounds(
    std::move(frame_id)
    , 
    std::move(left_bounds)
    , 
    std::move(right_bounds)
    , 
    std::move(source_size)
    );
}
void XRPresentationProviderInterceptorForTesting::SubmitFrameMissing(int16_t frame_id, const ::gpu::SyncToken& sync_token) {
  GetForwardingInterface()->SubmitFrameMissing(
    std::move(frame_id)
    , 
    std::move(sync_token)
    );
}
void XRPresentationProviderInterceptorForTesting::SubmitFrame(int16_t frame_id, const ::gpu::MailboxHolder& mailbox_holder, ::base::TimeDelta time_waited) {
  GetForwardingInterface()->SubmitFrame(
    std::move(frame_id)
    , 
    std::move(mailbox_holder)
    , 
    std::move(time_waited)
    );
}
void XRPresentationProviderInterceptorForTesting::SubmitFrameDrawnIntoTexture(int16_t frameId, const ::gpu::SyncToken& sync_token, ::base::TimeDelta time_waited) {
  GetForwardingInterface()->SubmitFrameDrawnIntoTexture(
    std::move(frameId)
    , 
    std::move(sync_token)
    , 
    std::move(time_waited)
    );
}
XRPresentationProviderAsyncWaiter::XRPresentationProviderAsyncWaiter(
    XRPresentationProvider* proxy) : proxy_(proxy) {}

XRPresentationProviderAsyncWaiter::~XRPresentationProviderAsyncWaiter() = default;




void XRPresentationClientInterceptorForTesting::OnSubmitFrameTransferred(bool success) {
  GetForwardingInterface()->OnSubmitFrameTransferred(
    std::move(success)
    );
}
void XRPresentationClientInterceptorForTesting::OnSubmitFrameRendered() {
  GetForwardingInterface()->OnSubmitFrameRendered();
}
void XRPresentationClientInterceptorForTesting::OnSubmitFrameGpuFence(::gfx::GpuFenceHandle gpu_fence_handle) {
  GetForwardingInterface()->OnSubmitFrameGpuFence(
    std::move(gpu_fence_handle)
    );
}
XRPresentationClientAsyncWaiter::XRPresentationClientAsyncWaiter(
    XRPresentationClient* proxy) : proxy_(proxy) {}

XRPresentationClientAsyncWaiter::~XRPresentationClientAsyncWaiter() = default;




void XRSessionClientInterceptorForTesting::OnExitPresent() {
  GetForwardingInterface()->OnExitPresent();
}
void XRSessionClientInterceptorForTesting::OnVisibilityStateChanged(XRVisibilityState visibility_state) {
  GetForwardingInterface()->OnVisibilityStateChanged(
    std::move(visibility_state)
    );
}
XRSessionClientAsyncWaiter::XRSessionClientAsyncWaiter(
    XRSessionClient* proxy) : proxy_(proxy) {}

XRSessionClientAsyncWaiter::~XRSessionClientAsyncWaiter() = default;




void WebXrInternalsRendererListenerInterceptorForTesting::OnFrameData(::device::mojom::blink::XrFrameStatisticsPtr xrframe_statistics) {
  GetForwardingInterface()->OnFrameData(
    std::move(xrframe_statistics)
    );
}
void WebXrInternalsRendererListenerInterceptorForTesting::OnConsoleLog(::device::mojom::blink::XrLogMessagePtr xrlogging_statistics) {
  GetForwardingInterface()->OnConsoleLog(
    std::move(xrlogging_statistics)
    );
}
WebXrInternalsRendererListenerAsyncWaiter::WebXrInternalsRendererListenerAsyncWaiter(
    WebXrInternalsRendererListener* proxy) : proxy_(proxy) {}

WebXrInternalsRendererListenerAsyncWaiter::~WebXrInternalsRendererListenerAsyncWaiter() = default;






}  // device::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif