// content/services/auction_worklet/public/mojom/trusted_signals_cache.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_SERVICES_AUCTION_WORKLET_PUBLIC_MOJOM_TRUSTED_SIGNALS_CACHE_MOJOM_H_
#define CONTENT_SERVICES_AUCTION_WORKLET_PUBLIC_MOJOM_TRUSTED_SIGNALS_CACHE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "content/services/auction_worklet/public/mojom/trusted_signals_cache.mojom-features.h"  // IWYU pragma: export
#include "content/services/auction_worklet/public/mojom/trusted_signals_cache.mojom-shared.h"  // IWYU pragma: export
#include "content/services/auction_worklet/public/mojom/trusted_signals_cache.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/big_buffer.mojom.h"
#include "mojo/public/mojom/base/unguessable_token.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "content/common/content_export.h"




namespace auction_worklet::mojom {

class TrustedSignalsCacheClientProxy;

template <typename ImplRefTraits>
class TrustedSignalsCacheClientStub;

class TrustedSignalsCacheClientRequestValidator;


class CONTENT_EXPORT TrustedSignalsCacheClient
    : public TrustedSignalsCacheClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = TrustedSignalsCacheClientInterfaceBase;
  using Proxy_ = TrustedSignalsCacheClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = TrustedSignalsCacheClientStub<ImplRefTraits>;

  using RequestValidator_ = TrustedSignalsCacheClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnSuccessMinVersion = 0,
    kOnErrorMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnSuccess_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnError_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~TrustedSignalsCacheClient() = default;

  
  virtual void OnSuccess(TrustedSignalsCompressionScheme compression_scheme, ::mojo_base::BigBuffer compression_group_data) = 0;

  
  virtual void OnError(const std::string& error_message) = 0;
};

class TrustedSignalsCacheProxy;

template <typename ImplRefTraits>
class TrustedSignalsCacheStub;

class TrustedSignalsCacheRequestValidator;


class CONTENT_EXPORT TrustedSignalsCache
    : public TrustedSignalsCacheInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = TrustedSignalsCacheInterfaceBase;
  using Proxy_ = TrustedSignalsCacheProxy;

  template <typename ImplRefTraits>
  using Stub_ = TrustedSignalsCacheStub<ImplRefTraits>;

  using RequestValidator_ = TrustedSignalsCacheRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kGetTrustedSignalsMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetTrustedSignals_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~TrustedSignalsCache() = default;

  
  virtual void GetTrustedSignals(const ::base::UnguessableToken& compression_group_token, ::mojo::PendingRemote<TrustedSignalsCacheClient> client) = 0;
};



class CONTENT_EXPORT TrustedSignalsCacheClientProxy
    : public TrustedSignalsCacheClient {
 public:
  using InterfaceType = TrustedSignalsCacheClient;

  explicit TrustedSignalsCacheClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnSuccess(TrustedSignalsCompressionScheme compression_scheme, ::mojo_base::BigBuffer compression_group_data) final;
  
  void OnError(const std::string& error_message) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class CONTENT_EXPORT TrustedSignalsCacheProxy
    : public TrustedSignalsCache {
 public:
  using InterfaceType = TrustedSignalsCache;

  explicit TrustedSignalsCacheProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetTrustedSignals(const ::base::UnguessableToken& compression_group_token, ::mojo::PendingRemote<TrustedSignalsCacheClient> client) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class CONTENT_EXPORT TrustedSignalsCacheClientStubDispatch {
 public:
  static bool Accept(TrustedSignalsCacheClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      TrustedSignalsCacheClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<TrustedSignalsCacheClient>>
class TrustedSignalsCacheClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  TrustedSignalsCacheClientStub() = default;
  ~TrustedSignalsCacheClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return TrustedSignalsCacheClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return TrustedSignalsCacheClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class CONTENT_EXPORT TrustedSignalsCacheStubDispatch {
 public:
  static bool Accept(TrustedSignalsCache* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      TrustedSignalsCache* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<TrustedSignalsCache>>
class TrustedSignalsCacheStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  TrustedSignalsCacheStub() = default;
  ~TrustedSignalsCacheStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return TrustedSignalsCacheStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return TrustedSignalsCacheStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class CONTENT_EXPORT TrustedSignalsCacheClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class CONTENT_EXPORT TrustedSignalsCacheRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class CONTENT_EXPORT TrustedSignalsCacheKey {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TrustedSignalsCacheKey, T>::value>;
  using DataView = TrustedSignalsCacheKeyDataView;
  using Data_ = internal::TrustedSignalsCacheKey_Data;

  template <typename... Args>
  static TrustedSignalsCacheKeyPtr New(Args&&... args) {
    return TrustedSignalsCacheKeyPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TrustedSignalsCacheKeyPtr From(const U& u) {
    return mojo::TypeConverter<TrustedSignalsCacheKeyPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TrustedSignalsCacheKey>::Convert(*this);
  }


  TrustedSignalsCacheKey();

  TrustedSignalsCacheKey(
      const ::base::UnguessableToken& compression_group_token,
      int32_t partition_id);


  ~TrustedSignalsCacheKey();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TrustedSignalsCacheKeyPtr>
  TrustedSignalsCacheKeyPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TrustedSignalsCacheKey::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, TrustedSignalsCacheKey::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, TrustedSignalsCacheKey::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TrustedSignalsCacheKey::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TrustedSignalsCacheKey::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TrustedSignalsCacheKey_UnserializedMessageContext<
            UserType, TrustedSignalsCacheKey::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<TrustedSignalsCacheKey::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return TrustedSignalsCacheKey::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TrustedSignalsCacheKey_UnserializedMessageContext<
            UserType, TrustedSignalsCacheKey::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TrustedSignalsCacheKey::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::UnguessableToken compression_group_token;
  
  int32_t partition_id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TrustedSignalsCacheKey::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TrustedSignalsCacheKey::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TrustedSignalsCacheKey::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TrustedSignalsCacheKey::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
TrustedSignalsCacheKeyPtr TrustedSignalsCacheKey::Clone() const {
  return New(
      mojo::Clone(compression_group_token),
      mojo::Clone(partition_id)
  );
}

template <typename T, TrustedSignalsCacheKey::EnableIfSame<T>*>
bool TrustedSignalsCacheKey::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->compression_group_token, other_struct.compression_group_token))
    return false;
  if (!mojo::Equals(this->partition_id, other_struct.partition_id))
    return false;
  return true;
}

template <typename T, TrustedSignalsCacheKey::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.compression_group_token < rhs.compression_group_token)
    return true;
  if (rhs.compression_group_token < lhs.compression_group_token)
    return false;
  if (lhs.partition_id < rhs.partition_id)
    return true;
  if (rhs.partition_id < lhs.partition_id)
    return false;
  return false;
}


}  // auction_worklet::mojom

namespace mojo {


template <>
struct CONTENT_EXPORT StructTraits<::auction_worklet::mojom::TrustedSignalsCacheKey::DataView,
                                         ::auction_worklet::mojom::TrustedSignalsCacheKeyPtr> {
  static bool IsNull(const ::auction_worklet::mojom::TrustedSignalsCacheKeyPtr& input) { return !input; }
  static void SetToNull(::auction_worklet::mojom::TrustedSignalsCacheKeyPtr* output) { output->reset(); }

  static const decltype(::auction_worklet::mojom::TrustedSignalsCacheKey::compression_group_token)& compression_group_token(
      const ::auction_worklet::mojom::TrustedSignalsCacheKeyPtr& input) {
    return input->compression_group_token;
  }

  static decltype(::auction_worklet::mojom::TrustedSignalsCacheKey::partition_id) partition_id(
      const ::auction_worklet::mojom::TrustedSignalsCacheKeyPtr& input) {
    return input->partition_id;
  }

  static bool Read(::auction_worklet::mojom::TrustedSignalsCacheKey::DataView input, ::auction_worklet::mojom::TrustedSignalsCacheKeyPtr* output);
};

}  // namespace mojo

#endif  // CONTENT_SERVICES_AUCTION_WORKLET_PUBLIC_MOJOM_TRUSTED_SIGNALS_CACHE_MOJOM_H_