// content/services/auction_worklet/public/mojom/private_aggregation_request.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "content/services/auction_worklet/public/mojom/private_aggregation_request.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "content/services/auction_worklet/public/mojom/private_aggregation_request.mojom-params-data.h"
#include "content/services/auction_worklet/public/mojom/private_aggregation_request.mojom-shared-message-ids.h"

#include "content/services/auction_worklet/public/mojom/private_aggregation_request.mojom-import-headers.h"
#include "content/services/auction_worklet/public/mojom/private_aggregation_request.mojom-test-utils.h"


namespace auction_worklet::mojom {
BucketOffset::BucketOffset()
    : value(),
      is_negative() {}

BucketOffset::BucketOffset(
    const ::absl::uint128& value_in,
    bool is_negative_in)
    : value(std::move(value_in)),
      is_negative(std::move(is_negative_in)) {}

BucketOffset::~BucketOffset() = default;

void BucketOffset::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "value"), this->value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::absl::uint128&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_negative"), this->is_negative,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool BucketOffset::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SignalBucket::SignalBucket()
    : base_value(),
      scale(1.0),
      offset() {}

SignalBucket::SignalBucket(
    BaseValue base_value_in,
    double scale_in,
    BucketOffsetPtr offset_in)
    : base_value(std::move(base_value_in)),
      scale(std::move(scale_in)),
      offset(std::move(offset_in)) {}

SignalBucket::~SignalBucket() = default;

void SignalBucket::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "base_value"), this->base_value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type BaseValue>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scale"), this->scale,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "offset"), this->offset,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type BucketOffsetPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SignalBucket::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SignalValue::SignalValue()
    : base_value(),
      scale(1.0),
      offset(0) {}

SignalValue::SignalValue(
    BaseValue base_value_in,
    double scale_in,
    int32_t offset_in)
    : base_value(std::move(base_value_in)),
      scale(std::move(scale_in)),
      offset(std::move(offset_in)) {}

SignalValue::~SignalValue() = default;
size_t SignalValue::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->base_value);
  seed = mojo::internal::Hash(seed, this->scale);
  seed = mojo::internal::Hash(seed, this->offset);
  return seed;
}

void SignalValue::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "base_value"), this->base_value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type BaseValue>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scale"), this->scale,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "offset"), this->offset,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SignalValue::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AggregatableReportForEventContribution::AggregatableReportForEventContribution()
    : bucket(),
      value(),
      filtering_id(),
      event_type() {}

AggregatableReportForEventContribution::AggregatableReportForEventContribution(
    ForEventSignalBucketPtr bucket_in,
    ForEventSignalValuePtr value_in,
    std::optional<uint64_t> filtering_id_in,
    EventTypePtr event_type_in)
    : bucket(std::move(bucket_in)),
      value(std::move(value_in)),
      filtering_id(std::move(filtering_id_in)),
      event_type(std::move(event_type_in)) {}

AggregatableReportForEventContribution::~AggregatableReportForEventContribution() = default;

void AggregatableReportForEventContribution::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bucket"), this->bucket,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ForEventSignalBucketPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "value"), this->value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ForEventSignalValuePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "filtering_id"), this->filtering_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<uint64_t>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "event_type"), this->event_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type EventTypePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AggregatableReportForEventContribution::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PrivateAggregationRequest::PrivateAggregationRequest()
    : contribution(),
      aggregation_mode(),
      debug_mode_details() {}

PrivateAggregationRequest::PrivateAggregationRequest(
    AggregatableReportContributionPtr contribution_in,
    ::blink::mojom::AggregationServiceMode aggregation_mode_in,
    ::blink::mojom::DebugModeDetailsPtr debug_mode_details_in)
    : contribution(std::move(contribution_in)),
      aggregation_mode(std::move(aggregation_mode_in)),
      debug_mode_details(std::move(debug_mode_details_in)) {}

PrivateAggregationRequest::~PrivateAggregationRequest() = default;

void PrivateAggregationRequest::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "contribution"), this->contribution,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AggregatableReportContributionPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "aggregation_mode"), this->aggregation_mode,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::AggregationServiceMode>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "debug_mode_details"), this->debug_mode_details,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::DebugModeDetailsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PrivateAggregationRequest::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ForEventSignalBucket::ForEventSignalBucket() : tag_(Tag::kIdBucket) {
  data_.id_bucket = new ::absl::uint128;
}

ForEventSignalBucket::~ForEventSignalBucket() {
  DestroyActive();
}


void ForEventSignalBucket::set_id_bucket(
    const ::absl::uint128& id_bucket) {
  if (tag_ == Tag::kIdBucket) {
    *(data_.id_bucket) = std::move(id_bucket);
  } else {
    DestroyActive();
    tag_ = Tag::kIdBucket;
    data_.id_bucket = new ::absl::uint128(
        std::move(id_bucket));
  }
}
void ForEventSignalBucket::set_signal_bucket(
    SignalBucketPtr signal_bucket) {
  if (tag_ == Tag::kSignalBucket) {
    *(data_.signal_bucket) = std::move(signal_bucket);
  } else {
    DestroyActive();
    tag_ = Tag::kSignalBucket;
    data_.signal_bucket = new SignalBucketPtr(
        std::move(signal_bucket));
  }
}

void ForEventSignalBucket::DestroyActive() {
  switch (tag_) {

    case Tag::kIdBucket:

      delete data_.id_bucket;
      break;
    case Tag::kSignalBucket:

      delete data_.signal_bucket;
      break;
  }
}

bool ForEventSignalBucket::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
ForEventSignalValue::ForEventSignalValue() : tag_(Tag::kIntValue) {
  data_.int_value = int32_t();
}

ForEventSignalValue::~ForEventSignalValue() {
  DestroyActive();
}


void ForEventSignalValue::set_int_value(
    int32_t int_value) {
  if (tag_ != Tag::kIntValue) {
    DestroyActive();
    tag_ = Tag::kIntValue;
  }
  data_.int_value = int_value;
}
void ForEventSignalValue::set_signal_value(
    SignalValuePtr signal_value) {
  if (tag_ == Tag::kSignalValue) {
    *(data_.signal_value) = std::move(signal_value);
  } else {
    DestroyActive();
    tag_ = Tag::kSignalValue;
    data_.signal_value = new SignalValuePtr(
        std::move(signal_value));
  }
}

void ForEventSignalValue::DestroyActive() {
  switch (tag_) {

    case Tag::kIntValue:

      break;
    case Tag::kSignalValue:

      delete data_.signal_value;
      break;
  }
}
size_t ForEventSignalValue::Hash(size_t seed) const {
  seed = mojo::internal::HashCombine(seed, static_cast<uint32_t>(tag_));
  switch (tag_) {

    case Tag::kIntValue:
      return mojo::internal::Hash(seed, data_.int_value);
    case Tag::kSignalValue:
      return mojo::internal::Hash(seed, *data_.signal_value);
    default:
      NOTREACHED();
  }
}

bool ForEventSignalValue::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
EventType::EventType() : tag_(Tag::kReserved) {
  data_.reserved = ReservedEventType();
}

EventType::~EventType() {
  DestroyActive();
}


void EventType::set_reserved(
    ReservedEventType reserved) {
  if (tag_ != Tag::kReserved) {
    DestroyActive();
    tag_ = Tag::kReserved;
  }
  data_.reserved = reserved;
}
void EventType::set_non_reserved(
    const std::string& non_reserved) {
  if (tag_ == Tag::kNonReserved) {
    *(data_.non_reserved) = std::move(non_reserved);
  } else {
    DestroyActive();
    tag_ = Tag::kNonReserved;
    data_.non_reserved = new std::string(
        std::move(non_reserved));
  }
}

void EventType::DestroyActive() {
  switch (tag_) {

    case Tag::kReserved:

      break;
    case Tag::kNonReserved:

      delete data_.non_reserved;
      break;
  }
}
size_t EventType::Hash(size_t seed) const {
  seed = mojo::internal::HashCombine(seed, static_cast<uint32_t>(tag_));
  switch (tag_) {

    case Tag::kReserved:
      return mojo::internal::Hash(seed, data_.reserved);
    case Tag::kNonReserved:
      return mojo::internal::Hash(seed, *data_.non_reserved);
    default:
      NOTREACHED();
  }
}

bool EventType::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
AggregatableReportContribution::AggregatableReportContribution() : tag_(Tag::kHistogramContribution) {
  data_.histogram_contribution = new ::blink::mojom::AggregatableReportHistogramContributionPtr;
}

AggregatableReportContribution::~AggregatableReportContribution() {
  DestroyActive();
}


void AggregatableReportContribution::set_histogram_contribution(
    ::blink::mojom::AggregatableReportHistogramContributionPtr histogram_contribution) {
  if (tag_ == Tag::kHistogramContribution) {
    *(data_.histogram_contribution) = std::move(histogram_contribution);
  } else {
    DestroyActive();
    tag_ = Tag::kHistogramContribution;
    data_.histogram_contribution = new ::blink::mojom::AggregatableReportHistogramContributionPtr(
        std::move(histogram_contribution));
  }
}
void AggregatableReportContribution::set_for_event_contribution(
    AggregatableReportForEventContributionPtr for_event_contribution) {
  if (tag_ == Tag::kForEventContribution) {
    *(data_.for_event_contribution) = std::move(for_event_contribution);
  } else {
    DestroyActive();
    tag_ = Tag::kForEventContribution;
    data_.for_event_contribution = new AggregatableReportForEventContributionPtr(
        std::move(for_event_contribution));
  }
}

void AggregatableReportContribution::DestroyActive() {
  switch (tag_) {

    case Tag::kHistogramContribution:

      delete data_.histogram_contribution;
      break;
    case Tag::kForEventContribution:

      delete data_.for_event_contribution;
      break;
  }
}

bool AggregatableReportContribution::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}


}  // auction_worklet::mojom


namespace mojo {


// static
bool StructTraits<::auction_worklet::mojom::BucketOffset::DataView, ::auction_worklet::mojom::BucketOffsetPtr>::Read(
    ::auction_worklet::mojom::BucketOffset::DataView input,
    ::auction_worklet::mojom::BucketOffsetPtr* output) {
  bool success = true;
  ::auction_worklet::mojom::BucketOffsetPtr result(::auction_worklet::mojom::BucketOffset::New());
  
      if (success && !input.ReadValue(&result->value))
        success = false;
      if (success)
        result->is_negative = input.is_negative();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::auction_worklet::mojom::SignalBucket::DataView, ::auction_worklet::mojom::SignalBucketPtr>::Read(
    ::auction_worklet::mojom::SignalBucket::DataView input,
    ::auction_worklet::mojom::SignalBucketPtr* output) {
  bool success = true;
  ::auction_worklet::mojom::SignalBucketPtr result(::auction_worklet::mojom::SignalBucket::New());
  
      if (success && !input.ReadBaseValue(&result->base_value))
        success = false;
      if (success)
        result->scale = input.scale();
      if (success && !input.ReadOffset(&result->offset))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::auction_worklet::mojom::SignalValue::DataView, ::auction_worklet::mojom::SignalValuePtr>::Read(
    ::auction_worklet::mojom::SignalValue::DataView input,
    ::auction_worklet::mojom::SignalValuePtr* output) {
  bool success = true;
  ::auction_worklet::mojom::SignalValuePtr result(::auction_worklet::mojom::SignalValue::New());
  
      if (success && !input.ReadBaseValue(&result->base_value))
        success = false;
      if (success)
        result->scale = input.scale();
      if (success)
        result->offset = input.offset();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::auction_worklet::mojom::AggregatableReportForEventContribution::DataView, ::auction_worklet::mojom::AggregatableReportForEventContributionPtr>::Read(
    ::auction_worklet::mojom::AggregatableReportForEventContribution::DataView input,
    ::auction_worklet::mojom::AggregatableReportForEventContributionPtr* output) {
  bool success = true;
  ::auction_worklet::mojom::AggregatableReportForEventContributionPtr result(::auction_worklet::mojom::AggregatableReportForEventContribution::New());
  
      if (success && !input.ReadBucket(&result->bucket))
        success = false;
      if (success && !input.ReadValue(&result->value))
        success = false;
      if (success) {
        result->filtering_id = input.filtering_id();
      }
      if (success && !input.ReadEventType(&result->event_type))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::auction_worklet::mojom::PrivateAggregationRequest::DataView, ::auction_worklet::mojom::PrivateAggregationRequestPtr>::Read(
    ::auction_worklet::mojom::PrivateAggregationRequest::DataView input,
    ::auction_worklet::mojom::PrivateAggregationRequestPtr* output) {
  bool success = true;
  ::auction_worklet::mojom::PrivateAggregationRequestPtr result(::auction_worklet::mojom::PrivateAggregationRequest::New());
  
      if (success && !input.ReadContribution(&result->contribution))
        success = false;
      if (success && !input.ReadAggregationMode(&result->aggregation_mode))
        success = false;
      if (success && !input.ReadDebugModeDetails(&result->debug_mode_details))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::auction_worklet::mojom::ForEventSignalBucket::DataView, ::auction_worklet::mojom::ForEventSignalBucketPtr>::Read(
    ::auction_worklet::mojom::ForEventSignalBucket::DataView input,
    ::auction_worklet::mojom::ForEventSignalBucketPtr* output) {
  using UnionType = ::auction_worklet::mojom::ForEventSignalBucket;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kIdBucket: {
      ::absl::uint128 result_id_bucket;
      if (!input.ReadIdBucket(&result_id_bucket))
        return false;

      *output = UnionType::NewIdBucket(
          std::move(result_id_bucket));
      break;
    }
    case Tag::kSignalBucket: {
      ::auction_worklet::mojom::SignalBucketPtr result_signal_bucket;
      if (!input.ReadSignalBucket(&result_signal_bucket))
        return false;

      *output = UnionType::NewSignalBucket(
          std::move(result_signal_bucket));
      break;
    }
    default:

      return false;
  }
  return true;
}

// static
bool UnionTraits<::auction_worklet::mojom::ForEventSignalValue::DataView, ::auction_worklet::mojom::ForEventSignalValuePtr>::Read(
    ::auction_worklet::mojom::ForEventSignalValue::DataView input,
    ::auction_worklet::mojom::ForEventSignalValuePtr* output) {
  using UnionType = ::auction_worklet::mojom::ForEventSignalValue;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kIntValue: {
      *output = UnionType::NewIntValue(input.int_value());
      break;
    }
    case Tag::kSignalValue: {
      ::auction_worklet::mojom::SignalValuePtr result_signal_value;
      if (!input.ReadSignalValue(&result_signal_value))
        return false;

      *output = UnionType::NewSignalValue(
          std::move(result_signal_value));
      break;
    }
    default:

      return false;
  }
  return true;
}

// static
bool UnionTraits<::auction_worklet::mojom::EventType::DataView, ::auction_worklet::mojom::EventTypePtr>::Read(
    ::auction_worklet::mojom::EventType::DataView input,
    ::auction_worklet::mojom::EventTypePtr* output) {
  using UnionType = ::auction_worklet::mojom::EventType;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kReserved: {
      ::auction_worklet::mojom::ReservedEventType result_reserved;
      if (!input.ReadReserved(&result_reserved))
        return false;

      *output = UnionType::NewReserved(result_reserved);
      break;
    }
    case Tag::kNonReserved: {
      std::string result_non_reserved;
      if (!input.ReadNonReserved(&result_non_reserved))
        return false;

      *output = UnionType::NewNonReserved(
          std::move(result_non_reserved));
      break;
    }
    default:

      return false;
  }
  return true;
}

// static
bool UnionTraits<::auction_worklet::mojom::AggregatableReportContribution::DataView, ::auction_worklet::mojom::AggregatableReportContributionPtr>::Read(
    ::auction_worklet::mojom::AggregatableReportContribution::DataView input,
    ::auction_worklet::mojom::AggregatableReportContributionPtr* output) {
  using UnionType = ::auction_worklet::mojom::AggregatableReportContribution;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kHistogramContribution: {
      ::blink::mojom::AggregatableReportHistogramContributionPtr result_histogram_contribution;
      if (!input.ReadHistogramContribution(&result_histogram_contribution))
        return false;

      *output = UnionType::NewHistogramContribution(
          std::move(result_histogram_contribution));
      break;
    }
    case Tag::kForEventContribution: {
      ::auction_worklet::mojom::AggregatableReportForEventContributionPtr result_for_event_contribution;
      if (!input.ReadForEventContribution(&result_for_event_contribution))
        return false;

      *output = UnionType::NewForEventContribution(
          std::move(result_for_event_contribution));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace auction_worklet::mojom {




}  // auction_worklet::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif