// content/browser/attribution_reporting/attribution_internals.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_BROWSER_ATTRIBUTION_REPORTING_ATTRIBUTION_INTERNALS_MOJOM_PARAMS_DATA_H_
#define CONTENT_BROWSER_ATTRIBUTION_REPORTING_ATTRIBUTION_INTERNALS_MOJOM_PARAMS_DATA_H_

#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace attribution_internals::mojom {
namespace internal {
class  Observer_OnSourcesChanged_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::WebUISource_Data>>> sources;

 private:
  friend class mojo::internal::MessageFragment<Observer_OnSourcesChanged_Params_Data>;

  Observer_OnSourcesChanged_Params_Data();
  ~Observer_OnSourcesChanged_Params_Data() = delete;
};
static_assert(sizeof(Observer_OnSourcesChanged_Params_Data) == 16,
              "Bad sizeof(Observer_OnSourcesChanged_Params_Data)");
class  Observer_OnReportsChanged_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::WebUIReport_Data>>> reports;

 private:
  friend class mojo::internal::MessageFragment<Observer_OnReportsChanged_Params_Data>;

  Observer_OnReportsChanged_Params_Data();
  ~Observer_OnReportsChanged_Params_Data() = delete;
};
static_assert(sizeof(Observer_OnReportsChanged_Params_Data) == 16,
              "Bad sizeof(Observer_OnReportsChanged_Params_Data)");
class  Observer_OnSourceHandled_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::WebUISourceRegistration_Data> source;

 private:
  friend class mojo::internal::MessageFragment<Observer_OnSourceHandled_Params_Data>;

  Observer_OnSourceHandled_Params_Data();
  ~Observer_OnSourceHandled_Params_Data() = delete;
};
static_assert(sizeof(Observer_OnSourceHandled_Params_Data) == 16,
              "Bad sizeof(Observer_OnSourceHandled_Params_Data)");
class  Observer_OnReportHandled_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::WebUIReport_Data> report;

 private:
  friend class mojo::internal::MessageFragment<Observer_OnReportHandled_Params_Data>;

  Observer_OnReportHandled_Params_Data();
  ~Observer_OnReportHandled_Params_Data() = delete;
};
static_assert(sizeof(Observer_OnReportHandled_Params_Data) == 16,
              "Bad sizeof(Observer_OnReportHandled_Params_Data)");
class  Observer_OnDebugReportSent_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::WebUIDebugReport_Data> report;

 private:
  friend class mojo::internal::MessageFragment<Observer_OnDebugReportSent_Params_Data>;

  Observer_OnDebugReportSent_Params_Data();
  ~Observer_OnDebugReportSent_Params_Data() = delete;
};
static_assert(sizeof(Observer_OnDebugReportSent_Params_Data) == 16,
              "Bad sizeof(Observer_OnDebugReportSent_Params_Data)");
class  Observer_OnAggregatableDebugReportSent_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::WebUIAggregatableDebugReport_Data> report;

 private:
  friend class mojo::internal::MessageFragment<Observer_OnAggregatableDebugReportSent_Params_Data>;

  Observer_OnAggregatableDebugReportSent_Params_Data();
  ~Observer_OnAggregatableDebugReportSent_Params_Data() = delete;
};
static_assert(sizeof(Observer_OnAggregatableDebugReportSent_Params_Data) == 16,
              "Bad sizeof(Observer_OnAggregatableDebugReportSent_Params_Data)");
class  Observer_OnTriggerHandled_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::WebUITrigger_Data> trigger;

 private:
  friend class mojo::internal::MessageFragment<Observer_OnTriggerHandled_Params_Data>;

  Observer_OnTriggerHandled_Params_Data();
  ~Observer_OnTriggerHandled_Params_Data() = delete;
};
static_assert(sizeof(Observer_OnTriggerHandled_Params_Data) == 16,
              "Bad sizeof(Observer_OnTriggerHandled_Params_Data)");
class  Observer_OnOsRegistration_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::WebUIOsRegistration_Data> registration;

 private:
  friend class mojo::internal::MessageFragment<Observer_OnOsRegistration_Params_Data>;

  Observer_OnOsRegistration_Params_Data();
  ~Observer_OnOsRegistration_Params_Data() = delete;
};
static_assert(sizeof(Observer_OnOsRegistration_Params_Data) == 16,
              "Bad sizeof(Observer_OnOsRegistration_Params_Data)");
class  Observer_OnDebugModeChanged_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t debug_mode : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<Observer_OnDebugModeChanged_Params_Data>;

  Observer_OnDebugModeChanged_Params_Data();
  ~Observer_OnDebugModeChanged_Params_Data() = delete;
};
static_assert(sizeof(Observer_OnDebugModeChanged_Params_Data) == 16,
              "Bad sizeof(Observer_OnDebugModeChanged_Params_Data)");
class  Handler_IsAttributionReportingEnabled_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<Handler_IsAttributionReportingEnabled_Params_Data>;

  Handler_IsAttributionReportingEnabled_Params_Data();
  ~Handler_IsAttributionReportingEnabled_Params_Data() = delete;
};
static_assert(sizeof(Handler_IsAttributionReportingEnabled_Params_Data) == 8,
              "Bad sizeof(Handler_IsAttributionReportingEnabled_Params_Data)");
class  Handler_IsAttributionReportingEnabled_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t enabled : 1;
  uint8_t pad0_[3];
  int32_t attribution_support;

 private:
  friend class mojo::internal::MessageFragment<Handler_IsAttributionReportingEnabled_ResponseParams_Data>;

  Handler_IsAttributionReportingEnabled_ResponseParams_Data();
  ~Handler_IsAttributionReportingEnabled_ResponseParams_Data() = delete;
};
static_assert(sizeof(Handler_IsAttributionReportingEnabled_ResponseParams_Data) == 16,
              "Bad sizeof(Handler_IsAttributionReportingEnabled_ResponseParams_Data)");
class  Handler_SendReport_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::ReportID_Data> id;

 private:
  friend class mojo::internal::MessageFragment<Handler_SendReport_Params_Data>;

  Handler_SendReport_Params_Data();
  ~Handler_SendReport_Params_Data() = delete;
};
static_assert(sizeof(Handler_SendReport_Params_Data) == 16,
              "Bad sizeof(Handler_SendReport_Params_Data)");
class  Handler_SendReport_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<Handler_SendReport_ResponseParams_Data>;

  Handler_SendReport_ResponseParams_Data();
  ~Handler_SendReport_ResponseParams_Data() = delete;
};
static_assert(sizeof(Handler_SendReport_ResponseParams_Data) == 8,
              "Bad sizeof(Handler_SendReport_ResponseParams_Data)");
class  Handler_ClearStorage_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<Handler_ClearStorage_Params_Data>;

  Handler_ClearStorage_Params_Data();
  ~Handler_ClearStorage_Params_Data() = delete;
};
static_assert(sizeof(Handler_ClearStorage_Params_Data) == 8,
              "Bad sizeof(Handler_ClearStorage_Params_Data)");
class  Handler_ClearStorage_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<Handler_ClearStorage_ResponseParams_Data>;

  Handler_ClearStorage_ResponseParams_Data();
  ~Handler_ClearStorage_ResponseParams_Data() = delete;
};
static_assert(sizeof(Handler_ClearStorage_ResponseParams_Data) == 8,
              "Bad sizeof(Handler_ClearStorage_ResponseParams_Data)");
class  Factory_Create_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Interface_Data observer;
  mojo::internal::Handle_Data handler;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<Factory_Create_Params_Data>;

  Factory_Create_Params_Data();
  ~Factory_Create_Params_Data() = delete;
};
static_assert(sizeof(Factory_Create_Params_Data) == 24,
              "Bad sizeof(Factory_Create_Params_Data)");

}  // namespace internal


class Observer_OnSourcesChanged_ParamsDataView {
 public:
  Observer_OnSourcesChanged_ParamsDataView() = default;

  Observer_OnSourcesChanged_ParamsDataView(
      internal::Observer_OnSourcesChanged_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSourcesDataView(
      mojo::ArrayDataView<WebUISourceDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSources(UserType* output) {
    
    auto* pointer = data_->sources.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::attribution_internals::mojom::WebUISourceDataView>>(
        pointer, output, message_);
  }
 private:
  internal::Observer_OnSourcesChanged_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Observer_OnReportsChanged_ParamsDataView {
 public:
  Observer_OnReportsChanged_ParamsDataView() = default;

  Observer_OnReportsChanged_ParamsDataView(
      internal::Observer_OnReportsChanged_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetReportsDataView(
      mojo::ArrayDataView<WebUIReportDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReports(UserType* output) {
    
    auto* pointer = data_->reports.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::attribution_internals::mojom::WebUIReportDataView>>(
        pointer, output, message_);
  }
 private:
  internal::Observer_OnReportsChanged_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Observer_OnSourceHandled_ParamsDataView {
 public:
  Observer_OnSourceHandled_ParamsDataView() = default;

  Observer_OnSourceHandled_ParamsDataView(
      internal::Observer_OnSourceHandled_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSourceDataView(
      WebUISourceRegistrationDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSource(UserType* output) {
    
    auto* pointer = data_->source.Get();
    return mojo::internal::Deserialize<::attribution_internals::mojom::WebUISourceRegistrationDataView>(
        pointer, output, message_);
  }
 private:
  internal::Observer_OnSourceHandled_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Observer_OnReportHandled_ParamsDataView {
 public:
  Observer_OnReportHandled_ParamsDataView() = default;

  Observer_OnReportHandled_ParamsDataView(
      internal::Observer_OnReportHandled_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetReportDataView(
      WebUIReportDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReport(UserType* output) {
    
    auto* pointer = data_->report.Get();
    return mojo::internal::Deserialize<::attribution_internals::mojom::WebUIReportDataView>(
        pointer, output, message_);
  }
 private:
  internal::Observer_OnReportHandled_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Observer_OnDebugReportSent_ParamsDataView {
 public:
  Observer_OnDebugReportSent_ParamsDataView() = default;

  Observer_OnDebugReportSent_ParamsDataView(
      internal::Observer_OnDebugReportSent_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetReportDataView(
      WebUIDebugReportDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReport(UserType* output) {
    
    auto* pointer = data_->report.Get();
    return mojo::internal::Deserialize<::attribution_internals::mojom::WebUIDebugReportDataView>(
        pointer, output, message_);
  }
 private:
  internal::Observer_OnDebugReportSent_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Observer_OnAggregatableDebugReportSent_ParamsDataView {
 public:
  Observer_OnAggregatableDebugReportSent_ParamsDataView() = default;

  Observer_OnAggregatableDebugReportSent_ParamsDataView(
      internal::Observer_OnAggregatableDebugReportSent_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetReportDataView(
      WebUIAggregatableDebugReportDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReport(UserType* output) {
    
    auto* pointer = data_->report.Get();
    return mojo::internal::Deserialize<::attribution_internals::mojom::WebUIAggregatableDebugReportDataView>(
        pointer, output, message_);
  }
 private:
  internal::Observer_OnAggregatableDebugReportSent_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Observer_OnTriggerHandled_ParamsDataView {
 public:
  Observer_OnTriggerHandled_ParamsDataView() = default;

  Observer_OnTriggerHandled_ParamsDataView(
      internal::Observer_OnTriggerHandled_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTriggerDataView(
      WebUITriggerDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTrigger(UserType* output) {
    
    auto* pointer = data_->trigger.Get();
    return mojo::internal::Deserialize<::attribution_internals::mojom::WebUITriggerDataView>(
        pointer, output, message_);
  }
 private:
  internal::Observer_OnTriggerHandled_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Observer_OnOsRegistration_ParamsDataView {
 public:
  Observer_OnOsRegistration_ParamsDataView() = default;

  Observer_OnOsRegistration_ParamsDataView(
      internal::Observer_OnOsRegistration_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRegistrationDataView(
      WebUIOsRegistrationDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRegistration(UserType* output) {
    
    auto* pointer = data_->registration.Get();
    return mojo::internal::Deserialize<::attribution_internals::mojom::WebUIOsRegistrationDataView>(
        pointer, output, message_);
  }
 private:
  internal::Observer_OnOsRegistration_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Observer_OnDebugModeChanged_ParamsDataView {
 public:
  Observer_OnDebugModeChanged_ParamsDataView() = default;

  Observer_OnDebugModeChanged_ParamsDataView(
      internal::Observer_OnDebugModeChanged_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool debug_mode() const {
    return data_->debug_mode;
  }
 private:
  internal::Observer_OnDebugModeChanged_Params_Data* data_ = nullptr;
};


class Handler_IsAttributionReportingEnabled_ParamsDataView {
 public:
  Handler_IsAttributionReportingEnabled_ParamsDataView() = default;

  Handler_IsAttributionReportingEnabled_ParamsDataView(
      internal::Handler_IsAttributionReportingEnabled_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::Handler_IsAttributionReportingEnabled_Params_Data* data_ = nullptr;
};


class Handler_IsAttributionReportingEnabled_ResponseParamsDataView {
 public:
  Handler_IsAttributionReportingEnabled_ResponseParamsDataView() = default;

  Handler_IsAttributionReportingEnabled_ResponseParamsDataView(
      internal::Handler_IsAttributionReportingEnabled_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool enabled() const {
    return data_->enabled;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadAttributionSupport(UserType* output) const {
    auto data_value = data_->attribution_support;
    return mojo::internal::Deserialize<::network::mojom::AttributionSupport>(
        data_value, output);
  }
  ::network::mojom::AttributionSupport attribution_support() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::AttributionSupport>(data_->attribution_support));
  }
 private:
  internal::Handler_IsAttributionReportingEnabled_ResponseParams_Data* data_ = nullptr;
};


class Handler_SendReport_ParamsDataView {
 public:
  Handler_SendReport_ParamsDataView() = default;

  Handler_SendReport_ParamsDataView(
      internal::Handler_SendReport_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIdDataView(
      ReportIDDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<::attribution_internals::mojom::ReportIDDataView>(
        pointer, output, message_);
  }
 private:
  internal::Handler_SendReport_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Handler_SendReport_ResponseParamsDataView {
 public:
  Handler_SendReport_ResponseParamsDataView() = default;

  Handler_SendReport_ResponseParamsDataView(
      internal::Handler_SendReport_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::Handler_SendReport_ResponseParams_Data* data_ = nullptr;
};


class Handler_ClearStorage_ParamsDataView {
 public:
  Handler_ClearStorage_ParamsDataView() = default;

  Handler_ClearStorage_ParamsDataView(
      internal::Handler_ClearStorage_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::Handler_ClearStorage_Params_Data* data_ = nullptr;
};


class Handler_ClearStorage_ResponseParamsDataView {
 public:
  Handler_ClearStorage_ResponseParamsDataView() = default;

  Handler_ClearStorage_ResponseParamsDataView(
      internal::Handler_ClearStorage_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::Handler_ClearStorage_ResponseParams_Data* data_ = nullptr;
};


class Factory_Create_ParamsDataView {
 public:
  Factory_Create_ParamsDataView() = default;

  Factory_Create_ParamsDataView(
      internal::Factory_Create_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeObserver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::attribution_internals::mojom::ObserverInterfaceBase>>(
            &data_->observer, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeHandler() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::attribution_internals::mojom::HandlerInterfaceBase>>(
            &data_->handler, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::Factory_Create_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};

inline void Observer_OnSourcesChanged_ParamsDataView::GetSourcesDataView(
    mojo::ArrayDataView<WebUISourceDataView>* output) {
  auto pointer = data_->sources.Get();
  *output = mojo::ArrayDataView<WebUISourceDataView>(pointer, message_);
}


inline void Observer_OnReportsChanged_ParamsDataView::GetReportsDataView(
    mojo::ArrayDataView<WebUIReportDataView>* output) {
  auto pointer = data_->reports.Get();
  *output = mojo::ArrayDataView<WebUIReportDataView>(pointer, message_);
}


inline void Observer_OnSourceHandled_ParamsDataView::GetSourceDataView(
    WebUISourceRegistrationDataView* output) {
  auto pointer = data_->source.Get();
  *output = WebUISourceRegistrationDataView(pointer, message_);
}


inline void Observer_OnReportHandled_ParamsDataView::GetReportDataView(
    WebUIReportDataView* output) {
  auto pointer = data_->report.Get();
  *output = WebUIReportDataView(pointer, message_);
}


inline void Observer_OnDebugReportSent_ParamsDataView::GetReportDataView(
    WebUIDebugReportDataView* output) {
  auto pointer = data_->report.Get();
  *output = WebUIDebugReportDataView(pointer, message_);
}


inline void Observer_OnAggregatableDebugReportSent_ParamsDataView::GetReportDataView(
    WebUIAggregatableDebugReportDataView* output) {
  auto pointer = data_->report.Get();
  *output = WebUIAggregatableDebugReportDataView(pointer, message_);
}


inline void Observer_OnTriggerHandled_ParamsDataView::GetTriggerDataView(
    WebUITriggerDataView* output) {
  auto pointer = data_->trigger.Get();
  *output = WebUITriggerDataView(pointer, message_);
}


inline void Observer_OnOsRegistration_ParamsDataView::GetRegistrationDataView(
    WebUIOsRegistrationDataView* output) {
  auto pointer = data_->registration.Get();
  *output = WebUIOsRegistrationDataView(pointer, message_);
}








inline void Handler_SendReport_ParamsDataView::GetIdDataView(
    ReportIDDataView* output) {
  auto pointer = data_->id.Get();
  *output = ReportIDDataView(pointer, message_);
}











}  // attribution_internals::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // CONTENT_BROWSER_ATTRIBUTION_REPORTING_ATTRIBUTION_INTERNALS_MOJOM_PARAMS_DATA_H_