// components/input/render_input_router.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/input/render_input_router.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/input/render_input_router.mojom-params-data.h"
#include "components/input/render_input_router.mojom-shared-message-ids.h"

#include "components/input/render_input_router.mojom-import-headers.h"
#include "components/input/render_input_router.mojom-test-utils.h"


namespace input::mojom {
RenderInputRouterConfig::RenderInputRouterConfig()
    : rir_client(),
      grouping_id(),
      force_enable_zoom(false) {}

RenderInputRouterConfig::RenderInputRouterConfig(
    ::mojo::PendingRemote<::blink::mojom::RenderInputRouterClient> rir_client_in,
    const ::base::UnguessableToken& grouping_id_in,
    bool force_enable_zoom_in)
    : rir_client(std::move(rir_client_in)),
      grouping_id(std::move(grouping_id_in)),
      force_enable_zoom(std::move(force_enable_zoom_in)) {}

RenderInputRouterConfig::~RenderInputRouterConfig() = default;

void RenderInputRouterConfig::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "rir_client"), this->rir_client,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<::blink::mojom::RenderInputRouterClient>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "grouping_id"), this->grouping_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::base::UnguessableToken&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "force_enable_zoom"), this->force_enable_zoom,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool RenderInputRouterConfig::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
TouchTransferState::TouchTransferState()
    : down_time_ms(),
      root_widget_frame_sink_id(),
      raw_y_offset(),
      dip_scale() {}

TouchTransferState::TouchTransferState(
    ::base::TimeTicks down_time_ms_in,
    const ::viz::FrameSinkId& root_widget_frame_sink_id_in,
    int32_t raw_y_offset_in,
    float dip_scale_in)
    : down_time_ms(std::move(down_time_ms_in)),
      root_widget_frame_sink_id(std::move(root_widget_frame_sink_id_in)),
      raw_y_offset(std::move(raw_y_offset_in)),
      dip_scale(std::move(dip_scale_in)) {}

TouchTransferState::~TouchTransferState() = default;

void TouchTransferState::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "down_time_ms"), this->down_time_ms,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeTicks>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "root_widget_frame_sink_id"), this->root_widget_frame_sink_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::viz::FrameSinkId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "raw_y_offset"), this->raw_y_offset,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "dip_scale"), this->dip_scale,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TouchTransferState::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char RenderInputRouterDelegate::Name_[] = "input.mojom.RenderInputRouterDelegate";

RenderInputRouterDelegate::IPCStableHashFunction RenderInputRouterDelegate::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::RenderInputRouterDelegate>(message.name())) {
    case messages::RenderInputRouterDelegate::kStateOnTouchTransfer: {
      return &RenderInputRouterDelegate::StateOnTouchTransfer_Sym::IPCStableHash;
    }
    case messages::RenderInputRouterDelegate::kNotifySiteIsMobileOptimized: {
      return &RenderInputRouterDelegate::NotifySiteIsMobileOptimized_Sym::IPCStableHash;
    }
    case messages::RenderInputRouterDelegate::kForceEnableZoomStateChanged: {
      return &RenderInputRouterDelegate::ForceEnableZoomStateChanged_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* RenderInputRouterDelegate::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::RenderInputRouterDelegate>(message.name())) {
      case messages::RenderInputRouterDelegate::kStateOnTouchTransfer:
            return "Receive input::mojom::RenderInputRouterDelegate::StateOnTouchTransfer";
      case messages::RenderInputRouterDelegate::kNotifySiteIsMobileOptimized:
            return "Receive input::mojom::RenderInputRouterDelegate::NotifySiteIsMobileOptimized";
      case messages::RenderInputRouterDelegate::kForceEnableZoomStateChanged:
            return "Receive input::mojom::RenderInputRouterDelegate::ForceEnableZoomStateChanged";
    }
  } else {
    switch (static_cast<messages::RenderInputRouterDelegate>(message.name())) {
      case messages::RenderInputRouterDelegate::kStateOnTouchTransfer:
            return "Receive reply input::mojom::RenderInputRouterDelegate::StateOnTouchTransfer";
      case messages::RenderInputRouterDelegate::kNotifySiteIsMobileOptimized:
            return "Receive reply input::mojom::RenderInputRouterDelegate::NotifySiteIsMobileOptimized";
      case messages::RenderInputRouterDelegate::kForceEnableZoomStateChanged:
            return "Receive reply input::mojom::RenderInputRouterDelegate::ForceEnableZoomStateChanged";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t RenderInputRouterDelegate::StateOnTouchTransfer_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)input::mojom::RenderInputRouterDelegate::StateOnTouchTransfer");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RenderInputRouterDelegate::NotifySiteIsMobileOptimized_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)input::mojom::RenderInputRouterDelegate::NotifySiteIsMobileOptimized");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RenderInputRouterDelegate::ForceEnableZoomStateChanged_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)input::mojom::RenderInputRouterDelegate::ForceEnableZoomStateChanged");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

RenderInputRouterDelegateProxy::RenderInputRouterDelegateProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void RenderInputRouterDelegateProxy::StateOnTouchTransfer(
    TouchTransferStatePtr in_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send input::mojom::RenderInputRouterDelegate::StateOnTouchTransfer", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("state"), in_state,
                        "<value of type TouchTransferStatePtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderInputRouterDelegate::kStateOnTouchTransfer), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::input::mojom::internal::RenderInputRouterDelegate_StateOnTouchTransfer_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->state)::BaseType> state_fragment(
          params.message());
  mojo::internal::Serialize<::input::mojom::TouchTransferStateDataView>(
      in_state, state_fragment);
  params->state.Set(
      state_fragment.is_null() ? nullptr : state_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->state.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null state in RenderInputRouterDelegate.StateOnTouchTransfer request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderInputRouterDelegate::Name_);
  message.set_method_name("StateOnTouchTransfer");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RenderInputRouterDelegateProxy::NotifySiteIsMobileOptimized(
    bool in_is_mobile_optimized, const ::viz::FrameSinkId& in_frame_sink_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send input::mojom::RenderInputRouterDelegate::NotifySiteIsMobileOptimized", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_mobile_optimized"), in_is_mobile_optimized,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_sink_id"), in_frame_sink_id,
                        "<value of type const ::viz::FrameSinkId&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderInputRouterDelegate::kNotifySiteIsMobileOptimized), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::input::mojom::internal::RenderInputRouterDelegate_NotifySiteIsMobileOptimized_Params_Data> params(
          message);
  params.Allocate();
  params->is_mobile_optimized = in_is_mobile_optimized;
  mojo::internal::MessageFragment<
      typename decltype(params->frame_sink_id)::BaseType> frame_sink_id_fragment(
          params.message());
  mojo::internal::Serialize<::viz::mojom::FrameSinkIdDataView>(
      in_frame_sink_id, frame_sink_id_fragment);
  params->frame_sink_id.Set(
      frame_sink_id_fragment.is_null() ? nullptr : frame_sink_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->frame_sink_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null frame_sink_id in RenderInputRouterDelegate.NotifySiteIsMobileOptimized request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderInputRouterDelegate::Name_);
  message.set_method_name("NotifySiteIsMobileOptimized");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RenderInputRouterDelegateProxy::ForceEnableZoomStateChanged(
    bool in_force_enable_zoom, const std::vector<::viz::FrameSinkId>& in_frame_sink_ids) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send input::mojom::RenderInputRouterDelegate::ForceEnableZoomStateChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("force_enable_zoom"), in_force_enable_zoom,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_sink_ids"), in_frame_sink_ids,
                        "<value of type const std::vector<::viz::FrameSinkId>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderInputRouterDelegate::kForceEnableZoomStateChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::input::mojom::internal::RenderInputRouterDelegate_ForceEnableZoomStateChanged_Params_Data> params(
          message);
  params.Allocate();
  params->force_enable_zoom = in_force_enable_zoom;
  mojo::internal::MessageFragment<
      typename decltype(params->frame_sink_ids)::BaseType>
      frame_sink_ids_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& frame_sink_ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  mojo::internal::Serialize<mojo::ArrayDataView<::viz::mojom::FrameSinkIdDataView>>(
      in_frame_sink_ids, frame_sink_ids_fragment, &frame_sink_ids_validate_params);
  params->frame_sink_ids.Set(
      frame_sink_ids_fragment.is_null() ? nullptr : frame_sink_ids_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->frame_sink_ids.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null frame_sink_ids in RenderInputRouterDelegate.ForceEnableZoomStateChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderInputRouterDelegate::Name_);
  message.set_method_name("ForceEnableZoomStateChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool RenderInputRouterDelegateStubDispatch::Accept(
    RenderInputRouterDelegate* impl,
    mojo::Message* message) {
  switch (static_cast<messages::RenderInputRouterDelegate>(message->header()->name)) {
    case messages::RenderInputRouterDelegate::kStateOnTouchTransfer: {
      DCHECK(message->is_serialized());
      internal::RenderInputRouterDelegate_StateOnTouchTransfer_Params_Data* params =
          reinterpret_cast<internal::RenderInputRouterDelegate_StateOnTouchTransfer_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for RenderInputRouterDelegate.0
      bool success = true;
      TouchTransferStatePtr p_state{};
      RenderInputRouterDelegate_StateOnTouchTransfer_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadState(&p_state))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderInputRouterDelegate::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StateOnTouchTransfer(        
        std::move(p_state));
      return true;
    }
    case messages::RenderInputRouterDelegate::kNotifySiteIsMobileOptimized: {
      DCHECK(message->is_serialized());
      internal::RenderInputRouterDelegate_NotifySiteIsMobileOptimized_Params_Data* params =
          reinterpret_cast<internal::RenderInputRouterDelegate_NotifySiteIsMobileOptimized_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for RenderInputRouterDelegate.1
      bool success = true;
      bool p_is_mobile_optimized{};
      ::viz::FrameSinkId p_frame_sink_id{};
      RenderInputRouterDelegate_NotifySiteIsMobileOptimized_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_is_mobile_optimized = input_data_view.is_mobile_optimized();
      if (success && !input_data_view.ReadFrameSinkId(&p_frame_sink_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderInputRouterDelegate::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifySiteIsMobileOptimized(        
        std::move(p_is_mobile_optimized), 
        std::move(p_frame_sink_id));
      return true;
    }
    case messages::RenderInputRouterDelegate::kForceEnableZoomStateChanged: {
      DCHECK(message->is_serialized());
      internal::RenderInputRouterDelegate_ForceEnableZoomStateChanged_Params_Data* params =
          reinterpret_cast<internal::RenderInputRouterDelegate_ForceEnableZoomStateChanged_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for RenderInputRouterDelegate.2
      bool success = true;
      bool p_force_enable_zoom{};
      std::vector<::viz::FrameSinkId> p_frame_sink_ids{};
      RenderInputRouterDelegate_ForceEnableZoomStateChanged_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_force_enable_zoom = input_data_view.force_enable_zoom();
      if (success && !input_data_view.ReadFrameSinkIds(&p_frame_sink_ids))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderInputRouterDelegate::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ForceEnableZoomStateChanged(        
        std::move(p_force_enable_zoom), 
        std::move(p_frame_sink_ids));
      return true;
    }
  }
  return false;
}

// static
bool RenderInputRouterDelegateStubDispatch::AcceptWithResponder(
    RenderInputRouterDelegate* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::RenderInputRouterDelegate>(message->header()->name)) {
    case messages::RenderInputRouterDelegate::kStateOnTouchTransfer: {
      break;
    }
    case messages::RenderInputRouterDelegate::kNotifySiteIsMobileOptimized: {
      break;
    }
    case messages::RenderInputRouterDelegate::kForceEnableZoomStateChanged: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kRenderInputRouterDelegateValidationInfo[] = {
    {base::to_underlying(messages::RenderInputRouterDelegate::kStateOnTouchTransfer),
     { &internal::RenderInputRouterDelegate_StateOnTouchTransfer_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::RenderInputRouterDelegate::kNotifySiteIsMobileOptimized),
     { &internal::RenderInputRouterDelegate_NotifySiteIsMobileOptimized_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::RenderInputRouterDelegate::kForceEnableZoomStateChanged),
     { &internal::RenderInputRouterDelegate_ForceEnableZoomStateChanged_Params_Data::Validate,
      nullptr /* no response */}},
};

bool RenderInputRouterDelegateRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::input::mojom::RenderInputRouterDelegate::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kRenderInputRouterDelegateValidationInfo);
}

const char RenderInputRouterDelegateClient::Name_[] = "input.mojom.RenderInputRouterDelegateClient";

RenderInputRouterDelegateClient::IPCStableHashFunction RenderInputRouterDelegateClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::RenderInputRouterDelegateClient>(message.name())) {
    case messages::RenderInputRouterDelegateClient::kNotifyObserversOfInputEvent: {
      return &RenderInputRouterDelegateClient::NotifyObserversOfInputEvent_Sym::IPCStableHash;
    }
    case messages::RenderInputRouterDelegateClient::kNotifyObserversOfInputEventAcks: {
      return &RenderInputRouterDelegateClient::NotifyObserversOfInputEventAcks_Sym::IPCStableHash;
    }
    case messages::RenderInputRouterDelegateClient::kOnInvalidInputEventSource: {
      return &RenderInputRouterDelegateClient::OnInvalidInputEventSource_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* RenderInputRouterDelegateClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::RenderInputRouterDelegateClient>(message.name())) {
      case messages::RenderInputRouterDelegateClient::kNotifyObserversOfInputEvent:
            return "Receive input::mojom::RenderInputRouterDelegateClient::NotifyObserversOfInputEvent";
      case messages::RenderInputRouterDelegateClient::kNotifyObserversOfInputEventAcks:
            return "Receive input::mojom::RenderInputRouterDelegateClient::NotifyObserversOfInputEventAcks";
      case messages::RenderInputRouterDelegateClient::kOnInvalidInputEventSource:
            return "Receive input::mojom::RenderInputRouterDelegateClient::OnInvalidInputEventSource";
    }
  } else {
    switch (static_cast<messages::RenderInputRouterDelegateClient>(message.name())) {
      case messages::RenderInputRouterDelegateClient::kNotifyObserversOfInputEvent:
            return "Receive reply input::mojom::RenderInputRouterDelegateClient::NotifyObserversOfInputEvent";
      case messages::RenderInputRouterDelegateClient::kNotifyObserversOfInputEventAcks:
            return "Receive reply input::mojom::RenderInputRouterDelegateClient::NotifyObserversOfInputEventAcks";
      case messages::RenderInputRouterDelegateClient::kOnInvalidInputEventSource:
            return "Receive reply input::mojom::RenderInputRouterDelegateClient::OnInvalidInputEventSource";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t RenderInputRouterDelegateClient::NotifyObserversOfInputEvent_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)input::mojom::RenderInputRouterDelegateClient::NotifyObserversOfInputEvent");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RenderInputRouterDelegateClient::NotifyObserversOfInputEventAcks_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)input::mojom::RenderInputRouterDelegateClient::NotifyObserversOfInputEventAcks");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RenderInputRouterDelegateClient::OnInvalidInputEventSource_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)input::mojom::RenderInputRouterDelegateClient::OnInvalidInputEventSource");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

RenderInputRouterDelegateClientProxy::RenderInputRouterDelegateClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void RenderInputRouterDelegateClientProxy::NotifyObserversOfInputEvent(
    const ::viz::FrameSinkId& in_id, ::std::unique_ptr<::blink::WebCoalescedInputEvent> in_event, bool in_dispatched_to_renderer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send input::mojom::RenderInputRouterDelegateClient::NotifyObserversOfInputEvent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type const ::viz::FrameSinkId&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event"), in_event,
                        "<value of type ::std::unique_ptr<::blink::WebCoalescedInputEvent>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("dispatched_to_renderer"), in_dispatched_to_renderer,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderInputRouterDelegateClient::kNotifyObserversOfInputEvent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::input::mojom::internal::RenderInputRouterDelegateClient_NotifyObserversOfInputEvent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->id)::BaseType> id_fragment(
          params.message());
  mojo::internal::Serialize<::viz::mojom::FrameSinkIdDataView>(
      in_id, id_fragment);
  params->id.Set(
      id_fragment.is_null() ? nullptr : id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in RenderInputRouterDelegateClient.NotifyObserversOfInputEvent request");
  mojo::internal::MessageFragment<
      typename decltype(params->event)::BaseType> event_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::EventDataView>(
      in_event, event_fragment);
  params->event.Set(
      event_fragment.is_null() ? nullptr : event_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->event.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null event in RenderInputRouterDelegateClient.NotifyObserversOfInputEvent request");
  params->dispatched_to_renderer = in_dispatched_to_renderer;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderInputRouterDelegateClient::Name_);
  message.set_method_name("NotifyObserversOfInputEvent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RenderInputRouterDelegateClientProxy::NotifyObserversOfInputEventAcks(
    const ::viz::FrameSinkId& in_id, ::blink::mojom::InputEventResultSource in_ack_source, ::blink::mojom::InputEventResultState in_ack_result, ::std::unique_ptr<::blink::WebCoalescedInputEvent> in_event) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send input::mojom::RenderInputRouterDelegateClient::NotifyObserversOfInputEventAcks", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type const ::viz::FrameSinkId&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("ack_source"), in_ack_source,
                        "<value of type ::blink::mojom::InputEventResultSource>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("ack_result"), in_ack_result,
                        "<value of type ::blink::mojom::InputEventResultState>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event"), in_event,
                        "<value of type ::std::unique_ptr<::blink::WebCoalescedInputEvent>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderInputRouterDelegateClient::kNotifyObserversOfInputEventAcks), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::input::mojom::internal::RenderInputRouterDelegateClient_NotifyObserversOfInputEventAcks_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->id)::BaseType> id_fragment(
          params.message());
  mojo::internal::Serialize<::viz::mojom::FrameSinkIdDataView>(
      in_id, id_fragment);
  params->id.Set(
      id_fragment.is_null() ? nullptr : id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in RenderInputRouterDelegateClient.NotifyObserversOfInputEventAcks request");
  mojo::internal::Serialize<::blink::mojom::InputEventResultSource>(
      in_ack_source, &params->ack_source);
  mojo::internal::Serialize<::blink::mojom::InputEventResultState>(
      in_ack_result, &params->ack_result);
  mojo::internal::MessageFragment<
      typename decltype(params->event)::BaseType> event_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::EventDataView>(
      in_event, event_fragment);
  params->event.Set(
      event_fragment.is_null() ? nullptr : event_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->event.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null event in RenderInputRouterDelegateClient.NotifyObserversOfInputEventAcks request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderInputRouterDelegateClient::Name_);
  message.set_method_name("NotifyObserversOfInputEventAcks");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RenderInputRouterDelegateClientProxy::OnInvalidInputEventSource(
    const ::viz::FrameSinkId& in_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send input::mojom::RenderInputRouterDelegateClient::OnInvalidInputEventSource", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type const ::viz::FrameSinkId&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderInputRouterDelegateClient::kOnInvalidInputEventSource), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::input::mojom::internal::RenderInputRouterDelegateClient_OnInvalidInputEventSource_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->id)::BaseType> id_fragment(
          params.message());
  mojo::internal::Serialize<::viz::mojom::FrameSinkIdDataView>(
      in_id, id_fragment);
  params->id.Set(
      id_fragment.is_null() ? nullptr : id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in RenderInputRouterDelegateClient.OnInvalidInputEventSource request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderInputRouterDelegateClient::Name_);
  message.set_method_name("OnInvalidInputEventSource");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool RenderInputRouterDelegateClientStubDispatch::Accept(
    RenderInputRouterDelegateClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::RenderInputRouterDelegateClient>(message->header()->name)) {
    case messages::RenderInputRouterDelegateClient::kNotifyObserversOfInputEvent: {
      DCHECK(message->is_serialized());
      internal::RenderInputRouterDelegateClient_NotifyObserversOfInputEvent_Params_Data* params =
          reinterpret_cast<internal::RenderInputRouterDelegateClient_NotifyObserversOfInputEvent_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for RenderInputRouterDelegateClient.0
      bool success = true;
      ::viz::FrameSinkId p_id{};
      ::std::unique_ptr<::blink::WebCoalescedInputEvent> p_event{};
      bool p_dispatched_to_renderer{};
      RenderInputRouterDelegateClient_NotifyObserversOfInputEvent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadId(&p_id))
        success = false;
      if (success && !input_data_view.ReadEvent(&p_event))
        success = false;
      if (success)
        p_dispatched_to_renderer = input_data_view.dispatched_to_renderer();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderInputRouterDelegateClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyObserversOfInputEvent(        
        std::move(p_id), 
        std::move(p_event), 
        std::move(p_dispatched_to_renderer));
      return true;
    }
    case messages::RenderInputRouterDelegateClient::kNotifyObserversOfInputEventAcks: {
      DCHECK(message->is_serialized());
      internal::RenderInputRouterDelegateClient_NotifyObserversOfInputEventAcks_Params_Data* params =
          reinterpret_cast<internal::RenderInputRouterDelegateClient_NotifyObserversOfInputEventAcks_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for RenderInputRouterDelegateClient.1
      bool success = true;
      ::viz::FrameSinkId p_id{};
      ::blink::mojom::InputEventResultSource p_ack_source{};
      ::blink::mojom::InputEventResultState p_ack_result{};
      ::std::unique_ptr<::blink::WebCoalescedInputEvent> p_event{};
      RenderInputRouterDelegateClient_NotifyObserversOfInputEventAcks_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadId(&p_id))
        success = false;
      if (success && !input_data_view.ReadAckSource(&p_ack_source))
        success = false;
      if (success && !input_data_view.ReadAckResult(&p_ack_result))
        success = false;
      if (success && !input_data_view.ReadEvent(&p_event))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderInputRouterDelegateClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyObserversOfInputEventAcks(        
        std::move(p_id), 
        std::move(p_ack_source), 
        std::move(p_ack_result), 
        std::move(p_event));
      return true;
    }
    case messages::RenderInputRouterDelegateClient::kOnInvalidInputEventSource: {
      DCHECK(message->is_serialized());
      internal::RenderInputRouterDelegateClient_OnInvalidInputEventSource_Params_Data* params =
          reinterpret_cast<internal::RenderInputRouterDelegateClient_OnInvalidInputEventSource_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for RenderInputRouterDelegateClient.2
      bool success = true;
      ::viz::FrameSinkId p_id{};
      RenderInputRouterDelegateClient_OnInvalidInputEventSource_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadId(&p_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderInputRouterDelegateClient::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnInvalidInputEventSource(        
        std::move(p_id));
      return true;
    }
  }
  return false;
}

// static
bool RenderInputRouterDelegateClientStubDispatch::AcceptWithResponder(
    RenderInputRouterDelegateClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::RenderInputRouterDelegateClient>(message->header()->name)) {
    case messages::RenderInputRouterDelegateClient::kNotifyObserversOfInputEvent: {
      break;
    }
    case messages::RenderInputRouterDelegateClient::kNotifyObserversOfInputEventAcks: {
      break;
    }
    case messages::RenderInputRouterDelegateClient::kOnInvalidInputEventSource: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kRenderInputRouterDelegateClientValidationInfo[] = {
    {base::to_underlying(messages::RenderInputRouterDelegateClient::kNotifyObserversOfInputEvent),
     { &internal::RenderInputRouterDelegateClient_NotifyObserversOfInputEvent_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::RenderInputRouterDelegateClient::kNotifyObserversOfInputEventAcks),
     { &internal::RenderInputRouterDelegateClient_NotifyObserversOfInputEventAcks_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::RenderInputRouterDelegateClient::kOnInvalidInputEventSource),
     { &internal::RenderInputRouterDelegateClient_OnInvalidInputEventSource_Params_Data::Validate,
      nullptr /* no response */}},
};

bool RenderInputRouterDelegateClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::input::mojom::RenderInputRouterDelegateClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kRenderInputRouterDelegateClientValidationInfo);
}



}  // input::mojom


namespace mojo {


// static
bool StructTraits<::input::mojom::RenderInputRouterConfig::DataView, ::input::mojom::RenderInputRouterConfigPtr>::Read(
    ::input::mojom::RenderInputRouterConfig::DataView input,
    ::input::mojom::RenderInputRouterConfigPtr* output) {
  bool success = true;
  ::input::mojom::RenderInputRouterConfigPtr result(::input::mojom::RenderInputRouterConfig::New());
  
      if (success) {
        result->rir_client =
            input.TakeRirClient<decltype(result->rir_client)>();
      }
      if (success && !input.ReadGroupingId(&result->grouping_id))
        success = false;
      if (success)
        result->force_enable_zoom = input.force_enable_zoom();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::input::mojom::TouchTransferState::DataView, ::input::mojom::TouchTransferStatePtr>::Read(
    ::input::mojom::TouchTransferState::DataView input,
    ::input::mojom::TouchTransferStatePtr* output) {
  bool success = true;
  ::input::mojom::TouchTransferStatePtr result(::input::mojom::TouchTransferState::New());
  
      if (success && !input.ReadDownTimeMs(&result->down_time_ms))
        success = false;
      if (success && !input.ReadRootWidgetFrameSinkId(&result->root_widget_frame_sink_id))
        success = false;
      if (success)
        result->raw_y_offset = input.raw_y_offset();
      if (success)
        result->dip_scale = input.dip_scale();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace input::mojom {


void RenderInputRouterDelegateInterceptorForTesting::StateOnTouchTransfer(TouchTransferStatePtr state) {
  GetForwardingInterface()->StateOnTouchTransfer(
    std::move(state)
    );
}
void RenderInputRouterDelegateInterceptorForTesting::NotifySiteIsMobileOptimized(bool is_mobile_optimized, const ::viz::FrameSinkId& frame_sink_id) {
  GetForwardingInterface()->NotifySiteIsMobileOptimized(
    std::move(is_mobile_optimized)
    , 
    std::move(frame_sink_id)
    );
}
void RenderInputRouterDelegateInterceptorForTesting::ForceEnableZoomStateChanged(bool force_enable_zoom, const std::vector<::viz::FrameSinkId>& frame_sink_ids) {
  GetForwardingInterface()->ForceEnableZoomStateChanged(
    std::move(force_enable_zoom)
    , 
    std::move(frame_sink_ids)
    );
}
RenderInputRouterDelegateAsyncWaiter::RenderInputRouterDelegateAsyncWaiter(
    RenderInputRouterDelegate* proxy) : proxy_(proxy) {}

RenderInputRouterDelegateAsyncWaiter::~RenderInputRouterDelegateAsyncWaiter() = default;




void RenderInputRouterDelegateClientInterceptorForTesting::NotifyObserversOfInputEvent(const ::viz::FrameSinkId& id, ::std::unique_ptr<::blink::WebCoalescedInputEvent> event, bool dispatched_to_renderer) {
  GetForwardingInterface()->NotifyObserversOfInputEvent(
    std::move(id)
    , 
    std::move(event)
    , 
    std::move(dispatched_to_renderer)
    );
}
void RenderInputRouterDelegateClientInterceptorForTesting::NotifyObserversOfInputEventAcks(const ::viz::FrameSinkId& id, ::blink::mojom::InputEventResultSource ack_source, ::blink::mojom::InputEventResultState ack_result, ::std::unique_ptr<::blink::WebCoalescedInputEvent> event) {
  GetForwardingInterface()->NotifyObserversOfInputEventAcks(
    std::move(id)
    , 
    std::move(ack_source)
    , 
    std::move(ack_result)
    , 
    std::move(event)
    );
}
void RenderInputRouterDelegateClientInterceptorForTesting::OnInvalidInputEventSource(const ::viz::FrameSinkId& id) {
  GetForwardingInterface()->OnInvalidInputEventSource(
    std::move(id)
    );
}
RenderInputRouterDelegateClientAsyncWaiter::RenderInputRouterDelegateClientAsyncWaiter(
    RenderInputRouterDelegateClient* proxy) : proxy_(proxy) {}

RenderInputRouterDelegateClientAsyncWaiter::~RenderInputRouterDelegateClientAsyncWaiter() = default;






}  // input::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif