// components/content_settings/core/common/content_settings.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_CONTENT_SETTINGS_CORE_COMMON_CONTENT_SETTINGS_MOJOM_BLINK_H_
#define COMPONENTS_CONTENT_SETTINGS_CORE_COMMON_CONTENT_SETTINGS_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/content_settings/core/common/content_settings.mojom-features.h"  // IWYU pragma: export
#include "components/content_settings/core/common/content_settings.mojom-shared.h"  // IWYU pragma: export
#include "components/content_settings/core/common/content_settings.mojom-blink-forward.h"  // IWYU pragma: export
#include "components/content_settings/core/common/content_settings_enums.mojom-blink-forward.h"
#include "mojo/public/mojom/base/time.mojom-blink.h"
#include "mojo/public/mojom/base/values.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace content_settings::mojom::blink {












class  PatternParts {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PatternParts, T>::value>;
  using DataView = PatternPartsDataView;
  using Data_ = internal::PatternParts_Data;

  template <typename... Args>
  static PatternPartsPtr New(Args&&... args) {
    return PatternPartsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PatternPartsPtr From(const U& u) {
    return mojo::TypeConverter<PatternPartsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PatternParts>::Convert(*this);
  }


  PatternParts();

  PatternParts(
      const WTF::String& scheme,
      bool is_scheme_wildcard,
      const WTF::String& host,
      bool has_domain_wildcard,
      const WTF::String& port,
      bool is_port_wildcard,
      const WTF::String& path,
      bool is_path_wildcard);


  ~PatternParts();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PatternPartsPtr>
  PatternPartsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PatternParts::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PatternParts::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PatternParts::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PatternParts::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PatternParts::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PatternParts_UnserializedMessageContext<
            UserType, PatternParts::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PatternParts::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PatternParts::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PatternParts_UnserializedMessageContext<
            UserType, PatternParts::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PatternParts::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  WTF::String scheme;
  
  bool is_scheme_wildcard;
  
  WTF::String host;
  
  bool has_domain_wildcard;
  
  WTF::String port;
  
  bool is_port_wildcard;
  
  WTF::String path;
  
  bool is_path_wildcard;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PatternParts::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PatternParts::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PatternParts::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PatternParts::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  ContentSettingsPattern {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ContentSettingsPattern, T>::value>;
  using DataView = ContentSettingsPatternDataView;
  using Data_ = internal::ContentSettingsPattern_Data;

  template <typename... Args>
  static ContentSettingsPatternPtr New(Args&&... args) {
    return ContentSettingsPatternPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ContentSettingsPatternPtr From(const U& u) {
    return mojo::TypeConverter<ContentSettingsPatternPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ContentSettingsPattern>::Convert(*this);
  }


  ContentSettingsPattern();

  ContentSettingsPattern(
      PatternPartsPtr parts,
      bool is_valid);

ContentSettingsPattern(const ContentSettingsPattern&) = delete;
ContentSettingsPattern& operator=(const ContentSettingsPattern&) = delete;

  ~ContentSettingsPattern();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ContentSettingsPatternPtr>
  ContentSettingsPatternPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ContentSettingsPattern::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ContentSettingsPattern::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ContentSettingsPattern::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ContentSettingsPattern::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ContentSettingsPattern::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ContentSettingsPattern_UnserializedMessageContext<
            UserType, ContentSettingsPattern::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ContentSettingsPattern::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ContentSettingsPattern::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ContentSettingsPattern_UnserializedMessageContext<
            UserType, ContentSettingsPattern::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ContentSettingsPattern::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  PatternPartsPtr parts;
  
  bool is_valid;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ContentSettingsPattern::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ContentSettingsPattern::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ContentSettingsPattern::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ContentSettingsPattern::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  RuleMetaData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<RuleMetaData, T>::value>;
  using DataView = RuleMetaDataDataView;
  using Data_ = internal::RuleMetaData_Data;

  template <typename... Args>
  static RuleMetaDataPtr New(Args&&... args) {
    return RuleMetaDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static RuleMetaDataPtr From(const U& u) {
    return mojo::TypeConverter<RuleMetaDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, RuleMetaData>::Convert(*this);
  }


  RuleMetaData();

  RuleMetaData(
      ::base::Time last_modified,
      ::base::Time last_used,
      ::base::Time last_visited,
      ::base::Time expiration,
      ::content_settings::mojom::blink::SessionModel session_model,
      ::base::TimeDelta lifetime,
      ::content_settings::mojom::blink::TpcdMetadataRuleSource tpcd_metadata_rule_source,
      ::content_settings::mojom::blink::TpcdMetadataCohort tpcd_metadata_cohort,
      bool decided_by_related_website_sets);


  ~RuleMetaData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = RuleMetaDataPtr>
  RuleMetaDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, RuleMetaData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, RuleMetaData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, RuleMetaData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RuleMetaData::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        RuleMetaData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::RuleMetaData_UnserializedMessageContext<
            UserType, RuleMetaData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<RuleMetaData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return RuleMetaData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::RuleMetaData_UnserializedMessageContext<
            UserType, RuleMetaData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<RuleMetaData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::Time last_modified;
  
  ::base::Time last_used;
  
  ::base::Time last_visited;
  
  ::base::Time expiration;
  
  ::content_settings::mojom::blink::SessionModel session_model;
  
  ::base::TimeDelta lifetime;
  
  ::content_settings::mojom::blink::TpcdMetadataRuleSource tpcd_metadata_rule_source;
  
  ::content_settings::mojom::blink::TpcdMetadataCohort tpcd_metadata_cohort;
  
  bool decided_by_related_website_sets;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, RuleMetaData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, RuleMetaData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, RuleMetaData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, RuleMetaData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  ContentSettingPatternSource {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ContentSettingPatternSource, T>::value>;
  using DataView = ContentSettingPatternSourceDataView;
  using Data_ = internal::ContentSettingPatternSource_Data;

  template <typename... Args>
  static ContentSettingPatternSourcePtr New(Args&&... args) {
    return ContentSettingPatternSourcePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ContentSettingPatternSourcePtr From(const U& u) {
    return mojo::TypeConverter<ContentSettingPatternSourcePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ContentSettingPatternSource>::Convert(*this);
  }


  ContentSettingPatternSource();

  ContentSettingPatternSource(
      ContentSettingsPatternPtr primary_pattern,
      ContentSettingsPatternPtr secondary_pattern,
      ::base::Value setting_value,
      RuleMetaDataPtr metadata,
      ::content_settings::mojom::blink::ProviderType source,
      bool incognito);

ContentSettingPatternSource(const ContentSettingPatternSource&) = delete;
ContentSettingPatternSource& operator=(const ContentSettingPatternSource&) = delete;

  ~ContentSettingPatternSource();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ContentSettingPatternSourcePtr>
  ContentSettingPatternSourcePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ContentSettingPatternSource::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ContentSettingPatternSource::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ContentSettingPatternSource::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ContentSettingPatternSource::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ContentSettingPatternSource::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ContentSettingPatternSource_UnserializedMessageContext<
            UserType, ContentSettingPatternSource::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ContentSettingPatternSource::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ContentSettingPatternSource::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ContentSettingPatternSource_UnserializedMessageContext<
            UserType, ContentSettingPatternSource::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ContentSettingPatternSource::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ContentSettingsPatternPtr primary_pattern;
  
  ContentSettingsPatternPtr secondary_pattern;
  
  ::base::Value setting_value;
  
  RuleMetaDataPtr metadata;
  
  ::content_settings::mojom::blink::ProviderType source;
  
  bool incognito;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ContentSettingPatternSource::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ContentSettingPatternSource::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ContentSettingPatternSource::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ContentSettingPatternSource::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  RendererContentSettingRules {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<RendererContentSettingRules, T>::value>;
  using DataView = RendererContentSettingRulesDataView;
  using Data_ = internal::RendererContentSettingRules_Data;

  template <typename... Args>
  static RendererContentSettingRulesPtr New(Args&&... args) {
    return RendererContentSettingRulesPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static RendererContentSettingRulesPtr From(const U& u) {
    return mojo::TypeConverter<RendererContentSettingRulesPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, RendererContentSettingRules>::Convert(*this);
  }


  RendererContentSettingRules();

  explicit RendererContentSettingRules(
      WTF::Vector<ContentSettingPatternSourcePtr> mixed_content_rules);

RendererContentSettingRules(const RendererContentSettingRules&) = delete;
RendererContentSettingRules& operator=(const RendererContentSettingRules&) = delete;

  ~RendererContentSettingRules();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = RendererContentSettingRulesPtr>
  RendererContentSettingRulesPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, RendererContentSettingRules::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, RendererContentSettingRules::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, RendererContentSettingRules::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RendererContentSettingRules::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        RendererContentSettingRules::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::RendererContentSettingRules_UnserializedMessageContext<
            UserType, RendererContentSettingRules::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<RendererContentSettingRules::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return RendererContentSettingRules::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::RendererContentSettingRules_UnserializedMessageContext<
            UserType, RendererContentSettingRules::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<RendererContentSettingRules::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  WTF::Vector<ContentSettingPatternSourcePtr> mixed_content_rules;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, RendererContentSettingRules::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, RendererContentSettingRules::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, RendererContentSettingRules::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, RendererContentSettingRules::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
PatternPartsPtr PatternParts::Clone() const {
  return New(
      mojo::Clone(scheme),
      mojo::Clone(is_scheme_wildcard),
      mojo::Clone(host),
      mojo::Clone(has_domain_wildcard),
      mojo::Clone(port),
      mojo::Clone(is_port_wildcard),
      mojo::Clone(path),
      mojo::Clone(is_path_wildcard)
  );
}

template <typename T, PatternParts::EnableIfSame<T>*>
bool PatternParts::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->scheme, other_struct.scheme))
    return false;
  if (!mojo::Equals(this->is_scheme_wildcard, other_struct.is_scheme_wildcard))
    return false;
  if (!mojo::Equals(this->host, other_struct.host))
    return false;
  if (!mojo::Equals(this->has_domain_wildcard, other_struct.has_domain_wildcard))
    return false;
  if (!mojo::Equals(this->port, other_struct.port))
    return false;
  if (!mojo::Equals(this->is_port_wildcard, other_struct.is_port_wildcard))
    return false;
  if (!mojo::Equals(this->path, other_struct.path))
    return false;
  if (!mojo::Equals(this->is_path_wildcard, other_struct.is_path_wildcard))
    return false;
  return true;
}

template <typename T, PatternParts::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.scheme < rhs.scheme)
    return true;
  if (rhs.scheme < lhs.scheme)
    return false;
  if (lhs.is_scheme_wildcard < rhs.is_scheme_wildcard)
    return true;
  if (rhs.is_scheme_wildcard < lhs.is_scheme_wildcard)
    return false;
  if (lhs.host < rhs.host)
    return true;
  if (rhs.host < lhs.host)
    return false;
  if (lhs.has_domain_wildcard < rhs.has_domain_wildcard)
    return true;
  if (rhs.has_domain_wildcard < lhs.has_domain_wildcard)
    return false;
  if (lhs.port < rhs.port)
    return true;
  if (rhs.port < lhs.port)
    return false;
  if (lhs.is_port_wildcard < rhs.is_port_wildcard)
    return true;
  if (rhs.is_port_wildcard < lhs.is_port_wildcard)
    return false;
  if (lhs.path < rhs.path)
    return true;
  if (rhs.path < lhs.path)
    return false;
  if (lhs.is_path_wildcard < rhs.is_path_wildcard)
    return true;
  if (rhs.is_path_wildcard < lhs.is_path_wildcard)
    return false;
  return false;
}
template <typename StructPtrType>
ContentSettingsPatternPtr ContentSettingsPattern::Clone() const {
  return New(
      mojo::Clone(parts),
      mojo::Clone(is_valid)
  );
}

template <typename T, ContentSettingsPattern::EnableIfSame<T>*>
bool ContentSettingsPattern::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->parts, other_struct.parts))
    return false;
  if (!mojo::Equals(this->is_valid, other_struct.is_valid))
    return false;
  return true;
}

template <typename T, ContentSettingsPattern::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.parts < rhs.parts)
    return true;
  if (rhs.parts < lhs.parts)
    return false;
  if (lhs.is_valid < rhs.is_valid)
    return true;
  if (rhs.is_valid < lhs.is_valid)
    return false;
  return false;
}
template <typename StructPtrType>
RuleMetaDataPtr RuleMetaData::Clone() const {
  return New(
      mojo::Clone(last_modified),
      mojo::Clone(last_used),
      mojo::Clone(last_visited),
      mojo::Clone(expiration),
      mojo::Clone(session_model),
      mojo::Clone(lifetime),
      mojo::Clone(tpcd_metadata_rule_source),
      mojo::Clone(tpcd_metadata_cohort),
      mojo::Clone(decided_by_related_website_sets)
  );
}

template <typename T, RuleMetaData::EnableIfSame<T>*>
bool RuleMetaData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->last_modified, other_struct.last_modified))
    return false;
  if (!mojo::Equals(this->last_used, other_struct.last_used))
    return false;
  if (!mojo::Equals(this->last_visited, other_struct.last_visited))
    return false;
  if (!mojo::Equals(this->expiration, other_struct.expiration))
    return false;
  if (!mojo::Equals(this->session_model, other_struct.session_model))
    return false;
  if (!mojo::Equals(this->lifetime, other_struct.lifetime))
    return false;
  if (!mojo::Equals(this->tpcd_metadata_rule_source, other_struct.tpcd_metadata_rule_source))
    return false;
  if (!mojo::Equals(this->tpcd_metadata_cohort, other_struct.tpcd_metadata_cohort))
    return false;
  if (!mojo::Equals(this->decided_by_related_website_sets, other_struct.decided_by_related_website_sets))
    return false;
  return true;
}

template <typename T, RuleMetaData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.last_modified < rhs.last_modified)
    return true;
  if (rhs.last_modified < lhs.last_modified)
    return false;
  if (lhs.last_used < rhs.last_used)
    return true;
  if (rhs.last_used < lhs.last_used)
    return false;
  if (lhs.last_visited < rhs.last_visited)
    return true;
  if (rhs.last_visited < lhs.last_visited)
    return false;
  if (lhs.expiration < rhs.expiration)
    return true;
  if (rhs.expiration < lhs.expiration)
    return false;
  if (lhs.session_model < rhs.session_model)
    return true;
  if (rhs.session_model < lhs.session_model)
    return false;
  if (lhs.lifetime < rhs.lifetime)
    return true;
  if (rhs.lifetime < lhs.lifetime)
    return false;
  if (lhs.tpcd_metadata_rule_source < rhs.tpcd_metadata_rule_source)
    return true;
  if (rhs.tpcd_metadata_rule_source < lhs.tpcd_metadata_rule_source)
    return false;
  if (lhs.tpcd_metadata_cohort < rhs.tpcd_metadata_cohort)
    return true;
  if (rhs.tpcd_metadata_cohort < lhs.tpcd_metadata_cohort)
    return false;
  if (lhs.decided_by_related_website_sets < rhs.decided_by_related_website_sets)
    return true;
  if (rhs.decided_by_related_website_sets < lhs.decided_by_related_website_sets)
    return false;
  return false;
}
template <typename StructPtrType>
ContentSettingPatternSourcePtr ContentSettingPatternSource::Clone() const {
  return New(
      mojo::Clone(primary_pattern),
      mojo::Clone(secondary_pattern),
      mojo::Clone(setting_value),
      mojo::Clone(metadata),
      mojo::Clone(source),
      mojo::Clone(incognito)
  );
}

template <typename T, ContentSettingPatternSource::EnableIfSame<T>*>
bool ContentSettingPatternSource::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->primary_pattern, other_struct.primary_pattern))
    return false;
  if (!mojo::Equals(this->secondary_pattern, other_struct.secondary_pattern))
    return false;
  if (!mojo::Equals(this->setting_value, other_struct.setting_value))
    return false;
  if (!mojo::Equals(this->metadata, other_struct.metadata))
    return false;
  if (!mojo::Equals(this->source, other_struct.source))
    return false;
  if (!mojo::Equals(this->incognito, other_struct.incognito))
    return false;
  return true;
}

template <typename T, ContentSettingPatternSource::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.primary_pattern < rhs.primary_pattern)
    return true;
  if (rhs.primary_pattern < lhs.primary_pattern)
    return false;
  if (lhs.secondary_pattern < rhs.secondary_pattern)
    return true;
  if (rhs.secondary_pattern < lhs.secondary_pattern)
    return false;
  if (lhs.setting_value < rhs.setting_value)
    return true;
  if (rhs.setting_value < lhs.setting_value)
    return false;
  if (lhs.metadata < rhs.metadata)
    return true;
  if (rhs.metadata < lhs.metadata)
    return false;
  if (lhs.source < rhs.source)
    return true;
  if (rhs.source < lhs.source)
    return false;
  if (lhs.incognito < rhs.incognito)
    return true;
  if (rhs.incognito < lhs.incognito)
    return false;
  return false;
}
template <typename StructPtrType>
RendererContentSettingRulesPtr RendererContentSettingRules::Clone() const {
  return New(
      mojo::Clone(mixed_content_rules)
  );
}

template <typename T, RendererContentSettingRules::EnableIfSame<T>*>
bool RendererContentSettingRules::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->mixed_content_rules, other_struct.mixed_content_rules))
    return false;
  return true;
}

template <typename T, RendererContentSettingRules::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.mixed_content_rules < rhs.mixed_content_rules)
    return true;
  if (rhs.mixed_content_rules < lhs.mixed_content_rules)
    return false;
  return false;
}


}  // content_settings::mojom::blink

namespace mojo {


template <>
struct  StructTraits<::content_settings::mojom::blink::PatternParts::DataView,
                                         ::content_settings::mojom::blink::PatternPartsPtr> {
  static bool IsNull(const ::content_settings::mojom::blink::PatternPartsPtr& input) { return !input; }
  static void SetToNull(::content_settings::mojom::blink::PatternPartsPtr* output) { output->reset(); }

  static const decltype(::content_settings::mojom::blink::PatternParts::scheme)& scheme(
      const ::content_settings::mojom::blink::PatternPartsPtr& input) {
    return input->scheme;
  }

  static decltype(::content_settings::mojom::blink::PatternParts::is_scheme_wildcard) is_scheme_wildcard(
      const ::content_settings::mojom::blink::PatternPartsPtr& input) {
    return input->is_scheme_wildcard;
  }

  static const decltype(::content_settings::mojom::blink::PatternParts::host)& host(
      const ::content_settings::mojom::blink::PatternPartsPtr& input) {
    return input->host;
  }

  static decltype(::content_settings::mojom::blink::PatternParts::has_domain_wildcard) has_domain_wildcard(
      const ::content_settings::mojom::blink::PatternPartsPtr& input) {
    return input->has_domain_wildcard;
  }

  static const decltype(::content_settings::mojom::blink::PatternParts::port)& port(
      const ::content_settings::mojom::blink::PatternPartsPtr& input) {
    return input->port;
  }

  static decltype(::content_settings::mojom::blink::PatternParts::is_port_wildcard) is_port_wildcard(
      const ::content_settings::mojom::blink::PatternPartsPtr& input) {
    return input->is_port_wildcard;
  }

  static const decltype(::content_settings::mojom::blink::PatternParts::path)& path(
      const ::content_settings::mojom::blink::PatternPartsPtr& input) {
    return input->path;
  }

  static decltype(::content_settings::mojom::blink::PatternParts::is_path_wildcard) is_path_wildcard(
      const ::content_settings::mojom::blink::PatternPartsPtr& input) {
    return input->is_path_wildcard;
  }

  static bool Read(::content_settings::mojom::blink::PatternParts::DataView input, ::content_settings::mojom::blink::PatternPartsPtr* output);
};


template <>
struct  StructTraits<::content_settings::mojom::blink::ContentSettingsPattern::DataView,
                                         ::content_settings::mojom::blink::ContentSettingsPatternPtr> {
  static bool IsNull(const ::content_settings::mojom::blink::ContentSettingsPatternPtr& input) { return !input; }
  static void SetToNull(::content_settings::mojom::blink::ContentSettingsPatternPtr* output) { output->reset(); }

  static const decltype(::content_settings::mojom::blink::ContentSettingsPattern::parts)& parts(
      const ::content_settings::mojom::blink::ContentSettingsPatternPtr& input) {
    return input->parts;
  }

  static decltype(::content_settings::mojom::blink::ContentSettingsPattern::is_valid) is_valid(
      const ::content_settings::mojom::blink::ContentSettingsPatternPtr& input) {
    return input->is_valid;
  }

  static bool Read(::content_settings::mojom::blink::ContentSettingsPattern::DataView input, ::content_settings::mojom::blink::ContentSettingsPatternPtr* output);
};


template <>
struct  StructTraits<::content_settings::mojom::blink::RuleMetaData::DataView,
                                         ::content_settings::mojom::blink::RuleMetaDataPtr> {
  static bool IsNull(const ::content_settings::mojom::blink::RuleMetaDataPtr& input) { return !input; }
  static void SetToNull(::content_settings::mojom::blink::RuleMetaDataPtr* output) { output->reset(); }

  static const decltype(::content_settings::mojom::blink::RuleMetaData::last_modified)& last_modified(
      const ::content_settings::mojom::blink::RuleMetaDataPtr& input) {
    return input->last_modified;
  }

  static const decltype(::content_settings::mojom::blink::RuleMetaData::last_used)& last_used(
      const ::content_settings::mojom::blink::RuleMetaDataPtr& input) {
    return input->last_used;
  }

  static const decltype(::content_settings::mojom::blink::RuleMetaData::last_visited)& last_visited(
      const ::content_settings::mojom::blink::RuleMetaDataPtr& input) {
    return input->last_visited;
  }

  static const decltype(::content_settings::mojom::blink::RuleMetaData::expiration)& expiration(
      const ::content_settings::mojom::blink::RuleMetaDataPtr& input) {
    return input->expiration;
  }

  static decltype(::content_settings::mojom::blink::RuleMetaData::session_model) session_model(
      const ::content_settings::mojom::blink::RuleMetaDataPtr& input) {
    return input->session_model;
  }

  static const decltype(::content_settings::mojom::blink::RuleMetaData::lifetime)& lifetime(
      const ::content_settings::mojom::blink::RuleMetaDataPtr& input) {
    return input->lifetime;
  }

  static decltype(::content_settings::mojom::blink::RuleMetaData::tpcd_metadata_rule_source) tpcd_metadata_rule_source(
      const ::content_settings::mojom::blink::RuleMetaDataPtr& input) {
    return input->tpcd_metadata_rule_source;
  }

  static decltype(::content_settings::mojom::blink::RuleMetaData::tpcd_metadata_cohort) tpcd_metadata_cohort(
      const ::content_settings::mojom::blink::RuleMetaDataPtr& input) {
    return input->tpcd_metadata_cohort;
  }

  static decltype(::content_settings::mojom::blink::RuleMetaData::decided_by_related_website_sets) decided_by_related_website_sets(
      const ::content_settings::mojom::blink::RuleMetaDataPtr& input) {
    return input->decided_by_related_website_sets;
  }

  static bool Read(::content_settings::mojom::blink::RuleMetaData::DataView input, ::content_settings::mojom::blink::RuleMetaDataPtr* output);
};


template <>
struct  StructTraits<::content_settings::mojom::blink::ContentSettingPatternSource::DataView,
                                         ::content_settings::mojom::blink::ContentSettingPatternSourcePtr> {
  static bool IsNull(const ::content_settings::mojom::blink::ContentSettingPatternSourcePtr& input) { return !input; }
  static void SetToNull(::content_settings::mojom::blink::ContentSettingPatternSourcePtr* output) { output->reset(); }

  static const decltype(::content_settings::mojom::blink::ContentSettingPatternSource::primary_pattern)& primary_pattern(
      const ::content_settings::mojom::blink::ContentSettingPatternSourcePtr& input) {
    return input->primary_pattern;
  }

  static const decltype(::content_settings::mojom::blink::ContentSettingPatternSource::secondary_pattern)& secondary_pattern(
      const ::content_settings::mojom::blink::ContentSettingPatternSourcePtr& input) {
    return input->secondary_pattern;
  }

  static const decltype(::content_settings::mojom::blink::ContentSettingPatternSource::setting_value)& setting_value(
      const ::content_settings::mojom::blink::ContentSettingPatternSourcePtr& input) {
    return input->setting_value;
  }

  static const decltype(::content_settings::mojom::blink::ContentSettingPatternSource::metadata)& metadata(
      const ::content_settings::mojom::blink::ContentSettingPatternSourcePtr& input) {
    return input->metadata;
  }

  static decltype(::content_settings::mojom::blink::ContentSettingPatternSource::source) source(
      const ::content_settings::mojom::blink::ContentSettingPatternSourcePtr& input) {
    return input->source;
  }

  static decltype(::content_settings::mojom::blink::ContentSettingPatternSource::incognito) incognito(
      const ::content_settings::mojom::blink::ContentSettingPatternSourcePtr& input) {
    return input->incognito;
  }

  static bool Read(::content_settings::mojom::blink::ContentSettingPatternSource::DataView input, ::content_settings::mojom::blink::ContentSettingPatternSourcePtr* output);
};


template <>
struct  StructTraits<::content_settings::mojom::blink::RendererContentSettingRules::DataView,
                                         ::content_settings::mojom::blink::RendererContentSettingRulesPtr> {
  static bool IsNull(const ::content_settings::mojom::blink::RendererContentSettingRulesPtr& input) { return !input; }
  static void SetToNull(::content_settings::mojom::blink::RendererContentSettingRulesPtr* output) { output->reset(); }

  static const decltype(::content_settings::mojom::blink::RendererContentSettingRules::mixed_content_rules)& mixed_content_rules(
      const ::content_settings::mojom::blink::RendererContentSettingRulesPtr& input) {
    return input->mixed_content_rules;
  }

  static bool Read(::content_settings::mojom::blink::RendererContentSettingRules::DataView input, ::content_settings::mojom::blink::RendererContentSettingRulesPtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_CONTENT_SETTINGS_CORE_COMMON_CONTENT_SETTINGS_MOJOM_BLINK_H_