/**
 * Qt6 Common library
 *
 * The Qt6 Common library is auto-generated and available to users under the same license as the Qt which it is used with or built with. See available licenses below. 
 * SPDX-License-Identifier: LicenseRef-Qt-Commercial OR LGPL-3.0-only OR GPL-2.0-only OR GPL-3.0-only
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

#ifndef QtOAI_HTTP_FILE_ELEMENT_H
#define QtOAI_HTTP_FILE_ELEMENT_H

#include "QtOAICommonExports.h"

#include <QtCore/qjsonvalue.h>
#include <QtCore/qmetatype.h>
#include <QtCore/qshareddata.h>
#include <QtCore/qstring.h>

namespace QtCommonOpenAPI {

// NOTE: Normally, QtOAIHttpFileElementShared would be forward-declared and
// defined in the cpp file with QT_DECLARE/DEFINE_QESDP_SPECIALIZATION_DTOR(),
// but since those macros are internal, we define it here instead.
// The class enables implicit sharing via QExplicitlySharedDataPointer.

class QtOAI_COMMON_EXPORT QtOAIHttpFileElementShared : public QSharedData
{
public:
    explicit QtOAIHttpFileElementShared(const QString &localFilename)
        : m_localFilename(localFilename) {}
    ~QtOAIHttpFileElementShared();

    QString m_variableName;
    const QString m_localFilename;
    QString m_mimeType;
    bool m_temporary = false;
};

class QtOAI_COMMON_EXPORT QtOAIHttpFileElement {

public:
    QtOAIHttpFileElement();
    explicit QtOAIHttpFileElement(const QString &localFilename);
    QtOAIHttpFileElement(const QtOAIHttpFileElement &other);
    QtOAIHttpFileElement(QtOAIHttpFileElement &&other) noexcept : d(std::move(other.d)) {}
    QtOAIHttpFileElement &operator=(const QtOAIHttpFileElement &other);
    QtOAIHttpFileElement &operator=(QtOAIHttpFileElement &&other) noexcept
    {
        if (this != &other)
            d = std::move(other.d);
        return *this;
    }
    ~QtOAIHttpFileElement();

    void setMimeType(const QString &mime);
    void setVariableName(const QString &name);
    void setTemporary(bool temp);

    QString mimeType() const;
    QString filename() const;
    QString variableName() const;
    bool isTemporary() const;

    QString requestFilename() const;
    bool isSet() const;
    bool fromStringValue(const QString &instr);
    bool fromJsonValue(const QJsonValue &jval);
    bool saveToLocalFile(const QByteArray &bytes);
    QString asJson() const;
    QJsonValue asJsonValue() const;
    QByteArray loadFromLocalFile() const;

private:
    QExplicitlySharedDataPointer<QtOAIHttpFileElementShared> d;
};

} // namespace QtCommonOpenAPI

Q_DECLARE_METATYPE(QtCommonOpenAPI::QtOAIHttpFileElement)

#endif // QtOAI_HTTP_FILE_ELEMENT_H
