
#line 132 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
// Copyright (C) 2016 The Qt Company Ltd.
// Contact: https://www.qt.io/licensing/
// SPDX-License-Identifier: LicenseRef-Qt-Commercial OR LGPL-3.0-only OR GPL-2.0-only OR GPL-3.0-only

#include <private/qqmljsengine_p.h>
#include <private/qqmljslexer_p.h>
#include <private/qqmljsast_p.h>
#include <private/qqmljsmemorypool_p.h>

#include <QtCore/qdebug.h>
#include <QtCore/qcoreapplication.h>

#include <string.h>


#line 440 "../../../qtdeclarative/src/qml/parser/qqmljs.g"


#include "qqmljsparser_p.h"

#include <QtCore/qvarlengtharray.h>

//
//  W A R N I N G
//  -------------
//
// This file is automatically generated from qqmljs.g.
// Changes should be made to that file, not here. Any change to this file will
// be lost!
//
// To regenerate this file, run:
//    qlalr --no-debug --no-lines --qt qqmljs.g
//

#define UNIMPLEMENTED syntaxError(loc(1), "Unimplemented"); return false

using namespace QQmlJS;
using namespace Qt::StringLiterals;

QT_BEGIN_NAMESPACE

void Parser::reallocateStack()
{
    if (! stack_size)
        stack_size = 128;
    else
        stack_size <<= 1;

    sym_stack = reinterpret_cast<Value*> (realloc(sym_stack, stack_size * sizeof(Value)));
    state_stack = reinterpret_cast<int*> (realloc(state_stack, stack_size * sizeof(int)));
    location_stack = reinterpret_cast<SourceLocation*> (realloc(location_stack, stack_size * sizeof(SourceLocation)));
    string_stack.resize(stack_size);
    rawString_stack.resize(stack_size);
}

Parser::Parser(Engine *engine):
    driver(engine),
    pool(engine->pool())
{
}

Parser::~Parser()
{
    if (stack_size) {
        free(sym_stack);
        free(state_stack);
        free(location_stack);
    }
}

static inline SourceLocation location(Lexer *lexer)
{
    SourceLocation loc;
    loc.offset = lexer->tokenOffset();
    loc.length = lexer->tokenLength();
    loc.startLine = lexer->tokenStartLine();
    loc.startColumn = lexer->tokenStartColumn();
    return loc;
}

AST::UiQualifiedId *Parser::reparseAsQualifiedId(AST::ExpressionNode *expr)
{
    QVarLengthArray<QStringView, 4> nameIds;
    QVarLengthArray<SourceLocation, 4> locations;
    QVarLengthArray<SourceLocation, 4> dotLocations;

    AST::ExpressionNode *it = expr;
    while (AST::FieldMemberExpression *m = AST::cast<AST::FieldMemberExpression *>(it)) {
        nameIds.append(m->name);
        locations.append(m->identifierToken);
        dotLocations.append(m->dotToken);
        it = m->base;
    }

    if (AST::IdentifierExpression *idExpr = AST::cast<AST::IdentifierExpression *>(it)) {
        AST::UiQualifiedId *q = new (pool) AST::UiQualifiedId(idExpr->name);
        q->identifierToken = idExpr->identifierToken;

        AST::UiQualifiedId *currentId = q;
        for (int i = nameIds.size() - 1; i != -1; --i) {
            currentId = new (pool) AST::UiQualifiedId(currentId, nameIds[i]);
            currentId->identifierToken = locations[i];
            currentId->dotToken = dotLocations[i];
        }

        return currentId->finish();
    }

    return 0;
}

void Parser::pushToken(int token)
{
    Q_ASSERT(last_token);
    Q_ASSERT(last_token < &token_buffer[TOKEN_BUFFER_SIZE]);
    last_token->token = yytoken;
    last_token->dval = yylval;
    last_token->spell = yytokenspell;
    last_token->raw = yytokenraw;
    last_token->loc = yylloc;
    ++last_token;
    yytoken = token;
}

void Parser::pushTokenWithEmptyLocation(int token)
{
    pushToken(token);
    yylloc = yyprevlloc;
    yylloc.offset += yylloc.length;
    yylloc.startColumn += yylloc.length;
    yylloc.length = 0;
}

int Parser::lookaheadToken(Lexer *lexer)
{
    if (yytoken < 0) {
        yyprevtoken = yytoken;
        yytoken = lexer->lex();
        yylval = lexer->tokenValue();
        yytokenspell = lexer->tokenSpell();
        yytokenraw = lexer->rawString();
        yylloc = location(lexer);
    }
    return yytoken;
}

bool Parser::ensureNoFunctionTypeAnnotations(AST::TypeAnnotation *returnValueAnnotation, AST::FormalParameterList *formals)
{
    // Type annotations are allowed everywhere in QML code.
    if (driver->lexer()->qmlMode())
        return true;

    for (auto formal = formals; formal; formal = formal->next) {
        if (formal->element && formal->element->typeAnnotation) {
            syntaxError(formal->element->typeAnnotation->firstSourceLocation(), "Type annotations are not permitted in function parameters in JavaScript functions");
            return false;
        }
    }
    if (returnValueAnnotation) {
        syntaxError(returnValueAnnotation->firstSourceLocation(), "Type annotations are not permitted for the return value of JavaScript functions");
        return false;
    }
    return true;
}

//#define PARSER_DEBUG

bool Parser::parse(int startToken)
{
    Lexer *lexer = driver->lexer();

    if (auto diagnosticMessage = lexer->illegalFileLengthError()) {
        diagnostic_messages.append(*diagnosticMessage);
        return false;
    }

    bool hadErrors = false;
    yytoken = -1;
    int action = 0;

    token_buffer[0].token = startToken;
    first_token = &token_buffer[0];
    if (startToken == T_FEED_JS_SCRIPT && !lexer->qmlMode()) {
        Directives ignoreDirectives;
        Directives *directives = driver->directives();
        if (!directives)
            directives = &ignoreDirectives;
        DiagnosticMessage error;
        if (!lexer->scanDirectives(directives, &error)) {
            diagnostic_messages.append(error);
            return false;
        }
        token_buffer[1].token = lexer->tokenKind();
        token_buffer[1].dval = lexer->tokenValue();
        token_buffer[1].loc = location(lexer);
        token_buffer[1].spell = lexer->tokenSpell();
        last_token = &token_buffer[2];
    } else {
        last_token = &token_buffer[1];
    }

    tos = -1;
    program = 0;

    do {
        if (++tos == stack_size)
            reallocateStack();

        state_stack[tos] = action;

    _Lcheck_token:
        if (yytoken == -1 && -TERMINAL_COUNT != action_index[action]) {
            yyprevlloc = yylloc;

            if (first_token == last_token) {
                yytoken = lexer->lex();
                yylval = lexer->tokenValue();
                yytokenspell = lexer->tokenSpell();
                yytokenraw = lexer->rawString();
                yylloc = location(lexer);
            } else {
                yytoken = first_token->token;
                yylval = first_token->dval;
                yytokenspell = first_token->spell;
                yytokenraw = first_token->raw;
                yylloc = first_token->loc;
                ++first_token;
                if (first_token == last_token)
                    first_token = last_token = &token_buffer[0];
            }
        }

#ifdef PARSER_DEBUG
       qDebug() << "   in state" << action;
#endif

        action = t_action(action, yytoken);
#ifdef PARSER_DEBUG
       qDebug() << "   current token" << yytoken << (yytoken >= 0 ? spell[yytoken] : "(null)") << "new state" << action;
#endif
        if (action > 0) {
            if (action != ACCEPT_STATE) {
                yyprevtoken = yytoken;
                yytoken = -1;
                sym(1).dval = yylval;
                stringRef(1) = yytokenspell;
                rawStringRef(1) = yytokenraw;
                loc(1) = yylloc;
            } else {
              --tos;
              return ! hadErrors;
            }
        } else if (action < 0) {
          const int r = -action - 1;
          tos -= rhs[r];

#ifdef PARSER_DEBUG
          qDebug() << "        reducing through rule " << -action;
#endif

          switch (r) {

#line 692 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 0: {
        sym(1).Node = sym(2).Node;
        program = sym(1).Node;
    } break;

#line 700 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 1: {
        sym(1).Node = sym(2).Node;
        program = sym(1).Node;
    } break;

#line 708 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 2: {
        sym(1).Node = sym(2).Node;
        program = sym(1).Node;
    } break;

#line 716 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 3: {
        sym(1).Node = sym(2).Node;
        program = sym(1).Node;
    } break;

#line 724 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 4: {
        sym(1).Node = sym(2).Node;
        program = sym(1).Node;
    } break;

#line 732 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 5: {
        sym(1).Node = sym(2).Node;
        program = sym(1).Node;
    } break;

#line 741 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 6: {
        sym(1).UiProgram = new (pool) AST::UiProgram(sym(1).UiHeaderItemList, sym(2).UiObjectMemberList->finish());
    } break;

#line 749 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 8: {
        sym(1).Node = sym(1).UiHeaderItemList->finish();
    } break;

#line 756 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 9: {
        sym(1).Node = new (pool) AST::UiHeaderItemList(sym(1).UiPragma);
    } break;

#line 763 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 10: {
        sym(1).Node = new (pool) AST::UiHeaderItemList(sym(1).UiImport);
    } break;

#line 770 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 11: {
        sym(1).Node = new (pool) AST::UiHeaderItemList(sym(1).UiHeaderItemList, sym(2).UiPragma);
    } break;

#line 777 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 12: {
        sym(1).Node = new (pool) AST::UiHeaderItemList(sym(1).UiHeaderItemList, sym(2).UiImport);
    } break;

#line 791 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 18: {
        AST::UiPragmaValueList *list
            = new (pool) AST::UiPragmaValueList(stringRef(1));
        list->location = loc(1);
        sym(1).Node = list;
    } break;

#line 801 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 19: {
        AST::UiPragmaValueList *list
            = new (pool) AST::UiPragmaValueList(sym(1).UiPragmaValueList, stringRef(3));
        list->location = loc(3);
        sym(1).Node = list;
    } break;

#line 811 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 20: {
        AST::UiPragma *pragma = new (pool) AST::UiPragma(stringRef(2));
        pragma->pragmaToken = loc(1);
        pragma->pragmaIdToken = loc(2);
        pragma->semicolonToken = loc(3);
        sym(1).Node = pragma;
    } break;

#line 822 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 21: {
        AST::UiPragma *pragma = new (pool) AST::UiPragma(
                stringRef(2), sym(4).UiPragmaValueList->finish());
        pragma->pragmaToken = loc(1);
        pragma->pragmaIdToken = loc(2);
        pragma->colonToken = loc(3);
        pragma->semicolonToken = loc(5);
        sym(1).Node = pragma;
    } break;

#line 837 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 23: {
        sym(1).UiImport->semicolonToken = loc(2);
    } break;

#line 844 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 24: {
        const int major = sym(1).dval;
        const int minor = sym(3).dval;
        if (!QTypeRevision::isValidSegment(major) || !QTypeRevision::isValidSegment(minor)) {
            diagnostic_messages.append(
                    compileError(loc(1),
                    QLatin1String("Invalid version. Version numbers must be >= 0 and < 255.")));
            return false;
        }
        auto version = new (pool) AST::UiVersionSpecifier(major, minor);
        version->majorToken = loc(1);
        version->minorToken = loc(3);
        sym(1).UiVersionSpecifier = version;
    } break;

#line 863 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 25: {
        const int major = sym(1).dval;
        if (!QTypeRevision::isValidSegment(major)) {
            diagnostic_messages.append(
                    compileError(loc(1),
                    QLatin1String("Invalid major version. Version numbers must be >= 0 and < 255.")));
            return false;
        }
        auto version = new (pool) AST::UiVersionSpecifier(sym(1).dval);
        version->majorToken = loc(1);
        sym(1).UiVersionSpecifier = version;
    } break;

#line 879 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 26: {
        sym(1).UiImport->version = sym(2).UiVersionSpecifier;
        sym(1).UiImport->semicolonToken = loc(3);
    } break;

#line 887 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 27: {
        sym(1).UiImport->version = sym(2).UiVersionSpecifier;
        sym(1).UiImport->asToken = loc(3);
        sym(1).UiImport->importIdToken = loc(4);
        sym(1).UiImport->importId = stringRef(4);
        sym(1).UiImport->semicolonToken = loc(5);
    } break;

#line 898 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 28: {
        sym(1).UiImport->asToken = loc(2);
        sym(1).UiImport->importIdToken = loc(3);
        sym(1).UiImport->importId = stringRef(3);
        sym(1).UiImport->semicolonToken = loc(4);
    } break;

#line 908 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 29: {
        AST::UiImport *node = 0;

        if (AST::StringLiteral *importIdLiteral = AST::cast<AST::StringLiteral *>(sym(2).Expression)) {
            node = new (pool) AST::UiImport(importIdLiteral->value);
            node->fileNameToken = loc(2);
        } else if (AST::UiQualifiedId *qualifiedId = reparseAsQualifiedId(sym(2).Expression)) {
            node = new (pool) AST::UiImport(qualifiedId);
            node->fileNameToken = loc(2);
        }

        sym(1).Node = node;

        if (node) {
            node->importToken = loc(1);
        } else {
            diagnostic_messages.append(compileError(loc(1),
             QLatin1String("Expected a qualified name id or a string literal")));

            return false; // ### remove me
        }
    } break;

#line 934 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 30: {
        sym(1).Node = nullptr;
    } break;

#line 941 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 31: {
        sym(1).Node = new (pool) AST::UiObjectMemberList(sym(1).UiObjectMember);
    } break;

#line 948 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 32: {
        AST::IdentifierExpression *node = new (pool) AST::IdentifierExpression(stringRef(1));
        node->identifierToken = loc(1);
        sym(1).Node = node;
    } break;

#line 957 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 33: {
        AST::FieldMemberExpression *node = new (pool) AST::FieldMemberExpression(sym(1).Expression, stringRef(3));
        node->dotToken = loc(2);
        node->identifierToken = loc(3);
        sym(1).Node = node;
    } break;

#line 967 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 34: {
        if (AST::UiQualifiedId *qualifiedId = reparseAsQualifiedId(sym(1).Expression)) {
            sym(1).UiQualifiedId = qualifiedId;
        } else {
            sym(1).UiQualifiedId = 0;

            diagnostic_messages.append(compileError(loc(1),
            QLatin1String("Expected a qualified name id")));

            return false;
        }
        AST::UiAnnotation *node = new (pool) AST::UiAnnotation(sym(1).UiQualifiedId, sym(2).UiObjectInitializer);
        sym(1).Node = node;
    } break;

#line 985 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

case 35: {
    sym(1).Node = sym(2).Node;
} break;

#line 993 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 36: {
        sym(1).Node = new (pool) AST::UiAnnotationList(sym(1).UiAnnotation);
    } break;

#line 1000 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 37: {
        AST::UiAnnotationList *node = new (pool) AST::UiAnnotationList(sym(1).UiAnnotationList, sym(2).UiAnnotation);
        sym(1).Node = node;
    } break;

#line 1008 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

   case 38: {
       AST::UiObjectDefinition *node = sym(2).UiObjectDefinition;
       node->annotations = sym(1).UiAnnotationList->finish();
       sym(1).Node = node;
   } break;

#line 1019 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 40: {
        sym(1).Node = new (pool) AST::UiObjectMemberList(sym(1).UiObjectMember);
    } break;

#line 1026 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 41: {
        AST::UiObjectMemberList *node = new (pool) AST:: UiObjectMemberList(sym(1).UiObjectMemberList, sym(2).UiObjectMember);
        sym(1).Node = node;
    } break;

#line 1034 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 42: {
        sym(1).Node = new (pool) AST::UiArrayMemberList(sym(1).UiObjectMember);
    } break;

#line 1041 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 43: {
        AST::UiArrayMemberList *node = new (pool) AST::UiArrayMemberList(sym(1).UiArrayMemberList, sym(3).UiObjectMember);
        node->commaToken = loc(2);
        sym(1).Node = node;
    } break;

#line 1050 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 44: {
        AST::UiObjectInitializer *node = new (pool) AST::UiObjectInitializer((AST::UiObjectMemberList*)0);
        node->lbraceToken = loc(1);
        node->rbraceToken = loc(2);
        sym(1).Node = node;
    } break;

#line 1060 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 45: {
        AST::UiObjectInitializer *node = new (pool) AST::UiObjectInitializer(sym(2).UiObjectMemberList->finish());
        node->lbraceToken = loc(1);
        node->rbraceToken = loc(3);
        sym(1).Node = node;
    } break;

#line 1070 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 46: {
        AST::UiObjectDefinition *node = new (pool) AST::UiObjectDefinition(sym(1).UiQualifiedId, sym(2).UiObjectInitializer);
        sym(1).Node = node;
    } break;

#line 1078 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

   case 47: {
       AST::UiObjectMember *node = sym(2).UiObjectMember;
       node->annotations = sym(1).UiAnnotationList->finish();
       sym(1).Node = sym(2).Node;
   } break;

#line 1094 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 52: {
        AST::UiArrayBinding *node = new (pool) AST::UiArrayBinding(sym(1).UiQualifiedId, sym(5).UiArrayMemberList->finish());
        node->colonToken = loc(2);
        node->lbracketToken = loc(4);
        node->rbracketToken = loc(7);
        sym(1).Node = node;
    } break;

#line 1105 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 53: {
        AST::UiObjectBinding *node = new (pool) AST::UiObjectBinding(
            sym(1).UiQualifiedId, sym(4).UiQualifiedId, sym(5).UiObjectInitializer);
        node->colonToken = loc(2);
        sym(1).Node = node;
    } break;

#line 1115 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 54: {
        AST::UiObjectBinding *node = new (pool) AST::UiObjectBinding(
          sym(3).UiQualifiedId, sym(1).UiQualifiedId, sym(4).UiObjectInitializer);
        node->colonToken = loc(2);
        node->hasOnToken = true;
        sym(1).Node = node;
    } break;

#line 1127 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 55: {
        AST::ObjectPattern *l = new (pool) AST::ObjectPattern(sym(3).PatternPropertyList->finish());
        l->lbraceToken = loc(1);
        l->rbraceToken = loc(4);
        AST::ExpressionStatement *node = new (pool) AST::ExpressionStatement(l);
        node->semicolonToken = loc(5);
        sym(1).Node = node;
    } break;

#line 1140 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 56: {
        AST::ObjectPattern *l = new (pool) AST::ObjectPattern(sym(3).PatternPropertyList->finish());
        l->lbraceToken = loc(1);
        l->rbraceToken = loc(5);
        AST::ExpressionStatement *node = new (pool) AST::ExpressionStatement(l);
        node->semicolonToken = loc(6);
        sym(1).Node = node;
    } break;

#line 1153 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 57: Q_FALLTHROUGH(); 
#line 1155 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 58: Q_FALLTHROUGH(); 
#line 1157 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 59: {
        sym(1).Node = sym(3).Node;
    } break;

#line 1165 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 60: Q_FALLTHROUGH(); 
#line 1167 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 61: Q_FALLTHROUGH(); 
#line 1169 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 62: Q_FALLTHROUGH(); 
#line 1171 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 63: Q_FALLTHROUGH(); 
#line 1173 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 64: Q_FALLTHROUGH(); 
#line 1175 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 65: {
        sym(1).Node = sym(2).Node;
    } break;

#line 1182 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

case 66:
{
    AST::UiScriptBinding *node = new (pool) AST::UiScriptBinding(sym(1).UiQualifiedId, sym(3).Statement);
    node->colonToken = loc(2);
    sym(1).Node = node;
    } break;

#line 1192 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 67: {
    if (!m_incompleteBindingsEnabled) {
        diagnostic_messages.append(compileError(loc(1), QLatin1String("Incomplete binding, expected token `:` or `{`")));
        return false;
    }
    AST::EmptyStatement *statement = new (pool) AST::EmptyStatement;
    statement->semicolonToken = loc(2);
    AST::UiScriptBinding *node = new (pool) AST::UiScriptBinding(sym(1).UiQualifiedId, statement);
    sym(1).Node = node;
    } break;

#line 1206 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 68: Q_FALLTHROUGH(); 
#line 1208 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 69: Q_FALLTHROUGH(); 
#line 1210 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 70: {
        AST::UiQualifiedId *node = new (pool) AST::UiQualifiedId(stringRef(1));
        node->identifierToken = loc(1);
        sym(1).Node = node;
    } break;

#line 1219 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 71: {
        AST::UiQualifiedId *node = new (pool) AST::UiQualifiedId(sym(1).UiQualifiedId, stringRef(3));
        node->identifierToken = loc(3);
        sym(1).Node = node;
    } break;

#line 1228 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 72: {
        sym(1).Node = nullptr;
    } break;

#line 1235 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 73: {
        sym(1).Node = sym(1).UiParameterList->finish();
    } break;

#line 1242 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 74: {
        AST::UiParameterList *node = new (pool) AST::UiParameterList(sym(3).Type, stringRef(1));
        node->identifierToken = loc(1);
        node->colonToken = loc(2);
        node->propertyTypeToken = loc(3);
        sym(1).Node = node;
    } break;

#line 1253 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 75: {
        AST::UiParameterList *node = new (pool) AST::UiParameterList(sym(1).Type, stringRef(2));
        node->propertyTypeToken = loc(1);
        node->identifierToken = loc(2);
        sym(1).Node = node;
    } break;

#line 1263 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 76: {
        AST::UiParameterList *node = new (pool) AST::UiParameterList(sym(1).UiParameterList, sym(5).Type, stringRef(3));
        node->propertyTypeToken = loc(5);
        node->commaToken = loc(2);
        node->identifierToken = loc(3);
        node->colonToken = loc(4);
        sym(1).Node = node;
    } break;

#line 1275 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 77: {
        AST::UiParameterList *node = new (pool) AST::UiParameterList(sym(1).UiParameterList, sym(3).Type, stringRef(4));
        node->propertyTypeToken = loc(3);
        node->commaToken = loc(2);
        node->identifierToken = loc(4);
        sym(1).Node = node;
    } break;

#line 1286 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 78: {
        AST::UiPublicMember *node = new (pool) AST::UiPublicMember(nullptr, stringRef(2));
        node->type = AST::UiPublicMember::Signal;
        node->setPropertyToken(loc(1));
        node->typeToken = loc(2);
        node->identifierToken = loc(2);
        node->lparenToken = loc(3);
        node->parameters = sym(4).UiParameterList;
        node->rparenToken = loc(5);
        node->semicolonToken = loc(6);
        sym(1).Node = node;
    } break;

#line 1302 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 79: {
        AST::UiPublicMember *node = new (pool) AST::UiPublicMember(nullptr, stringRef(2));
        node->type = AST::UiPublicMember::Signal;
        node->setPropertyToken(loc(1));
        node->typeToken = loc(2);
        node->identifierToken = loc(2);
        node->semicolonToken = loc(3);
        sym(1).Node = node;
    } break;

#line 1331 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 86: {
        AST::UiPropertyAttributes *node = sym(2).UiPropertyAttributes;
        if (node->isRequired())
            diagnostic_messages.append(compileError(node->requiredToken(), QLatin1String("Duplicated 'required' attribute is not allowed."), QtCriticalMsg));
        node->m_requiredToken = loc(1);
        sym(1).UiPropertyAttributes = node;
    } break;

#line 1342 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 87: {
        AST::UiPropertyAttributes *node = sym(2).UiPropertyAttributes;
        if (node->isDefaultMember())
            diagnostic_messages.append(compileError(node->requiredToken(), QLatin1String("Duplicated 'default' attribute is not allowed."), QtCriticalMsg));
        node->m_defaultToken = loc(1);
        sym(1).UiPropertyAttributes = node;
    } break;

#line 1353 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 88: {
        AST::UiPropertyAttributes *node = sym(2).UiPropertyAttributes;
        if (node->isReadonly())
            diagnostic_messages.append(compileError(node->requiredToken(), QLatin1String("Duplicated 'readonly' attribute is not allowed."), QtCriticalMsg));
        node->m_readonlyToken = loc(1);
        sym(1).UiPropertyAttributes = node;
    } break;

#line 1364 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 89: {
        AST::UiPropertyAttributes *node = sym(2).UiPropertyAttributes;
        if (node->isFinal())
            syntaxError(node->finalToken(), "Duplicated 'final' attribute is not allowed.");
        node->m_finalToken = loc(1);
        if (node->isVirtual()) {
            syntaxError(node->virtualToken(), "The 'virtual' cannot be combined with 'final', as these attributes are mutually exclusive");
        }
        if (node->isOverride()) {
            syntaxError(node->overrideToken(), "'override' is redundant when a property is marked as 'final'");
        }
        sym(1).UiPropertyAttributes = node;
    } break;

#line 1381 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 90: {
        AST::UiPropertyAttributes *node = sym(2).UiPropertyAttributes;
        if (node->isVirtual())
            syntaxError(node->virtualToken(), "Duplicated 'virtual' attribute is not allowed.");
        if (node->isOverride()) {
            syntaxError(loc(1), "'virtual' is redundant when overriding a property. The 'override' "
            "must only be used when actually overriding an existing property; using it on a "
            "new property is an error.");
        }
        if (node->isFinal()) {
            syntaxError(loc(1), "The 'virtual' cannot be combined with 'final', as these attributes are mutually exclusive");
        }
        node->m_virtualToken = loc(1);
        sym(1).UiPropertyAttributes = node;
    } break;

#line 1400 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 91: {
        AST::UiPropertyAttributes *node = sym(2).UiPropertyAttributes;
        if (node->isOverride())
            syntaxError(node->overrideToken(), "Duplicated 'override' attribute is not allowed.");
        if (node->isVirtual()) {
            syntaxError(node->virtualToken(), "'virtual' is redundant when overriding a property. The 'override' "
            "must only be used when actually overriding an existing property; using it on a "
            "new property is an error.");
        }
        if (node->isFinal()) {
            syntaxError(loc(1), "'override' is redundant when a property is marked as 'final'");
        }
        node->m_overrideToken = loc(1);
        sym(1).UiPropertyAttributes = node;
    } break;

#line 1419 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 92: {
        AST::UiPropertyAttributes *node = new (pool) AST::UiPropertyAttributes();
        node->m_propertyToken = loc(1);
        sym(1).UiPropertyAttributes = node;
    } break;

#line 1428 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 93: {
        AST::UiPublicMember *node = new (pool) AST::UiPublicMember(sym(4).UiQualifiedId->finish(), stringRef(6));
        auto attributes = sym(1).UiPropertyAttributes;
        node->setAttributes(attributes);
        if (attributes->isReadonly())
            diagnostic_messages.append(compileError(attributes->readonlyToken(), QLatin1String("Read-only properties require an initializer."), QtWarningMsg));
        node->typeModifier = stringRef(2);
        node->typeModifierToken = loc(2);
        node->typeToken = loc(4);
        node->identifierToken = loc(6);
        node->semicolonToken = loc(7);
        sym(1).Node = node;
    } break;

#line 1447 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 95: {
        AST::UiPublicMember *node = new (pool) AST::UiPublicMember(sym(2).UiQualifiedId->finish(), stringRef(3));
        auto attributes = sym(1).UiPropertyAttributes;
        if (attributes->isReadonly())
            diagnostic_messages.append(compileError(attributes->readonlyToken(), QLatin1String("Read-only properties require an initializer."), QtCriticalMsg));
        node->setAttributes(attributes);
        node->typeToken = loc(2);
        node->identifierToken = loc(3);
        node->semicolonToken = loc(4);
        sym(1).Node = node;
    } break;

#line 1465 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

/* we need OptionalSemicolon because UiScriptStatement might already parse the last semicolon
  and then we would miss a semicolon (see tests/auto/quick/qquickvisualdatamodel/data/objectlist.qml)*/
 
#line 1471 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 99: {
        AST::UiRequired *node = new (pool) AST::UiRequired(stringRef(2));
        node->requiredToken = loc(1);
        node->semicolonToken = loc(3);
        sym(1).Node = node;
    } break;

#line 1483 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 101: {
        AST::UiPublicMember *node = new (pool) AST::UiPublicMember(sym(2).UiQualifiedId->finish(), stringRef(3), sym(5).Statement);
        auto attributes = sym(1).UiPropertyAttributes;
        if (attributes->isRequired())
            diagnostic_messages.append(compileError(attributes->requiredToken(), QLatin1String("Required properties with initializer do not make sense."), QtCriticalMsg));
        node->setAttributes(attributes);
        node->typeToken = loc(2);
        node->identifierToken = loc(3);
        node->colonToken = loc(4);
        sym(1).Node = node;
    } break;

#line 1498 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 102: {
        AST::UiPublicMember *node = new (pool) AST::UiPublicMember(sym(4).UiQualifiedId->finish(), stringRef(6), sym(8).Statement);
        node->typeModifier = stringRef(2);
        auto attributes = sym(1).UiPropertyAttributes;
        if (attributes->isRequired())
            diagnostic_messages.append(compileError(attributes->requiredToken(), QLatin1String("Required properties with initializer do not make sense."), QtCriticalMsg));
        node->setAttributes(attributes);
        node->typeModifierToken = loc(2);
        node->typeToken = loc(4);
        node->identifierToken = loc(6);
        node->colonToken = loc(7);
        sym(1).Node = node;
    } break;

#line 1517 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 104: {
        AST::UiPublicMember *node = new (pool) AST::UiPublicMember(sym(4).UiQualifiedId->finish(), stringRef(6));
        auto attributes = sym(1).UiPropertyAttributes;
        if (attributes->isRequired())
            diagnostic_messages.append(compileError(attributes->requiredToken(), QLatin1String("Required properties with initializer do not make sense."), QtCriticalMsg));
        node->setAttributes(attributes);
        node->typeModifier = stringRef(2);
        node->typeModifierToken = loc(2);
        node->typeToken = loc(4);
        node->identifierToken = loc(6);
        node->semicolonToken = loc(7); // insert a fake ';' before ':'
        node->colonToken = loc(7);

        AST::UiQualifiedId *propertyName = new (pool) AST::UiQualifiedId(stringRef(6));
        propertyName->identifierToken = loc(6);
        propertyName->next = nullptr;

        AST::UiArrayBinding *binding = new (pool) AST::UiArrayBinding(propertyName, sym(10).UiArrayMemberList->finish());
        binding->colonToken = loc(7);
        binding->lbracketToken = loc(9);
        binding->rbracketToken = loc(12);

        node->binding = binding;

        sym(1).Node = node;
    } break;

#line 1549 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 106: {
        AST::UiPublicMember *node = new (pool) AST::UiPublicMember(sym(2).UiQualifiedId->finish(), stringRef(3));
        auto attributes = sym(1).UiPropertyAttributes;
        if (attributes->isRequired())
            diagnostic_messages.append(compileError(attributes->requiredToken(), QLatin1String("Required properties with initializer do not make sense."), QtWarningMsg));
        node->setAttributes(attributes);
        node->typeToken = loc(2);
        node->identifierToken = loc(3);
        node->semicolonToken = loc(4); // insert a fake ';' before ':'
        node->colonToken = loc(4);

        AST::UiQualifiedId *propertyName = new (pool) AST::UiQualifiedId(stringRef(3));
        propertyName->identifierToken = loc(3);
        propertyName->next = nullptr;

        AST::UiObjectBinding *binding = new (pool) AST::UiObjectBinding(
          propertyName, sym(6).UiQualifiedId, sym(7).UiObjectInitializer);
        binding->colonToken = loc(4);

        node->binding = binding;

        sym(1).Node = node;
    } break;

#line 1578 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 108: {
        auto node = new (pool) AST::UiSourceElement(sym(1).Node);
        sym(1).Node = node;
    } break;

#line 1586 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 109: {
        sym(1).Node = new (pool) AST::UiSourceElement(sym(1).Node);
    } break;

#line 1593 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 110: {
        sym(1).Node = new (pool) AST::UiSourceElement(sym(1).Node);
    } break;

#line 1600 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 111: {
      if (AST::ArrayMemberExpression *mem = AST::cast<AST::ArrayMemberExpression *>(sym(1).Expression)) {
        diagnostic_messages.append(compileError(mem->lbracketToken,
          QLatin1String("Ignored annotation"), QtWarningMsg));

        sym(1).Expression = mem->base;
      }

      if (AST::UiQualifiedId *qualifiedId = reparseAsQualifiedId(sym(1).Expression)) {
        sym(1).UiQualifiedId = qualifiedId;
      } else {
        sym(1).UiQualifiedId = 0;

        diagnostic_messages.append(compileError(loc(1),
          QLatin1String("Expected a qualified name id")));

        return false; // ### recover
      }
    } break;

#line 1623 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 112: {
        AST::UiEnumDeclaration *enumDeclaration = new (pool) AST::UiEnumDeclaration(stringRef(2), sym(4).UiEnumMemberList->finish());
        enumDeclaration->enumToken = loc(1);
        enumDeclaration->identifierToken = loc(2);
        enumDeclaration->lbraceToken = loc(3);
        enumDeclaration->rbraceToken = loc(5);
        sym(1).Node = enumDeclaration;
        break;
    }

#line 1636 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 113: {
        if (!stringRef(2).front().isUpper()) {
            diagnostic_messages.append(compileError(loc(2),
                QLatin1String("Type name must be upper case"), QtWarningMsg));
        }
        auto inlineComponent = new (pool) AST::UiInlineComponent(stringRef(2), sym(4).UiObjectDefinition);
        inlineComponent->componentToken = loc(1);
        inlineComponent->identifierToken = loc(2);
        sym(1).Node = inlineComponent;
    } break;

#line 1650 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 114: {
        AST::UiEnumMemberList *node = new (pool) AST::UiEnumMemberList(stringRef(1));
        node->memberToken = loc(1);
        sym(1).Node = node;
        break;
    }

#line 1660 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 115: {
        AST::UiEnumMemberList *node = new (pool) AST::UiEnumMemberList(stringRef(1), sym(3).dval);
        node->memberToken = loc(1);
        node->valueToken = loc(3);
        sym(1).Node = node;
        break;
    }

#line 1672 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 116: {
        AST::UiEnumMemberList *node = new (pool) AST::UiEnumMemberList(stringRef(1), -sym(4).dval);
        node->memberToken = loc(1);
        node->valueToken = combine(loc(3), loc(4));
        sym(1).Node = node;
        break;
    }

#line 1683 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 117: {
        AST::UiEnumMemberList *node = new (pool) AST::UiEnumMemberList(sym(1).UiEnumMemberList, stringRef(3));
        node->commaToken = loc(2);
        node->memberToken = loc(3);
        sym(1).Node = node;
        break;
    }

#line 1694 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 118: {
        AST::UiEnumMemberList *node = new (pool) AST::UiEnumMemberList(sym(1).UiEnumMemberList, stringRef(3), sym(5).dval);
        node->commaToken = loc(2);
        node->memberToken = loc(3);
        node->equalToken = loc(4);
        node->valueToken = loc(5);
        sym(1).Node = node;
        break;
    }

#line 1708 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 119: {
        AST::UiEnumMemberList *node = new (pool) AST::UiEnumMemberList(sym(1).UiEnumMemberList, stringRef(3), -sym(6).dval);
        node->commaToken = loc(2);
        node->memberToken = loc(3);
        node->equalToken = loc(4);
        node->valueToken = combine(loc(5), loc(6));
        sym(1).Node = node;
        break;
    }

#line 1791 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 200: {
        sym(1).Type = new (pool) AST::Type(sym(1).UiQualifiedId, sym(3).Type);
        sym(1).Type->lAngleBracketToken = loc(2);
        sym(1).Type->rAngleBracketToken = loc(4);
    } break;

#line 1802 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 202: Q_FALLTHROUGH(); 
#line 1804 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 203: {
        AST::UiQualifiedId *id = new (pool) AST::UiQualifiedId(stringRef(1));
        id->identifierToken = loc(1);
        sym(1).Type = new (pool) AST::Type(id->finish());
    } break;

#line 1813 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 204: {
        sym(1).Type = new (pool) AST::Type(sym(1).UiQualifiedId);
    } break;

#line 1820 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 205: {
        sym(1).TypeAnnotation = new (pool) AST::TypeAnnotation(sym(2).Type);
        sym(1).TypeAnnotation->colonToken = loc(1);
    } break;

#line 1829 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 207: {
        sym(1).TypeAnnotation = nullptr;
    } break;

#line 1840 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 208: {
        AST::ThisExpression *node = new (pool) AST::ThisExpression();
        node->thisToken = loc(1);
        sym(1).Node = node;
    } break;

#line 1849 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 209: {
        AST::IdentifierExpression *node = new (pool) AST::IdentifierExpression(stringRef(1));
        node->identifierToken = loc(1);
        sym(1).Node = node;
    } break;

#line 1867 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 218: {
        if (coverExpressionType != CE_ParenthesizedExpression) {
            syntaxError(coverExpressionErrorLocation, "Expected token ')'.");
            return false;
        }
    } break;

#line 1878 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 219: {
        AST::NestedExpression *node = new (pool) AST::NestedExpression(sym(2).Expression);
        node->lparenToken = loc(1);
        node->rparenToken = loc(3);
        sym(1).Node = node;
        coverExpressionType = CE_ParenthesizedExpression;
    } break;

#line 1889 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 220: {
        AST::FunctionExpression *f = new (pool) AST::FunctionExpression(QStringView(), nullptr, nullptr);
        f->functionToken = loc(1).startZeroLengthLocation();
        f->lparenToken = loc(1);
        f->rparenToken = loc(2);
        sym(1).Node = f;
        coverExpressionErrorLocation = loc(2);
        coverExpressionType = CE_FormalParameterList;
    } break;

#line 1902 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 221: {
        AST::FormalParameterList *list = (new (pool) AST::FormalParameterList(nullptr, sym(2).PatternElement))->finish(pool);
        AST::FunctionExpression *f = new (pool) AST::FunctionExpression(QStringView(), list, nullptr);
        f->functionToken = loc(1).startZeroLengthLocation();
        f->lparenToken = loc(1);
        f->rparenToken = loc(3);
        sym(1).FunctionExpression = f;
        coverExpressionErrorLocation = loc(2);
        coverExpressionType = CE_FormalParameterList;
    } break;

#line 1916 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 222: {
        AST::FormalParameterList *list = sym(2).Expression->reparseAsFormalParameterList(pool);
        if (!list) {
            syntaxError(loc(1), "Invalid Arrow parameter list.");
            return false;
        }
        list->commaToken = loc(3);
        if (sym(4).Node) {
            list = new (pool) AST::FormalParameterList(list, sym(4).PatternElement);
        }

        AST::FunctionExpression *f = new (pool) AST::FunctionExpression(QStringView(), list->finish(pool), nullptr);
        f->functionToken = loc(1).startZeroLengthLocation();
        f->lparenToken = loc(1);
        f->rparenToken = loc(5);
        coverExpressionErrorLocation = loc(4);
        coverExpressionType = CE_FormalParameterList;
        sym(1).FunctionExpression = f;
    } break;

#line 1939 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 223: {
        AST::NullExpression *node = new (pool) AST::NullExpression();
        node->nullToken = loc(1);
        sym(1).Node = node;
    } break;

#line 1948 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 224: {
        AST::TrueLiteral *node = new (pool) AST::TrueLiteral();
        node->trueToken = loc(1);
        sym(1).Node = node;
    } break;

#line 1957 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 225: {
        AST::FalseLiteral *node = new (pool) AST::FalseLiteral();
        node->falseToken = loc(1);
        sym(1).Node = node;
    } break;

#line 1966 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 226: {
        AST::NumericLiteral *node = new (pool) AST::NumericLiteral(sym(1).dval);
        node->literalToken = loc(1);
        sym(1).Node = node;
    } break;

#line 1975 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 227: Q_FALLTHROUGH(); 
#line 1978 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 228: {
        AST::StringLiteral *node = new (pool) AST::StringLiteral(stringRef(1));
        node->literalToken = loc(1);
        sym(1).Node = node;
    } break;

#line 1990 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

{
    Lexer::RegExpBodyPrefix prefix;
    case 229:
        prefix = Lexer::NoPrefix;
        goto scan_regexp;

#line 2002 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 230:
        prefix = Lexer::EqualPrefix;
        goto scan_regexp;

    scan_regexp: {
        bool rx = lexer->scanRegExp(prefix);
        if (!rx) {
            diagnostic_messages.append(compileError(location(lexer), lexer->errorMessage()));
            return false;
        }

        loc(1).length = lexer->tokenLength();
        yylloc = loc(1); // adjust the location of the current token

        AST::RegExpLiteral *node = new (pool) AST::RegExpLiteral(driver->newStringRef(lexer->regExpPattern()), lexer->regExpFlags());
        node->literalToken = loc(1);
        sym(1).Node = node;
    } break;
}

#line 2026 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 231: {
        AST::PatternElementList *list = nullptr;
        if (sym(2).Elision)
            list = (new (pool) AST::PatternElementList(sym(2).Elision, nullptr))->finish();
        AST::ArrayPattern *node = new (pool) AST::ArrayPattern(list);
        node->lbracketToken = loc(1);
        node->rbracketToken = loc(3);
        sym(1).Node = node;
    } break;

#line 2039 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 232: {
        AST::ArrayPattern *node = new (pool) AST::ArrayPattern(sym(2).PatternElementList->finish());
        node->lbracketToken = loc(1);
        node->rbracketToken = loc(3);
        sym(1).Node = node;
    } break;

#line 2049 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 233: {
        auto *list = sym(2).PatternElementList;
        if (sym(4).Elision) {
            AST::PatternElementList *l = new (pool) AST::PatternElementList(sym(4).Elision, nullptr);
            l->commaToken = loc(3);
            list = list->append(l);
        }
        AST::ArrayPattern *node = new (pool) AST::ArrayPattern(list->finish());
        node->lbracketToken = loc(1);
        node->commaToken = loc(3);
        node->rbracketToken = loc(5);
        sym(1).Node = node;
        Q_ASSERT(node->isValidArrayLiteral());
    } break;

#line 2067 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 234: {
        auto *expression = sym(1).Expression;
        AST::PatternElement *e = new (pool) AST::PatternElement(expression);
        sym(1).Node = new (pool) AST::PatternElementList(nullptr, e);
        if (auto *be = expression->binaryExpressionCast(); be && be->op == QSOperator::Assign)
            e->equalToken = be->operatorToken;
    } break;

#line 2078 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 235: {
        auto *expression = sym(2).Expression;
        AST::PatternElement *e = new (pool) AST::PatternElement(expression);
        sym(1).Node = new (pool) AST::PatternElementList(sym(1).Elision->finish(), e);
        if (auto *be = expression->binaryExpressionCast(); be && be->op == QSOperator::Assign)
            e->equalToken = be->operatorToken;
    } break;

#line 2089 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 236: {
        AST::PatternElementList *node = new (pool) AST::PatternElementList(sym(1).Elision, sym(2).PatternElement);
        sym(1).Node = node;
    } break;

#line 2097 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 237: {
        auto *expression = sym(4).Expression;
        AST::PatternElement *e = new (pool) AST::PatternElement(expression);
        AST::PatternElementList *node = new (pool) AST::PatternElementList(sym(3).Elision, e);
        node->commaToken = loc(2);
        sym(1).Node = sym(1).PatternElementList->append(node);
        if (auto *be = expression->binaryExpressionCast(); be && be->op == QSOperator::Assign)
            e->equalToken = be->operatorToken;
    } break;

#line 2110 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 238: {
        AST::PatternElementList *node = new (pool) AST::PatternElementList(sym(3).Elision, sym(4).PatternElement);
        node->commaToken = loc(2);
        sym(1).Node = sym(1).PatternElementList->append(node);
    } break;

#line 2119 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 239: {
        AST::Elision *node = new (pool) AST::Elision();
        node->commaToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2128 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 240: {
        AST::Elision *node = new (pool) AST::Elision(sym(1).Elision);
        node->commaToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2137 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 241: {
        sym(1).Node = nullptr;
    } break;

#line 2144 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 242: {
        sym(1).Node = sym(1).Elision->finish();
    } break;

#line 2151 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 243: {
        auto *expression = sym(2).Expression;
        AST::PatternElement *node = new (pool) AST::PatternElement(expression, AST::PatternElement::SpreadElement);
        sym(1).Node = node;
        if (auto *be = expression->binaryExpressionCast(); be && be->op == QSOperator::Assign)
            node->equalToken = be->operatorToken;
    } break;

#line 2162 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 244: {
        AST::ObjectPattern *node = new (pool) AST::ObjectPattern();
        node->lbraceToken = loc(1);
        node->rbraceToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2172 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 245: {
        AST::ObjectPattern *node = new (pool) AST::ObjectPattern(sym(2).PatternPropertyList->finish());
        node->lbraceToken = loc(1);
        node->rbraceToken = loc(3);
        sym(1).Node = node;
    } break;

#line 2182 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 246: {
        AST::ObjectPattern *node = new (pool) AST::ObjectPattern(sym(2).PatternPropertyList->finish());
        node->lbraceToken = loc(1);
        node->rbraceToken = loc(4);
        sym(1).Node = node;
    } break;

#line 2193 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 247: Q_FALLTHROUGH(); 
#line 2195 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 248: {
      sym(1).Node = new (pool) AST::PatternPropertyList(sym(1).PatternProperty);
    } break;

#line 2202 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 249: Q_FALLTHROUGH(); 
#line 2204 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 250: {
        AST::PatternPropertyList *node = new (pool) AST::PatternPropertyList(sym(1).PatternPropertyList, sym(3).PatternProperty);
        sym(1).Node = node;
    } break;

#line 2212 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 251: {
        AST::IdentifierPropertyName *name = new (pool) AST::IdentifierPropertyName(stringRef(1));
        name->propertyNameToken = loc(1);
        AST::IdentifierExpression *expr = new (pool) AST::IdentifierExpression(stringRef(1));
        expr->identifierToken = loc(1);
        AST::PatternProperty *node = new (pool) AST::PatternProperty(name, expr);
        sym(1).Node = node;
    } break;

#line 2227 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 253: {
        AST::IdentifierPropertyName *name = new (pool) AST::IdentifierPropertyName(stringRef(1));
        name->propertyNameToken = loc(1);
        AST::IdentifierExpression *left = new (pool) AST::IdentifierExpression(stringRef(1));
        left->identifierToken = loc(1);
        // if initializer is an anonymous function expression, we need to assign identifierref as it's name
        if (auto *f = asAnonymousFunctionDefinition(sym(2).Expression))
            f->name = stringRef(1);
        if (auto *c = asAnonymousClassDefinition(sym(2).Expression))
            c->name = stringRef(1);
        AST::BinaryExpression *assignment = new (pool) AST::BinaryExpression(left, QSOperator::Assign, sym(2).Expression);
        assignment->operatorToken = loc(2);
        AST::PatternProperty *node = new (pool) AST::PatternProperty(name, assignment);
        sym(1).Node = node;

    } break;

#line 2247 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 254: Q_FALLTHROUGH(); 
#line 2249 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 255: {
        AST::PatternProperty *node = new (pool) AST::PatternProperty(sym(1).PropertyName, sym(3).Expression);
        if (auto *c = asAnonymousClassDefinition(sym(3).Expression)) {
            if (!AST::cast<AST::ComputedPropertyName *>(sym(1).PropertyName))
                c->name = driver->newStringRef(sym(1).PropertyName->asString());
        }
        node->colonToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2267 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 259: {
        AST::IdentifierPropertyName *node = new (pool) AST::IdentifierPropertyName(stringRef(1));
        node->propertyNameToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2276 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 260: Q_FALLTHROUGH(); 
#line 2278 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 261: {
        AST::StringLiteralPropertyName *node = new (pool) AST::StringLiteralPropertyName(stringRef(1));
        node->propertyNameToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2287 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 262: Q_FALLTHROUGH(); 
#line 2289 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 263: {
        AST::NumericLiteralPropertyName *node = new (pool) AST::NumericLiteralPropertyName(sym(1).dval);
        node->propertyNameToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2298 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 264: {
        AST::ComputedPropertyName *node = new (pool) AST::ComputedPropertyName(sym(2).Expression);
        node->propertyNameToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2307 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 265: Q_FALLTHROUGH(); 
#line 2309 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

case 266: {
    auto node = new (pool) AST::InitializerExpression(sym(2).Expression);
    node->equalToken = loc(1);
    sym(1).Expression = node;
} break;

#line 2319 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 267: Q_FALLTHROUGH(); 
#line 2321 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 268: {
        sym(1).Node = nullptr;
    } break;

#line 2331 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 271: {
        AST::TemplateLiteral *node = new (pool) AST::TemplateLiteral(stringRef(1), rawStringRef(1), nullptr);
        node->literalToken = loc(1);
        node->hasNoSubstitution = true;
        sym(1).Node = node;
    } break;

#line 2341 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 272: {
        AST::TemplateLiteral *node = new (pool) AST::TemplateLiteral(stringRef(1), rawStringRef(1), nullptr);
        node->literalToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2350 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 273: Q_FALLTHROUGH(); 
#line 2353 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 274: {
        AST::TemplateLiteral *node = new (pool) AST::TemplateLiteral(stringRef(1), rawStringRef(1), sym(2).Expression);
        node->next = sym(3).Template;
        node->literalToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2366 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 276: {
        AST::SuperLiteral *node = new (pool) AST::SuperLiteral();
        node->superToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2376 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 277: Q_FALLTHROUGH(); 
#line 2378 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 278: {
        AST::ArrayMemberExpression *node = new (pool) AST::ArrayMemberExpression(sym(1).Expression, sym(3).Expression);
        node->lbracketToken = loc(2);
        node->rbracketToken = loc(4);
        sym(1).Node = node;
    } break;

#line 2387 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 279: {
        AST::ArrayMemberExpression *node = new (pool) AST::ArrayMemberExpression(sym(1).Expression, sym(4).Expression);
        node->optionalToken = loc(2);
        node->lbracketToken = loc(3);
        node->rbracketToken = loc(5);
        node->isOptional = true;
        sym(1).Node = node;
    } break;

#line 2400 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 280:
    {
        AST::IdentifierExpression *node = new (pool) AST::IdentifierExpression(stringRef(1));
        node->identifierToken= loc(1);
        sym(1).Node = node;
    } Q_FALLTHROUGH();

#line 2408 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 281: Q_FALLTHROUGH(); 
#line 2410 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 282: {
        AST::FieldMemberExpression *node = new (pool) AST::FieldMemberExpression(sym(1).Expression, stringRef(3));
        node->dotToken = loc(2);
        node->identifierToken = loc(3);
        sym(1).Node = node;
    } break;

#line 2420 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 283: {
        AST::FieldMemberExpression *node = new (pool) AST::FieldMemberExpression(sym(1).Expression, stringRef(3));
        node->dotToken = loc(2);
        node->identifierToken = loc(3);
        node->isOptional = true;
        sym(1).Node = node;
    } break;

#line 2433 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 285: {
        AST::NewMemberExpression *node = new (pool) AST::NewMemberExpression(sym(2).Expression, sym(4).ArgumentList);
        node->newToken = loc(1);
        node->lparenToken = loc(3);
        node->rparenToken = loc(5);
        sym(1).Node = node;
    } break;

#line 2449 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 288: {
        AST::NewExpression *node = new (pool) AST::NewExpression(sym(2).Expression);
        node->newToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2459 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 289: Q_FALLTHROUGH(); 
#line 2461 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 290: {
        AST::TaggedTemplate *node = new (pool) AST::TaggedTemplate(sym(1).Expression, sym(2).Template);
        sym(1).Node = node;
    } break;

#line 2469 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 291: {
        AST::CallExpression *node = new (pool) AST::CallExpression(sym(1).Expression, sym(3).ArgumentList);
        node->lparenToken = loc(2);
        node->rparenToken = loc(4);
        sym(1).Node = node;
    } break;

#line 2479 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 292: {
        AST::CallExpression *node = new (pool) AST::CallExpression(sym(1).Expression, sym(4).ArgumentList);
        node->optionalToken = loc(2);
        node->lparenToken = loc(3);
        node->rparenToken = loc(5);
        node->isOptional = true;
        sym(1).Node = node;
    } break;

#line 2491 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 293: Q_FALLTHROUGH(); 
#line 2493 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 294: {
        AST::CallExpression *node = new (pool) AST::CallExpression(sym(1).Expression, sym(3).ArgumentList);
        node->lparenToken = loc(2);
        node->rparenToken = loc(4);
        sym(1).Node = node;
    } break;

#line 2503 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 295: {
        AST::CallExpression *node = new (pool) AST::CallExpression(sym(1).Expression, sym(4).ArgumentList);
        node->optionalToken = loc(2);
        node->lparenToken = loc(3);
        node->rparenToken = loc(5);
        node->isOptional = true;
        sym(1).Node = node;
    } break;

#line 2516 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 296: {
        AST::ArrayMemberExpression *node = new (pool) AST::ArrayMemberExpression(sym(1).Expression, sym(3).Expression);
        node->lbracketToken = loc(2);
        node->rbracketToken = loc(4);
        sym(1).Node = node;
    } break;

#line 2526 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 297: {
        AST::ArrayMemberExpression *node = new (pool) AST::ArrayMemberExpression(sym(1).Expression, sym(4).Expression);
        node->optionalToken = loc(2);
        node->lbracketToken = loc(3);
        node->rbracketToken = loc(5);
        node->isOptional = true;
        sym(1).Node = node;
    } break;

#line 2538 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 298: {
        AST::FieldMemberExpression *node = new (pool) AST::FieldMemberExpression(sym(1).Expression, stringRef(3));
        node->dotToken = loc(2);
        node->identifierToken = loc(3);
        sym(1).Node = node;
    } break;

#line 2548 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 299: {
        AST::FieldMemberExpression *node = new (pool) AST::FieldMemberExpression(sym(1).Expression, stringRef(3));
        node->dotToken = loc(2);
        node->identifierToken = loc(3);
        node->isOptional = true;
        sym(1).Node = node;
    } break;

#line 2559 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 300: {
        sym(1).Node = nullptr;
    } break;

#line 2566 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 301: Q_FALLTHROUGH(); 
#line 2568 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 302: {
        sym(1).Node = sym(1).ArgumentList->finish();
    } break;

#line 2575 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 303: {
        sym(1).Node = new (pool) AST::ArgumentList(sym(1).Expression);
    } break;

#line 2582 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 304: {
        AST::ArgumentList *node = new (pool) AST::ArgumentList(sym(2).Expression);
        node->isSpreadElement = true;
        sym(1).Node = node;
    } break;

#line 2591 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 305: {
        AST::ArgumentList *node = new (pool) AST::ArgumentList(sym(1).ArgumentList, sym(3).Expression);
        node->commaToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2600 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 306: {
        AST::ArgumentList *node = new (pool) AST::ArgumentList(sym(1).ArgumentList, sym(4).Expression);
        node->commaToken = loc(2);
        node->isSpreadElement = true;
        sym(1).Node = node;
    } break;

#line 2615 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 310: {
        AST::PostIncrementExpression *node = new (pool) AST::PostIncrementExpression(sym(1).Expression);
        node->incrementToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2624 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 311: {
        AST::PostDecrementExpression *node = new (pool) AST::PostDecrementExpression(sym(1).Expression);
        node->decrementToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2633 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 312: {
        AST::PreIncrementExpression *node = new (pool) AST::PreIncrementExpression(sym(2).Expression);
        node->incrementToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2642 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 313: {
        AST::PreDecrementExpression *node = new (pool) AST::PreDecrementExpression(sym(2).Expression);
        node->decrementToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2653 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 315: {
        AST::DeleteExpression *node = new (pool) AST::DeleteExpression(sym(2).Expression);
        node->deleteToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2662 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 316: {
        AST::VoidExpression *node = new (pool) AST::VoidExpression(sym(2).Expression);
        node->voidToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2671 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 317: {
        AST::TypeOfExpression *node = new (pool) AST::TypeOfExpression(sym(2).Expression);
        node->typeofToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2680 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 318: {
        AST::UnaryPlusExpression *node = new (pool) AST::UnaryPlusExpression(sym(2).Expression);
        node->plusToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2689 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 319: {
        AST::UnaryMinusExpression *node = new (pool) AST::UnaryMinusExpression(sym(2).Expression);
        node->minusToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2698 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 320: {
        AST::TildeExpression *node = new (pool) AST::TildeExpression(sym(2).Expression);
        node->tildeToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2707 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 321: {
        AST::NotExpression *node = new (pool) AST::NotExpression(sym(2).Expression);
        node->notToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2718 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 323: {
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, QSOperator::Exp, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2729 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 325: {
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, sym(2).ival, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2738 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 326: {
        sym(1).ival = QSOperator::Mul;
    } break;

#line 2745 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 327: {
        sym(1).ival = QSOperator::Div;
    } break;

#line 2752 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 328: {
        sym(1).ival = QSOperator::Mod;
    } break;

#line 2761 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 330: {
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, QSOperator::Add, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2770 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 331: {
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, QSOperator::Sub, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2781 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 333: {
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, QSOperator::LShift, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2790 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 334: {
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, QSOperator::RShift, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2799 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 335: {
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, QSOperator::URShift, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2811 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 338: Q_FALLTHROUGH(); 
#line 2813 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 339: {
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, sym(2).ival, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2822 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 340: {
        sym(1).ival = QSOperator::Lt;
    } break;

#line 2828 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 341: {
        sym(1).ival = QSOperator::Gt;
    } break;

#line 2834 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 342: {
        sym(1).ival = QSOperator::Le;
    } break;

#line 2840 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 343: {
        sym(1).ival = QSOperator::Ge;
    } break;

#line 2846 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 344: {
        sym(1).ival = QSOperator::InstanceOf;
    } break;

#line 2852 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 345: {
        sym(1).ival = QSOperator::As;
    } break;

#line 2859 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 346: {
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, QSOperator::In, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2871 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 349: Q_FALLTHROUGH(); 
#line 2873 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 350: {
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, sym(2).ival, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2882 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 351: {
        sym(1).ival = QSOperator::Equal;
    } break;

#line 2888 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 352: {
        sym(1).ival = QSOperator::NotEqual;
    } break;

#line 2894 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 353: {
        sym(1).ival = QSOperator::StrictEqual;
    } break;

#line 2900 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 354: {
        sym(1).ival = QSOperator::StrictNotEqual;
    } break;

#line 2911 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 357: Q_FALLTHROUGH(); 
#line 2913 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 358: {
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, QSOperator::BitAnd, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2926 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 361: Q_FALLTHROUGH(); 
#line 2928 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 362: {
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, QSOperator::BitXor, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2940 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 365: Q_FALLTHROUGH(); 
#line 2942 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 366: {
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, QSOperator::BitOr, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2954 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 369: Q_FALLTHROUGH(); 
#line 2956 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 370: {
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, QSOperator::And, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2968 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 373: Q_FALLTHROUGH(); 
#line 2970 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 374: {
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, QSOperator::Or, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2982 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 377: Q_FALLTHROUGH(); 
#line 2984 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 378: {

        auto *lhs = sym(1).Expression;
        auto *rhs = sym(3).Expression;

        // Check if lhs or rhs contain || or &&

        if (lhs->binaryExpressionCast() != nullptr) {
            auto *binaryExpr = lhs->binaryExpressionCast();
            if (binaryExpr->op == QSOperator::And || binaryExpr->op == QSOperator::Or) {
                syntaxError(binaryExpr->operatorToken, "Left-hand side may not contain || or &&");
                return false;
            }
        }

        if (rhs->binaryExpressionCast() != nullptr) {
            auto *binaryExpr = rhs->binaryExpressionCast();
            if (binaryExpr->op == QSOperator::And || binaryExpr->op == QSOperator::Or) {
                syntaxError(binaryExpr->operatorToken, "Right-hand side may not contain || or &&");
                return false;
            }
        }

        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(lhs, QSOperator::Coalesce, rhs);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 3018 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 381: Q_FALLTHROUGH(); 
#line 3020 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 382: {
        AST::ConditionalExpression *node = new (pool) AST::ConditionalExpression(sym(1).Expression, sym(3).Expression, sym(5).Expression);
        node->questionToken = loc(2);
        node->colonToken = loc(4);
        sym(1).Node = node;
    } break;

#line 3039 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 389: Q_FALLTHROUGH(); 
#line 3041 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 390: {
        if (sym(1).Expression->containsOptionalChain()) {
            syntaxError(loc(1), QStringLiteral("Optional chains are not permitted on the left-hand-side in assignments"));
        }
        // need to convert the LHS to an AssignmentPattern if it was an Array/ObjectLiteral
        if (AST::Pattern *p = sym(1).Expression->patternCast()) {
            SourceLocation errorLoc;
            QString errorMsg;
            if (!p->convertLiteralToAssignmentPattern(pool, &errorLoc, &errorMsg)) {
                syntaxError(errorLoc, errorMsg);
                return false;
            }
        }
        // if lhs is an identifier expression and rhs is an anonymous function expression, we need to assign the name of lhs to the function
        if (auto *f = asAnonymousFunctionDefinition(sym(3).Expression)) {
            if (auto *id = AST::cast<AST::IdentifierExpression *>(sym(1).Expression))
                f->name = id->name;
        }
        if (auto *c = asAnonymousClassDefinition(sym(3).Expression)) {
            if (auto *id = AST::cast<AST::IdentifierExpression *>(sym(1).Expression))
                c->name = id->name;
        }

        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, QSOperator::Assign, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 3072 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 391: Q_FALLTHROUGH(); 
#line 3074 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 392: {
        if (sym(1).Expression->containsOptionalChain()) {
            syntaxError(loc(1), QStringLiteral("Optional chains are not permitted on the left-hand-side in assignments"));
        }
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, sym(2).ival, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 3086 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 393: {
        sym(1).ival = QSOperator::InplaceMul;
    } break;

#line 3093 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 394: {
        sym(1).ival = QSOperator::InplaceExp;
    } break;

#line 3100 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 395: {
        sym(1).ival = QSOperator::InplaceDiv;
    } break;

#line 3107 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 396: {
        sym(1).ival = QSOperator::InplaceMod;
    } break;

#line 3114 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 397: {
        sym(1).ival = QSOperator::InplaceAdd;
    } break;

#line 3121 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 398: {
        sym(1).ival = QSOperator::InplaceSub;
    } break;

#line 3128 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 399: {
        sym(1).ival = QSOperator::InplaceLeftShift;
    } break;

#line 3135 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 400: {
        sym(1).ival = QSOperator::InplaceRightShift;
    } break;

#line 3142 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 401: {
        sym(1).ival = QSOperator::InplaceURightShift;
    } break;

#line 3149 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 402: {
        sym(1).ival = QSOperator::InplaceAnd;
    } break;

#line 3156 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 403: {
        sym(1).ival = QSOperator::InplaceXor;
    } break;

#line 3163 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 404: {
        sym(1).ival = QSOperator::InplaceOr;
    } break;

#line 3173 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 407: Q_FALLTHROUGH(); 
#line 3175 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 408: {
          AST::CommaExpression *node
                = new (pool) AST::CommaExpression(sym(1).Expression, sym(3).Expression);
          node->commaToken = loc(2);
          sym(1).Node = node;
    } break;

#line 3185 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 409: Q_FALLTHROUGH(); 
#line 3187 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 410: {
      sym(1).Node = nullptr;
    } break;

#line 3199 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 413: {
        sym(1).Node = sym(3).Node;
    } break;

#line 3206 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 414: Q_FALLTHROUGH(); 
#line 3208 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 415: Q_FALLTHROUGH(); 
#line 3210 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 416: Q_FALLTHROUGH(); 
#line 3212 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 417: Q_FALLTHROUGH(); 
#line 3214 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 418: Q_FALLTHROUGH(); 
#line 3216 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 419: Q_FALLTHROUGH(); 
#line 3218 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 420: Q_FALLTHROUGH(); 
#line 3220 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 421: Q_FALLTHROUGH(); 
#line 3222 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 422: Q_FALLTHROUGH(); 
#line 3224 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 423: Q_FALLTHROUGH(); 
#line 3226 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 424: Q_FALLTHROUGH(); 
#line 3228 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 425: Q_FALLTHROUGH(); 
#line 3230 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 426: {
        sym(1).Node = sym(2).Node;
    } break;

#line 3252 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 437: {
        AST::Block *node = new (pool) AST::Block(sym(2).StatementList);
        node->lbraceToken = loc(1);
        node->rbraceToken = loc(3);
        sym(1).Node = node;
    } break;

#line 3264 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 439: {
        sym(1).StatementList = sym(1).StatementList->append(sym(2).StatementList);
    } break;

#line 3271 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 440: {
        sym(1).StatementList = new (pool) AST::StatementList(sym(1).Statement);
    } break;

#line 3278 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 441: {
        sym(1).Node = new (pool) AST::StatementList(sym(3).FunctionDeclaration);
    } break;

#line 3285 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 442: {
        sym(1).Node = nullptr;
    } break;

#line 3292 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 443: {
        sym(1).Node = sym(1).StatementList->finish();
    } break;

#line 3299 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 444: {
        sym(1).scope = AST::VariableScope::Let;
    } break;

#line 3305 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 445: {
        sym(1).scope = AST::VariableScope::Const;
    } break;

#line 3312 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 446: {
        sym(1).scope = AST::VariableScope::Var;
    } break;

#line 3319 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 447: Q_FALLTHROUGH(); 
#line 3321 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 448: Q_FALLTHROUGH(); 
#line 3323 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 449: Q_FALLTHROUGH(); 
#line 3325 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 450: {
        AST::VariableDeclarationList *declarations = sym(2).VariableDeclarationList->finish(sym(1).scope);
        for (auto it = declarations; it; it = it->next) {
            if (it->declaration && it->declaration->typeAnnotation) {
                syntaxError(it->declaration->typeAnnotation->firstSourceLocation(), "Type annotations are not permitted in variable declarations");
                return false;
            }
        }
        AST::VariableStatement *node = new (pool) AST::VariableStatement(declarations);
        node->declarationKindToken = loc(1);
        sym(1).Node = node;
    } break;

#line 3343 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 452: Q_FALLTHROUGH(); 
#line 3345 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 453: Q_FALLTHROUGH(); 
#line 3347 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 454: Q_FALLTHROUGH(); 
#line 3349 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 455: {
  sym(1).Node = new (pool) AST::VariableDeclarationList(sym(1).PatternElement);
    } break;

#line 3356 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 456: Q_FALLTHROUGH(); 
#line 3358 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 457: Q_FALLTHROUGH(); 
#line 3360 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 458: Q_FALLTHROUGH(); 
#line 3362 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 459: {
        AST::VariableDeclarationList *node = new (pool) AST::VariableDeclarationList(sym(1).VariableDeclarationList, sym(3).PatternElement);
        node->commaToken = loc(2);
        sym(1).Node = node;
    } break;

#line 3371 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 460: Q_FALLTHROUGH(); 
#line 3373 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 461: Q_FALLTHROUGH(); 
#line 3375 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 462: Q_FALLTHROUGH(); 
#line 3377 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 463: {
        auto *node = new (pool) AST::PatternElement(stringRef(1), sym(2).TypeAnnotation, sym(3).Expression);
        node->identifierToken = loc(1);
        sym(1).Node = node;
        // if initializer is an anonymous function expression, we need to assign identifierref as it's name
        if (auto *f = asAnonymousFunctionDefinition(sym(3).Expression))
            f->name = stringRef(1);
        if (auto *c = asAnonymousClassDefinition(sym(3).Expression))
            c->name = stringRef(1);
    } break;

#line 3391 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 464: Q_FALLTHROUGH(); 
#line 3393 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 465: Q_FALLTHROUGH(); 
#line 3395 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 466: Q_FALLTHROUGH(); 
#line 3397 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 467: {
        auto *node = new (pool) AST::PatternElement(sym(1).Pattern, sym(2).Expression);
        node->identifierToken = loc(1);
        sym(1).Node = node;
    } break;

#line 3406 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 468: {
        auto *node = new (pool) AST::ObjectPattern(sym(2).PatternPropertyList);
        node->lbraceToken = loc(1);
        node->rbraceToken = loc(3);
        node->parseMode = AST::Pattern::Binding;
        sym(1).Node = node;
    } break;

#line 3417 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 469: {
        auto *node = new (pool) AST::ArrayPattern(sym(2).PatternElementList);
        node->lbracketToken = loc(1);
        node->rbracketToken = loc(3);
        node->parseMode = AST::Pattern::Binding;
        sym(1).Node = node;
    } break;

#line 3428 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 470: {
        sym(1).Node = nullptr;
    } break;

#line 3435 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
 case 471: 
#line 3437 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 472: {
        sym(1).Node = sym(1).PatternPropertyList->finish();
    } break;

#line 3444 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 473: {
        if (sym(1).Elision || sym(2).Node) {
            auto *l = new (pool) AST::PatternElementList(sym(1).Elision, sym(2).PatternElement);
            sym(1).Node = l->finish();
        } else {
            sym(1).Node = nullptr;
        }
    } break;

#line 3456 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 474: {
        sym(1).Node = sym(1).PatternElementList->finish();
    } break;

#line 3463 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 475: {
        if (sym(3).Elision || sym(4).Node) {
            auto *l = new (pool) AST::PatternElementList(sym(3).Elision, sym(4).PatternElement);
            l->commaToken = loc(2);
            l = sym(1).PatternElementList->append(l);
            sym(1).Node = l;
        }
        sym(1).Node = sym(1).PatternElementList->finish();
    } break;

#line 3476 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 476: {
        sym(1).Node = new (pool) AST::PatternPropertyList(sym(1).PatternProperty);
    } break;

#line 3483 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 477: {
        sym(1).Node = new (pool) AST::PatternPropertyList(sym(1).PatternPropertyList, sym(3).PatternProperty);
    } break;

#line 3492 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 479: {
        sym(1).PatternElementList = sym(1).PatternElementList->append(sym(3).PatternElementList);
        sym(3).PatternElementList->commaToken = loc(2);
    } break;

#line 3500 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 480: {
        sym(1).Node = new (pool) AST::PatternElementList(sym(1).Elision, sym(2).PatternElement);
    } break;

#line 3508 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 481: {
        AST::IdentifierPropertyName *name = new (pool) AST::IdentifierPropertyName(stringRef(1));
        name->propertyNameToken = loc(1);
        // if initializer is an anonymous function expression, we need to assign identifierref as it's name
        if (auto *f = asAnonymousFunctionDefinition(sym(2).Expression))
            f->name = stringRef(1);
        if (auto *c = asAnonymousClassDefinition(sym(2).Expression))
            c->name = stringRef(1);
        AST::PatternProperty *node = new (pool) AST::PatternProperty(name, stringRef(1), sym(2).Expression);
        sym(1).Node = node;
    } break;

#line 3523 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 482: {
        AST::PatternProperty *node = new (pool) AST::PatternProperty(sym(1).PropertyName, stringRef(3), sym(4).Expression);
        node->colonToken = loc(2);
        node->identifierToken = loc(3);
        sym(1).Node = node;
    } break;

#line 3533 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 483: {
        AST::PatternProperty *node = new (pool) AST::PatternProperty(sym(1).PropertyName, sym(3).Pattern, sym(4).Expression);
        node->colonToken = loc(2);
        sym(1).Node = node;
    } break;

#line 3542 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 484: {
      AST::PatternElement *node = new (pool) AST::PatternElement(stringRef(1), sym(2).TypeAnnotation, sym(3).Expression);
      node->identifierToken = loc(1);
      // if initializer is an anonymous function expression, we need to assign identifierref as it's name
      if (auto *f = asAnonymousFunctionDefinition(sym(3).Expression))
          f->name = stringRef(1);
      if (auto *c = asAnonymousClassDefinition(sym(3).Expression))
          c->name = stringRef(1);
      sym(1).Node = node;
    } break;

#line 3556 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 485: {
        AST::PatternElement *node = new (pool) AST::PatternElement(sym(1).Pattern, sym(2).Expression);
        sym(1).Node = node;
    } break;

#line 3564 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 486: {
        AST::PatternElement *node = new (pool) AST::PatternElement(stringRef(2), /*type annotation*/nullptr, nullptr, AST::PatternElement::RestElement);
        node->identifierToken = loc(2);
        sym(1).Node = node;
    } break;

#line 3573 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 487: {
        AST::PatternElement *node = new (pool) AST::PatternElement(sym(2).Pattern, nullptr, AST::PatternElement::RestElement);
        sym(1).Node = node;
    } break;

#line 3581 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 488: {
        sym(1).Node = nullptr;
    } break;

#line 3591 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 490: {
        AST::EmptyStatement *node = new (pool) AST::EmptyStatement();
        node->semicolonToken = loc(1);
        sym(1).Node = node;
    } break;

#line 3606 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 491: {
        int token = lookaheadToken(lexer);
        if (token == T_LBRACE)
            pushToken(T_FORCE_BLOCK);
        else if (token == T_FUNCTION || token == T_CLASS || token == T_LET || token == T_CONST)
            pushToken(T_FORCE_DECLARATION);
    } break;

#line 3617 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 492: {
        AST::ExpressionStatement *node = new (pool) AST::ExpressionStatement(sym(1).Expression);
        node->semicolonToken = loc(2);
        sym(1).Node = node;
    } break;

#line 3626 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 493: {
        AST::IfStatement *node = new (pool) AST::IfStatement(sym(3).Expression, sym(5).Statement, sym(7).Statement);
        node->ifToken = loc(1);
        node->lparenToken = loc(2);
        node->rparenToken = loc(4);
        node->elseToken = loc(6);
        sym(1).Node = node;
    } break;

#line 3638 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 494: {
        AST::IfStatement *node = new (pool) AST::IfStatement(sym(3).Expression, sym(5).Statement);
        node->ifToken = loc(1);
        node->lparenToken = loc(2);
        node->rparenToken = loc(4);
        sym(1).Node = node;
    } break;

#line 3651 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 496: {
        AST::DoWhileStatement *node = new (pool) AST::DoWhileStatement(sym(2).Statement, sym(5).Expression);
        node->doToken = loc(1);
        node->whileToken = loc(3);
        node->lparenToken = loc(4);
        node->rparenToken = loc(6);
        node->semicolonToken = loc(7);
        sym(1).Node = node;
    } break;

#line 3664 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 497: {
        AST::WhileStatement *node = new (pool) AST::WhileStatement(sym(3).Expression, sym(5).Statement);
        node->whileToken = loc(1);
        node->lparenToken = loc(2);
        node->rparenToken = loc(4);
        sym(1).Node = node;
    } break;

#line 3675 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 498: {
        AST::ForStatement *node = new (pool) AST::ForStatement(sym(3).Expression, sym(5).Expression, sym(7).Expression, sym(9).Statement);
        node->forToken = loc(1);
        node->lparenToken = loc(2);
        node->firstSemicolonToken = loc(4);
        node->secondSemicolonToken = loc(6);
        node->rparenToken = loc(8);
        sym(1).Node = node;
    } break;

#line 3688 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 499: Q_FALLTHROUGH(); 
#line 3690 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 500: {
        // ### get rid of the static_cast!
        AST::ForStatement *node = new (pool) AST::ForStatement(
          static_cast<AST::VariableStatement *>(sym(3).Node)->declarations, sym(5).Expression,
          sym(7).Expression, sym(9).Statement);
        if (node->declarations) {
            AST::PatternElement *pe = node->declarations->declaration;
            pe->isForDeclaration = true;
            pe->declarationKindToken = loc(3);
        }
        node->forToken = loc(1);
        node->lparenToken = loc(2);
        node->firstSemicolonToken = loc(4);
        node->secondSemicolonToken = loc(6);
        node->rparenToken = loc(8);
        sym(1).Node = node;
    } break;

#line 3711 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 501: {
        sym(1).forEachType = AST::ForEachType::In;
    } break;

#line 3718 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 502: {
        sym(1).forEachType = AST::ForEachType::Of;
    } break;

#line 3725 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 503: {
        // need to convert the LHS to an AssignmentPattern if it was an Array/ObjectLiteral
        if (AST::Pattern *p = sym(3).Expression->patternCast()) {
            SourceLocation errorLoc;
            QString errorMsg;
            if (!p->convertLiteralToAssignmentPattern(pool, &errorLoc, &errorMsg)) {
                syntaxError(errorLoc, errorMsg);
                return false;
            }
        }
        AST::ForEachStatement *node = new (pool) AST::ForEachStatement(sym(3).Expression, sym(5).Expression, sym(7).Statement);
        node->forToken = loc(1);
        node->lparenToken = loc(2);
        node->inOfToken = loc(4);
        node->rparenToken = loc(6);
        node->type = sym(4).forEachType;
        sym(1).Node = node;
    } break;

#line 3747 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 504: {
        AST::ForEachStatement *node = new (pool) AST::ForEachStatement(sym(3).PatternElement, sym(5).Expression, sym(7).Statement);
        node->forToken = loc(1);
        node->lparenToken = loc(2);
        node->inOfToken = loc(4);
        node->rparenToken = loc(6);
        node->type = sym(4).forEachType;
        sym(1).Node = node;
    } break;

#line 3760 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 505: Q_FALLTHROUGH(); 
#line 3762 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 506: {
        if (auto typeAnnotation = sym(3).TypeAnnotation) {
            syntaxError(typeAnnotation->firstSourceLocation(), "Type annotations are not permitted in variable declarations");
            return false;
        }
        auto *node = new (pool) AST::PatternElement(stringRef(2), sym(3).TypeAnnotation, nullptr);
        node->identifierToken = loc(2);
        node->scope = sym(1).scope;
        node->isForDeclaration = true;
        node->declarationKindToken = loc(1);
        sym(1).Node = node;
    } break;

#line 3778 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 507: Q_FALLTHROUGH(); 
#line 3780 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 508: {
        auto *node = new (pool) AST::PatternElement(sym(2).Pattern, nullptr);
        node->scope = sym(1).scope;
        node->isForDeclaration = true;
        node->declarationKindToken = loc(1);
        sym(1).Node = node;
    } break;

#line 3791 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 509: {
        AST::ContinueStatement *node = new (pool) AST::ContinueStatement();
        node->continueToken = loc(1);
        node->semicolonToken = loc(2);
        sym(1).Node = node;
    } break;

#line 3801 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 510: {
        AST::ContinueStatement *node = new (pool) AST::ContinueStatement(stringRef(2));
        node->continueToken = loc(1);
        node->identifierToken = loc(2);
        node->semicolonToken = loc(3);
        sym(1).Node = node;
    } break;

#line 3812 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 511: {
        AST::BreakStatement *node = new (pool) AST::BreakStatement(QStringView());
        node->breakToken = loc(1);
        node->semicolonToken = loc(2);
        sym(1).Node = node;
    } break;

#line 3822 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 512: {
        AST::BreakStatement *node = new (pool) AST::BreakStatement(stringRef(2));
        node->breakToken = loc(1);
        node->identifierToken = loc(2);
        node->semicolonToken = loc(3);
        sym(1).Node = node;
    } break;

#line 3833 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 513: {
        if (!functionNestingLevel) {
            syntaxError(loc(1), "Return statement not allowed outside of Function declaration.");
            return false;
        }
        AST::ReturnStatement *node = new (pool) AST::ReturnStatement(sym(2).Expression);
        node->returnToken = loc(1);
        node->semicolonToken = loc(3);
        sym(1).Node = node;
    } break;

#line 3847 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 514: {
        AST::WithStatement *node = new (pool) AST::WithStatement(sym(3).Expression, sym(5).Statement);
        node->withToken = loc(1);
        node->lparenToken = loc(2);
        node->rparenToken = loc(4);
        sym(1).Node = node;
    } break;

#line 3858 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 515: {
        AST::SwitchStatement *node = new (pool) AST::SwitchStatement(sym(3).Expression, sym(5).CaseBlock);
        node->switchToken = loc(1);
        node->lparenToken = loc(2);
        node->rparenToken = loc(4);
        sym(1).Node = node;
    } break;

#line 3869 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 516: {
        AST::CaseBlock *node = new (pool) AST::CaseBlock(sym(2).CaseClauses);
        node->lbraceToken = loc(1);
        node->rbraceToken = loc(3);
        sym(1).Node = node;
    } break;

#line 3879 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 517: {
        AST::CaseBlock *node = new (pool) AST::CaseBlock(sym(2).CaseClauses, sym(3).DefaultClause, sym(4).CaseClauses);
        node->lbraceToken = loc(1);
        node->rbraceToken = loc(5);
        sym(1).Node = node;
    } break;

#line 3889 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 518: {
        sym(1).Node = new (pool) AST::CaseClauses(sym(1).CaseClause);
    } break;

#line 3896 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 519: {
        sym(1).Node = new (pool) AST::CaseClauses(sym(1).CaseClauses, sym(2).CaseClause);
    } break;

#line 3903 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 520: {
        sym(1).Node = nullptr;
    } break;

#line 3910 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 521: {
        sym(1).Node = sym(1).CaseClauses->finish();
    } break;

#line 3917 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 522: {
        AST::CaseClause *node = new (pool) AST::CaseClause(sym(2).Expression, sym(4).StatementList);
        node->caseToken = loc(1);
        node->colonToken = loc(3);
        sym(1).Node = node;
    } break;

#line 3927 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 523: {
        AST::DefaultClause *node = new (pool) AST::DefaultClause(sym(3).StatementList);
        node->defaultToken = loc(1);
        node->colonToken = loc(2);
        sym(1).Node = node;
    } break;

#line 3937 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 524: {
        AST::LabelledStatement *node = new (pool) AST::LabelledStatement(stringRef(1), sym(3).Statement);
        node->identifierToken = loc(1);
        node->colonToken = loc(2);
        sym(1).Node = node;
    } break;

#line 3949 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 526: {
        syntaxError(loc(3), "FunctionDeclarations are not allowed after a label.");
        return false;
    } break;

#line 3957 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 527: {
        AST::ThrowStatement *node = new (pool) AST::ThrowStatement(sym(2).Expression);
        node->throwToken = loc(1);
        node->semicolonToken = loc(3);
        sym(1).Node = node;
    } break;

#line 3967 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 528: {
        AST::TryStatement *node = new (pool) AST::TryStatement(sym(2).Statement, sym(3).Catch);
        node->tryToken = loc(1);
        sym(1).Node = node;
    } break;

#line 3976 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 529: {
        AST::TryStatement *node = new (pool) AST::TryStatement(sym(2).Statement, sym(3).Finally);
        node->tryToken = loc(1);
        sym(1).Node = node;
    } break;

#line 3985 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 530: {
        AST::TryStatement *node = new (pool) AST::TryStatement(sym(2).Statement, sym(3).Catch, sym(4).Finally);
        node->tryToken = loc(1);
        sym(1).Node = node;
    } break;

#line 3994 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 531: {
        AST::Catch *node = new (pool) AST::Catch(sym(3).PatternElement, sym(5).Block);
        node->catchToken = loc(1);
        node->lparenToken = loc(2);
        node->identifierToken = loc(3);
        node->rparenToken = loc(4);
        sym(1).Node = node;
    } break;

#line 4006 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 532: {
        AST::Finally *node = new (pool) AST::Finally(sym(2).Block);
        node->finallyToken = loc(1);
        sym(1).Node = node;
    } break;

#line 4015 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 533: {
        AST::PatternElement *node = new (pool) AST::PatternElement(stringRef(1));
        node->identifierToken = loc(1);
        node->scope = AST::VariableScope::Let;
        sym(1).Node = node;
    } break;

#line 4025 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 534: {
        AST::PatternElement *node = new (pool) AST::PatternElement(sym(1).Pattern);
        node->scope = AST::VariableScope::Let;
        sym(1).Node = node;
    } break;

#line 4034 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 535: {
        AST::DebuggerStatement *node = new (pool) AST::DebuggerStatement();
        node->debuggerToken = loc(1);
        node->semicolonToken = loc(2);
        sym(1).Node = node;
    } break;

#line 4051 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 537: {
        if (!ensureNoFunctionTypeAnnotations(sym(6).TypeAnnotation, sym(4).FormalParameterList))
            return false;
        AST::FunctionDeclaration *node = new (pool) AST::FunctionDeclaration(stringRef(2), sym(4).FormalParameterList, sym(8).StatementList, sym(6).TypeAnnotation);
        node->functionToken = loc(1);
        node->identifierToken = loc(2);
        node->lparenToken = loc(3);
        node->rparenToken = loc(5);
        node->lbraceToken = loc(7);
        node->rbraceToken = loc(9);
        sym(1).Node = node;
    } break;

#line 4067 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 538: {
        AST::FunctionDeclaration *node = new (pool) AST::FunctionDeclaration(stringRef(2), sym(4).FormalParameterList, sym(8).StatementList,
                                                                             sym(6).TypeAnnotation);
        node->functionToken = loc(1);
        node->identifierToken = loc(2);
        node->lparenToken = loc(3);
        node->rparenToken = loc(5);
        node->lbraceToken = loc(7);
        node->rbraceToken = loc(9);
        sym(1).Node = node;
    } break;

#line 4083 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 540: {
        if (!ensureNoFunctionTypeAnnotations(sym(5).TypeAnnotation, sym(3).FormalParameterList))
            return false;
        AST::FunctionDeclaration *node = new (pool) AST::FunctionDeclaration(QStringView(), sym(3).FormalParameterList, sym(7).StatementList,
                                                                             sym(5).TypeAnnotation);
        node->functionToken = loc(1);
        node->lparenToken = loc(2);
        node->rparenToken = loc(4);
        node->lbraceToken = loc(6);
        node->rbraceToken = loc(8);
        sym(1).Node = node;
    } break;

#line 4099 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 541: {
        if (!ensureNoFunctionTypeAnnotations(sym(6).TypeAnnotation, sym(4).FormalParameterList))
            return false;
        AST::FunctionExpression *node = new (pool) AST::FunctionExpression(stringRef(2), sym(4).FormalParameterList, sym(8).StatementList,
                                                                           sym(6).TypeAnnotation);
        node->functionToken = loc(1);
        if (! stringRef(2).isNull())
          node->identifierToken = loc(2);
        node->lparenToken = loc(3);
        node->rparenToken = loc(5);
        node->lbraceToken = loc(7);
        node->rbraceToken = loc(9);
        sym(1).Node = node;
    } break;

#line 4117 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 542: {
        if (!ensureNoFunctionTypeAnnotations(sym(5).TypeAnnotation, sym(3).FormalParameterList))
            return false;
        AST::FunctionExpression *node = new (pool) AST::FunctionExpression(QStringView(), sym(3).FormalParameterList, sym(7).StatementList,
                                                                           sym(5).TypeAnnotation);
        node->functionToken = loc(1);
        node->lparenToken = loc(2);
        node->rparenToken = loc(4);
        node->lbraceToken = loc(6);
        node->rbraceToken = loc(8);
        sym(1).Node = node;
    } break;

#line 4135 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 544: {
        sym(1).Node = nullptr;
    } break;

#line 4142 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 545: {
        AST::FormalParameterList *node = (new (pool) AST::FormalParameterList(nullptr, sym(1).PatternElement))->finish(pool);
        sym(1).Node = node;
    } break;

#line 4150 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
 case 546: 
#line 4152 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 547: {
        sym(1).Node = sym(1).FormalParameterList->finish(pool);
    } break;

#line 4159 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 548: {
        AST::FormalParameterList *node = (new (pool) AST::FormalParameterList(sym(1).FormalParameterList, sym(3).PatternElement))->finish(pool);
        sym(1).Node = node;
    } break;

#line 4167 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 549: {
        AST::FormalParameterList *node = new (pool) AST::FormalParameterList(nullptr, sym(1).PatternElement);
        sym(1).Node = node;
    } break;

#line 4176 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 550: {
        sym(1).FormalParameterList->commaToken = loc(2);
        AST::FormalParameterList *node = new (pool) AST::FormalParameterList(sym(1).FormalParameterList, sym(3).PatternElement);
        sym(1).Node = node;
    } break;

#line 4187 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 552: {
        ++functionNestingLevel;
    } break;

#line 4194 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 553: {
        --functionNestingLevel;
    } break;

#line 4204 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 555: Q_FALLTHROUGH(); 
#line 4206 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 556: {
        AST::ReturnStatement *ret = new (pool) AST::ReturnStatement(sym(4).Expression);
        ret->returnToken = sym(4).Node->firstSourceLocation().startZeroLengthLocation();
        ret->semicolonToken = sym(4).Node->lastSourceLocation().endZeroLengthLocation(driver->code());
        AST::StatementList *statements = (new (pool) AST::StatementList(ret))->finish();
        AST::FunctionExpression *f = sym(1).FunctionExpression;
        f->body = statements;
        f->isArrowFunction = true;
        f->lbraceToken = sym(4).Node->firstSourceLocation().startZeroLengthLocation();
        f->rbraceToken = sym(4).Node->lastSourceLocation().endZeroLengthLocation(driver->code());
        sym(1).Node = f;
    } break;

#line 4222 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 557: Q_FALLTHROUGH(); 
#line 4224 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 558: {
        AST::FunctionExpression *f = sym(1).FunctionExpression;
        f->body = sym(6).StatementList;
        f->isArrowFunction = true;
        f->lbraceToken = loc(5);
        f->rbraceToken = loc(7);
        sym(1).Node = f;
    } break;

#line 4236 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 559: {
        AST::PatternElement *e = new (pool) AST::PatternElement(stringRef(1), /*type annotation*/nullptr, nullptr, AST::PatternElement::Binding);
        e->identifierToken = loc(1);
        AST::FormalParameterList *list = (new (pool) AST::FormalParameterList(nullptr, e))->finish(pool);
        AST::FunctionExpression *f = new (pool) AST::FunctionExpression(QStringView(), list, nullptr);
        f->functionToken = loc(1).startZeroLengthLocation();
        sym(1).FunctionExpression = f;
    } break;

#line 4250 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 560: {
        if (coverExpressionType != CE_FormalParameterList) {
            AST::NestedExpression *ne = static_cast<AST::NestedExpression *>(sym(1).Node);
            AST::FormalParameterList *list = ne->expression->reparseAsFormalParameterList(pool);
            if (!list) {
                syntaxError(loc(1), "Invalid Arrow parameter list.");
                return false;
            }
            AST::FunctionExpression *f = new (pool) AST::FunctionExpression(QStringView(), list->finish(pool), nullptr);
            f->functionToken = loc(1).startZeroLengthLocation();
            f->lparenToken = ne->lparenToken;
            f->rparenToken = ne->rparenToken;
            sym(1).FunctionExpression = f;
        }
    } break;

#line 4272 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 561: {
        if (lookaheadToken(lexer) == T_LBRACE)
            pushToken(T_FORCE_BLOCK);
    } break;

#line 4280 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 562: {
        if (!ensureNoFunctionTypeAnnotations(sym(5).TypeAnnotation, sym(3).FormalParameterList))
            return false;
        AST::FunctionExpression *f = new (pool) AST::FunctionExpression(stringRef(1), sym(3).FormalParameterList, sym(7).StatementList);
        f->functionToken = sym(1).PropertyName->firstSourceLocation();
        f->lparenToken = loc(2);
        f->rparenToken = loc(4);
        f->lbraceToken = loc(6);
        f->rbraceToken = loc(8);
        AST::PatternProperty *node = new (pool) AST::PatternProperty(sym(1).PropertyName, f, AST::PatternProperty::Method);
        node->colonToken = loc(2);
        sym(1).Node = node;
    } break;

#line 4297 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 563: {
        if (!ensureNoFunctionTypeAnnotations(sym(6).TypeAnnotation, sym(4).FormalParameterList))
            return false;
        AST::FunctionExpression *f = new (pool) AST::FunctionExpression(stringRef(2), sym(4).FormalParameterList, sym(8).StatementList);
        f->starToken = loc(1);
        f->functionToken = sym(2).PropertyName->firstSourceLocation();
        f->lparenToken = loc(3);
        f->rparenToken = loc(5);
        f->lbraceToken = loc(7);
        f->rbraceToken = loc(9);
        f->isGenerator = true;
        AST::PatternProperty *node = new (pool) AST::PatternProperty(sym(2).PropertyName, f, AST::PatternProperty::Method);
        sym(1).Node = node;
    } break;

#line 4316 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 564: {
        if (!ensureNoFunctionTypeAnnotations(sym(5).TypeAnnotation, /*formals*/nullptr))
            return false;
        AST::FunctionExpression *f = new (pool) AST::FunctionExpression(stringRef(2), nullptr, sym(7).StatementList);
        f->functionToken = sym(2).PropertyName->firstSourceLocation();
        f->lparenToken = loc(3);
        f->rparenToken = loc(4);
        f->lbraceToken = loc(6);
        f->rbraceToken = loc(8);
        AST::PatternProperty *node = new (pool) AST::PatternProperty(sym(2).PropertyName, f, AST::PatternProperty::Getter);
        sym(1).Node = node;
    } break;

#line 4332 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 565: {
        if (!ensureNoFunctionTypeAnnotations(sym(6).TypeAnnotation, sym(4).FormalParameterList))
            return false;
        AST::FunctionExpression *f = new (pool) AST::FunctionExpression(stringRef(2), sym(4).FormalParameterList, sym(8).StatementList);
        f->functionToken = sym(2).PropertyName->firstSourceLocation();
        f->lparenToken = loc(3);
        f->rparenToken = loc(5);
        f->lbraceToken = loc(7);
        f->rbraceToken = loc(9);
        AST::PatternProperty *node = new (pool) AST::PatternProperty(sym(2).PropertyName, f, AST::PatternProperty::Setter);
        sym(1).Node = node;
    } break;

#line 4349 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 566: {
        AST::FormalParameterList *node = (new (pool) AST::FormalParameterList(nullptr, sym(1).PatternElement))->finish(pool);
        sym(1).Node = node;
    } break;

#line 4357 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 567: {
        lexer->enterGeneratorBody();
    } break;

#line 4364 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 568: {
        --functionNestingLevel;
        lexer->leaveGeneratorBody();
    } break;

#line 4372 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 569: {
        AST::FunctionDeclaration *node = new (pool) AST::FunctionDeclaration(QStringView(), nullptr, nullptr);
        node->functionToken = loc(1);
        node->starToken = loc(2);
        sym(1).FunctionDeclaration = node;
    } break;

#line 4382 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 570: {
        AST::FunctionDeclaration *node = sym(1).FunctionDeclaration;
        node->identifierToken = loc(2);
        node->name = stringRef(2);
        node->lparenToken = loc(3);
        node->formals = sym(4).FormalParameterList;
        node->rparenToken = loc(5);
        node->lbraceToken = loc(6);
        node->body = sym(7).StatementList;
        node->rbraceToken = loc(8);
        node->isGenerator = true;
        sym(1).Node = node;
    } break;

#line 4400 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 572: {
        AST::FunctionDeclaration *node = sym(1).FunctionDeclaration;
        node->lparenToken = loc(2);
        node->formals = sym(3).FormalParameterList;
        node->rparenToken = loc(4);
        node->lbraceToken = loc(5);
        node->body = sym(6).StatementList;
        node->rbraceToken = loc(7);
        node->isGenerator = true;
        sym(1).Node = node;
    } break;

#line 4415 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 573: {
        AST::FunctionExpression *node = new (pool) AST::FunctionExpression(stringRef(3), sym(5).FormalParameterList, sym(8).StatementList);
        node->functionToken = loc(1);
        node->starToken = loc(2);
        if (!stringRef(3).isNull())
          node->identifierToken = loc(3);
        node->lparenToken = loc(4);
        node->rparenToken = loc(6);
        node->lbraceToken = loc(7);
        node->rbraceToken = loc(9);
        node->isGenerator = true;
        sym(1).Node = node;
    } break;

#line 4432 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 574: {
        AST::FunctionExpression *node = new (pool) AST::FunctionExpression(QStringView(), sym(4).FormalParameterList, sym(7).StatementList);
        node->functionToken = loc(1);
        node->starToken = loc(2);
        node->lparenToken = loc(3);
        node->rparenToken = loc(5);
        node->lbraceToken = loc(6);
        node->rbraceToken = loc(8);
        node->isGenerator = true;
        sym(1).Node = node;
    } break;

#line 4449 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 576: Q_FALLTHROUGH(); 
#line 4451 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 577: {
        AST::YieldExpression *node = new (pool) AST::YieldExpression();
        node->yieldToken = loc(1);
        sym(1).Node = node;
    } break;

#line 4460 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 578: Q_FALLTHROUGH(); 
#line 4462 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 579: {
        AST::YieldExpression *node = new (pool) AST::YieldExpression(sym(3).Expression);
        node->yieldToken = loc(1);
        node->isYieldStar = true;
        sym(1).Node = node;
    } break;

#line 4472 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 580: Q_FALLTHROUGH(); 
#line 4474 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 581: {
        AST::YieldExpression *node = new (pool) AST::YieldExpression(sym(2).Expression);
        node->yieldToken = loc(1);
        sym(1).Node = node;
    } break;

#line 4484 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 582: {
        AST::ClassDeclaration *node = new (pool) AST::ClassDeclaration(stringRef(2), sym(3).Expression, sym(5).ClassElementList);
        node->classToken = loc(1);
        node->identifierToken = loc(2);
        node->lbraceToken = loc(4);
        node->rbraceToken = loc(6);
        sym(1).Node = node;
    } break;

#line 4496 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 583: {
        AST::ClassExpression *node = new (pool) AST::ClassExpression(stringRef(2), sym(3).Expression, sym(5).ClassElementList);
        node->classToken = loc(1);
        node->identifierToken = loc(2);
        node->lbraceToken = loc(4);
        node->rbraceToken = loc(6);
        sym(1).Node = node;
    } break;

#line 4508 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 584: {
        AST::ClassDeclaration *node = new (pool) AST::ClassDeclaration(QStringView(), sym(2).Expression, sym(4).ClassElementList);
        node->classToken = loc(1);
        node->lbraceToken = loc(3);
        node->rbraceToken = loc(5);
        sym(1).Node = node;
    } break;

#line 4519 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 585: {
        AST::ClassExpression *node = new (pool) AST::ClassExpression(QStringView(), sym(2).Expression, sym(4).ClassElementList);
        node->classToken = loc(1);
        node->lbraceToken = loc(3);
        node->rbraceToken = loc(5);
        sym(1).Node = node;
    } break;

#line 4532 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 587: {
        if (++classNestingLevel == 1)
            lexer->setStaticIsKeyword(true);
    } break;

#line 4540 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 588: {
        if (--classNestingLevel == 0)
            lexer->setStaticIsKeyword(false);
    } break;

#line 4548 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 589: {
        sym(1).Node = nullptr;
    } break;

#line 4555 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 590: {
        sym(1).Node = sym(2).Node;
    } break;

#line 4562 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 591: {
        sym(1).Node = nullptr;
    } break;

#line 4569 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 592: {
        if (sym(1).Node)
            sym(1).Node = sym(1).ClassElementList->finish();
    } break;

#line 4579 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 594: {
        if (sym(1).Node) {
            if (sym(2).Node)
                sym(1).ClassElementList = sym(1).ClassElementList->append(sym(2).ClassElementList);
        } else if (sym(2).Node) {
            sym(1).Node = sym(2).Node;
        }
    } break;

#line 4591 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 595: {
        AST::ClassElementList *node = new (pool) AST::ClassElementList(sym(1).PatternProperty, false);
        sym(1).Node = node;
    } break;

#line 4599 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 596: {
        AST::ClassElementList *node = new (pool) AST::ClassElementList(sym(2).PatternProperty, true);
        sym(1).Node = node;
    } break;

#line 4607 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 597: {
        sym(1).Node = nullptr;
    } break;

#line 4616 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 598: {
        sym(1).Node = nullptr;
    } break;

#line 4625 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 600: {
        sym(1).Node = new (pool) AST::Program(sym(1).StatementList->finish());
    } break;

#line 4632 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
  case 601: {
        sym(1).Node = new (pool) AST::ESModule(sym(1).StatementList);
    } break;

#line 4638 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 602: {
        sym(1).StatementList = sym(1).StatementList->finish();
    } break;

#line 4645 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 603: {
        sym(1).StatementList = nullptr;
    } break;

#line 4655 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 606: {
        sym(1).StatementList = sym(1).StatementList->append(sym(2).StatementList);
    } break;

#line 4663 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
 case 607:  Q_FALLTHROUGH(); 
#line 4665 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 608: {
        sym(1).StatementList = new (pool) AST::StatementList(sym(1).Node);
    } break;

#line 4674 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 610: {
        auto decl = new (pool) AST::ImportDeclaration(sym(2).ImportClause, sym(3).FromClause);
        decl->importToken = loc(1);
        sym(1).Node = decl;
    } break;

#line 4682 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 611: {
        auto decl = new (pool) AST::ImportDeclaration(stringRef(2));
        decl->importToken = loc(1);
        decl->moduleSpecifierToken = loc(2);
        sym(1).Node = decl;
    } break;

#line 4692 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 612: {
        auto clause = new (pool) AST::ImportClause(stringRef(1));
        clause->importedDefaultBindingToken = loc(1);
        sym(1).ImportClause = clause;
    } break;

#line 4700 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 613: {
        sym(1).ImportClause = new (pool) AST::ImportClause(sym(1).NameSpaceImport);
    } break;

#line 4706 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 614: {
        sym(1).ImportClause = new (pool) AST::ImportClause(sym(1).NamedImports);
    } break;

#line 4712 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 615: {
        auto importClause = new (pool) AST::ImportClause(stringRef(1), sym(3).NameSpaceImport);
        importClause->importedDefaultBindingToken = loc(1);
        sym(1).ImportClause = importClause;
    } break;

#line 4720 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 616: {
        auto importClause = new (pool) AST::ImportClause(stringRef(1), sym(3).NamedImports);
        importClause->importedDefaultBindingToken = loc(1);
        sym(1).ImportClause = importClause;
    } break;

#line 4731 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 618: {
        auto import = new (pool) AST::NameSpaceImport(stringRef(3));
        import->starToken = loc(1);
        import->importedBindingToken = loc(3);
        sym(1).NameSpaceImport = import;
    } break;

#line 4741 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 619: {
        auto namedImports = new (pool) AST::NamedImports();
        namedImports->leftBraceToken = loc(1);
        namedImports->rightBraceToken = loc(2);
        sym(1).NamedImports = namedImports;
    } break;

#line 4750 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 620: {
        auto namedImports = new (pool) AST::NamedImports(sym(2).ImportsList->finish());
        namedImports->leftBraceToken = loc(1);
        namedImports->rightBraceToken = loc(3);
        sym(1).NamedImports = namedImports;
    } break;

#line 4759 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 621: {
        auto namedImports = new (pool) AST::NamedImports(sym(2).ImportsList->finish());
        namedImports->leftBraceToken = loc(1);
        namedImports->rightBraceToken = loc(4);
        sym(1).NamedImports = namedImports;
    } break;

#line 4769 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 622: {
        auto clause = new (pool) AST::FromClause(stringRef(2));
        clause->fromToken = loc(1);
        clause->moduleSpecifierToken = loc(2);
        sym(1).FromClause = clause;
    } break;

#line 4779 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 623: {
        auto importsList = new (pool) AST::ImportsList(sym(1).ImportSpecifier);
        importsList->importSpecifierToken = loc(1);
        sym(1).ImportsList = importsList;
    } break;

#line 4787 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 624: {
        auto importsList = new (pool) AST::ImportsList(sym(1).ImportsList, sym(3).ImportSpecifier);
        importsList->importSpecifierToken = loc(3);
        sym(1).ImportsList = importsList;
    } break;

#line 4799 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 625: {
        auto importSpecifier = new (pool) AST::ImportSpecifier(stringRef(1));
        importSpecifier->importedBindingToken = loc(1);
        sym(1).ImportSpecifier = importSpecifier;
    } break;

#line 4807 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 626: {
    auto importSpecifier = new (pool) AST::ImportSpecifier(stringRef(1), stringRef(3));
    importSpecifier->identifierToken = loc(1);
    importSpecifier->importedBindingToken = loc(3);
    sym(1).ImportSpecifier = importSpecifier;
    } break;

#line 4824 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 629: {
        int token = lookaheadToken(lexer);
        if (token == T_FUNCTION || token == T_CLASS)
            pushToken(T_FORCE_DECLARATION);
    } break;

#line 4833 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 630: {
        auto exportDeclaration = new (pool) AST::ExportDeclaration(sym(3).FromClause);
        exportDeclaration->exportToken = loc(1);
        sym(1).ExportDeclaration = exportDeclaration;
    } break;

#line 4841 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 631: {
        auto exportDeclaration = new (pool) AST::ExportDeclaration(sym(2).ExportClause, sym(3).FromClause);
        exportDeclaration->exportToken = loc(1);
        sym(1).ExportDeclaration = exportDeclaration;
    } break;

#line 4849 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 632: {
        auto exportDeclaration = new (pool) AST::ExportDeclaration(sym(2).ExportClause);
        exportDeclaration->exportToken = loc(1);
        sym(1).ExportDeclaration = exportDeclaration;
    } break;

#line 4857 "../../../qtdeclarative/src/qml/parser/qqmljs.g"
 case 633:  Q_FALLTHROUGH(); 
#line 4859 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 634: {
        auto exportDeclaration = new (pool) AST::ExportDeclaration(/*exportDefault=*/false, sym(2).Node);
        exportDeclaration->exportToken = loc(1);
        sym(1).ExportDeclaration = exportDeclaration;
    } break;

#line 4867 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 635: {
        if (auto *f = AST::cast<AST::FunctionDeclaration*>(sym(5).Node)) {
            if (f->name.isEmpty()) {
                f->name = stringRef(2);
                f->identifierToken = loc(2);
            }
        }
    } Q_FALLTHROUGH();

#line 4878 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 636: {
        // Emulate 15.2.3.11
        if (auto *cls = AST::cast<AST::ClassDeclaration*>(sym(5).Node)) {
            if (cls->name.isEmpty()) {
                cls->name = stringRef(2);
                cls->identifierToken = loc(2);
            }
        }

        auto exportDeclaration = new (pool) AST::ExportDeclaration(/*exportDefault=*/true, sym(5).Node);
        exportDeclaration->exportToken = loc(1);
        sym(1).ExportDeclaration = exportDeclaration;
    } break;

#line 4894 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 637: {
        // if lhs is an identifier expression and rhs is an anonymous function expression, we need to assign the name of lhs to the function
        if (auto *f = asAnonymousFunctionDefinition(sym(4).Node)) {
            f->name = stringRef(2);
        }
        if (auto *c = asAnonymousClassDefinition(sym(4).Expression)) {
            c->name = stringRef(2);
        }

        auto exportDeclaration = new (pool) AST::ExportDeclaration(/*exportDefault=*/true, sym(4).Node);
        exportDeclaration->exportToken = loc(1);
        sym(1).ExportDeclaration = exportDeclaration;
    } break;

#line 4911 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 638: {
        auto exportClause = new (pool) AST::ExportClause();
        exportClause->leftBraceToken = loc(1);
        exportClause->rightBraceToken = loc(2);
        sym(1).ExportClause = exportClause;
    } break;

#line 4920 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 639: {
        auto exportClause = new (pool) AST::ExportClause(sym(2).ExportsList->finish());
        exportClause->leftBraceToken = loc(1);
        exportClause->rightBraceToken = loc(3);
        sym(1).ExportClause = exportClause;
    } break;

#line 4929 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 640: {
        auto exportClause = new (pool) AST::ExportClause(sym(2).ExportsList->finish());
        exportClause->leftBraceToken = loc(1);
        exportClause->rightBraceToken = loc(4);
        sym(1).ExportClause = exportClause;
    } break;

#line 4939 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 641: {
        sym(1).ExportsList = new (pool) AST::ExportsList(sym(1).ExportSpecifier);
    } break;

#line 4945 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 642: {
        sym(1).ExportsList = new (pool) AST::ExportsList(sym(1).ExportsList, sym(3).ExportSpecifier);
    } break;

#line 4952 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 643: {
        auto exportSpecifier = new (pool) AST::ExportSpecifier(stringRef(1));
        exportSpecifier->identifierToken = loc(1);
        sym(1).ExportSpecifier = exportSpecifier;
    } break;

#line 4960 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    case 644: {
        auto exportSpecifier = new (pool) AST::ExportSpecifier(stringRef(1), stringRef(3));
        exportSpecifier->identifierToken = loc(1);
        exportSpecifier->exportedIdentifierToken = loc(3);
        sym(1).ExportSpecifier = exportSpecifier;
    } break;

#line 4971 "../../../qtdeclarative/src/qml/parser/qqmljs.g"

    // ------------ end of switch statement
            } // switch
            action = nt_action(state_stack[tos], lhs[r] - TERMINAL_COUNT);
        } // if
    } while (action != 0);

#ifdef PARSER_DEBUG
    qDebug() << "Done or error.";
#endif

    if (first_token == last_token) {
        const int errorState = state_stack[tos];

        // automatic insertion of missing identifiers after dots
        if (yytoken != -1 && m_identifierInsertionEnabled && t_action(errorState, T_IDENTIFIER) && yyprevtoken == T_DOT) {
#ifdef PARSER_DEBUG
            qDebug() << "Inserting missing identifier between" << spell[yyprevtoken] << "and"
                     << spell[yytoken];
#endif
            pushTokenWithEmptyLocation(T_IDENTIFIER);
            action = errorState;
            goto _Lcheck_token;
        }


        // automatic insertion of `;'
        if (yytoken != -1 && ((t_action(errorState, T_AUTOMATIC_SEMICOLON) && lexer->canInsertAutomaticSemicolon(yytoken))
                              || t_action(errorState, T_COMPATIBILITY_SEMICOLON))) {
#ifdef PARSER_DEBUG
            qDebug() << "Inserting automatic semicolon.";
#endif
            pushTokenWithEmptyLocation(T_SEMICOLON);
            action = errorState;
            goto _Lcheck_token;
        }

        hadErrors = true;

        token_buffer[0].token = yytoken;
        token_buffer[0].dval = yylval;
        token_buffer[0].spell = yytokenspell;
        token_buffer[0].raw = yytokenraw;
        token_buffer[0].loc = yylloc;

        token_buffer[1].token = yytoken       = lexer->lex();
        token_buffer[1].dval  = yylval        = lexer->tokenValue();
        token_buffer[1].spell = yytokenspell  = lexer->tokenSpell();
        token_buffer[1].raw   = yytokenraw    = lexer->rawString();
        token_buffer[1].loc   = yylloc        = location(lexer);

        if (t_action(errorState, yytoken)) {
#ifdef PARSER_DEBUG
            qDebug() << "Parse error, trying to recover.";
#endif
            QString msg;
            int token = token_buffer[0].token;
            if (token < 0 || token >= TERMINAL_COUNT)
                msg = QCoreApplication::translate("QQmlParser", "Syntax error");
            else
                msg = QCoreApplication::translate("QQmlParser", "Unexpected token `%1'").arg(QLatin1String(spell[token]));
            diagnostic_messages.append(compileError(token_buffer[0].loc, msg));

            action = errorState;
            goto _Lcheck_token;
        }

        static int tokens[] = {
            T_PLUS,
            T_EQ,

            T_COMMA,
            T_COLON,
            T_SEMICOLON,

            T_RPAREN, T_RBRACKET, T_RBRACE,

            T_NUMERIC_LITERAL,
            T_IDENTIFIER,

            T_LPAREN, T_LBRACKET, T_LBRACE,

            EOF_SYMBOL
        };

        for (int *tk = tokens; *tk != EOF_SYMBOL; ++tk) {
            int a = t_action(errorState, *tk);
            if (a > 0 && t_action(a, yytoken)) {
#ifdef PARSER_DEBUG
                qDebug() << "Parse error, trying to recover (2).";
#endif
                const QString msg = QCoreApplication::translate("QQmlParser", "Expected token `%1'").arg(QLatin1String(spell[*tk]));
                diagnostic_messages.append(compileError(token_buffer[0].loc, msg));

                pushToken(*tk);
                goto _Lcheck_token;
            }
        }

        for (int tk = 1; tk < TERMINAL_COUNT; ++tk) {
            if (tk == T_AUTOMATIC_SEMICOLON || tk == T_FEED_UI_PROGRAM    ||
                tk == T_FEED_JS_STATEMENT   || tk == T_FEED_JS_EXPRESSION)
               continue;

            int a = t_action(errorState, tk);
            if (a > 0 && t_action(a, yytoken)) {
                const QString msg = QCoreApplication::translate("QQmlParser", "Expected token `%1'").arg(QLatin1String(spell[tk]));
                diagnostic_messages.append(compileError(token_buffer[0].loc, msg));

                pushToken(tk);
                goto _Lcheck_token;
            }
        }

        const QString msg = QCoreApplication::translate("QQmlParser", "Syntax error");
        diagnostic_messages.append(compileError(token_buffer[0].loc, msg));
    }

    return false;
}

QT_END_NAMESPACE


