/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.generator.internal;

import java.lang.reflect.Member;
import java.sql.CallableStatement;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Clock;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.SessionFactory;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.CurrentTimestamp;
import org.hibernate.annotations.SourceType;
import org.hibernate.annotations.UpdateTimestamp;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.jdbc.JdbcLogging;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.engine.jdbc.spi.JdbcCoordinator;
import org.hibernate.engine.jdbc.spi.StatementPreparer;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.generator.BeforeExecutionGenerator;
import org.hibernate.generator.EventType;
import org.hibernate.generator.EventTypeSets;
import org.hibernate.generator.GeneratorCreationContext;
import org.hibernate.generator.OnExecutionGenerator;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.mapping.BasicValue;
import org.hibernate.type.descriptor.java.ClockHelper;
import org.hibernate.type.descriptor.java.JavaType;

public class CurrentTimestampGeneration
implements BeforeExecutionGenerator,
OnExecutionGenerator {
    public static final String CLOCK_SETTING_NAME = "hibernate.testing.clock";
    private final EnumSet<EventType> eventTypes;
    private final JavaType<Object> propertyType;
    private final CurrentTimestampGeneratorDelegate delegate;
    private static final Map<Class<?>, BiFunction<@Nullable Clock, Integer, CurrentTimestampGeneratorDelegate>> GENERATOR_PRODUCERS = new HashMap();
    private static final Map<Key, CurrentTimestampGeneratorDelegate> GENERATOR_DELEGATES = new ConcurrentHashMap<Key, CurrentTimestampGeneratorDelegate>();

    public CurrentTimestampGeneration(CurrentTimestamp annotation, Member member, GeneratorCreationContext context) {
        this.delegate = CurrentTimestampGeneration.getGeneratorDelegate(annotation.source(), member, context);
        this.eventTypes = EventTypeSets.fromArray(annotation.event());
        this.propertyType = CurrentTimestampGeneration.getPropertyType(context);
    }

    public CurrentTimestampGeneration(CreationTimestamp annotation, Member member, GeneratorCreationContext context) {
        this.delegate = CurrentTimestampGeneration.getGeneratorDelegate(annotation.source(), member, context);
        this.eventTypes = EventTypeSets.INSERT_ONLY;
        this.propertyType = CurrentTimestampGeneration.getPropertyType(context);
    }

    public CurrentTimestampGeneration(UpdateTimestamp annotation, Member member, GeneratorCreationContext context) {
        this.delegate = CurrentTimestampGeneration.getGeneratorDelegate(annotation.source(), member, context);
        this.eventTypes = EventTypeSets.INSERT_AND_UPDATE;
        this.propertyType = CurrentTimestampGeneration.getPropertyType(context);
    }

    private static CurrentTimestampGeneratorDelegate getGeneratorDelegate(SourceType source, Member member, GeneratorCreationContext context) {
        return CurrentTimestampGeneration.getGeneratorDelegate(source, ReflectHelper.getPropertyType(member), context);
    }

    static CurrentTimestampGeneratorDelegate getGeneratorDelegate(SourceType source, Class<?> propertyType, GeneratorCreationContext context) {
        return switch (source) {
            default -> throw new IncompatibleClassChangeError();
            case SourceType.DB -> null;
            case SourceType.VM -> {
                Key key = new Key(propertyType, CurrentTimestampGeneration.getBaseClock(context), CurrentTimestampGeneration.getPrecision(context));
                CurrentTimestampGeneratorDelegate delegate = GENERATOR_DELEGATES.get(key);
                if (delegate != null) {
                    yield delegate;
                }
                BiFunction<Clock, Integer, CurrentTimestampGeneratorDelegate> producer = GENERATOR_PRODUCERS.get(key.clazz);
                if (producer == null) {
                    yield null;
                }
                CurrentTimestampGeneratorDelegate generatorDelegate = producer.apply(key.clock, key.precision);
                CurrentTimestampGeneratorDelegate old = GENERATOR_DELEGATES.putIfAbsent(key, generatorDelegate);
                if (old != null) {
                    yield old;
                }
                yield generatorDelegate;
            }
        };
    }

    private static int getPrecision(GeneratorCreationContext context) {
        BasicValue basicValue = (BasicValue)context.getProperty().getValue();
        Size size = basicValue.getColumns().get(0).getColumnSize(context.getDatabase().getDialect(), basicValue.getMetadata());
        return size.getPrecision() == null ? 0 : size.getPrecision();
    }

    private static Clock getBaseClock(GeneratorCreationContext context) {
        return context.getServiceRegistry().requireService(ConfigurationService.class).getSetting(CLOCK_SETTING_NAME, value -> (Clock)value);
    }

    public static <T extends Clock> T getClock(SessionFactory sessionFactory) {
        return (T)((Clock)sessionFactory.getProperties().get(CLOCK_SETTING_NAME));
    }

    private static JavaType<Object> getPropertyType(GeneratorCreationContext context) {
        return context.getDatabase().getTypeConfiguration().getJavaTypeRegistry().getDescriptor(context.getProperty().getType().getReturnedClass());
    }

    @Override
    public boolean generatedOnExecution() {
        return this.delegate == null;
    }

    @Override
    public EnumSet<EventType> getEventTypes() {
        return this.eventTypes;
    }

    @Override
    public Object generate(SharedSessionContractImplementor session, Object owner, Object currentValue, EventType eventType) {
        if (this.delegate == null) {
            if (eventType != EventType.FORCE_INCREMENT) {
                throw new UnsupportedOperationException("CurrentTimestampGeneration.generate() should not have been called");
            }
            return this.propertyType.wrap(CurrentTimestampGeneration.getCurrentTimestamp(session), session);
        }
        return this.delegate.generate();
    }

    @Override
    public boolean writePropertyValue() {
        return false;
    }

    @Override
    public boolean referenceColumnsInSql(Dialect dialect) {
        return true;
    }

    @Override
    public String[] getReferencedColumnValues(Dialect dialect) {
        return new String[]{dialect.currentTimestamp()};
    }

    static Timestamp getCurrentTimestamp(SharedSessionContractImplementor session) {
        Dialect dialect = session.getJdbcServices().getJdbcEnvironment().getDialect();
        return CurrentTimestampGeneration.getCurrentTimestampFromDatabase(dialect.getCurrentTimestampSelectString(), dialect.isCurrentTimestampSelectStringCallable(), session);
    }

    static Timestamp getCurrentTimestampFromDatabase(String timestampSelectString, boolean callable, SharedSessionContractImplementor session) {
        JdbcCoordinator coordinator = session.getJdbcCoordinator();
        StatementPreparer statementPreparer = coordinator.getStatementPreparer();
        PreparedStatement statement = null;
        try {
            Timestamp ts;
            statement = statementPreparer.prepareStatement(timestampSelectString, callable);
            Timestamp timestamp = ts = callable ? CurrentTimestampGeneration.extractCalledResult(statement, coordinator, timestampSelectString) : CurrentTimestampGeneration.extractResult(statement, coordinator, timestampSelectString);
            if (JdbcLogging.JDBC_MESSAGE_LOGGER.isTraceEnabled()) {
                JdbcLogging.JDBC_MESSAGE_LOGGER.currentTimestampRetrievedFromDatabase(ts, ts.getNanos(), ts.getTime());
            }
            Timestamp timestamp2 = ts;
            return timestamp2;
        }
        catch (SQLException e) {
            throw session.getJdbcServices().getSqlExceptionHelper().convert(e, "could not obtain current timestamp from database", timestampSelectString);
        }
        finally {
            if (statement != null) {
                coordinator.getLogicalConnection().getResourceRegistry().release(statement);
                coordinator.afterStatementExecution();
            }
        }
    }

    static Timestamp extractResult(PreparedStatement statement, JdbcCoordinator coordinator, String sql) throws SQLException {
        ResultSet resultSet = coordinator.getResultSetReturn().extract(statement, sql);
        resultSet.next();
        return resultSet.getTimestamp(1);
    }

    static Timestamp extractCalledResult(PreparedStatement statement, JdbcCoordinator coordinator, String sql) throws SQLException {
        CallableStatement callable = (CallableStatement)statement;
        callable.registerOutParameter(1, 93);
        coordinator.getResultSetReturn().execute(callable, sql);
        return callable.getTimestamp(1);
    }

    static {
        GENERATOR_PRODUCERS.put(java.util.Date.class, (baseClock, precision) -> {
            Clock clock = ClockHelper.forPrecision(baseClock, precision, 3);
            return () -> new java.util.Date(clock.millis());
        });
        GENERATOR_PRODUCERS.put(Calendar.class, (baseClock, precision) -> {
            Clock clock = ClockHelper.forPrecision(baseClock, precision, 3);
            return () -> {
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeInMillis(clock.millis());
                return calendar;
            };
        });
        GENERATOR_PRODUCERS.put(Date.class, (baseClock, precision) -> () -> new Date(baseClock == null ? System.currentTimeMillis() : baseClock.millis()));
        GENERATOR_PRODUCERS.put(Time.class, (baseClock, precision) -> {
            Clock clock = ClockHelper.forPrecision(baseClock, precision, 3);
            return () -> new Time(clock.millis());
        });
        GENERATOR_PRODUCERS.put(Timestamp.class, (baseClock, precision) -> {
            Clock clock = ClockHelper.forPrecision(baseClock, precision, 9);
            return () -> Timestamp.from(clock.instant());
        });
        GENERATOR_PRODUCERS.put(Instant.class, (baseClock, precision) -> {
            Clock clock = ClockHelper.forPrecision(baseClock, precision, 9);
            return clock::instant;
        });
        GENERATOR_PRODUCERS.put(LocalDate.class, (baseClock, precision) -> () -> LocalDate.now(baseClock == null ? Clock.systemDefaultZone() : baseClock));
        GENERATOR_PRODUCERS.put(LocalDateTime.class, (baseClock, precision) -> {
            Clock clock = ClockHelper.forPrecision(baseClock, precision, 9);
            return () -> LocalDateTime.now(clock);
        });
        GENERATOR_PRODUCERS.put(LocalTime.class, (baseClock, precision) -> {
            Clock clock = ClockHelper.forPrecision(baseClock, precision, 9);
            return () -> LocalTime.now(clock);
        });
        GENERATOR_PRODUCERS.put(MonthDay.class, (baseClock, precision) -> () -> MonthDay.now(baseClock == null ? Clock.systemDefaultZone() : baseClock));
        GENERATOR_PRODUCERS.put(OffsetDateTime.class, (baseClock, precision) -> {
            Clock clock = ClockHelper.forPrecision(baseClock, precision, 9);
            return () -> OffsetDateTime.now(clock);
        });
        GENERATOR_PRODUCERS.put(OffsetTime.class, (baseClock, precision) -> {
            Clock clock = ClockHelper.forPrecision(baseClock, precision, 9);
            return () -> OffsetTime.now(clock);
        });
        GENERATOR_PRODUCERS.put(Year.class, (baseClock, precision) -> () -> Year.now(baseClock == null ? Clock.systemDefaultZone() : baseClock));
        GENERATOR_PRODUCERS.put(YearMonth.class, (baseClock, precision) -> () -> YearMonth.now(baseClock == null ? Clock.systemDefaultZone() : baseClock));
        GENERATOR_PRODUCERS.put(ZonedDateTime.class, (baseClock, precision) -> {
            Clock clock = ClockHelper.forPrecision(baseClock, precision, 9);
            return () -> ZonedDateTime.now(clock);
        });
    }

    static interface CurrentTimestampGeneratorDelegate {
        public Object generate();
    }

    private record Key(Class<?> clazz, @Nullable Clock clock, int precision) {
    }
}

