---
stage: Growth
group: Engagement
info: For assistance with this tutorial, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments-to-other-projects-and-subjects.
title: 'チュートリアル: 左側のサイドバーを使用してGitLab内を移動する'
---

{{< details >}}

- プラン: Free、Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

{{< history >}}

- GitLab 16.0で[導入](https://gitlab.com/groups/gitlab-org/-/epics/9044)されました。
- 16.0から16.5では、アバターを選択し、**New navigation**（New navigation） トグルをオフにすることで、サイドバーをオフにできます。

{{< /history >}}

<!-- vale gitlab_base.FutureTense = NO -->

このチュートリアルに従って、新しい左側のサイドバーを使用してUI内を移動する方法を学んでください。

## 左側のサイドバーのレイアウト {#layout-of-the-left-sidebar}

左側のサイドバーの上部には、いくつかのショートカットがあります。これらのショートカットを使用して、左側のサイドバーの表示と非表示を切り替えたり、新しい作業アイテムを作成したり、検索したり、プロフィールを表示したりできます。イシュー、マージリクエスト、To-Do項目のリストを表示することもできます。

![割り当てられたイシュー、マージリクエスト、To-Doリスト、およびアバターを含む左側のサイドバーの上部セクション。](img/sidebar_top_v18_3.png)

{{< alert type="note" >}}

左側のサイドバーを非表示にした場合は、カーソルをGitLabウィンドウの左エッジにカーソルを合わせると、一時的に表示できます。

{{< /alert >}}

左側のサイドバーの次の領域は、表示している情報に基づいて変化します。たとえば、プロジェクトを表示したり、プロジェクトやグループを調査したり、プロフィールを表示したりする場合があります。左側のサイドバーの他の領域に切り替えるには、**検索または移動先**を使用します。

![左側のサイドバーからのコンテキスト切り替え。](img/sidebar_middle_v18_3.png)

左側のサイドバーの残りの部分は、選択したオプションに基づいて入力された状態になります。たとえば、プロジェクト内にいる場合、サイドバーはプロジェクト固有になります。

## プロジェクトを検索 {#find-your-project}

ここで、左側のサイドバーで使用するいくつかの一般的なタスクについて説明します。

まず、作業するプロジェクトを検索します。

1. 利用可能なすべてのプロジェクトを調査するには、左側のサイドバーで**検索または移動先**を選択します。
1. 頻繁にアクセスするプロジェクトのリストから選択するか、コロン`:`の後にプロジェクト名を入力します:

   ![プロジェクトと頻繁にアクセスするプロジェクトを検索するための検索バー。](img/search_projects_v18_3.png)

左側のサイドバーに、プロジェクト固有のオプションが表示されるようになりました。

![プロジェクト固有のオプション](img/project_selected_v18_3.png)

## 頻繁に使用する項目をピン留めする {#pin-frequently-used-items}

頻繁に使用するメニュー項目は、ピン留めできます。

1. ピン留めする項目が表示されるまで、セクションを展開します。
1. カーソルを合わせてピン（{{< icon name="thumbtack" >}}）を選択します。

   ![選択されたピンアイコン。](img/pin_v18_3.png)

項目は**ピン留め**セクションに表示されます:

![ピン留めセクションの項目。](img/pinned_v18_3.png)

{{< alert type="note" >}}

プロジェクトの表示中にピン留めする項目は、グループの表示中にピン留めする項目とは異なります。

{{< /alert >}}

## よりフォーカスされたビューを使用する {#use-a-more-focused-view}

左側のサイドバーでは、アクセスできる領域をよりフォーカスして表示することもできます。**検索または移動先**を選択し、**あなたの作業**を選択します。

![検索バーとあなたの作業項目。](img/your_work_v18_3.png)

次に、左側のサイドバーに**あなたの作業**が表示されます。

## 管理者エリアに移動 {#go-to-the-admin-area}

**管理者**エリアも、左側のサイドバーの下部にあります:

![管理者エリアボタン。](img/admin_area_v18_3.png)

## 新着情報にアクセス {#access-whats-new}

**新着情報**機能は、過去10バージョンのGitLabの新機能のハイライトをユーザーに表示します。

未読の**新着情報**項目にアクセスするには、左側のサイドバーの下部にある**新着情報**を選択します。

読み取り済みの**新着情報**項目にアクセスするには:

1. 左側のサイドバーの下部にある**ヘルプ**（{{< icon name="question" >}}）を選択します。
1. メニューから**新着情報**を選択します。
