/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.executor;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.search.SearchRequestBuilder;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.search.SearchHits;
import org.opensearch.search.builder.PointInTimeBuilder;
import org.opensearch.search.sort.SortOrder;
import org.opensearch.sql.legacy.domain.Select;
import org.opensearch.sql.legacy.exception.SqlParseException;
import org.opensearch.sql.legacy.pit.PointInTimeHandler;
import org.opensearch.transport.client.Client;

public abstract class ElasticHitsExecutor {
    protected static final Logger LOG = LogManager.getLogger();
    protected PointInTimeHandler pit;
    protected Client client;

    protected abstract void run() throws IOException, SqlParseException;

    protected abstract SearchHits getHits();

    public SearchResponse getResponseWithHits(SearchRequestBuilder request, Select select, int size, SearchResponse previousResponse, PointInTimeHandler pit) {
        request.setSize(size);
        boolean ordered = select.isOrderdSelect();
        if (!ordered) {
            request.addSort("_doc", SortOrder.ASC);
            request.addSort("_id", SortOrder.ASC);
        }
        request.setPointInTime(new PointInTimeBuilder(pit.getPitId()));
        if (previousResponse != null && select.getFrom().isEmpty()) {
            request.searchAfter((Object[])previousResponse.getHits().getSortFields());
        }
        SearchResponse responseWithHits = (SearchResponse)request.get();
        return responseWithHits;
    }
}

