/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.nio.support;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.concurrent.FutureCallback;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.EntityDetails;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.Header;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.HttpException;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.HttpResponse;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.nio.AsyncClientExchangeHandler;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.nio.AsyncRequestProducer;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.nio.AsyncResponseConsumer;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.nio.CapacityChannel;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.nio.DataStreamChannel;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.nio.RequestChannel;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.protocol.HttpContext;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.util.Args;

public final class BasicClientExchangeHandler<T>
implements AsyncClientExchangeHandler {
    private final AsyncRequestProducer requestProducer;
    private final AsyncResponseConsumer<T> responseConsumer;
    private final AtomicBoolean completed;
    private final AtomicBoolean outputTerminated;
    private final AtomicBoolean inputTerminated;
    private final FutureCallback<T> resultCallback;

    public BasicClientExchangeHandler(AsyncRequestProducer requestProducer, AsyncResponseConsumer<T> responseConsumer, FutureCallback<T> resultCallback) {
        this.requestProducer = Args.notNull(requestProducer, "Request producer");
        this.responseConsumer = Args.notNull(responseConsumer, "Response consumer");
        this.completed = new AtomicBoolean();
        this.resultCallback = resultCallback;
        this.outputTerminated = new AtomicBoolean();
        this.inputTerminated = new AtomicBoolean();
    }

    @Override
    public void produceRequest(RequestChannel requestChannel, HttpContext httpContext) throws HttpException, IOException {
        this.requestProducer.sendRequest(requestChannel, httpContext);
    }

    @Override
    public int available() {
        return this.requestProducer.available();
    }

    @Override
    public void produce(DataStreamChannel channel) throws IOException {
        if (this.outputTerminated.get()) {
            channel.endStream();
            return;
        }
        this.requestProducer.produce(channel);
    }

    @Override
    public void consumeInformation(HttpResponse response, HttpContext httpContext) throws HttpException, IOException {
        this.responseConsumer.informationResponse(response, httpContext);
    }

    @Override
    public void consumeResponse(HttpResponse response, EntityDetails entityDetails, HttpContext httpContext) throws HttpException, IOException {
        if (response.getCode() >= 400) {
            this.releaseRequestProducer();
        }
        this.responseConsumer.consumeResponse(response, entityDetails, httpContext, new FutureCallback<T>(){

            @Override
            public void completed(T result) {
                BasicClientExchangeHandler.this.completedInternal(result);
            }

            @Override
            public void failed(Exception ex) {
                BasicClientExchangeHandler.this.failedInternal(ex);
            }

            @Override
            public void cancelled() {
                BasicClientExchangeHandler.this.cancelledInternal();
            }
        });
    }

    @Override
    public void cancel() {
        this.cancelledInternal();
    }

    @Override
    public void updateCapacity(CapacityChannel capacityChannel) throws IOException {
        this.responseConsumer.updateCapacity(capacityChannel);
    }

    @Override
    public void consume(ByteBuffer src) throws IOException {
        this.responseConsumer.consume(src);
    }

    @Override
    public void streamEnd(List<? extends Header> trailers) throws HttpException, IOException {
        this.responseConsumer.streamEnd(trailers);
    }

    @Override
    public void failed(Exception cause) {
        try {
            if (this.inputTerminated.compareAndSet(false, true)) {
                this.responseConsumer.failed(cause);
                this.responseConsumer.releaseResources();
            }
            if (this.outputTerminated.compareAndSet(false, true)) {
                this.requestProducer.failed(cause);
                this.requestProducer.releaseResources();
            }
        }
        finally {
            this.failedInternal(cause);
        }
    }

    private void completedInternal(T result) {
        if (this.completed.compareAndSet(false, true)) {
            try {
                if (this.resultCallback != null) {
                    this.resultCallback.completed(result);
                }
            }
            finally {
                this.releaseResourcesInternal();
            }
        }
    }

    private void failedInternal(Exception ex) {
        if (this.completed.compareAndSet(false, true)) {
            try {
                if (this.resultCallback != null) {
                    this.resultCallback.failed(ex);
                }
            }
            finally {
                this.releaseResourcesInternal();
            }
        }
    }

    private void cancelledInternal() {
        if (this.completed.compareAndSet(false, true)) {
            try {
                if (this.resultCallback != null) {
                    this.resultCallback.cancelled();
                }
            }
            finally {
                this.releaseResourcesInternal();
            }
        }
    }

    private void releaseResponseConsumer() {
        if (this.inputTerminated.compareAndSet(false, true)) {
            this.responseConsumer.releaseResources();
        }
    }

    private void releaseRequestProducer() {
        if (this.outputTerminated.compareAndSet(false, true)) {
            this.requestProducer.releaseResources();
        }
    }

    private void releaseResourcesInternal() {
        this.releaseRequestProducer();
        this.releaseResponseConsumer();
    }

    @Override
    public void releaseResources() {
        this.releaseRequestProducer();
    }
}

