/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.controlcenter.notification.filter.parser;

import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.OpenSearchException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.admin.indices.forcemerge.ForceMergeRequest;
import org.opensearch.action.admin.indices.forcemerge.ForceMergeResponse;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.action.support.DefaultShardOperationFailedException;
import org.opensearch.indexmanagement.controlcenter.notification.filter.OperationResult;
import org.opensearch.indexmanagement.controlcenter.notification.filter.parser.ActionRespParseResult;
import org.opensearch.indexmanagement.controlcenter.notification.filter.parser.ResponseParser;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ*\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00022\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0016J$\u0010\u0017\u001a\u00020\u000e2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00022\b\u0010\u0018\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/opensearch/indexmanagement/controlcenter/notification/filter/parser/ForceMergeIndexRespParser;", "Lorg/opensearch/indexmanagement/controlcenter/notification/filter/parser/ResponseParser;", "Lorg/opensearch/action/admin/indices/forcemerge/ForceMergeResponse;", "request", "Lorg/opensearch/action/admin/indices/forcemerge/ForceMergeRequest;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "<init>", "(Lorg/opensearch/action/admin/indices/forcemerge/ForceMergeRequest;Lorg/opensearch/cluster/service/ClusterService;)V", "getRequest", "()Lorg/opensearch/action/admin/indices/forcemerge/ForceMergeRequest;", "getClusterService", "()Lorg/opensearch/cluster/service/ClusterService;", "indexNameWithCluster", "", "parseAndSendNotification", "", "response", "ex", "Ljava/lang/Exception;", "callback", "Ljava/util/function/Consumer;", "Lorg/opensearch/indexmanagement/controlcenter/notification/filter/parser/ActionRespParseResult;", "buildNotificationMessage", "exception", "isTimeout", "", "buildNotificationTitle", "operationResult", "Lorg/opensearch/indexmanagement/controlcenter/notification/filter/OperationResult;", "opensearch-index-management"})
@SourceDebugExtension(value={"SMAP\nForceMergeIndexRespParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ForceMergeIndexRespParser.kt\norg/opensearch/indexmanagement/controlcenter/notification/filter/parser/ForceMergeIndexRespParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,85:1\n1#2:86\n*E\n"})
public final class ForceMergeIndexRespParser
implements ResponseParser<ForceMergeResponse> {
    @NotNull
    private final ForceMergeRequest request;
    @NotNull
    private final ClusterService clusterService;
    @Nullable
    private final String indexNameWithCluster;

    public ForceMergeIndexRespParser(@NotNull ForceMergeRequest request, @NotNull ClusterService clusterService) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        this.request = request;
        this.clusterService = clusterService;
        this.indexNameWithCluster = this.getIndexName((ActionRequest)this.request, this.clusterService);
    }

    @NotNull
    public final ForceMergeRequest getRequest() {
        return this.request;
    }

    @NotNull
    public final ClusterService getClusterService() {
        return this.clusterService;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void parseAndSendNotification(@Nullable ForceMergeResponse response, @Nullable Exception ex, @NotNull Consumer<ActionRespParseResult> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        if (ex != null) {
            callback.accept(new ActionRespParseResult(OperationResult.FAILED, ResponseParser.buildNotificationMessage$default(this, null, ex, false, 4, null), this.buildNotificationTitle(OperationResult.FAILED)));
            return;
        }
        if (response == null) {
            $i$a$-requireNotNull-ForceMergeIndexRespParser$parseAndSendNotification$1 = false;
            $i$a$-requireNotNull-ForceMergeIndexRespParser$parseAndSendNotification$1 = "ForceMergeResponse must not be null";
            throw new IllegalArgumentException($i$a$-requireNotNull-ForceMergeIndexRespParser$parseAndSendNotification$1.toString());
        }
        if (response.getShardFailures() == null) ** GOTO lbl-1000
        v0 = response.getShardFailures();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getShardFailures(...)");
        if (((Object[])v0).length == 0 == false) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = hasFailures = false;
        }
        if (hasFailures) {
            callback.accept(new ActionRespParseResult(OperationResult.FAILED, ResponseParser.buildNotificationMessage$default(this, (ActionResponse)response, null, false, 6, null), this.buildNotificationTitle(OperationResult.FAILED)));
        } else {
            callback.accept(new ActionRespParseResult(OperationResult.COMPLETE, ResponseParser.buildNotificationMessage$default(this, (ActionResponse)response, null, false, 6, null), this.buildNotificationTitle(OperationResult.COMPLETE)));
        }
    }

    @Override
    @NotNull
    public String buildNotificationMessage(@Nullable ForceMergeResponse response2, @Nullable Exception exception, boolean isTimeout) {
        DefaultShardOperationFailedException[] defaultShardOperationFailedExceptionArray;
        Object object;
        if (exception != null) {
            if (exception instanceof OpenSearchException) {
                object = "index [" + ((OpenSearchException)exception).getIndex().getName() + "] " + ((OpenSearchException)exception).getMessage() + ".";
            } else {
                object = exception.getMessage();
                if (object == null) {
                    object = "";
                }
            }
        } else if (response2 != null && !((defaultShardOperationFailedExceptionArray = response2.getShardFailures()) == null || defaultShardOperationFailedExceptionArray.length == 0)) {
            DefaultShardOperationFailedException[] defaultShardOperationFailedExceptionArray2 = response2.getShardFailures();
            Intrinsics.checkNotNullExpressionValue((Object)defaultShardOperationFailedExceptionArray2, (String)"getShardFailures(...)");
            object = ArraysKt.joinToString$default((Object[])defaultShardOperationFailedExceptionArray2, (CharSequence)",", null, null, (int)0, null, ForceMergeIndexRespParser::buildNotificationMessage$lambda$1, (int)30, null);
        } else {
            object = this.request.indices().length == 1 ? "The force merge operation on " + this.indexNameWithCluster + " has been completed." : this.indexNameWithCluster + " have been merged.";
        }
        return object;
    }

    @Override
    @NotNull
    public String buildNotificationTitle(@NotNull OperationResult operationResult) {
        Intrinsics.checkNotNullParameter((Object)((Object)operationResult), (String)"operationResult");
        if (this.request.indices().length == 1) {
            return "Force merge operation on " + this.indexNameWithCluster + " has " + this.getOperationResultTitleDesc(operationResult);
        }
        return "Force merge operation on " + this.request.indices().length + " indexes from [" + this.clusterService.getClusterName().value() + "] has " + this.getOperationResultTitleDesc(operationResult);
    }

    @Override
    @Nullable
    public String getIndexName(@NotNull ActionRequest req, @NotNull ClusterService clusterService) {
        return ResponseParser.super.getIndexName(req, clusterService);
    }

    @Override
    @NotNull
    public String getOperationResultTitleDesc(@NotNull OperationResult result2) {
        return ResponseParser.super.getOperationResultTitleDesc(result2);
    }

    private static final CharSequence buildNotificationMessage$lambda$1(DefaultShardOperationFailedException it) {
        return "index [" + it.index() + "] shard [" + it.shardId() + "] " + it.reason();
    }
}

