/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.transport;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.opensearch.action.support.nodes.BaseNodesRequest;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.timeseries.model.ProfileName;

public class ProfileRequest
extends BaseNodesRequest<ProfileRequest> {
    private Set<ProfileName> profilesToBeRetrieved;
    private String configId;

    public ProfileRequest(StreamInput in) throws IOException {
        super(in);
        int size = in.readVInt();
        this.profilesToBeRetrieved = new HashSet<ProfileName>();
        if (size != 0) {
            for (int i = 0; i < size; ++i) {
                this.profilesToBeRetrieved.add((ProfileName)in.readEnum(ProfileName.class));
            }
        }
        this.configId = in.readString();
    }

    public ProfileRequest(String configId, Set<ProfileName> profilesToBeRetrieved, DiscoveryNode ... nodes) {
        super(nodes);
        this.configId = configId;
        this.profilesToBeRetrieved = profilesToBeRetrieved;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.profilesToBeRetrieved.size());
        for (ProfileName profile : this.profilesToBeRetrieved) {
            out.writeEnum((Enum)profile);
        }
        out.writeString(this.configId);
    }

    public String getConfigId() {
        return this.configId;
    }

    public Set<ProfileName> getProfilesToBeRetrieved() {
        return this.profilesToBeRetrieved;
    }
}

