/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.clients.consumer.AcknowledgementCommitCallback;
import org.apache.kafka.clients.consumer.internals.Acknowledgements;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicIdPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcknowledgementCommitCallbackHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AcknowledgementCommitCallbackHandler.class);
    private final AcknowledgementCommitCallback acknowledgementCommitCallback;
    private boolean enteredCallback = false;

    AcknowledgementCommitCallbackHandler(AcknowledgementCommitCallback acknowledgementCommitCallback) {
        this.acknowledgementCommitCallback = acknowledgementCommitCallback;
    }

    public boolean hasEnteredCallback() {
        return this.enteredCallback;
    }

    void onComplete(List<Map<TopicIdPartition, Acknowledgements>> acknowledgementsMapList) {
        acknowledgementsMapList.forEach(acknowledgementsMap -> acknowledgementsMap.forEach((partition, acknowledgements) -> {
            KafkaException exception = acknowledgements.getAcknowledgeException();
            Set<Long> offsets = acknowledgements.getAcknowledgementsTypeMap().keySet();
            Set<Long> offsetsCopy = Set.copyOf(offsets);
            this.enteredCallback = true;
            try {
                this.acknowledgementCommitCallback.onComplete(Map.of(partition, offsetsCopy), exception);
            }
            catch (Exception e) {
                LOG.error("Exception thrown by acknowledgement commit callback", (Throwable)e);
            }
            finally {
                this.enteredCallback = false;
            }
        }));
    }
}

