/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.cli;

import com.fasterxml.jackson.core.exc.StreamReadException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DatabindException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.connect.cli.AbstractConnectCli;
import org.apache.kafka.connect.connector.policy.ConnectorClientConfigOverridePolicy;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.json.JsonConverter;
import org.apache.kafka.connect.runtime.Connect;
import org.apache.kafka.connect.runtime.Herder;
import org.apache.kafka.connect.runtime.Worker;
import org.apache.kafka.connect.runtime.isolation.Plugins;
import org.apache.kafka.connect.runtime.rest.RestClient;
import org.apache.kafka.connect.runtime.rest.RestServer;
import org.apache.kafka.connect.runtime.rest.entities.ConnectorInfo;
import org.apache.kafka.connect.runtime.rest.entities.CreateConnectorRequest;
import org.apache.kafka.connect.runtime.standalone.StandaloneConfig;
import org.apache.kafka.connect.runtime.standalone.StandaloneHerder;
import org.apache.kafka.connect.storage.FileOffsetBackingStore;
import org.apache.kafka.connect.util.FutureCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectStandalone
extends AbstractConnectCli<StandaloneHerder, StandaloneConfig> {
    private static final Logger log = LoggerFactory.getLogger(ConnectStandalone.class);

    public ConnectStandalone(String ... args) {
        super(args);
    }

    @Override
    protected String usage() {
        return "ConnectStandalone worker.properties [connector1.properties connector2.json ...]";
    }

    @Override
    public void processExtraArgs(Connect<StandaloneHerder> connect, String[] extraArgs) {
        try {
            for (String connectorConfigFile : extraArgs) {
                CreateConnectorRequest createConnectorRequest = this.parseConnectorConfigurationFile(connectorConfigFile);
                FutureCallback<Herder.Created<ConnectorInfo>> cb = new FutureCallback<Herder.Created<ConnectorInfo>>((error, info) -> {
                    if (error != null) {
                        log.error("Failed to create connector for {}", (Object)connectorConfigFile);
                    } else {
                        log.info("Created connector {}", (Object)((ConnectorInfo)info.result()).name());
                    }
                });
                connect.herder().putConnectorConfig(createConnectorRequest.name(), createConnectorRequest.config(), createConnectorRequest.initialTargetState(), false, cb);
                cb.get();
            }
            connect.herder().ready();
        }
        catch (Throwable t) {
            log.error("Stopping after connector error", t);
            connect.stop();
            Exit.exit((int)3);
        }
    }

    CreateConnectorRequest parseConnectorConfigurationFile(String filePath) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        File connectorConfigurationFile = Paths.get(filePath, new String[0]).toFile();
        try {
            Map connectorConfigs = (Map)objectMapper.readValue(connectorConfigurationFile, (TypeReference)new TypeReference<Map<String, String>>(){});
            if (!connectorConfigs.containsKey("name")) {
                throw new ConnectException("Connector configuration at '" + filePath + "' is missing the mandatory 'name' configuration");
            }
            return new CreateConnectorRequest((String)connectorConfigs.get("name"), connectorConfigs, null);
        }
        catch (StreamReadException | DatabindException e) {
            log.debug("Could not parse connector configuration file '{}' into a Map with String keys and values", (Object)filePath);
            try {
                objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
                CreateConnectorRequest createConnectorRequest = (CreateConnectorRequest)objectMapper.readValue(connectorConfigurationFile, (TypeReference)new TypeReference<CreateConnectorRequest>(){});
                if (createConnectorRequest.config().containsKey("name")) {
                    if (!createConnectorRequest.config().get("name").equals(createConnectorRequest.name())) {
                        throw new ConnectException("Connector name configuration in 'config' doesn't match the one specified in 'name' at '" + filePath + "'");
                    }
                } else {
                    createConnectorRequest.config().put("name", createConnectorRequest.name());
                }
                return createConnectorRequest;
            }
            catch (StreamReadException | DatabindException e2) {
                log.debug("Could not parse connector configuration file '{}' into an object of type {}", (Object)filePath, (Object)CreateConnectorRequest.class.getSimpleName());
                Map connectorConfigs = Utils.propsToStringMap((Properties)Utils.loadProps((String)filePath));
                if (!connectorConfigs.containsKey("name")) {
                    throw new ConnectException("Connector configuration at '" + filePath + "' is missing the mandatory 'name' configuration");
                }
                return new CreateConnectorRequest((String)connectorConfigs.get("name"), connectorConfigs, null);
            }
        }
    }

    @Override
    protected StandaloneHerder createHerder(StandaloneConfig config, String workerId, Plugins plugins, ConnectorClientConfigOverridePolicy connectorClientConfigOverridePolicy, RestServer restServer, RestClient restClient) {
        FileOffsetBackingStore offsetBackingStore = new FileOffsetBackingStore(plugins.newInternalConverter(true, JsonConverter.class.getName(), Map.of("schemas.enable", "false")));
        offsetBackingStore.configure(config);
        Worker worker = new Worker(workerId, Time.SYSTEM, plugins, config, offsetBackingStore, connectorClientConfigOverridePolicy);
        return new StandaloneHerder(worker, config.kafkaClusterId(), connectorClientConfigOverridePolicy);
    }

    @Override
    protected StandaloneConfig createConfig(Map<String, String> workerProps) {
        return new StandaloneConfig(workerProps);
    }

    public static void main(String[] args) {
        ConnectStandalone connectStandalone = new ConnectStandalone(args);
        connectStandalone.run();
    }
}

