/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.quota;

import java.util.Objects;
import org.apache.kafka.common.errors.ThrottlingQuotaExceededException;
import org.apache.kafka.common.metrics.QuotaViolationException;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.quota.AbstractControllerMutationQuota;

public class StrictControllerMutationQuota
extends AbstractControllerMutationQuota {
    private final Sensor quotaSensor;

    public StrictControllerMutationQuota(Time time, Sensor quotaSensor) {
        super(time);
        this.quotaSensor = Objects.requireNonNull(quotaSensor, "quotaSensor cannot be null");
    }

    @Override
    public boolean isExceeded() {
        return this.lastThrottleTimeMs > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void record(double permits) {
        long timeMs = this.time.milliseconds();
        try {
            Sensor sensor = this.quotaSensor;
            synchronized (sensor) {
                this.quotaSensor.checkQuotas(timeMs);
                this.quotaSensor.record(permits, timeMs, false);
            }
        }
        catch (QuotaViolationException e) {
            this.updateThrottleTime(e, timeMs);
            throw new ThrottlingQuotaExceededException((int)this.lastThrottleTimeMs, Errors.THROTTLING_QUOTA_EXCEEDED.message());
        }
    }
}

