/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.quota;

import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.internals.Plugin;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.QuotaViolationException;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.common.metrics.stats.TokenBucket;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.network.Session;
import org.apache.kafka.server.config.ClientQuotaManagerConfig;
import org.apache.kafka.server.quota.ClientQuotaCallback;
import org.apache.kafka.server.quota.ClientQuotaManager;
import org.apache.kafka.server.quota.ClientSensors;
import org.apache.kafka.server.quota.ControllerMutationQuota;
import org.apache.kafka.server.quota.PermissiveControllerMutationQuota;
import org.apache.kafka.server.quota.QuotaType;
import org.apache.kafka.server.quota.StrictControllerMutationQuota;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControllerMutationQuotaManager
extends ClientQuotaManager {
    private static final Logger LOG = LoggerFactory.getLogger(ControllerMutationQuotaManager.class);

    public ControllerMutationQuotaManager(ClientQuotaManagerConfig config, Metrics metrics, Time time, String threadNamePrefix, Optional<Plugin<ClientQuotaCallback>> quotaCallback) {
        super(config, metrics, QuotaType.CONTROLLER_MUTATION, time, threadNamePrefix, quotaCallback);
    }

    @Override
    protected MetricName clientQuotaMetricName(Map<String, String> quotaMetricTags) {
        return this.metrics.metricName("tokens", QuotaType.CONTROLLER_MUTATION.toString(), "Tracking remaining tokens in the token bucket per user/client-id", quotaMetricTags);
    }

    private MetricName clientRateMetricName(Map<String, String> quotaMetricTags) {
        return this.metrics.metricName("mutation-rate", QuotaType.CONTROLLER_MUTATION.toString(), "Tracking mutation-rate per user/client-id", quotaMetricTags);
    }

    @Override
    protected void registerQuotaMetrics(Map<String, String> metricTags, Sensor sensor) {
        sensor.add(this.clientRateMetricName(metricTags), (MeasurableStat)new Rate());
        sensor.add(this.clientQuotaMetricName(metricTags), (MeasurableStat)new TokenBucket(), this.getQuotaMetricConfig(metricTags));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int recordAndGetThrottleTimeMs(Session session, String clientId, double value, long timeMs) {
        ClientSensors clientSensors = this.getOrCreateQuotaSensors(session, clientId);
        Sensor quotaSensor = clientSensors.quotaSensor();
        try {
            Sensor sensor = quotaSensor;
            synchronized (sensor) {
                quotaSensor.checkQuotas(timeMs);
                quotaSensor.record(value, timeMs, false);
            }
            return 0;
        }
        catch (QuotaViolationException e) {
            int throttleTimeMs = (int)ControllerMutationQuotaManager.throttleTimeMs(e);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Quota violated for sensor ({}). Delay time: ({})", (Object)quotaSensor.name(), (Object)throttleTimeMs);
            }
            return throttleTimeMs;
        }
    }

    public ControllerMutationQuota newStrictQuotaFor(Session session, String clientId) {
        if (this.quotasEnabled()) {
            ClientSensors clientSensors = this.getOrCreateQuotaSensors(session, clientId);
            return new StrictControllerMutationQuota(this.time, clientSensors.quotaSensor());
        }
        return ControllerMutationQuota.UNBOUNDED_CONTROLLER_MUTATION_QUOTA;
    }

    public ControllerMutationQuota newStrictQuotaFor(Session session, RequestHeader header) {
        return this.newStrictQuotaFor(session, header.clientId());
    }

    public ControllerMutationQuota newPermissiveQuotaFor(Session session, String clientId) {
        if (this.quotasEnabled()) {
            ClientSensors clientSensors = this.getOrCreateQuotaSensors(session, clientId);
            return new PermissiveControllerMutationQuota(this.time, clientSensors.quotaSensor());
        }
        return ControllerMutationQuota.UNBOUNDED_CONTROLLER_MUTATION_QUOTA;
    }

    public ControllerMutationQuota newQuotaFor(Session session, RequestHeader header, short strictSinceVersion) {
        if (header.apiVersion() >= strictSinceVersion) {
            return this.newStrictQuotaFor(session, header);
        }
        return this.newPermissiveQuotaFor(session, header.clientId());
    }

    public static long throttleTimeMs(QuotaViolationException e) {
        if (e.metric().measurable() instanceof TokenBucket) {
            return Math.round(-e.value() / e.bound() * 1000.0);
        }
        throw new IllegalArgumentException("Metric " + String.valueOf(e.metric().metricName()) + " is not a TokenBucket metric, value " + String.valueOf(e.metric().measurable()));
    }
}

