/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server;

import org.apache.kafka.common.Uuid;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.metadata.Replicas;
import org.apache.kafka.server.common.TopicIdPartition;

record Assignment(TopicIdPartition topicIdPartition, Uuid directoryId, long submissionTimeNs, Runnable successCallback) {
    boolean valid(int nodeId, MetadataImage image) {
        TopicImage topicImage = image.topics().getTopic(this.topicIdPartition.topicId());
        if (topicImage == null) {
            return false;
        }
        PartitionRegistration partition = (PartitionRegistration)topicImage.partitions().get(this.topicIdPartition.partitionId());
        if (partition == null) {
            return false;
        }
        return Replicas.contains((int[])partition.replicas, (int)nodeId);
    }
}

