/*
 * Decompiled with CFR 0.152.
 */
package training.ui;

import com.intellij.util.ui.Animator;
import javax.swing.JScrollBar;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import training.ui.LessonMessagePane;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000fJ\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u000fH\u0002J\b\u0010\u0015\u001a\u00020\u0011H\u0002J\b\u0010\u0016\u001a\u00020\u0011H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Ltraining/ui/StepAnimator;", "", "verticalScrollBar", "Ljavax/swing/JScrollBar;", "messagePane", "Ltraining/ui/LessonMessagePane;", "<init>", "(Ljavax/swing/JScrollBar;Ltraining/ui/LessonMessagePane;)V", "getVerticalScrollBar", "()Ljavax/swing/JScrollBar;", "getMessagePane", "()Ltraining/ui/LessonMessagePane;", "animator", "Lcom/intellij/util/ui/Animator;", "totalMessageAnimationCycles", "", "startAnimation", "", "needScroll", "scrollAnimation", "needScrollTo", "rectangleAnimation", "stopMessageAnimation", "intellij.featuresTrainer"})
public final class StepAnimator {
    @NotNull
    private final JScrollBar verticalScrollBar;
    @NotNull
    private final LessonMessagePane messagePane;
    @Nullable
    private Animator animator;
    private final int totalMessageAnimationCycles;

    public StepAnimator(@NotNull JScrollBar verticalScrollBar, @NotNull LessonMessagePane messagePane) {
        Intrinsics.checkNotNullParameter((Object)verticalScrollBar, (String)"verticalScrollBar");
        Intrinsics.checkNotNullParameter((Object)((Object)messagePane), (String)"messagePane");
        this.verticalScrollBar = verticalScrollBar;
        this.messagePane = messagePane;
        this.totalMessageAnimationCycles = 15;
    }

    @NotNull
    public final JScrollBar getVerticalScrollBar() {
        return this.verticalScrollBar;
    }

    @NotNull
    public final LessonMessagePane getMessagePane() {
        return this.messagePane;
    }

    public final void startAnimation(int needScroll) {
        Animator animator = this.animator;
        if (animator != null) {
            Animator it = animator;
            boolean bl = false;
            it.suspend();
            this.stopMessageAnimation();
        }
        this.messagePane.setTotalAnimation(this.totalMessageAnimationCycles);
        this.messagePane.setCurrentAnimation(0);
        this.scrollAnimation(needScroll);
    }

    private final void scrollAnimation(int needScrollTo) {
        block1: {
            int start = this.verticalScrollBar.getValue();
            if (needScrollTo <= start) {
                this.rectangleAnimation();
                this.verticalScrollBar.setValue(needScrollTo);
                return;
            }
            int needAdd = needScrollTo - start;
            Animator animator = this.animator = (Animator)new Animator(needAdd, this, start, needScrollTo){
                final /* synthetic */ StepAnimator this$0;
                final /* synthetic */ int $start;
                final /* synthetic */ int $needScrollTo;
                {
                    this.this$0 = $receiver;
                    this.$start = $start;
                    this.$needScrollTo = $needScrollTo;
                    super("Scroll animation", $needAdd, 200, false, false, null, 48, null);
                }

                public void paintNow(int frame, int totalFrames, int cycle) {
                    this.this$0.getVerticalScrollBar().setValue(this.$start + MathKt.roundToInt((double)((double)totalFrames * (1.0 - Math.cos(Math.PI * ((double)frame / (double)totalFrames))) / (double)2)));
                }

                protected void paintCycleEnd() {
                    if (Intrinsics.areEqual((Object)((Object)this), (Object)StepAnimator.access$getAnimator$p(this.this$0))) {
                        this.this$0.getVerticalScrollBar().setValue(this.$needScrollTo);
                        StepAnimator.access$setAnimator$p(this.this$0, null);
                        StepAnimator.access$rectangleAnimation(this.this$0);
                    }
                }
            };
            if (animator == null) break block1;
            animator.resume();
        }
    }

    private final void rectangleAnimation() {
        block0: {
            int n = this.totalMessageAnimationCycles;
            Animator animator = this.animator = (Animator)new Animator(this, n){
                final /* synthetic */ StepAnimator this$0;
                {
                    this.this$0 = $receiver;
                    super("Scroll animation", $super_call_param$1, 100, false, false, null, 48, null);
                }

                public void paintNow(int frame, int totalFrames, int cycle) {
                    this.this$0.getMessagePane().setTotalAnimation(totalFrames);
                    this.this$0.getMessagePane().setCurrentAnimation(frame);
                    this.this$0.getMessagePane().repaint();
                }

                protected void paintCycleEnd() {
                    if (Intrinsics.areEqual((Object)((Object)this), (Object)StepAnimator.access$getAnimator$p(this.this$0))) {
                        StepAnimator.access$stopMessageAnimation(this.this$0);
                        this.this$0.getMessagePane().repaint();
                        StepAnimator.access$setAnimator$p(this.this$0, null);
                    }
                }
            };
            if (animator == null) break block0;
            animator.resume();
        }
    }

    private final void stopMessageAnimation() {
        this.messagePane.setTotalAnimation(0);
        this.messagePane.setCurrentAnimation(0);
    }

    public static final /* synthetic */ Animator access$getAnimator$p(StepAnimator $this) {
        return $this.animator;
    }

    public static final /* synthetic */ void access$setAnimator$p(StepAnimator $this, Animator animator) {
        $this.animator = animator;
    }

    public static final /* synthetic */ void access$rectangleAnimation(StepAnimator $this) {
        $this.rectangleAnimation();
    }

    public static final /* synthetic */ void access$stopMessageAnimation(StepAnimator $this) {
        $this.stopMessageAnimation();
    }
}

