/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.tree;

import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeMatch;
import org.jetbrains.annotations.NotNull;

public interface NodePointer {
    @NotNull
    public Node findNode(NodeMatch var1);

    public static NodePointer anchor() {
        return match -> match.anchor();
    }

    public static NodePointer marked(String mark) {
        return match -> match.getMarkedNode(mark);
    }

    public static NodePointer neighbor(int indexDelta) {
        return match -> match.anchor().neighbor(indexDelta);
    }

    public static NodePointer neighbor(String label, int indexDelta) {
        return match -> match.getMarkedNode(label).neighbor(indexDelta);
    }

    public static NodePointer phraseStart(NodePointer head) {
        return match -> head.findNode(match).phraseStart();
    }

    public static NodePointer phraseStart() {
        return NodePointer.phraseStart(NodePointer.anchor());
    }

    public static NodePointer phraseEnd(NodePointer head) {
        return match -> head.findNode(match).phraseEnd();
    }

    public static NodePointer phraseEnd() {
        return NodePointer.phraseEnd(NodePointer.anchor());
    }
}

