/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.ru;

import ai.grazie.rules.Example;
import ai.grazie.rules.Rule;
import ai.grazie.rules.common.DateChecker;
import ai.grazie.rules.ru.RussianDateChecker;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodePattern;
import java.util.List;

class SemanticRules {
    static final NodePattern timeUnit = NodePattern.N.lemma("\u043c\u043e\u043c\u0435\u043d\u0442|\u0441\u0435\u043a\u0443\u043d\u0434\u0430|\u043c\u0438\u043d\u0443\u0442\u0430|\u0447\u0430\u0441|\u043f\u043e\u043b\u0447\u0430\u0441\u0430|\u0434\u0435\u043d\u044c|\u043d\u043e\u0447\u044c|\u0441\u0443\u0442\u043a\u0438|\u043d\u0435\u0434\u0435\u043b\u044f|\u043c\u0435\u0441\u044f\u0446|\u043a\u0432\u0430\u0440\u0442\u0430\u043b|\u0433\u043e\u0434|\u0432\u0435\u043a|\u0442\u044b\u0441\u044f\u0447\u0435\u043b\u0435\u0442\u0438\u0435|\u0443\u0442\u0440\u043e|\u0432\u0435\u0447\u0435\u0440");
    static final NodePattern lengthUnit = NodePattern.or(NodePattern.N.lemma("(.*)?\u043c\u0435\u0442\u0440|\u043c\u0438\u043b\u044f|\u0444\u0443\u0442|\u0434\u044e\u0439\u043c|\u044f\u0440\u0434|\u0432\u0435\u0440\u0441\u0442\u0430|\u0430\u0440\u0448\u0438\u043d|\u0432\u0435\u0440\u0448\u043e\u043a|\u0441\u0430\u0436\u0435\u043d\u044c|\u043b\u043e\u043a\u043e\u0442\u044c|\u0430\u043d\u0433\u0441\u0442\u0440\u0435\u043c|\u043b\u0438\u0433\u0430|\u043b\u044c\u0435|\u0444\u0443\u0440\u043b\u043e\u043d\u0433|\u0447\u0435\u0439\u043d|\u043b\u0430\u0434\u043e\u043d\u044c|\u0448\u0430\u0433"), NodePattern.N.form("[\u043d\u043c\u0441\u043a\u0434\u043f]?\u043c|\u043c\u043a\u043c"));
    static final String nounNumbers = "\u043f\u0430\u0440\u0430|\u0441\u043e\u0442\u043d\u044f|\u0434\u044e\u0436\u0438\u043d\u0430|\u0434\u0435\u0441\u044f\u0442\u043e\u043a|\u0442\u044b\u0441\u044f\u0447\u0430|\u043c\u0438\u043b\u043b\u0438\u043e\u043d|\u043c\u0438\u043b\u043b\u0438\u0430\u0440\u0434|\u0442\u0440\u0438\u043b\u043b\u0438\u043e\u043d";
    static final String dayNames = String.join((CharSequence)"|", RussianDateChecker.INSTANCE.dayNames);
    static final String monthNames = String.join((CharSequence)"|", RussianDateChecker.INSTANCE.monthNames);
    static final NodePattern durableNoun = NodePattern.or(NodePattern.N.lemma("\u0436\u0438\u0437\u043d\u044c|\u0444\u0438\u043b\u044c\u043c|\u0441\u043f\u0435\u043a\u0442\u0430\u043a\u043b\u044c|\u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435|\u0432\u044b\u0441\u0442\u0443\u043f\u043b\u0435\u043d\u0438\u0435|\u043a\u043e\u043d\u0444\u0435\u0440\u0435\u043d\u0446\u0438\u044f|\u0441\u0438\u043c\u043f\u043e\u0437\u0438\u0443\u043c|\u0441\u043e\u0431\u0440\u0430\u043d\u0438\u0435|\u043e\u0431\u0441\u0443\u0436\u0434\u0435\u043d\u0438\u0435|\u0434\u043e\u043a\u043b\u0430\u0434|\u0443\u0440\u043e\u043a|\u043f\u0430\u0440\u0430|\u0441\u0435\u0430\u043d\u0441|\u0440\u0430\u0441\u0441\u043a\u0430\u0437|\u0432\u0440\u0435\u043c\u044f|\u043f\u0440\u0430\u0437\u0434\u043d\u0438\u043a|\u043e\u0442\u043f\u0443\u0441\u043a|\u0432\u0435\u0441\u043d\u0430|\u0437\u0438\u043c\u0430|\u043b\u0435\u0442\u043e|\u043e\u0441\u0435\u043d\u044c|\u0432\u044b\u0445\u043e\u0434\u043d\u043e\u0439|\u043f\u0435\u0440\u0438\u043e\u0434|" + dayNames + "|" + monthNames), timeUnit);
    private static final NodePattern durableQuantity = NodePattern.N.lemma("\u043f\u0430\u0440\u0430|\u0441\u043e\u0442\u043d\u044f|\u0434\u044e\u0436\u0438\u043d\u0430|\u0434\u0435\u0441\u044f\u0442\u043e\u043a|\u0442\u044b\u0441\u044f\u0447\u0430|\u043c\u0438\u043b\u043b\u0438\u043e\u043d|\u043c\u0438\u043b\u043b\u0438\u0430\u0440\u0434|\u0442\u0440\u0438\u043b\u043b\u0438\u043e\u043d|\u0447\u0430\u0441\u0442\u044c").withDependent("nmod", durableNoun.noDependents("case"));
    static final NodePattern durable = NodePattern.or(durableNoun, durableQuantity);
    static final NodePattern moment = NodePattern.N.lemma("\u0440\u0430\u0437");

    SemanticRules() {
    }

    static List<Rule.PatternRule> rules() {
        return List.of(new Rule.PatternRule("Semantics.ODET_NADET_CONFUSION", "\u0412\u044b\u0431\u043e\u0440 \u00ab\u043e\u0434\u0435\u0442\u044c\u00bb \u0438\u043b\u0438 \u00ab\u043d\u0430\u0434\u0435\u0442\u044c\u00bb", "\u041e\u0434\u0435\u0432\u0430\u044e\u0442 \u0447\u0435\u043b\u043e\u0432\u0435\u043a\u0430, \u043d\u0430\u0434\u0435\u0432\u0430\u044e\u0442 \u043e\u0434\u0435\u0436\u0434\u0443.", "https://russkiiyazyk.ru/leksika/nadet-odet.html", () -> SemanticRules.odetNadetConfusion(), new Example("<b>\u041e\u0434\u0435\u0432\u0430\u0435\u043c</b> \u043c\u044b \u0448\u0442\u0430\u043d\u0438\u0448\u043a\u0438, \u0431\u0443\u0434\u0435\u043c \u0431\u0435\u0433\u0430\u0442\u044c \u0432 \u043d\u0438\u0445 \u0432\u043f\u0440\u0438\u043f\u0440\u044b\u0436\u043a\u0443.", "<b>\u041d\u0430\u0434\u0435\u0432\u0430\u0435\u043c</b> \u043c\u044b \u0448\u0442\u0430\u043d\u0438\u0448\u043a\u0438, \u0431\u0443\u0434\u0435\u043c \u0431\u0435\u0433\u0430\u0442\u044c \u0432 \u043d\u0438\u0445 \u0432\u043f\u0440\u0438\u043f\u0440\u044b\u0436\u043a\u0443.")), new Rule.PatternRule("Semantics.ABSOLUTE_DATE_ISSUES", "\u041e\u0448\u0438\u0431\u043a\u0438 \u0432 \u0430\u0431\u0441\u043e\u043b\u044e\u0442\u043d\u044b\u0445 \u0434\u0430\u0442\u0430\u0445", "\u0414\u0430\u0442\u044b \u0434\u043e\u043b\u0436\u043d\u044b \u0431\u044b\u0442\u044c \u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u043c\u0438, \u0434\u043d\u0438 \u043d\u0435\u0434\u0435\u043b\u0438 \u0434\u043e\u043b\u0436\u043d\u044b \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u043e\u0432\u0430\u0442\u044c \u0434\u0430\u0442\u0430\u043c.", null, () -> RussianDateChecker.INSTANCE.absolutePattern(), RussianDateChecker.INSTANCE.weekdayExample(DateChecker.YearStrategy.absolute), new Example("\u041f\u0440\u0438\u043c\u0435\u0440 \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e\u0439 \u0434\u0430\u0442\u044b \u2014 <b>31 \u0430\u043f\u0440\u0435\u043b\u044f</b>.", new String[0])), new Rule.PatternRule("Semantics.RELATIVE_DATE_ISSUES", "\u041e\u0448\u0438\u0431\u043a\u0438 \u0432 \u043e\u0442\u043d\u043e\u0441\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0445 \u0434\u0430\u0442\u0430\u0445", "\u041b\u043e\u0433\u0438\u0447\u0435\u0441\u043a\u0438\u0435 \u043e\u0448\u0438\u0431\u043a\u0438 \u0432 \u043f\u0440\u0435\u0434\u043f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u0438, \u0447\u0442\u043e \u0442\u0435\u043a\u0441\u0442 \u043d\u0430\u043f\u0438\u0441\u0430\u043d \u043f\u043e \u043e\u0442\u043d\u043e\u0448\u0435\u043d\u0438\u044e \u043a \u0442\u0435\u043a\u0443\u0449\u0435\u043c\u0443 \u0434\u043d\u044e:\n<ul>\n<li>\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u043f\u0440\u043e\u0448\u0435\u0434\u0448\u0435\u0433\u043e \u0432\u0440\u0435\u043c\u0435\u043d\u0438 \u0441 \u0431\u0443\u0434\u0443\u0449\u0438\u043c\u0438 \u0434\u0430\u0442\u0430\u043c\u0438,\n<li>\u041f\u043e\u0434\u043e\u0437\u0440\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0435 \u0443\u043f\u043e\u043c\u0438\u043d\u0430\u043d\u0438\u044f \u0434\u0430\u0442 \u0432 \u043f\u0440\u043e\u0448\u0435\u0434\u0448\u0435\u043c \u0433\u043e\u0434\u0443 \u0432 \u043d\u0430\u0447\u0430\u043b\u0435 \u043d\u043e\u0432\u043e\u0433\u043e,\n<li>\u0414\u0430\u0442\u044b \u0431\u0435\u0437 \u044f\u0432\u043d\u043e\u0433\u043e \u0443\u043a\u0430\u0437\u0430\u043d\u0438\u044f \u0433\u043e\u0434\u0430 (\u043f\u0440\u0435\u0434\u043f\u043e\u043b\u043e\u0436\u0438\u0442\u0435\u043b\u044c\u043d\u043e, \u0438\u0437 \u043d\u044b\u043d\u0435\u0448\u043d\u0435\u0433\u043e \u0433\u043e\u0434\u0430) \u0441 \u043d\u0435\u0441\u043e\u0432\u043f\u0430\u0434\u0430\u044e\u0449\u0438\u043c \u0434\u043d\u0451\u043c \u043d\u0435\u0434\u0435\u043b\u0438.\n</ul>\n", null, () -> RussianDateChecker.INSTANCE.relativePattern(), new Example("\u041c\u044b \u0441\u0434\u0435\u043b\u0430\u043b\u0438 \u044d\u0442\u043e \u0432 <b>2048 \u0433\u043e\u0434\u0443</b>.", new String[0]), RussianDateChecker.INSTANCE.weekdayExample(DateChecker.YearStrategy.current)));
    }

    private static NodePattern odetNadetConfusion() {
        NodePattern wearable = NodePattern.N.lemma("\u0431\u0430\u0445\u0438\u043b\u044b|\u0431\u0430\u0448\u043c\u0430(\u0447\u043e)?\u043a|\u0431\u0435\u043b\u044c\u0435|\u0431\u043e\u0442\u0438\u043d\u043e(\u0447\u0435)?\u043a|\u0431\u0440\u0430\u0441\u043b\u0435\u0442(\u0438\u043a)?|\u0431\u0440\u043e\u043d\u044f|\u0431\u0440\u044e\u0447?\u043a\u0438|\u0431\u0443\u0440\u043a\u0430|\u0431\u0443\u0441\u0438\u043a\u0438|\u0431\u0443\u0441\u044b|\u0431\u044e\u0441\u0442\u0433\u0430\u043b\u044c\u0442\u0435\u0440|\u0432\u0430\u043b\u0435\u043d\u043e(\u0447\u0435)?\u043a|\u0432\u0430\u0440\u0435\u0436\u043a\u0430|\u0432\u0430\u0442\u043d\u0438(\u0447\u0435)?\u043a|\u0432\u0435\u043d\u0435\u0446|\u0433\u0430\u043b\u0441\u0442\u0443(\u0447\u0435)?\u043a|\u0434\u0436\u0438\u043d\u0441\u044b|\u0434\u043e\u0441\u043f\u0435\u0445|\u0436\u0438\u043b\u0435\u0442(\u0438\u043a|\u043a\u0430)?|\u043a\u0430\u043f\u044e\u0448\u043e\u043d(\u0447\u0438\u043a)?|\u043a\u0435\u0434(\u0438\u043a)?|\u043a\u0435\u043f(\u043e\u0447)?\u043a\u0430|\u043a\u043e\u043b\u0433\u043e\u0442(\u043e\u0447?)\u043a\u0438|\u043a\u043e\u043b\u0435\u0447\u043a\u043e|\u043a\u043e\u043b\u044c\u0446\u043e|\u043a\u043e\u043c\u0431\u0438\u043d\u0435\u0437\u043e\u043d(\u0447\u0438\u043a)?|\u043a\u043e\u043d\u0435\u043a|\u043a\u043e\u0440\u043e\u043d\u0430|\u043a\u043e\u0441\u0442\u044e\u043c(\u0447\u0438\u043a)?|\u043a\u043e\u0441\u044b\u043d(\u043e\u0447)?\u043a\u0430|\u043a\u043e\u0444\u0442(\u043e\u0447)?\u0430|\u043a\u0440\u0435\u0441\u0442(\u0438\u043a)?|\u043a\u0440\u043e\u0441\u0441\u043e\u0432(\u043e\u0447)?\u043a\u0430|\u043a\u0440\u043e\u0441\u0441\u043e\u0432\u043e\u043a|\u043a\u0443\u0440\u0442(\u043e\u0447)?\u043a\u0430|\u043b\u0430\u0441\u0442\u0430|\u043b\u0438\u0444\u0447\u0438\u043a|\u043b\u044b\u0436\u0430|\u043c\u0430\u0435\u0447\u043a\u0430|\u043c\u0430\u0439\u043a\u0430|\u043c\u0430\u0441\u043a\u0430|\u043c\u0435\u0434\u0430\u043b\u044c|\u043c\u0435\u0448\u043e\u043a|\u043d\u0430\u043c\u043e\u0440\u0434\u043d\u0438(\u0447\u0435)?\u043a|\u043d\u0430\u0440\u0443\u0447\u043d\u0438\u043a|\u043d\u0430\u0440\u044f\u0434|\u043d\u043e\u0441\u043e\u043a|\u043d\u043e\u0441\u043e\u0447\u0435\u043a|\u043e\u0431\u0440\u0443\u0447|\u043e\u0431\u0443\u0432\u043a\u0430|\u043e\u0431\u0443\u0432\u044c|\u043e\u0434\u0435\u0436\u0434\u0430|\u043e\u0436\u0435\u0440\u0435\u043b\u044c\u0435|\u043e\u0440\u0434\u0435\u043d|\u043e\u0447(\u043e\u0447)?\u043a\u0438|\u043f\u0430\u043b\u044c\u0442(\u0438\u0448\u043a|\u0435\u0446)?\u043e|\u043f\u0430\u043d\u0430\u043c\u043a?\u0430|\u043f\u0430\u0440\u0430\u043d\u0434\u0436\u0430|\u043f\u0430\u0440\u0438(\u0447\u043e)?\u043a|\u043f\u0435\u043d\u0441\u043d\u0435|\u043f\u0435\u0440\u0435\u0434\u043d\u0438(\u0447\u0435)?\u043a|\u043f\u0435\u0440\u0447\u0430\u0442\u043a\u0430|\u043f\u0438\u0434\u0436\u0430(\u0447\u043e)\u043a|\u043f\u0438\u0436\u0430\u043c\u043a?\u0430|\u043f\u043b\u0430\u0442\u043e(\u0447\u0435)?\u043a|\u043f\u043b\u0430\u0442\u044c(\u0438\u0446)?\u0435|\u043f\u043b\u0430\u0449(\u0438\u043a)?|\u043f\u043e\u0432\u044f\u0437(\u043e\u0447)?\u043a\u0430|\u043f\u043e\u043b\u0443\u0448\u0443\u0431\u043e(\u0447\u0435)?\u043a|\u043f\u0440\u0435\u0437\u0435\u0440\u0432\u0430\u0442\u0438\u0432|\u043f\u0440\u043e\u0442\u0438\u0432\u043e\u0433\u0430\u0437|\u043f\u0443\u0442\u044b|\u043f\u0443\u0445\u043e\u0432\u0438(\u0447\u043e)?\u043a|\u0440\u0430\u043d\u0435\u0446|\u0440\u0443\u0431\u0430\u0448(\u0435\u0447)?\u043a\u0430|\u0440\u0443\u043a\u0430\u0432\u0438\u0446\u0430|\u0440\u0443\u043a\u0430\u0432\u0438\u0447\u043a\u0430|\u0440\u044e\u043a\u0437\u0430(\u0447\u043e)?\u043a|\u0441\u0430\u043d\u0434\u0430\u043b\u0438[\u043a\u044f]?|\u0441\u0430\u043f\u043e\u0433|\u0441\u0430\u043f\u043e\u0436\u043e\u043a|\u0441\u0432\u0438\u0442\u0435\u0440(\u043e\u043a)?|\u0441\u043a\u0430\u0444\u0430\u043d\u0434\u0440|\u0441\u043c\u043e\u043a\u0438\u043d\u0433|\u0441\u043e\u0440\u043e\u0447\u043a\u0430|\u0441\u044e\u0440\u0442\u0443(\u0447\u043e)?\u043a|\u0442\u0430\u043f\u043e(\u0447\u0435)?\u043a|\u0442\u043e\u043f(\u0438\u043a)?|\u0442\u0440\u0443\u0441\u0438\u043a\u0438|\u0442\u0440\u0443\u0441\u044b|\u0442\u0443\u0444\u0435\u043b\u044c\u043a\u0430|\u0442\u0443\u0444\u043b\u044f|\u0444\u043e\u0440\u043c\u0430|\u0444\u0440\u0430\u043a|\u0444\u0443\u0440\u0430\u0436\u043a\u0430|\u0444\u0443\u0442\u0431\u043e\u043b(\u043e\u0447)?\u043a\u0430|\u0445\u0430\u043b\u0430\u0442(\u0438\u043a)?|\u0445\u0438\u0434\u0436\u0430\u0431|\u0447\u0430\u0441\u0438\u043a\u0438|\u0447\u0430\u0441\u044b|\u0448\u0430\u043f(\u043e\u0447)?\u043a\u0430|\u0448\u0430\u0440\u0444(\u0438\u043a)?|\u0448\u043a\u0443\u0440\u0430|\u0448\u043b\u0435\u043c|\u0448\u043b\u044f\u043f\u043a?\u0430|\u0448\u0442\u0430\u043d\u0438\u0448\u043a\u0438|\u0448\u0442\u0430\u043d\u044b|\u0448\u0443\u0431\u043a?\u0430|\u044e\u0431(\u043e\u0447)?\u043a\u0430|\u044f\u0440\u043c\u043e");
        return NodePattern.or(NodePattern.N.lemma("\u043e\u0434\u0435\u0442\u044c|\u043e\u0434\u0435\u0432\u0430\u0442\u044c|\u043e\u0431\u0443\u0442\u044c|\u043e\u0431\u0443\u0432\u0430\u0442\u044c").and(NodePattern.or(NodePattern.N.withDependent("obj|nsubj:pass", wearable), NodePattern.N.withDependent("obj|nsubj:pass").withDependent("obl", NodePattern.N.withDependent("case", NodePattern.N.form("\u043d\u0430"))))).message("\u0421 \u043d\u0435\u043e\u0434\u0443\u0448\u0435\u0432\u043b\u0451\u043d\u043d\u044b\u043c\u0438 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u043c\u0438 \u043e\u0431\u044b\u0447\u043d\u043e \u0443\u043f\u043e\u0442\u0440\u0435\u0431\u043b\u044f\u0435\u0442\u0441\u044f \u00ab\u043d\u0430\u0434\u0435\u0442\u044c\u00bb").correct(NodeCorrector.regexReplace("(\u043e\u0434\u0435|\u043e\u0431\u0443)(\u0432\u0430)?(.*)", "\u043d\u0430\u0434\u0435$2$3")), NodePattern.N.lemma("\u043f\u0435\u0440\u0435\u043e\u0434\u0435(\u0432\u0430)?\u0442\u044c").withDependent("obj", wearable).message("\u0421 \u043d\u0435\u043e\u0434\u0443\u0448\u0435\u0432\u043b\u0451\u043d\u043d\u044b\u043c\u0438 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u043c\u0438 \u043e\u0431\u044b\u0447\u043d\u043e \u0443\u043f\u043e\u0442\u0440\u0435\u0431\u043b\u044f\u0435\u0442\u0441\u044f \u00ab\u043f\u043e\u043c\u0435\u043d\u044f\u0442\u044c\u00bb").correct(NodeCorrector.regexReplace("\u043f\u0435\u0440\u0435\u043e\u0434\u0435(\u0432\u0430)?(.*)", "\u043f\u043e\u043c\u0435\u043d\u044f$1$2")), NodePattern.N.lemma("\u0440\u0430\u0437\u0434\u0435\u0442\u044c|\u0440\u0430\u0437\u0434\u0435\u0432\u0430\u0442\u044c|\u0440\u0430\u0437\u0443\u0442\u044c|\u0440\u0430\u0437\u0443\u0432\u0430\u0442\u044c").withDependent("obj", wearable).message("\u0421 \u043d\u0435\u043e\u0434\u0443\u0448\u0435\u0432\u043b\u0451\u043d\u043d\u044b\u043c\u0438 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u043c\u0438 \u043e\u0431\u044b\u0447\u043d\u043e \u0443\u043f\u043e\u0442\u0440\u0435\u0431\u043b\u044f\u0435\u0442\u0441\u044f \u00ab\u0441\u043d\u044f\u0442\u044c\u00bb").correct(NodeCorrector.regexReplace("(\u0440\u0430\u0437\u0434\u0435|\u0440\u0430\u0437\u0443)(\u0432\u0430)?(.*)", "\u0441\u043d\u044f$2$3")), NodePattern.N.lemma("\u043d\u0430\u0434\u0435\u0442\u044c|\u043d\u0430\u0434\u0435\u0432\u0430\u0442\u044c").withDependent("obj", NodePattern.N.pos("NN:Name.*").andNot(NodePattern.N.pos("NN:Inanim.*"))).message("\u0421 \u043e\u0434\u0443\u0448\u0435\u0432\u043b\u0451\u043d\u043d\u044b\u043c\u0438 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u043c\u0438 \u043e\u0431\u044b\u0447\u043d\u043e \u0443\u043f\u043e\u0442\u0440\u0435\u0431\u043b\u044f\u0435\u0442\u0441\u044f \u00ab\u043e\u0434\u0435\u0442\u044c\u00bb").correct(NodeCorrector.regexReplace("\u043d\u0430\u0434\u0435(\u0432\u0430)?(.*)", "\u043e\u0434\u0435$1$2")));
    }
}

