/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.ru;

import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.common.FeatureRestriction;
import ai.grazie.rules.common.MessageUtil;
import ai.grazie.rules.ru.Case;
import ai.grazie.rules.ru.InflectedForm;
import ai.grazie.rules.ru.IntroductoryConstructions;
import ai.grazie.rules.ru.RussianTreePatterns;
import ai.grazie.rules.ru.RussianValences;
import ai.grazie.rules.ru.SemanticRules;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodeMatch;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.ReportingKind;
import ai.grazie.rules.tree.TextRange;
import ai.grazie.rules.tree.Tree;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AgreementSet {
    static final NodePattern checksMakeSense = NodePattern.or(CommonPatterns.possiblyConj(NodePattern.N.withHeadRelation("nsubj(:pass)?|i?obj|obl(:agent)?|nmod|compound|root|vocative")), NodePattern.N.withDependent("amod|det").andNot(CommonPatterns.possiblyConj(NodePattern.N.withHeadRelation("advmod|det|amod"))), CommonPatterns.possiblyConj(NodePattern.N.withDependent("case")), NodePattern.N.pos("NN.*|ADJ.*").and(CommonPatterns.possiblyConj(NodePattern.N.withDependent("nsubj(:pass)?"))));
    private static final NodePattern isCopulaPredicate = NodePattern.or(NodePattern.N.lemma("\u043c\u043e\u0447\u044c|\u0434\u043e\u043b\u0436\u0435\u043d").withDependent("obl|xcomp", NodePattern.N.withDependent("cop")), NodePattern.N.pos("NN:.*"), NodePattern.N.lemma("\u0442\u043e\u0442"), NodePattern.N.withDependent("expl").withDependent("nsubj.*"), NodePattern.N.pos("ADJ:(MPR|Posit).*|Ord.*").noDependents("cop").withDependent("nsubj", NodePattern.N.form("\u044d?\u0442\u043e")), NodePattern.N.withDependent("cop", NodePattern.N.form("\u0435\u0441\u0442\u044c")).withDependent("nsubj.*", NodePattern.N.pos("PNN.*")));
    private static final NodePattern advMisparsedAsCopula = NodePattern.N.pos("ADV").withDependent("nsubj.*|csubj.*", NodePattern.N.afterHead()).noDependents("cop|aux.*");
    private static final NodePattern nonSubject = NodePattern.or(NodePattern.N.withDependent("mark|cop"), NodePattern.N.withHead("nsubj.*", NodePattern.or(RussianTreePatterns.finiteVerb.andNot(RussianTreePatterns.infinitive).withDependent("aux.*", NodePattern.N.pos("VB.*")), IntroductoryConstructions.firstPersonSgVerbIntro.noDependents("xcomp|ccomp|obj|obl"))));
    private static final NodePattern possibleParticipleArgument = NodePattern.N.withPrevSiblingIncludingOtherSide(NodePattern.N.pos("PT.*"));
    private static final NodePattern instrPredicate = Case.T.posPattern.andOr(NodePattern.N.pos("(ADJ|PT).*").and(CommonPatterns.possiblyConj(NodePattern.N.withDependent("cop|aux:pass", NodePattern.N.markAs("CopLike")))), NodePattern.N.withHead("xcomp", NodePattern.N.markAs("CopLike")).andNot(RussianTreePatterns.clause));
    private static final NodePattern goodBadAllowedToDisagree = NodePattern.N.withDependent("nsubj", NodePattern.N.pos("PNN.*:P[123]")).noDependents("cop");
    private static final NodePattern predicateAllowedToDisagree = NodePattern.or(NodePattern.N.withDependent("case|mark", NodePattern.N.pos("PREP")), NodePattern.N.form("\u044d?\u0442\u043e"), NodePattern.N.pos("ADV|ADJ:Short:Neut|ADJ:Comp").noForm("\u0441\u043e\u0433\u043b\u0430\u0441\u043d\u043e|\u0436\u0430\u043b\u043a\u043e").andOr(NodePattern.N.noForm("\u043f\u043b\u043e\u0445\u043e|\u0445\u043e\u0440\u043e\u0448\u043e"), goodBadAllowedToDisagree).andNot(NodePattern.N.pos("PT_Short:.*")), NodePattern.N.withDependent("cop", NodePattern.N.form("\u044d\u0442\u043e|\u0435\u0441\u0442\u044c")), NodePattern.not(NodePattern.N.pos("ADJ:Short.*")).withDependent("cop", NodePattern.N.form("\u0431\u0443\u0434\u0435\u0442")), NodePattern.N.pos("ADJ:Short.*").pos("ADV").withDependent("obl", RussianTreePatterns.whPhrase), NodePattern.N.pos("Num.*"), NodePattern.N.withDependent("nummod.*"));
    private static final NodePattern complexPredicateAllowedToDisagree = NodePattern.N.noPos("PNN.*").andOr(NodePattern.N.form("\u0440\u0430\u0437"), NodePattern.N.noPos("ADV")).withDependent("cop", NodePattern.N.lemma("\u0431\u044b\u0442\u044c")).withDependent("nsubj.*", NodePattern.N.form("\u044d?\u0442\u043e"));
    private static final NodePattern compoundAmbiguity = NodePattern.N.directlyAfter(NodePattern.N.pos("NN.*").withHeadRelation("nmod"));
    private static final NodePattern loneAll = NodePattern.N.form("\u0432\u0441[\u0435\u0451]").noDependents();
    private static final NodePattern misparsedParticipleObject = NodePattern.N.beforeHead().pos("PT:.*:TRANS.*").withHead("amod", Case.V.posPattern);
    private static final NodePattern misparsedElaborativeAppos = NodePattern.N.pos("PNN.*|ADJ:MPR.*").afterHead().withHead("det|conj", NodePattern.N.withDependent("nsubj.*|csubj.*", RussianTreePatterns.whWord)).trace("\u0447\u0442\u043e \u0432 X, \u0442\u043e \u0436\u0435 \u0441\u0430\u043c\u043e\u0435 \u0438\u043b\u0438 \u043d\u0435\u0442");
    private static final NodePattern tech = NodePattern.N.form("\u0442\u0435\u0445");
    private static final NodePattern takeAdjective = NodePattern.N.pos("ADJ:(Short|Posit|MPR).*|PT.*").noDependents("acl:relcl|mark|cop|nsubj.*|case|aux:pass").noDependents("obl", NodePattern.N.inFormSequence(2, "\u0432", "\u0442\u043e\u043c", "\u0447\u0438\u0441\u043b\u0435")).andNot(misparsedParticipleObject).andNot(NodePattern.N.noSpaceAfter().directlyBefore(CommonPatterns.HYPHEN_NODE).withDependent("conj")).andNot(NodePattern.N.form("\u043a\u043e[\u0439\u0435]").withDependent("fixed")).andNot(NodePattern.N.afterHead().directlyAfter(RussianTreePatterns.openingQuotations)).andNot(NodePattern.N.markAs("Det").withHead("det", NodePattern.N.withDependent("case", NodePattern.N.beforeHead().after("Det")))).andNot(NodePattern.N.withHead("det", NodePattern.N.pos("ADJ:Short.*"))).andNot(NodePattern.N.withHead("det", NodePattern.N.pos("ADJ:Posit.*").withHeadRelation("acl.*"))).andNot(misparsedElaborativeAppos).andNot(tech.noSpaceAfter().beforeHead().directlyBefore(CommonPatterns.dot)).andNot(NodePattern.N.lemma("\u0441\u0430\u043c").andOr(NodePattern.N.directlyBefore(NodePattern.N.lemma("\u0431\u044b\u0442\u044c")), NodePattern.N.inFormSequence(0, ".*", "\u043f\u043e", "\u0441\u0435\u0431\u0435").withHead("amod", NodePattern.N.withDependent("nsubj")), NodePattern.N.directlyAfter(NodePattern.N.pos("NN.*")).directlyBefore(NodePattern.N.pos("NN.*")))).andNot(NodePattern.N.pos("ADV").withHead("amod", NodePattern.N.pos("ADJ.*"))).andNot(NodePattern.N.directlyBefore(CommonPatterns.latinOrNumber)).andNot(loneAll.andOr(NodePattern.N.afterHead(), NodePattern.N.markAs("All").withHead(NodePattern.N.withDependent("det", NodePattern.N.after("All"))))).andNot(NodePattern.custom(AgreementSet::isAmbiguousAdjLike)).andNot(NodePattern.N.form("\u043a\u043e\u0435").directlyBefore(CommonPatterns.noSpaceHyphen));
    private static final NodePattern possibleAmodNmodAmbiguity = NodePattern.N.withDependent("case").withHead("nmod|obl", NodePattern.N.pos("ADJ:Posit.*"));
    private static final NodePattern impersonalPredicate = NodePattern.N.pos(".*:Neut.*|VB:(Past|Real|Fut):.*:Sin:P3");
    private static final NodePattern allowedSgRelative = NodePattern.or(NodePattern.N.withHeadRelation("conj"), NodePattern.N.withHead("obj", NodePattern.N.withHead("conj", NodePattern.N.withDependent("obj"))));
    private static final NodePattern allowedSgAdjWithPluralMain = NodePattern.or(NodePattern.N.withHeadRelation("conj"), NodePattern.N.withDependent("conj"), NodePattern.N.withHead("amod", NodePattern.N.withHead("conj", NodePattern.N.pos("ADJ.*"))), NodePattern.N.lemma("\u043a\u0430\u0436\u0434\u044b\u0439").afterHead().withHeadRelation("det"), NodePattern.N.withHead("det", NodePattern.N.lemma("\u0432\u044b")));
    private static final NodePattern npAllowingDetachablePluralAdjs = NodePattern.N.pos("NN.*").withHeadRelation("conj").noDependents("det|amod");
    private static final NodePattern allowedPluralAdjWithSgNoun = NodePattern.or(NodePattern.N.beforeHead().withHead("det|amod", NodePattern.or(NodePattern.N.withDependent("conj", npAllowingDetachablePluralAdjs), NodePattern.N.withHeadRelation("conj").withNextSibling(npAllowingDetachablePluralAdjs))), NodePattern.N.afterHead().withHeadRelation("det|amod|acl.*").andOr(NodePattern.N.withHead(NodePattern.N.withHeadRelation("conj")), NodePattern.N.withPrevSibling(NodePattern.N.withHeadRelation("conj"))));
    private static final NodePattern misparsedAppos = NodePattern.N.withHeadRelation("conj").withPhraseStart(NodePattern.or(NodePattern.N.form("\u043d\u0435"), CommonPatterns.comma.directlyBefore(NodePattern.N.form("\u043d\u0435"))));
    private static final NodePattern noConjAmbiguities = NodePattern.or(NodePattern.not(NodePattern.N.withHeadRelation("conj")), CommonPatterns.lastWord.noDependents("cc", NodePattern.not(NodePattern.N.form("\u0438"))));
    private static final NodePattern nonGovernableNmod = NodePattern.N.withHeadRelation("nmod").andOr(NodePattern.N.withPhraseStart(NodePattern.or(NodePattern.PUNCT, NodePattern.N.directlyAfter(NodePattern.PUNCT))), NodePattern.N.withDependent("mark"), NodePattern.N.withDependent("nmod", NodePattern.N.withDependent("punct", RussianTreePatterns.dashes)));
    private static final NodePattern postfixNmod = NodePattern.N.afterHead().withHeadRelation("nmod").andNot(nonGovernableNmod);
    private static final NodePattern hasPrepAround = NodePattern.or(NodePattern.N.inPhrase(NodePattern.N.withDependent("case")).andNot(postfixNmod), NodePattern.N.directlyAfter(CommonPatterns.latin.and(CommonPatterns.possiblySkipUp("flat.*", NodePattern.N.withDependent("case")))), NodePattern.N.afterHead().withPrevSibling(NodePattern.N.afterHead().andOr(NodePattern.N.withHeadRelation("conj|appos"), NodePattern.N.noPos()).andOr(NodePattern.N.withDependent("case"), NodePattern.N.directlyAfter(NodePattern.N.withHeadRelation("case")))), NodePattern.custom(n -> n.back().anyMatch(RussianTreePatterns.wordInternalPunctuation::matches)));
    private static final NodePattern npAttachmentAmbiguity = NodePattern.N.withHeadRelation("nsubj(:pass)?|i?obj|obl(:agent)?|nmod|compound").andOr(NodePattern.N.withPrevSibling(NodePattern.N.withHeadRelation("nsubj(:pass)?|i?obj|obl(:agent)?|nmod|compound").afterHead()), NodePattern.N.withHead(NodePattern.N.withDependent("xcomp")));
    private static final NodePattern splitSubjectPart = Case.R.posPattern.withHead("i?obj", NodePattern.N.withDependent("nsubj", NodePattern.N.pos("ADV")));
    private static final NodePattern mayUseStructureCases = NodePattern.N.withHead("nsubj(:pass)?|i?obj|obl(:agent)?|nmod|compound", NodePattern.N.noDependents("flat:foreign").noHeadRelation("cop")).noDependents("cop").noDependents("mark", NodePattern.N.form("\u0447\u0435\u043c")).andNot(nonGovernableNmod).andNot(npAttachmentAmbiguity).andNot(splitSubjectPart);
    private static final NodePattern relMainClauseConjAmbiguity = NodePattern.N.afterHead().withHead("conj", NodePattern.N.afterHead().withHead("acl:relcl", NodePattern.N.afterHead().withHead("nsubj(:pass)?|i?obj|obl(:agent)?|nmod|compound", RussianTreePatterns.clause)));
    private static final NodePattern mainClauseCopula_participle_ambiguity = NodePattern.N.pos("PT.*").withHead("acl", NodePattern.N.withHeadRelation("nsubj")).withDependent("advmod", NodePattern.N.afterHead());
    static final String AGREEMENT_MESSAGE = "\u041d\u0430\u0440\u0443\u0448\u0435\u043d\u043e \u0441\u043e\u0433\u043b\u0430\u0441\u043e\u0432\u0430\u043d\u0438\u0435?";
    private static final NodePattern sameLemmaWithHead = NodePattern.custom(n -> CommonPatterns.haveSameLemma(n, Objects.requireNonNull(n.head())));
    private static final NodePattern ignoreHeadPrep = NodePattern.or(RussianTreePatterns.clause, sameLemmaWithHead, NodePattern.N.withDependent("ccomp"), NodePattern.N.withDependent("det", NodePattern.N.lemma("\u043d\u0438\u043a\u0430\u043a\u043e\u0439")), AgreementSet.hasPreviousConjunct(NodePattern.or(RussianTreePatterns.clause, NodePattern.N.withDependent("case"))), NodePattern.N.withHead("conj", NodePattern.N.withDependent("nmod", NodePattern.N.noPos())), NodePattern.N.withDependent("punct", NodePattern.N.form("/")), NodePattern.N.withPrevSibling(NodePattern.N.withHeadRelation("acl:relcl")));
    private static final NodePattern relclAttachmentAmbiguity = NodePattern.or(NodePattern.N.withHead("nsubj.*|obl", NodePattern.N.withHeadRelation("acl.*")), NodePattern.N.withHeadRelation("obl").withPrevSibling(NodePattern.N.withHeadRelation("obj").afterHead()));
    private static final NodePattern severalPrepositions = CommonPatterns.severalDependents("case|mark");
    private static final NodePattern isSubject = CommonPatterns.possiblyConj(NodePattern.N.withHeadRelation("nsubj.*"));
    private static final NodePattern isObject = CommonPatterns.possiblyConj(NodePattern.N.withHeadRelation("obj"));
    private static final NodePattern chtoZa = NodePattern.N.withDependent("amod", NodePattern.N.form("\u0447\u0442\u043e").beforeHead());
    private static final NodePattern aNeAdj = NodePattern.N.withDependent("cc", NodePattern.N.form("\u0430")).withHead("det|amod", NodePattern.N.withDependent("advmod", NodePattern.N.form("\u043d\u0435").beforeHead()));
    private static final NodePattern byl = NodePattern.N.form("\u0431\u044b\u043b");
    private static final NodePattern ktoAsHead = NodePattern.N.withHead("root|nsubj", NodePattern.N.form("\u043a\u0442\u043e"));
    private static final NodePattern postfixNoPrepNmod = postfixNmod.noDependents("case|mark");
    private static final NodePattern separatedParticiplePhrase = NodePattern.N.pos("PT.*").withDependent("punct").withDependent(".*", NodePattern.not(NodePattern.PUNCT));
    private static final FeatureRestriction<Case> allCases = new FeatureRestriction<Case>("\u041a\u043e\u043d\u0442\u0435\u043a\u0441\u0442", EnumSet.allOf(Case.class));
    private static final NodePattern clauseNom = NodePattern.N.form("\u043a\u0442\u043e|\u0447\u0442\u043e").directlyBefore(NodePattern.N.lemma("\u0442\u0430\u043a\u043e\u0439")).and(RussianTreePatterns.clause);
    private static final NodePattern isFullOfX = NodePattern.N.withDependent("cop").withDependent("amod", NodePattern.N.lemma("\u043f\u043e\u043b\u043d\u044b\u0439"));
    private final Node main;
    private final List<Node> adjectives = new ArrayList<Node>();
    private final Set<Node> relatives = new LinkedHashSet<Node>();
    private final List<ComplexPredicate> predicates = new ArrayList<ComplexPredicate>();
    private final Map<Node, LinkedHashSet<InflectedForm>> node2Features = new LinkedHashMap<Node, LinkedHashSet<InflectedForm>>();
    private final FeatureRestriction<Case> possibleCases;
    private static final NodePattern singleCommaBeforeHead = NodePattern.custom(n -> ((StreamEx)n.nextUntil(Objects.requireNonNull(n.head())).filter(CommonPatterns.comma::matches)).count() == 1L);
    private static final NodePattern prepMisparsedAsAdvmod = NodePattern.N.noDependents("case").and(CommonPatterns.possiblyConj(NodePattern.N.withHeadRelation("nsubj(:pass)?|i?obj|obl(:agent)?|nmod|compound|root"))).withDependent("advmod", NodePattern.N.beforeHead().pos("PREP").noDependents());
    private static final NodePattern possiblyForeign = NodePattern.N.form("\u043a\u043e\u0436\u0435").withDependent("compound", NodePattern.N.noPos());
    private static final NodePattern kurazhu = NodePattern.N.pos("NN:Inanim:Masc:Sin:D").form(".*[\u0443\u044e]").withDependent("case", NodePattern.N.form("\u0434\u043b\u044f"));
    private static final NodePattern possiblyMisparsedParataxis = NodePattern.N.withHeadRelation("nsubj(:pass)?|i?obj|obl(:agent)?|nmod|compound").withPhraseStart(CommonPatterns.colon);
    private static final NodePattern nonMain = NodePattern.or(NodePattern.N.directlyBefore(CommonPatterns.HYPHEN_NODE), NodePattern.N.directlyAfter(CommonPatterns.HYPHEN_NODE), misparsedElaborativeAppos, NodePattern.N.withHeadRelation("nmod").andOr(NodePattern.N.directlyBefore(RussianTreePatterns.closingQuotations), NodePattern.N.directlyAfter(RussianTreePatterns.openingQuotations)), NodePattern.N.pos("INTERJECTION"), NodePattern.N.form("\u0440\u0430\u0437").withDependent("det"), NodePattern.N.pos("PRDC").andNot(NodePattern.N.withHead("nsubj.*|csubj.*", NodePattern.N.pos("VB.*"))), IntroductoryConstructions.pravda, compoundAmbiguity, NodePattern.N.form("\u043e\u0434\u043d\u043e\u043c\u0443|\u043e\u0434\u043d\u043e\u0439|\u043e\u0434\u043d\u0438\u043c").noDependents().withHeadRelation("obl"), NodePattern.N.form("\u043e\u0434\u0438\u043d|\u043e\u0434\u043d\u0430|\u043e\u0434\u043d\u0438").noDependents().withHead("obl", CommonPatterns.skipUp("xcomp", CommonPatterns.possiblySkipDown("aux", RussianTreePatterns.finiteVerb))), NodePattern.N.inFormSequence(0, "\u0441\u0432\u044f\u0442\u0430\u044f", "\u0441\u0432\u044f\u0442\u044b\u0445"), NodePattern.N.form("\u0434\u0440\u0443\u0433").and(CommonPatterns.beforeSkipping(NodePattern.N.pos("PREP"), NodePattern.N.lemma("\u0434\u0440\u0443\u0433"))), ktoAsHead.withNextSibling(byl), Case.Nom.posPattern.beforeHead().withHead(NodePattern.N.directlyAfter(RussianTreePatterns.dashes).directlyBefore(CommonPatterns.colon)), Case.Nom.posPattern.afterHead().markAs("Nom").withHead("nsubj", NodePattern.ROOT.before(RussianTreePatterns.dashes.andNot(CommonPatterns.noSpaceHyphen).before("Nom"))), Case.D.posPattern.withHead("iobj", RussianTreePatterns.infinitive), loneAll.withHead("nsubj", NodePattern.ROOT), NodePattern.ROOT.and(Case.Nom.posPattern).withDependent("case", NodePattern.N.form("\u043e")), NodePattern.or(NodePattern.ROOT, CommonPatterns.firstChildPhrase.withHead(RussianTreePatterns.clause).noDependents("case")).withDependent("det", NodePattern.N.form("\u044d\u0442\u043e")), NodePattern.N.withHead("conj", NodePattern.or(NodePattern.N.withHead("i?obj|obl", NodePattern.N.withHeadRelation("acl.*")), NodePattern.N.withHeadRelation("nmod|det"))), possiblyMisparsedParataxis.trace("a colon-separated NP, possibly misparsed parataxis"), Case.D.posPattern.withHead("iobj", Case.R.posPattern.and(CommonPatterns.possiblyConj(NodePattern.or(possiblyMisparsedParataxis, NodePattern.N.withHeadRelation("root|advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis"))))).trace("\u043e\u0442\u043b\u0438\u0447\u043d\u043e\u0433\u043e \u0434\u043d\u044f \u0442\u0435\u0431\u0435"), prepMisparsedAsAdvmod, NodePattern.N.withDependent("nmod", NodePattern.N.withDependent("case").beforeHead().markAs("NMod")).withDependent("case", NodePattern.N.before("NMod")), NodePattern.N.withDependent("amod", NodePattern.N.withDependent("conj")).withHeadRelation("nmod").beforeHead(), NodePattern.N.withHeadRelation("obl").withDependent("mark", NodePattern.N.form("\u043a\u0430\u043a")), NodePattern.N.inFormSequence(0, "\u043a\u0440\u043e\u0432\u044c", "\u0438\u0437", "\u043d\u043e\u0441\u0443"), NodePattern.N.inFormSequence(1, "\u0432", "\u0434\u043e\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435|\u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0438\u0435"), NodePattern.N.inFormSequence(1, "\u0441\u043e", "\u0442\u043e\u0432\u0430\u0440\u0438\u0449\u0438"), NodePattern.N.inFormSequence(1, "\u0441", "\u0433\u043e\u043b\u043e\u0434\u0443"), NodePattern.N.inFormSequence(2, "\u043d\u0430", "\u043a\u0430\u0436\u0434\u043e\u043c", "\u0448\u0430\u0433\u0443"), NodePattern.N.inFormSequence(2, "\u0440\u0430\u0437", "\u043e\u0442", "\u0440\u0430\u0437\u0443"), NodePattern.N.form("\u0430\u0432\u0442\u043e").directlyBefore(NodePattern.N.lemma("\u0442\u0435\u0441\u0442")), NodePattern.N.form("\u0441\u0430\u043c[\u0430\u043e\u0438]?").noDependents(), NodePattern.N.form("\u0432\u0435\u043a\u0438").withDependent("case", NodePattern.N.inFormSequence(0, "\u0432", "\u043a\u043e\u0438")), NodePattern.N.withHeadRelation("conj").form("\u043f\u0440\u043e\u0447\u0430\u044f"), NodePattern.N.withDependent("case", NodePattern.N.directlyBefore(CommonPatterns.colon)), CommonPatterns.possiblyConj(NodePattern.or(NodePattern.N.withDependent("obl", NodePattern.N.beforeHead().lemma("\u043a\u0430\u0436\u0443\u0449\u0438\u0439\u0441\u044f")), NodePattern.N.withDependent("appos|nummod.*|flat:(foreign|name)|orphan"), NodePattern.N.withDependent("advmod", RussianValences.genAdverb))), NodePattern.N.onlyPos("NN:Fam:.*").withDependent("amod").andNot(CommonPatterns.capitalized).trace("wrong inflection mistagged as a surname (\u0447\u0435\u0441\u0442\u043d\u044b\u0445 \u0440\u044b\u0446\u0430\u0440\u0435\u0432)"), possiblyForeign, kurazhu, NodePattern.N.beforeHead().withHeadRelation("nsubj").and(singleCommaBeforeHead), NodePattern.N.pos("PNN:.*:Nom.*").withHead(NodePattern.N.form("\u0435\u0441\u0442\u044c").noDependents("aux|obj", NodePattern.N.noPos(".*:Nom.*"))), NodePattern.N.pos("PNN:.*:Nom.*").and(CommonPatterns.lastWord).directlyAfter(NodePattern.N.form("\u043a\u0430\u043a")), NodePattern.N.inFormSequence(1, "\u043d\u0430", "[\u0432\u0442]\u044b"), NodePattern.N.form("\u0434\u0443\u0431\u043b\u044c").withDependent("advmod", NodePattern.N.noPos()), NodePattern.N.withDependent("case", NodePattern.N.pos("PREP").afterHead()), NodePattern.N.form("\u044d?\u0442\u043e").withHeadRelation("nsubj").andOr(NodePattern.N.directlyBefore(NodePattern.ROOT.noPos(".*:Short:.*")), NodePattern.N.withHead(NodePattern.N.pos("PNN.*P[123]|ADJ:MPR.*").withDependent("cop", NodePattern.N.lemma("\u0431\u044b\u0442\u044c")))), NodePattern.N.pos(".*:PL:R").withOnlyDependents(NodePattern.N.pos(".*:R")).withHead("obj", NodePattern.N.pos("VB:.*:TRANS:PFV:.*")), NodePattern.N.withHead("obj", NodePattern.N.pos(RussianValences.passiveParticiple.pattern())).trace("unlikely to suggest anything useful in a passive participle object"), NodePattern.N.formCaseSensitive("\u041b\u0435\u0441[\u044c\u044e\u044f]|\u0420\u0443\u0441\u0441[\u0430\u0435\u044b]|\u041c\u0438\u0440[\u0430\u0435\u044b]").trace("unknown proper name"), NodePattern.N.form("\u043f\u0435\u0440\u0435\u0432\u043e\u0434\u0447\u0438\u043a|\u0440\u0435\u0444\u0435\u0440\u0435\u043d\u0442\u044b?|\u0433\u0438\u0434\u044b?").noPos(".*:V.*").trace("inanimate \u043f\u0435\u0440\u0435\u0432\u043e\u0434\u0447\u0438\u043a|\u0440\u0435\u0444\u0435\u0440\u0435\u043d\u0442|\u0433\u0438\u0434"), NodePattern.N.form("\u0447\u0442\u043e").withDependent("amod", NodePattern.N.pos("ADJ:.*:R")), NodePattern.N.withHeadRelation("nsubj").pos("NN:.*:Fem:Sin:R").withDependent("amod", NodePattern.N.pos(".*Fem:R")));
    private static final NodePattern unrelatedClauseConj = NodePattern.or(NodePattern.N.withDependent("[cn]subj.*|flat:foreign"), NodePattern.N.withDependent("i?obj|obl", NodePattern.N.beforeHead()), CommonPatterns.possiblySkipDown("aux", NodePattern.N.pos(".*:P[12].*")), NodePattern.N.pos("VB:.*PL:P3").withHead("conj", NodePattern.N.noPos("VB:.*PL:P3")), NodePattern.N.pos("VB:Past:.*").noDependents("cc"), NodePattern.N.withDependent("cc", NodePattern.N.form("\u0438").directlyAfter(CommonPatterns.comma.beforeHead())), impersonalPredicate);
    private static final NodePattern noGovernmentCheck = NodePattern.or(NodePattern.N.pos("ADV|ADJ:Comp|VB.*"), NodePattern.N.form("\u0438\u0445|\u0435\u0433\u043e|\u0435[\u0435\u0451]"), NodePattern.N.withDependent("amod", misparsedParticipleObject), NodePattern.N.directlyAfter(RussianTreePatterns.openingQuotations), NodePattern.N.inFormSequence(1, "\u0431\u0435\u0437|\u0441", "\u0433\u043b\u0430\u0437\u0443"), NodePattern.N.inFormSequence(1, "\u043d\u0430", "\u0434\u043d\u044e|\u043f\u043e\u0432\u043e\u0434\u0443"), NodePattern.N.inFormSequence(1, "\u043e\u0442", "\u0440\u043e\u0434\u0443"), NodePattern.N.inFormSequence(1, "\u043f\u043e", "\u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u0438"));

    private AgreementSet(Node main, List<Node> adjectives, List<Node> relatives, List<ComplexPredicate> predicates, List<InflectedForm> onMain) {
        this.main = main;
        this.node2Features.put(main, new LinkedHashSet<InflectedForm>(onMain));
        for (Node adj : adjectives) {
            if ((adj = this.initForms(adj)) == null) continue;
            this.adjectives.add(adj);
        }
        for (Node rel : relatives) {
            if ((rel = this.initForms(rel)) == null) continue;
            this.relatives.add(rel);
        }
        for (ComplexPredicate predicate : predicates) {
            Node head;
            Node finite = predicate.finite == null ? null : this.initForms(predicate.finite);
            Node node = head = predicate.head == null ? null : this.initForms(predicate.head);
            if (finite == null && head == null) continue;
            this.predicates.add(new ComplexPredicate(head, finite));
        }
        this.possibleCases = this.calcPossibleCases(main);
    }

    @Nullable
    private Node initForms(Node node) {
        List<InflectedForm> forms = InflectedForm.fromPosTags(node);
        if (forms.isEmpty()) {
            return null;
        }
        this.node2Features.put(node, new LinkedHashSet<InflectedForm>(forms));
        return node;
    }

    private static NodePattern hasPreviousConjunct(NodePattern matching) {
        return NodePattern.N.markAs("Conjunct").withHead("conj", NodePattern.N.withDependent("conj", matching.before("Conjunct")));
    }

    @Nullable
    static AgreementSet create(Node main) {
        Node predicate;
        if (nonMain.matches(main)) {
            return null;
        }
        List<InflectedForm> onMain = InflectedForm.fromNPHead(main);
        if (onMain.isEmpty()) {
            return null;
        }
        Node node = predicate = main.hasHeadRelation("nsubj.*") && !nonSubject.matches(main) ? main.head() : null;
        if (advMisparsedAsCopula.matches(predicate)) {
            predicate = null;
        }
        ArrayList<Node> allPredicates = new ArrayList<Node>();
        if (predicate != null) {
            if (predicate.hasHeadRelation("conj")) {
                return null;
            }
            if (predicate.hasHeadRelation("acl:relcl") && AgreementSet.findRelWh(predicate) != null) {
                return null;
            }
            if (predicate.hasPos("ADJ:Short:.*") && predicate.hasDependent("aux:pass")) {
                return null;
            }
            if (!predicate.hasPos("VB:.*") && main.hasForm("\u0432\u044b")) {
                return null;
            }
            if (AgreementSet.hasSubjectArgumentAmbiguity(main, predicate)) {
                return null;
            }
            if (main.hasLemma("\u0447\u0442\u043e") && predicate.hasHeadRelation("acl:relcl")) {
                return null;
            }
            if (isCopulaPredicate.matches(predicate)) {
                return null;
            }
            if (RussianTreePatterns.openingQuotations.matches(predicate.prevNode())) {
                return null;
            }
            allPredicates.add(predicate);
            boolean vb = predicate.hasPos("VB.*");
            boolean adj = predicate.hasPos("ADJ:Short.*|PT_Short.*");
            if (!predicate.hasHeadRelation("conj|ccomp|acl")) {
                Node conj;
                Iterator<Node> iterator = predicate.findDependents("conj").iterator();
                while (!(!iterator.hasNext() || unrelatedClauseConj.matches(conj = iterator.next()) || conj.hasPos("PT_Short:Past:.*") && !predicate.hasPos("PT_Short:Past:.*") || conj.hasPos("VB:.*:PL") && !predicate.hasPos("VB:.*:PL"))) {
                    boolean matchingPos;
                    boolean bl = matchingPos = vb && conj.hasPos("VB.*") || adj && conj.hasPos("ADJ:Short.*|PT_Short.*");
                    if (!matchingPos) break;
                    allPredicates.add(conj);
                }
            }
        }
        if (isFullOfX.matches(main)) {
            return null;
        }
        ArrayList<ComplexPredicate> predicates = new ArrayList<ComplexPredicate>();
        for (Node each : allPredicates) {
            ComplexPredicate complex = ComplexPredicate.from(instrPredicate.matches(each) ? null : each, AgreementSet.findFiniteCandidate(each), main);
            if (complex == null) continue;
            predicates.add(complex);
        }
        List adjectives = ((StreamEx)((StreamEx)StreamEx.of(main.findDependents("det|amod|acl")).filter(takeAdjective::matches)).flatMap(n -> StreamEx.of((Object)n).append(n.findDependents("det|amod|conj"))).filter(takeAdjective::matches)).toList();
        if (adjectives.stream().anyMatch(n -> possibleParticipleArgument.matches((Node)n))) {
            return null;
        }
        List relatives = ((StreamEx)StreamEx.of(main.findDependents("acl:relcl")).filter(relcl -> !AgreementSet.isAmbiguousAdjLike(relcl))).toFlatList(AgreementSet::scanRelativeClause);
        return new AgreementSet(main, adjectives, relatives, predicates, onMain);
    }

    private static List<Node> scanRelativeClause(Node relcl) {
        Node mainWh = AgreementSet.findRelWh(relcl);
        if (mainWh == null) {
            return List.of();
        }
        ArrayList<Node> toCheck = new ArrayList<Node>();
        toCheck.add(mainWh);
        ArrayList<ComplexPredicate> predicates = new ArrayList<ComplexPredicate>();
        Node mainSubj = relcl.findSingleDependent("nsubj.*");
        if (mainSubj == mainWh) {
            predicates.add(ComplexPredicate.from(relcl, mainWh));
        }
        for (Node conj : relcl.findDependents("conj")) {
            Node subj;
            Node wh = AgreementSet.findRelWh(conj);
            if (wh != null) {
                toCheck.add(wh);
            }
            if ((subj = conj.findSingleDependent("nsubj.*")) != wh || subj == null && mainWh != mainSubj) continue;
            predicates.add(ComplexPredicate.from(conj, subj != null ? subj : mainSubj));
        }
        return ((StreamEx)((StreamEx)StreamEx.of(predicates).filter(Objects::nonNull)).flatCollection(ComplexPredicate::nodes).append(toCheck).distinct()).toList();
    }

    static Node findRelWh(Node relcl) {
        Node wh = RussianTreePatterns.findWh(relcl);
        return wh != null && wh.hasForm("\u043a\u043e\u0442\u043e\u0440.*|\u0447\u0442\u043e") ? wh : null;
    }

    private static boolean isImpersonalClause(@Nullable Node subject, @NotNull Node finite) {
        return impersonalPredicate.matches(finite) && (subject == null || Case.R.isPresentOn(subject) || Case.D.isPresentOn(subject));
    }

    @NotNull
    private static Node findFiniteCandidate(Node each) {
        Optional copAux = StreamEx.of(each.findDependents("cop|aux.*")).findFirst(n -> !n.hasForm("\u0431\u044b?"));
        return copAux.orElse(each);
    }

    private static boolean isAmbiguousAdjLike(Node node) {
        Node prev;
        Node head = node.head();
        if (head != null) {
            if (head.isBefore(node)) {
                if (CommonPatterns.possiblyConj(NodePattern.N.withHeadRelation("nmod")).matches(head)) {
                    return true;
                }
                if (misparsedAppos.matches(head)) {
                    return true;
                }
                if (relclAttachmentAmbiguity.matches(head)) {
                    return true;
                }
                if (NodePattern.N.withPrevSibling(NodePattern.N.afterHead().withHeadRelation("nmod")).matches(node)) {
                    return true;
                }
                if (head.hasHeadRelation("root") && head.hasDependent("case") && head.hasDependent("nsubj")) {
                    return true;
                }
            }
            if (head.isAfter(node)) {
                if (node.nextUntil(head).anyMatch(RussianTreePatterns.closingQuotations::matches)) {
                    return true;
                }
            }
        }
        if (!node.hasPos("PT.*") && !node.hasHeadRelation("acl.*")) {
            return false;
        }
        for (prev = node.prevSibling(); prev != null && prev.hasHeadRelation("punct"); prev = prev.prevSibling()) {
        }
        return prev != null && prev.hasHeadRelation("nmod");
    }

    @Nullable
    private NodeMatch checkGovernment(NodeMatch match) {
        if (noGovernmentCheck.matches(this.main) || this.seems_adjMain_vs_mainGen_ambiguity()) {
            return null;
        }
        Node prep = AgreementSet.findPreposition(this.main);
        if (this.possibleCases.isRestricted() && this.filterCase((Collection<InflectedForm>)this.node2Features.get(this.main)).isEmpty() && noConjAmbiguities.matches(this.main) && !this.seemsAmodNmodAmbiguity()) {
            return this.fixCase(match, prep);
        }
        if (prep == null && !hasPrepAround.matches(this.main) && this.hasOnlyPCase() && !this.main.hasHeadRelation("amod|det|nummod.*|appos|parataxis|flat.*")) {
            if (this.main.hasHeadRelation("nsubj.*|root")) {
                match = this.suggestCases(match, List.of(Case.Nom));
            } else if (this.main.hasHeadRelation("nmod")) {
                match = this.suggestCases(match, List.of(Case.R));
            }
            return this.addPreposition(match);
        }
        return null;
    }

    private boolean hasOnlyPCase() {
        return this.toMatchCase().allMatch(f -> f.caze == Case.P || f.caze == Case.P2);
    }

    private boolean seemsAmodNmodAmbiguity() {
        return this.adjectives.stream().takeWhile(a -> !this.filterCase((Collection<InflectedForm>)this.node2Features.get(a)).isEmpty()).findAny().isPresent() && possibleAmodNmodAmbiguity.matches(this.main);
    }

    private boolean seems_adjMain_vs_mainGen_ambiguity() {
        Node prev = this.main.prevNode();
        if (prev == null || prev.head() != this.main || !Case.R.posPattern.matches(this.main)) {
            return false;
        }
        String caseRegexp = AgreementSet.findPreposition(this.main) != null ? StreamEx.of(this.possibleCases.allowed()).joining((CharSequence)"|") : "R";
        return prev.tagIndependently().hasPos("NN:[^F].*:(" + caseRegexp + ")($|:.*)");
    }

    private NodeMatch addPreposition(NodeMatch match) {
        String[] preps;
        Node anchor = Objects.requireNonNullElse(this.main.findSingleDependent("det"), this.main);
        Node phraseStart = anchor.phraseStart();
        if (phraseStart.hasForm("\u043d\u0435")) {
            match = match.withCorrector(NodeCorrector.replace(phraseStart, "\u043d\u0430")).withReportedNode(phraseStart);
        }
        if (anchor.prevNode() != null && anchor.prevNode().hasForm("\u0432|\u043d\u0430|\u043e|\u043f\u0440\u0438")) {
            return null;
        }
        for (String s : preps = new String[]{"\u0432", "\u043d\u0430", "\u043e", "\u043f\u0440\u0438"}) {
            match = match.withCorrector(NodeCorrector.insertBefore(anchor, s + " "));
        }
        return match.withTouchedNodes(this.node2Features.keySet()).withMessage("\u041f\u0440\u0435\u0434\u043b\u043e\u0436\u043d\u044b\u0439 \u043f\u0430\u0434\u0435\u0436 \u0442\u0440\u0435\u0431\u0443\u0435\u0442 \u043f\u0440\u0435\u0434\u043b\u043e\u0433\u0430").withReportedNode(this.main);
    }

    private NodeMatch fixCase(NodeMatch match, @Nullable Node prep) {
        if (prep != null && prep.hasForm("\u0437\u0430") && chtoZa.matches(this.main)) {
            return null;
        }
        if (NodePattern.N.inFormSequence(0, "\u0438\u0437", "\u0437\u0430").matches(prep)) {
            return null;
        }
        if (prep != null && this.main.prevNode() == prep) {
            String joined = prep.form() + this.main.form();
            if (this.main.tree().treeSupport().tagToken(joined).hasPos("NN:[^F].*|ADV") && !joined.equalsIgnoreCase("\u0443\u0432\u0430\u043c") && !joined.equalsIgnoreCase("\u0441\u043d\u0430\u043c") && !joined.equalsIgnoreCase("\u0441\u0442\u043e\u0447\u043a\u0438")) {
                match = match.withCorrector(NodeCorrector.replaceNodes(prep, this.main, joined));
            }
        }
        match = this.suggestCases(match, ((StreamEx)StreamEx.of(this.possibleCases.allowed()).filter(c -> c != Case.Nom)).toList());
        List caseNames = ((StreamEx)((StreamEx)StreamEx.of(this.possibleCases.allowed()).sorted()).map(c -> c.presentableGen).distinct()).toList();
        if (prep != null) {
            TextRange prepRange = Case.izZa.matches(prep) ? new TextRange(prep.startOffset(), prep.neighbor(2).endOffset()) : prep.textRange();
            match = match.withReportedRange(prepRange, prep.tree(), ReportingKind.Hover);
        }
        return match.withTouchedNodes(this.node2Features.keySet()).withMessage(this.possibleCases.reason() + " \u0442\u0440\u0435\u0431\u0443\u0435\u0442 " + MessageUtil.coordinate(caseNames, " \u0438\u043b\u0438 ", " \u0438\u043b\u0438 ") + " \u043f\u0430\u0434\u0435\u0436\u0430");
    }

    private NodeMatch suggestCases(NodeMatch match, List<Case> possibleCases) {
        List<InflectedForm> toTry = this.possibleInflections(possibleCases);
        for (InflectedForm form : toTry) {
            Map<Node, NodeCorrector> correctors = this.imposeFeatures(form);
            match = match.withCorrector(NodeCorrector.joinAll(correctors.values())).withReportedNodes(correctors.keySet());
        }
        if (this.main.form().length() == 1) {
            return CommonPatterns.highlightPlusOneChar.match(this.main, match);
        }
        return match;
    }

    @Nullable
    NodeMatch check(NodeMatch match) {
        NodeMatch result = this.checkAgreement(match);
        return result != null ? result : this.checkGovernment(match);
    }

    @Nullable
    private NodeMatch checkAgreement(NodeMatch match) {
        if (this.adjectives.isEmpty() && this.predicates.isEmpty() && this.relatives.isEmpty()) {
            return null;
        }
        if (this.hasUnpairedQuotesBetweenSetNodes()) {
            return null;
        }
        Set<InflectedForm> mainForms = this.filterCase(AgreementSet.augmentMainFeatures(this.main, (Set<InflectedForm>)this.node2Features.get(this.main)));
        if (mainForms.isEmpty() && this.seemsAmodNmodAmbiguity()) {
            return null;
        }
        if (this.seems_adjMain_vs_mainGen_ambiguity()) {
            return null;
        }
        boolean adjMismatch = !this.checkAdjectiveAgreement(mainForms);
        boolean relMismatch = !this.checkRelativeAgreement(mainForms);
        List<Object> possiblyMisparsedSiblings = adjMismatch ? this.possiblyMisparsedSiblings() : List.of();
        boolean svMismatch = false;
        for (ComplexPredicate pair : this.predicates) {
            if (pair != this.predicates.get(0) || !(svMismatch |= !this.checkSubjectVerbAgreement(mainForms, pair)) || !this.node2Features.get(this.main).stream().anyMatch(f -> !f.matchesCase(this.possibleCases.allowed()))) continue;
            for (Node node : possiblyMisparsedSiblings) {
                if (!this.checkSubjectVerbAgreement(AgreementSet.augmentMainFeatures(node, (Set<InflectedForm>)this.node2Features.get(node)), pair)) continue;
                return null;
            }
        }
        if (!svMismatch && !possiblyMisparsedSiblings.isEmpty()) {
            return null;
        }
        if (svMismatch || adjMismatch || relMismatch) {
            if (this.predicates.isEmpty() && this.isGovernmentIssue()) {
                return null;
            }
            match = match.withCorrectors(this.specializedFixes());
            ArrayList availableFeatures = Lists.newArrayList((Iterable)Iterables.concat(this.node2Features.values()));
            List<InflectedForm> possibleInflections = this.possibleInflections(this.possibleCases.allowed());
            List<InflectedForm> toTry = ((StreamEx)StreamEx.of(possibleInflections).filter(f1 -> availableFeatures.stream().anyMatch(f2 -> f1.unify((InflectedForm)f2) != null))).toList();
            if (toTry.isEmpty()) {
                toTry = possibleInflections;
            }
            for (InflectedForm form : toTry) {
                Map<Node, NodeCorrector> correctors = this.imposeFeatures(form);
                match = match.withCorrector(NodeCorrector.joinAll(correctors.values())).withReportedNodes(correctors.keySet());
            }
            return match.withTouchedNodes(this.node2Features.keySet()).withMessage(AGREEMENT_MESSAGE);
        }
        return null;
    }

    private List<NodeCorrector> specializedFixes() {
        String prepReplacement;
        Node prep = AgreementSet.findPreposition(this.main);
        String string = prepReplacement = prep == null ? null : AgreementSet.fixPrep(prep);
        if (prepReplacement != null) {
            return List.of(NodeCorrector.replace(prep, prepReplacement));
        }
        if (this.adjectives.size() == 1 && tech.matches(this.adjectives.get(0)) && this.relatives.isEmpty() && !this.filterCase((Collection<InflectedForm>)this.node2Features.get(this.main)).isEmpty()) {
            return List.of(NodeCorrector.replace(this.adjectives.get(0), "\u0442\u0435\u0445."));
        }
        return List.of();
    }

    @Nullable
    private static String fixPrep(Node prep) {
        if (NodePattern.N.inFormSequence(0, "\u0432\u043e", "\u0432\u0441\u0435\u0433\u043e").matches(prep)) {
            return "\u0441\u043e";
        }
        return null;
    }

    private boolean hasUnpairedQuotesBetweenSetNodes() {
        boolean seenSetElement = false;
        int quoteCount = 0;
        for (Node node : this.main.tree().nodes()) {
            if (this.node2Features.containsKey(node)) {
                seenSetElement = true;
                if (quoteCount % 2 == 1) {
                    return true;
                }
                quoteCount = 0;
                continue;
            }
            if (!seenSetElement || !RussianTreePatterns.anyQuotation.matches(node)) continue;
            ++quoteCount;
        }
        return false;
    }

    private boolean isGovernmentIssue() {
        return this.toMatchCase().noneMatch(f -> f.matchesCase(this.possibleCases.allowed()));
    }

    private StreamEx<InflectedForm> toMatchCase() {
        return (StreamEx)StreamEx.of((Object)this.main).append(this.adjectives).map(this.node2Features::get).flatCollection(Function.identity()).distinct();
    }

    private List<InflectedForm> possibleInflections(Collection<Case> possibleCases) {
        List<InflectedForm.Number> numbers;
        List<InflectedForm.Gender> genders;
        boolean pronoun = this.main.hasPos("PNN.*");
        LinkedHashSet<InflectedForm> onMain = this.node2Features.get(this.main);
        ArrayList availableFeatures = Lists.newArrayList((Iterable)Iterables.concat(this.node2Features.values()));
        List<InflectedForm.Animacy> animacies = AgreementSet.possibleFeatures(onMain, f -> f.animacy);
        if (animacies.isEmpty()) {
            Collections.addAll(animacies, InflectedForm.Animacy.values());
        }
        if ((genders = AgreementSet.possibleFeatures(pronoun ? availableFeatures : onMain, f -> f.gender)).isEmpty()) {
            Collections.addAll(genders, InflectedForm.Gender.values());
        }
        if (this.main.hasPos("PNN:.*:P[12]")) {
            genders.addAll(InflectedForm.P12Genders);
        }
        LinkedHashSet<InflectedForm.Person> persons = new LinkedHashSet<InflectedForm.Person>(List.of(InflectedForm.Person.P3));
        if (pronoun) {
            persons.addAll(AgreementSet.possibleFeatures(availableFeatures, f -> f.person));
        }
        if (!(numbers = AgreementSet.possibleFeatures(availableFeatures, f -> f.number)).contains((Object)InflectedForm.Number.Sin) && this.main.lowForm().endsWith("\u0438\u0439")) {
            numbers.add(InflectedForm.Number.Sin);
        }
        ArrayList<InflectedForm> result = new ArrayList<InflectedForm>();
        for (InflectedForm.Animacy animacy : animacies) {
            for (InflectedForm.Person person : persons) {
                for (Case caze : possibleCases) {
                    if (numbers.contains((Object)InflectedForm.Number.Sin)) {
                        for (InflectedForm.Gender gender : genders) {
                            result.add(new InflectedForm(gender, InflectedForm.Number.Sin, person, caze, animacy));
                        }
                    }
                    InflectedForm plural = new InflectedForm(null, InflectedForm.Number.PL, person, caze, animacy);
                    if (!numbers.contains((Object)InflectedForm.Number.PL) && !this.hasSimilarNounPlural(caze)) continue;
                    result.add(plural);
                }
            }
        }
        return result;
    }

    private boolean hasSimilarNounPlural(Case caze) {
        return this.main.hasPos("NN.*") && this.main.tree().treeSupport().inflectNode(this.main, "NN.*", "NN:.*:PL:" + String.valueOf((Object)caze)).stream().anyMatch(s -> AgreementSet.differByOneChar(s, this.main.form()));
    }

    private static boolean differByOneChar(String s1, String s2) {
        return s1.length() == s2.length() && Strings.commonPrefix((CharSequence)s1, (CharSequence)s2).length() + Strings.commonSuffix((CharSequence)s1, (CharSequence)s2).length() == s1.length() - 1 || s1.substring(0, s1.length() - 1).equals(s2);
    }

    private static <T> List<T> possibleFeatures(Collection<InflectedForm> forms, Function<InflectedForm, T> extractor) {
        return ((StreamEx)((StreamEx)StreamEx.of(forms).map(extractor).filter(Objects::nonNull)).distinct()).toMutableList();
    }

    private boolean checkAdjectiveAgreement(Set<InflectedForm> mainForms) {
        Set<InflectedForm> unified = mainForms;
        for (Node adj : this.adjectives) {
            if (unified.isEmpty()) break;
            LinkedHashSet<InflectedForm> allForms = this.node2Features.get(adj);
            Set forms = this.filterCase(allForms);
            if (allowedSgAdjWithPluralMain.matches(adj)) {
                forms = InflectedForm.addNumber(forms, InflectedForm.Number.PL).toSet();
            } else if (allowedPluralAdjWithSgNoun.matches(adj)) {
                forms = InflectedForm.addNumber(forms, InflectedForm.Number.Sin).toSet();
            }
            if (!(unified = AgreementSet.unifyFeatures(unified, forms)).isEmpty() || !adj.isAfter(this.main) || !this.couldBeGenitiveNMod(adj, allForms) && !aNeAdj.matches(adj)) continue;
            return true;
        }
        return !unified.isEmpty();
    }

    private boolean couldBeGenitiveNMod(Node adj, LinkedHashSet<InflectedForm> allForms) {
        return (this.main.hasPos("NN:.*") || this.main.hasPos("ADJ.*") && adj.hasHeadRelation("det")) && allForms.stream().anyMatch(f -> f.caze == Case.R);
    }

    private boolean checkRelativeAgreement(Set<InflectedForm> mainForms) {
        Set<InflectedForm> unified = mainForms;
        for (Node rel : this.relatives) {
            Set forms = ((StreamEx)StreamEx.of((Collection)this.node2Features.get(rel)).map(f -> f.removeCasePerson()).filter(Objects::nonNull)).toSet();
            if (rel.isAfter(this.main) && allowedSgRelative.matches(this.main)) {
                forms = InflectedForm.addNumber(forms, InflectedForm.Number.Sin).toSet();
            }
            if (!(unified = AgreementSet.unifyFeatures(unified, forms)).isEmpty()) continue;
            return relMainClauseConjAmbiguity.matches(rel);
        }
        return true;
    }

    private boolean checkSubjectVerbAgreement(Set<InflectedForm> subjectForms, ComplexPredicate predicate) {
        LinkedHashSet<InflectedForm> onFinite;
        Set<InflectedForm> unified = subjectForms;
        if (InflectedForm.isPossiblySingular.matches(this.main)) {
            unified = InflectedForm.addNumber(unified, InflectedForm.Number.Sin).toSet();
        }
        if ((onFinite = this.node2Features.get(predicate.finite)) != null) {
            unified = AgreementSet.unifyFeatures((Collection<InflectedForm>)unified, onFinite);
        }
        LinkedHashSet<InflectedForm> onPredicate = this.node2Features.get(predicate.head);
        if (predicate.finite != predicate.head && onPredicate != null) {
            unified = AgreementSet.unifyFeatures(unified, onPredicate);
        }
        return !unified.isEmpty();
    }

    private List<Node> possiblyMisparsedSiblings() {
        if (this.adjectives.isEmpty()) {
            return List.of();
        }
        if (!this.main.hasHeadRelation("nsubj.*|i?obj|obl|nmod|root")) {
            return List.of();
        }
        LinkedHashSet<InflectedForm> onMain = this.node2Features.get(this.main);
        List adjectivesBefore = ((StreamEx)StreamEx.of(this.adjectives).filter(a -> a.isBefore(this.main))).toList();
        for (int i = adjectivesBefore.size() - 1; i >= 0; --i) {
            Node adj = (Node)adjectivesBefore.get(i);
            if (!AgreementSet.unifyFeatures((Collection<InflectedForm>)this.node2Features.get(adj), onMain).isEmpty()) continue;
            if (i == 0 && mainClauseCopula_participle_ambiguity.matches(adj)) {
                return List.of(adj);
            }
            List<Node> nonMatching = adjectivesBefore.subList(0, i + 1);
            Node prep = AgreementSet.findPreposition(this.main);
            boolean couldBeMisparsed = prep != null ? this.couldBeMisparsedPrepositionArguments(nonMatching, prep) : this.couldBeBareMisparsedArguments(nonMatching);
            return couldBeMisparsed ? nonMatching : List.of();
        }
        List adjectivesAfter = ((StreamEx)((StreamEx)StreamEx.of(this.adjectives).filter(a -> a.isAfter(this.main))).takeWhile(a -> !separatedParticiplePhrase.matches((Node)a))).toList();
        for (int i = 0; i < adjectivesAfter.size(); ++i) {
            Node adj = (Node)adjectivesAfter.get(i);
            if (!AgreementSet.unifyFeatures((Collection<InflectedForm>)this.node2Features.get(adj), onMain).isEmpty()) continue;
            List<Node> nonMatching = adjectivesAfter.subList(i, adjectivesAfter.size());
            return this.couldBeBareMisparsedArguments(nonMatching) ? nonMatching : List.of();
        }
        return List.of();
    }

    private boolean couldBeMisparsedPrepositionArguments(List<Node> nonMatching, Node prep) {
        Set<Case> argumentCases = this.main.head() == null ? EnumSet.of(Case.Nom) : this.getArgumentCases(prep);
        Predicate<Node> hasRequiredCase = a -> this.node2Features.get(a).stream().anyMatch(f -> f.caze != null && f.caze.isCoveredBy(this.possibleCases.allowed()));
        Predicate<Node> canBeArgument = a -> this.node2Features.get(a).stream().anyMatch(f -> f.caze != null && f.caze.isCoveredBy(argumentCases));
        List ppCandidates = ((StreamEx)StreamEx.of(nonMatching).takeWhile(hasRequiredCase)).toList();
        return !ppCandidates.isEmpty() && ((StreamEx)((StreamEx)((StreamEx)StreamEx.of(this.adjectives).filter(a -> a.isBefore(this.main))).append((Object)this.main).append(this.adjectives).distinct()).skip((long)ppCandidates.size())).allMatch(canBeArgument);
    }

    private boolean couldBeBareMisparsedArguments(List<Node> nonMatching) {
        Node prev = nonMatching.get(0).prevSibling();
        if (prev != null && prev.hasHeadRelation("iobj")) {
            return true;
        }
        if (this.main.head() == null) {
            return false;
        }
        Set<Case> argumentCases = this.getArgumentCases(null);
        Set mainCases = ((StreamEx)StreamEx.of(this.filterCase((Collection<InflectedForm>)this.node2Features.get(this.main))).map(f1 -> f1.caze).filter(Objects::nonNull)).toSet();
        Predicate<Node> hasOnlyMainCase = a -> this.node2Features.get(a).stream().allMatch(f -> f.caze != null && (f.caze.isCoveredBy(mainCases) || !f.caze.isCoveredBy(argumentCases)));
        return nonMatching.stream().noneMatch(hasOnlyMainCase);
    }

    private Set<Case> getArgumentCases(@Nullable Node prep) {
        List filtered;
        Node head = Objects.requireNonNull(this.main.head());
        List valences = RussianValences.get(head);
        if (!valences.isEmpty() && prep != null && !(filtered = ((StreamEx)StreamEx.of(valences).filter(s -> s.any(a -> !RussianValences.prepositionCases(prep, a).isEmpty()))).toList()).isEmpty()) {
            valences = filtered;
        }
        HashSet<Case> argumentCases = new HashSet<Case>(!valences.isEmpty() ? Case.getArgumentCases(valences) : Case.maxArgumentCases(head));
        if (head.hasDependent("[nc]subj.*") && !this.main.hasHeadRelation("nsubj.*")) {
            argumentCases.remove((Object)Case.Nom);
        }
        return argumentCases;
    }

    private static Set<InflectedForm> augmentMainFeatures(Node node, Set<InflectedForm> forms) {
        InflectedForm.Gender gender = InflectedForm.additionalGender(node);
        if (gender != null) {
            forms.addAll(StreamEx.of(forms).map(f -> f.withGender(gender)).toSet());
        }
        if (InflectedForm.isPossiblyPlural.matches(node)) {
            return InflectedForm.addNumber(forms, InflectedForm.Number.PL).toSet();
        }
        return forms;
    }

    private Set<InflectedForm> filterCase(Collection<InflectedForm> forms) {
        return ((StreamEx)StreamEx.of(forms).filter(f -> f.matchesCase(this.possibleCases.allowed()))).toSet();
    }

    private static Set<InflectedForm> unifyFeatures(Collection<InflectedForm> forms1, Collection<InflectedForm> forms2) {
        return StreamEx.of(forms1).flatMap(f1 -> StreamEx.of((Collection)forms2).map(f2 -> f1.unify((InflectedForm)f2)).filter(Objects::nonNull)).toSet();
    }

    private FeatureRestriction<Case> calcPossibleCases(Node node) {
        Set<Case> result;
        Node prep;
        FeatureRestriction<Case> fromStructure;
        if (severalPrepositions.matches(node)) {
            return allCases;
        }
        NodeMatch match = instrPredicate.match(node);
        if (match != null) {
            return FeatureRestriction.restricted((Node)match.getMarkedNode("CopLike"), (Enum[])new Case[]{Case.T});
        }
        Node head = node.head();
        if (isSubject.matches(node) && head != null) {
            if (this.node2Features.containsKey(head)) {
                return FeatureRestriction.restricted((Node)head, (Enum[])new Case[]{Case.Nom});
            }
            Node finite = AgreementSet.findFiniteCandidate(head);
            if (this.node2Features.containsKey(finite)) {
                return FeatureRestriction.restricted((Node)finite, (Enum[])new Case[]{Case.Nom});
            }
        }
        if ((fromStructure = AgreementSet.calcStructureOrPrepositionCases(prep = AgreementSet.findPreposition(node), node)) != null) {
            return fromStructure;
        }
        if (postfixNoPrepNmod.matches(node) && Case.R.isPresentOn(node)) {
            return FeatureRestriction.restricted((Node)Objects.requireNonNull(node.head()), (Enum[])new Case[]{Case.R});
        }
        if (clauseNom.matches(node)) {
            return FeatureRestriction.restricted((String)"\u041a\u043e\u043d\u0442\u0435\u043a\u0441\u0442", (Enum[])new Case[]{Case.Nom});
        }
        if (this.relatives.contains(node)) {
            result = (Set)((StreamEx)StreamEx.of((Collection)this.node2Features.get(node)).map(f -> f.caze).filter(Objects::nonNull)).toCollection(LinkedHashSet::new);
        } else {
            Set existing = ((EntryStream)EntryStream.of(this.node2Features).filter(e -> !this.relatives.contains(e.getKey()))).flatMapKeyValue((__, forms) -> forms.stream().map(f -> f.caze)).toSet();
            result = EnumSet.allOf(Case.class);
            if (!existing.contains(null)) {
                result.retainAll(existing);
            }
        }
        if (result.isEmpty()) {
            result = EnumSet.allOf(Case.class);
        }
        if (prep == null) {
            if (!hasPrepAround.matches(node)) {
                result.remove((Object)Case.P);
            }
            if (node.hasHeadRelation("nmod") && !SemanticRules.durable.matches(node)) {
                result.remove((Object)Case.V);
            } else if (isObject.matches(node) && (Case.R.isPresentOn(node) || Case.V.isPresentOn(node))) {
                result.retainAll(List.of(Case.R, Case.V));
            }
        }
        return result.isEmpty() ? allCases : FeatureRestriction.restricted((String)"\u041a\u043e\u043d\u0442\u0435\u043a\u0441\u0442", (Enum[])((Case[])result.toArray(Case[]::new)));
    }

    @Nullable
    static FeatureRestriction<Case> calcStructureOrPrepositionCases(@Nullable Node prep, Node node) {
        Set result;
        FeatureRestriction<Case> fromStructure;
        Node head = node.head();
        if (mayUseStructureCases.matches(node) && (fromStructure = AgreementSet.getKnownStructureCases(node, head, prep)) != null) {
            return fromStructure;
        }
        if (prep != null && (result = Case.getPrepositionCases(prep)) != null) {
            if (prep.nextNode() != node) {
                result = (Set)((StreamEx)StreamEx.of(result).filter(c -> c != Case.Nom)).toCollection(LinkedHashSet::new);
            }
            String prepText = Case.izZa.matches(prep) ? "\u0438\u0437-" + prep.neighbor(2).presentableText() : prep.presentableText();
            return new FeatureRestriction<Case>(prep.tree().treeSupport().quote(prepText), result);
        }
        return null;
    }

    @Nullable
    private static FeatureRestriction<Case> getKnownStructureCases(Node node, @Nullable Node head, @Nullable Node prep) {
        StreamEx adjuncts;
        StreamEx args;
        LinkedHashSet fromStructure;
        List<Object> valences;
        List<Object> list = valences = head == null ? List.of() : RussianValences.get(head);
        if (!valences.isEmpty() && !(fromStructure = (LinkedHashSet)((StreamEx)(args = (StreamEx)((StreamEx)StreamEx.of(valences).flatCollection(s -> s.arguments).distinct()).filter(a -> a.findOn(head) == null && a.matchesLexically(node) || a.matchesFully(node))).append((Stream)(adjuncts = (StreamEx)StreamEx.of(RussianValences.adjuncts).flatMap(a -> a.destructure()).filter(a -> a.matchesLexically(node))))).flatCollection(a -> RussianValences.prepositionCases(prep, a)).toCollection(LinkedHashSet::new)).isEmpty()) {
            return FeatureRestriction.restricted((Node)(prep != null ? prep : head), (Enum[])((Case[])fromStructure.toArray(Case[]::new)));
        }
        return null;
    }

    @Nullable
    static Node findPreposition(Node node) {
        Node own = RussianTreePatterns.findOwnPreposition(node);
        if (own != null) {
            return own;
        }
        Node head = node.head();
        return head != null && node.hasHeadRelation("conj") && !ignoreHeadPrep.matches(node) ? RussianTreePatterns.findOwnPreposition(head) : null;
    }

    private Map<Node, NodeCorrector> imposeFeatures(@NotNull InflectedForm form) {
        LinkedHashMap<Node, NodeCorrector> result = new LinkedHashMap<Node, NodeCorrector>();
        for (Map.Entry<Node, LinkedHashSet<InflectedForm>> entry : this.node2Features.entrySet()) {
            Node target = entry.getKey();
            InflectedForm effective = this.relatives.contains(target) ? form.removeCasePerson() : form;
            if (effective == null || entry.getValue().stream().anyMatch(f -> f.unify(effective) != null)) continue;
            Set<Case> cases = this.relatives.contains(target) ? this.calcPossibleCases(target).allowed() : EnumSet.of(form.caze);
            NodeCorrector corrector = effective.inflect(target, this.main, cases);
            if (corrector == null) {
                return Collections.emptyMap();
            }
            result.put(target, corrector);
        }
        return result;
    }

    private static boolean hasSubjectArgumentAmbiguity(Node subject, Node predicate) {
        Node obj;
        if (Case.hasTransitiveVerbAround.matches(predicate) && ((obj = predicate.findSingleDependent("obj")) == null || AgreementSet.mayHavePos(obj, ".*:Nom.*")) && AgreementSet.mayHavePos(subject, ".*:[VR]($|:.*)")) {
            return true;
        }
        Set<Case> argStructure = Case.getArgumentCases(predicate);
        return argStructure != null && argStructure.stream().anyMatch(c -> c != Case.Nom && c.isPresentOn(subject));
    }

    private static boolean mayHavePos(Node node, String regexp) {
        Tree.Token token = node.tagIndependently();
        return token.hasPos(regexp) || !token.hasPos(".*");
    }

    public String toString() {
        return "AgreementSet{main=" + String.valueOf(this.main) + ", possibleCases=" + String.valueOf(this.possibleCases) + "}";
    }

    private record ComplexPredicate(@Nullable Node head, @Nullable Node finite) {
        private ComplexPredicate(@Nullable Node head, @Nullable Node finite) {
            assert (head != null || finite != null);
        }

        @Nullable
        static ComplexPredicate from(@NotNull Node predicate, @Nullable Node subj) {
            return ComplexPredicate.from(predicate, AgreementSet.findFiniteCandidate(predicate), subj);
        }

        @Nullable
        static ComplexPredicate from(@Nullable Node predicate, @NotNull Node finite, @Nullable Node subj) {
            if (AgreementSet.isImpersonalClause(subj, finite)) {
                return null;
            }
            if (complexPredicateAllowedToDisagree.matches(predicate)) {
                return null;
            }
            if (!RussianTreePatterns.finiteVerb.matches(finite)) {
                finite = null;
            }
            if (predicateAllowedToDisagree.matches(predicate)) {
                predicate = null;
            }
            if (predicate != null || finite != null) {
                return new ComplexPredicate(predicate, finite);
            }
            return null;
        }

        List<Node> nodes() {
            return ((StreamEx)StreamEx.of((Object[])new Node[]{this.head, this.finite}).filter(Objects::nonNull)).toList();
        }

        @Override
        public String toString() {
            return "Predicate{predicate=" + String.valueOf(this.head) + ", finite=" + String.valueOf(this.finite) + "}";
        }
    }
}

