/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.synthetic;

import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifier;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.impl.auxiliary.modifiers.GrModifierListImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.auxiliary.modifiers.GrModifierListUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightAnnotation;

public class GrLightModifierList
extends LightElement
implements GrModifierList {
    private int myModifiers;
    private final List<GrAnnotation> myAnnotations;
    private final PsiElement myParent;

    public GrLightModifierList(@NotNull PsiElement parent) {
        if (parent == null) {
            GrLightModifierList.$$$reportNull$$$0(0);
        }
        super(parent.getManager(), parent.getLanguage());
        this.myAnnotations = new ArrayList<GrAnnotation>();
        this.myParent = parent;
    }

    public PsiElement getParent() {
        return this.myParent;
    }

    public PsiFile getContainingFile() {
        return this.getParent().getContainingFile();
    }

    public void addModifier(String modifier) {
        int code = GrModifierListImpl.NAME_TO_MODIFIER_FLAG_MAP.getInt((Object)modifier);
        assert (code != 0);
        this.myModifiers |= code;
    }

    public void addModifier(int modifier) {
        this.myModifiers |= modifier;
    }

    public void removeModifier(int modifier) {
        this.myModifiers &= ~modifier;
    }

    public void setModifiers(int modifiers) {
        this.myModifiers = modifiers;
    }

    public void setModifiers(String ... modifiers) {
        this.myModifiers = 0;
        for (String modifier : modifiers) {
            this.addModifier(modifier);
        }
    }

    @Override
    public int getModifierFlags() {
        return this.myModifiers;
    }

    @Override
    public boolean hasModifierProperty(@NotNull String name) {
        if (name == null) {
            GrLightModifierList.$$$reportNull$$$0(1);
        }
        return GrModifierListUtil.hasModifierProperty(this, name);
    }

    @Override
    public boolean hasExplicitModifier(@NotNull String name) {
        if (name == null) {
            GrLightModifierList.$$$reportNull$$$0(2);
        }
        return GrModifierListUtil.hasExplicitModifier(this, name);
    }

    @Override
    public void setModifierProperty(@NotNull String name, boolean value) throws IncorrectOperationException {
        if (name == null) {
            GrLightModifierList.$$$reportNull$$$0(3);
        }
        throw new IncorrectOperationException();
    }

    @Override
    public GrAnnotation @NotNull [] getRawAnnotations() {
        GrAnnotation[] grAnnotationArray = this.getAnnotations();
        if (grAnnotationArray == null) {
            GrLightModifierList.$$$reportNull$$$0(4);
        }
        return grAnnotationArray;
    }

    public void checkSetModifierProperty(@NotNull String name, boolean value) throws IncorrectOperationException {
        if (name == null) {
            GrLightModifierList.$$$reportNull$$$0(5);
        }
        throw new IncorrectOperationException();
    }

    @Override
    public GrAnnotation @NotNull [] getAnnotations() {
        GrAnnotation[] grAnnotationArray = this.myAnnotations.toArray(GrAnnotation.EMPTY_ARRAY);
        if (grAnnotationArray == null) {
            GrLightModifierList.$$$reportNull$$$0(6);
        }
        return grAnnotationArray;
    }

    public PsiAnnotation @NotNull [] getApplicableAnnotations() {
        PsiAnnotation[] psiAnnotationArray = this.getAnnotations();
        if (psiAnnotationArray == null) {
            GrLightModifierList.$$$reportNull$$$0(7);
        }
        return psiAnnotationArray;
    }

    public PsiAnnotation findAnnotation(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            GrLightModifierList.$$$reportNull$$$0(8);
        }
        for (GrAnnotation annotation : this.myAnnotations) {
            if (!annotation.hasQualifiedName(qualifiedName)) continue;
            return annotation;
        }
        return null;
    }

    @NotNull
    public GrLightAnnotation addAnnotation(@NotNull @NonNls String qualifiedName) {
        if (qualifiedName == null) {
            GrLightModifierList.$$$reportNull$$$0(9);
        }
        GrLightAnnotation annotation = new GrLightAnnotation(this.getManager(), this.getLanguage(), qualifiedName, this);
        this.myAnnotations.add(annotation);
        GrLightAnnotation grLightAnnotation = annotation;
        if (grLightAnnotation == null) {
            GrLightModifierList.$$$reportNull$$$0(10);
        }
        return grLightAnnotation;
    }

    public void addAnnotation(@NotNull GrAnnotation annotation) {
        if (annotation == null) {
            GrLightModifierList.$$$reportNull$$$0(11);
        }
        this.myAnnotations.add(annotation);
    }

    public void copyAnnotations(@Nullable GrModifierList other) {
        if (other == null) {
            return;
        }
        ContainerUtil.addAll(this.myAnnotations, (Object[])other.getAnnotations());
    }

    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            GrLightModifierList.$$$reportNull$$$0(12);
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitModifierList((PsiModifierList)this);
        } else {
            visitor2.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        return "GrModifierList";
    }

    public String getText() {
        StringBuilder buffer = new StringBuilder();
        for (GrAnnotation annotation : this.myAnnotations) {
            buffer.append(annotation.getText());
            buffer.append(' ');
        }
        for (String modifier : GrModifier.GROOVY_MODIFIERS) {
            if (!this.hasExplicitModifier(modifier)) continue;
            buffer.append(modifier);
            buffer.append(' ');
        }
        if (!buffer.isEmpty()) {
            buffer.delete(buffer.length() - 1, buffer.length());
        }
        return buffer.toString();
    }

    @Override
    public PsiElement @NotNull [] getModifiers() {
        if (PsiElement.EMPTY_ARRAY == null) {
            GrLightModifierList.$$$reportNull$$$0(13);
        }
        return PsiElement.EMPTY_ARRAY;
    }

    @Override
    @Nullable
    public PsiElement getModifier(@GrModifier.GrModifierConstant @NotNull @NonNls String name) {
        if (name == null) {
            GrLightModifierList.$$$reportNull$$$0(14);
        }
        return null;
    }

    @Override
    public boolean hasExplicitVisibilityModifiers() {
        return GrModifierListUtil.hasExplicitVisibilityModifiers(this);
    }

    @Override
    public void accept(@NotNull GroovyElementVisitor visitor2) {
        if (visitor2 == null) {
            GrLightModifierList.$$$reportNull$$$0(15);
        }
        visitor2.visitModifierList(this);
    }

    @Override
    public void acceptChildren(@NotNull GroovyElementVisitor visitor2) {
        if (visitor2 == null) {
            GrLightModifierList.$$$reportNull$$$0(16);
        }
    }

    public void copyModifiers(@NotNull PsiModifierListOwner modifierOwner) {
        if (modifierOwner == null) {
            GrLightModifierList.$$$reportNull$$$0(17);
        }
        int mod = 0;
        PsiModifierList modifierList = modifierOwner.getModifierList();
        if (modifierList instanceof GrModifierList) {
            mod = ((GrModifierList)modifierList).getModifierFlags();
        } else if (modifierList != null) {
            for (String modifier : PsiModifier.MODIFIERS) {
                if (!modifierList.hasExplicitModifier(modifier)) continue;
                mod |= GrModifierListImpl.NAME_TO_MODIFIER_FLAG_MAP.getInt((Object)modifier);
            }
        }
        this.setModifiers(mod);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GrLightModifierList list = (GrLightModifierList)o;
        return this.myModifiers == list.myModifiers && Objects.equals(this.myAnnotations, list.myAnnotations);
    }

    public int hashCode() {
        return Objects.hash(this.myModifiers, this.myAnnotations);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6, 7, 10, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrLightModifierList";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 12: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifierOwner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrLightModifierList";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRawAnnotations";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotations";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicableAnnotations";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "addAnnotation";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "hasModifierProperty";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "hasExplicitModifier";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setModifierProperty";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 10: 
            case 13: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkSetModifierProperty";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findAnnotation";
                break;
            }
            case 9: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addAnnotation";
                break;
            }
            case 12: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getModifier";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "acceptChildren";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "copyModifiers";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6, 7, 10, 13 -> new IllegalStateException(string);
        };
    }
}

