/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.compiler.plugins.kotlin;

import androidx.compose.compiler.plugins.kotlin.ComposePluginKt;
import androidx.compose.compiler.plugins.kotlin.FeatureFlag;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CompilerConfiguration;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\tH\u0002J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\tH\u0002J\u0016\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\tJ\u0016\u0010\u0015\u001a\u00020\u000e2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002J\u000e\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0019J\u0010\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\tH\u0002R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Landroidx/compose/compiler/plugins/kotlin/FeatureFlags;", "", "featureConfiguration", "", "", "<init>", "(Ljava/util/List;)V", "setForCompatibility", "", "Landroidx/compose/compiler/plugins/kotlin/FeatureFlag;", "duplicate", "enabledFeatures", "disabledFeatures", "enableFeature", "", "feature", "disableFeature", "setFeature", "value", "", "isEnabled", "processConfigurationList", "featuresNames", "validateFeatureFlags", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "currentState", "kotlin-compose-compiler-plugin"})
public final class FeatureFlags {
    @NotNull
    private final Set<FeatureFlag> setForCompatibility;
    @NotNull
    private final Set<FeatureFlag> duplicate;
    @NotNull
    private final Set<FeatureFlag> enabledFeatures;
    @NotNull
    private final Set<FeatureFlag> disabledFeatures;

    public FeatureFlags(@NotNull List<String> featureConfiguration) {
        Intrinsics.checkNotNullParameter(featureConfiguration, (String)"featureConfiguration");
        this.setForCompatibility = new LinkedHashSet();
        this.duplicate = new LinkedHashSet();
        this.enabledFeatures = new LinkedHashSet();
        this.disabledFeatures = new LinkedHashSet();
        this.processConfigurationList(featureConfiguration);
    }

    public /* synthetic */ FeatureFlags(List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(list);
    }

    private final void enableFeature(FeatureFlag feature) {
        if (this.disabledFeatures.contains((Object)feature)) {
            this.duplicate.add(feature);
            this.disabledFeatures.remove((Object)feature);
        }
        this.enabledFeatures.add(feature);
    }

    private final void disableFeature(FeatureFlag feature) {
        if (this.enabledFeatures.contains((Object)feature)) {
            this.duplicate.add(feature);
            this.enabledFeatures.remove((Object)feature);
        }
        this.disabledFeatures.add(feature);
    }

    public final void setFeature(@NotNull FeatureFlag feature, boolean value) {
        Intrinsics.checkNotNullParameter((Object)((Object)feature), (String)"feature");
        if (feature.getDefault() != value) {
            this.setForCompatibility.add(feature);
            if (value) {
                this.enableFeature(feature);
            } else {
                this.disableFeature(feature);
            }
        }
    }

    public final boolean isEnabled(@NotNull FeatureFlag feature) {
        Intrinsics.checkNotNullParameter((Object)((Object)feature), (String)"feature");
        return this.enabledFeatures.contains((Object)feature) || feature.getDefault() && !this.disabledFeatures.contains((Object)feature);
    }

    private final void processConfigurationList(List<String> featuresNames) {
        for (String featureName : featuresNames) {
            Pair<FeatureFlag, Boolean> pair = FeatureFlag.Companion.fromString(featureName);
            FeatureFlag feature = (FeatureFlag)((Object)pair.component1());
            boolean enabled = (Boolean)pair.component2();
            if (feature == null) continue;
            if (enabled) {
                this.enableFeature(feature);
                continue;
            }
            this.disableFeature(feature);
        }
    }

    public final void validateFeatureFlags(@NotNull CompilerConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        MessageCollector msgCollector = (MessageCollector)configuration.get(CommonConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        if (msgCollector != null) {
            Set reported = new LinkedHashSet();
            Set configured = SetsKt.plus(this.enabledFeatures, (Iterable)this.disabledFeatures);
            Set oldAndNewSet = CollectionsKt.intersect((Iterable)this.setForCompatibility, (Iterable)configured);
            for (FeatureFlag feature : oldAndNewSet) {
                FeatureFlags.validateFeatureFlags$report(reported, msgCollector, feature, "Feature " + ComposePluginKt.featureFlagName() + '=' + feature.getFeatureName() + " is using featureFlags and is set using the deprecated option. It is recommended to only use featureFlag. " + this.currentState(feature));
            }
            for (FeatureFlag feature : this.duplicate) {
                if (reported.contains((Object)feature)) continue;
                FeatureFlags.validateFeatureFlags$report(reported, msgCollector, feature, "Feature " + ComposePluginKt.featureFlagName() + '=' + feature.getFeatureName() + " was both enabled and disabled. " + this.currentState(feature));
            }
            for (FeatureFlag feature : this.disabledFeatures) {
                if (feature.getDefault()) continue;
                FeatureFlags.validateFeatureFlags$report(reported, msgCollector, feature, "The feature " + ComposePluginKt.featureFlagName() + '=' + feature.getFeatureName() + " is disabled by default and specifying this option explicitly is not necessary.");
            }
            for (FeatureFlag feature : this.enabledFeatures) {
                if (!feature.getDefault()) continue;
                FeatureFlags.validateFeatureFlags$report(reported, msgCollector, feature, "The feature " + ComposePluginKt.featureFlagName() + '=' + feature.getFeatureName() + " is enabled by default and specifying this option explicitly is not necessary.");
            }
        }
    }

    private final String currentState(FeatureFlag feature) {
        return "With the given options set, the feature is " + (this.isEnabled(feature) ? "enabled" : "disabled");
    }

    private static final void validateFeatureFlags$report(Set<FeatureFlag> reported, MessageCollector msgCollector, FeatureFlag feature, String message) {
        if (!reported.contains((Object)feature)) {
            reported.add(feature);
            MessageCollector.report$default((MessageCollector)msgCollector, (CompilerMessageSeverity)CompilerMessageSeverity.WARNING, (String)message, null, (int)4, null);
        }
    }

    public FeatureFlags() {
        this(null, 1, null);
    }
}

