/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.importSettings.chooser.ui;

import com.intellij.ide.startup.importSettings.chooser.ui.WizardPageTrackerKt;
import com.intellij.platform.ide.bootstrap.IdeStartupWizardCollector;
import com.intellij.platform.ide.bootstrap.StartupWizardStage;
import com.intellij.util.concurrency.ThreadingAssertions;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\bJ\u0006\u0010\f\u001a\u00020\nR\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/ide/startup/importSettings/chooser/ui/WizardPageTracker;", "", "<init>", "()V", "lastEnterTimeNs", "", "Ljava/lang/Long;", "currentStage", "Lcom/intellij/platform/ide/bootstrap/StartupWizardStage;", "onEnter", "", "stage", "onLeave", "intellij.ide.startup.importSettings"})
public final class WizardPageTracker {
    @Nullable
    private Long lastEnterTimeNs;
    @Nullable
    private StartupWizardStage currentStage;

    public final void onEnter(@Nullable StartupWizardStage stage) {
        ThreadingAssertions.assertEventDispatchThread();
        if (this.currentStage != null) {
            WizardPageTrackerKt.access$getLogger$p().error("Logic error: entered page " + stage + " while still on page " + this.currentStage + ".");
        }
        this.lastEnterTimeNs = System.nanoTime();
        this.currentStage = stage;
    }

    public final void onLeave() {
        StartupWizardStage startupWizardStage = this.currentStage;
        if (startupWizardStage == null) {
            return;
        }
        StartupWizardStage stage = startupWizardStage;
        ThreadingAssertions.assertEventDispatchThread();
        Long enterTimeNs = this.lastEnterTimeNs;
        long leaveTimeNs = System.nanoTime();
        if (enterTimeNs == null) {
            return;
        }
        Duration duration = Duration.ofNanos(leaveTimeNs - enterTimeNs);
        Intrinsics.checkNotNull((Object)duration);
        IdeStartupWizardCollector.INSTANCE.logStartupStageTime(stage, duration);
        this.lastEnterTimeNs = null;
        this.currentStage = null;
    }
}

