/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.comment;

import com.intellij.lang.Language;
import com.intellij.markdown.utils.lang.HtmlSyntaxHighlighter;
import com.intellij.openapi.diff.DiffColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorColorsUtil;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.ui.ColorUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB!\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001f\u0010\u0015\u001a\u00020\u00112\b\u0010\u0016\u001a\u0004\u0018\u00010\u00052\u000b\u0010\u0017\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0018H\u0016J/\u0010\u0019\u001a\u00020\u00112\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0016\u001a\u00020\n2\u000b\u0010\u0017\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u001b\u0010\u0010\u001a\u00020\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u000f\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/comment/GHSuggestionHtmlSyntaxHighlighter;", "Lcom/intellij/markdown/utils/lang/HtmlSyntaxHighlighter;", "project", "Lcom/intellij/openapi/project/Project;", "filePath", "", "reviewContent", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Ljava/lang/String;)V", "fileLanguage", "Lcom/intellij/lang/Language;", "Lorg/jetbrains/annotations/NotNull;", "getFileLanguage", "()Lcom/intellij/lang/Language;", "fileLanguage$delegate", "Lkotlin/Lazy;", "coloredReviewChunk", "Lcom/intellij/openapi/util/text/HtmlChunk;", "getColoredReviewChunk", "()Lcom/intellij/openapi/util/text/HtmlChunk;", "coloredReviewChunk$delegate", "color", "language", "rawContent", "Lcom/intellij/openapi/util/NlsSafe;", "createColoredChunk", "textAttributesKey", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "Companion", "intellij.vcs.github"})
public final class GHSuggestionHtmlSyntaxHighlighter
implements HtmlSyntaxHighlighter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Project project;
    @NotNull
    private final String filePath;
    @NotNull
    private final String reviewContent;
    @NotNull
    private final Lazy fileLanguage$delegate;
    @NotNull
    private final Lazy coloredReviewChunk$delegate;

    public GHSuggestionHtmlSyntaxHighlighter(@Nullable Project project, @NotNull String filePath, @NotNull String reviewContent) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)reviewContent, (String)"reviewContent");
        this.project = project;
        this.filePath = filePath;
        this.reviewContent = reviewContent;
        this.fileLanguage$delegate = LazyKt.lazy(() -> GHSuggestionHtmlSyntaxHighlighter.fileLanguage_delegate$lambda$0(this));
        this.coloredReviewChunk$delegate = LazyKt.lazy(() -> GHSuggestionHtmlSyntaxHighlighter.coloredReviewChunk_delegate$lambda$0(this));
    }

    private final Language getFileLanguage() {
        Lazy lazy = this.fileLanguage$delegate;
        return (Language)lazy.getValue();
    }

    private final HtmlChunk getColoredReviewChunk() {
        Lazy lazy = this.coloredReviewChunk$delegate;
        return (HtmlChunk)lazy.getValue();
    }

    @NotNull
    public HtmlChunk color(@Nullable String language, @NotNull String rawContent) {
        Intrinsics.checkNotNullParameter((Object)rawContent, (String)"rawContent");
        HtmlBuilder htmlBuilder = new HtmlBuilder().append(this.getColoredReviewChunk());
        Language language2 = this.getFileLanguage();
        String string = Companion.trimStartWithMinIndent(rawContent);
        TextAttributesKey textAttributesKey = DiffColors.DIFF_INSERTED;
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"DIFF_INSERTED");
        HtmlChunk htmlChunk = htmlBuilder.append(this.createColoredChunk(this.project, language2, string, textAttributesKey)).toFragment();
        Intrinsics.checkNotNullExpressionValue((Object)htmlChunk, (String)"toFragment(...)");
        return htmlChunk;
    }

    private final HtmlChunk createColoredChunk(Project project, Language language, String rawContent, TextAttributesKey textAttributesKey) {
        EditorColorsScheme editorColorsScheme = EditorColorsUtil.getGlobalOrDefaultColorScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getGlobalOrDefaultColorScheme(...)");
        EditorColorsScheme colorsScheme = editorColorsScheme;
        Color backgroundColor = colorsScheme.getAttributes(textAttributesKey).getBackgroundColor();
        String styles = StringsKt.trimIndent((String)("\n      background-color: " + ColorUtil.toHtmlColor((Color)backgroundColor) + "; \n      margin: 0;\n      padding: " + GHSuggestionHtmlSyntaxHighlighter.Companion.getPADDING() + " " + GHSuggestionHtmlSyntaxHighlighter.Companion.getPADDING() + ";\n    "));
        HtmlChunk.Element element = HtmlChunk.tag((String)"pre").style(styles).child(HtmlSyntaxHighlighter.Companion.colorHtmlChunk(project, language, rawContent));
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"child(...)");
        return (HtmlChunk)element;
    }

    private static final Language fileLanguage_delegate$lambda$0(GHSuggestionHtmlSyntaxHighlighter this$0) {
        String string = PathUtil.getFileName((String)this$0.filePath);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFileName(...)");
        String name = string;
        FileType fileType = FileTypeRegistry.getInstance().getFileTypeByFileName(name);
        LanguageFileType languageFileType = fileType instanceof LanguageFileType ? (LanguageFileType)fileType : null;
        if (languageFileType == null) {
            languageFileType = (LanguageFileType)PlainTextFileType.INSTANCE;
        }
        LanguageFileType fileType2 = languageFileType;
        return fileType2.getLanguage();
    }

    private static final HtmlChunk coloredReviewChunk_delegate$lambda$0(GHSuggestionHtmlSyntaxHighlighter this$0) {
        Project project = this$0.project;
        Language language = this$0.getFileLanguage();
        String string = Companion.trimStartWithMinIndent(this$0.reviewContent);
        TextAttributesKey textAttributesKey = DiffColors.DIFF_DELETED;
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"DIFF_DELETED");
        return this$0.createColoredChunk(project, language, string, textAttributesKey);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\n2\u0006\u0010\u000b\u001a\u00020\tH\u0007R\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/comment/GHSuggestionHtmlSyntaxHighlighter$Companion;", "", "<init>", "()V", "PADDING", "", "getPADDING", "()I", "trimStartWithMinIndent", "", "Lcom/intellij/openapi/util/NlsSafe;", "text", "intellij.vcs.github"})
    public static final class Companion {
        private Companion() {
        }

        private final int getPADDING() {
            return JBUI.scale((int)2);
        }

        @VisibleForTesting
        @NotNull
        public final String trimStartWithMinIndent(@NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Object it = StringsKt.lines((CharSequence)text);
            boolean bl = false;
            Object object = Intrinsics.areEqual((Object)CollectionsKt.last((List)it), (Object)"") ? CollectionsKt.dropLast((List)it, (int)1) : it;
            Object lines = object;
            if (lines.isEmpty()) {
                return text;
            }
            int minIndent = Integer.MAX_VALUE;
            it = lines.iterator();
            while (it.hasNext()) {
                char symbol;
                String line = (String)it.next();
                int currentIndent = 0;
                int n = line.length();
                for (int i = 0; i < n && (symbol = line.charAt(i)) == ' '; ++i) {
                    ++currentIndent;
                }
                minIndent = Integer.min(minIndent, currentIndent);
            }
            String startIndent = StringsKt.repeat((CharSequence)" ", (int)minIndent);
            return CollectionsKt.joinToString$default((Iterable)((Iterable)lines), (CharSequence)"\n", null, null, (int)0, null, arg_0 -> Companion.trimStartWithMinIndent$lambda$1(startIndent, arg_0), (int)30, null);
        }

        private static final CharSequence trimStartWithMinIndent$lambda$1(String $startIndent, String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return StringsKt.removePrefix((String)it, (CharSequence)$startIndent);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

