/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.resolution.failure.describer;

import java.util.List;
import javax.inject.Inject;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributeDescriber;
import org.gradle.api.internal.attributes.AttributeDescriberRegistry;
import org.gradle.internal.component.model.AttributeDescriberSelector;
import org.gradle.internal.component.resolution.failure.ResolutionCandidateAssessor;
import org.gradle.internal.component.resolution.failure.describer.AbstractResolutionFailureDescriber;
import org.gradle.internal.component.resolution.failure.exception.VariantSelectionByNameException;
import org.gradle.internal.component.resolution.failure.type.ConfigurationNotCompatibleFailure;
import org.gradle.internal.exceptions.StyledException;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.internal.logging.text.TreeFormatter;

public abstract class ConfigurationNotCompatibleFailureDescriber
extends AbstractResolutionFailureDescriber<ConfigurationNotCompatibleFailure> {
    private static final String INCOMPATIBLE_VARIANTS_PREFIX = "Incompatible variant errors are explained in more detail at ";
    private static final String INCOMPATIBLE_VARIANTS_SECTION = "sub:variant-incompatible";
    private final AttributeDescriberRegistry attributeDescribers;

    @Inject
    public ConfigurationNotCompatibleFailureDescriber(AttributeDescriberRegistry attributeDescribers) {
        this.attributeDescribers = attributeDescribers;
    }

    public VariantSelectionByNameException describeFailure(ConfigurationNotCompatibleFailure failure) {
        AttributeDescriber describer = AttributeDescriberSelector.selectDescriber((AttributeContainerInternal)failure.getRequestedAttributes(), this.attributeDescribers.getDescribers());
        String message = this.buildFailureMsg(failure, describer);
        List<String> resolutions = this.buildResolutions(this.suggestSpecificDocumentation(INCOMPATIBLE_VARIANTS_PREFIX, INCOMPATIBLE_VARIANTS_SECTION), this.suggestReviewAlgorithm());
        return new VariantSelectionByNameException(message, failure, resolutions);
    }

    private String buildFailureMsg(ConfigurationNotCompatibleFailure failure, AttributeDescriber describer) {
        ResolutionCandidateAssessor.AssessedCandidate assessedCandidate = (ResolutionCandidateAssessor.AssessedCandidate)failure.getCandidates().get(0);
        TreeFormatter formatter = new TreeFormatter();
        String candidateName = assessedCandidate.getDisplayName();
        formatter.node("Configuration '" + candidateName + "' in " + StyledException.style((StyledTextOutput.Style)StyledTextOutput.Style.Info, (String)failure.getTargetComponent().getDisplayName()) + " does not match the consumer attributes");
        this.formatUnselectable(assessedCandidate, formatter, describer);
        return formatter.toString();
    }

    private void formatUnselectable(ResolutionCandidateAssessor.AssessedCandidate assessedCandidate, TreeFormatter formatter, AttributeDescriber describer) {
        formatter.node("Configuration '");
        formatter.append((CharSequence)assessedCandidate.getDisplayName());
        formatter.append((CharSequence)"'");
        this.formatAttributeMatchesForIncompatibility(assessedCandidate, formatter, describer);
    }
}

