/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.cxx.in to make changes.
 */

#include "itkImage.h"
#include "itkVectorImage.h"
#include "itkLabelMap.h"
#include "itkLabelObject.h"
#include "itkNumericTraits.h"
#include "itkNumericTraitsVariableLengthVectorPixel.h"
#include "itkVectorIndexSelectionCastImageFilter.h"
#include "itkComposeImageFilter.h"

#include "sitkFFTConvolutionImageFilter.h"
#include "itkFFTConvolutionImageFilter.h"

// Additional include files
#include "sitkBoundaryConditions.hxx"
// Done with additional include files

namespace itk::simple {

//-----------------------------------------------------------------------------

//
// Default constructor that initializes parameters
//
FFTConvolutionImageFilter::FFTConvolutionImageFilter ()
{
  this->m_MemberFactory =  std::make_unique<detail::MemberFunctionFactory<MemberFunctionType>>( this );

  this->m_MemberFactory->RegisterMemberFunctions< PixelIDTypeList, 2, 3 > ();



}

//
// Destructor
//
FFTConvolutionImageFilter::~FFTConvolutionImageFilter() = default;



//
// ToString
//
std::string FFTConvolutionImageFilter::ToString() const
{
  std::ostringstream out;
  out << "itk::simple::FFTConvolutionImageFilter\n";
  out << "  Normalize: ";
  this->ToStringHelper(out, this->m_Normalize);
  out << std::endl;
  out << "  BoundaryCondition: ";
  this->ToStringHelper(out, this->m_BoundaryCondition);
  out << std::endl;
  out << "  OutputRegionMode: ";
  this->ToStringHelper(out, this->m_OutputRegionMode);
  out << std::endl;

  out << ProcessObject::ToString();
  return out.str();
}

//
// Execute
//
Image FFTConvolutionImageFilter::Execute ( const Image & image, const Image & kernelImage )
{
  const PixelIDValueEnum type = image.GetPixelID();
  const unsigned int dimension = image.GetDimension();
  CheckImageMatchingDimension(  image, kernelImage, "kernelImage" );

  return this->m_MemberFactory->GetMemberFunction( type, dimension )( &image, &kernelImage );
}



//-----------------------------------------------------------------------------

sitkClangDiagnosticPush();
sitkClangWarningIgnore("-Wunused-local-typedef");

//
// ExecuteInternal
//
template <class TImageType>
Image FFTConvolutionImageFilter::ExecuteInternal ( const Image * inImage, const Image * inKernelImage )
{
  // Define the input and output image types
  using InputImageType = TImageType;


  using OutputImageType = InputImageType;



  using FilterType = itk::FFTConvolutionImageFilter< InputImageType, InputImageType, OutputImageType >;
  // Set up the ITK filter
  typename FilterType::Pointer filter = FilterType::New();


  assert( inImage != nullptr );
  typename FilterType::InputImageType::ConstPointer image1 = this->CastImageToITK<typename FilterType::InputImageType>( *inImage );
  filter->SetInput( image1 );
  assert( inKernelImage != nullptr );
  typename FilterType::KernelImageType::ConstPointer image2 = this->CastImageToITK<typename FilterType::KernelImageType>( *inKernelImage );
  filter->SetKernelImage( image2 );


  filter->SetNormalize ( this->m_Normalize );
  std::unique_ptr< ImageBoundaryCondition< InputImageType > > bc( CreateNewBoundaryConditionInstance< Self, FilterType >( m_BoundaryCondition ) ); filter->SetBoundaryCondition( bc.get() );

  filter->SetOutputRegionMode ( typename FilterType::OutputRegionModeEnum ( int( this->m_OutputRegionMode ) ) );




  this->PreUpdate( filter.GetPointer() );



  // Run the ITK filter and return the output as a SimpleITK image
  filter->Update();



  typename FilterType::OutputImageType::Pointer itkOutImage{ filter->GetOutput()};
  filter = nullptr;
  this->FixNonZeroIndex( itkOutImage.GetPointer() );
  return Image{ this->CastITKToImage( itkOutImage.GetPointer() ) };

}

sitkClangDiagnosticPop();

//-----------------------------------------------------------------------------


//
// Function to run the Execute method of this filter
//
Image FFTConvolution ( const Image & image, const Image & kernelImage, bool normalize, FFTConvolutionImageFilter::BoundaryConditionType boundaryCondition, FFTConvolutionImageFilter::OutputRegionModeType outputRegionMode )
{
  FFTConvolutionImageFilter filter;
  filter.SetNormalize( normalize );  filter.SetBoundaryCondition( boundaryCondition );  filter.SetOutputRegionMode( outputRegionMode );
  return filter.Execute ( image, kernelImage );
}


}
