/* parser auto-generated by pidl */

#include "replace.h"
#include "bin/default/librpc/gen_ndr/ndr_backupkey.h"

#include "librpc/gen_ndr/ndr_misc.h"
#include "librpc/gen_ndr/ndr_security.h"
_PUBLIC_ enum ndr_err_code ndr_push_bkrp_exported_RSA_key_pair(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct bkrp_exported_RSA_key_pair *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0x00000002));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0x00000494));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->certificate_len));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0x00000207));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0x0000A400));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0x32415352));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0x00000800));
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			{
				struct ndr_push *_ndr_public_exponent;
				NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_public_exponent, 0, 4));
				NDR_CHECK(ndr_push_DATA_BLOB(_ndr_public_exponent, NDR_SCALARS, r->public_exponent));
				NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_public_exponent, 0, 4));
			}
			ndr->flags = _flags_save_DATA_BLOB;
		}
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			{
				struct ndr_push *_ndr_modulus;
				NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_modulus, 0, 256));
				NDR_CHECK(ndr_push_DATA_BLOB(_ndr_modulus, NDR_SCALARS, r->modulus));
				NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_modulus, 0, 256));
			}
			ndr->flags = _flags_save_DATA_BLOB;
		}
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			{
				struct ndr_push *_ndr_prime1;
				NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_prime1, 0, 128));
				NDR_CHECK(ndr_push_DATA_BLOB(_ndr_prime1, NDR_SCALARS, r->prime1));
				NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_prime1, 0, 128));
			}
			ndr->flags = _flags_save_DATA_BLOB;
		}
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			{
				struct ndr_push *_ndr_prime2;
				NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_prime2, 0, 128));
				NDR_CHECK(ndr_push_DATA_BLOB(_ndr_prime2, NDR_SCALARS, r->prime2));
				NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_prime2, 0, 128));
			}
			ndr->flags = _flags_save_DATA_BLOB;
		}
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			{
				struct ndr_push *_ndr_exponent1;
				NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_exponent1, 0, 128));
				NDR_CHECK(ndr_push_DATA_BLOB(_ndr_exponent1, NDR_SCALARS, r->exponent1));
				NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_exponent1, 0, 128));
			}
			ndr->flags = _flags_save_DATA_BLOB;
		}
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			{
				struct ndr_push *_ndr_exponent2;
				NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_exponent2, 0, 128));
				NDR_CHECK(ndr_push_DATA_BLOB(_ndr_exponent2, NDR_SCALARS, r->exponent2));
				NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_exponent2, 0, 128));
			}
			ndr->flags = _flags_save_DATA_BLOB;
		}
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			{
				struct ndr_push *_ndr_coefficient;
				NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_coefficient, 0, 128));
				NDR_CHECK(ndr_push_DATA_BLOB(_ndr_coefficient, NDR_SCALARS, r->coefficient));
				NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_coefficient, 0, 128));
			}
			ndr->flags = _flags_save_DATA_BLOB;
		}
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			{
				struct ndr_push *_ndr_private_exponent;
				NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_private_exponent, 0, 256));
				NDR_CHECK(ndr_push_DATA_BLOB(_ndr_private_exponent, NDR_SCALARS, r->private_exponent));
				NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_private_exponent, 0, 256));
			}
			ndr->flags = _flags_save_DATA_BLOB;
		}
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			{
				struct ndr_push *_ndr_cert;
				NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_cert, 0, r->certificate_len));
				NDR_CHECK(ndr_push_DATA_BLOB(_ndr_cert, NDR_SCALARS, r->cert));
				NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_cert, 0, r->certificate_len));
			}
			ndr->flags = _flags_save_DATA_BLOB;
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_bkrp_exported_RSA_key_pair(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct bkrp_exported_RSA_key_pair *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->header1));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->header2));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->certificate_len));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->magic1));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->magic2));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->magic3));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->magic4));
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			{
				struct ndr_pull *_ndr_public_exponent;
				ssize_t sub_size = 4;
				NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_public_exponent, 0, sub_size));
				NDR_CHECK(ndr_pull_DATA_BLOB(_ndr_public_exponent, NDR_SCALARS, &r->public_exponent));
				NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_public_exponent, 0, sub_size));
			}
			ndr->flags = _flags_save_DATA_BLOB;
		}
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			{
				struct ndr_pull *_ndr_modulus;
				ssize_t sub_size = 256;
				NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_modulus, 0, sub_size));
				NDR_CHECK(ndr_pull_DATA_BLOB(_ndr_modulus, NDR_SCALARS, &r->modulus));
				NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_modulus, 0, sub_size));
			}
			ndr->flags = _flags_save_DATA_BLOB;
		}
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			{
				struct ndr_pull *_ndr_prime1;
				ssize_t sub_size = 128;
				NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_prime1, 0, sub_size));
				NDR_CHECK(ndr_pull_DATA_BLOB(_ndr_prime1, NDR_SCALARS, &r->prime1));
				NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_prime1, 0, sub_size));
			}
			ndr->flags = _flags_save_DATA_BLOB;
		}
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			{
				struct ndr_pull *_ndr_prime2;
				ssize_t sub_size = 128;
				NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_prime2, 0, sub_size));
				NDR_CHECK(ndr_pull_DATA_BLOB(_ndr_prime2, NDR_SCALARS, &r->prime2));
				NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_prime2, 0, sub_size));
			}
			ndr->flags = _flags_save_DATA_BLOB;
		}
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			{
				struct ndr_pull *_ndr_exponent1;
				ssize_t sub_size = 128;
				NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_exponent1, 0, sub_size));
				NDR_CHECK(ndr_pull_DATA_BLOB(_ndr_exponent1, NDR_SCALARS, &r->exponent1));
				NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_exponent1, 0, sub_size));
			}
			ndr->flags = _flags_save_DATA_BLOB;
		}
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			{
				struct ndr_pull *_ndr_exponent2;
				ssize_t sub_size = 128;
				NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_exponent2, 0, sub_size));
				NDR_CHECK(ndr_pull_DATA_BLOB(_ndr_exponent2, NDR_SCALARS, &r->exponent2));
				NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_exponent2, 0, sub_size));
			}
			ndr->flags = _flags_save_DATA_BLOB;
		}
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			{
				struct ndr_pull *_ndr_coefficient;
				ssize_t sub_size = 128;
				NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_coefficient, 0, sub_size));
				NDR_CHECK(ndr_pull_DATA_BLOB(_ndr_coefficient, NDR_SCALARS, &r->coefficient));
				NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_coefficient, 0, sub_size));
			}
			ndr->flags = _flags_save_DATA_BLOB;
		}
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			{
				struct ndr_pull *_ndr_private_exponent;
				ssize_t sub_size = 256;
				NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_private_exponent, 0, sub_size));
				NDR_CHECK(ndr_pull_DATA_BLOB(_ndr_private_exponent, NDR_SCALARS, &r->private_exponent));
				NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_private_exponent, 0, sub_size));
			}
			ndr->flags = _flags_save_DATA_BLOB;
		}
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			{
				struct ndr_pull *_ndr_cert;
				ssize_t sub_size = r->certificate_len;
				NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_cert, 0, sub_size));
				NDR_CHECK(ndr_pull_DATA_BLOB(_ndr_cert, NDR_SCALARS, &r->cert));
				NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_cert, 0, sub_size));
			}
			ndr->flags = _flags_save_DATA_BLOB;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_bkrp_exported_RSA_key_pair(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct bkrp_exported_RSA_key_pair *r)
{
	ndr_print_bkrp_exported_RSA_key_pair(ndr, name, r);
}

_PUBLIC_ void ndr_print_bkrp_exported_RSA_key_pair(struct ndr_print *ndr, const char *name, const struct bkrp_exported_RSA_key_pair *r)
{
	ndr_print_struct(ndr, name, "bkrp_exported_RSA_key_pair");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "header1", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0x00000002:r->header1);
	ndr_print_uint32(ndr, "header2", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0x00000494:r->header2);
	ndr_print_uint32(ndr, "certificate_len", r->certificate_len);
	ndr_print_uint32(ndr, "magic1", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0x00000207:r->magic1);
	ndr_print_uint32(ndr, "magic2", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0x0000A400:r->magic2);
	ndr_print_uint32(ndr, "magic3", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0x32415352:r->magic3);
	ndr_print_uint32(ndr, "magic4", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0x00000800:r->magic4);
	{
		libndr_flags _flags_save_DATA_BLOB = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
		ndr_print_DATA_BLOB(ndr, "public_exponent", r->public_exponent);
		ndr->flags = _flags_save_DATA_BLOB;
	}
	{
		libndr_flags _flags_save_DATA_BLOB = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
		ndr_print_DATA_BLOB(ndr, "modulus", r->modulus);
		ndr->flags = _flags_save_DATA_BLOB;
	}
	{
		libndr_flags _flags_save_DATA_BLOB = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
		ndr_print_DATA_BLOB(ndr, "prime1", r->prime1);
		ndr->flags = _flags_save_DATA_BLOB;
	}
	{
		libndr_flags _flags_save_DATA_BLOB = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
		ndr_print_DATA_BLOB(ndr, "prime2", r->prime2);
		ndr->flags = _flags_save_DATA_BLOB;
	}
	{
		libndr_flags _flags_save_DATA_BLOB = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
		ndr_print_DATA_BLOB(ndr, "exponent1", r->exponent1);
		ndr->flags = _flags_save_DATA_BLOB;
	}
	{
		libndr_flags _flags_save_DATA_BLOB = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
		ndr_print_DATA_BLOB(ndr, "exponent2", r->exponent2);
		ndr->flags = _flags_save_DATA_BLOB;
	}
	{
		libndr_flags _flags_save_DATA_BLOB = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
		ndr_print_DATA_BLOB(ndr, "coefficient", r->coefficient);
		ndr->flags = _flags_save_DATA_BLOB;
	}
	{
		libndr_flags _flags_save_DATA_BLOB = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
		ndr_print_DATA_BLOB(ndr, "private_exponent", r->private_exponent);
		ndr->flags = _flags_save_DATA_BLOB;
	}
	{
		libndr_flags _flags_save_DATA_BLOB = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
		ndr_print_DATA_BLOB(ndr, "cert", r->cert);
		ndr->flags = _flags_save_DATA_BLOB;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_bkrp_dc_serverwrap_key(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct bkrp_dc_serverwrap_key *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0x00000001));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->key, 256));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_bkrp_dc_serverwrap_key(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct bkrp_dc_serverwrap_key *r)
{
	uint32_t size_key_0 = 0;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->magic));
		size_key_0 = 256;
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->key, size_key_0));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_bkrp_dc_serverwrap_key(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct bkrp_dc_serverwrap_key *r)
{
	ndr_print_bkrp_dc_serverwrap_key(ndr, name, r);
}

_PUBLIC_ void ndr_print_bkrp_dc_serverwrap_key(struct ndr_print *ndr, const char *name, const struct bkrp_dc_serverwrap_key *r)
{
	ndr_print_struct(ndr, name, "bkrp_dc_serverwrap_key");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "magic", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0x00000001:r->magic);
	ndr_print_array_uint8(ndr, "key", r->key, 256);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_bkrp_empty(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct bkrp_empty *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 1));
		NDR_CHECK(ndr_push_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_bkrp_empty(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct bkrp_empty *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 1));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_bkrp_empty(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct bkrp_empty *r)
{
	ndr_print_bkrp_empty(ndr, name, r);
}

_PUBLIC_ void ndr_print_bkrp_empty(struct ndr_print *ndr, const char *name, const struct bkrp_empty *r)
{
	ndr_print_struct(ndr, name, "bkrp_empty");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_bkrp_client_side_wrapped(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct bkrp_client_side_wrapped *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->version));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->encrypted_secret_len));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->access_check_len));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->guid));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->encrypted_secret, r->encrypted_secret_len));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->access_check, r->access_check_len));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_bkrp_client_side_wrapped(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct bkrp_client_side_wrapped *r)
{
	uint32_t size_encrypted_secret_0 = 0;
	uint32_t size_access_check_0 = 0;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->version));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->encrypted_secret_len));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->access_check_len));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->guid));
		size_encrypted_secret_0 = r->encrypted_secret_len;
		NDR_PULL_ALLOC_N(ndr, r->encrypted_secret, size_encrypted_secret_0);
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->encrypted_secret, size_encrypted_secret_0));
		size_access_check_0 = r->access_check_len;
		NDR_PULL_ALLOC_N(ndr, r->access_check, size_access_check_0);
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->access_check, size_access_check_0));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_bkrp_client_side_wrapped(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct bkrp_client_side_wrapped *r)
{
	ndr_print_bkrp_client_side_wrapped(ndr, name, r);
}

_PUBLIC_ void ndr_print_bkrp_client_side_wrapped(struct ndr_print *ndr, const char *name, const struct bkrp_client_side_wrapped *r)
{
	ndr_print_struct(ndr, name, "bkrp_client_side_wrapped");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "version", r->version);
	ndr_print_uint32(ndr, "encrypted_secret_len", r->encrypted_secret_len);
	ndr_print_uint32(ndr, "access_check_len", r->access_check_len);
	ndr_print_GUID(ndr, "guid", &r->guid);
	ndr_print_array_uint8(ndr, "encrypted_secret", r->encrypted_secret, r->encrypted_secret_len);
	ndr_print_array_uint8(ndr, "access_check", r->access_check, r->access_check_len);
	ndr->depth--;
}

_PUBLIC_ size_t ndr_size_bkrp_client_side_wrapped(const struct bkrp_client_side_wrapped *r, libndr_flags flags)
{
	return ndr_size_struct(r, flags, (ndr_push_flags_fn_t)ndr_push_bkrp_client_side_wrapped);
}

_PUBLIC_ enum ndr_err_code ndr_push_bkrp_client_side_unwrapped(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct bkrp_client_side_unwrapped *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0x00000000));
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			{
				struct ndr_push *_ndr_secret;
				NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_secret, 0, -1));
				NDR_CHECK(ndr_push_DATA_BLOB(_ndr_secret, NDR_SCALARS, r->secret));
				NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_secret, 0, -1));
			}
			ndr->flags = _flags_save_DATA_BLOB;
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_bkrp_client_side_unwrapped(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct bkrp_client_side_unwrapped *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->magic));
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			{
				struct ndr_pull *_ndr_secret;
				ssize_t sub_size = -1;
				NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_secret, 0, sub_size));
				NDR_CHECK(ndr_pull_DATA_BLOB(_ndr_secret, NDR_SCALARS, &r->secret));
				NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_secret, 0, sub_size));
			}
			ndr->flags = _flags_save_DATA_BLOB;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_bkrp_client_side_unwrapped(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct bkrp_client_side_unwrapped *r)
{
	ndr_print_bkrp_client_side_unwrapped(ndr, name, r);
}

_PUBLIC_ void ndr_print_bkrp_client_side_unwrapped(struct ndr_print *ndr, const char *name, const struct bkrp_client_side_unwrapped *r)
{
	ndr_print_struct(ndr, name, "bkrp_client_side_unwrapped");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "magic", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0x00000000:r->magic);
	{
		libndr_flags _flags_save_DATA_BLOB = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
		ndr_print_DATA_BLOB(ndr, "secret", r->secret);
		ndr->flags = _flags_save_DATA_BLOB;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_bkrp_encrypted_secret_v2(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct bkrp_encrypted_secret_v2 *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->secret_len));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0x00000020));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->secret, r->secret_len));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->payload_key, 32));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_bkrp_encrypted_secret_v2(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct bkrp_encrypted_secret_v2 *r)
{
	uint32_t size_secret_0 = 0;
	uint32_t size_payload_key_0 = 0;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->secret_len));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->magic));
		size_secret_0 = r->secret_len;
		NDR_PULL_ALLOC_N(ndr, r->secret, size_secret_0);
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->secret, size_secret_0));
		size_payload_key_0 = 32;
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->payload_key, size_payload_key_0));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_bkrp_encrypted_secret_v2(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct bkrp_encrypted_secret_v2 *r)
{
	ndr_print_bkrp_encrypted_secret_v2(ndr, name, r);
}

_PUBLIC_ void ndr_print_bkrp_encrypted_secret_v2(struct ndr_print *ndr, const char *name, const struct bkrp_encrypted_secret_v2 *r)
{
	ndr_print_struct(ndr, name, "bkrp_encrypted_secret_v2");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "secret_len", r->secret_len);
	ndr_print_uint32(ndr, "magic", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0x00000020:r->magic);
	ndr_print_array_uint8(ndr, "secret", r->secret, r->secret_len);
	ndr_print_array_uint8(ndr, "payload_key", r->payload_key, 32);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_bkrp_encrypted_secret_v3(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct bkrp_encrypted_secret_v3 *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->secret_len));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0x00000030));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0x00006610));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0x0000800e));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->secret, r->secret_len));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->payload_key, 48));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_bkrp_encrypted_secret_v3(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct bkrp_encrypted_secret_v3 *r)
{
	uint32_t size_secret_0 = 0;
	uint32_t size_payload_key_0 = 0;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->secret_len));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->magic1));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->magic2));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->magic3));
		size_secret_0 = r->secret_len;
		NDR_PULL_ALLOC_N(ndr, r->secret, size_secret_0);
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->secret, size_secret_0));
		size_payload_key_0 = 48;
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->payload_key, size_payload_key_0));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_bkrp_encrypted_secret_v3(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct bkrp_encrypted_secret_v3 *r)
{
	ndr_print_bkrp_encrypted_secret_v3(ndr, name, r);
}

_PUBLIC_ void ndr_print_bkrp_encrypted_secret_v3(struct ndr_print *ndr, const char *name, const struct bkrp_encrypted_secret_v3 *r)
{
	ndr_print_struct(ndr, name, "bkrp_encrypted_secret_v3");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "secret_len", r->secret_len);
	ndr_print_uint32(ndr, "magic1", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0x00000030:r->magic1);
	ndr_print_uint32(ndr, "magic2", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0x00006610:r->magic2);
	ndr_print_uint32(ndr, "magic3", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0x0000800e:r->magic3);
	ndr_print_array_uint8(ndr, "secret", r->secret, r->secret_len);
	ndr_print_array_uint8(ndr, "payload_key", r->payload_key, 48);
	ndr->depth--;
}

static void ndr_print_flags_bkrp_access_check_v2(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct bkrp_access_check_v2 *r)
{
	ndr_print_bkrp_access_check_v2(ndr, name, r);
}

_PUBLIC_ void ndr_print_bkrp_access_check_v2(struct ndr_print *ndr, const char *name, const struct bkrp_access_check_v2 *r)
{
	ndr_print_struct(ndr, name, "bkrp_access_check_v2");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "magic", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0x00000001:r->magic);
	ndr_print_uint32(ndr, "nonce_len", r->nonce_len);
	ndr_print_array_uint8(ndr, "nonce", r->nonce, r->nonce_len);
	ndr_print_dom_sid(ndr, "sid", &r->sid);
	ndr_print_array_uint8(ndr, "hash", r->hash, 20);
	ndr->depth--;
}

static void ndr_print_flags_bkrp_access_check_v3(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct bkrp_access_check_v3 *r)
{
	ndr_print_bkrp_access_check_v3(ndr, name, r);
}

_PUBLIC_ void ndr_print_bkrp_access_check_v3(struct ndr_print *ndr, const char *name, const struct bkrp_access_check_v3 *r)
{
	ndr_print_struct(ndr, name, "bkrp_access_check_v3");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "magic", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0x00000001:r->magic);
	ndr_print_uint32(ndr, "nonce_len", r->nonce_len);
	ndr_print_array_uint8(ndr, "nonce", r->nonce, r->nonce_len);
	ndr_print_dom_sid(ndr, "sid", &r->sid);
	ndr_print_array_uint8(ndr, "hash", r->hash, 64);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_bkrp_rc4encryptedpayload(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct bkrp_rc4encryptedpayload *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->r3, 32));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->mac, 20));
		NDR_CHECK(ndr_push_dom_sid(ndr, NDR_SCALARS, &r->sid));
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			{
				struct ndr_push *_ndr_secret_data;
				NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_secret_data, 0, -1));
				NDR_CHECK(ndr_push_DATA_BLOB(_ndr_secret_data, NDR_SCALARS, r->secret_data));
				NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_secret_data, 0, -1));
			}
			ndr->flags = _flags_save_DATA_BLOB;
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_bkrp_rc4encryptedpayload(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct bkrp_rc4encryptedpayload *r)
{
	uint32_t size_r3_0 = 0;
	uint32_t size_mac_0 = 0;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		size_r3_0 = 32;
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->r3, size_r3_0));
		size_mac_0 = 20;
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->mac, size_mac_0));
		NDR_CHECK(ndr_pull_dom_sid(ndr, NDR_SCALARS, &r->sid));
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			{
				struct ndr_pull *_ndr_secret_data;
				ssize_t sub_size = -1;
				NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_secret_data, 0, sub_size));
				NDR_CHECK(ndr_pull_DATA_BLOB(_ndr_secret_data, NDR_SCALARS, &r->secret_data));
				NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_secret_data, 0, sub_size));
			}
			ndr->flags = _flags_save_DATA_BLOB;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_bkrp_rc4encryptedpayload(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct bkrp_rc4encryptedpayload *r)
{
	ndr_print_bkrp_rc4encryptedpayload(ndr, name, r);
}

_PUBLIC_ void ndr_print_bkrp_rc4encryptedpayload(struct ndr_print *ndr, const char *name, const struct bkrp_rc4encryptedpayload *r)
{
	ndr_print_struct(ndr, name, "bkrp_rc4encryptedpayload");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_array_uint8(ndr, "r3", r->r3, 32);
	ndr_print_array_uint8(ndr, "mac", r->mac, 20);
	ndr_print_dom_sid(ndr, "sid", &r->sid);
	{
		libndr_flags _flags_save_DATA_BLOB = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
		ndr_print_DATA_BLOB(ndr, "secret_data", r->secret_data);
		ndr->flags = _flags_save_DATA_BLOB;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_bkrp_server_side_wrapped(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct bkrp_server_side_wrapped *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0x00000001));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->payload_length));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->ciphertext_length));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->guid));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->r2, 68));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->rc4encryptedpayload, r->ciphertext_length));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_bkrp_server_side_wrapped(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct bkrp_server_side_wrapped *r)
{
	uint32_t size_r2_0 = 0;
	uint32_t size_rc4encryptedpayload_0 = 0;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->magic));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->payload_length));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->ciphertext_length));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->guid));
		size_r2_0 = 68;
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->r2, size_r2_0));
		size_rc4encryptedpayload_0 = r->ciphertext_length;
		NDR_PULL_ALLOC_N(ndr, r->rc4encryptedpayload, size_rc4encryptedpayload_0);
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->rc4encryptedpayload, size_rc4encryptedpayload_0));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_bkrp_server_side_wrapped(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct bkrp_server_side_wrapped *r)
{
	ndr_print_bkrp_server_side_wrapped(ndr, name, r);
}

_PUBLIC_ void ndr_print_bkrp_server_side_wrapped(struct ndr_print *ndr, const char *name, const struct bkrp_server_side_wrapped *r)
{
	ndr_print_struct(ndr, name, "bkrp_server_side_wrapped");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "magic", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0x00000001:r->magic);
	ndr_print_uint32(ndr, "payload_length", r->payload_length);
	ndr_print_uint32(ndr, "ciphertext_length", r->ciphertext_length);
	ndr_print_GUID(ndr, "guid", &r->guid);
	ndr_print_array_uint8(ndr, "r2", r->r2, 68);
	ndr_print_array_uint8(ndr, "rc4encryptedpayload", r->rc4encryptedpayload, r->ciphertext_length);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_bkrp_opaque_blob(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct bkrp_opaque_blob *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->opaque));
			ndr->flags = _flags_save_DATA_BLOB;
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_bkrp_opaque_blob(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct bkrp_opaque_blob *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->opaque));
			ndr->flags = _flags_save_DATA_BLOB;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_bkrp_opaque_blob(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct bkrp_opaque_blob *r)
{
	ndr_print_bkrp_opaque_blob(ndr, name, r);
}

_PUBLIC_ void ndr_print_bkrp_opaque_blob(struct ndr_print *ndr, const char *name, const struct bkrp_opaque_blob *r)
{
	ndr_print_struct(ndr, name, "bkrp_opaque_blob");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	{
		libndr_flags _flags_save_DATA_BLOB = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
		ndr_print_DATA_BLOB(ndr, "opaque", r->opaque);
		ndr->flags = _flags_save_DATA_BLOB;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_bkrp_data_in_blob(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union bkrp_data_in_blob *r)
{
	uint32_t level;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_push_union_align(ndr, 4));
		switch (level) {
			case BACKUPKEY_RESTORE_GUID_INTEGER: {
				NDR_CHECK(ndr_push_bkrp_client_side_wrapped(ndr, NDR_SCALARS, &r->restore_req));
			break; }

			case BACKUPKEY_RETRIEVE_BACKUP_KEY_GUID_INTEGER: {
				NDR_CHECK(ndr_push_bkrp_empty(ndr, NDR_SCALARS, &r->empty));
			break; }

			case BACKUPKEY_RESTORE_GUID_WIN2K_INTEGER: {
				NDR_CHECK(ndr_push_bkrp_server_side_wrapped(ndr, NDR_SCALARS, &r->unsign_req));
			break; }

			case BACKUPKEY_BACKUP_GUID_INTEGER: {
				NDR_CHECK(ndr_push_bkrp_opaque_blob(ndr, NDR_SCALARS, &r->sign_req));
			break; }

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case BACKUPKEY_RESTORE_GUID_INTEGER:
			break;

			case BACKUPKEY_RETRIEVE_BACKUP_KEY_GUID_INTEGER:
			break;

			case BACKUPKEY_RESTORE_GUID_WIN2K_INTEGER:
			break;

			case BACKUPKEY_BACKUP_GUID_INTEGER:
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_bkrp_data_in_blob(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union bkrp_data_in_blob *r)
{
	uint32_t level;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_pull_union_align(ndr, 4));
		switch (level) {
			case BACKUPKEY_RESTORE_GUID_INTEGER: {
				NDR_CHECK(ndr_pull_bkrp_client_side_wrapped(ndr, NDR_SCALARS, &r->restore_req));
			break; }

			case BACKUPKEY_RETRIEVE_BACKUP_KEY_GUID_INTEGER: {
				NDR_CHECK(ndr_pull_bkrp_empty(ndr, NDR_SCALARS, &r->empty));
			break; }

			case BACKUPKEY_RESTORE_GUID_WIN2K_INTEGER: {
				NDR_CHECK(ndr_pull_bkrp_server_side_wrapped(ndr, NDR_SCALARS, &r->unsign_req));
			break; }

			case BACKUPKEY_BACKUP_GUID_INTEGER: {
				NDR_CHECK(ndr_pull_bkrp_opaque_blob(ndr, NDR_SCALARS, &r->sign_req));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case BACKUPKEY_RESTORE_GUID_INTEGER:
			break;

			case BACKUPKEY_RETRIEVE_BACKUP_KEY_GUID_INTEGER:
			break;

			case BACKUPKEY_RESTORE_GUID_WIN2K_INTEGER:
			break;

			case BACKUPKEY_BACKUP_GUID_INTEGER:
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_bkrp_data_in_blob(struct ndr_print *ndr, const char *name, const union bkrp_data_in_blob *r)
{
	uint32_t level;
	level = ndr_print_steal_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "bkrp_data_in_blob");
	switch (level) {
		case BACKUPKEY_RESTORE_GUID_INTEGER:
			ndr_print_bkrp_client_side_wrapped(ndr, "restore_req", &r->restore_req);
		break;

		case BACKUPKEY_RETRIEVE_BACKUP_KEY_GUID_INTEGER:
			ndr_print_bkrp_empty(ndr, "empty", &r->empty);
		break;

		case BACKUPKEY_RESTORE_GUID_WIN2K_INTEGER:
			ndr_print_bkrp_server_side_wrapped(ndr, "unsign_req", &r->unsign_req);
		break;

		case BACKUPKEY_BACKUP_GUID_INTEGER:
			ndr_print_bkrp_opaque_blob(ndr, "sign_req", &r->sign_req);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

_PUBLIC_ enum ndr_err_code ndr_push_bkrp_BackupKey(struct ndr_push *ndr, ndr_flags_type flags, const struct bkrp_BackupKey *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.guidActionAgent == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.data_in == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, r->in.guidActionAgent));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.data_in_len));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->in.data_in, r->in.data_in_len));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.data_in_len));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.param));
	}
	if (flags & NDR_OUT) {
		if (r->out.data_out == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.data_out_len == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.data_out));
		if (*r->out.data_out) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, *r->out.data_out_len));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, *r->out.data_out, *r->out.data_out_len));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.data_out_len));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_bkrp_BackupKey(struct ndr_pull *ndr, ndr_flags_type flags, struct bkrp_BackupKey *r)
{
	uint32_t size_data_in_1 = 0;
	uint32_t _ptr_data_out;
	uint32_t size_data_out_2 = 0;
	TALLOC_CTX *_mem_save_guidActionAgent_0 = NULL;
	TALLOC_CTX *_mem_save_data_out_0 = NULL;
	TALLOC_CTX *_mem_save_data_out_1 = NULL;
	TALLOC_CTX *_mem_save_data_out_len_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.guidActionAgent);
		}
		_mem_save_guidActionAgent_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.guidActionAgent, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, r->in.guidActionAgent));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_guidActionAgent_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.data_in));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->in.data_in, &size_data_in_1));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC_N(ndr, r->in.data_in, size_data_in_1);
		}
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->in.data_in, size_data_in_1));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.data_in_len));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.param));
		NDR_PULL_ALLOC(ndr, r->out.data_out);
		NDR_ZERO_STRUCTP(r->out.data_out);
		NDR_PULL_ALLOC(ndr, r->out.data_out_len);
		NDR_ZERO_STRUCTP(r->out.data_out_len);
		if (r->in.data_in) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->in.data_in, r->in.data_in_len));
		}
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.guidActionAgent == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.guidActionAgent);
			NDR_ZERO_STRUCTP(r->in.guidActionAgent);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.data_out);
		}
		_mem_save_data_out_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.data_out, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_data_out));
		if (_ptr_data_out) {
			NDR_PULL_ALLOC(ndr, *r->out.data_out);
		} else {
			*r->out.data_out = NULL;
		}
		if (*r->out.data_out) {
			_mem_save_data_out_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.data_out, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, r->out.data_out));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)r->out.data_out, &size_data_out_2));
			NDR_PULL_ALLOC_N(ndr, *r->out.data_out, size_data_out_2);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, *r->out.data_out, size_data_out_2));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_data_out_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_data_out_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.data_out_len);
		}
		_mem_save_data_out_len_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.data_out_len, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.data_out_len));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_data_out_len_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (*r->out.data_out) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)r->out.data_out, *r->out.data_out_len));
		}
	}
	return NDR_ERR_SUCCESS;
}

#ifndef SKIP_NDR_TABLE_backupkey
static const struct ndr_interface_public_struct backupkey_public_structs[] = {
	{
		.name = "bkrp_exported_RSA_key_pair",
		.struct_size = sizeof(struct bkrp_exported_RSA_key_pair ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_bkrp_exported_RSA_key_pair,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_bkrp_exported_RSA_key_pair,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_bkrp_exported_RSA_key_pair,
	},
	{
		.name = "bkrp_dc_serverwrap_key",
		.struct_size = sizeof(struct bkrp_dc_serverwrap_key ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_bkrp_dc_serverwrap_key,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_bkrp_dc_serverwrap_key,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_bkrp_dc_serverwrap_key,
	},
	{
		.name = "bkrp_empty",
		.struct_size = sizeof(struct bkrp_empty ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_bkrp_empty,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_bkrp_empty,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_bkrp_empty,
	},
	{
		.name = "bkrp_client_side_wrapped",
		.struct_size = sizeof(struct bkrp_client_side_wrapped ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_bkrp_client_side_wrapped,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_bkrp_client_side_wrapped,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_bkrp_client_side_wrapped,
	},
	{
		.name = "bkrp_client_side_unwrapped",
		.struct_size = sizeof(struct bkrp_client_side_unwrapped ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_bkrp_client_side_unwrapped,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_bkrp_client_side_unwrapped,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_bkrp_client_side_unwrapped,
	},
	{
		.name = "bkrp_encrypted_secret_v2",
		.struct_size = sizeof(struct bkrp_encrypted_secret_v2 ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_bkrp_encrypted_secret_v2,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_bkrp_encrypted_secret_v2,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_bkrp_encrypted_secret_v2,
	},
	{
		.name = "bkrp_encrypted_secret_v3",
		.struct_size = sizeof(struct bkrp_encrypted_secret_v3 ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_bkrp_encrypted_secret_v3,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_bkrp_encrypted_secret_v3,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_bkrp_encrypted_secret_v3,
	},
	{
		.name = "bkrp_access_check_v2",
		.struct_size = sizeof(struct bkrp_access_check_v2 ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_bkrp_access_check_v2,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_bkrp_access_check_v2,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_bkrp_access_check_v2,
	},
	{
		.name = "bkrp_access_check_v3",
		.struct_size = sizeof(struct bkrp_access_check_v3 ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_bkrp_access_check_v3,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_bkrp_access_check_v3,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_bkrp_access_check_v3,
	},
	{
		.name = "bkrp_rc4encryptedpayload",
		.struct_size = sizeof(struct bkrp_rc4encryptedpayload ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_bkrp_rc4encryptedpayload,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_bkrp_rc4encryptedpayload,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_bkrp_rc4encryptedpayload,
	},
	{
		.name = "bkrp_server_side_wrapped",
		.struct_size = sizeof(struct bkrp_server_side_wrapped ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_bkrp_server_side_wrapped,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_bkrp_server_side_wrapped,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_bkrp_server_side_wrapped,
	},
	{
		.name = "bkrp_opaque_blob",
		.struct_size = sizeof(struct bkrp_opaque_blob ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_bkrp_opaque_blob,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_bkrp_opaque_blob,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_bkrp_opaque_blob,
	},
	{ .name = NULL }
};

static const struct ndr_interface_call backupkey_calls[] = {
	{
		"bkrp_BackupKey",
		sizeof(struct bkrp_BackupKey),
		(ndr_push_flags_fn_t) ndr_push_bkrp_BackupKey,
		(ndr_pull_flags_fn_t) ndr_pull_bkrp_BackupKey,
		(ndr_print_function_t) ndr_print_bkrp_BackupKey,
		{ 0, NULL },
		{ 0, NULL },
	},
	{ .name = NULL }
};

static const char * const backupkey_endpoint_strings[] = {
	"ncacn_np:[\\pipe\\protected_storage]", 
	"ncacn_ip_tcp:", 
};

static const struct ndr_interface_string_array backupkey_endpoints = {
	.count	= 2,
	.names	= backupkey_endpoint_strings
};

static const char * const backupkey_authservice_strings[] = {
	"host", 
};

static const struct ndr_interface_string_array backupkey_authservices = {
	.count	= 1,
	.names	= backupkey_authservice_strings
};


const struct ndr_interface_table ndr_table_backupkey = {
	.name		= "backupkey",
	.syntax_id	= {
		{0x3dde7c30,0x165d,0x11d1,{0xab,0x8f},{0x00,0x80,0x5f,0x14,0xdb,0x40}},
		NDR_BACKUPKEY_VERSION
	},
	.helpstring	= NDR_BACKUPKEY_HELPSTRING,
	.num_calls	= 1,
	.calls		= backupkey_calls,
	.num_public_structs	= 12,
	.public_structs		= backupkey_public_structs,
	.endpoints	= &backupkey_endpoints,
	.authservices	= &backupkey_authservices
};

#endif /* SKIP_NDR_TABLE_backupkey */
