// MIT License
//
// Copyright (c) 2023-2025 Advanced Micro Devices, Inc. All rights reserved.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

#if defined(ROCPROFILER_LIB_ROCPROFILER_HIP_HIP_CPP_IMPL) &&                                       \
    ROCPROFILER_LIB_ROCPROFILER_HIP_HIP_CPP_IMPL == 1

#    include <rocprofiler-sdk/external_correlation.h>
#    include <rocprofiler-sdk/hip.h>

#    include "defines.hpp"
#    include "hip.hpp"

namespace rocprofiler
{
namespace hip
{
template <>
struct hip_domain_info<ROCPROFILER_HIP_TABLE_ID_LAST>
{
    using args_type              = rocprofiler_hip_api_args_t;
    using retval_type            = rocprofiler_hip_api_retval_t;
    using callback_data_type     = rocprofiler_callback_tracing_hip_api_data_t;
    using buffered_data_type     = rocprofiler_buffer_tracing_hip_api_record_t;
    using buffered_ext_data_type = rocprofiler_buffer_tracing_hip_api_ext_record_t;
};

template <>
struct hip_domain_info<ROCPROFILER_HIP_TABLE_ID_Runtime>
: hip_domain_info<ROCPROFILER_HIP_TABLE_ID_LAST>
{
    static constexpr auto callback_domain_idx     = ROCPROFILER_CALLBACK_TRACING_HIP_RUNTIME_API;
    static constexpr auto buffered_domain_idx     = ROCPROFILER_BUFFER_TRACING_HIP_RUNTIME_API;
    static constexpr auto buffered_ext_domain_idx = ROCPROFILER_BUFFER_TRACING_HIP_RUNTIME_API_EXT;
    static constexpr auto none                    = ROCPROFILER_HIP_RUNTIME_API_ID_NONE;
    static constexpr auto last                    = ROCPROFILER_HIP_RUNTIME_API_ID_LAST;
    static constexpr auto external_correlation_id_domain_idx =
        ROCPROFILER_EXTERNAL_CORRELATION_REQUEST_HIP_RUNTIME_API;
};

template <>
struct hip_domain_info<ROCPROFILER_HIP_TABLE_ID_Compiler>
: hip_domain_info<ROCPROFILER_HIP_TABLE_ID_LAST>
{
    static constexpr auto callback_domain_idx     = ROCPROFILER_CALLBACK_TRACING_HIP_COMPILER_API;
    static constexpr auto buffered_domain_idx     = ROCPROFILER_BUFFER_TRACING_HIP_COMPILER_API;
    static constexpr auto buffered_ext_domain_idx = ROCPROFILER_BUFFER_TRACING_HIP_COMPILER_API_EXT;
    static constexpr auto none                    = ROCPROFILER_HIP_COMPILER_API_ID_NONE;
    static constexpr auto last                    = ROCPROFILER_HIP_COMPILER_API_ID_LAST;
    static constexpr auto external_correlation_id_domain_idx =
        ROCPROFILER_EXTERNAL_CORRELATION_REQUEST_HIP_COMPILER_API;
};
}  // namespace hip
}  // namespace rocprofiler

// clang-format off
HIP_API_TABLE_LOOKUP_DEFINITION(ROCPROFILER_HIP_TABLE_ID_Compiler, hip_compiler_api_table_t, compiler)
HIP_API_TABLE_LOOKUP_DEFINITION(ROCPROFILER_HIP_TABLE_ID_Runtime, hip_runtime_api_table_t, runtime)

HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Compiler, ROCPROFILER_HIP_COMPILER_API_ID___hipPopCallConfiguration, __hipPopCallConfiguration, __hipPopCallConfiguration_fn, gridDim, blockDim, sharedMem, stream)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Compiler, ROCPROFILER_HIP_COMPILER_API_ID___hipPushCallConfiguration, __hipPushCallConfiguration, __hipPushCallConfiguration_fn, gridDim, blockDim, sharedMem, stream)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Compiler, ROCPROFILER_HIP_COMPILER_API_ID___hipRegisterFatBinary, __hipRegisterFatBinary, __hipRegisterFatBinary_fn, data)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Compiler, ROCPROFILER_HIP_COMPILER_API_ID___hipRegisterFunction, __hipRegisterFunction, __hipRegisterFunction_fn, modules, hostFunction, deviceFunction, deviceName, threadLimit, tid, bid, blockDim, gridDim, wSize)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Compiler, ROCPROFILER_HIP_COMPILER_API_ID___hipRegisterManagedVar, __hipRegisterManagedVar, __hipRegisterManagedVar_fn, hipModule, pointer, init_value, name, size, align)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Compiler, ROCPROFILER_HIP_COMPILER_API_ID___hipRegisterSurface, __hipRegisterSurface, __hipRegisterSurface_fn, modules, var, hostVar, deviceVar, type, ext)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Compiler, ROCPROFILER_HIP_COMPILER_API_ID___hipRegisterTexture, __hipRegisterTexture, __hipRegisterTexture_fn, modules, var, hostVar, deviceVar, type, norm, ext)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Compiler, ROCPROFILER_HIP_COMPILER_API_ID___hipRegisterVar, __hipRegisterVar, __hipRegisterVar_fn, modules, var, hostVar, deviceVar, ext, size, constant, global)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Compiler, ROCPROFILER_HIP_COMPILER_API_ID___hipUnregisterFatBinary, __hipUnregisterFatBinary, __hipUnregisterFatBinary_fn, modules)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipApiName, hipApiName, hipApiName_fn, id)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipArray3DCreate, hipArray3DCreate, hipArray3DCreate_fn, array, pAllocateArray)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipArray3DGetDescriptor, hipArray3DGetDescriptor, hipArray3DGetDescriptor_fn, pArrayDescriptor, array)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipArrayCreate, hipArrayCreate, hipArrayCreate_fn, pHandle, pAllocateArray)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipArrayDestroy, hipArrayDestroy, hipArrayDestroy_fn, array)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipArrayGetDescriptor, hipArrayGetDescriptor, hipArrayGetDescriptor_fn, pArrayDescriptor, array)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipArrayGetInfo, hipArrayGetInfo, hipArrayGetInfo_fn, desc, extent, flags, array)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipBindTexture, hipBindTexture, hipBindTexture_fn, offset, tex, devPtr, desc, size)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipBindTexture2D, hipBindTexture2D, hipBindTexture2D_fn, offset, tex, devPtr, desc, width, height, pitch)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipBindTextureToArray, hipBindTextureToArray, hipBindTextureToArray_fn, tex, array, desc)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipBindTextureToMipmappedArray, hipBindTextureToMipmappedArray, hipBindTextureToMipmappedArray_fn, tex, mipmappedArray, desc)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipChooseDevice, hipChooseDevice, hipChooseDevice_fn, device, prop)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipChooseDeviceR0000, hipChooseDeviceR0000, hipChooseDeviceR0000_fn, device, prop)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipConfigureCall, hipConfigureCall, hipConfigureCall_fn, gridDim, blockDim, sharedMem, stream)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipCreateSurfaceObject, hipCreateSurfaceObject, hipCreateSurfaceObject_fn, pSurfObject, pResDesc)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipCreateTextureObject, hipCreateTextureObject, hipCreateTextureObject_fn, pTexObject, pResDesc, pTexDesc, pResViewDesc)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipCtxCreate, hipCtxCreate, hipCtxCreate_fn, ctx, flags, device)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipCtxDestroy, hipCtxDestroy, hipCtxDestroy_fn, ctx)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipCtxDisablePeerAccess, hipCtxDisablePeerAccess, hipCtxDisablePeerAccess_fn, peerCtx)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipCtxEnablePeerAccess, hipCtxEnablePeerAccess, hipCtxEnablePeerAccess_fn, peerCtx, flags)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipCtxGetApiVersion, hipCtxGetApiVersion, hipCtxGetApiVersion_fn, ctx, apiVersion)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipCtxGetCacheConfig, hipCtxGetCacheConfig, hipCtxGetCacheConfig_fn, cacheConfig)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipCtxGetCurrent, hipCtxGetCurrent, hipCtxGetCurrent_fn, ctx)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipCtxGetDevice, hipCtxGetDevice, hipCtxGetDevice_fn, device)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipCtxGetFlags, hipCtxGetFlags, hipCtxGetFlags_fn, flags)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipCtxGetSharedMemConfig, hipCtxGetSharedMemConfig, hipCtxGetSharedMemConfig_fn, pConfig)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipCtxPopCurrent, hipCtxPopCurrent, hipCtxPopCurrent_fn, ctx)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipCtxPushCurrent, hipCtxPushCurrent, hipCtxPushCurrent_fn, ctx)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipCtxSetCacheConfig, hipCtxSetCacheConfig, hipCtxSetCacheConfig_fn, cacheConfig)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipCtxSetCurrent, hipCtxSetCurrent, hipCtxSetCurrent_fn, ctx)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipCtxSetSharedMemConfig, hipCtxSetSharedMemConfig, hipCtxSetSharedMemConfig_fn, config)
HIP_API_INFO_DEFINITION_0(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipCtxSynchronize, hipCtxSynchronize, hipCtxSynchronize_fn)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipDestroyExternalMemory, hipDestroyExternalMemory, hipDestroyExternalMemory_fn, extMem)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipDestroyExternalSemaphore, hipDestroyExternalSemaphore, hipDestroyExternalSemaphore_fn, extSem)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipDestroySurfaceObject, hipDestroySurfaceObject, hipDestroySurfaceObject_fn, surfaceObject)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipDestroyTextureObject, hipDestroyTextureObject, hipDestroyTextureObject_fn, textureObject)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipDeviceCanAccessPeer, hipDeviceCanAccessPeer, hipDeviceCanAccessPeer_fn, canAccessPeer, deviceId, peerDeviceId)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipDeviceComputeCapability, hipDeviceComputeCapability, hipDeviceComputeCapability_fn, major, minor, device)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipDeviceDisablePeerAccess, hipDeviceDisablePeerAccess, hipDeviceDisablePeerAccess_fn, peerDeviceId)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipDeviceEnablePeerAccess, hipDeviceEnablePeerAccess, hipDeviceEnablePeerAccess_fn, peerDeviceId, flags)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipDeviceGet, hipDeviceGet, hipDeviceGet_fn, device, ordinal)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipDeviceGetAttribute, hipDeviceGetAttribute, hipDeviceGetAttribute_fn, pi, attr, deviceId)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipDeviceGetByPCIBusId, hipDeviceGetByPCIBusId, hipDeviceGetByPCIBusId_fn, device, pciBusId)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipDeviceGetCacheConfig, hipDeviceGetCacheConfig, hipDeviceGetCacheConfig_fn, cacheConfig)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipDeviceGetDefaultMemPool, hipDeviceGetDefaultMemPool, hipDeviceGetDefaultMemPool_fn, mem_pool, device)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipDeviceGetGraphMemAttribute, hipDeviceGetGraphMemAttribute, hipDeviceGetGraphMemAttribute_fn, device, attr, value)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipDeviceGetLimit, hipDeviceGetLimit, hipDeviceGetLimit_fn, pValue, limit)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipDeviceGetMemPool, hipDeviceGetMemPool, hipDeviceGetMemPool_fn, mem_pool, device)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipDeviceGetName, hipDeviceGetName, hipDeviceGetName_fn, name, len, device)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipDeviceGetP2PAttribute, hipDeviceGetP2PAttribute, hipDeviceGetP2PAttribute_fn, value, attr, srcDevice, dstDevice)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipDeviceGetPCIBusId, hipDeviceGetPCIBusId, hipDeviceGetPCIBusId_fn, pciBusId, len, device)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipDeviceGetSharedMemConfig, hipDeviceGetSharedMemConfig, hipDeviceGetSharedMemConfig_fn, pConfig)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipDeviceGetStreamPriorityRange, hipDeviceGetStreamPriorityRange, hipDeviceGetStreamPriorityRange_fn, leastPriority, greatestPriority)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipDeviceGetUuid, hipDeviceGetUuid, hipDeviceGetUuid_fn, uuid, device)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipDeviceGraphMemTrim, hipDeviceGraphMemTrim, hipDeviceGraphMemTrim_fn, device)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipDevicePrimaryCtxGetState, hipDevicePrimaryCtxGetState, hipDevicePrimaryCtxGetState_fn, dev, flags, active)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipDevicePrimaryCtxRelease, hipDevicePrimaryCtxRelease, hipDevicePrimaryCtxRelease_fn, dev)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipDevicePrimaryCtxReset, hipDevicePrimaryCtxReset, hipDevicePrimaryCtxReset_fn, dev)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipDevicePrimaryCtxRetain, hipDevicePrimaryCtxRetain, hipDevicePrimaryCtxRetain_fn, pctx, dev)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipDevicePrimaryCtxSetFlags, hipDevicePrimaryCtxSetFlags, hipDevicePrimaryCtxSetFlags_fn, dev, flags)
HIP_API_INFO_DEFINITION_0(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipDeviceReset, hipDeviceReset, hipDeviceReset_fn)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipDeviceSetCacheConfig, hipDeviceSetCacheConfig, hipDeviceSetCacheConfig_fn, cacheConfig)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipDeviceSetGraphMemAttribute, hipDeviceSetGraphMemAttribute, hipDeviceSetGraphMemAttribute_fn, device, attr, value)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipDeviceSetLimit, hipDeviceSetLimit, hipDeviceSetLimit_fn, limit, value)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipDeviceSetMemPool, hipDeviceSetMemPool, hipDeviceSetMemPool_fn, device, mem_pool)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipDeviceSetSharedMemConfig, hipDeviceSetSharedMemConfig, hipDeviceSetSharedMemConfig_fn, config)
HIP_API_INFO_DEFINITION_0(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipDeviceSynchronize, hipDeviceSynchronize, hipDeviceSynchronize_fn)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipDeviceTotalMem, hipDeviceTotalMem, hipDeviceTotalMem_fn, bytes, device)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipDriverGetVersion, hipDriverGetVersion, hipDriverGetVersion_fn, driverVersion)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipDrvGetErrorName, hipDrvGetErrorName, hipDrvGetErrorName_fn, hipError, errorString)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipDrvGetErrorString, hipDrvGetErrorString, hipDrvGetErrorString_fn, hipError, errorString)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipDrvGraphAddMemcpyNode, hipDrvGraphAddMemcpyNode, hipDrvGraphAddMemcpyNode_fn, phGraphNode, hGraph, dependencies, numDependencies, copyParams, ctx)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipDrvMemcpy2DUnaligned, hipDrvMemcpy2DUnaligned, hipDrvMemcpy2DUnaligned_fn, pCopy)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipDrvMemcpy3D, hipDrvMemcpy3D, hipDrvMemcpy3D_fn, pCopy)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipDrvMemcpy3DAsync, hipDrvMemcpy3DAsync, hipDrvMemcpy3DAsync_fn, pCopy, stream)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipDrvPointerGetAttributes, hipDrvPointerGetAttributes, hipDrvPointerGetAttributes_fn, numAttributes, attributes, data, ptr)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipEventCreate, hipEventCreate, hipEventCreate_fn, event)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipEventCreateWithFlags, hipEventCreateWithFlags, hipEventCreateWithFlags_fn, event, flags)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipEventDestroy, hipEventDestroy, hipEventDestroy_fn, event)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipEventElapsedTime, hipEventElapsedTime, hipEventElapsedTime_fn, ms, start, stop)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipEventQuery, hipEventQuery, hipEventQuery_fn, event)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipEventRecord, hipEventRecord, hipEventRecord_fn, event, stream)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipEventSynchronize, hipEventSynchronize, hipEventSynchronize_fn, event)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipExtGetLinkTypeAndHopCount, hipExtGetLinkTypeAndHopCount, hipExtGetLinkTypeAndHopCount_fn, device1, device2, linktype, hopcount)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipExtLaunchKernel, hipExtLaunchKernel, hipExtLaunchKernel_fn, function_address, numBlocks, dimBlocks, args, sharedMemBytes, stream, startEvent, stopEvent, flags)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipExtLaunchMultiKernelMultiDevice, hipExtLaunchMultiKernelMultiDevice, hipExtLaunchMultiKernelMultiDevice_fn, launchParamsList, numDevices, flags)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipExtMallocWithFlags, hipExtMallocWithFlags, hipExtMallocWithFlags_fn, ptr, sizeBytes, flags)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipExtStreamCreateWithCUMask, hipExtStreamCreateWithCUMask, hipExtStreamCreateWithCUMask_fn, stream, cuMaskSize, cuMask)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipExtStreamGetCUMask, hipExtStreamGetCUMask, hipExtStreamGetCUMask_fn, stream, cuMaskSize, cuMask)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipExternalMemoryGetMappedBuffer, hipExternalMemoryGetMappedBuffer, hipExternalMemoryGetMappedBuffer_fn, devPtr, extMem, bufferDesc)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipFree, hipFree, hipFree_fn, ptr)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipFreeArray, hipFreeArray, hipFreeArray_fn, array)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipFreeAsync, hipFreeAsync, hipFreeAsync_fn, dev_ptr, stream)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipFreeHost, hipFreeHost, hipFreeHost_fn, ptr)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipFreeMipmappedArray, hipFreeMipmappedArray, hipFreeMipmappedArray_fn, mipmappedArray)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipFuncGetAttribute, hipFuncGetAttribute, hipFuncGetAttribute_fn, value, attrib, hfunc)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipFuncGetAttributes, hipFuncGetAttributes, hipFuncGetAttributes_fn, attr, func)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipFuncSetAttribute, hipFuncSetAttribute, hipFuncSetAttribute_fn, func, attr, value)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipFuncSetCacheConfig, hipFuncSetCacheConfig, hipFuncSetCacheConfig_fn, func, config)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipFuncSetSharedMemConfig, hipFuncSetSharedMemConfig, hipFuncSetSharedMemConfig_fn, func, config)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGLGetDevices, hipGLGetDevices, hipGLGetDevices_fn, pHipDeviceCount, pHipDevices, hipDeviceCount, deviceList)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGetChannelDesc, hipGetChannelDesc, hipGetChannelDesc_fn, desc, array)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGetDevice, hipGetDevice, hipGetDevice_fn, deviceId)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGetDeviceCount, hipGetDeviceCount, hipGetDeviceCount_fn, count)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGetDeviceFlags, hipGetDeviceFlags, hipGetDeviceFlags_fn, flags)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGetDevicePropertiesR0600, hipGetDevicePropertiesR0600, hipGetDevicePropertiesR0600_fn, prop, deviceId)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGetDevicePropertiesR0000, hipGetDevicePropertiesR0000, hipGetDevicePropertiesR0000_fn, prop, deviceId)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGetErrorName, hipGetErrorName, hipGetErrorName_fn, hip_error)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGetErrorString, hipGetErrorString, hipGetErrorString_fn, hipError)
HIP_API_INFO_DEFINITION_0(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGetLastError, hipGetLastError, hipGetLastError_fn)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGetMipmappedArrayLevel, hipGetMipmappedArrayLevel, hipGetMipmappedArrayLevel_fn, levelArray, mipmappedArray, level)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGetSymbolAddress, hipGetSymbolAddress, hipGetSymbolAddress_fn, devPtr, symbol)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGetSymbolSize, hipGetSymbolSize, hipGetSymbolSize_fn, size, symbol)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGetTextureAlignmentOffset, hipGetTextureAlignmentOffset, hipGetTextureAlignmentOffset_fn, offset, texref)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGetTextureObjectResourceDesc, hipGetTextureObjectResourceDesc, hipGetTextureObjectResourceDesc_fn, pResDesc, textureObject)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGetTextureObjectResourceViewDesc, hipGetTextureObjectResourceViewDesc, hipGetTextureObjectResourceViewDesc_fn, pResViewDesc, textureObject)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGetTextureObjectTextureDesc, hipGetTextureObjectTextureDesc, hipGetTextureObjectTextureDesc_fn, pTexDesc, textureObject)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGetTextureReference, hipGetTextureReference, hipGetTextureReference_fn, texref, symbol)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphAddChildGraphNode, hipGraphAddChildGraphNode, hipGraphAddChildGraphNode_fn, pGraphNode, graph, pDependencies, numDependencies, childGraph)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphAddDependencies, hipGraphAddDependencies, hipGraphAddDependencies_fn, graph, from, to, numDependencies)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphAddEmptyNode, hipGraphAddEmptyNode, hipGraphAddEmptyNode_fn, pGraphNode, graph, pDependencies, numDependencies)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphAddEventRecordNode, hipGraphAddEventRecordNode, hipGraphAddEventRecordNode_fn, pGraphNode, graph, pDependencies, numDependencies, event)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphAddEventWaitNode, hipGraphAddEventWaitNode, hipGraphAddEventWaitNode_fn, pGraphNode, graph, pDependencies, numDependencies, event)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphAddHostNode, hipGraphAddHostNode, hipGraphAddHostNode_fn, pGraphNode, graph, pDependencies, numDependencies, pNodeParams)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphAddKernelNode, hipGraphAddKernelNode, hipGraphAddKernelNode_fn, pGraphNode, graph, pDependencies, numDependencies, pNodeParams)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphAddMemAllocNode, hipGraphAddMemAllocNode, hipGraphAddMemAllocNode_fn, pGraphNode, graph, pDependencies, numDependencies, pNodeParams)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphAddMemFreeNode, hipGraphAddMemFreeNode, hipGraphAddMemFreeNode_fn, pGraphNode, graph, pDependencies, numDependencies, dev_ptr)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphAddMemcpyNode, hipGraphAddMemcpyNode, hipGraphAddMemcpyNode_fn, pGraphNode, graph, pDependencies, numDependencies, pCopyParams)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphAddMemcpyNode1D, hipGraphAddMemcpyNode1D, hipGraphAddMemcpyNode1D_fn, pGraphNode, graph, pDependencies, numDependencies, dst, src, count, kind)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphAddMemcpyNodeFromSymbol, hipGraphAddMemcpyNodeFromSymbol, hipGraphAddMemcpyNodeFromSymbol_fn, pGraphNode, graph, pDependencies, numDependencies, dst, symbol, count, offset, kind)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphAddMemcpyNodeToSymbol, hipGraphAddMemcpyNodeToSymbol, hipGraphAddMemcpyNodeToSymbol_fn, pGraphNode, graph, pDependencies, numDependencies, symbol, src, count, offset, kind)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphAddMemsetNode, hipGraphAddMemsetNode, hipGraphAddMemsetNode_fn, pGraphNode, graph, pDependencies, numDependencies, pMemsetParams)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphChildGraphNodeGetGraph, hipGraphChildGraphNodeGetGraph, hipGraphChildGraphNodeGetGraph_fn, node, pGraph)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphClone, hipGraphClone, hipGraphClone_fn, pGraphClone, originalGraph)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphCreate, hipGraphCreate, hipGraphCreate_fn, pGraph, flags)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphDebugDotPrint, hipGraphDebugDotPrint, hipGraphDebugDotPrint_fn, graph, path, flags)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphDestroy, hipGraphDestroy, hipGraphDestroy_fn, graph)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphDestroyNode, hipGraphDestroyNode, hipGraphDestroyNode_fn, node)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphEventRecordNodeGetEvent, hipGraphEventRecordNodeGetEvent, hipGraphEventRecordNodeGetEvent_fn, node, event_out)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphEventRecordNodeSetEvent, hipGraphEventRecordNodeSetEvent, hipGraphEventRecordNodeSetEvent_fn, node, event)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphEventWaitNodeGetEvent, hipGraphEventWaitNodeGetEvent, hipGraphEventWaitNodeGetEvent_fn, node, event_out)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphEventWaitNodeSetEvent, hipGraphEventWaitNodeSetEvent, hipGraphEventWaitNodeSetEvent_fn, node, event)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphExecChildGraphNodeSetParams, hipGraphExecChildGraphNodeSetParams, hipGraphExecChildGraphNodeSetParams_fn, hGraphExec, node, childGraph)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphExecDestroy, hipGraphExecDestroy, hipGraphExecDestroy_fn, graphExec)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphExecEventRecordNodeSetEvent, hipGraphExecEventRecordNodeSetEvent, hipGraphExecEventRecordNodeSetEvent_fn, hGraphExec, hNode, event)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphExecEventWaitNodeSetEvent, hipGraphExecEventWaitNodeSetEvent, hipGraphExecEventWaitNodeSetEvent_fn, hGraphExec, hNode, event)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphExecHostNodeSetParams, hipGraphExecHostNodeSetParams, hipGraphExecHostNodeSetParams_fn, hGraphExec, node, pNodeParams)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphExecKernelNodeSetParams, hipGraphExecKernelNodeSetParams, hipGraphExecKernelNodeSetParams_fn, hGraphExec, node, pNodeParams)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphExecMemcpyNodeSetParams, hipGraphExecMemcpyNodeSetParams, hipGraphExecMemcpyNodeSetParams_fn, hGraphExec, node, pNodeParams)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphExecMemcpyNodeSetParams1D, hipGraphExecMemcpyNodeSetParams1D, hipGraphExecMemcpyNodeSetParams1D_fn, hGraphExec, node, dst, src, count, kind)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphExecMemcpyNodeSetParamsFromSymbol, hipGraphExecMemcpyNodeSetParamsFromSymbol, hipGraphExecMemcpyNodeSetParamsFromSymbol_fn, hGraphExec, node, dst, symbol, count, offset, kind)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphExecMemcpyNodeSetParamsToSymbol, hipGraphExecMemcpyNodeSetParamsToSymbol, hipGraphExecMemcpyNodeSetParamsToSymbol_fn, hGraphExec, node, symbol, src, count, offset, kind)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphExecMemsetNodeSetParams, hipGraphExecMemsetNodeSetParams, hipGraphExecMemsetNodeSetParams_fn, hGraphExec, node, pNodeParams)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphExecUpdate, hipGraphExecUpdate, hipGraphExecUpdate_fn, hGraphExec, hGraph, hErrorNode_out, updateResult_out)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphGetEdges, hipGraphGetEdges, hipGraphGetEdges_fn, graph, from, to, numEdges)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphGetNodes, hipGraphGetNodes, hipGraphGetNodes_fn, graph, nodes, numNodes)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphGetRootNodes, hipGraphGetRootNodes, hipGraphGetRootNodes_fn, graph, pRootNodes, pNumRootNodes)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphHostNodeGetParams, hipGraphHostNodeGetParams, hipGraphHostNodeGetParams_fn, node, pNodeParams)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphHostNodeSetParams, hipGraphHostNodeSetParams, hipGraphHostNodeSetParams_fn, node, pNodeParams)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphInstantiate, hipGraphInstantiate, hipGraphInstantiate_fn, pGraphExec, graph, pErrorNode, pLogBuffer, bufferSize)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphInstantiateWithFlags, hipGraphInstantiateWithFlags, hipGraphInstantiateWithFlags_fn, pGraphExec, graph, flags)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphKernelNodeCopyAttributes, hipGraphKernelNodeCopyAttributes, hipGraphKernelNodeCopyAttributes_fn, hSrc, hDst)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphKernelNodeGetAttribute, hipGraphKernelNodeGetAttribute, hipGraphKernelNodeGetAttribute_fn, hNode, attr, value)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphKernelNodeGetParams, hipGraphKernelNodeGetParams, hipGraphKernelNodeGetParams_fn, node, pNodeParams)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphKernelNodeSetAttribute, hipGraphKernelNodeSetAttribute, hipGraphKernelNodeSetAttribute_fn, hNode, attr, value)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphKernelNodeSetParams, hipGraphKernelNodeSetParams, hipGraphKernelNodeSetParams_fn, node, pNodeParams)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphLaunch, hipGraphLaunch, hipGraphLaunch_fn, graphExec, stream)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphMemAllocNodeGetParams, hipGraphMemAllocNodeGetParams, hipGraphMemAllocNodeGetParams_fn, node, pNodeParams)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphMemFreeNodeGetParams, hipGraphMemFreeNodeGetParams, hipGraphMemFreeNodeGetParams_fn, node, dev_ptr)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphMemcpyNodeGetParams, hipGraphMemcpyNodeGetParams, hipGraphMemcpyNodeGetParams_fn, node, pNodeParams)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphMemcpyNodeSetParams, hipGraphMemcpyNodeSetParams, hipGraphMemcpyNodeSetParams_fn, node, pNodeParams)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphMemcpyNodeSetParams1D, hipGraphMemcpyNodeSetParams1D, hipGraphMemcpyNodeSetParams1D_fn, node, dst, src, count, kind)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphMemcpyNodeSetParamsFromSymbol, hipGraphMemcpyNodeSetParamsFromSymbol, hipGraphMemcpyNodeSetParamsFromSymbol_fn, node, dst, symbol, count, offset, kind)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphMemcpyNodeSetParamsToSymbol, hipGraphMemcpyNodeSetParamsToSymbol, hipGraphMemcpyNodeSetParamsToSymbol_fn, node, symbol, src, count, offset, kind)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphMemsetNodeGetParams, hipGraphMemsetNodeGetParams, hipGraphMemsetNodeGetParams_fn, node, pNodeParams)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphMemsetNodeSetParams, hipGraphMemsetNodeSetParams, hipGraphMemsetNodeSetParams_fn, node, pNodeParams)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphNodeFindInClone, hipGraphNodeFindInClone, hipGraphNodeFindInClone_fn, pNode, originalNode, clonedGraph)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphNodeGetDependencies, hipGraphNodeGetDependencies, hipGraphNodeGetDependencies_fn, node, pDependencies, pNumDependencies)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphNodeGetDependentNodes, hipGraphNodeGetDependentNodes, hipGraphNodeGetDependentNodes_fn, node, pDependentNodes, pNumDependentNodes)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphNodeGetEnabled, hipGraphNodeGetEnabled, hipGraphNodeGetEnabled_fn, hGraphExec, hNode, isEnabled)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphNodeGetType, hipGraphNodeGetType, hipGraphNodeGetType_fn, node, pType)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphNodeSetEnabled, hipGraphNodeSetEnabled, hipGraphNodeSetEnabled_fn, hGraphExec, hNode, isEnabled)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphReleaseUserObject, hipGraphReleaseUserObject, hipGraphReleaseUserObject_fn, graph, object, count)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphRemoveDependencies, hipGraphRemoveDependencies, hipGraphRemoveDependencies_fn, graph, from, to, numDependencies)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphRetainUserObject, hipGraphRetainUserObject, hipGraphRetainUserObject_fn, graph, object, count, flags)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphUpload, hipGraphUpload, hipGraphUpload_fn, graphExec, stream)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphicsGLRegisterBuffer, hipGraphicsGLRegisterBuffer, hipGraphicsGLRegisterBuffer_fn, resource, buffer, flags)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphicsGLRegisterImage, hipGraphicsGLRegisterImage, hipGraphicsGLRegisterImage_fn, resource, image, target, flags)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphicsMapResources, hipGraphicsMapResources, hipGraphicsMapResources_fn, count, resources, stream)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphicsResourceGetMappedPointer, hipGraphicsResourceGetMappedPointer, hipGraphicsResourceGetMappedPointer_fn, devPtr, size, resource)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphicsSubResourceGetMappedArray, hipGraphicsSubResourceGetMappedArray, hipGraphicsSubResourceGetMappedArray_fn, array, resource, arrayIndex, mipLevel)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphicsUnmapResources, hipGraphicsUnmapResources, hipGraphicsUnmapResources_fn, count, resources, stream)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphicsUnregisterResource, hipGraphicsUnregisterResource, hipGraphicsUnregisterResource_fn, resource)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipHostAlloc, hipHostAlloc, hipHostAlloc_fn, ptr, size, flags)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipHostFree, hipHostFree, hipHostFree_fn, ptr)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipHostGetDevicePointer, hipHostGetDevicePointer, hipHostGetDevicePointer_fn, devPtr, hstPtr, flags)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipHostGetFlags, hipHostGetFlags, hipHostGetFlags_fn, flagsPtr, hostPtr)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipHostMalloc, hipHostMalloc, hipHostMalloc_fn, ptr, size, flags)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipHostRegister, hipHostRegister, hipHostRegister_fn, hostPtr, sizeBytes, flags)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipHostUnregister, hipHostUnregister, hipHostUnregister_fn, hostPtr)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipImportExternalMemory, hipImportExternalMemory, hipImportExternalMemory_fn, extMem_out, memHandleDesc)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipImportExternalSemaphore, hipImportExternalSemaphore, hipImportExternalSemaphore_fn, extSem_out, semHandleDesc)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipInit, hipInit, hipInit_fn, flags)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipIpcCloseMemHandle, hipIpcCloseMemHandle, hipIpcCloseMemHandle_fn, devPtr)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipIpcGetEventHandle, hipIpcGetEventHandle, hipIpcGetEventHandle_fn, handle, event)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipIpcGetMemHandle, hipIpcGetMemHandle, hipIpcGetMemHandle_fn, handle, devPtr)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipIpcOpenEventHandle, hipIpcOpenEventHandle, hipIpcOpenEventHandle_fn, event, handle)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipIpcOpenMemHandle, hipIpcOpenMemHandle, hipIpcOpenMemHandle_fn, devPtr, handle, flags)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipKernelNameRef, hipKernelNameRef, hipKernelNameRef_fn, func)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipKernelNameRefByPtr, hipKernelNameRefByPtr, hipKernelNameRefByPtr_fn, hostFunction, stream)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipLaunchByPtr, hipLaunchByPtr, hipLaunchByPtr_fn, func)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipLaunchCooperativeKernel, hipLaunchCooperativeKernel, hipLaunchCooperativeKernel_fn, func, gridDim, blockDimX, kernelParams, sharedMemBytes, stream)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipLaunchCooperativeKernelMultiDevice, hipLaunchCooperativeKernelMultiDevice, hipLaunchCooperativeKernelMultiDevice_fn, launchParamsList, numDevices, flags)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipLaunchHostFunc, hipLaunchHostFunc, hipLaunchHostFunc_fn, stream, fn, userData)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipLaunchKernel, hipLaunchKernel, hipLaunchKernel_fn, function_address, numBlocks, dimBlocks, args, sharedMemBytes, stream)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMalloc, hipMalloc, hipMalloc_fn, ptr, size)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMalloc3D, hipMalloc3D, hipMalloc3D_fn, pitchedDevPtr, extent)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMalloc3DArray, hipMalloc3DArray, hipMalloc3DArray_fn, array, desc, extent, flags)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMallocArray, hipMallocArray, hipMallocArray_fn, array, desc, width, height, flags)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMallocAsync, hipMallocAsync, hipMallocAsync_fn, dev_ptr, size, stream)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMallocFromPoolAsync, hipMallocFromPoolAsync, hipMallocFromPoolAsync_fn, dev_ptr, size, mem_pool, stream)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMallocHost, hipMallocHost, hipMallocHost_fn, ptr, size)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMallocManaged, hipMallocManaged, hipMallocManaged_fn, dev_ptr, size, flags)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMallocMipmappedArray, hipMallocMipmappedArray, hipMallocMipmappedArray_fn, mipmappedArray, desc, extent, numLevels, flags)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMallocPitch, hipMallocPitch, hipMallocPitch_fn, ptr, pitch, width, height)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemAddressFree, hipMemAddressFree, hipMemAddressFree_fn, devPtr, size)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemAddressReserve, hipMemAddressReserve, hipMemAddressReserve_fn, ptr, size, alignment, addr, flags)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemAdvise, hipMemAdvise, hipMemAdvise_fn, dev_ptr, count, advice, device)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemAllocHost, hipMemAllocHost, hipMemAllocHost_fn, ptr, size)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemAllocPitch, hipMemAllocPitch, hipMemAllocPitch_fn, dptr, pitch, widthInBytes, height, elementSizeBytes)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemCreate, hipMemCreate, hipMemCreate_fn, handle, size, prop, flags)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemExportToShareableHandle, hipMemExportToShareableHandle, hipMemExportToShareableHandle_fn, shareableHandle, handle, handleType, flags)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemGetAccess, hipMemGetAccess, hipMemGetAccess_fn, flags, location, ptr)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemGetAddressRange, hipMemGetAddressRange, hipMemGetAddressRange_fn, pbase, psize, dptr)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemGetAllocationGranularity, hipMemGetAllocationGranularity, hipMemGetAllocationGranularity_fn, granularity, prop, option)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemGetAllocationPropertiesFromHandle, hipMemGetAllocationPropertiesFromHandle, hipMemGetAllocationPropertiesFromHandle_fn, prop, handle)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemGetInfo, hipMemGetInfo, hipMemGetInfo_fn, free, total)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemImportFromShareableHandle, hipMemImportFromShareableHandle, hipMemImportFromShareableHandle_fn, handle, osHandle, shHandleType)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemMap, hipMemMap, hipMemMap_fn, ptr, size, offset, handle, flags)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemMapArrayAsync, hipMemMapArrayAsync, hipMemMapArrayAsync_fn, mapInfoList, count, stream)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemPoolCreate, hipMemPoolCreate, hipMemPoolCreate_fn, mem_pool, pool_props)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemPoolDestroy, hipMemPoolDestroy, hipMemPoolDestroy_fn, mem_pool)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemPoolExportPointer, hipMemPoolExportPointer, hipMemPoolExportPointer_fn, export_data, dev_ptr)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemPoolExportToShareableHandle, hipMemPoolExportToShareableHandle, hipMemPoolExportToShareableHandle_fn, shared_handle, mem_pool, handle_type, flags)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemPoolGetAccess, hipMemPoolGetAccess, hipMemPoolGetAccess_fn, flags, mem_pool, location)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemPoolGetAttribute, hipMemPoolGetAttribute, hipMemPoolGetAttribute_fn, mem_pool, attr, value)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemPoolImportFromShareableHandle, hipMemPoolImportFromShareableHandle, hipMemPoolImportFromShareableHandle_fn, mem_pool, shared_handle, handle_type, flags)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemPoolImportPointer, hipMemPoolImportPointer, hipMemPoolImportPointer_fn, dev_ptr, mem_pool, export_data)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemPoolSetAccess, hipMemPoolSetAccess, hipMemPoolSetAccess_fn, mem_pool, desc_list, count)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemPoolSetAttribute, hipMemPoolSetAttribute, hipMemPoolSetAttribute_fn, mem_pool, attr, value)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemPoolTrimTo, hipMemPoolTrimTo, hipMemPoolTrimTo_fn, mem_pool, min_bytes_to_hold)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemPrefetchAsync, hipMemPrefetchAsync, hipMemPrefetchAsync_fn, dev_ptr, count, device, stream)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemPtrGetInfo, hipMemPtrGetInfo, hipMemPtrGetInfo_fn, ptr, size)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemRangeGetAttribute, hipMemRangeGetAttribute, hipMemRangeGetAttribute_fn, data, data_size, attribute, dev_ptr, count)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemRangeGetAttributes, hipMemRangeGetAttributes, hipMemRangeGetAttributes_fn, data, data_sizes, attributes, num_attributes, dev_ptr, count)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemRelease, hipMemRelease, hipMemRelease_fn, handle)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemRetainAllocationHandle, hipMemRetainAllocationHandle, hipMemRetainAllocationHandle_fn, handle, addr)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemSetAccess, hipMemSetAccess, hipMemSetAccess_fn, ptr, size, desc, count)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemUnmap, hipMemUnmap, hipMemUnmap_fn, ptr, size)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemcpy, hipMemcpy, hipMemcpy_fn, dst, src, sizeBytes, kind)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemcpy2D, hipMemcpy2D, hipMemcpy2D_fn, dst, dpitch, src, spitch, width, height, kind)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemcpy2DAsync, hipMemcpy2DAsync, hipMemcpy2DAsync_fn, dst, dpitch, src, spitch, width, height, kind, stream)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemcpy2DFromArray, hipMemcpy2DFromArray, hipMemcpy2DFromArray_fn, dst, dpitch, src, wOffset, hOffset, width, height, kind)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemcpy2DFromArrayAsync, hipMemcpy2DFromArrayAsync, hipMemcpy2DFromArrayAsync_fn, dst, dpitch, src, wOffset, hOffset, width, height, kind, stream)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemcpy2DToArray, hipMemcpy2DToArray, hipMemcpy2DToArray_fn, dst, wOffset, hOffset, src, spitch, width, height, kind)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemcpy2DToArrayAsync, hipMemcpy2DToArrayAsync, hipMemcpy2DToArrayAsync_fn, dst, wOffset, hOffset, src, spitch, width, height, kind, stream)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemcpy3D, hipMemcpy3D, hipMemcpy3D_fn, p)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemcpy3DAsync, hipMemcpy3DAsync, hipMemcpy3DAsync_fn, p, stream)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemcpyAsync, hipMemcpyAsync, hipMemcpyAsync_fn, dst, src, sizeBytes, kind, stream)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemcpyAtoH, hipMemcpyAtoH, hipMemcpyAtoH_fn, dst, srcArray, srcOffset, count)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemcpyDtoD, hipMemcpyDtoD, hipMemcpyDtoD_fn, dst, src, sizeBytes)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemcpyDtoDAsync, hipMemcpyDtoDAsync, hipMemcpyDtoDAsync_fn, dst, src, sizeBytes, stream)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemcpyDtoH, hipMemcpyDtoH, hipMemcpyDtoH_fn, dst, src, sizeBytes)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemcpyDtoHAsync, hipMemcpyDtoHAsync, hipMemcpyDtoHAsync_fn, dst, src, sizeBytes, stream)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemcpyFromArray, hipMemcpyFromArray, hipMemcpyFromArray_fn, dst, srcArray, wOffset, hOffset, count, kind)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemcpyFromSymbol, hipMemcpyFromSymbol, hipMemcpyFromSymbol_fn, dst, symbol, sizeBytes, offset, kind)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemcpyFromSymbolAsync, hipMemcpyFromSymbolAsync, hipMemcpyFromSymbolAsync_fn, dst, symbol, sizeBytes, offset, kind, stream)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemcpyHtoA, hipMemcpyHtoA, hipMemcpyHtoA_fn, dstArray, dstOffset, srcHost, count)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemcpyHtoD, hipMemcpyHtoD, hipMemcpyHtoD_fn, dst, src, sizeBytes)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemcpyHtoDAsync, hipMemcpyHtoDAsync, hipMemcpyHtoDAsync_fn, dst, src, sizeBytes, stream)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemcpyParam2D, hipMemcpyParam2D, hipMemcpyParam2D_fn, pCopy)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemcpyParam2DAsync, hipMemcpyParam2DAsync, hipMemcpyParam2DAsync_fn, pCopy, stream)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemcpyPeer, hipMemcpyPeer, hipMemcpyPeer_fn, dst, dstDeviceId, src, srcDeviceId, sizeBytes)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemcpyPeerAsync, hipMemcpyPeerAsync, hipMemcpyPeerAsync_fn, dst, dstDeviceId, src, srcDevice, sizeBytes, stream)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemcpyToArray, hipMemcpyToArray, hipMemcpyToArray_fn, dst, wOffset, hOffset, src, count, kind)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemcpyToSymbol, hipMemcpyToSymbol, hipMemcpyToSymbol_fn, symbol, src, sizeBytes, offset, kind)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemcpyToSymbolAsync, hipMemcpyToSymbolAsync, hipMemcpyToSymbolAsync_fn, symbol, src, sizeBytes, offset, kind, stream)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemcpyWithStream, hipMemcpyWithStream, hipMemcpyWithStream_fn, dst, src, sizeBytes, kind, stream)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemset, hipMemset, hipMemset_fn, dst, value, sizeBytes)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemset2D, hipMemset2D, hipMemset2D_fn, dst, pitch, value, width, height)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemset2DAsync, hipMemset2DAsync, hipMemset2DAsync_fn, dst, pitch, value, width, height, stream)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemset3D, hipMemset3D, hipMemset3D_fn, pitchedDevPtr, value, extent)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemset3DAsync, hipMemset3DAsync, hipMemset3DAsync_fn, pitchedDevPtr, value, extent, stream)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemsetAsync, hipMemsetAsync, hipMemsetAsync_fn, dst, value, sizeBytes, stream)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemsetD16, hipMemsetD16, hipMemsetD16_fn, dest, value, count)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemsetD16Async, hipMemsetD16Async, hipMemsetD16Async_fn, dest, value, count, stream)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemsetD32, hipMemsetD32, hipMemsetD32_fn, dest, value, count)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemsetD32Async, hipMemsetD32Async, hipMemsetD32Async_fn, dst, value, count, stream)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemsetD8, hipMemsetD8, hipMemsetD8_fn, dest, value, count)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemsetD8Async, hipMemsetD8Async, hipMemsetD8Async_fn, dest, value, count, stream)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMipmappedArrayCreate, hipMipmappedArrayCreate, hipMipmappedArrayCreate_fn, pHandle, pMipmappedArrayDesc, numMipmapLevels)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMipmappedArrayDestroy, hipMipmappedArrayDestroy, hipMipmappedArrayDestroy_fn, hMipmappedArray)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMipmappedArrayGetLevel, hipMipmappedArrayGetLevel, hipMipmappedArrayGetLevel_fn, pLevelArray, hMipMappedArray, level)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipModuleGetFunction, hipModuleGetFunction, hipModuleGetFunction_fn, function, module, kname)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipModuleGetGlobal, hipModuleGetGlobal, hipModuleGetGlobal_fn, dptr, bytes, hmod, name)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipModuleGetTexRef, hipModuleGetTexRef, hipModuleGetTexRef_fn, texRef, hmod, name)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipModuleLaunchCooperativeKernel, hipModuleLaunchCooperativeKernel, hipModuleLaunchCooperativeKernel_fn, func, gridDimX, gridDimY, gridDimZ, blockDimX, blockDimY, blockDimZ, sharedMemBytes, stream, kernelParams)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipModuleLaunchCooperativeKernelMultiDevice, hipModuleLaunchCooperativeKernelMultiDevice, hipModuleLaunchCooperativeKernelMultiDevice_fn, launchParamsList, numDevices, flags)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipModuleLaunchKernel, hipModuleLaunchKernel, hipModuleLaunchKernel_fn, func, gridDimX, gridDimY, gridDimZ, blockDimX, blockDimY, blockDimZ, sharedMemBytes, stream, kernelParams, extra)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipModuleLoad, hipModuleLoad, hipModuleLoad_fn, module, fname)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipModuleLoadData, hipModuleLoadData, hipModuleLoadData_fn, module, image)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipModuleLoadDataEx, hipModuleLoadDataEx, hipModuleLoadDataEx_fn, module, image, numOptions, options, optionValues)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipModuleOccupancyMaxActiveBlocksPerMultiprocessor, hipModuleOccupancyMaxActiveBlocksPerMultiprocessor, hipModuleOccupancyMaxActiveBlocksPerMultiprocessor_fn, numBlocks, func, blockSize, dynSharedMemPerBlk)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipModuleOccupancyMaxActiveBlocksPerMultiprocessorWithFlags, hipModuleOccupancyMaxActiveBlocksPerMultiprocessorWithFlags, hipModuleOccupancyMaxActiveBlocksPerMultiprocessorWithFlags_fn, numBlocks, func, blockSize, dynSharedMemPerBlk, flags)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipModuleOccupancyMaxPotentialBlockSize, hipModuleOccupancyMaxPotentialBlockSize, hipModuleOccupancyMaxPotentialBlockSize_fn, gridSize, blockSize, func, dynSharedMemPerBlk, blockSizeLimit)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipModuleOccupancyMaxPotentialBlockSizeWithFlags, hipModuleOccupancyMaxPotentialBlockSizeWithFlags, hipModuleOccupancyMaxPotentialBlockSizeWithFlags_fn, gridSize, blockSize, func, dynSharedMemPerBlk, blockSizeLimit, flags)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipModuleUnload, hipModuleUnload, hipModuleUnload_fn, module)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipOccupancyMaxActiveBlocksPerMultiprocessor, hipOccupancyMaxActiveBlocksPerMultiprocessor, hipOccupancyMaxActiveBlocksPerMultiprocessor_fn, numBlocks, func, blockSize, dynSharedMemPerBlk)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipOccupancyMaxActiveBlocksPerMultiprocessorWithFlags, hipOccupancyMaxActiveBlocksPerMultiprocessorWithFlags, hipOccupancyMaxActiveBlocksPerMultiprocessorWithFlags_fn, numBlocks, func, blockSize, dynSharedMemPerBlk, flags)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipOccupancyMaxPotentialBlockSize, hipOccupancyMaxPotentialBlockSize, hipOccupancyMaxPotentialBlockSize_fn, gridSize, blockSize, func, dynSharedMemPerBlk, blockSizeLimit)
HIP_API_INFO_DEFINITION_0(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipPeekAtLastError, hipPeekAtLastError, hipPeekAtLastError_fn)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipPointerGetAttribute, hipPointerGetAttribute, hipPointerGetAttribute_fn, data, attribute, ptr)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipPointerGetAttributes, hipPointerGetAttributes, hipPointerGetAttributes_fn, attributes, ptr)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipPointerSetAttribute, hipPointerSetAttribute, hipPointerSetAttribute_fn, value, attribute, ptr)
HIP_API_INFO_DEFINITION_0(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipProfilerStart, hipProfilerStart, hipProfilerStart_fn)
HIP_API_INFO_DEFINITION_0(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipProfilerStop, hipProfilerStop, hipProfilerStop_fn)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipRuntimeGetVersion, hipRuntimeGetVersion, hipRuntimeGetVersion_fn, runtimeVersion)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipSetDevice, hipSetDevice, hipSetDevice_fn, deviceId)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipSetDeviceFlags, hipSetDeviceFlags, hipSetDeviceFlags_fn, flags)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipSetupArgument, hipSetupArgument, hipSetupArgument_fn, arg, size, offset)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipSignalExternalSemaphoresAsync, hipSignalExternalSemaphoresAsync, hipSignalExternalSemaphoresAsync_fn, extSemArray, paramsArray, numExtSems, stream)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipStreamAddCallback, hipStreamAddCallback, hipStreamAddCallback_fn, stream, callback, userData, flags)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipStreamAttachMemAsync, hipStreamAttachMemAsync, hipStreamAttachMemAsync_fn, stream, dev_ptr, length, flags)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipStreamBeginCapture, hipStreamBeginCapture, hipStreamBeginCapture_fn, stream, mode)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipStreamCreate, hipStreamCreate, hipStreamCreate_fn, stream)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipStreamCreateWithFlags, hipStreamCreateWithFlags, hipStreamCreateWithFlags_fn, stream, flags)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipStreamCreateWithPriority, hipStreamCreateWithPriority, hipStreamCreateWithPriority_fn, stream, flags, priority)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipStreamDestroy, hipStreamDestroy, hipStreamDestroy_fn, stream)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipStreamEndCapture, hipStreamEndCapture, hipStreamEndCapture_fn, stream, pGraph)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipStreamGetCaptureInfo, hipStreamGetCaptureInfo, hipStreamGetCaptureInfo_fn, stream, pCaptureStatus, pId)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipStreamGetCaptureInfo_v2, hipStreamGetCaptureInfo_v2, hipStreamGetCaptureInfo_v2_fn, stream, captureStatus_out, id_out, graph_out, dependencies_out, numDependencies_out)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipStreamGetDevice, hipStreamGetDevice, hipStreamGetDevice_fn, stream, device)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipStreamGetFlags, hipStreamGetFlags, hipStreamGetFlags_fn, stream, flags)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipStreamGetPriority, hipStreamGetPriority, hipStreamGetPriority_fn, stream, priority)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipStreamIsCapturing, hipStreamIsCapturing, hipStreamIsCapturing_fn, stream, pCaptureStatus)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipStreamQuery, hipStreamQuery, hipStreamQuery_fn, stream)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipStreamSynchronize, hipStreamSynchronize, hipStreamSynchronize_fn, stream)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipStreamUpdateCaptureDependencies, hipStreamUpdateCaptureDependencies, hipStreamUpdateCaptureDependencies_fn, stream, dependencies, numDependencies, flags)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipStreamWaitEvent, hipStreamWaitEvent, hipStreamWaitEvent_fn, stream, event, flags)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipStreamWaitValue32, hipStreamWaitValue32, hipStreamWaitValue32_fn, stream, ptr, value, flags, mask)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipStreamWaitValue64, hipStreamWaitValue64, hipStreamWaitValue64_fn, stream, ptr, value, flags, mask)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipStreamWriteValue32, hipStreamWriteValue32, hipStreamWriteValue32_fn, stream, ptr, value, flags)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipStreamWriteValue64, hipStreamWriteValue64, hipStreamWriteValue64_fn, stream, ptr, value, flags)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipTexObjectCreate, hipTexObjectCreate, hipTexObjectCreate_fn, pTexObject, pResDesc, pTexDesc, pResViewDesc)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipTexObjectDestroy, hipTexObjectDestroy, hipTexObjectDestroy_fn, texObject)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipTexObjectGetResourceDesc, hipTexObjectGetResourceDesc, hipTexObjectGetResourceDesc_fn, pResDesc, texObject)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipTexObjectGetResourceViewDesc, hipTexObjectGetResourceViewDesc, hipTexObjectGetResourceViewDesc_fn, pResViewDesc, texObject)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipTexObjectGetTextureDesc, hipTexObjectGetTextureDesc, hipTexObjectGetTextureDesc_fn, pTexDesc, texObject)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipTexRefGetAddress, hipTexRefGetAddress, hipTexRefGetAddress_fn, dev_ptr, texRef)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipTexRefGetAddressMode, hipTexRefGetAddressMode, hipTexRefGetAddressMode_fn, pam, texRef, dim)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipTexRefGetFilterMode, hipTexRefGetFilterMode, hipTexRefGetFilterMode_fn, pfm, texRef)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipTexRefGetFlags, hipTexRefGetFlags, hipTexRefGetFlags_fn, pFlags, texRef)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipTexRefGetFormat, hipTexRefGetFormat, hipTexRefGetFormat_fn, pFormat, pNumChannels, texRef)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipTexRefGetMaxAnisotropy, hipTexRefGetMaxAnisotropy, hipTexRefGetMaxAnisotropy_fn, pmaxAnsio, texRef)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipTexRefGetMipMappedArray, hipTexRefGetMipMappedArray, hipTexRefGetMipMappedArray_fn, pArray, texRef)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipTexRefGetMipmapFilterMode, hipTexRefGetMipmapFilterMode, hipTexRefGetMipmapFilterMode_fn, pfm, texRef)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipTexRefGetMipmapLevelBias, hipTexRefGetMipmapLevelBias, hipTexRefGetMipmapLevelBias_fn, pbias, texRef)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipTexRefGetMipmapLevelClamp, hipTexRefGetMipmapLevelClamp, hipTexRefGetMipmapLevelClamp_fn, pminMipmapLevelClamp, pmaxMipmapLevelClamp, texRef)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipTexRefSetAddress, hipTexRefSetAddress, hipTexRefSetAddress_fn, ByteOffset, texRef, dptr, bytes)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipTexRefSetAddress2D, hipTexRefSetAddress2D, hipTexRefSetAddress2D_fn, texRef, desc, dptr, Pitch)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipTexRefSetAddressMode, hipTexRefSetAddressMode, hipTexRefSetAddressMode_fn, texRef, dim, am)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipTexRefSetArray, hipTexRefSetArray, hipTexRefSetArray_fn, tex, array, flags)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipTexRefSetBorderColor, hipTexRefSetBorderColor, hipTexRefSetBorderColor_fn, texRef, pBorderColor)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipTexRefSetFilterMode, hipTexRefSetFilterMode, hipTexRefSetFilterMode_fn, texRef, fm)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipTexRefSetFlags, hipTexRefSetFlags, hipTexRefSetFlags_fn, texRef, Flags)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipTexRefSetFormat, hipTexRefSetFormat, hipTexRefSetFormat_fn, texRef, fmt, NumPackedComponents)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipTexRefSetMaxAnisotropy, hipTexRefSetMaxAnisotropy, hipTexRefSetMaxAnisotropy_fn, texRef, maxAniso)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipTexRefSetMipmapFilterMode, hipTexRefSetMipmapFilterMode, hipTexRefSetMipmapFilterMode_fn, texRef, fm)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipTexRefSetMipmapLevelBias, hipTexRefSetMipmapLevelBias, hipTexRefSetMipmapLevelBias_fn, texRef, bias)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipTexRefSetMipmapLevelClamp, hipTexRefSetMipmapLevelClamp, hipTexRefSetMipmapLevelClamp_fn, texRef, minMipMapLevelClamp, maxMipMapLevelClamp)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipTexRefSetMipmappedArray, hipTexRefSetMipmappedArray, hipTexRefSetMipmappedArray_fn, texRef, mipmappedArray, Flags)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipThreadExchangeStreamCaptureMode, hipThreadExchangeStreamCaptureMode, hipThreadExchangeStreamCaptureMode_fn, mode)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipUnbindTexture, hipUnbindTexture, hipUnbindTexture_fn, tex)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipUserObjectCreate, hipUserObjectCreate, hipUserObjectCreate_fn, object_out, ptr, destroy, initialRefcount, flags)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipUserObjectRelease, hipUserObjectRelease, hipUserObjectRelease_fn, object, count)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipUserObjectRetain, hipUserObjectRetain, hipUserObjectRetain_fn, object, count)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipWaitExternalSemaphoresAsync, hipWaitExternalSemaphoresAsync, hipWaitExternalSemaphoresAsync_fn, extSemArray, paramsArray, numExtSems, stream)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipCreateChannelDesc, hipCreateChannelDesc, hipCreateChannelDesc_fn, x, y, z, w, f)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipExtModuleLaunchKernel, hipExtModuleLaunchKernel, hipExtModuleLaunchKernel_fn, func, globalWorkSizeX, globalWorkSizeY, globalWorkSizeZ, localWorkSizeX, localWorkSizeY, localWorkSizeZ, sharedMemBytes, stream, kernelParams, extra, startEvent, stopEvent, flags)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipHccModuleLaunchKernel, hipHccModuleLaunchKernel, hipHccModuleLaunchKernel_fn, func, globalWorkSizeX, globalWorkSizeY, globalWorkSizeZ, localWorkSizeX, localWorkSizeY, localWorkSizeZ, sharedMemBytes, stream, kernelParams, extra, startEvent, stopEvent)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemcpy_spt, hipMemcpy_spt, hipMemcpy_spt_fn, dst, src, sizeBytes, kind)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemcpyToSymbol_spt, hipMemcpyToSymbol_spt, hipMemcpyToSymbol_spt_fn, symbol, src, sizeBytes, offset, kind)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemcpyFromSymbol_spt, hipMemcpyFromSymbol_spt, hipMemcpyFromSymbol_spt_fn, dst, symbol, sizeBytes, offset, kind)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemcpy2D_spt, hipMemcpy2D_spt, hipMemcpy2D_spt_fn, dst, dpitch, src, spitch, width, height, kind)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemcpy2DFromArray_spt, hipMemcpy2DFromArray_spt, hipMemcpy2DFromArray_spt_fn, dst, dpitch, src, wOffset, hOffset, width, height, kind)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemcpy3D_spt, hipMemcpy3D_spt, hipMemcpy3D_spt_fn, p)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemset_spt, hipMemset_spt, hipMemset_spt_fn, dst, value, sizeBytes)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemsetAsync_spt, hipMemsetAsync_spt, hipMemsetAsync_spt_fn, dst, value, sizeBytes, stream)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemset2D_spt, hipMemset2D_spt, hipMemset2D_spt_fn, dst, pitch, value, width, height)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemset2DAsync_spt, hipMemset2DAsync_spt, hipMemset2DAsync_spt_fn, dst, pitch, value, width, height, stream)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemset3DAsync_spt, hipMemset3DAsync_spt, hipMemset3DAsync_spt_fn, pitchedDevPtr, value, extent, stream)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemset3D_spt, hipMemset3D_spt, hipMemset3D_spt_fn, pitchedDevPtr, value, extent)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemcpyAsync_spt, hipMemcpyAsync_spt, hipMemcpyAsync_spt_fn, dst, src, sizeBytes, kind, stream)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemcpy3DAsync_spt, hipMemcpy3DAsync_spt, hipMemcpy3DAsync_spt_fn, p, stream)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemcpy2DAsync_spt, hipMemcpy2DAsync_spt, hipMemcpy2DAsync_spt_fn, dst, dpitch, src, spitch, width, height, kind, stream)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemcpyFromSymbolAsync_spt, hipMemcpyFromSymbolAsync_spt, hipMemcpyFromSymbolAsync_spt_fn, dst, symbol, sizeBytes, offset, kind, stream)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemcpyToSymbolAsync_spt, hipMemcpyToSymbolAsync_spt, hipMemcpyToSymbolAsync_spt_fn, symbol, src, sizeBytes, offset, kind, stream)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemcpyFromArray_spt, hipMemcpyFromArray_spt, hipMemcpyFromArray_spt_fn, dst, src, wOffsetSrc, hOffset, count, kind)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemcpy2DToArray_spt, hipMemcpy2DToArray_spt, hipMemcpy2DToArray_spt_fn, dst, wOffset, hOffset, src, spitch, width, height, kind)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemcpy2DFromArrayAsync_spt, hipMemcpy2DFromArrayAsync_spt, hipMemcpy2DFromArrayAsync_spt_fn, dst, dpitch, src, wOffsetSrc, hOffsetSrc, width, height, kind, stream)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemcpy2DToArrayAsync_spt, hipMemcpy2DToArrayAsync_spt, hipMemcpy2DToArrayAsync_spt_fn, dst, wOffset, hOffset, src, spitch, width, height, kind, stream)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipStreamQuery_spt, hipStreamQuery_spt, hipStreamQuery_spt_fn, stream)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipStreamSynchronize_spt, hipStreamSynchronize_spt, hipStreamSynchronize_spt_fn, stream)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipStreamGetPriority_spt, hipStreamGetPriority_spt, hipStreamGetPriority_spt_fn, stream, priority)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipStreamWaitEvent_spt, hipStreamWaitEvent_spt, hipStreamWaitEvent_spt_fn, stream, event, flags)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipStreamGetFlags_spt, hipStreamGetFlags_spt, hipStreamGetFlags_spt_fn, stream, flags)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipStreamAddCallback_spt, hipStreamAddCallback_spt, hipStreamAddCallback_spt_fn, stream, callback, userData, flags)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipEventRecord_spt, hipEventRecord_spt, hipEventRecord_spt_fn, event, stream)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipLaunchCooperativeKernel_spt, hipLaunchCooperativeKernel_spt, hipLaunchCooperativeKernel_spt_fn, func, gridDim, blockDim, kernelParams, sharedMemBytes, stream)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipLaunchKernel_spt, hipLaunchKernel_spt, hipLaunchKernel_spt_fn, function_address, numBlocks, dimBlocks, args, sharedMemBytes, stream)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphLaunch_spt, hipGraphLaunch_spt, hipGraphLaunch_spt_fn, graphExec, stream)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipStreamBeginCapture_spt, hipStreamBeginCapture_spt, hipStreamBeginCapture_spt_fn, stream, mode)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipStreamEndCapture_spt, hipStreamEndCapture_spt, hipStreamEndCapture_spt_fn, stream, pGraph)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipStreamIsCapturing_spt, hipStreamIsCapturing_spt, hipStreamIsCapturing_spt_fn, stream, pCaptureStatus)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipStreamGetCaptureInfo_spt, hipStreamGetCaptureInfo_spt, hipStreamGetCaptureInfo_spt_fn, stream, pCaptureStatus, pId)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipStreamGetCaptureInfo_v2_spt, hipStreamGetCaptureInfo_v2_spt, hipStreamGetCaptureInfo_v2_spt_fn, stream, captureStatus_out, id_out, graph_out, dependencies_out, numDependencies_out)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipLaunchHostFunc_spt, hipLaunchHostFunc_spt, hipLaunchHostFunc_spt_fn, stream, fn, userData)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGetStreamDeviceId, hipGetStreamDeviceId, hipGetStreamDeviceId_fn, stream)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipDrvGraphAddMemsetNode, hipDrvGraphAddMemsetNode, hipDrvGraphAddMemsetNode_fn, phGraphNode, hGraph, dependencies, numDependencies, memsetParams, ctx)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphAddExternalSemaphoresWaitNode, hipGraphAddExternalSemaphoresWaitNode, hipGraphAddExternalSemaphoresWaitNode_fn, pGraphNode, graph, pDependencies, numDependencies, nodeParams)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphAddExternalSemaphoresSignalNode, hipGraphAddExternalSemaphoresSignalNode, hipGraphAddExternalSemaphoresSignalNode_fn, pGraphNode, graph, pDependencies, numDependencies, nodeParams)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphExternalSemaphoresSignalNodeSetParams, hipGraphExternalSemaphoresSignalNodeSetParams, hipGraphExternalSemaphoresSignalNodeSetParams_fn, hNode, nodeParams)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphExternalSemaphoresWaitNodeSetParams, hipGraphExternalSemaphoresWaitNodeSetParams, hipGraphExternalSemaphoresWaitNodeSetParams_fn, hNode, nodeParams)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphExternalSemaphoresSignalNodeGetParams, hipGraphExternalSemaphoresSignalNodeGetParams, hipGraphExternalSemaphoresSignalNodeGetParams_fn, hNode, params_out)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphExternalSemaphoresWaitNodeGetParams, hipGraphExternalSemaphoresWaitNodeGetParams, hipGraphExternalSemaphoresWaitNodeGetParams_fn, hNode, params_out)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphExecExternalSemaphoresSignalNodeSetParams, hipGraphExecExternalSemaphoresSignalNodeSetParams, hipGraphExecExternalSemaphoresSignalNodeSetParams_fn, hGraphExec, hNode, nodeParams)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphExecExternalSemaphoresWaitNodeSetParams, hipGraphExecExternalSemaphoresWaitNodeSetParams, hipGraphExecExternalSemaphoresWaitNodeSetParams_fn, hGraphExec, hNode, nodeParams)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphAddNode, hipGraphAddNode, hipGraphAddNode_fn, pGraphNode, graph, pDependencies, numDependencies, nodeParams)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphInstantiateWithParams, hipGraphInstantiateWithParams, hipGraphInstantiateWithParams_fn, pGraphExec, graph, instantiateParams)
HIP_API_INFO_DEFINITION_0(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipExtGetLastError, hipExtGetLastError, hipExtGetLastError_fn)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipTexRefGetBorderColor, hipTexRefGetBorderColor, hipTexRefGetBorderColor_fn, pBorderColor, texRef)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipTexRefGetArray, hipTexRefGetArray, hipTexRefGetArray_fn, pArray, texRef)

#if HIP_RUNTIME_API_TABLE_STEP_VERSION >= 1
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGetProcAddress, hipGetProcAddress, hipGetProcAddress_fn, symbol, pfn, hipVersion, flags, symbolStatus)
#endif

#if HIP_RUNTIME_API_TABLE_STEP_VERSION >= 2
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipStreamBeginCaptureToGraph, hipStreamBeginCaptureToGraph, hipStreamBeginCaptureToGraph_fn, stream, graph, dependencies, dependencyData, numDependencies, mode)
#endif

#if HIP_RUNTIME_API_TABLE_STEP_VERSION >= 3
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGetFuncBySymbol, hipGetFuncBySymbol, hipGetFuncBySymbol_fn, functionPtr, symbolPtr)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipSetValidDevices, hipSetValidDevices, hipSetValidDevices_fn, device_arr, len)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemcpyAtoD, hipMemcpyAtoD, hipMemcpyAtoD_fn, dstDevice, srcArray, srcOffset, ByteCount)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemcpyDtoA, hipMemcpyDtoA, hipMemcpyDtoA_fn, dstArray, dstOffset, srcDevice, ByteCount)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemcpyAtoA, hipMemcpyAtoA, hipMemcpyAtoA_fn, dstArray, dstOffset, srcArray, srcOffset, ByteCount)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemcpyAtoHAsync, hipMemcpyAtoHAsync, hipMemcpyAtoHAsync_fn, dstHost, srcArray, srcOffset, ByteCount, stream)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemcpyHtoAAsync, hipMemcpyHtoAAsync, hipMemcpyHtoAAsync_fn, dstArray, dstOffset, srcHost, ByteCount, stream)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemcpy2DArrayToArray, hipMemcpy2DArrayToArray, hipMemcpy2DArrayToArray_fn, dst, wOffsetDst, hOffsetDst, src, wOffsetSrc, hOffsetSrc, width, height, kind)
#endif

#if HIP_RUNTIME_API_TABLE_STEP_VERSION >= 4
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipDrvGraphAddMemFreeNode, hipDrvGraphAddMemFreeNode, hipDrvGraphAddMemFreeNode_fn, phGraphNode, hGraph, dependencies, numDependencies, dptr)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipDrvGraphExecMemcpyNodeSetParams, hipDrvGraphExecMemcpyNodeSetParams, hipDrvGraphExecMemcpyNodeSetParams_fn, hGraphExec, hNode, copyParams, ctx)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipDrvGraphExecMemsetNodeSetParams, hipDrvGraphExecMemsetNodeSetParams, hipDrvGraphExecMemsetNodeSetParams_fn, hGraphExec, hNode, memsetParams, ctx)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphExecGetFlags, hipGraphExecGetFlags, hipGraphExecGetFlags_fn, graphExec, flags)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphNodeSetParams, hipGraphNodeSetParams, hipGraphNodeSetParams_fn, node, nodeParams)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphExecNodeSetParams, hipGraphExecNodeSetParams, hipGraphExecNodeSetParams_fn, graphExec, node, nodeParams)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipExternalMemoryGetMappedMipmappedArray, hipExternalMemoryGetMappedMipmappedArray, hipExternalMemoryGetMappedMipmappedArray_fn, mipmap, extMem, mipmapDesc)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipDrvGraphMemcpyNodeGetParams, hipDrvGraphMemcpyNodeGetParams, hipDrvGraphMemcpyNodeGetParams_fn, hNode, nodeParams)
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipDrvGraphMemcpyNodeSetParams, hipDrvGraphMemcpyNodeSetParams, hipDrvGraphMemcpyNodeSetParams_fn, hNode, nodeParams)
#endif

#if HIP_RUNTIME_API_TABLE_STEP_VERSION >= 5
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipExtHostAlloc, hipExtHostAlloc, hipExtHostAlloc_fn, ptr, size, flags)
#endif

#if HIP_RUNTIME_API_TABLE_STEP_VERSION >= 6
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipDeviceGetTexture1DLinearMaxWidth, hipDeviceGetTexture1DLinearMaxWidth, hipDeviceGetTexture1DLinearMaxWidth_fn, maxWidthInElements, fmtDesc, device)
#endif

#if HIP_RUNTIME_API_TABLE_STEP_VERSION >= 7
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipStreamBatchMemOp, hipStreamBatchMemOp, hipStreamBatchMemOp_fn, stream, count, paramArray, flags);
#endif

#if HIP_RUNTIME_API_TABLE_STEP_VERSION >= 8
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphAddBatchMemOpNode, hipGraphAddBatchMemOpNode, hipGraphAddBatchMemOpNode_fn, phGraphNode, hGraph, dependencies, numDependencies, nodeParams);
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphBatchMemOpNodeGetParams, hipGraphBatchMemOpNodeGetParams, hipGraphBatchMemOpNodeGetParams_fn, hNode, nodeParams_out);
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphBatchMemOpNodeSetParams, hipGraphBatchMemOpNodeSetParams, hipGraphBatchMemOpNodeSetParams_fn, hNode, nodeParams);
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGraphExecBatchMemOpNodeSetParams, hipGraphExecBatchMemOpNodeSetParams, hipGraphExecBatchMemOpNodeSetParams_fn, hGraphExec, hNode, nodeParams);
#endif

#if HIP_RUNTIME_API_TABLE_STEP_VERSION >= 9
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipLinkAddData, hipLinkAddData, hipLinkAddData_fn, state, type, data, size, name, numOptions, options, optionValues);
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipLinkAddFile, hipLinkAddFile, hipLinkAddFile_fn, state, type, path, numOptions, options, optionValues);
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipLinkComplete, hipLinkComplete, hipLinkComplete_fn, state, hipBinOut, sizeOut);
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipLinkCreate, hipLinkCreate, hipLinkCreate_fn,  numOptions, options, optionValues, stateOut);
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipLinkDestroy, hipLinkDestroy, hipLinkDestroy_fn, state);
#endif

#if HIP_RUNTIME_API_TABLE_STEP_VERSION >= 10
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipEventRecordWithFlags, hipEventRecordWithFlags, hipEventRecordWithFlags_fn, event, stream, flags);
#endif

#if HIP_RUNTIME_API_TABLE_STEP_VERSION >= 11
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipLaunchKernelExC, hipLaunchKernelExC, hipLaunchKernelExC_fn, config, fPtr, args);
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipDrvLaunchKernelEx, hipDrvLaunchKernelEx, hipDrvLaunchKernelEx_fn, config, f, params, extra);
#endif

#if HIP_RUNTIME_API_TABLE_STEP_VERSION >= 12
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemGetHandleForAddressRange, hipMemGetHandleForAddressRange, hipMemGetHandleForAddressRange_fn, handle, dptr, size, handleType, flags);
#endif

#if HIP_RUNTIME_API_TABLE_STEP_VERSION >= 14
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipModuleGetFunctionCount, hipModuleGetFunctionCount, hipModuleGetFunctionCount_fn, count, mod);
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemsetD2D8, hipMemsetD2D8, hipMemsetD2D8_fn, dst, dstPitch, value, width, height);
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemsetD2D8Async, hipMemsetD2D8Async, hipMemsetD2D8Async_fn, dst, dstPitch, value, width, height, stream);
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemsetD2D16, hipMemsetD2D16, hipMemsetD2D16_fn, dst, dstPitch, value, width, height);
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemsetD2D16Async, hipMemsetD2D16Async, hipMemsetD2D16Async_fn, dst, dstPitch, value, width, height, stream);
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemsetD2D32, hipMemsetD2D32, hipMemsetD2D32_fn, dst, dstPitch, value, width, height);
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemsetD2D32Async, hipMemsetD2D32Async, hipMemsetD2D32Async_fn, dst, dstPitch, value, width, height, stream);
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipStreamGetAttribute, hipStreamGetAttribute, hipStreamGetAttribute_fn, stream, attr, value_out);
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipStreamSetAttribute, hipStreamSetAttribute, hipStreamSetAttribute_fn, stream, attr, value);
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipModuleLoadFatBinary, hipModuleLoadFatBinary, hipModuleLoadFatBinary_fn, module, fatbin);
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemcpyBatchAsync, hipMemcpyBatchAsync, hipMemcpyBatchAsync_fn, dsts, srcs, sizes, attrs, attrsIdxs, numAttrs, failIdx, stream);
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemcpy3DBatchAsync, hipMemcpy3DBatchAsync, hipMemcpy3DBatchAsync_fn, numOps, opList, failIdx, flags, stream);
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemcpy3DPeer, hipMemcpy3DPeer, hipMemcpy3DPeer_fn, p);
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemcpy3DPeerAsync, hipMemcpy3DPeerAsync, hipMemcpy3DPeerAsync_fn, p, stream);
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGetDriverEntryPoint, hipGetDriverEntryPoint, hipGetDriverEntryPoint_fn, symbol, funcPtr, flags, driverStatus);
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipGetDriverEntryPoint_spt, hipGetDriverEntryPoint_spt, hipGetDriverEntryPoint_spt_fn, symbol, funcPtr, flags, driverStatus);
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemPrefetchAsync_v2, hipMemPrefetchAsync_v2, hipMemPrefetchAsync_v2_fn, dev_ptr, count, location, flags, stream);
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipMemAdvise_v2, hipMemAdvise_v2, hipMemAdvise_v2_fn, dev_ptr, count, advice, location);
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipStreamGetId, hipStreamGetId, hipStreamGetId_fn, stream, streamId);
#endif

#if HIP_RUNTIME_API_TABLE_STEP_VERSION >= 15
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipLibraryLoadData, hipLibraryLoadData, hipLibraryLoadData_fn, library, code, jitOptions, jitOptionsValues, numJitOptions, libraryOptions, libraryOptionValues, numLibraryOptions);
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipLibraryLoadFromFile, hipLibraryLoadFromFile, hipLibraryLoadFromFile_fn, library, fileName, jitOptions, jitOptionsValues, numJitOptions, libraryOptions, libraryOptionValues, numLibraryOptions);
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipLibraryUnload, hipLibraryUnload, hipLibraryUnload_fn, library);
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipLibraryGetKernel, hipLibraryGetKernel, hipLibraryGetKernel_fn, pKernel, library, name);
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipLibraryGetKernelCount, hipLibraryGetKernelCount, hipLibraryGetKernelCount_fn, count, library);
#endif

#if HIP_RUNTIME_API_TABLE_STEP_VERSION >= 16
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipStreamCopyAttributes, hipStreamCopyAttributes, hipStreamCopyAttributes_fn, dst, src);
#endif

#if HIP_RUNTIME_API_TABLE_STEP_VERSION >= 17
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipLibraryEnumerateKernels, hipLibraryEnumerateKernels, hipLibraryEnumerateKernels_fn, kernels, numKernels, library);
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipKernelGetLibrary, hipKernelGetLibrary, hipKernelGetLibrary_fn, library, kernel);
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipKernelGetName, hipKernelGetName, hipKernelGetName_fn, name, kernel);
#endif

#if HIP_RUNTIME_API_TABLE_STEP_VERSION >= 18
HIP_API_INFO_DEFINITION_V(ROCPROFILER_HIP_TABLE_ID_Runtime, ROCPROFILER_HIP_RUNTIME_API_ID_hipOccupancyAvailableDynamicSMemPerBlock, hipOccupancyAvailableDynamicSMemPerBlock, hipOccupancyAvailableDynamicSMemPerBlock_fn, dynamicSmemSize, f, numBlocks, blockSize);
#endif
// clang-format on

#else
#    error "Do not compile this file directly. It is included by lib/rocprofiler-sdk/hip/hip.cpp"
#endif
