// Copyright © 2023-2025 Advanced Micro Devices, Inc.
// SPDX-License-Identifier: MIT

#include "../shim.attn_fwd.h"
#include <aotriton/_internal/triton_kernel.h>
#include <aotriton/_internal/kernel_cluster.h>
#include <aotriton/cpp_tune.h>
#include <string_view>
#ifndef NDEBUG
#include <iostream>
#endif

#define CURRENT_ENTRY_PUBLIC Autotune_attn_fwd__A4__F62

#define ARRAY_SIZE(array)  (sizeof(array) / sizeof(array[0]))

namespace { // Anonymous namespace

using namespace std::literals::string_view_literals;

#if AOTRITON_BUILD_FOR_TUNING
// PSels and Copts in JSON String
static const char* kernel_psels[] = {
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 16, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 16, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 16, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 16, "BLOCK_N": 16, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 16, "BLOCK_N": 16, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 16, "BLOCK_N": 16, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw"
};
static const char* kernel_copts[] = {
  R"xyzw({"waves_per_eu": 1, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 4, "num_stages": 1})xyzw"
};
#endif

struct PerfFields {
  int16_t BLOCK_M;
    int16_t BLOCK_N;
    int8_t  PERSISTENT_TYPE;
    int8_t  GRID_CU_MULTIP;
    bool    PRE_LOAD_V;
};

static PerfFields image_perf_list [] = {
    { .BLOCK_M = 16, .BLOCK_N = 16, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 16, .BLOCK_N = 16, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 16, .BLOCK_N = 16, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 16, .BLOCK_N = 16, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 16, .BLOCK_N = 16, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 16, .BLOCK_N = 16, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 64, .BLOCK_N = 32, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 64, .BLOCK_N = 32, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false }
};

// u8R generates char8_t which is poorly supported almost everywhere.
constexpr pstring_view PACKAGE_PATH
#if defined(_WIN32)
{ LR"xyzw(amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_64_T_T_3_0___gfx11xx)xyzw" };
#else
{ R"xyzw(amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_64_T_T_3_0___gfx11xx)xyzw" };
#endif
constexpr std::string_view FUNC_NAME { R"xyzw(＊fp16@16_64_T_T_3_0)xyzw" };
constexpr std::string_view ARCH_NAME { R"xyzw(gfx1103)xyzw" };

// Checksum can be confirmed with `echo -n '<string>' | b2sum -l 64`
// For example:
//   $ echo -n 'amd-gfx110x/flash/attn_fwd/FONLY__^bf16@16,128,False,False,0,0___gfx1100__P__32_32_0_2_False__CO__wave3_warp2_stg1-Gpu-gfx1100' | b2sum -l 64
//   c4b51ee645d79580  -
static AOTRITON_NS::TritonKernelCompactMeta meta_list[] = {
    { 0x621177ffu, 0x0678e618u, 334, 83 }, // 621177ff0678e618 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_64_T_T_3_0___gfx11xx__P__2_2_16_16_False__CO__wave1_warp2_stg1--Arch_gfx1103
    { 0x03484c5bu, 0xfb41aa6au, 334, 33 }, // 03484c5bfb41aa6a = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_64_T_T_3_0___gfx11xx__P__2_2_16_16_False__CO__wave3_warp2_stg1--Arch_gfx1103
    { 0x9d1ecfb4u, 0xc0c08765u, 334, 50 }, // 9d1ecfb4c0c08765 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_64_T_T_3_0___gfx11xx__P__2_2_16_16_False__CO__wave4_warp2_stg1--Arch_gfx1103
    { 0xdadb85b0u, 0xa146245bu, 471, 83 }, // dadb85b0a146245b = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_64_T_T_3_0___gfx11xx__P__2_2_16_16_True__CO__wave1_warp2_stg1--Arch_gfx1103
    { 0x527eb92du, 0x5106b9dfu, 471, 16 }, // 527eb92d5106b9df = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_64_T_T_3_0___gfx11xx__P__2_2_16_16_True__CO__wave2_warp2_stg1--Arch_gfx1103
    { 0xc553aa9bu, 0xc962b9b1u, 471, 50 }, // c553aa9bc962b9b1 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_64_T_T_3_0___gfx11xx__P__2_2_16_16_True__CO__wave4_warp2_stg1--Arch_gfx1103
    { 0x5b27e6ddu, 0x031bceb2u, 219, 83 }, // 5b27e6dd031bceb2 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_64_T_T_3_0___gfx11xx__P__2_2_32_16_False__CO__wave1_warp2_stg1--Arch_gfx1103
    { 0x66bbadddu, 0xf2d6bc8bu, 219, 202 }, // 66bbadddf2d6bc8b = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_64_T_T_3_0___gfx11xx__P__2_2_32_16_False__CO__wave1_warp4_stg1--Arch_gfx1103
    { 0xde9b190bu, 0x3aac7669u, 219, 16 }, // de9b190b3aac7669 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_64_T_T_3_0___gfx11xx__P__2_2_32_16_False__CO__wave2_warp2_stg1--Arch_gfx1103
    { 0x745a9b3cu, 0x25dfd762u, 219, 116 }, // 745a9b3c25dfd762 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_64_T_T_3_0___gfx11xx__P__2_2_32_16_False__CO__wave2_warp4_stg1--Arch_gfx1103
    { 0xf774c159u, 0x87f5ed8fu, 219, 33 }, // f774c15987f5ed8f = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_64_T_T_3_0___gfx11xx__P__2_2_32_16_False__CO__wave3_warp2_stg1--Arch_gfx1103
    { 0x3a84ebaeu, 0xcb539c71u, 219, 167 }, // 3a84ebaecb539c71 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_64_T_T_3_0___gfx11xx__P__2_2_32_16_False__CO__wave3_warp4_stg1--Arch_gfx1103
    { 0xaad32624u, 0x6d678ec1u, 219, 133 }, // aad326246d678ec1 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_64_T_T_3_0___gfx11xx__P__2_2_32_16_False__CO__wave4_warp4_stg1--Arch_gfx1103
    { 0xe44a6b06u, 0x5c9f77a8u, 411, 83 }, // e44a6b065c9f77a8 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_64_T_T_3_0___gfx11xx__P__2_2_32_16_True__CO__wave1_warp2_stg1--Arch_gfx1103
    { 0x3360ddf9u, 0x3206d14cu, 411, 202 }, // 3360ddf93206d14c = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_64_T_T_3_0___gfx11xx__P__2_2_32_16_True__CO__wave1_warp4_stg1--Arch_gfx1103
    { 0x7d620f09u, 0xe9fb3bc2u, 411, 16 }, // 7d620f09e9fb3bc2 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_64_T_T_3_0___gfx11xx__P__2_2_32_16_True__CO__wave2_warp2_stg1--Arch_gfx1103
    { 0xdc3089b7u, 0xc3cb0803u, 411, 116 }, // dc3089b7c3cb0803 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_64_T_T_3_0___gfx11xx__P__2_2_32_16_True__CO__wave2_warp4_stg1--Arch_gfx1103
    { 0x4f5fda61u, 0xcced26abu, 411, 33 }, // 4f5fda61cced26ab = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_64_T_T_3_0___gfx11xx__P__2_2_32_16_True__CO__wave3_warp2_stg1--Arch_gfx1103
    { 0x2eb9bfd1u, 0x55383c40u, 411, 167 }, // 2eb9bfd155383c40 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_64_T_T_3_0___gfx11xx__P__2_2_32_16_True__CO__wave3_warp4_stg1--Arch_gfx1103
    { 0xc4324692u, 0x6c9b1af9u, 411, 133 }, // c43246926c9b1af9 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_64_T_T_3_0___gfx11xx__P__2_2_32_16_True__CO__wave4_warp4_stg1--Arch_gfx1103
    { 0x01c13e52u, 0x9a6ff9f1u, 426, 202 }, // 01c13e529a6ff9f1 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_64_T_T_3_0___gfx11xx__P__2_2_32_32_True__CO__wave1_warp4_stg1--Arch_gfx1103
    { 0x44e1ee3fu, 0x080b2552u, 426, 167 }, // 44e1ee3f080b2552 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_64_T_T_3_0___gfx11xx__P__2_2_32_32_True__CO__wave3_warp4_stg1--Arch_gfx1103
    { 0xa0566f8fu, 0x89de0d71u, 235, 202 }, // a0566f8f89de0d71 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_64_T_T_3_0___gfx11xx__P__2_2_64_32_False__CO__wave1_warp4_stg1--Arch_gfx1103
    { 0x437bb198u, 0x926899c3u, 235, 116 }, // 437bb198926899c3 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_64_T_T_3_0___gfx11xx__P__2_2_64_32_False__CO__wave2_warp4_stg1--Arch_gfx1103
};

static constexpr int kTotalNumKernels = ARRAY_SIZE(meta_list);

using AOTRITON_NS::v3::flash::autotune::attn_fwd_packed_string;

static AOTRITON_NS::TritonKernelCluster<kTotalNumKernels>
kernel_cluster(meta_list,
               attn_fwd_packed_string);

static int8_t lut[1][10][10] =
{
// GPU gfx1103_mod0
{{ 0, 3, 5, 2, 4, 0, 1, 1, 3, 1},
 {12,18,16,11, 7,18,16,16,19,18},
 {12, 9,14,19,18,16,19, 7,12, 9},
 { 7,11,13,17,17,15,13,17,17,17},
 {11, 9,15,17,13,17,15,17,13,13},
 {10,20,22,22,22,13,17,17,13,21},
 { 8,22,22,22,22,22,22,22,22,22},
 {10,22,22,22,22,22,22,22,22,22},
 { 6,22,22,22,22,22,22,22,23,23},
 { 6,22,23,22,22,22,22,22,23,22}}
// End of GPU gfx1103_mod0
}
;

}; // End of anonymous namespace

namespace AOTRITON_NS::v3::flash::autotune {

// using AOTRITON_NS::v2::flash::AttnFwdContext;

void CURRENT_ENTRY_PUBLIC(AttnFwdContext& context, int mod_number) {
#if AOTRITON_BUILD_FOR_TUNING
    int preferred_index = context._has_preferred_kernel;
    context._total_number_of_kernels = kTotalNumKernels;
#ifndef NDEBUG
    std::cerr << "Autotune_attn_fwd__A4__F62 "
              << "kTotalNumKernels = " << kTotalNumKernels << " "
              << "_has_preferred_kernel = " << preferred_index << " "
              << std::endl;
#endif
    if (preferred_index != -1) {
        if (preferred_index >= kTotalNumKernels)
            return ;
        context.kernel_on_device = kernel_cluster.get(preferred_index);
        context.pp_args_index = 11;
        context.package_path = PACKAGE_PATH;
        context.func_name = FUNC_NAME;
        context.arch_name = ARCH_NAME;
        context._preferred_kernel_psels = kernel_psels[preferred_index];
        context._preferred_kernel_copts = kernel_copts[preferred_index];
        const auto& perf = image_perf_list[preferred_index];
        context.PERSISTENT_TYPE = perf.PERSISTENT_TYPE;
    context.GRID_CU_MULTIP = perf.GRID_CU_MULTIP;
    context.BLOCK_M = perf.BLOCK_M;
    context.BLOCK_N = perf.BLOCK_N;
    context.PRE_LOAD_V = perf.PRE_LOAD_V;
        return ;
    }
#endif
    auto kernel_index = attn_fwd__lut_lambda__0(*context.params, mod_number, lut);
    if (kernel_index < 0) {
      return ;
    }
    context.kernel_on_device = kernel_cluster.get(kernel_index);
    context.pp_args_index = 11;
    context.package_path = PACKAGE_PATH;
    context.func_name = FUNC_NAME;
    context.arch_name = ARCH_NAME;
#ifndef NDEBUG
    std::cerr << __FILE__ << " kernel_index = " << int(kernel_index) << std::endl;
#endif
    const auto& perf = image_perf_list[kernel_index];
    context.PERSISTENT_TYPE = perf.PERSISTENT_TYPE;
    context.GRID_CU_MULTIP = perf.GRID_CU_MULTIP;
    context.BLOCK_M = perf.BLOCK_M;
    context.BLOCK_N = perf.BLOCK_N;
    context.PRE_LOAD_V = perf.PRE_LOAD_V;
}

#undef CURRENT_ENTRY_PUBLIC
}

// Human-readable Signature 
// Q = "*fp16:16"
// B = 0
// A = 0
// Sm_scale = "fp32"
// L = "*fp32:16"
// Q_descale = 0
// stride_bz = 0
// stride_az = 0
// Num_head_q = "i32"
// cu_seqlens_q = "*i32:16"
// BLOCK_DMODEL = 64
// Head_dim = "i32"
// PADDED_HEAD = True
// ENABLE_DROPOUT = True
// dropout_p = "fp32"
// philox_seed_ptr = "*u64"
// philox_offset1 = "*u64"
// philox_offset2 = "u64"
// RETURN_ENCODED_SOFTMAX = False
// encoded_softmax = 0
// CAUSAL_TYPE = 3
// Window_left = "i32"
// BIAS_TYPE = 0
// USE_ALIBI = False
// INT8 = False
// persistent_atomic_counter = "*i32"
// Num_CU = "i32"

// SELECT * FROM FLASH$attn_fwd WHERE gpu IN ('gfx1100_mod0') AND inputs$Q_dtype = 'torch.float16' AND inputs$BLOCK_DMODEL = 64 AND inputs$PADDED_HEAD = False AND inputs$ENABLE_DROPOUT = True AND inputs$CAUSAL_TYPE = 3 AND inputs$BIAS_TYPE = 0

// vim: set fileencoding=utf-8

