const char * _shader_cache_raw[] = {
"anaglyph_header.fs", ""
"uniform bool isPicking;\n"
"#ifdef ANAGLYPH\n"
"uniform mat3 matL;\n"
"uniform float gamma;\n"
"#endif\n"
"#ifdef NO_ORDER_TRANSP\n"
"#ifdef ONE_DRAW_BUFFER\n"
"uniform float which_pass;  // 0. - first, 1. - second\n"
"#endif\n"
"#define gl_FragColor gl_FragData[0]\n"
"float get_weight(float depth, float alpha){\n"
"return alpha * max(1e-2, 3e3 * pow(1. - depth, 3.));  // eq #10\n"
"}\n"
"/*\n"
"* Set data for order independant transparency\n"
"*\n"
"* With multiple buffers:\n"
"* gl_FragData[0]: weighted color\n"
"* gl_FragData[1]: weight\n"
"*\n"
"* With one buffer and multi-pass:\n"
"* gl_FragData[0]: weighted color in pass 1\n"
"* gl_FragData[0]: weight         in pass 2\n"
"*\n"
"*/\n"
"void setFragDataForNoOrderTransp(float depth) {\n"
"float wi = get_weight(depth, gl_FragColor.a);\n"
"gl_FragData[0] = vec4(gl_FragColor.rgb * wi, gl_FragColor.a);\n"
"#ifdef ONE_DRAW_BUFFER\n"
"gl_FragData[0] = mix(gl_FragData[0], vec4(wi, wi, 0., 1.), which_pass);\n"
"#else\n"
"#ifdef ANAGLYPH\n"
"gl_FragData[1].rg = vec2(wi);\n"
"#else\n"
"gl_FragData[1].r = wi;\n"
"#endif // ANAGLYPH\n"
"#endif // ONE_DRAW_BUFFER\n"
"}\n"
"#endif // NO_ORDER_TRANSP\n"
"/*\n"
"* Apply post-lighting effects directly to output variables like gl_FragColor\n"
"*/\n"
"void PostLightingEffectsNoOIT() {\n"
"if (isPicking)\n"
"return;\n"
"#ifdef ray_trace_mode_3\n"
"gl_FragColor.rgb = floor(gl_FragColor.rgb * 3.999) / 3.0;\n"
"#endif\n"
"#ifdef ANAGLYPH\n"
"gl_FragColor.rgb = matL * pow(gl_FragColor.rgb, vec3(gamma));\n"
"#endif\n"
"}\n"
"vec3 ComputeChromadepth(float depth);\n"
"/*\n"
"* ... including OIT\n"
"*/\n"
"void PostLightingEffects(float depth) {\n"
"if (isPicking)\n"
"return;\n"
"PostLightingEffectsNoOIT();\n"
"#ifdef chromadepth_postlighting\n"
"vec3 luma_coeff = vec3(.30, .59, .11);\n"
"gl_FragColor.rgb = ComputeChromadepth(depth) * dot(luma_coeff, gl_FragColor.rgb);\n"
"#endif\n"
"#ifdef transparency_mode_3\n"
"#ifndef NO_ORDER_TRANSP\n"
"if (gl_FragColor.a < .95)\n"
"discard;\n"
"#else\n"
"if (gl_FragColor.a > .95)\n"
"discard;\n"
"setFragDataForNoOrderTransp(depth);\n"
"#endif // NO_ORDER_TRANSP\n"
"#endif // transparency_mode_3\n"
"}\n"
"/*\n"
"* Default argument overload\n"
"*/\n"
"void PostLightingEffects() {\n"
"PostLightingEffects(gl_FragCoord.z);\n"
"}\n"
"#ifdef chromadepth\n"
"#ifndef ortho\n"
"/*\n"
"* \"unproject\" the depth value if not in orthoscopic view, to get\n"
"* a depth gradient which is linear in eye space.\n"
"*/\n"
"uniform vec2 clippingplanes;\n"
"float orthoDepth(float depth) {\n"
"float front = clippingplanes.x;\n"
"float back = clippingplanes.y;\n"
"float front_inv = 1. / front;\n"
"float back_inv  = 1. / back;\n"
"float depth_eye = 1. / (depth * (back_inv - front_inv) + front_inv);\n"
"return (depth_eye - front) / (back - front);\n"
"}\n"
"#endif\n"
"/*\n"
"* Chromadepth - Calculates a color by depth.\n"
"* Uses a rainbow from red (near) to blue (far).\n"
"*\n"
"* http://chromatek.com/art-and-design/design-guide/\n"
"*/\n"
"vec3 ComputeChromadepth(float depth) {\n"
"#ifndef ortho\n"
"depth = orthoDepth(depth);\n"
"#endif\n"
"const float margin = 1. / 4.;\n"
"float hue6 = 6. * 240. / 360. *\n"
"clamp(depth * (1. + 2. * margin) - margin, 0., 1.);\n"
"return clamp(vec3(\n"
"abs(hue6 - 3.) - 1.,\n"
"2. - abs(hue6 - 2.),\n"
"2. - abs(hue6 - 4.)),\n"
"0., 1.);\n"
"}\n"
"#endif\n"
"/*\n"
"* Applies pre-lighting and pre-fog color alteration effects.\n"
"*/\n"
"vec4 ApplyColorEffects(vec4 color, float depth) {\n"
"#ifdef chromadepth\n"
"#ifndef chromadepth_postlighting\n"
"if (!isPicking)\n"
"color.rgb = ComputeChromadepth(depth);\n"
"#endif\n"
"#endif\n"
"return color;\n"
"}\n"
,
"bezier.fs", ""
"void main()\n"
"{\n"
"gl_FragColor = vec4(1.0, 1.0, 0.0f, 1.0);\n"
"}\n"
,
"bezier.tsc", ""
"#version 400\n"
"layout(vertices = 4) out;\n"
"uniform float segmentCount;\n"
"uniform float stripCount;\n"
"void main()\n"
"{\n"
"gl_out[gl_InvocationID].gl_Position = gl_in[gl_InvocationID].gl_Position;\n"
"gl_TessLevelOuter[1] = segmentCount;\n"
"gl_TessLevelOuter[0] = stripCount;\n"
"}\n"
,
"bezier.tse", ""
"#version 400\n"
"layout(isolines) in;\n"
"uniform mat4 g_ProjectionMatrix;\n"
"uniform mat4 g_ModelViewMatrix;\n"
"void main()\n"
"{\n"
"float t = gl_TessCoord.x;\n"
"float oneMinusT = 1.0 - t;\n"
"vec3 p0 = gl_in[0].gl_Position.xyz;\n"
"vec3 p1 = gl_in[1].gl_Position.xyz;\n"
"vec3 p2 = gl_in[2].gl_Position.xyz;\n"
"vec3 p3 = gl_in[3].gl_Position.xyz;\n"
"vec3 curveP = oneMinusT * oneMinusT * oneMinusT * p0 +\n"
"3.0f * oneMinusT * oneMinusT * t * p1 + 3.0f * oneMinusT * t * t * p2 +\n"
"t * t * t * p3;\n"
"gl_Position = g_ProjectionMatrix * g_ModelViewMatrix * vec4(curveP, 1.0);\n"
"}\n"
,
"bezier.vs", ""
"attribute vec3 position;\n"
"void main()\n"
"{\n"
"gl_Position = vec4(position, 1.0);\n"
"}\n"
,
"bg.fs", ""
"#include webgl_header.fs\n"
"#ifdef PURE_OPENGL_ES_2\n"
"precision highp float;\n"
"#endif\n"
"#include anaglyph_header.fs\n"
"varying vec2 bgTextureLookup ;\n"
"#include compute_fog_color.fs\n"
"void main()\n"
"{\n"
"gl_FragColor = vec4(ComputeBgColor(), 1.);\n"
"}\n"
,
"bg.vs", ""
"#ifdef PURE_OPENGL_ES_2\n"
"precision highp float;\n"
"#endif\n"
"attribute vec3 a_Vertex;\n"
"varying vec2 bgTextureLookup ;\n"
"uniform bool isPicking;\n"
"void main()\n"
"{\n"
"gl_Position = vec4(a_Vertex.xy, .5, 1.);\n"
"bgTextureLookup = (1. + a_Vertex.xy) / 2.;\n"
"}\n"
,
"call_compute_color_for_light.fs", ""
"/*\n"
"* This shader snipplet gets included multiple times (once for every light)\n"
"*\n"
"* postfix = \"_0\"       if light == 0\n"
"* postfix = \" * 0.0\"   if light > spec_count\n"
"* postfix = \"\"         else\n"
"*/\n"
"lighting += ComputeLighting(normal,\n"
"g_LightSource[`light`].position.xyz,\n"
"g_LightSource[`light`].diffuse.r,\n"
"spec_value`postfix`,\n"
"shininess`postfix`);\n"
,
"compute_color_for_light.fs", ""
"/*\n"
"* Lighting fragment header\n"
"*/\n"
"uniform float shininess;\n"
"uniform float shininess_0;\n"
"uniform float spec_value;\n"
"uniform float spec_value_0;\n"
"#ifdef precomputed_lighting\n"
"uniform samplerCube lightingTex;\n"
"#else\n"
"struct LightSource{\n"
"vec4 ambient;\n"
"vec4 diffuse;\n"
"vec4 specular;\n"
"vec4 position;\n"
"};\n"
"uniform LightSource g_LightSource[8];\n"
"struct  LightModel {\n"
"vec4 ambient;\n"
"};\n"
"uniform LightModel g_LightModel;\n"
"#endif\n"
"#ifdef ray_transparency_oblique\n"
"uniform float trans_oblique;\n"
"uniform float oblique_power;\n"
"#endif\n"
"/*\n"
"* Call this function for every light\n"
"*\n"
"* Return: (color intensity, specular (white) intensity)\n"
"*/\n"
"vec2 ComputeLighting(vec3 normal,   // surface normal\n"
"vec3 L,        // gl_LightSource[i].position.xyz\n"
"float diffuse, // gl_LightSource[i].diffuse.r\n"
"float spec,    // specular intensity\n"
"float shine)   // specular exponent\n"
"{\n"
"L = normalize(L);\n"
"float NdotL = dot(normal, L);\n"
"if (NdotL > 0.0) {\n"
"diffuse *= NdotL;\n"
"vec3 H = normalize(L + vec3(0., 0., 1.));\n"
"float NdotH = max(dot(normal, H), 0.0);\n"
"spec *= pow(NdotH, shine);\n"
"return vec2(diffuse, spec);\n"
"} else {\n"
"return vec2(0.0);\n"
"}\n"
"}\n"
"/*\n"
"* Apply lighting from all lights\n"
"*\n"
"* Return: lighted color\n"
"*/\n"
"vec4 ApplyLighting(vec4 color, vec3 normal) {\n"
"#ifdef precomputed_lighting\n"
"vec2 lighting = textureCube(lightingTex, normal).ra;\n"
"#else\n"
"vec2 lighting = vec2(g_LightModel.ambient.r, 0.0);\n"
"#include CallComputeColorForLight\n"
"#endif\n"
"color.rgb *= min(lighting.x, 1.0);\n"
"color.rgb += lighting.y;\n"
"#ifdef ray_transparency_oblique\n"
"float oblique_factor = abs(normal.z);\n"
"oblique_factor = mix(\n"
"(0.5 + 0.5 * (1.0 -\n"
"pow((1.0 - oblique_factor) * 2.0, oblique_power))),\n"
"(      0.5 * (\n"
"pow((      oblique_factor) * 2.0, oblique_power))),\n"
"step(oblique_factor, 0.5));\n"
"float trans = (1. - color.a) * (trans_oblique * oblique_factor + (1. - trans_oblique));\n"
"color.a = 1. - clamp(trans, 0.0, 1.0);\n"
"#endif\n"
"return color;\n"
"}\n"
,
"compute_fog_color.fs", ""
"/*\n"
"* Background and fog fragment header\n"
"*/\n"
"uniform sampler2D bgTextureMap;\n"
"uniform vec3 bgSolidColor;\n"
"uniform vec2 tileSize;\n"
"uniform vec2 tiledSize;\n"
"uniform vec2 viewImageSize;\n"
"vec3 ComputeBgColor() {\n"
"#ifdef bg_image_mode_solid\n"
"return bgSolidColor.rgb;\n"
"#else\n"
"float covered = 1.0;\n"
"#ifdef bg_image_mode_1_or_3\n"
"vec2 bgLookup = 0.5 + (bgTextureLookup - 0.5) / viewImageSize;\n"
"#ifndef bg_image_mode_2_or_3\n"
"vec2 within01 = step(0., bgLookup) * step(-1., -bgLookup);\n"
"covered = within01.x * within01.y;\n"
"#endif\n"
"#else\n"
"#ifdef bg_image_mode_2_or_3\n"
"vec2 bgLookup = mod(bgTextureLookup, tiledSize) / tiledSize;\n"
"bgLookup = tileSize * floor(bgLookup / tileSize);\n"
"#else\n"
"vec2 bgLookup = bgTextureLookup;\n"
"#endif\n"
"#endif\n"
"vec4 bgColor = texture2D(bgTextureMap, bgLookup);\n"
"return mix(bgSolidColor.rgb, bgColor.rgb, min(covered, bgColor.a));\n"
"#endif\n"
"}\n"
"vec4 ApplyFog(vec4 color, float fog) {\n"
"#ifdef depth_cue\n"
"if (isPicking || fog >= 1.)\n"
"return color;\n"
"return vec4(mix(ComputeBgColor(), color.rgb, fog), color.a);\n"
"#else\n"
"return color;\n"
"#endif\n"
"}\n"
,
"connector.fs", ""
"#include webgl_header.fs\n"
"varying vec3 NORMAL ;\n"
"#ifdef use_geometry_shaders\n"
"varying vec4 COLOR ;\n"
"#else\n"
"varying vec4 COLORIn ;\n"
"#define COLOR COLORIn\n"
"#endif\n"
"varying float fog;\n"
"varying vec2 bgTextureLookup;\n"
"#ifdef use_geometry_shaders\n"
"varying float lineEdge;\n"
"varying float aaCutoff;\n"
"#endif\n"
"#include anaglyph_header.fs\n"
"#include compute_fog_color.fs\n"
"float mysmoothstep(float edge0, float edge1, float x){\n"
"float rets = step(edge0, edge1) * step(edge1, edge0);\n"
"return rets * step(edge0, x) + (1.-rets) * smoothstep(edge0, edge1, x);\n"
"}\n"
"void main()\n"
"{\n"
"float alpha = COLOR.a;\n"
"#ifdef use_geometry_shaders\n"
"#ifdef line_smooth\n"
"alpha *= mysmoothstep(0., aaCutoff, 1. - abs(lineEdge));\n"
"#endif\n"
"#endif\n"
"vec4 color = ApplyColorEffects(COLOR, gl_FragCoord.z);\n"
"gl_FragColor = ApplyFog(vec4(color.rgb, alpha), fog);\n"
"PostLightingEffects();\n"
"}\n"
,
"connector.gs", ""
"#version 120\n"
"#extension GL_EXT_geometry_shader4 : require\n"
"#extension GL_EXT_gpu_shader4 : require\n"
"varying out vec3 NORMAL ;\n"
"varying out vec4 COLOR ;\n"
"varying out float fog;\n"
"varying out vec2 bgTextureLookup;\n"
"varying out float lineEdge;\n"
"varying out float aaCutoff;\n"
"varying in vec4 a_center[];\n"
"varying in vec4 a_target[];\n"
"varying in vec4 COLORIn[];\n"
"varying in vec2 a_textSizeIn[];\n"
"varying in vec3 a_screenWorldOffsetIn[];\n"
"varying in vec2 a_indentFactorIn[];\n"
"varying in float a_relative_modeIn[];\n"
"varying in float a_draw_flagsIn[];\n"
"varying in vec4 a_bkgrd_colorIn[];\n"
"varying in float a_rel_ext_lengthIn[];\n"
"varying in float a_con_widthIn[];\n"
"uniform vec2 screenSize;\n"
"uniform float screenOriginVertexScale;\n"
"uniform float antialiasedLines;\n"
"uniform float textureToLabelSize;\n"
"uniform float front;\n"
"uniform float clipRange;\n"
"float PI = 3.14159265358979323846264;\n"
"float mysmoothstep(float edge0, float edge1, float x){\n"
"float rets = step(edge0, edge1) * step(edge1, edge0);\n"
"return rets * step(edge0, x) + (1.-rets) * smoothstep(edge0, edge1, x);\n"
"}\n"
"#include connector.shared\n"
"struct lineSeg_t {\n"
"vec2 p1;\n"
"vec2 p2;\n"
"};\n"
"bool lineSegIntersection(vec2 p1,  vec2 p2, vec2 p3, vec2 p4, out vec2 po) {\n"
"float  distAB, theCos, theSin, newX, abpos;\n"
"vec2 p2i, p3i, p4i;\n"
"if ((p1.x==p2.x && p1.y==p2.y) || (p3.x==p4.x && p3.y==p4.y)) return false;\n"
"if ((p1.x==p3.x && p1.y==p3.y) || (p2.x==p3.x && p2.y==p3.y)\n"
"||  (p1.x==p4.x && p1.y==p4.y) || (p2.x==p4.x && p2.y==p4.y)) {\n"
"return false; }\n"
"p2i.x = p2.x; p2i.y = p2.y;\n"
"p3i.x = p3.x; p3i.y = p3.y;\n"
"p4i.x = p4.x; p4i.y = p4.y;\n"
"p2i.x -= p1.x; p2i.y -= p1.y;\n"
"p3i.x -= p1.x; p3i.y -= p1.y;\n"
"p4i.x -= p1.x; p4i.y -= p1.y;\n"
"distAB = sqrt(p2i.x * p2i.x + p2i.y * p2i.y);\n"
"theCos = p2i.x / distAB;\n"
"theSin = p2i.y / distAB;\n"
"newX = p3i.x * theCos + p3i.y * theSin;\n"
"p3i.y = p3i.y * theCos - p3i.x * theSin;\n"
"p3i.x = newX;\n"
"newX = p4i.x * theCos + p4i.y * theSin;\n"
"p4i.y = p4i.y * theCos - p4i.x * theSin;\n"
"p4i.x = newX;\n"
"if ((p3i.y < 0. && p4i.y<0.) || (p3i.y >= 0. && p4i.y >= 0.)) return false;\n"
"abpos = p4i.x + (p3i.x - p4i.x) * p4i.y / (p4i.y - p3i.y);\n"
"if (abpos<0. || abpos>distAB) return false;\n"
"po.x = p1.x + abpos * theCos;\n"
"po.y = p1.y + abpos * theSin;\n"
"return true;\n"
"}\n"
"void setBG(){\n"
"bgTextureLookup = (gl_Position.xy/gl_Position.w) / 2.0 + 0.5;\n"
"}\n"
"void drawLineAsGeometryClipped(vec4 pt1, vec4 pt2, lineSeg_t labelTop, lineSeg_t labelBottom, lineSeg_t labelLeft, lineSeg_t labelRight, out vec2 dirv, float lineWidth, float aa){\n"
"vec4 pt1E = pt1;\n"
"vec4 pt2E = pt2;\n"
"pt1E.xy = floor(pt1.xy * screenSize) / screenSize;\n"
"pt2E.xy = floor(pt2.xy * screenSize) / screenSize;\n"
"vec3 diffV = pt1E.xyz - pt2E.xyz;\n"
"vec2 dirvPnorm = vec2(normalize(cross(diffV, vec3(0.,0.,1.))).xy);\n"
"vec2 dirvP = lineWidth*dirvPnorm;\n"
"dirv = dirvP/screenSize;\n"
"int l1V = 0 , l2V = 0;\n"
"lineSeg_t l1, l2;\n"
"vec2 isec1, isec2;\n"
"l1.p1 = pt1.xy + dirv;\n"
"l1.p2 = pt2.xy + dirv;\n"
"l2.p1 = pt1.xy - dirv;\n"
"l2.p2 = pt2.xy - dirv;\n"
"if (lineSegIntersection(labelTop.p1, labelTop.p2, l1.p1, l1.p2, isec1)) {\n"
"l1V = 1;\n"
"} else if (lineSegIntersection(labelRight.p1, labelRight.p2, l1.p1, l1.p2, isec1)) {\n"
"l1V = 2;\n"
"} else if (lineSegIntersection(labelBottom.p1, labelBottom.p2, l1.p1, l1.p2, isec1)) {\n"
"l1V = 3;\n"
"} else if (lineSegIntersection(labelLeft.p1, labelLeft.p2, l1.p1, l1.p2, isec1)) {\n"
"l1V = 4;\n"
"}\n"
"if (lineSegIntersection(labelTop.p1, labelTop.p2, l2.p1, l2.p2, isec2)) {\n"
"l2V = 1;\n"
"} else if (lineSegIntersection(labelRight.p1, labelRight.p2, l2.p1, l2.p2, isec2)) {\n"
"l2V = 2;\n"
"} else if (lineSegIntersection(labelBottom.p1, labelBottom.p2, l2.p1, l2.p2, isec2)) {\n"
"l2V = 3;\n"
"} else if (lineSegIntersection(labelLeft.p1, labelLeft.p2, l2.p1, l2.p2, isec2)) {\n"
"l2V = 4;\n"
"}\n"
"if ( (l1V > 0 && l2V > 0) && (l1V == l2V) ) {\n"
"pt1E.xy = pt1.xy + dirv; pt1E.z = pt1.z;\n"
"gl_Position = pt1E;\n"
"lineEdge = 1.; aaCutoff = aa;\n"
"setBG(); EmitVertex();\n"
"pt1E.xy = pt1.xy - dirv; pt1E.z = pt1.z;\n"
"gl_Position = pt1E;\n"
"lineEdge = -1.;\n"
"setBG(); EmitVertex();\n"
"pt2E.xy = isec1;  pt2E.z = pt2.z;\n"
"gl_Position = pt2E;\n"
"lineEdge = 1.;\n"
"setBG(); EmitVertex();\n"
"pt2E.xy = isec2;  pt2E.z = pt2.z;\n"
"gl_Position = pt2E;\n"
"lineEdge = -1.;\n"
"setBG(); EmitVertex();\n"
"EndPrimitive();\n"
"lineEdge = 0.;\n"
"aaCutoff = 0.;\n"
"} else if ( (l1V > 0 && l2V > 0) && (l1V != l2V) ) { // Find the corner\n"
"vec2 isecc;\n"
"if ( (l1V == 1 && l2V == 2) || (l1V == 2 && l2V == 1) ) { // UR\n"
"isecc = labelTop.p1;\n"
"} else if ( (l1V == 2 && l2V == 3) || (l1V == 3 && l2V == 2) ) { // LR\n"
"isecc = labelBottom.p2;\n"
"} else if ( (l1V == 3 && l2V == 4) || (l1V == 4 && l2V == 3) ) { // LL\n"
"isecc = labelBottom.p1;\n"
"} else if ( (l1V == 4 && l2V == 1) || (l1V == 1 && l2V == 4) ) { // UL\n"
"isecc = labelTop.p2;\n"
"}\n"
"pt2E.xy = isec1.xy; pt2E.z = pt2.z;\n"
"gl_Position = pt2E;\n"
"lineEdge = 1.; aaCutoff = aa;\n"
"setBG(); EmitVertex();\n"
"pt1E.xy = pt1.xy + dirv; pt1E.z = pt1.z;\n"
"gl_Position = pt1E;\n"
"lineEdge = 1.;\n"
"setBG(); EmitVertex();\n"
"pt2E.xy = isecc.xy; pt2E.z = pt2.z;\n"
"gl_Position = pt2E;\n"
"/* since we are adding a corner vertex, we also need to\n"
"account for anti-aliasing by setting lineEdge for that\n"
"vertex. */\n"
"float len1 = length(screenSize* (isecc.xy - isec1.xy)); // length between corner and first intersection\n"
"float len2 = length(screenSize* (isecc.xy - isec2.xy)); // length between corner and second intersection\n"
"float lenc = length(screenSize* (isec2.xy - isec1.xy)); // length between intersections, i.e., line width\n"
"float ang = atan(len2 / len1);  // angle between perpendicular vector and first edge\n"
"float n2 = sin(ang) * len2;     // second edge projected onto perpendicular vector\n"
"float lenr = (n2 / lenc) * 2. - 1.;  // figure out ratio and normalize it between -1 and 1\n"
"float lenrsign = 2. * (step(0., lenr) - .5);  // sign for lenr used below\n"
"lineEdge = lenrsign * (1. - mysmoothstep(0., aa, 1 - abs(lenr))); // take into account aa for corner vertex lineEdge\n"
"setBG(); EmitVertex();\n"
"pt1E.xy = pt1.xy - dirv; pt1E.z = pt1.z;\n"
"gl_Position = pt1E;\n"
"lineEdge = -1.;\n"
"setBG(); EmitVertex();\n"
"pt2E.xy = isec2.xy; pt2E.z = pt2.z;\n"
"gl_Position = pt2E;\n"
"lineEdge = -1.;\n"
"setBG(); EmitVertex();\n"
"EndPrimitive();\n"
"}\n"
"}\n"
"void drawLineAsGeometry(vec4 pt1, vec4 pt2, out vec2 dirv, float lineWidth, float aa){\n"
"vec4 pt1E = pt1;\n"
"vec4 pt2E = pt2;\n"
"pt1E.xy = floor(pt1.xy * screenSize) / screenSize;\n"
"pt2E.xy = floor(pt2.xy * screenSize) / screenSize;\n"
"vec3 diffV = pt1E.xyz - pt2E.xyz;\n"
"vec2 dirvPnorm = vec2(normalize(cross(diffV, vec3(0.,0.,1.))).xy);\n"
"vec2 dirvP = lineWidth*dirvPnorm;\n"
"dirv = dirvP/screenSize;\n"
"pt1E.xy = pt1.xy + dirv;\n"
"gl_Position = pt1E;\n"
"lineEdge = -1.; aaCutoff = aa;\n"
"setBG(); EmitVertex();\n"
"pt2E.xy = pt2.xy + dirv;\n"
"gl_Position = pt2E;\n"
"lineEdge = -1.;\n"
"setBG(); EmitVertex();\n"
"pt1E.xy = pt1.xy - dirv;\n"
"gl_Position = pt1E;\n"
"lineEdge = 1.;\n"
"setBG(); EmitVertex();\n"
"pt2E.xy = pt2.xy - dirv;\n"
"gl_Position = pt2E;\n"
"lineEdge = 1.;\n"
"setBG(); EmitVertex();\n"
"EndPrimitive();\n"
"lineEdge = 0.;\n"
"aaCutoff = 0.;\n"
"}\n"
"void drawLineAsGeometryWithOffsets(vec4 pt1, vec4 pt2, float topext, float bottomext){\n"
"vec4 pt1E = pt1;\n"
"vec4 pt2E = pt2;\n"
"vec3 diffV = pt1E.xyz - pt2E.xyz;\n"
"vec2 linev = vec2(a_con_widthIn[0] * normalize(diffV).xy) / screenSize;\n"
"vec2 dirv = vec2((a_con_widthIn[0]*normalize(cross(diffV, vec3(0.,0.,1.)).xy)))/screenSize;\n"
"pt1E.xy = pt1.xy + dirv + topext * linev;\n"
"gl_Position = pt1E;\n"
"setBG(); EmitVertex();\n"
"pt2E.xy = pt2.xy + dirv - topext * linev;\n"
"gl_Position = pt2E;\n"
"setBG(); EmitVertex();\n"
"pt1E.xy = pt1.xy - dirv + bottomext * linev;\n"
"gl_Position = pt1E;\n"
"setBG(); EmitVertex();\n"
"pt2E.xy = pt2.xy - dirv - bottomext * linev;\n"
"gl_Position = pt2E;\n"
"setBG(); EmitVertex();\n"
"EndPrimitive();\n"
"}\n"
"void main()\n"
"{\n"
"vec4 transformedCenter, transformedTarget;\n"
"vec2 textSizeInScreen, offset, drawVector;\n"
"float doNotDraw;\n"
"float connector_mode_0, connector_mode_1, connector_mode_2, connector_mode_3, connector_mode_4, connector_mode_2_4, drawBackgroundOutline, drawBackground, drawConnector, isProjected, zValue, zTarget;\n"
"lineEdge = 0.;\n"
"aaCutoff = 0.;\n"
"getDrawFlags(a_draw_flagsIn[0], connector_mode_0, connector_mode_1, connector_mode_2, connector_mode_3, connector_mode_4, drawBackgroundOutline, drawBackground, drawConnector);\n"
"float negLabelSize = step(textureToLabelSize, 0.);\n"
"float textureToLabelSizeA = abs(textureToLabelSize);\n"
"float extLength = (1.-negLabelSize) * a_rel_ext_lengthIn[0] + negLabelSize * (-a_rel_ext_lengthIn[0]/(screenOriginVertexScale*2.) );\n"
"vec2 textSize = a_textSizeIn[0] / textureToLabelSizeA;\n"
"connector_mode_2_4 = connector_mode_2 + connector_mode_4;\n"
"calculatePreConnectorInfo(a_center[0], a_target[0], textSize, a_indentFactorIn[0], a_screenWorldOffsetIn[0], transformedCenter, transformedTarget, textSizeInScreen, offset, drawVector, doNotDraw, a_relative_modeIn[0], isProjected, zValue, a_con_widthIn[0], zTarget);\n"
"vec4 endpointOnBBX, endpointExtendedOffBBX;\n"
"calculateConnectorInfo(a_center[0], textSizeInScreen, textSize, drawVector, offset, fog, transformedCenter, transformedTarget, endpointOnBBX, endpointExtendedOffBBX, connector_mode_0, connector_mode_1, connector_mode_2, connector_mode_3, connector_mode_4, extLength, isProjected, zValue);\n"
"NORMAL = vec3(0.,0.,1.);\n"
"float withinView = step(zValue, 1.) * step(-1., zValue);\n"
"float ttz = (1.-zTarget) * (1.-isProjected); // not zTarget and not projected, then keep same, otherwise zValue\n"
"transformedTarget.z =  ttz * transformedTarget.z + (1.-ttz) * zValue;\n"
"vec4 transformedPosition3 = transformedCenter;\n"
"transformedPosition3.xy += offset;\n"
"transformedPosition3.z = zValue;\n"
"vec4 upperLeft = transformedPosition3;\n"
"upperLeft.xy += textSizeInScreen * vec2(-1.,1.);\n"
"vec4 upperRight = transformedPosition3;\n"
"upperRight.xy += textSizeInScreen * vec2(1.,1.);\n"
"vec4 lowerLeft = transformedPosition3;\n"
"lowerLeft.xy +=  textSizeInScreen * vec2(-1.,-1.);\n"
"vec4 lowerRight = transformedPosition3;\n"
"lowerRight.xy += textSizeInScreen * vec2(1.,-1.);\n"
"lineSeg_t labelTop, labelBottom, labelLeft, labelRight;\n"
"labelTop.p1 = upperRight.xy;\n"
"labelTop.p2 = upperLeft.xy;\n"
"labelBottom.p1 = lowerLeft.xy;\n"
"labelBottom.p2 = lowerRight.xy;\n"
"labelRight.p1 = upperRight.xy;\n"
"labelRight.p2 = lowerRight.xy;\n"
"labelLeft.p1 = upperLeft.xy;\n"
"labelLeft.p2 = lowerLeft.xy;\n"
"if (drawBackgroundOutline + drawBackground > 0.){\n"
"if (drawBackground > 0.){\n"
"if (drawBackgroundOutline > 0.){\n"
"vec2 lineWidth = a_con_widthIn[0] / (screenSize);\n"
"vec4 upperLeftM = upperLeft + vec4(lineWidth.x, -lineWidth.y, 0., 0.),\n"
"upperRightM = upperRight + vec4(-lineWidth.x, -lineWidth.y, 0., 0.),\n"
"lowerLeftM = lowerLeft + vec4(lineWidth.x, lineWidth.y, 0., 0.),\n"
"lowerRightM = lowerRight + vec4(-lineWidth.x, lineWidth.y, 0., 0.);\n"
"COLOR = a_bkgrd_colorIn[0];\n"
"gl_Position = upperLeftM; setBG(); EmitVertex();\n"
"gl_Position = upperRightM; setBG(); EmitVertex();\n"
"gl_Position = lowerLeftM;  setBG(); EmitVertex();\n"
"gl_Position = lowerRightM; setBG(); EmitVertex();\n"
"EndPrimitive();\n"
"} else {\n"
"COLOR = a_bkgrd_colorIn[0];\n"
"gl_Position = upperLeft; setBG(); EmitVertex();\n"
"gl_Position = upperRight; setBG(); EmitVertex();\n"
"gl_Position = lowerLeft;  setBG(); EmitVertex();\n"
"gl_Position = lowerRight; setBG(); EmitVertex();\n"
"EndPrimitive();\n"
"}\n"
"}\n"
"if (drawBackgroundOutline > 0.){\n"
"COLOR = COLORIn[0];\n"
"drawLineAsGeometryWithOffsets(upperLeft, upperRight, 1., 0.);\n"
"drawLineAsGeometryWithOffsets(lowerRight, upperRight, 0., 1.);\n"
"drawLineAsGeometryWithOffsets(lowerLeft, lowerRight, 0., 1.);\n"
"drawLineAsGeometryWithOffsets(lowerLeft, upperLeft, 1., 0.);\n"
"}\n"
"}\n"
"if (drawConnector > 0 && doNotDraw == 0.){\n"
"COLOR = COLORIn[0];\n"
"float aa = min(1., 2./a_con_widthIn[0]);\n"
"float widthAdjustment = aa * a_con_widthIn[0];\n"
"float adjLineWidth = antialiasedLines * widthAdjustment + a_con_widthIn[0];\n"
"if (connector_mode_2_4 > 0.){\n"
"vec2 dirv1, dirv2;\n"
"drawLineAsGeometry(endpointExtendedOffBBX, endpointOnBBX, dirv2, a_con_widthIn[0], 0);\n"
"drawLineAsGeometry(transformedTarget, endpointExtendedOffBBX, dirv1, adjLineWidth, aa);\n"
"float norder = step(0., cross(vec3(dirv1.x, dirv1.y, 0.), vec3(dirv2.x, dirv2.y, 0.)).z);\n"
"lineEdge = 0.; aaCutoff = 0.;\n"
"gl_Position = endpointExtendedOffBBX;\n"
"setBG(); EmitVertex();\n"
"lineEdge = -1.; aaCutoff = aa;\n"
"if (norder < .5){\n"
"vec4 pt = endpointExtendedOffBBX;\n"
"pt.xy = endpointExtendedOffBBX.xy + dirv1;\n"
"gl_Position = pt;\n"
"setBG(); EmitVertex();\n"
"pt.xy = endpointExtendedOffBBX.xy + dirv2;\n"
"gl_Position = pt;\n"
"aaCutoff = 0.;\n"
"setBG(); EmitVertex();\n"
"} else {\n"
"vec4 pt = endpointExtendedOffBBX;\n"
"pt.xy = endpointExtendedOffBBX.xy - dirv2;\n"
"gl_Position = pt;\n"
"aaCutoff = 0.;\n"
"setBG(); EmitVertex();\n"
"pt.xy = endpointExtendedOffBBX.xy - dirv1;\n"
"gl_Position = pt;\n"
"aaCutoff = aa;\n"
"setBG(); EmitVertex();\n"
"}\n"
"EndPrimitive();\n"
"lineEdge = 0.; aaCutoff = 0.;\n"
"} else if (connector_mode_1 > 0. && drawBackground > 0.){\n"
"vec4 midULUR = (upperLeft + upperRight) / 2.0;\n"
"vec4 midLLLR = (lowerLeft + lowerRight) / 2.0;\n"
"vec4 midMid = (midULUR + midLLLR) / 2.0;\n"
"vec2 dirv;\n"
"drawLineAsGeometryClipped(transformedTarget, midMid, labelTop, labelBottom, labelLeft, labelRight, dirv, adjLineWidth, aa);\n"
"} else { //connector_mode 0 or 3, or connector_mode 1 without the background\n"
"vec2 dirv;\n"
"drawLineAsGeometry(transformedTarget, endpointOnBBX, dirv, adjLineWidth, aa);\n"
"}\n"
"}\n"
"}\n"
,
"connector.shared", ""
"#include webgl_header.vs\n"
"/* computeConnectorOffset : this function takes the drawVector and returns the offset of the\n"
"* endpoint for the connector in the label's bbx coordinates\n"
"*/\n"
"vec2 computeConnectorOffset_0(vec2 drawVector){\n"
"float hmid = step(abs(drawVector.x), .5);\n"
"float vmid = step(abs(drawVector.y), .5);\n"
"float right = (1.-hmid) * step(0., drawVector.x) + hmid * .5;\n"
"float top = (1.-vmid) * step(0., drawVector.y) + vmid * .5;\n"
"float xoff = 2. * (right - .5), yoff = 2. * (top - .5);\n"
"return vec2(xoff, yoff);\n"
"}\n"
"vec2 computeConnectorOffset_1(vec2 drawVector){\n"
"vec2 drawVectorN = normalize(drawVector);\n"
"float absyx = step(abs(drawVectorN.y), abs(drawVectorN.x));\n"
"float notabsyx = 1. - absyx;\n"
"float hdir = 2. * (step(0., drawVectorN.x) - .5);\n"
"float vdir = 2. * (step(0., drawVectorN.y) - .5);\n"
"float dvxy = drawVector.x / drawVector.y;\n"
"float dvyx = drawVector.y / drawVector.x;\n"
"return vec2(((absyx * hdir) + (notabsyx * vdir * dvxy)),\n"
"((notabsyx * vdir) + (absyx * hdir * dvyx)));\n"
"}\n"
"vec2 computeConnectorOffset_2(vec2 drawVector, out vec2 eoff, vec2 textSize, float extLength){\n"
"float rightorig = step(0., drawVector.x);\n"
"float ratio = abs(textSize.y/textSize.x);\n"
"float right = rightorig + (rightorig - .5) * clamp(abs(drawVector.x)-1., 0., 2. * min(1., extLength * ratio));\n"
"float top = step(0., drawVector.y);\n"
"float xofforig = 2. * (rightorig - .5), xoff = 2. * (right - .5), yoff = 2. * (top - .5);\n"
"eoff = vec2(xoff, yoff);\n"
"return vec2(xofforig, yoff);\n"
"}\n"
"vec2 computeConnectorOffset_3(vec2 drawVector){\n"
"float hmid = step(abs(drawVector.x), 1.);\n"
"float vmid = step(abs(drawVector.y), 1.);\n"
"float right = (1.-hmid) * step(0., drawVector.x) + hmid * ((1. + drawVector.x) / 2.);\n"
"float top = (1.-vmid) * step(0., drawVector.y) + vmid * ((1. + drawVector.y) / 2.);\n"
"float xoff = 2. * (right - .5), yoff = 2. * (top - .5);\n"
"return vec2(xoff, yoff);\n"
"}\n"
"vec2 computeConnectorOffset_4(vec2 drawVector, out vec2 eoff, vec2 textSize, float extLength){\n"
"float hmid = step(abs(drawVector.x), 1.);\n"
"float vmid = step(abs(drawVector.y), 1.);\n"
"float rightorig = (1.-hmid) * step(0., drawVector.x) + hmid * ((1. + drawVector.x) / 2.);\n"
"float ratio = abs(textSize.y/textSize.x);\n"
"float right = rightorig + (1.-hmid) * (rightorig - .5) * clamp(abs(drawVector.x)-1., 0., 2. * min(1., extLength * ratio));\n"
"float top = (1.-vmid) * step(0., drawVector.y) +\n"
"vmid * ((1. + drawVector.y) / 2.);\n"
"float xofforig = 2. * (rightorig - .5), xoff = 2. * (right - .5), yoff = 2. * (top - .5);\n"
"eoff = vec2(xoff, yoff);\n"
"return vec2(xofforig, yoff);\n"
"}\n"
"vec2 computeCenterOffsetFromProjectedPoint(vec2 indentFactor, vec2 textSizeInScreen, vec2 screenWorldOffset){\n"
"return (indentFactor * textSizeInScreen + screenWorldOffset/(screenSize*screenOriginVertexScale));\n"
"}\n"
"vec4 normalizeVec4(vec4 point){\n"
"vec4 retPt = vec4(point.xyz/point.w, 1.);\n"
"retPt.xy = ( floor(retPt.xy * screenSize + .5 ) + .5 ) / screenSize; // to match label rounding to middle of pixel\n"
"return retPt;\n"
"}\n"
"float convertNormalZToScreenZ(float normalz){\n"
"float a_centerN = (normalz + 1.) / 2.;\n"
"float ptInPreProjectionZ = -(front + clipRange * a_centerN);\n"
"vec4 ptInPreProjection = vec4(0., 0., ptInPreProjectionZ, 1.);\n"
"vec4 projVect = g_ProjectionMatrix * ptInPreProjection;\n"
"return projVect.z / projVect.w;\n"
"}\n"
"void calculatePreConnectorInfo(vec4 a_center, vec4 a_target, vec2 textSize, vec2 indentFactor, vec3 screenWorldOffset, out vec4 tCenter, out vec4 tTarget, out vec2 tsScreen, out vec2 offset, out vec2 dVector, out float doNotDraw, float a_relative_mode, out float isProjected, out float zValue, in float lineWidth, out float zTarget){\n"
"vec3 viewVector = vec3(vec4(0., 0., -1., 0.) * g_ModelViewMatrix);\n"
"tCenter = normalizeVec4(g_ProjectionMatrix * g_ModelViewMatrix * a_center);\n"
"tTarget = normalizeVec4(g_ProjectionMatrix * g_ModelViewMatrix * a_target);\n"
"vec4 a_centerp = (a_center + screenWorldOffset.z * vec4(viewVector, 0.));\n"
"vec4 transformedPositionZ = normalizeVec4(g_ProjectionMatrix * g_ModelViewMatrix * a_centerp);  // use projected center point for z\n"
"float isScreenCoord = step(2., mod(a_relative_mode, 4.));\n"
"float isPixelCoord = step(4., mod(a_relative_mode, 8.));\n"
"isProjected = step(isPixelCoord + isScreenCoord, 0.5);\n"
"zTarget = step(8., mod(a_relative_mode, 16.));\n"
"zValue = (1.-zTarget) * ((isProjected * transformedPositionZ.z) + (1.-isProjected) * convertNormalZToScreenZ(a_center.z) ) + zTarget * tTarget.z;\n"
"zValue += 1e-4;\n"
"vec2 pixOffset = ((2. * a_center.xy / screenSize) - 1.);\n"
"tCenter = isProjected * tCenter + isScreenCoord * a_center + isPixelCoord * vec4(pixOffset.x, pixOffset.y, -0.5, 0.); // only xy are used from tCenter\n"
"tCenter.w = 1.;\n"
"tsScreen = textSize / screenSize;\n"
"offset = computeCenterOffsetFromProjectedPoint(indentFactor, tsScreen, screenWorldOffset.xy);\n"
"dVector = (tTarget.xy - tCenter.xy - offset) / tsScreen;\n"
"vec2 limit = 1.0 + .5 * lineWidth/textSize;\n"
"doNotDraw = (1.-step(limit.x, abs(dVector.x)))  * (1.-step(limit.y, abs(dVector.y)));\n"
"}\n"
"void getDrawFlags(float drawFlags, out float connector_mode_0, out float connector_mode_1, out float connector_mode_2, out float connector_mode_3, out float connector_mode_4, out float drawBackgroundOutline, out float drawBackground, out float drawConnector){\n"
"connector_mode_4 = step(64., mod(drawFlags, 128.));\n"
"connector_mode_3 = step(32., mod(drawFlags, 64.));\n"
"connector_mode_2 = step(16., mod(drawFlags, 32.));\n"
"connector_mode_1 = step(8., mod(drawFlags, 16.));\n"
"drawBackgroundOutline = step(4., mod(drawFlags, 8.));\n"
"drawBackground = step(2., mod(drawFlags, 4.));\n"
"drawConnector = step(1., mod(drawFlags, 2.));\n"
"connector_mode_0 = 1. - step(0.5, connector_mode_1 + connector_mode_2 + connector_mode_3 + connector_mode_4);\n"
"}\n"
"void calculateConnectorInfo(vec4 a_center, vec2 tsScreen, vec2 textSize, vec2 dVector, vec2 offset, out float fog, in vec4 tCenter, in vec4 tTarget, out vec4 endpointOnBBX, out vec4 endpointExtendedOffBBX, float connector_mode_0, float connector_mode_1, float connector_mode_2, float connector_mode_3, float connector_mode_4, float extLength, float isProjected, float zValue){\n"
"vec3 eye_pos = vec3(isProjected * (g_ModelViewMatrix * a_center) + ((1.-isProjected) * a_center));\n"
"fog = (g_Fog_end - abs(eye_pos.z)) * g_Fog_scale;\n"
"vec2 eoff;\n"
"vec2 conOff;\n"
"if (connector_mode_0 > 0.)\n"
"conOff = computeConnectorOffset_0(dVector);\n"
"else if (connector_mode_1 > 0.)\n"
"conOff = computeConnectorOffset_1(dVector);\n"
"else if (connector_mode_2 > 0.)\n"
"conOff = computeConnectorOffset_2(dVector, eoff, textSize, extLength);\n"
"else if (connector_mode_3 > 0.)\n"
"conOff = computeConnectorOffset_3(dVector);\n"
"else if (connector_mode_4 > 0.)\n"
"conOff = computeConnectorOffset_4(dVector, eoff, textSize, extLength);\n"
"vec2 addXY = offset + tsScreen * conOff;\n"
"endpointOnBBX = tCenter;\n"
"endpointOnBBX.xy = endpointOnBBX.xy + addXY;\n"
"endpointOnBBX.z = zValue;\n"
"endpointExtendedOffBBX = tCenter;\n"
"endpointExtendedOffBBX.xy = endpointExtendedOffBBX.xy + offset + tsScreen * eoff;\n"
"endpointExtendedOffBBX.z = zValue;\n"
"}\n"
,
"connector.vs", ""
"attribute vec4 a_target_pt3d;\n"
"attribute vec4 a_center_pt3d;\n"
"attribute vec3 a_indentFactor;\n"
"attribute vec3 a_screenWorldOffset;\n"
"attribute vec2 a_textSize;\n"
"attribute vec4 a_Color;\n"
"attribute float a_relative_mode;\n"
"attribute float a_draw_flags;\n"
"attribute vec4 a_bkgrd_color;\n"
"attribute float a_rel_ext_length;\n"
"attribute float a_con_width;\n"
"varying vec4 COLORIn;\n"
"#ifdef use_geometry_shaders\n"
"varying vec4 a_center;\n"
"varying vec4 a_target;\n"
"varying vec2 a_textSizeIn;\n"
"varying vec3 a_screenWorldOffsetIn;\n"
"varying vec2 a_indentFactorIn;\n"
"varying float a_relative_modeIn;\n"
"varying float a_draw_flagsIn;\n"
"varying vec4 a_bkgrd_colorIn;\n"
"varying float a_rel_ext_lengthIn;\n"
"varying float a_con_widthIn;\n"
"varying vec4 COLOR;\n"
"varying float lineEdge;\n"
"varying float aaCutoff;\n"
"#else\n"
"attribute float a_isCenterPt;\n"
"#endif\n"
"varying vec3 NORMAL;\n"
"varying float fog;\n"
"varying vec2 bgTextureLookup;\n"
"#define E 2.718281828459045\n"
"uniform vec2 screenSize;\n"
"uniform float screenOriginVertexScale;\n"
"uniform float labelTextureSize;\n"
"uniform float front;\n"
"uniform float clipRange;\n"
"float PI = 3.14159265358979323846264;\n"
"#include connector.shared\n"
"vec4 getGLPosition(vec4 endpointOnBBX, vec4 transformedTarget, vec4 endpointExtendedOffBBX, float connector_mode_2_4){\n"
"#ifdef use_geometry_shaders\n"
"float a_isCenterPt = 1.;\n"
"#endif\n"
"float isExtended = step(1.5, a_isCenterPt);\n"
"float isTarget = (1.-isExtended) * step(.5, a_isCenterPt );\n"
"float isCenter = (1.-isTarget) * (1.-isExtended);\n"
"return connector_mode_2_4 * ( (isCenter * endpointOnBBX) + (isTarget * transformedTarget) + (isExtended * endpointExtendedOffBBX)) +\n"
"(1.-connector_mode_2_4) * ( (step(.5,a_isCenterPt) * endpointOnBBX) + (1.-step(.5,a_isCenterPt)) * transformedTarget);\n"
"}\n"
"void main()\n"
"{\n"
"#ifdef use_geometry_shaders\n"
"a_center = a_center_pt3d ;\n"
"a_target = a_target_pt3d ;\n"
"a_textSizeIn = a_textSize;\n"
"a_screenWorldOffsetIn = a_screenWorldOffset;\n"
"a_indentFactorIn = a_indentFactor.xy;\n"
"gl_Position = a_center_pt3d ;\n"
"a_relative_modeIn = a_relative_mode;\n"
"a_draw_flagsIn = a_draw_flags;\n"
"a_bkgrd_colorIn = a_bkgrd_color;\n"
"a_rel_ext_lengthIn = a_rel_ext_length;\n"
"a_con_widthIn = a_con_width;\n"
"#else\n"
"NORMAL = vec3(0.,0.,1.);\n"
"vec4 transformedCenter, transformedTarget;\n"
"vec2 textSizeInScreen, offset, drawVector;\n"
"float doNotDraw, isProjected, zValue, zTarget;\n"
"float connector_mode_0, connector_mode_1, connector_mode_2, connector_mode_3, connector_mode_4, drawBackgroundOutline, drawBackground, drawConnector, connector_mode_2_4 ;\n"
"getDrawFlags(a_draw_flags, connector_mode_0, connector_mode_1, connector_mode_2, connector_mode_3, connector_mode_4, drawBackgroundOutline, drawBackground, drawConnector);\n"
"connector_mode_2_4 = connector_mode_2 + connector_mode_4;\n"
"calculatePreConnectorInfo(a_center_pt3d, a_target_pt3d, a_textSize, a_indentFactor.xy, a_screenWorldOffset, transformedCenter, transformedTarget, textSizeInScreen, offset, drawVector, doNotDraw, a_relative_mode, isProjected, zValue, a_con_width, zTarget);\n"
"vec4 endpointOnBBX, endpointExtendedOffBBX;\n"
"calculateConnectorInfo(a_center_pt3d, textSizeInScreen, a_textSize, drawVector, offset, fog, transformedCenter, transformedTarget, endpointOnBBX, endpointExtendedOffBBX, connector_mode_0, connector_mode_1, connector_mode_2, connector_mode_3, connector_mode_4, a_rel_ext_length, isProjected, zValue);\n"
"float withinView = step(zValue, 1.) * step(-1., zValue);\n"
"transformedTarget.z = withinView * transformedTarget.z + (1.-withinView) * zValue;\n"
"gl_Position = (1.-doNotDraw) * getGLPosition(endpointOnBBX, transformedTarget, endpointExtendedOffBBX, connector_mode_2_4);\n"
"bgTextureLookup = (gl_Position.xy/gl_Position.w) / 2.0 + 0.5;\n"
"#endif\n"
"COLORIn = a_Color;\n"
"}\n"
,
"copy.fs", ""
"#ifndef PYMOL_WEBGL\n"
"#version 120\n"
"#else\n"
"precision highp float;\n"
"#endif\n"
"uniform sampler2D colorTex;\n"
"varying vec2 texcoordAttr;\n"
"void main()\n"
"{\n"
"gl_FragColor = texture2D(colorTex, texcoordAttr);\n"
"}\n"
,
"copy.vs", ""
"#ifndef PYMOL_WEBGL\n"
"#version 120\n"
"#endif\n"
"uniform sampler2D colorTex;\n"
"attribute vec3 a_Vertex;\n"
"varying vec2 texcoordAttr;\n"
"void main()\n"
"{\n"
"vec2 vert = vec2((1. + a_Vertex.xy) / 2.);\n"
"texcoordAttr = vert;\n"
"gl_Position = vec4(a_Vertex.x, a_Vertex.y, 0., 1.);\n"
"}\n"
,
"cylinder.fs", ""
"#ifdef PYMOL_WEBGL_IOS\n"
"#extension GL_EXT_frag_depth : require\n"
"#endif\n"
"#include webgl_header.fs\n"
"uniform float inv_height;\n"
"uniform bool no_flat_caps;\n"
"uniform float half_bond;\n"
"uniform mat4 g_ProjectionMatrix;\n"
"uniform float g_Fog_end;\n"
"uniform float g_Fog_scale;\n"
"#include anaglyph_header.fs\n"
"varying vec3 surface_point ;\n"
"varying vec3 axis ;\n"
"varying vec3 base ;\n"
"varying vec3 end_cyl ;\n"
"varying vec3 U ;\n"
"varying vec3 V ;\n"
"varying float radius;\n"
"varying float cap;\n"
"varying float inv_sqr_height;\n"
"varying vec4 color1;\n"
"varying vec4 color2;\n"
"varying vec2 bgTextureLookup;\n"
"uniform bool lighting_enabled;\n"
"#include compute_fog_color.fs\n"
"#include compute_color_for_light.fs\n"
"/*\n"
"* Get the lowest bit from 'bits' and shift 'bits' to the right.\n"
"* Equivalent to (if 'bits' would be int):\n"
"* bit = bits & 0x1; bits >>= 1; return bit;\n"
"*/\n"
"bool get_bit_and_shift(inout float bits) {\n"
"float bit = mod(bits, 2.0);\n"
"bits = (bits - bit) / 2.0;\n"
"return bit > 0.5;\n"
"}\n"
"void main(void)\n"
"{\n"
"vec3 ray_target = surface_point;\n"
"#ifdef ortho\n"
"vec3 ray_origin = surface_point;\n"
"vec3 ray_direction = vec3(0., 0., 1.);\n"
"#else\n"
"vec3 ray_origin = vec3(0.);\n"
"vec3 ray_direction = normalize(-ray_target);\n"
"#endif\n"
"mat3 basis = mat3(U, V, axis);\n"
"vec2 P = ((ray_target - base) * basis).xy;\n"
"vec2 D = (ray_direction * basis).xy;\n"
"float radius2 = radius*radius;\n"
"float a0 = P.x*P.x + P.y*P.y - radius2;\n"
"float a1 = P.x*D.x + P.y*D.y;\n"
"float a2 = D.x*D.x + D.y*D.y;\n"
"float d = a1*a1 - a0*a2;\n"
"if (d < 0.0)\n"
"discard;\n"
"float dist = (-a1 + sqrt(d))/a2;\n"
"vec3 new_point = ray_target + dist * ray_direction;\n"
"vec3 tmp_point = new_point - base;\n"
"vec3 normal = normalize(tmp_point - axis * dot(tmp_point, axis));\n"
"/* cap :  4 bits : 1st - frontcap\n"
"2nd - endcap\n"
"3rd - frontcapround\n"
"4th - endcapround\n"
"5th - interp\n"
"*/\n"
"float fcap = cap + .001;  // to account for odd rounding issues when setting\n"
"bool frontcap      = get_bit_and_shift(fcap);\n"
"bool endcap        = get_bit_and_shift(fcap);\n"
"bool frontcapround = get_bit_and_shift(fcap) && no_flat_caps;\n"
"bool endcapround   = get_bit_and_shift(fcap) && no_flat_caps;\n"
"bool nocolorinterp = !get_bit_and_shift(fcap);\n"
"vec4 color;\n"
"float ratio = dot(new_point-base, vec3(end_cyl-base)) * inv_sqr_height;\n"
"if (isPicking || !lighting_enabled){ // for picking\n"
"ratio = step(.5, ratio);\n"
"} else if (nocolorinterp){\n"
"float dp = clamp(-half_bond*new_point.z*inv_height, 0., .5);\n"
"ratio = smoothstep(.5 - dp, .5 + dp, ratio);\n"
"} else {\n"
"ratio = clamp(ratio, 0., 1.);\n"
"}\n"
"color = mix(color1, color2, ratio);\n"
"bool cap_test_base = 0.0 > dot((new_point - base), axis);\n"
"bool cap_test_end  = 0.0 < dot((new_point - end_cyl), axis);\n"
"if (cap_test_base || cap_test_end) {\n"
"vec3 thisaxis = -axis;\n"
"vec3 thisbase = base;\n"
"if (cap_test_end) {\n"
"thisaxis = axis;\n"
"thisbase = end_cyl;\n"
"frontcap = endcap;\n"
"frontcapround = endcapround;\n"
"}\n"
"if (!frontcap)\n"
"discard;\n"
"if (frontcapround) {\n"
"vec3 sphere_direction = thisbase - ray_origin;\n"
"float b = dot(sphere_direction, ray_direction);\n"
"float pos = b*b + radius2 -dot(sphere_direction, sphere_direction);\n"
"if (pos < 0.0)\n"
"discard;\n"
"float near = sqrt(pos) + b;\n"
"new_point = near * ray_direction + ray_origin;\n"
"normal = normalize(new_point - thisbase);\n"
"} else {\n"
"float dNV = dot(thisaxis, ray_direction);\n"
"if (dNV < 0.0)\n"
"discard;\n"
"float near = dot(thisaxis, thisbase - ray_origin) / dNV;\n"
"new_point = ray_direction * near + ray_origin;\n"
"if (dot(new_point - thisbase, new_point - thisbase) > radius2)\n"
"discard;\n"
"normal = thisaxis;\n"
"}\n"
"}\n"
"vec2 clipZW = new_point.z * g_ProjectionMatrix[2].zw +\n"
"g_ProjectionMatrix[3].zw;\n"
"float depth = 0.5 + 0.5 * clipZW.x / clipZW.y;\n"
"if (depth <= 0.0)\n"
"discard;\n"
"gl_FragDepth = depth;\n"
"if (!isPicking && lighting_enabled){\n"
"color = ApplyColorEffects(color, depth);\n"
"color = ApplyLighting(color, normal);\n"
"}\n"
"if (isPicking){\n"
"gl_FragColor = color;\n"
"} else {\n"
"float fog = (g_Fog_end + new_point.z) * g_Fog_scale;\n"
"gl_FragColor = ApplyFog(color, fog);\n"
"PostLightingEffects(depth);\n"
"}\n"
"}\n"
,
"cylinder.vs", ""
"#include webgl_header.vs\n"
"attribute vec3 attr_vertex1;\n"
"attribute vec3 attr_vertex2;\n"
"attribute vec4 a_Color;\n"
"attribute vec4 a_Color2;\n"
"attribute float attr_radius;\n"
"attribute float a_cap;\n"
"attribute float attr_flags;\n"
"varying vec3 surface_point ;\n"
"varying vec3 axis ;\n"
"varying vec3 base ;\n"
"varying vec3 end_cyl ;\n"
"varying vec3 U ;\n"
"varying vec3 V ;\n"
"varying float radius;\n"
"varying float cap;\n"
"varying float inv_sqr_height;\n"
"varying vec4 color1;\n"
"varying vec4 color2;\n"
"varying vec2 bgTextureLookup;\n"
"uniform float uni_radius;\n"
"float get_bit_and_shift(inout float bits) {\n"
"float bit = mod(bits, 2.0);\n"
"bits = (bits - bit) / 2.0;\n"
"return step(.5, bit);\n"
"}\n"
"void main(void)\n"
"{\n"
"float uniformglscale = length(g_NormalMatrix[0]);\n"
"if (uni_radius!=0.0){\n"
"radius = uni_radius * attr_radius;\n"
"} else {\n"
"radius = attr_radius;\n"
"}\n"
"color1 = a_Color;\n"
"color2 = a_Color2;\n"
"vec3 attr_axis = attr_vertex2 - attr_vertex1;\n"
"cap = a_cap;\n"
"inv_sqr_height = length(attr_axis) / uniformglscale;\n"
"inv_sqr_height *= inv_sqr_height;\n"
"inv_sqr_height = 1.0 / inv_sqr_height;\n"
"vec3 h = normalize(attr_axis);\n"
"axis = normalize(g_NormalMatrix * h);\n"
"vec3 u = cross(h, vec3(1.0, 0.0, 0.0));\n"
"if (dot(u,u) < 0.001)\n"
"u = cross(h, vec3(0.0, 1.0, 0.0));\n"
"u = normalize(u);\n"
"vec3 v = normalize(cross(u, h));\n"
"U = normalize(g_NormalMatrix * u);\n"
"V = normalize(g_NormalMatrix * v);\n"
"vec4 base4 = g_ModelViewMatrix * vec4(attr_vertex1, 1.0);\n"
"base = base4.xyz;\n"
"vec4 end4 = g_ModelViewMatrix * vec4(attr_vertex2, 1.0);\n"
"end_cyl = end4.xyz;\n"
"vec4 vertex = vec4(attr_vertex1, 1.0);\n"
"float packed_flags = attr_flags;\n"
"float out_v = get_bit_and_shift(packed_flags);\n"
"float up_v = get_bit_and_shift(packed_flags);\n"
"float right_v = get_bit_and_shift(packed_flags);\n"
"vertex.xyz += up_v * attr_axis;\n"
"vertex.xyz += (2.0 * right_v - 1.0) * radius * u;\n"
"vertex.xyz += (2.0 * out_v - 1.0) * radius * v;\n"
"vertex.xyz += (2.0 * up_v - 1.0) * radius * h;\n"
"vec4 tvertex = g_ModelViewMatrix * vertex;\n"
"surface_point = tvertex.xyz;\n"
"gl_Position = g_ProjectionMatrix * g_ModelViewMatrix * vertex;\n"
"radius /= uniformglscale;\n"
"if (gl_Position.z / gl_Position.w < -1.0) {\n"
"float diff = abs(base4.z - end4.z) + radius * 3.5;\n"
"vec4 inset = g_ModelViewMatrix * vertex;\n"
"inset.z -= diff;\n"
"inset = g_ProjectionMatrix * inset;\n"
"if (inset.z / inset.w > -1.0) {\n"
"gl_Position.z = -gl_Position.w;\n"
"}\n"
"}\n"
"bgTextureLookup = (gl_Position.xy/gl_Position.w) / 2.0 + 0.5;\n"
"}\n"
,
"default.fs", ""
"#include webgl_header.fs\n"
"varying vec3 packed_data_0 ;\n"
"varying float fog;\n"
"varying vec2 bgTextureLookup;\n"
"#ifdef PURE_OPENGL_ES_2\n"
"varying vec4 COLOR;\n"
"#else\n"
"#define COLOR gl_Color\n"
"#endif\n"
"#define NORMAL normalize(packed_data_0.xyz)\n"
"uniform bool lighting_enabled;\n"
"uniform bool two_sided_lighting_enabled;\n"
"#include anaglyph_header.fs\n"
"#include compute_fog_color.fs\n"
"#include compute_color_for_light.fs\n"
"void main()\n"
"{\n"
"vec4 color = ApplyColorEffects(COLOR, gl_FragCoord.z);\n"
"if (!isPicking && lighting_enabled){\n"
"vec3 normal = NORMAL;\n"
"if (two_sided_lighting_enabled){\n"
"bool ff = gl_FrontFacing ? true : false;\n"
"if (!ff)\n"
"normal = -normal;\n"
"}\n"
"color = ApplyLighting(color, normal);\n"
"}\n"
"gl_FragColor = ApplyFog(color, fog);\n"
"PostLightingEffects();\n"
"}\n"
,
"default.vs", ""
"#include webgl_header.vs\n"
"attribute vec4 a_Vertex;\n"
"attribute vec3 a_Normal;\n"
"attribute vec4 a_Color;\n"
"varying vec3 packed_data_0 ;\n"
"#define NORMAL  packed_data_0\n"
"#ifdef PURE_OPENGL_ES_2\n"
"varying vec4 COLOR;\n"
"#else\n"
"#define COLOR gl_FrontColor = gl_BackColor\n"
"#endif\n"
"varying float fog;\n"
"varying vec2 bgTextureLookup;\n"
"void main()\n"
"{\n"
"#ifdef PYMOL_WEBGL_IOS\n"
"gl_PointSize = g_PointSize;\n"
"#endif\n"
"NORMAL = normalize(g_NormalMatrix * a_Normal);\n"
"vec3 eye_pos = vec3(g_ModelViewMatrix * a_Vertex);\n"
"COLOR = a_Color;\n"
"fog = (g_Fog_end + eye_pos.z) * g_Fog_scale;\n"
"gl_Position = g_ProjectionMatrix * g_ModelViewMatrix * a_Vertex;\n"
"bgTextureLookup = (gl_Position.xy/gl_Position.w) / 2.0 + 0.5;\n"
"}\n"
,
"indicator.fs", ""
"#include webgl_header.fs\n"
"#ifdef PYMOL_WEBGL_IOS\n"
"precision highp float;\n"
"#else\n"
"#version 120\n"
"#endif\n"
"uniform sampler2D textureMap;\n"
"uniform vec2 textureLookup ;\n"
"uniform vec2 textureScale ;\n"
"uniform float g_pointSize;\n"
"uniform vec4 viewport;\n"
"#include anaglyph_header.fs\n"
"varying vec4 POS;\n"
"/*\n"
"* On graphics drivers which are not buggy, this should be\n"
"* equivalent to gl_PointCoord.\n"
"*/\n"
"vec2 get_pointcoord() {\n"
"vec2 p = viewport.xy + 0.5 * (POS.xy / POS.w + 1.0) * viewport.zw;\n"
"return (gl_FragCoord.xy - p) / g_pointSize + 0.5;\n"
"}\n"
"void main()\n"
"{\n"
"gl_FragColor = texture2D(textureMap, textureLookup + get_pointcoord() * textureScale);\n"
"PostLightingEffects();\n"
"}\n"
,
"indicator.vs", ""
"#ifdef PYMOL_WEBGL_IOS\n"
"precision highp float;\n"
"#else\n"
"#version 120\n"
"#endif\n"
"#include webgl_header.vs\n"
"attribute vec4 a_Vertex;\n"
"attribute vec4 a_Color;\n"
"varying vec4 COLOR;\n"
"varying vec4 POS;\n"
"uniform float g_pointSize;\n"
"void main()\n"
"{\n"
"COLOR = a_Color;\n"
"gl_PointSize = g_pointSize;\n"
"gl_Position = g_ProjectionMatrix * g_ModelViewMatrix * a_Vertex;\n"
"POS = gl_Position;\n"
"}\n"
,
"label.fs", ""
"#include webgl_header.fs\n"
"#ifdef PURE_OPENGL_ES_2\n"
"precision highp float;\n"
"#endif\n"
"/* ios recent */\n"
"uniform sampler2D textureMap;\n"
"varying vec2 textureLookup ;\n"
"varying vec4 pickcolor ;\n"
"varying float fog;\n"
"varying vec3 normalizedViewCoordinate;\n"
"#define bgTextureLookup normalizedViewCoordinate.xy\n"
"#include anaglyph_header.fs\n"
"#include compute_fog_color.fs\n"
"void main()\n"
"{\n"
"if (isPicking) {\n"
"gl_FragColor = pickcolor;\n"
"} else {\n"
"gl_FragColor = texture2D(textureMap, textureLookup);\n"
"#ifdef PYMOL_IOS\n"
"if (gl_FragColor.a < .1)\n"
"discard;\n"
"#else\n"
"if (gl_FragColor.a < .05)\n"
"discard;\n"
"#endif\n"
"gl_FragColor = ApplyColorEffects(gl_FragColor, gl_FragCoord.z);\n"
"gl_FragColor = ApplyFog(gl_FragColor, fog);\n"
"#ifdef NO_ORDER_TRANSP\n"
"setFragDataForNoOrderTransp(gl_FragCoord.z);\n"
"#endif\n"
"}\n"
"}\n"
,
"label.vs", ""
"#ifdef PURE_OPENGL_ES_2\n"
"precision highp float;\n"
"#endif\n"
"#include webgl_header.vs\n"
"attribute vec4 attr_targetpos;\n"
"attribute vec4 attr_worldpos;\n"
"attribute vec3 attr_screenoffset;\n"
"attribute vec2 attr_texcoords;\n"
"attribute vec3 attr_screenworldoffset;\n"
"attribute vec4 attr_pickcolor;\n"
"attribute float attr_relative_mode;\n"
"varying vec2 textureLookup ;\n"
"varying vec3 normalizedViewCoordinate;\n"
"varying vec4 pickcolor ;\n"
"uniform vec2 screenSize;\n"
"uniform float screenOriginVertexScale;\n"
"uniform float scaleByVertexScale;\n"
"uniform float labelTextureSize;\n"
"varying float fog;\n"
"uniform float front;\n"
"uniform float clipRange;\n"
"vec4 normalizeVec4(vec4 point){\n"
"return vec4(point.xyz/point.w, 1.);\n"
"}\n"
"float convertNormalZToScreenZ(float normalz){\n"
"float a_centerN = (normalz + 1.) / 2.;\n"
"float ptInPreProjectionZ = -(front + clipRange * a_centerN);\n"
"vec4 ptInPreProjection = vec4(0., 0., ptInPreProjectionZ, 1.);\n"
"vec4 projVect = g_ProjectionMatrix * ptInPreProjection;\n"
"return projVect.z / projVect.w;\n"
"}\n"
"void main()\n"
"{\n"
"float drawConnector, isProjected, isScreenCoord, isPixelCoord, zTarget;\n"
"drawConnector = step(1., mod(attr_relative_mode, 2.));\n"
"isScreenCoord = step(2., mod(attr_relative_mode, 4.));\n"
"isPixelCoord = step(4., mod(attr_relative_mode, 8.));\n"
"zTarget = step(8., mod(attr_relative_mode, 16.));\n"
"isProjected = step(isPixelCoord + isScreenCoord, 0.5);\n"
"vec3 viewVector = vec3(vec4(0.,0.,-1.,0.) * g_ModelViewMatrix);\n"
"float sovx = screenOriginVertexScale;\n"
"#ifdef openvr_enabled\n"
"vec3 camPos = vec4(gl_ModelViewMatrixInverse * vec4(0.,0.,0.,1.)).xyz;\n"
"viewVector = normalize(attr_worldpos.xyz - camPos);\n"
"sovx = 1.0 / 2.0;\n"
"#endif\n"
"float screenVertexScale = scaleByVertexScale * sovx * labelTextureSize + (1. - scaleByVertexScale);\n"
"vec4 transformedPosition = g_ProjectionMatrix * g_ModelViewMatrix * attr_worldpos;\n"
"vec4 targetPosition = normalizeVec4(g_ProjectionMatrix * g_ModelViewMatrix * attr_targetpos);\n"
"transformedPosition.xyz = transformedPosition.xyz/transformedPosition.w;\n"
"transformedPosition.xy = ( floor(transformedPosition.xy * screenSize + .5 ) + .5 ) / screenSize;\n"
"vec4 a_center = (attr_worldpos + attr_screenworldoffset.z * vec4(viewVector, 0.));\n"
"vec4 transformedPositionZ = g_ProjectionMatrix * g_ModelViewMatrix * a_center;\n"
"transformedPositionZ.xyz = transformedPositionZ.xyz/transformedPositionZ.w;\n"
"transformedPositionZ.w = 1.;\n"
"vec2 pixOffset = ((2. * attr_worldpos.xy / screenSize) - 1.);\n"
"transformedPosition = isProjected * transformedPosition + isScreenCoord * attr_worldpos + isPixelCoord * vec4(pixOffset.x, pixOffset.y, -0.5, 0.);\n"
"transformedPosition.xy = transformedPosition.xy + attr_screenworldoffset.xy/(screenSize*sovx);\n"
"transformedPosition.z = (1.-zTarget) * ((isProjected * transformedPositionZ.z) + (1.-isProjected) * convertNormalZToScreenZ(attr_worldpos.z)) + zTarget * targetPosition.z;\n"
"transformedPosition.xy += attr_screenoffset.xy * 2./(screenSize.xy*screenVertexScale);\n"
"transformedPosition.w = 1.;\n"
"gl_Position = transformedPosition;\n"
"textureLookup = attr_texcoords;\n"
"normalizedViewCoordinate = (gl_Position.xyz/gl_Position.w) / 2.0 + 0.5;\n"
"#ifdef depth_cue\n"
"vec3 eye_pos = mix(attr_worldpos, g_ModelViewMatrix * attr_worldpos, isProjected).xyz;\n"
"fog = (g_Fog_end + eye_pos.z) * g_Fog_scale;\n"
"fog = max(fog, 0.0);\n"
"#else\n"
"fog = 1.1; // >= 1.0\n"
"#endif\n"
"pickcolor = attr_pickcolor;\n"
"}\n"
,
"line.fs", ""
"#include webgl_header.fs\n"
"#define bgTextureLookup a_bgTextureLookup\n"
"varying vec3 a_NORMAL ;\n"
"varying vec4 a_COLOR ;\n"
"varying vec4 a_COLOR2 ;\n"
"varying vec4 a_COLOR_INTERP ;\n"
"varying float a_INTERPOLATE;\n"
"varying float a_LINE_POSITION;\n"
"varying float a_fog;\n"
"varying vec2 a_bgTextureLookup;\n"
"uniform bool lighting_enabled;\n"
"uniform bool two_sided_lighting_enabled;\n"
"#include anaglyph_header.fs\n"
"#include compute_fog_color.fs\n"
"#include compute_color_for_light.fs\n"
"void main()\n"
"{\n"
"float whichColor = step(.5, a_LINE_POSITION);\n"
"vec4 color_step = whichColor * a_COLOR2 / a_LINE_POSITION + (1.-whichColor) * a_COLOR / (1.-a_LINE_POSITION);\n"
"vec4 icolor = a_INTERPOLATE * a_COLOR_INTERP + (1.-a_INTERPOLATE) * color_step;\n"
"vec4 color = ApplyColorEffects(icolor, gl_FragCoord.z);\n"
"if (!isPicking && lighting_enabled){\n"
"vec3 normal = a_NORMAL;\n"
"if (two_sided_lighting_enabled){\n"
"bool ff = gl_FrontFacing ? true : false;\n"
"if (!ff)\n"
"normal = -normal;\n"
"}\n"
"color = ApplyLighting(color, normal);\n"
"}\n"
"gl_FragColor = ApplyFog(color, a_fog);\n"
"PostLightingEffects();\n"
"}\n"
,
"line.vs", ""
"#ifndef PYMOL_WEBGL_IOS\n"
"#ifdef gl_VertexID_enabled\n"
"#extension GL_EXT_gpu_shader4 : require\n"
"#endif\n"
"#endif\n"
"#include webgl_header.vs\n"
"attribute vec4 a_Vertex;\n"
"attribute vec3 a_Normal;\n"
"attribute vec4 a_Color;\n"
"attribute float a_interpolate;\n"
"#ifndef gl_VertexID_enabled\n"
"attribute float a_line_position;\n"
"#endif\n"
"#define a_VERTEX gl_Position\n"
"varying vec3 a_NORMAL ;\n"
"varying vec4 a_COLOR ;\n"
"varying vec4 a_COLOR2 ;\n"
"varying vec4 a_COLOR_INTERP ;\n"
"varying float a_INTERPOLATE ;\n"
"varying float a_LINE_POSITION ;\n"
"varying float a_fog;\n"
"#define bgTextureLookup a_bgTextureLookup\n"
"varying vec2 a_bgTextureLookup;\n"
"uniform bool isPicking;\n"
"void main()\n"
"{\n"
"#ifdef PYMOL_WEBGL_IOS\n"
"gl_PointSize = g_PointSize;\n"
"#endif\n"
"vec3 eye_pos = vec3(g_ModelViewMatrix * a_Vertex);\n"
"a_INTERPOLATE = isPicking ? 0. : a_interpolate;\n"
"#ifdef gl_VertexID_enabled\n"
"a_LINE_POSITION = mod(float(gl_VertexID), 2.);\n"
"#else\n"
"a_LINE_POSITION = a_line_position;\n"
"#endif\n"
"a_VERTEX = g_ProjectionMatrix * g_ModelViewMatrix * a_Vertex;\n"
"a_NORMAL = normalize(g_NormalMatrix * a_Normal);\n"
"a_COLOR_INTERP = a_Color;\n"
"a_COLOR = (1.-a_LINE_POSITION) * a_Color ;\n"
"a_COLOR2 = a_LINE_POSITION * a_Color;\n"
"a_fog = (g_Fog_end + eye_pos.z) * g_Fog_scale;\n"
"a_bgTextureLookup = (gl_Position.xy/gl_Position.w) / 2.0 + 0.5;\n"
"}\n"
,
"oit.fs", ""
"#ifndef PYMOL_WEBGL\n"
"#version 120\n"
"#else\n"
"precision highp float;\n"
"#endif\n"
"uniform sampler2D accumTex;\n"
"uniform sampler2D revealageTex;\n"
"uniform float isRight;\n"
"varying vec2 texcoordAttr;\n"
"#define texture texture2D\n"
"void main()\n"
"{\n"
"vec4 accum = texture(accumTex, texcoordAttr).rgba;\n"
"float r = accum.a;\n"
"#ifdef ANAGLYPH\n"
"#ifdef GLEW_VERSION_3_0\n"
"accum.a = texture(revealageTex, texcoordAttr).r;\n"
"#else\n"
"vec2 sum = texture(revealageTex, texcoordAttr).rg;\n"
"accum.a = (1.-isRight) * sum.x + isRight * sum.y;\n"
"#endif\n"
"#else\n"
"accum.a = texture(revealageTex, texcoordAttr).r;\n"
"#endif\n"
"gl_FragColor = vec4(accum.rgb / clamp(accum.a, 1e-4, 5e4), r);\n"
"}\n"
,
"oit.vs", ""
"#ifndef PYMOL_WEBGL\n"
"#version 120\n"
"#endif\n"
"attribute vec3 a_Vertex;\n"
"varying vec2 texcoordAttr;\n"
"void main()\n"
"{\n"
"vec2 vert = vec2((1. + a_Vertex.xy) / 2.);\n"
"texcoordAttr = vert;\n"
"gl_Position = vec4(a_Vertex.x, a_Vertex.y, 0., 1.);\n"
"}\n"
,
"ramp.fs", ""
"#ifdef PURE_OPENGL_ES_2\n"
"precision lowp float;\n"
"#endif\n"
"varying vec4 COLOR ;\n"
"varying vec3 NORMAL ;\n"
"void main()\n"
"{\n"
"float NdotV = dot(NORMAL, vec3(0.,0.,1.));\n"
"gl_FragColor = vec4(NdotV * COLOR.xyz, COLOR.a);\n"
"#ifdef ANAGLYPH\n"
"gl_FragColor.rgb = vec3((gl_FragColor.r + gl_FragColor.b + gl_FragColor.g) / 3.);\n"
"#endif\n"
"}\n"
,
"ramp.vs", ""
"#include webgl_header.vs\n"
"attribute vec4 a_Vertex;\n"
"attribute vec4 a_Color;\n"
"attribute vec3 a_Normal;\n"
"varying vec4 COLOR ;\n"
"varying vec3 NORMAL ;\n"
"uniform vec3 offsetPt;\n"
"void main()\n"
"{\n"
"COLOR = a_Color;\n"
"NORMAL = a_Normal;\n"
"vec4 vertex = a_Vertex + vec4(offsetPt,0.);\n"
"gl_Position = g_ProjectionMatrix * vertex;\n"
"}\n"
,
"screen.fs", ""
"#ifdef PURE_OPENGL_ES_2\n"
"precision highp float;\n"
"#endif\n"
"/* ios recent */\n"
"uniform sampler2D textureMap;\n"
"varying vec4 backgroundColor;\n"
"varying vec2 textureLookup ;\n"
"void main()\n"
"{\n"
"vec4 fColor = texture2D(textureMap, textureLookup);\n"
"vec4 bColor = backgroundColor * (1.-fColor.a);\n"
"gl_FragColor = vec4(bColor.rgb + fColor.rgb * fColor.a, bColor.a + fColor.a );\n"
"#ifdef ANAGLYPH\n"
"gl_FragColor.rgb = vec3((gl_FragColor.r + gl_FragColor.b + gl_FragColor.g) / 3.);\n"
"#endif\n"
"}\n"
,
"screen.vs", ""
"#ifdef PURE_OPENGL_ES_2\n"
"precision highp float;\n"
"#endif\n"
"attribute vec3 attr_screenoffset;\n"
"attribute vec2 attr_texcoords;\n"
"attribute vec4 attr_backgroundcolor;\n"
"varying vec2 textureLookup ;\n"
"varying vec4 backgroundColor;\n"
"uniform vec2 t2PixelSize;\n"
"void main()\n"
"{\n"
"vec4 transformedPosition = vec4(attr_screenoffset.x * t2PixelSize.x - 1.,\n"
"attr_screenoffset.y * t2PixelSize.y - 1.,\n"
".9, 1.);\n"
"gl_Position = transformedPosition;\n"
"backgroundColor = attr_backgroundcolor;\n"
"textureLookup = attr_texcoords;\n"
"}\n"
,
"sphere.fs", ""
"#ifdef PYMOL_WEBGL_IOS\n"
"#extension GL_EXT_frag_depth : require\n"
"#endif\n"
"#include webgl_header.fs\n"
"varying vec4 COLOR;\n"
"varying vec3 sphere_center;\n"
"varying float radius2;\n"
"varying vec3 point;\n"
"varying vec2 bgTextureLookup;\n"
"uniform bool lighting_enabled;\n"
"uniform mat4 g_ProjectionMatrix;\n"
"uniform float g_Fog_end;\n"
"uniform float g_Fog_scale;\n"
"#include anaglyph_header.fs\n"
"#include compute_fog_color.fs\n"
"#include compute_color_for_light.fs\n"
"void main(void)\n"
"{\n"
"#ifdef ortho\n"
"vec3 ray_origin = point;\n"
"vec3 ray_direction = vec3(0., 0., -1.);\n"
"vec3 sphere_direction = ray_origin - sphere_center;\n"
"#else\n"
"vec3 ray_origin = vec3(0., 0., 0.);\n"
"vec3 ray_direction = normalize(point);\n"
"vec3 sphere_direction = sphere_center;\n"
"#endif\n"
"float b = dot(sphere_direction, ray_direction);\n"
"float position = b * b + radius2 - dot(sphere_direction, sphere_direction);\n"
"if (position < 0.0)\n"
"discard;\n"
"float nearest = b - sqrt(position);\n"
"vec3 ipoint = nearest * ray_direction + ray_origin;\n"
"vec3 normal = normalize(ipoint - sphere_center);\n"
"vec2 clipZW = ipoint.z * g_ProjectionMatrix[2].zw +\n"
"g_ProjectionMatrix[3].zw;\n"
"float depth = 0.5 + 0.5 * clipZW.x / clipZW.y;\n"
"/*\n"
"float isDiscarded = step(.5, step(depth, 0.) + step(1.-depth, 0.));\n"
"if (isDiscarded > 0.0)\n"
"discard;\n"
"*/\n"
"if (depth <= 0.0 || depth >= 1.0)\n"
"discard;\n"
"gl_FragDepth = depth;\n"
"if (!isPicking){\n"
"if (lighting_enabled){\n"
"vec4 color = ApplyColorEffects(COLOR, depth);\n"
"color = ApplyLighting(color, normal);\n"
"float fogv = (g_Fog_end + ipoint.z) * g_Fog_scale;\n"
"gl_FragColor = ApplyFog(color, fogv);\n"
"} else {\n"
"gl_FragColor = COLOR;\n"
"}\n"
"PostLightingEffects(depth);\n"
"} else {\n"
"if (COLOR.a == 0.0) {\n"
"discard;\n"
"}\n"
"gl_FragColor = COLOR;\n"
"}\n"
"}\n"
,
"sphere.vs", ""
"#include webgl_header.vs\n"
"uniform float sphere_size_scale;\n"
"attribute vec4 a_vertex_radius;\n"
"attribute vec4 a_Color;\n"
"attribute float a_rightUpFlags;\n"
"varying vec4 COLOR;\n"
"varying vec3 sphere_center;\n"
"varying float radius2;\n"
"varying vec3 point;\n"
"varying vec2 bgTextureLookup;\n"
"/*\n"
"* horizontial and vertical adjustment of outer tangent hitting the\n"
"* impostor quad, in model view space.\n"
"*/\n"
"vec2 outer_tangent_adjustment(vec3 center, float radius_sq) {\n"
"vec2 xy_dist = vec2(length(center.xz), length(center.yz));\n"
"vec2 cos_a = clamp(center.z / xy_dist, -1., 1.);\n"
"vec2 cos_b = xy_dist / sqrt(radius_sq + (xy_dist * xy_dist));\n"
"vec2 cos_ab = (cos_a * cos_b + sqrt(\n"
"(1. - cos_a * cos_a) *\n"
"(1. - cos_b * cos_b)));\n"
"vec2 cos_ab_sq = cos_ab * cos_ab;\n"
"vec2 tan_ab_sq = (1. - cos_ab_sq) / cos_ab_sq;\n"
"vec2 adjustment = sqrt(tan_ab_sq + 1.);\n"
"return min(adjustment, 10.);\n"
"}\n"
"void main(void)\n"
"{\n"
"float radius = a_vertex_radius.w * sphere_size_scale;\n"
"radius /= length(g_NormalMatrix[0]);\n"
"float right = -1. + 2.*mod(a_rightUpFlags, 2.);\n"
"float up = -1. + 2.*floor(mod(a_rightUpFlags/2., 2.));\n"
"vec4 tmppos = g_ModelViewMatrix * vec4(a_vertex_radius.xyz, 1.);\n"
"COLOR = a_Color;\n"
"radius2 = radius * radius; // compute squared radius\n"
"vec2 corner_offset = vec2(right, up);\n"
"#ifndef ortho\n"
"corner_offset *= outer_tangent_adjustment(tmppos.xyz, radius2);\n"
"#endif\n"
"vec4 eye_space_pos = tmppos;\n"
"eye_space_pos.xy += radius * corner_offset;\n"
"sphere_center = tmppos.xyz / tmppos.w;\n"
"point = eye_space_pos.xyz / eye_space_pos.w;\n"
"#ifndef PYMOL_WEBGL_IOS\n"
"gl_ClipVertex = eye_space_pos;\n"
"#endif\n"
"gl_Position = g_ProjectionMatrix * eye_space_pos;\n"
"bgTextureLookup = (gl_Position.xy/gl_Position.w) / 2.0 + 0.5;\n"
"}\n"
,
"surface.fs", ""
"#include webgl_header.fs\n"
"varying vec3 packed_data_0 ;\n"
"varying float fog;\n"
"varying vec2 bgTextureLookup;\n"
"#ifdef PURE_OPENGL_ES_2\n"
"varying vec4 COLOR;\n"
"#else\n"
"#define COLOR gl_Color\n"
"#endif\n"
"#define NORMAL normalize(packed_data_0.xyz)\n"
"uniform bool lighting_enabled;\n"
"uniform bool two_sided_lighting_enabled;\n"
"uniform vec4 interior_color;\n"
"uniform bool use_interior_color;\n"
"#include anaglyph_header.fs\n"
"#include compute_fog_color.fs\n"
"#include compute_color_for_light.fs\n"
"void main()\n"
"{\n"
"if (isPicking){\n"
"gl_FragColor = COLOR; // no lighting\n"
"} else {\n"
"bool is_interior = gl_FrontFacing ? false : true;\n"
"vec3 normal = NORMAL;\n"
"if (use_interior_color && is_interior) {\n"
"gl_FragColor = vec4(interior_color.rgb, COLOR.a);\n"
"} else {\n"
"if (is_interior) {\n"
"if (two_sided_lighting_enabled) {\n"
"normal = -normal;\n"
"} else {\n"
"normal = vec3(0.);\n"
"}\n"
"}\n"
"vec4 color = ApplyColorEffects(COLOR, gl_FragCoord.z);\n"
"color = ApplyLighting(color, normal);\n"
"gl_FragColor = ApplyFog(color, fog);\n"
"}\n"
"PostLightingEffects();\n"
"}\n"
"}\n"
,
"surface.vs", ""
"#include webgl_header.vs\n"
"uniform bool isPicking;\n"
"attribute vec4 a_Vertex;\n"
"attribute vec3 a_Normal;\n"
"attribute vec4 a_Color;\n"
"attribute float a_Accessibility; /* This is for ambient occlusion, 1.0 by default */\n"
"varying vec3 packed_data_0 ;\n"
"varying vec4 packed_data_1 ;\n"
"varying vec4 packed_data_2 ;\n"
"varying vec4 packed_data_4 ;\n"
"#define NORMAL  packed_data_0\n"
"#ifdef PURE_OPENGL_ES_2\n"
"varying vec4 COLOR;\n"
"#else\n"
"#define COLOR gl_FrontColor\n"
"#endif\n"
"#define E 2.718281828459045\n"
"/* this doesn't work for setting fog_color, need to set the values independently */\n"
"varying float fog;\n"
"varying vec2 bgTextureLookup;\n"
"uniform bool lighting_enabled;\n"
"uniform float ambient_occlusion_scale;\n"
"uniform int accessibility_mode;\n"
"uniform float accessibility_mode_on;\n"
"void main()\n"
"{\n"
"NORMAL = normalize(g_NormalMatrix * a_Normal);\n"
"vec3 eye_pos = vec3(g_ModelViewMatrix * a_Vertex);\n"
"#ifdef PYMOL_WEBGL_IOS\n"
"gl_PointSize = g_PointSize;\n"
"#endif\n"
"if (isPicking){\n"
"COLOR = a_Color; // no lighting\n"
"} else {\n"
"vec4 COLORa;\n"
"if (accessibility_mode == 1){\n"
"COLORa = vec4(clamp(a_Color.xyz * (1.-(ambient_occlusion_scale*a_Accessibility)), 0., 1.), a_Color.w);\n"
"} else if (accessibility_mode == 2){\n"
"COLORa = vec4(a_Color.xyz * cos(90.*radians(clamp(ambient_occlusion_scale*a_Accessibility, 0., 1.))), a_Color.w);\n"
"} else {\n"
"COLORa = vec4(clamp(a_Color.xyz * (1. / (1. + pow(E, 0.5 * ( (ambient_occlusion_scale * a_Accessibility) - 10.)))), 0., 1.), a_Color.w);\n"
"}\n"
"COLOR = mix(a_Color, COLORa, accessibility_mode_on);\n"
"fog = (g_Fog_end + eye_pos.z) * g_Fog_scale;\n"
"}\n"
"gl_Position = g_ProjectionMatrix * g_ModelViewMatrix * a_Vertex;\n"
"bgTextureLookup = (gl_Position.xy/gl_Position.w) / 2.0 + 0.5;\n"
"}\n"
,
"trilines.fs", ""
"#include webgl_header.fs\n"
"#ifdef PURE_OPENGL_ES_2\n"
"precision highp float;\n"
"#endif\n"
"#ifdef line_smooth\n"
"uniform float line_width;\n"
"varying float centerdist;\n"
"#endif\n"
"varying vec4 COLOR;\n"
"varying vec4 COLOR2;\n"
"varying float a_INTERPOLATE;\n"
"varying float fog;\n"
"varying vec2 bgTextureLookup;\n"
"varying float whichEnd;\n"
"#include anaglyph_header.fs\n"
"#include compute_fog_color.fs\n"
"void main(void) {\n"
"float which = mix(step(0.5, whichEnd), whichEnd, a_INTERPOLATE);\n"
"vec4 BCOLOR = mix(COLOR, COLOR2, which);\n"
"vec4 color = ApplyColorEffects(BCOLOR, gl_FragCoord.z);\n"
"#ifdef line_smooth\n"
"const float margin = 1.5;\n"
"if (!isPicking)\n"
"color.a *= (1. - max(0.,\n"
"(abs(centerdist) - line_width + margin) / margin));\n"
"#endif\n"
"gl_FragColor = ApplyFog(color, fog);\n"
"PostLightingEffectsNoOIT();\n"
"}\n"
,
"trilines.vs", ""
"#include webgl_header.vs\n"
"attribute vec3 a_Vertex;\n"
"attribute vec3 a_OtherVertex;\n"
"attribute float a_UV;\n"
"attribute vec4 a_Color;\n"
"attribute vec4 a_Color2;\n"
"attribute float a_interpolate;\n"
"uniform vec2 inv_dimensions;\n"
"uniform float line_width;\n"
"uniform bool isPicking;\n"
"varying vec4 COLOR;\n"
"varying vec4 COLOR2;\n"
"varying float a_INTERPOLATE;\n"
"varying float fog;\n"
"varying vec2 bgTextureLookup;\n"
"varying float centerdist;\n"
"varying float whichEnd;\n"
"void main(void) {\n"
"vec2 UV;\n"
"UV.y = mod(a_UV, 2.0);\n"
"UV.x = (a_UV - UV.y) / 2.;\n"
"UV.y = 2. * UV.y - 1.;  // -1. or 1.\n"
"UV.x = 2. * UV.x - 1.;  // -1. or 1.\n"
"float swapPoints = step(0., UV.x);\n"
"vec3 b_Vertex = mix(a_Vertex, a_OtherVertex, swapPoints);\n"
"vec3 b_OtherVertex = mix(a_OtherVertex, a_Vertex, swapPoints);\n"
"whichEnd = swapPoints;\n"
"a_INTERPOLATE = isPicking ? 0. : a_interpolate;\n"
"COLOR = a_Color;\n"
"COLOR2 = a_Color2;\n"
"vec4 eye_pos = g_ModelViewMatrix * vec4(b_Vertex, 1.0);\n"
"vec4 pointA = g_ProjectionMatrix * g_ModelViewMatrix * vec4(b_Vertex, 1.0);\n"
"vec4 pointB = g_ProjectionMatrix * g_ModelViewMatrix * vec4(b_OtherVertex, 1.0);\n"
"pointA.xyz = pointA.xyz / abs(pointA.w);\n"
"pointB.xyz = pointB.xyz / abs(pointB.w);\n"
"pointA.w = 1.;\n"
"pointB.w = 1.;\n"
"vec2 perpAB = normalize((pointA.yx - pointB.yx) * inv_dimensions)\n"
"* vec2(1., -1.);\n"
"float width = line_width;\n"
"#ifdef line_smooth\n"
"centerdist = UV.x * UV.y * line_width;\n"
"if (!isPicking)\n"
"width += 1.0;\n"
"else\n"
"width = max(1.0, width);\n"
"#else\n"
"width = max(1.0, width);\n"
"#endif\n"
"pointA.xy += width * perpAB * UV.y * inv_dimensions;\n"
"fog = (g_Fog_end + eye_pos.z) * g_Fog_scale;\n"
"gl_Position = pointA;\n"
"bgTextureLookup = (gl_Position.xy / gl_Position.w) / 2.0 + 0.5;\n"
"}\n"
,
"volume.fs", ""
"uniform sampler3D volumeTex;\n"
"uniform sampler2D colorTex2D;\n"
"uniform sampler1D colorTex1D;\n"
"uniform float volumeScale;\n"
"uniform float volumeBias;\n"
"uniform float sliceDist;\n"
"uniform mat4 TexMatrix;\n"
"uniform vec3 eyeposM;\n"
"uniform vec3 vDirM;\n"
"uniform sampler3D carvemask;\n"
"uniform bool carvemaskFlag;\n"
"varying vec3 vertexM;\n"
"varying float fog;\n"
"varying vec2 bgTextureLookup;\n"
"#include anaglyph_header.fs\n"
"#include compute_fog_color.fs\n"
"bool iscarvemasked(vec3 t) {\n"
"return carvemaskFlag && texture3D(carvemask, t).r > 0.5;\n"
"}\n"
"void main()\n"
"{\n"
"#ifdef volume_mode\n"
"#else // volume_mode\n"
"if (iscarvemasked(gl_TexCoord[0].xyz))\n"
"discard;\n"
"float v = texture3D(volumeTex, gl_TexCoord[0].xyz).r;\n"
"v = v * volumeScale + volumeBias;\n"
"if (v < 0. || v > 1.) discard;\n"
"vec4 color = texture1D(colorTex1D, v);\n"
"#endif // volume_mode\n"
"if (color.a == 0.0)\n"
"discard;\n"
"color = ApplyColorEffects(color, gl_FragCoord.z);\n"
"gl_FragColor = ApplyFog(color, fog);\n"
"PostLightingEffects();\n"
"}\n"
,
"volume.vs", ""
"#include webgl_header.vs\n"
"uniform vec3 slabTexOffset;\n"
"varying vec3 vertexM;\n"
"varying float fog;\n"
"varying vec2 bgTextureLookup;\n"
"void main()\n"
"{\n"
"vec4 vertex = g_ModelViewMatrix * gl_Vertex;\n"
"gl_TexCoord[0] = gl_MultiTexCoord0;\n"
"#ifdef volume_mode\n"
"#endif // volume_mode\n"
"gl_Position = g_ProjectionMatrix * g_ModelViewMatrix * gl_Vertex;\n"
"fog = (g_Fog_end + vertex.z) * g_Fog_scale;\n"
"bgTextureLookup = (gl_Position.xy/gl_Position.w) / 2.0 + 0.5;\n"
"}\n"
,
"vrcontroller.fs", ""
"uniform sampler2D diffuse;\n"
"varying vec2 texcoords;\n"
"void main() {\n"
"gl_FragColor = texture2D(diffuse, texcoords);\n"
"}\n"
,
"vrcontroller.vs", ""
"attribute vec3 position;\n"
"attribute vec2 texcoords_in;\n"
"varying vec2 texcoords;\n"
"void main() {\n"
"texcoords = texcoords_in;\n"
"gl_Position = gl_ModelViewProjectionMatrix * vec4(position, 1);\n"
"}\n"
,
"webgl_header.fs", ""
"#ifndef ONE_DRAW_BUFFER\n"
"#ifdef PURE_OPENGL_ES_2\n"
"#extension GL_EXT_draw_buffers : require\n"
"#endif\n"
"#endif\n"
"#ifdef PYMOL_WEBGL_IOS\n"
"precision highp float;\n"
"#endif\n"
,
"webgl_header.vs", ""
"uniform mat3 g_NormalMatrix;\n"
"uniform mat4 g_ModelViewMatrix;\n"
"uniform mat4 g_ProjectionMatrix;\n"
"#ifdef PYMOL_WEBGL_IOS\n"
"uniform float g_PointSize;\n"
"#endif\n"
"uniform float g_Fog_end;\n"
"uniform float g_Fog_scale;\n"
,
0};
const char * _include_deps[] = {
"webgl_header.fs", "bg.fs", "connector.fs", "cylinder.fs", "default.fs", "indicator.fs", "label.fs", "line.fs", "sphere.fs", "surface.fs", "trilines.fs", 0,
"anaglyph_header.fs", "bg.fs", "connector.fs", "cylinder.fs", "default.fs", "indicator.fs", "label.fs", "line.fs", "sphere.fs", "surface.fs", "trilines.fs", "volume.fs", 0,
"compute_fog_color.fs", "bg.fs", "connector.fs", "cylinder.fs", "default.fs", "label.fs", "line.fs", "sphere.fs", "surface.fs", "trilines.fs", "volume.fs", 0,
"CallComputeColorForLight", "compute_color_for_light.fs", 0,
"connector.shared", "connector.gs", "connector.vs", 0,
"webgl_header.vs", "connector.shared", "cylinder.vs", "default.vs", "indicator.vs", "label.vs", "line.vs", "ramp.vs", "sphere.vs", "surface.vs", "trilines.vs", "volume.vs", 0,
"compute_color_for_light.fs", "cylinder.fs", "default.fs", "line.fs", "sphere.fs", "surface.fs", 0,
0};
const char * _ifdef_deps[] = {
"ANAGLYPH", "anaglyph_header.fs", "oit.fs", "ramp.fs", "screen.fs", 0,
"NO_ORDER_TRANSP", "anaglyph_header.fs", "label.fs", 0,
"ONE_DRAW_BUFFER", "anaglyph_header.fs", "webgl_header.fs", 0,
"ray_trace_mode_3", "anaglyph_header.fs", 0,
"chromadepth_postlighting", "anaglyph_header.fs", 0,
"transparency_mode_3", "anaglyph_header.fs", 0,
"chromadepth", "anaglyph_header.fs", 0,
"ortho", "anaglyph_header.fs", "cylinder.fs", "sphere.fs", "sphere.vs", 0,
"PURE_OPENGL_ES_2", "bg.fs", "bg.vs", "default.fs", "default.vs", "label.fs", "label.vs", "ramp.fs", "screen.fs", "screen.vs", "surface.fs", "surface.vs", "trilines.fs", "webgl_header.fs", 0,
"precomputed_lighting", "compute_color_for_light.fs", 0,
"ray_transparency_oblique", "compute_color_for_light.fs", 0,
"bg_image_mode_solid", "compute_fog_color.fs", 0,
"bg_image_mode_1_or_3", "compute_fog_color.fs", 0,
"bg_image_mode_2_or_3", "compute_fog_color.fs", 0,
"depth_cue", "compute_fog_color.fs", "label.vs", 0,
"use_geometry_shaders", "connector.fs", "connector.vs", 0,
"line_smooth", "connector.fs", "trilines.fs", "trilines.vs", 0,
"PYMOL_WEBGL", "copy.fs", "copy.vs", "oit.fs", "oit.vs", 0,
"PYMOL_WEBGL_IOS", "cylinder.fs", "default.vs", "indicator.fs", "indicator.vs", "line.vs", "sphere.fs", "sphere.vs", "surface.vs", "webgl_header.fs", "webgl_header.vs", 0,
"PYMOL_IOS", "label.fs", 0,
"openvr_enabled", "label.vs", 0,
"gl_VertexID_enabled", "line.vs", 0,
"GLEW_VERSION_3_0", "oit.fs", 0,
"volume_mode", "volume.fs", "volume.vs", 0,
0};
