#include "vtkABI.h"
#include "vtkClientServerInterpreter.h"

extern "C" { void vtkBlockSortHelper_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkDirectionEncoder_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkEncodedGradientEstimator_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkEncodedGradientShader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkFiniteDifferenceGradientEstimator_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkFixedPointRayCastImage_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkFixedPointVolumeRayCastCompositeGOHelper_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkFixedPointVolumeRayCastCompositeGOShadeHelper_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkFixedPointVolumeRayCastCompositeHelper_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkFixedPointVolumeRayCastCompositeShadeHelper_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkFixedPointVolumeRayCastHelper_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkFixedPointVolumeRayCastMapper_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkFixedPointVolumeRayCastMIPHelper_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkGPUVolumeRayCastMapper_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkMultiVolume_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkOSPRayVolumeInterface_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkAnariVolumeInterface_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkProjectedTetrahedraMapper_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkRayCastImageDisplayHelper_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkRecursiveSphereDirectionEncoder_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkSphericalDirectionEncoder_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkUnstructuredGridBunykRayCastFunction_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkUnstructuredGridHomogeneousRayIntegrator_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkUnstructuredGridLinearRayIntegrator_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkUnstructuredGridPartialPreIntegration_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkUnstructuredGridPreIntegration_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkUnstructuredGridVolumeMapper_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkUnstructuredGridVolumeRayCastFunction_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkUnstructuredGridVolumeRayCastIterator_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkUnstructuredGridVolumeRayCastMapper_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkUnstructuredGridVolumeRayIntegrator_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkUnstructuredGridVolumeZSweepMapper_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkVolumeMapper_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkVolumeOutlineSource_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkVolumePicker_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkVolumeRayCastSpaceLeapingImageFilter_Init(vtkClientServerInterpreter*); }

extern "C" VTK_ABI_EXPORT void vtkRenderingVolumeCS_Initialize(vtkClientServerInterpreter* csi)
{
  (void)csi;
  vtkBlockSortHelper_Init(csi);
  vtkDirectionEncoder_Init(csi);
  vtkEncodedGradientEstimator_Init(csi);
  vtkEncodedGradientShader_Init(csi);
  vtkFiniteDifferenceGradientEstimator_Init(csi);
  vtkFixedPointRayCastImage_Init(csi);
  vtkFixedPointVolumeRayCastCompositeGOHelper_Init(csi);
  vtkFixedPointVolumeRayCastCompositeGOShadeHelper_Init(csi);
  vtkFixedPointVolumeRayCastCompositeHelper_Init(csi);
  vtkFixedPointVolumeRayCastCompositeShadeHelper_Init(csi);
  vtkFixedPointVolumeRayCastHelper_Init(csi);
  vtkFixedPointVolumeRayCastMapper_Init(csi);
  vtkFixedPointVolumeRayCastMIPHelper_Init(csi);
  vtkGPUVolumeRayCastMapper_Init(csi);
  vtkMultiVolume_Init(csi);
  vtkOSPRayVolumeInterface_Init(csi);
  vtkAnariVolumeInterface_Init(csi);
  vtkProjectedTetrahedraMapper_Init(csi);
  vtkRayCastImageDisplayHelper_Init(csi);
  vtkRecursiveSphereDirectionEncoder_Init(csi);
  vtkSphericalDirectionEncoder_Init(csi);
  vtkUnstructuredGridBunykRayCastFunction_Init(csi);
  vtkUnstructuredGridHomogeneousRayIntegrator_Init(csi);
  vtkUnstructuredGridLinearRayIntegrator_Init(csi);
  vtkUnstructuredGridPartialPreIntegration_Init(csi);
  vtkUnstructuredGridPreIntegration_Init(csi);
  vtkUnstructuredGridVolumeMapper_Init(csi);
  vtkUnstructuredGridVolumeRayCastFunction_Init(csi);
  vtkUnstructuredGridVolumeRayCastIterator_Init(csi);
  vtkUnstructuredGridVolumeRayCastMapper_Init(csi);
  vtkUnstructuredGridVolumeRayIntegrator_Init(csi);
  vtkUnstructuredGridVolumeZSweepMapper_Init(csi);
  vtkVolumeMapper_Init(csi);
  vtkVolumeOutlineSource_Init(csi);
  vtkVolumePicker_Init(csi);
  vtkVolumeRayCastSpaceLeapingImageFilter_Init(csi);
}
