// python wrapper for vtkMPIMToNSocketConnection
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkMPIMToNSocketConnection.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkMPIMToNSocketConnection(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkMPIMToNSocketConnection_ClassNew(); }


static PyObject *
PyvtkMPIMToNSocketConnection_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkMPIMToNSocketConnection::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMPIMToNSocketConnection_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMPIMToNSocketConnection *op = static_cast<vtkMPIMToNSocketConnection *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkMPIMToNSocketConnection::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMPIMToNSocketConnection_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkMPIMToNSocketConnection *tempr = vtkMPIMToNSocketConnection::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMPIMToNSocketConnection_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMPIMToNSocketConnection *op = static_cast<vtkMPIMToNSocketConnection *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkMPIMToNSocketConnection *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkMPIMToNSocketConnection::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMPIMToNSocketConnection_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkMPIMToNSocketConnection::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMPIMToNSocketConnection_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMPIMToNSocketConnection *op = static_cast<vtkMPIMToNSocketConnection *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkMPIMToNSocketConnection::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMPIMToNSocketConnection_Initialize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Initialize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMPIMToNSocketConnection *op = static_cast<vtkMPIMToNSocketConnection *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->Initialize(temp0);
    }
    else
    {
      op->vtkMPIMToNSocketConnection::Initialize(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkMPIMToNSocketConnection_ConnectMtoN(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ConnectMtoN");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMPIMToNSocketConnection *op = static_cast<vtkMPIMToNSocketConnection *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ConnectMtoN();
    }
    else
    {
      op->vtkMPIMToNSocketConnection::ConnectMtoN();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkMPIMToNSocketConnection_SetNumberOfConnections(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNumberOfConnections");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMPIMToNSocketConnection *op = static_cast<vtkMPIMToNSocketConnection *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetNumberOfConnections(temp0);
    }
    else
    {
      op->vtkMPIMToNSocketConnection::SetNumberOfConnections(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkMPIMToNSocketConnection_GetNumberOfConnections(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfConnections");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMPIMToNSocketConnection *op = static_cast<vtkMPIMToNSocketConnection *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetNumberOfConnections() :
      op->vtkMPIMToNSocketConnection::GetNumberOfConnections());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMPIMToNSocketConnection_SetPortInformation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPortInformation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMPIMToNSocketConnection *op = static_cast<vtkMPIMToNSocketConnection *>(vp);

  unsigned int temp0;
  int temp1;
  const char *temp2 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetPortInformation(temp0, temp1, temp2);
    }
    else
    {
      op->vtkMPIMToNSocketConnection::SetPortInformation(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkMPIMToNSocketConnection_GetSocketCommunicator(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSocketCommunicator");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMPIMToNSocketConnection *op = static_cast<vtkMPIMToNSocketConnection *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkSocketCommunicator *tempr = (ap.IsBound() ?
      op->GetSocketCommunicator() :
      op->vtkMPIMToNSocketConnection::GetSocketCommunicator());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMPIMToNSocketConnection_GetPortInformation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPortInformation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMPIMToNSocketConnection *op = static_cast<vtkMPIMToNSocketConnection *>(vp);

  vtkMPIMToNSocketConnectionPortInformation *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkMPIMToNSocketConnectionPortInformation"))
  {
    if (ap.IsBound())
    {
      op->GetPortInformation(temp0);
    }
    else
    {
      op->vtkMPIMToNSocketConnection::GetPortInformation(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkMPIMToNSocketConnection_GetPortNumber(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPortNumber");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMPIMToNSocketConnection *op = static_cast<vtkMPIMToNSocketConnection *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetPortNumber() :
      op->vtkMPIMToNSocketConnection::GetPortNumber());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkMPIMToNSocketConnection_Methods[] = {
  {"IsTypeOf", PyvtkMPIMToNSocketConnection_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkMPIMToNSocketConnection_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkMPIMToNSocketConnection_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkMPIMToNSocketConnection\nC++: static vtkMPIMToNSocketConnection *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkMPIMToNSocketConnection_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkMPIMToNSocketConnection\nC++: vtkMPIMToNSocketConnection *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkMPIMToNSocketConnection_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkMPIMToNSocketConnection_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"Initialize", PyvtkMPIMToNSocketConnection_Initialize, METH_VARARGS,
   "Initialize(self, waiting_process_type:int) -> None\nC++: void Initialize(int waiting_process_type)\n\n"},
  {"ConnectMtoN", PyvtkMPIMToNSocketConnection_ConnectMtoN, METH_VARARGS,
   "ConnectMtoN(self) -> None\nC++: void ConnectMtoN()\n\nSetup  the connection.\n"},
  {"SetNumberOfConnections", PyvtkMPIMToNSocketConnection_SetNumberOfConnections, METH_VARARGS,
   "SetNumberOfConnections(self, __a:int) -> None\nC++: void SetNumberOfConnections(int)\n\nSet the number of connections to be made.\n"},
  {"GetNumberOfConnections", PyvtkMPIMToNSocketConnection_GetNumberOfConnections, METH_VARARGS,
   "GetNumberOfConnections(self) -> int\nC++: virtual int GetNumberOfConnections()\n\n"},
  {"SetPortInformation", PyvtkMPIMToNSocketConnection_SetPortInformation, METH_VARARGS,
   "SetPortInformation(self, processNumber:int, portNumber:int,\n    hostName:str) -> None\nC++: void SetPortInformation(unsigned int processNumber,\n    int portNumber, const char *hostName)\n\nSet up information about the remote connection.\n"},
  {"GetSocketCommunicator", PyvtkMPIMToNSocketConnection_GetSocketCommunicator, METH_VARARGS,
   "GetSocketCommunicator(self) -> vtkSocketCommunicator\nC++: virtual vtkSocketCommunicator *GetSocketCommunicator()\n\nReturn the socket communicator for this process.\n"},
  {"GetPortInformation", PyvtkMPIMToNSocketConnection_GetPortInformation, METH_VARARGS,
   "GetPortInformation(self,\n    __a:vtkMPIMToNSocketConnectionPortInformation) -> None\nC++: void GetPortInformation(\n    vtkMPIMToNSocketConnectionPortInformation *)\n\nFill the port information values into the port information\nobject.\n"},
  {"GetPortNumber", PyvtkMPIMToNSocketConnection_GetPortNumber, METH_VARARGS,
   "GetPortNumber(self) -> int\nC++: virtual int GetPortNumber()\n\nSet port to use, if the value is 0, then the system will pick the\nport.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkMPIMToNSocketConnection_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("port_number"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkMPIMToNSocketConnection_GetPortNumber(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetPortNumber\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("socket_communicator"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkMPIMToNSocketConnection_GetSocketCommunicator(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetSocketCommunicator\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_connections"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkMPIMToNSocketConnection_GetNumberOfConnections(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkMPIMToNSocketConnection_SetNumberOfConnections(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkMPIMToNSocketConnection_SetNumberOfConnections(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetNumberOfConnections/SetNumberOfConnections\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkMPIMToNSocketConnection_Doc =
  "vtkMPIMToNSocketConnection - class to create socket connections\nbetween two servers\n\n"
  "Superclass: vtkObject\n\n"
  "class used to create socket connections between the render and data\n"
  "servers.  This used for example when data is on a super computer\n"
  "(SGI, IBM, etc) and Rendering on a Linux cluster with hardware\n"
  "graphics support. This problem is known as the \"M\" to \"N\" geometry\n"
  "load redistribution problem.  It addresses the common case where\n"
  "there is a significante mismatch in the size of large parallel\n"
  "computing resources and the often smaller parallel\n"
  "hardward-accelerated rendering resources. The larger number of\n"
  "processors on the compute servers are called M, and the smaller\n"
  "number of rendering processors are call N.  This class is used to\n"
  "create N vtkSocketCommunicator's that connect the first N of the M\n"
  "processes on the data server to the N processes on the render server.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkMPIMToNSocketConnection_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingCore.vtkMPIMToNSocketConnection", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkMPIMToNSocketConnection_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkMPIMToNSocketConnection_StaticNew()
{
  return vtkMPIMToNSocketConnection::New();
}

PyObject *PyvtkMPIMToNSocketConnection_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkMPIMToNSocketConnection_Type, PyvtkMPIMToNSocketConnection_Methods,
    "vtkMPIMToNSocketConnection",
 &PyvtkMPIMToNSocketConnection_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkObject");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkMPIMToNSocketConnection_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkMPIMToNSocketConnection(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkMPIMToNSocketConnection_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkMPIMToNSocketConnection", o) != 0)
  {
    Py_DECREF(o);
  }

}

