#include "vtkABI.h"
#include "vtkClientServerInterpreter.h"

extern "C" { void vtkmConfigFilters_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkmFilterOverrides_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkmAverageToCells_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkmAverageToPoints_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkmCleanGrid_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkmClip_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkmContour_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkmCoordinateSystemTransform_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkmExternalFaces_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkmExtractVOI_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkmGradient_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkmHistogram_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkmImageConnectivity_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkmLevelOfDetail_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkmNDHistogram_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkmPointElevation_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkmPointTransform_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkmPolyDataNormals_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkmProbe_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkmSlice_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkmThreshold_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkmTriangleMeshPointNormals_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkmWarpScalar_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkmWarpVector_Init(vtkClientServerInterpreter*); }

extern "C" VTK_ABI_EXPORT void vtkAcceleratorsVTKmFiltersCS_Initialize(vtkClientServerInterpreter* csi)
{
  (void)csi;
  vtkmConfigFilters_Init(csi);
  vtkmFilterOverrides_Init(csi);
  vtkmAverageToCells_Init(csi);
  vtkmAverageToPoints_Init(csi);
  vtkmCleanGrid_Init(csi);
  vtkmClip_Init(csi);
  vtkmContour_Init(csi);
  vtkmCoordinateSystemTransform_Init(csi);
  vtkmExternalFaces_Init(csi);
  vtkmExtractVOI_Init(csi);
  vtkmGradient_Init(csi);
  vtkmHistogram_Init(csi);
  vtkmImageConnectivity_Init(csi);
  vtkmLevelOfDetail_Init(csi);
  vtkmNDHistogram_Init(csi);
  vtkmPointElevation_Init(csi);
  vtkmPointTransform_Init(csi);
  vtkmPolyDataNormals_Init(csi);
  vtkmProbe_Init(csi);
  vtkmSlice_Init(csi);
  vtkmThreshold_Init(csi);
  vtkmTriangleMeshPointNormals_Init(csi);
  vtkmWarpScalar_Init(csi);
  vtkmWarpVector_Init(csi);
}
